/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.util.ImageUtilities;

abstract class BreadCrumbsNavigator {
    private static final Icon ICON_SEPARATOR = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(BreadCrumbsNavigator.class.getPackage().getName().replace('.', '/') + "/separator.png"), (boolean)true));
    private static final Icon ICON_PIN = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(BreadCrumbsNavigator.class.getPackage().getName().replace('.', '/') + "/pin.png"), (boolean)true));
    private static final Icon ICON_PIN_SELECTED = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(BreadCrumbsNavigator.class.getPackage().getName().replace('.', '/') + "/pin_selected.png"), (boolean)true));
    private JComponent component;

    BreadCrumbsNavigator() {
    }

    abstract void nodeClicked(HeapViewerNode var1);

    abstract void nodePinned(HeapViewerNode var1);

    abstract void openNode(HeapViewerNode var1);

    abstract HeapViewerRenderer getRenderer(HeapViewerNode var1);

    abstract HeapViewerNodeAction.Actions getNodeActions(HeapViewerNode var1);

    Component getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    void setNode(HeapViewerNode node, HeapViewerNode pinnedNode, HeapViewerNode root, String viewName) {
        if (this.component == null) {
            this.init();
        }
        this.setNodeImpl(node, pinnedNode, root, viewName);
    }

    private void setNodeImpl(HeapViewerNode node, HeapViewerNode pinnedNode, HeapViewerNode root, String viewName) {
        this.component.removeAll();
        HeapViewerNode visitedPinnedNode = null;
        while (node != null && !(node instanceof RootNode)) {
            boolean beforePinnedNode;
            this.component.add((Component)BreadCrumbsNavigator.createSeparator(), 0);
            final HeapViewerNode nodeF = node;
            if (!(viewName == null && node == root || node.isLeaf())) {
                this.component.add(Box.createHorizontalStrut(2), 0);
                PinButton pb = new PinButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        BreadCrumbsNavigator.this.nodePinned(this.isSelected() ? nodeF : null);
                    }
                };
                pb.setSelected(((Object)((Object)node)).equals((Object)pinnedNode));
                pb.setToolTipText(pb.isSelected() ? Bundle.BreadCrumbsNavigator_ResetPin() : Bundle.BreadCrumbsNavigator_Pin());
                if (pb.isSelected()) {
                    visitedPinnedNode = pinnedNode;
                }
                this.component.add((Component)pb, 0);
                this.component.add(Box.createHorizontalStrut(3), 0);
            }
            HeapViewerRenderer renderer = this.getRenderer(node);
            LinkButton lb = new LinkButton(renderer.getShortName(), renderer.getIcon()){

                @Override
                protected void clicked() {
                    BreadCrumbsNavigator.this.nodeClicked(nodeF);
                }

                @Override
                protected void middleClicked(MouseEvent e) {
                    HeapViewerNodeAction.Actions nodeActions = BreadCrumbsNavigator.this.getNodeActions(nodeF);
                    ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
                    nodeActions.performMiddleButtonAction(ae);
                }

                @Override
                protected void populatePopup(JPopupMenu popup) {
                    HeapViewerNodeAction.Actions nodeActions = BreadCrumbsNavigator.this.getNodeActions(nodeF);
                    nodeActions.populatePopup(popup);
                }
            };
            boolean bl = beforePinnedNode = visitedPinnedNode != null && visitedPinnedNode != node;
            if (beforePinnedNode) {
                lb.setForeground(UIUtils.getDisabledLineColor());
            }
            lb.setToolTipText(beforePinnedNode ? Bundle.BreadCrumbsNavigator_ResetPinSelectNode(renderer.toString()) : Bundle.BreadCrumbsNavigator_SelectNode(renderer.toString()));
            lb.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        BreadCrumbsNavigator.this.openNode(nodeF);
                    }
                }
            });
            this.component.add((Component)lb, 0);
            node = node.getParent();
        }
        if (viewName != null) {
            this.component.add((Component)BreadCrumbsNavigator.createSeparator(), 0);
            LinkButton lb = new LinkButton(viewName){

                @Override
                protected void clicked() {
                    BreadCrumbsNavigator.this.nodeClicked(null);
                }
            };
            if (visitedPinnedNode != null) {
                lb.setForeground(UIUtils.getDisabledLineColor());
            }
            lb.setToolTipText(Bundle.BreadCrumbsNavigator_ResetView());
            this.component.add((Component)lb, 0);
            this.component.add(Box.createHorizontalStrut(4), 0);
        }
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    private static JComponent createSeparator() {
        JLabel sepL = new JLabel(ICON_SEPARATOR);
        sepL.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        return sepL;
    }

    private void init() {
        final int refHeight = new LinkButton((String)"XXX", (Icon)Icons.getIcon((String)"LanguageIcons.Class")).getPreferredSize().height + 3;
        this.component = new JPanel(null){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = refHeight;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = refHeight;
                return dim;
            }
        };
        this.component.setLayout(new BoxLayout(this.component, 2));
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
    }

    private static class PinButton
    extends JToggleButton {
        PinButton() {
            super(ICON_PIN);
            this.setSelectedIcon(ICON_PIN_SELECTED);
            this.setRolloverIcon(ICON_PIN_SELECTED);
            this.setPressedIcon(ICON_PIN_SELECTED);
            this.setOpaque(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setMargin(new Insets(1, 2, 1, 2));
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

