/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryReleases;
import cc.arduino.contributions.libraries.LibraryInstaller;
import cc.arduino.contributions.libraries.LibraryTypeComparator;
import cc.arduino.contributions.libraries.ui.ContributedLibraryTableCellEditor;
import cc.arduino.contributions.libraries.ui.ContributedLibraryTableCellRenderer;
import cc.arduino.contributions.libraries.ui.DropdownAllLibraries;
import cc.arduino.contributions.libraries.ui.DropdownInstalledLibraryItem;
import cc.arduino.contributions.libraries.ui.DropdownLibraryOfCategoryItem;
import cc.arduino.contributions.libraries.ui.DropdownLibraryOfTypeItem;
import cc.arduino.contributions.libraries.ui.DropdownUpdatableLibrariesItem;
import cc.arduino.contributions.libraries.ui.LibrariesIndexTableModel;
import cc.arduino.contributions.libraries.ui.MultiLibraryInstallDialog;
import cc.arduino.contributions.ui.DropdownItem;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import cc.arduino.contributions.ui.InstallerJDialog;
import cc.arduino.contributions.ui.InstallerJDialogUncaughtExceptionHandler;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.Progress;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import processing.app.BaseNoGui;
import processing.app.I18n;

public class LibraryManagerUI
extends InstallerJDialog<ContributedLibraryReleases> {
    private final JComboBox typeChooser;
    private final LibraryInstaller installer;
    protected final ActionListener typeChooserActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            DropdownItem selected = (DropdownItem)LibraryManagerUI.this.typeChooser.getSelectedItem();
            LibraryManagerUI.this.previousRowAtPoint = -1;
            if (selected != null && LibraryManagerUI.this.extraFilter != selected.getFilterPredicate()) {
                LibraryManagerUI.this.extraFilter = selected.getFilterPredicate();
                if (LibraryManagerUI.this.contribTable.getCellEditor() != null) {
                    LibraryManagerUI.this.contribTable.getCellEditor().stopCellEditing();
                }
                LibraryManagerUI.this.updateIndexFilter(LibraryManagerUI.this.filters, LibraryManagerUI.this.categoryFilter.and(LibraryManagerUI.this.extraFilter));
            }
        }
    };
    private Collection<String> oldCategories = new ArrayList<String>();
    private Collection<String> oldTypes = new ArrayList<String>();
    private Thread installerThread = null;

    @Override
    protected FilteredAbstractTableModel createContribModel() {
        return new LibrariesIndexTableModel();
    }

    private LibrariesIndexTableModel getContribModel() {
        return (LibrariesIndexTableModel)this.contribModel;
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new ContributedLibraryTableCellRenderer();
    }

    @Override
    protected InstallerTableCell createCellEditor() {
        return new ContributedLibraryTableCellEditor(){

            @Override
            protected void onInstall(ContributedLibrary selectedLibrary, Optional<ContributedLibrary> mayInstalledLibrary) {
                if (mayInstalledLibrary.isPresent() && selectedLibrary.isIDEBuiltIn()) {
                    LibraryManagerUI.this.onRemovePressed(mayInstalledLibrary.get());
                } else {
                    LibraryManagerUI.this.onInstallPressed(selectedLibrary);
                }
            }

            @Override
            protected void onRemove(ContributedLibrary library) {
                LibraryManagerUI.this.onRemovePressed(library);
            }
        };
    }

    public LibraryManagerUI(Frame parent, LibraryInstaller installer) {
        super(parent, I18n.tr((String)"Library Manager"), Dialog.ModalityType.APPLICATION_MODAL, I18n.tr((String)"Unable to reach Arduino.cc due to possible network issues."));
        this.installer = installer;
        this.filtersContainer.add((Component)new JLabel(I18n.tr((String)"Topic")), 1);
        this.filtersContainer.remove(2);
        this.typeChooser = new JComboBox();
        this.typeChooser.setMaximumRowCount(20);
        this.typeChooser.setEnabled(false);
        this.filtersContainer.add(Box.createHorizontalStrut(5), 0);
        this.filtersContainer.add((Component)new JLabel(I18n.tr((String)"Type")), 1);
        this.filtersContainer.add(Box.createHorizontalStrut(5), 2);
        this.filtersContainer.add((Component)this.typeChooser, 3);
    }

    public void updateUI() {
        List categories = BaseNoGui.librariesIndexer.getIndex().getCategories();
        LinkedList<String> types = new LinkedList<String>(BaseNoGui.librariesIndexer.getIndex().getTypes());
        Collections.sort(types, new LibraryTypeComparator());
        if (categories.equals(this.oldCategories) && types.equals(this.oldTypes)) {
            return;
        }
        this.oldCategories = categories;
        this.oldTypes = types;
        this.categoryFilter = x -> true;
        this.categoryChooser.removeActionListener(this.categoryChooserActionListener);
        this.categoryChooser.removeAllItems();
        this.categoryChooser.addItem(new DropdownAllLibraries());
        for (String category : categories) {
            this.categoryChooser.addItem(new DropdownLibraryOfCategoryItem(category));
        }
        this.categoryChooser.setEnabled(this.categoryChooser.getItemCount() > 1);
        this.categoryChooser.addActionListener(this.categoryChooserActionListener);
        this.categoryChooser.setSelectedIndex(0);
        this.extraFilter = x -> true;
        this.typeChooser.removeActionListener(this.typeChooserActionListener);
        this.typeChooser.removeAllItems();
        this.typeChooser.addItem(new DropdownAllLibraries());
        this.typeChooser.addItem(new DropdownUpdatableLibrariesItem());
        this.typeChooser.addItem(new DropdownInstalledLibraryItem());
        for (String type : types) {
            this.typeChooser.addItem(new DropdownLibraryOfTypeItem(type));
        }
        this.typeChooser.setEnabled(this.typeChooser.getItemCount() > 1);
        this.typeChooser.addActionListener(this.typeChooserActionListener);
        this.typeChooser.setSelectedIndex(0);
        this.filterField.setEnabled(this.contribModel.getRowCount() > 0);
    }

    @Override
    public void selectDropdownItemByClassName(String dropdownItem) {
        this.selectDropdownItemByClassName(this.typeChooser, dropdownItem);
    }

    public void setProgress(Progress progress) {
        this.progressBar.setValue(progress);
    }

    @Override
    protected void onCancelPressed() {
        super.onUpdatePressed();
        if (this.installerThread != null) {
            this.installerThread.interrupt();
        }
    }

    @Override
    protected void onUpdatePressed() {
        super.onUpdatePressed();
        this.installerThread = new Thread(() -> {
            try {
                this.setProgressVisible(true, "");
                this.installer.updateIndex(this::setProgress);
                this.onIndexesUpdated();
                if (this.contribTable.getCellEditor() != null) {
                    this.contribTable.getCellEditor().stopCellEditing();
                }
                this.getContribModel().update();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setProgressVisible(false, "");
            }
        });
        this.installerThread.setName("LibraryManager Update Thread");
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onInstallPressed(ContributedLibrary lib) {
        MultiLibraryInstallDialog.Result installDeps;
        List deps = BaseNoGui.librariesIndexer.getIndex().resolveDependeciesOf(lib);
        boolean depsInstalled = deps.stream().allMatch(l -> l.getInstalledLibrary().isPresent() || l.getName().equals(lib.getName()));
        if (!depsInstalled) {
            MultiLibraryInstallDialog dialog = new MultiLibraryInstallDialog((Window)this, lib, deps);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            installDeps = dialog.getInstallDepsResult();
            if (installDeps == MultiLibraryInstallDialog.Result.CANCEL) {
                return;
            }
        } else {
            installDeps = MultiLibraryInstallDialog.Result.NONE;
        }
        this.clearErrorMessage();
        this.installerThread = new Thread(() -> {
            try {
                this.setProgressVisible(true, I18n.tr((String)"Installing..."));
                if (installDeps == MultiLibraryInstallDialog.Result.ALL) {
                    this.installer.install(deps, this::setProgress);
                } else {
                    this.installer.install(lib, this::setProgress);
                }
                this.onIndexesUpdated();
                if (this.contribTable.getCellEditor() != null) {
                    this.contribTable.getCellEditor().stopCellEditing();
                }
                this.getContribModel().update();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setProgressVisible(false, "");
            }
        });
        this.installerThread.setName("LibraryManager Installer Thread");
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onRemovePressed(ContributedLibrary lib) {
        int chosenOption;
        boolean managedByIndex = BaseNoGui.librariesIndexer.getIndex().getLibraries().contains(lib);
        if (!managedByIndex && (chosenOption = JOptionPane.showConfirmDialog(this, I18n.tr((String)"This library is not listed on Library Manager. You won't be able to reinstall it from here.\nAre you sure you want to delete it?"), I18n.tr((String)"Please confirm library deletion"), 0, 3)) != 0) {
            return;
        }
        this.clearErrorMessage();
        this.installerThread = new Thread(() -> {
            try {
                this.setProgressVisible(true, I18n.tr((String)"Removing..."));
                this.installer.remove(lib, this::setProgress);
                this.onIndexesUpdated();
                if (this.contribTable.getCellEditor() != null) {
                    this.contribTable.getCellEditor().stopCellEditing();
                }
                this.getContribModel().update();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setProgressVisible(false, "");
            }
        });
        this.installerThread.setName("LibraryManager Remove Thread");
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    protected void onIndexesUpdated() throws Exception {
    }
}

