/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.resource.ClasspathSupport;
import java.io.File;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;

public class FeaturePath {
    private FeaturePath() {
    }

    public static URI parse(String featureIdentifier) {
        Objects.requireNonNull(featureIdentifier, "featureIdentifier may not be null");
        if (featureIdentifier.isEmpty()) {
            throw new IllegalArgumentException("featureIdentifier may not be empty");
        }
        if ("classpath:".equals(featureIdentifier)) {
            return ClasspathSupport.rootPackageUri();
        }
        if (FeaturePath.nonStandardPathSeparatorInUse(featureIdentifier)) {
            String standardized = FeaturePath.replaceNonStandardPathSeparator(featureIdentifier);
            return FeaturePath.parseAssumeFileScheme(standardized);
        }
        if (FeaturePath.isWindowsOS() && FeaturePath.pathContainsWindowsDrivePattern(featureIdentifier)) {
            return FeaturePath.parseAssumeFileScheme(featureIdentifier);
        }
        if (FeaturePath.probablyURI(featureIdentifier)) {
            return FeaturePath.parseProbableURI(featureIdentifier);
        }
        return FeaturePath.parseAssumeFileScheme(featureIdentifier);
    }

    private static boolean nonStandardPathSeparatorInUse(String featureIdentifier) {
        return File.separatorChar != '/' && featureIdentifier.contains(File.separator);
    }

    private static String replaceNonStandardPathSeparator(String featureIdentifier) {
        return featureIdentifier.replace(File.separatorChar, '/');
    }

    private static URI parseAssumeFileScheme(String featureIdentifier) {
        File featureFile = new File(featureIdentifier);
        return featureFile.toURI();
    }

    private static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return FeaturePath.normalize(osName).contains("windows");
    }

    private static boolean pathContainsWindowsDrivePattern(String featureIdentifier) {
        return featureIdentifier.matches("^[a-zA-Z]:.*$");
    }

    private static boolean probablyURI(String featureIdentifier) {
        return featureIdentifier.matches("^[a-zA-Z+.\\-]+:.*$");
    }

    private static URI parseProbableURI(String featureIdentifier) {
        URI uri = URI.create(featureIdentifier);
        if ("file".equals(uri.getScheme())) {
            return FeaturePath.parseAssumeFileScheme(uri.getSchemeSpecificPart());
        }
        return uri;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

