/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.browser.BrowserLauncher;
import tim.prune.function.search.TrackListModel;

public abstract class GenericDownloaderFunction
extends GenericFunction
implements Runnable {
    protected JDialog _dialog = null;
    protected TrackListModel _trackListModel = null;
    protected JTable _trackTable = null;
    protected boolean _cancelled = false;
    protected String _errorMessage = null;
    protected JLabel _statusLabel = null;
    private JTextArea _descriptionBox = null;
    private JButton _loadButton = null;
    private JButton _showButton = null;

    public GenericDownloaderFunction(App app) {
        super(app);
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    GenericDownloaderFunction.this._cancelled = true;
                }
            });
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._trackListModel.clear();
        this._loadButton.setEnabled(false);
        this._showButton.setEnabled(false);
        this._cancelled = false;
        this._descriptionBox.setText("");
        this._errorMessage = null;
        new Thread(this).start();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._statusLabel = new JLabel(I18nManager.getText("confirm.running"));
        jPanel.add((Component)this._statusLabel, "North");
        this._trackListModel = new TrackListModel(this.getColumnKey(0), this.getColumnKey(1));
        this._trackTable = new JTable(this._trackListModel);
        this._trackTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.onTrackSelected();
            }
        });
        this._trackTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        if (this._trackListModel.getColumnCount() > 1) {
            this._trackTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        }
        JScrollPane jScrollPane = new JScrollPane(this._trackTable);
        jScrollPane.setPreferredSize(new Dimension(450, 200));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.pointdownload.description")) + " :");
        jPanel2.add((Component)jLabel, "North");
        this._descriptionBox = new JTextArea(5, 20);
        this._descriptionBox.setEditable(false);
        this._descriptionBox.setLineWrap(true);
        this._descriptionBox.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this._descriptionBox);
        jScrollPane2.setPreferredSize(new Dimension(400, 80));
        jPanel2.add((Component)jScrollPane2, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel2);
        jSplitPane.setResizeWeight(1.0);
        jPanel.add((Component)jSplitPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._loadButton = new JButton(I18nManager.getText("button.load"));
        this._loadButton.setEnabled(false);
        this._loadButton.addActionListener(actionEvent -> this.loadSelected());
        jPanel3.add(this._loadButton);
        this._showButton = new JButton(I18nManager.getText("button.showwebpage"));
        this._showButton.setEnabled(false);
        this._showButton.addActionListener(actionEvent -> this.showSelectedWebpage());
        jPanel3.add(this._showButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> {
            this._cancelled = true;
            this._dialog.dispose();
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void onTrackSelected() {
        int n = this._trackTable.getSelectedRowCount();
        boolean bl = false;
        if (n > 0) {
            this.setDescription(this._trackListModel.getTrack(this._trackTable.getSelectedRow()).getDescription());
            this._descriptionBox.setCaretPosition(0);
            bl = this._trackListModel.getTrack(this._trackTable.getSelectedRow()).getWebUrl() != null;
        } else {
            this._descriptionBox.setText("");
        }
        this._loadButton.setEnabled(n > 0);
        this._showButton.setEnabled(n == 1 && bl);
    }

    protected abstract String getColumnKey(int var1);

    private void setDescription(String string) {
        String string2 = string;
        if (string == null || string.length() < 2) {
            string2 = I18nManager.getText("dialog.pointdownload.nodescription");
        }
        this._descriptionBox.setText(string2);
    }

    private final void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount()) {
                String string = this._trackListModel.getTrack(n3).getLatitude();
                String string2 = this._trackListModel.getTrack(n3).getLongitude();
                if (string != null && string2 != null) {
                    DataPoint dataPoint = new DataPoint(new Latitude(string), new Longitude(string2), null);
                    dataPoint.setFieldValue(Field.WAYPT_NAME, this._trackListModel.getTrack(n3).getTrackName(), false);
                    arrayList.add(dataPoint);
                }
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            AppendRangeCmd appendRangeCmd = new AppendRangeCmd(arrayList);
            appendRangeCmd.setDescription(this.getName());
            appendRangeCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.pointsadded", arrayList.size()));
            this._app.execute(appendRangeCmd);
        }
        this._cancelled = true;
        this._dialog.dispose();
    }

    private void showSelectedWebpage() {
        int n = this._trackTable.getSelectedRow();
        if (n >= 0 && n < this._trackListModel.getRowCount()) {
            String string = this._trackListModel.getTrack(n).getWebUrl();
            BrowserLauncher.launchBrowser(string);
        }
    }
}

