/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.internal.jimage.ImageReader;
import jdk.internal.jrtfs.SystemImage;

class ExplodedImage
extends SystemImage {
    private static final String MODULES = "/modules/";
    private static final String PACKAGES = "/packages/";
    private static final int PACKAGES_LEN = "/packages/".length();
    private final FileSystem defaultFS;
    private final String separator;
    private final Map<String, PathNode> nodes = Collections.synchronizedMap(new HashMap());
    private final BasicFileAttributes modulesDirAttrs;

    ExplodedImage(Path modulesDir) throws IOException {
        this.defaultFS = FileSystems.getDefault();
        String str = this.defaultFS.getSeparator();
        this.separator = str.equals("/") ? null : str;
        this.modulesDirAttrs = Files.readAttributes(modulesDir, BasicFileAttributes.class, new LinkOption[0]);
        this.initNodes();
    }

    @Override
    public void close() throws IOException {
        this.nodes.clear();
    }

    @Override
    public byte[] getResource(ImageReader.Node node) throws IOException {
        return ((PathNode)node).getContent();
    }

    @Override
    public synchronized ImageReader.Node findNode(String str) {
        int modEndIdx;
        int pkgEndIdx;
        ImageReader.Node node = this.findModulesNode(str);
        if (node != null) {
            return node;
        }
        if (str.startsWith(PACKAGES) && (pkgEndIdx = str.indexOf(47, PACKAGES_LEN)) != -1 && (modEndIdx = str.indexOf(47, pkgEndIdx + 1)) != -1) {
            ImageReader.Node linkNode = this.nodes.get(str.substring(0, modEndIdx));
            if (linkNode == null || !linkNode.isLink()) {
                return null;
            }
            String mod = MODULES + str.substring(pkgEndIdx + 1);
            return this.findModulesNode(mod);
        }
        return null;
    }

    ImageReader.Node findModulesNode(String str) {
        PathNode node = this.nodes.get(str);
        if (node != null) {
            return node;
        }
        Path p = this.underlyingPath(str);
        if (p != null) {
            try {
                Path f;
                BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isRegularFile() && (f = p.getFileName()).toString().startsWith("_the.")) {
                    return null;
                }
                node = new PathNode(str, p, attrs);
                this.nodes.put(str, node);
                return node;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    Path underlyingPath(String str) {
        if (str.startsWith(MODULES)) {
            str = this.frontSlashToNativeSlash(str.substring("/modules".length()));
            return this.defaultFS.getPath(explodedModulesDir.toString(), str);
        }
        return null;
    }

    private String frontSlashToNativeSlash(String str) {
        return this.separator == null ? str : str.replace("/", this.separator);
    }

    private String nativeSlashToFrontSlash(String str) {
        return this.separator == null ? str : str.replace(this.separator, "/");
    }

    private String slashesToDots(String str) {
        return str.replace(this.separator != null ? this.separator : "/", ".");
    }

    private void initNodes() throws IOException {
        HashMap packageToModules = new HashMap();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(explodedModulesDir);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                String moduleName = path.getFileName().toString();
                this.findModulesNode(MODULES + moduleName);
                Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(p -> {
                    String pkgName = this.slashesToDots((p = module.relativize((Path)p)).toString());
                    if (!pkgName.isEmpty() && !pkgName.startsWith("META-INF")) {
                        ArrayList<String> moduleNames = (ArrayList<String>)packageToModules.get(pkgName);
                        if (moduleNames == null) {
                            moduleNames = new ArrayList<String>();
                            packageToModules.put(pkgName, moduleNames);
                        }
                        moduleNames.add(moduleName);
                    }
                });
            }
        }
        PathNode modulesDir = new PathNode("/modules", new ArrayList<ImageReader.Node>(this.nodes.values()));
        this.nodes.put(modulesDir.getName(), modulesDir);
        ArrayList<ImageReader.Node> packagesChildren = new ArrayList<ImageReader.Node>(packageToModules.size());
        for (Map.Entry entry : packageToModules.entrySet()) {
            String pkgName = (String)entry.getKey();
            List moduleNameList = (List)entry.getValue();
            ArrayList<ImageReader.Node> moduleLinkNodes = new ArrayList<ImageReader.Node>(moduleNameList.size());
            for (String moduleName : moduleNameList) {
                ImageReader.Node moduleNode = this.findModulesNode(MODULES + moduleName);
                PathNode linkNode = new PathNode(PACKAGES + pkgName + "/" + moduleName, moduleNode);
                this.nodes.put(linkNode.getName(), linkNode);
                moduleLinkNodes.add(linkNode);
            }
            PathNode pkgDir = new PathNode(PACKAGES + pkgName, moduleLinkNodes);
            this.nodes.put(pkgDir.getName(), pkgDir);
            packagesChildren.add(pkgDir);
        }
        PathNode packagesDir = new PathNode("/packages", packagesChildren);
        this.nodes.put(packagesDir.getName(), packagesDir);
        ArrayList<ImageReader.Node> arrayList = new ArrayList<ImageReader.Node>();
        arrayList.add(packagesDir);
        arrayList.add(modulesDir);
        PathNode root = new PathNode("/", arrayList);
        this.nodes.put(root.getName(), root);
    }

    private final class PathNode
    extends ImageReader.Node {
        private Path path;
        private PathNode link;
        private List<ImageReader.Node> children;

        PathNode(String name, Path path, BasicFileAttributes attrs) {
            super(name, attrs);
            this.path = path;
        }

        PathNode(String name, ImageReader.Node link) {
            super(name, link.getFileAttributes());
            this.link = (PathNode)link;
        }

        PathNode(String name, List<ImageReader.Node> children) {
            super(name, ExplodedImage.this.modulesDirAttrs);
            this.children = children;
        }

        @Override
        public boolean isDirectory() {
            return this.children != null || this.link == null && this.getFileAttributes().isDirectory();
        }

        @Override
        public boolean isLink() {
            return this.link != null;
        }

        @Override
        public PathNode resolveLink(boolean recursive) {
            if (this.link == null) {
                return this;
            }
            return recursive && this.link.isLink() ? this.link.resolveLink(true) : this.link;
        }

        byte[] getContent() throws IOException {
            if (!this.getFileAttributes().isRegularFile()) {
                throw new FileSystemException(this.getName() + " is not file");
            }
            return Files.readAllBytes(this.path);
        }

        @Override
        public List<ImageReader.Node> getChildren() {
            if (!this.isDirectory()) {
                throw new IllegalArgumentException("not a directory: " + this.getNameString());
            }
            if (this.children == null) {
                ArrayList<ImageReader.Node> list = new ArrayList<ImageReader.Node>();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
                    for (Path p : stream) {
                        p = SystemImage.explodedModulesDir.relativize(p);
                        String pName = ExplodedImage.MODULES + ExplodedImage.this.nativeSlashToFrontSlash(p.toString());
                        ImageReader.Node node = ExplodedImage.this.findNode(pName);
                        if (node == null) continue;
                        list.add(node);
                    }
                }
                catch (IOException x) {
                    return null;
                }
                this.children = list;
            }
            return this.children;
        }

        @Override
        public long size() {
            try {
                return this.isDirectory() ? 0L : Files.size(this.path);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }
}

