/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class FontFamilyDeclaration
extends Declaration {
    private TeXFontFamily family;
    private TeXFontFamily orgFamily;

    public FontFamilyDeclaration(String string, int n) {
        super(string);
        this.orgFamily = TeXFontFamily.INHERIT;
        switch (n) {
            case -1: {
                this.family = TeXFontFamily.INHERIT;
                break;
            }
            case 0: {
                this.family = TeXFontFamily.RM;
                break;
            }
            case 1: {
                this.family = TeXFontFamily.SF;
                break;
            }
            case 2: {
                this.family = TeXFontFamily.TT;
                break;
            }
            case 3: {
                this.family = TeXFontFamily.CAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid family ID " + n);
            }
        }
    }

    public FontFamilyDeclaration(String string, TeXFontFamily teXFontFamily) {
        super(string);
        this.family = teXFontFamily;
        this.orgFamily = TeXFontFamily.INHERIT;
    }

    @Override
    public Object clone() {
        return new FontFamilyDeclaration(this.getName(), this.family);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgFamily = teXSettings.getCurrentFontFamily();
        teXSettings.setFontFamily(this.family);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontFamily(this.orgFamily);
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }

    public TeXFontFamily getFamily() {
        return this.family;
    }
}

