/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.ConditionAnd;
import com.dickimawbooks.bib2gls.ConditionNegate;
import com.dickimawbooks.bib2gls.ConditionOr;
import com.dickimawbooks.bib2gls.Conditional;
import com.dickimawbooks.bib2gls.ConditionalBinary;
import com.dickimawbooks.bib2gls.ConditionalListElement;
import com.dickimawbooks.bib2gls.ConditionalUnary;
import com.dickimawbooks.bib2gls.Field;
import com.dickimawbooks.bib2gls.FieldFieldMatch;
import com.dickimawbooks.bib2gls.FieldInField;
import com.dickimawbooks.bib2gls.FieldLengthMatch;
import com.dickimawbooks.bib2gls.FieldNullMatch;
import com.dickimawbooks.bib2gls.FieldNumberMatch;
import com.dickimawbooks.bib2gls.FieldPatternMatch;
import com.dickimawbooks.bib2gls.FieldPrefixOfField;
import com.dickimawbooks.bib2gls.FieldStringMatch;
import com.dickimawbooks.bib2gls.FieldSuffixOfField;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.FieldValueList;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.Relational;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.WhiteSpace;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Pattern;

public class ConditionalList
extends Vector<ConditionalListElement>
implements Conditional {
    protected ConditionalList() {
    }

    protected ConditionalList(int n) {
        super(n);
    }

    public static ConditionalList popCondition(GlsResource glsResource, String string, TeXObjectList teXObjectList, int n) throws Bib2GlsException, IOException {
        ConditionalList conditionalList = new ConditionalList();
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        TeXParser teXParser = glsResource.getParser();
        while (!teXObjectList.isEmpty()) {
            TeXObject teXObject = teXObjectList.peek();
            if (teXObject instanceof WhiteSpace) {
                teXObjectList.pop();
                continue;
            }
            if (teXObject instanceof SingleToken) {
                int n2 = ((SingleToken)teXObject).getCharCode();
                if (n2 == n) {
                    teXObjectList.pop();
                    conditionalList.validate(glsResource);
                    return conditionalList;
                }
                if (n2 == 33) {
                    conditionalList.add(new ConditionNegate());
                    teXObjectList.pop();
                    continue;
                }
                if (n2 == 124) {
                    conditionalList.add(new ConditionOr());
                    teXObjectList.pop();
                    continue;
                }
                if (n2 == 38) {
                    conditionalList.add(new ConditionAnd());
                    teXObjectList.pop();
                    continue;
                }
                if (n2 == 40) {
                    teXObjectList.pop();
                    conditionalList.add(ConditionalList.popCondition(glsResource, string, teXObjectList, 41));
                    continue;
                }
                conditionalList.add(ConditionalList.popComparison(glsResource, string, teXObjectList));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                conditionalList.add(ConditionalList.popComparison(glsResource, string, teXObjectList));
                continue;
            }
            if (conditionalList.isEmpty()) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_in", teXObject.toString(teXParser), bib2Gls.toTruncatedString(teXParser, teXObjectList)));
            }
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_after", teXObject.toString(teXParser), conditionalList.toString()));
        }
        if (n != -1) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_missing_end", Character.valueOf((char)n)));
        }
        return conditionalList;
    }

    public static Conditional popComparison(GlsResource glsResource, String string, TeXObjectList teXObjectList) throws Bib2GlsException, IOException {
        String string2;
        FieldValueElement fieldValueElement;
        Object object;
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        TeXParser teXParser = glsResource.getParser();
        teXObjectList.popLeadingWhiteSpace();
        TeXObject teXObject = teXObjectList.peek();
        String string3 = null;
        if (teXObject instanceof ControlSequence) {
            object = (ControlSequence)teXObject;
            string3 = ((ControlSequence)object).getName();
            if (!string3.equals("LEN") && !string3.equals("CAT")) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_in", teXObject, bib2Gls.toTruncatedString(teXParser, teXObjectList)));
            }
            teXObject = teXObjectList.pop();
            teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
            if (teXParser.isStack(teXObject)) {
                TeXObjectList teXObjectList2 = (TeXObjectList)teXObject;
                fieldValueElement = FieldValueList.pop(glsResource, string, teXObjectList2);
                teXObjectList2.popLeadingWhiteSpace();
                if (!teXObjectList2.isEmpty()) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.unexpected_content_in_arg", teXObjectList2.toString(teXParser), "\\" + string3));
                }
            } else {
                throw new Bib2GlsException(bib2Gls.getMessage("error.expected_field_or_string", "\\" + string3, teXObject.toString(teXParser)));
            }
            string2 = String.format("\\%s{%s}", string3, fieldValueElement);
            if (!string3.equals("LEN")) {
                string3 = null;
            }
        } else {
            fieldValueElement = Field.popField(glsResource, string, teXObjectList);
            string2 = ((Object)fieldValueElement).toString();
        }
        teXObjectList.popLeadingWhiteSpace();
        teXObject = teXObjectList.pop();
        if (teXObject == null) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.regexp_or_cmp_condition_missing", fieldValueElement));
        }
        if (teXObject instanceof ControlSequence) {
            if ("LEN".equals(string3)) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.numeric_condition", string2, teXObject.toString(teXParser)));
            }
            object = ((ControlSequence)teXObject).getName();
            if (((String)object).equals("IN")) {
                return new FieldInField(fieldValueElement, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList));
            }
            if (((String)object).equals("NIN")) {
                return new FieldInField(fieldValueElement, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList), true);
            }
            if (((String)object).equals("PREFIXOF")) {
                return new FieldPrefixOfField(fieldValueElement, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList));
            }
            if (((String)object).equals("NOTPREFIXOF")) {
                return new FieldPrefixOfField(fieldValueElement, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList), true);
            }
            if (((String)object).equals("SUFFIXOF")) {
                return new FieldSuffixOfField(fieldValueElement, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList));
            }
            if (((String)object).equals("NOTSUFFIXOF")) {
                return new FieldSuffixOfField(fieldValueElement, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList), true);
            }
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_after", "\\" + (String)object, string2));
        }
        teXObjectList.popLeadingWhiteSpace();
        object = teXObjectList.peek();
        if (object == null) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.regexp_or_cmp_condition_missing", string2 + teXObject.toString(teXParser)));
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        if (teXObject instanceof SingleToken) {
            n = ((SingleToken)teXObject).getCharCode();
        }
        if (object instanceof SingleToken) {
            n2 = ((SingleToken)object).getCharCode();
            n3 = ((SingleToken)object).getCatCode();
        }
        if (n == 61 && n2 == 47) {
            if ("LEN".equals(string3)) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.numeric_condition", string2, teXObject.toString(teXParser)));
            }
            teXObjectList.pop();
            String string4 = ConditionalList.popQuoted(glsResource, teXObjectList, 47).toString(teXParser);
            int n4 = 0;
            teXObject = teXObjectList.peek();
            if (teXObject instanceof SingleToken && ((SingleToken)teXObject).getCharCode() == 105) {
                n4 = 66;
                teXObject = teXObjectList.pop();
            }
            Pattern pattern = Pattern.compile(string4, n4);
            return new FieldPatternMatch(fieldValueElement, pattern);
        }
        Relational relational = null;
        if (n == 61) {
            relational = Relational.EQUALS;
        } else if (n == 60) {
            if (n2 == 61) {
                relational = Relational.LE;
                teXObject = teXObjectList.pop();
                teXObjectList.popLeadingWhiteSpace();
                object = teXObjectList.peek();
            } else if (n2 == 62) {
                relational = Relational.NOT_EQUALS;
                teXObject = teXObjectList.pop();
                teXObjectList.popLeadingWhiteSpace();
                object = teXObjectList.peek();
            } else {
                relational = Relational.LT;
            }
        } else if (n == 62) {
            if (n2 == 61) {
                relational = Relational.GE;
                teXObject = teXObjectList.pop();
                teXObjectList.popLeadingWhiteSpace();
                object = teXObjectList.peek();
            } else {
                relational = Relational.GT;
            }
        } else {
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_after", teXObject.toString(teXParser), fieldValueElement));
        }
        if ("LEN".equals(string3)) {
            try {
                return new FieldLengthMatch(fieldValueElement, relational, ConditionalList.popNumber(glsResource, teXObjectList));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.numeric_condition", string3, bib2Gls.toTruncatedString(teXParser, teXObjectList)), numberFormatException);
            }
        }
        if (object instanceof ControlSequence && ((ControlSequence)object).getName().equals("NULL")) {
            teXObjectList.pop();
            if (relational != Relational.EQUALS && relational != Relational.NOT_EQUALS) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.null_condition", new Object[]{relational, fieldValueElement}));
            }
            return new FieldNullMatch(fieldValueElement, relational == Relational.EQUALS);
        }
        if (n2 == 34) {
            teXObjectList.pop();
            String string5 = ConditionalList.popQuoted(glsResource, teXObjectList, 34).toString(teXParser);
            boolean bl = false;
            teXObject = teXObjectList.peek();
            if (teXObject instanceof SingleToken && ((SingleToken)teXObject).getCharCode() == 105) {
                bl = true;
                teXObject = teXObjectList.pop();
            }
            return new FieldStringMatch(fieldValueElement, relational, string5, true, bl);
        }
        if (object instanceof Group || n3 == 1) {
            String string6 = TeXParserUtils.popArg(teXParser, teXObjectList).toString(teXParser);
            boolean bl = false;
            teXObject = teXObjectList.peek();
            if (teXObject instanceof SingleToken && ((SingleToken)teXObject).getCharCode() == 105) {
                bl = true;
                teXObject = teXObjectList.pop();
            }
            return new FieldStringMatch(fieldValueElement, relational, string6, false, bl);
        }
        if (n2 >= 48 && n2 <= 57 || n2 == 46 || n2 == 43 || n2 == 45) {
            try {
                return new FieldNumberMatch(fieldValueElement, relational, ConditionalList.popNumber(glsResource, teXObjectList));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.numeric_condition", new Object[]{relational, bib2Gls.toTruncatedString(teXParser, teXObjectList)}), numberFormatException);
            }
        }
        return new FieldFieldMatch(fieldValueElement, relational, ConditionalList.popFieldValueElement(glsResource, string, teXObjectList));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FieldValueElement popFieldValueElement(GlsResource glsResource, String string, TeXObjectList teXObjectList) throws IOException, Bib2GlsException {
        void var5_10;
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        TeXParser teXParser = glsResource.getParser();
        teXObjectList.popLeadingWhiteSpace();
        TeXObject teXObject = teXObjectList.peek();
        if (teXObject instanceof ControlSequence) {
            String string2 = ((ControlSequence)teXObject).getName();
            if (!string2.equals("CAT")) throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_in", "\\" + string2, bib2Gls.toTruncatedString(teXParser, teXObjectList)));
            teXObject = teXObjectList.pop();
            teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
            if (!teXParser.isStack(teXObject)) throw new Bib2GlsException(bib2Gls.getMessage("error.expected_field_or_string", "\\" + string2, teXObject.toString(teXParser)));
            TeXObjectList teXObjectList2 = (TeXObjectList)teXObject;
            FieldValueList fieldValueList = FieldValueList.pop(glsResource, string, teXObjectList2);
            teXObjectList2.popLeadingWhiteSpace();
            if (teXObjectList2.isEmpty()) return var5_10;
            throw new Bib2GlsException(bib2Gls.getMessage("error.unexpected_content_in_arg", teXObjectList2.toString(teXParser), "\\" + string2));
        }
        Field field = Field.popField(glsResource, string, teXObjectList);
        return var5_10;
    }

    public static Number popNumber(GlsResource glsResource, TeXObjectList teXObjectList) throws NumberFormatException, IOException {
        Object object;
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!teXObjectList.isEmpty() && (object = teXObjectList.peek()) instanceof SingleToken) {
            int n = ((SingleToken)object).getCharCode();
            if (n >= 48 && n <= 57) {
                stringBuilder.appendCodePoint(n);
                bl3 = true;
                teXObjectList.pop();
                continue;
            }
            if (n == 43 || n == 45) {
                if (bl3 || bl && !bl2) break;
                stringBuilder.appendCodePoint(n);
                teXObjectList.pop();
                continue;
            }
            if (n == 101 || n == 69) {
                if (bl2) break;
                stringBuilder.appendCodePoint(n);
                bl3 = false;
                bl2 = true;
                teXObjectList.pop();
                continue;
            }
            if (n != 46 || bl || bl2) break;
            stringBuilder.appendCodePoint(n);
            bl = true;
            teXObjectList.pop();
        }
        if (((String)(object = stringBuilder.toString())).isEmpty()) {
            throw new NumberFormatException(bib2Gls.getMessage("error.missing_numeric", new Object[0]));
        }
        if (bl || bl2) {
            return Double.valueOf((String)object);
        }
        return Integer.valueOf((String)object);
    }

    public static TeXObjectList popQuoted(GlsResource glsResource, TeXObjectList teXObjectList, int n) throws Bib2GlsException, IOException {
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        TeXParser teXParser = glsResource.getParser();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        while (!teXObjectList.isEmpty()) {
            TeXObject teXObject = teXObjectList.pop();
            if (teXObject instanceof SingleToken && ((SingleToken)teXObject).getCharCode() == n) {
                return teXObjectList2;
            }
            teXObjectList2.add(teXObject);
        }
        throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_missing_end", Character.valueOf((char)n)));
    }

    protected void validate(GlsResource glsResource) throws Bib2GlsException {
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        if (this.isEmpty()) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.empty_condition", new Object[0]));
        }
        ConditionalUnary conditionalUnary = null;
        ConditionalBinary conditionalBinary = null;
        Conditional conditional = null;
        Boolean bl = null;
        for (int i = 0; i < this.size(); ++i) {
            ConditionalListElement conditionalListElement = (ConditionalListElement)this.get(i);
            if (conditionalListElement instanceof ConditionalUnary) {
                conditionalUnary = (ConditionalUnary)conditionalListElement;
                if (++i == this.size()) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.unary_missing", conditionalUnary, this.toString()));
                }
                conditionalListElement = (ConditionalListElement)this.get(i);
            }
            if (!(conditionalListElement instanceof Conditional)) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.condition_in", conditionalListElement, this.toString()));
            }
            conditional = (Conditional)conditionalListElement;
            if (bl == null) {
                bl = Boolean.TRUE;
            } else if (conditionalBinary != null) {
                conditionalBinary = null;
            } else {
                if (conditionalUnary == null) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.binary", conditional, this.toString()));
                }
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.binary", conditionalUnary.toString() + conditional.toString(), this.toString()));
            }
            if (++i >= this.size()) continue;
            conditionalListElement = (ConditionalListElement)this.get(i);
            if (conditionalListElement instanceof ConditionalBinary) {
                conditionalBinary = (ConditionalBinary)conditionalListElement;
                continue;
            }
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.binary", conditionalListElement, this.toString()));
        }
    }

    @Override
    public boolean booleanValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage("Entry: " + bib2GlsEntry + ". Evaluating condition group: " + this.toString());
        }
        if (this.isEmpty()) {
            bib2Gls.debugMessage("error.invalid.empty_condition", new Object[0]);
            return false;
        }
        ConditionalUnary conditionalUnary = null;
        ConditionalBinary conditionalBinary = null;
        Conditional conditional = null;
        Boolean bl = null;
        for (int i = 0; i < this.size(); ++i) {
            ConditionalListElement conditionalListElement = (ConditionalListElement)this.get(i);
            if (conditionalListElement instanceof ConditionalUnary) {
                conditionalUnary = (ConditionalUnary)conditionalListElement;
                if (++i == this.size()) {
                    bib2Gls.debugMessage("error.invalid.unary_missing", conditionalUnary, this.toString());
                    return false;
                }
                conditionalListElement = (ConditionalListElement)this.get(i);
            }
            if (!(conditionalListElement instanceof Conditional)) {
                bib2Gls.debugMessage("error.invalid.condition_in", conditionalListElement, this.toString());
                return false;
            }
            conditional = (Conditional)conditionalListElement;
            if (bl == null) {
                bl = conditionalUnary == null ? Boolean.valueOf(conditional.booleanValue(bib2GlsEntry)) : Boolean.valueOf(conditionalUnary.booleanValue(bib2GlsEntry, conditional));
            } else if (conditionalBinary != null) {
                bl = conditionalUnary == null ? Boolean.valueOf(conditionalBinary.booleanValue(bib2GlsEntry, bl, conditional)) : Boolean.valueOf(conditionalBinary.booleanValue(bib2GlsEntry, bl, conditionalUnary, conditional));
                conditionalBinary = null;
            } else {
                if (conditionalUnary == null) {
                    bib2Gls.debugMessage("error.invalid.binary", conditional, this.toString());
                    return false;
                }
                bib2Gls.debugMessage("error.invalid.binary", conditionalUnary.toString() + conditional.toString(), this.toString());
                return false;
            }
            if (++i >= this.size()) continue;
            conditionalListElement = (ConditionalListElement)this.get(i);
            if (conditionalListElement instanceof ConditionalBinary) {
                conditionalBinary = (ConditionalBinary)conditionalListElement;
                continue;
            }
            bib2Gls.debugMessage("error.invalid.binary", conditionalListElement, this.toString());
            return false;
        }
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage("Entry: " + bib2GlsEntry + ". Result from condition group: " + this.toString() + " : " + bl);
        }
        return bl;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            ConditionalListElement conditionalListElement = (ConditionalListElement)this.get(i);
            if (conditionalListElement instanceof ConditionalList) {
                stringBuilder.append("( ");
                stringBuilder.append(conditionalListElement.toString());
                stringBuilder.append(" )");
                continue;
            }
            if (conditionalListElement instanceof ConditionalBinary) {
                stringBuilder.append(" ");
                stringBuilder.append(conditionalListElement.toString());
                stringBuilder.append(" ");
                continue;
            }
            if (conditionalListElement instanceof ConditionalUnary) {
                stringBuilder.append(conditionalListElement.toString());
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(conditionalListElement.toString());
        }
        return stringBuilder.toString();
    }
}

