/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.AtxHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0006\u001a\u00060\u0007R\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "calcTailStartPos", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "headerSize", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Lkotlin/ranges/IntRange;", "markdown"})
public final class AtxHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        Intrinsics.checkNotNullParameter(stateInfo, "stateInfo");
        IntRange headerRange = this.matches(pos);
        if (headerRange != null) {
            return CollectionsKt.listOf(new AtxHeaderMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, headerRange, this.calcTailStartPos(pos, headerRange.getLast()), pos.getNextLineOrEofOffset()));
        }
        return CollectionsKt.emptyList();
    }

    private final int calcTailStartPos(LookaheadText.Position pos, int headerSize) {
        int n;
        CharSequence line = pos.getCurrentLineFromPosition();
        int offset = line.length() - 1;
        while (offset > headerSize && CharsKt.isWhitespace(line.charAt(offset))) {
            n = offset;
            offset = n + -1;
        }
        while (offset > headerSize && line.charAt(offset) == '#' && line.charAt(offset - 1) != '\\') {
            n = offset;
            offset = n + -1;
        }
        if (offset + 1 < line.length() && CharsKt.isWhitespace(line.charAt(offset)) && line.charAt(offset + 1) == '#') {
            return pos.getOffset() + offset + 1;
        }
        return pos.getOffset() + line.length();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        return this.matches(pos) != null;
    }

    private final IntRange matches(LookaheadText.Position pos) {
        if (pos.getOffsetInCurrentLine() != -1) {
            Character[] characterArray;
            CharSequence text2 = pos.getCurrentLineFromPosition();
            int offset = 0;
            offset = MarkerBlockProvider.Companion.passSmallIndent$default(MarkerBlockProvider.Companion, text2, 0, 2, null);
            if (offset >= text2.length() || text2.charAt(offset) != '#') {
                return null;
            }
            int start = offset;
            int n = 6;
            boolean bl = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int it = n2;
                boolean bl2 = false;
                if (offset >= text2.length() || text2.charAt(offset) != '#') continue;
                int n4 = offset;
                offset = n4 + 1;
            }
            if (offset < text2.length() && !CollectionsKt.listOf(characterArray = new Character[]{Character.valueOf(' '), Character.valueOf('\t')}).contains(Character.valueOf(text2.charAt(offset)))) {
                return null;
            }
            return new IntRange(start, offset - 1);
        }
        return null;
    }
}

