/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.PDFImageWriter;

public class PDFToImage {
    private static final String PASSWORD = "-password";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String IMAGE_FORMAT = "-imageType";
    private static final String OUTPUT_PREFIX = "-outputPrefix";
    private static final String COLOR = "-color";
    private static final String RESOLUTION = "-resolution";
    private static final String CROPBOX = "-cropbox";
    private static final String NONSEQ = "-nonSeq";

    private PDFToImage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int resolution;
        boolean useNonSeqParser = false;
        String password = "";
        String pdfFile = null;
        String outputPrefix = null;
        String imageFormat = "jpg";
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        String color = "rgb";
        float cropBoxLowerLeftX = 0.0f;
        float cropBoxLowerLeftY = 0.0f;
        float cropBoxUpperRightX = 0.0f;
        float cropBoxUpperRightY = 0.0f;
        try {
            resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            resolution = 96;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(START_PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                startPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(END_PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(IMAGE_FORMAT)) {
                imageFormat = args[++i];
                continue;
            }
            if (args[i].equals(OUTPUT_PREFIX)) {
                outputPrefix = args[++i];
                continue;
            }
            if (args[i].equals(COLOR)) {
                color = args[++i];
                continue;
            }
            if (args[i].equals(RESOLUTION)) {
                resolution = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals(CROPBOX)) {
                cropBoxLowerLeftX = Float.valueOf(args[++i]).floatValue();
                cropBoxLowerLeftY = Float.valueOf(args[++i]).floatValue();
                cropBoxUpperRightX = Float.valueOf(args[++i]).floatValue();
                cropBoxUpperRightY = Float.valueOf(args[++i]).floatValue();
                continue;
            }
            if (args[i].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            if (pdfFile != null) continue;
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PDFToImage.usage();
        } else {
            if (outputPrefix == null) {
                outputPrefix = pdfFile.substring(0, pdfFile.lastIndexOf(46));
            }
            PDDocument document = null;
            try {
                PDFImageWriter imageWriter;
                boolean success;
                if (useNonSeqParser) {
                    document = PDDocument.loadNonSeq(new File(pdfFile), null, password);
                } else {
                    document = PDDocument.load(pdfFile);
                    if (document.isEncrypted()) {
                        document.decrypt(password);
                    }
                }
                int imageType = 24;
                if ("bilevel".equalsIgnoreCase(color)) {
                    imageType = 12;
                } else if ("indexed".equalsIgnoreCase(color)) {
                    imageType = 13;
                } else if ("gray".equalsIgnoreCase(color)) {
                    imageType = 10;
                } else if ("rgb".equalsIgnoreCase(color)) {
                    imageType = 1;
                } else if ("rgba".equalsIgnoreCase(color)) {
                    imageType = 2;
                } else {
                    System.err.println("Error: the number of bits per pixel must be 1, 8 or 24.");
                    System.exit(2);
                }
                if (cropBoxLowerLeftX != 0.0f || cropBoxLowerLeftY != 0.0f || cropBoxUpperRightX != 0.0f || cropBoxUpperRightY != 0.0f) {
                    PDFToImage.changeCropBoxes(document, cropBoxLowerLeftX, cropBoxLowerLeftY, cropBoxUpperRightX, cropBoxUpperRightY);
                }
                if (!(success = (imageWriter = new PDFImageWriter()).writeImage(document, imageFormat, password, startPage, endPage, outputPrefix, imageType, resolution))) {
                    System.err.println("Error: no writer found for image format '" + imageFormat + "'");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PDFToImage [OPTIONS] <PDF file>\n  -password  <password>          Password to decrypt document\n  -imageType <image type>        (" + PDFToImage.getImageFormats() + ")\n  -outputPrefix <output prefix>  Filename prefix for image files\n  -startPage <number>            The first page to start extraction(1 based)\n  -endPage <number>              The last page to extract(inclusive)\n  -color <string>                The color depth (valid: bilevel, indexed, gray, rgb, rgba)\n  -resolution <number>           The bitmap resolution in dpi\n  -cropbox <number> <number> <number> <number> The page area to export\n  -nonSeq                        Enables the new non-sequential parser\n  <PDF file>                     The PDF document to use\n");
        System.exit(1);
    }

    private static String getImageFormats() {
        StringBuffer retval = new StringBuffer();
        String[] formats = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            retval.append(formats[i]);
            if (i + 1 >= formats.length) continue;
            retval.append(",");
        }
        return retval.toString();
    }

    private static void changeCropBoxes(PDDocument document, float a, float b, float c, float d) {
        List pages = document.getDocumentCatalog().getAllPages();
        for (int i = 0; i < pages.size(); ++i) {
            System.out.println("resizing page");
            PDPage page = (PDPage)pages.get(i);
            PDRectangle rectangle = new PDRectangle();
            rectangle.setLowerLeftX(a);
            rectangle.setLowerLeftY(b);
            rectangle.setUpperRightX(c);
            rectangle.setUpperRightY(d);
            page.setMediaBox(rectangle);
            page.setCropBox(rectangle);
        }
    }
}

