/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class SemaphoreValve
extends ValveBase {
    protected Semaphore semaphore = null;
    protected int concurrency = 10;
    protected boolean fairness = false;
    protected boolean block = true;
    protected boolean interruptible = false;
    protected int highConcurrencyStatus = -1;

    public SemaphoreValve() {
        super(true);
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int n) {
        this.concurrency = n;
    }

    public boolean getFairness() {
        return this.fairness;
    }

    public void setFairness(boolean bl) {
        this.fairness = bl;
    }

    public boolean getBlock() {
        return this.block;
    }

    public void setBlock(boolean bl) {
        this.block = bl;
    }

    public boolean getInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(boolean bl) {
        this.interruptible = bl;
    }

    public int getHighConcurrencyStatus() {
        return this.highConcurrencyStatus;
    }

    public void setHighConcurrencyStatus(int n) {
        this.highConcurrencyStatus = n;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.semaphore = new Semaphore(this.concurrency, this.fairness);
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.semaphore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.controlConcurrency(request, response)) {
            boolean bl = true;
            try {
                if (this.block) {
                    if (this.interruptible) {
                        try {
                            this.semaphore.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = false;
                            this.permitDenied(request, response);
                            if (bl) {
                                this.semaphore.release();
                            }
                            return;
                        }
                    } else {
                        this.semaphore.acquireUninterruptibly();
                    }
                } else if (!this.semaphore.tryAcquire()) {
                    bl = false;
                    this.permitDenied(request, response);
                    return;
                }
                this.getNext().invoke(request, response);
            }
            finally {
                if (bl) {
                    this.semaphore.release();
                }
            }
        } else {
            this.getNext().invoke(request, response);
        }
    }

    public boolean controlConcurrency(Request request, Response response) {
        return true;
    }

    public void permitDenied(Request request, Response response) throws IOException, ServletException {
        if (this.highConcurrencyStatus > 0) {
            response.sendError(this.highConcurrencyStatus);
        }
    }
}

