/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GzipInterceptor
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(GzipInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(GzipInterceptor.class);
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        try {
            byte[] byArray = GzipInterceptor.compress(channelMessage.getMessage().getBytes());
            channelMessage.getMessage().trim(channelMessage.getMessage().getLength());
            channelMessage.getMessage().append(byArray, 0, byArray.length);
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("gzipInterceptor.compress.failed"));
            throw new ChannelException(iOException);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        try {
            byte[] byArray = GzipInterceptor.decompress(channelMessage.getMessage().getBytes());
            channelMessage.getMessage().trim(channelMessage.getMessage().getLength());
            channelMessage.getMessage().append(byArray, 0, byArray.length);
            super.messageReceived(channelMessage);
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("gzipInterceptor.decompress.failed"), (Throwable)iOException);
        }
    }

    public static byte[] compress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.flush();
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decompress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[2048];
        int n = gZIPInputStream.read(byArray2);
        while (n > -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = gZIPInputStream.read(byArray2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

