/* tracker-turtle-reader.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-turtle-reader.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "tracker-sparql-query.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-db-interface.h"

#define TRACKER_TURTLE_READER_BUFFER_SIZE 32
#define TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE ((2 * 1024) * 1024)

#define TRACKER_TURTLE_READER_TYPE_TOKEN_INFO (tracker_turtle_reader_token_info_get_type ())
typedef struct _TrackerTurtleReaderTokenInfo TrackerTurtleReaderTokenInfo;
typedef enum  {
	TRACKER_TURTLE_READER_STATE_INITIAL,
	TRACKER_TURTLE_READER_STATE_BOS,
	TRACKER_TURTLE_READER_STATE_SUBJECT,
	TRACKER_TURTLE_READER_STATE_PREDICATE,
	TRACKER_TURTLE_READER_STATE_OBJECT
} TrackerTurtleReaderState;

#define TRACKER_TURTLE_READER_TYPE_STATE (tracker_turtle_reader_state_get_type ())
enum  {
	TRACKER_TURTLE_READER_0_PROPERTY,
	TRACKER_TURTLE_READER_GRAPH_PROPERTY,
	TRACKER_TURTLE_READER_SUBJECT_PROPERTY,
	TRACKER_TURTLE_READER_PREDICATE_PROPERTY,
	TRACKER_TURTLE_READER_OBJECT_PROPERTY,
	TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY,
	TRACKER_TURTLE_READER_NUM_PROPERTIES
};
static GParamSpec* tracker_turtle_reader_properties[TRACKER_TURTLE_READER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TrackerTurtleReaderTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerTurtleReaderPrivate {
	TrackerSparqlScanner* scanner;
	TrackerTurtleReaderTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	TrackerTurtleReaderState state;
	gchar* _graph;
	gchar* _subject;
	gchar* _predicate;
	gchar* _object;
	gboolean _object_is_uri;
	GHashTable* prefix_map;
	GQueue* subject_stack;
	GQueue* predicate_stack;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GMappedFile* mapped_file;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
};

static gint TrackerTurtleReader_private_offset;
static gpointer tracker_turtle_reader_parent_class = NULL;

static GType tracker_turtle_reader_token_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self);
static GType tracker_turtle_reader_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self,
                                               const gchar* user_bnodeid);
static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self,
                                           GError** error);
static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self);
static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self,
                                       TrackerSparqlTokenType type,
                                       GError** error);
static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self,
                                         const gchar* msg);
static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self,
                                       TrackerSparqlTokenType type,
                                       GError** error);
static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self,
                                              gint strip);
static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self,
                                                    const gchar* prefix,
                                                    const gchar* local_name,
                                                    GError** error);
static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self,
                                        const gchar* value);
static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self,
                                          const gchar* value);
static void tracker_turtle_reader_set_object (TrackerTurtleReader* self,
                                       const gchar* value);
static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self,
                                              gboolean value);
static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self,
                                      const gchar* value);
static void tracker_turtle_reader_finalize (GObject * obj);
static GType tracker_turtle_reader_get_type_once (void);
static void _vala_tracker_turtle_reader_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_tracker_turtle_reader_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
tracker_turtle_reader_get_instance_private (TrackerTurtleReader* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerTurtleReader_private_offset);
}

static GType
tracker_turtle_reader_state_get_type_once (void)
{
	static const GEnumValue values[] = {{TRACKER_TURTLE_READER_STATE_INITIAL, "TRACKER_TURTLE_READER_STATE_INITIAL", "initial"}, {TRACKER_TURTLE_READER_STATE_BOS, "TRACKER_TURTLE_READER_STATE_BOS", "bos"}, {TRACKER_TURTLE_READER_STATE_SUBJECT, "TRACKER_TURTLE_READER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_READER_STATE_PREDICATE, "TRACKER_TURTLE_READER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_READER_STATE_OBJECT, "TRACKER_TURTLE_READER_STATE_OBJECT", "object"}, {0, NULL, NULL}};
	GType tracker_turtle_reader_state_type_id;
	tracker_turtle_reader_state_type_id = g_enum_register_static ("TrackerTurtleReaderState", values);
	return tracker_turtle_reader_state_type_id;
}

static GType
tracker_turtle_reader_state_get_type (void)
{
	static volatile gsize tracker_turtle_reader_state_type_id__once = 0;
	if (g_once_init_enter (&tracker_turtle_reader_state_type_id__once)) {
		GType tracker_turtle_reader_state_type_id;
		tracker_turtle_reader_state_type_id = tracker_turtle_reader_state_get_type_once ();
		g_once_init_leave (&tracker_turtle_reader_state_type_id__once, tracker_turtle_reader_state_type_id);
	}
	return tracker_turtle_reader_state_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
#line 61 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	var = (g_free (var), NULL);
#line 181 "tracker-turtle-reader.c"
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
#line 61 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
#line 189 "tracker-turtle-reader.c"
}

TrackerTurtleReader*
tracker_turtle_reader_construct (GType object_type,
                                 GFile* file,
                                 GError** error)
{
	TrackerTurtleReader * self = NULL;
	guchar* _tmp18_;
	guchar* _tmp19_;
	gint _tmp19__length1;
	TrackerTurtleReaderTokenInfo* _tmp20_;
	GHashFunc _tmp21_;
	GEqualFunc _tmp22_;
	GDestroyNotify _tmp23_;
	GDestroyNotify _tmp24_;
	GHashTable* _tmp25_;
	GQueue* _tmp26_;
	GQueue* _tmp27_;
	GError* _inner_error0_ = NULL;
#line 71 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 71 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self = (TrackerTurtleReader*) g_object_new (object_type, NULL);
#line 72 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_file_is_native (file)) {
#line 216 "tracker-turtle-reader.c"
		GMappedFile* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GMappedFile* _tmp3_;
		GMappedFile* _tmp4_;
		GMappedFile* _tmp5_;
		GMappedFile* _tmp6_;
		gchar* _tmp7_;
		GMappedFile* _tmp8_;
		TrackerSparqlScanner* _tmp9_;
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_file_get_path (file);
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp2_ = _tmp1_;
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp3_ = g_mapped_file_new (_tmp2_, FALSE, &_inner_error0_);
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4_ = _tmp3_;
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp2_);
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = _tmp4_;
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 247 "tracker-turtle-reader.c"
		}
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = _tmp0_;
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = NULL;
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_mapped_file_unref0 (self->priv->mapped_file);
#line 73 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->mapped_file = _tmp5_;
#line 74 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = self->priv->mapped_file;
#line 74 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = g_mapped_file_get_contents (_tmp6_);
#line 74 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = self->priv->mapped_file;
#line 74 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = tracker_sparql_scanner_new (_tmp7_, g_mapped_file_get_length (_tmp8_));
#line 74 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_object_unref0 (self->priv->scanner);
#line 74 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->scanner = _tmp9_;
#line 72 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_mapped_file_unref0 (_tmp0_);
#line 271 "tracker-turtle-reader.c"
	} else {
		gsize len = 0UL;
		GFileInputStream* istream = NULL;
		GFileInputStream* _tmp10_;
		guchar* _tmp11_;
		GFileInputStream* _tmp12_;
		guchar* _tmp13_;
		gint _tmp13__length1;
		gsize _tmp14_ = 0UL;
		guchar* _tmp16_;
		gint _tmp16__length1;
		TrackerSparqlScanner* _tmp17_;
#line 77 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = g_file_read (file, NULL, &_inner_error0_);
#line 77 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		istream = _tmp10_;
#line 77 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 77 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 77 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 77 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 296 "tracker-turtle-reader.c"
		}
#line 78 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = g_new0 (guchar, TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE);
#line 78 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 78 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->buffer = _tmp11_;
#line 78 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->buffer_length1 = TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE;
#line 78 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_ = istream;
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_ = self->priv->buffer;
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13__length1 = self->priv->buffer_length1;
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_input_stream_read_all ((GInputStream*) _tmp12_, _tmp13_, (gsize) _tmp13__length1, &_tmp14_, NULL, &_inner_error0_);
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		len = _tmp14_;
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (istream);
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 79 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 328 "tracker-turtle-reader.c"
		}
#line 82 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (len == ((gsize) TRACKER_TURTLE_READER_MAX_ONTOLOGY_SIZE)) {
#line 332 "tracker-turtle-reader.c"
			GError* _tmp15_;
#line 83 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp15_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Ontology file too large");
#line 83 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_inner_error0_ = _tmp15_;
#line 83 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 83 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (istream);
#line 83 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (self);
#line 83 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 346 "tracker-turtle-reader.c"
		}
#line 85 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp16_ = self->priv->buffer;
#line 85 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp16__length1 = self->priv->buffer_length1;
#line 85 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp17_ = tracker_sparql_scanner_new (_tmp16_, len);
#line 85 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_object_unref0 (self->priv->scanner);
#line 85 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->scanner = _tmp17_;
#line 72 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_object_unref0 (istream);
#line 360 "tracker-turtle-reader.c"
	}
#line 88 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp18_ = g_new0 (guchar, 16);
#line 88 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 88 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = _tmp18_;
#line 88 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid_length1 = 16;
#line 88 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
#line 89 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp19_ = self->priv->base_uuid;
#line 89 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp19__length1 = self->priv->base_uuid_length1;
#line 89 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	uuid_generate (_tmp19_);
#line 91 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp20_ = g_new0 (TrackerTurtleReaderTokenInfo, TRACKER_TURTLE_READER_BUFFER_SIZE);
#line 91 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 91 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = _tmp20_;
#line 91 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens_length1 = TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 91 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->_tokens_size_ = self->priv->tokens_length1;
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp21_ = g_str_hash;
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp22_ = g_str_equal;
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp23_ = g_free;
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp24_ = g_free;
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp25_ = g_hash_table_new_full (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 92 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->prefix_map = _tmp25_;
#line 93 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp26_ = g_queue_new ();
#line 93 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(self->priv->subject_stack == NULL) ? NULL : (self->priv->subject_stack = (_g_queue_free__g_free0_ (self->priv->subject_stack), NULL));
#line 93 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->subject_stack = _tmp26_;
#line 94 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp27_ = g_queue_new ();
#line 94 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(self->priv->predicate_stack == NULL) ? NULL : (self->priv->predicate_stack = (_g_queue_free__g_free0_ (self->priv->predicate_stack), NULL));
#line 94 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->predicate_stack = _tmp27_;
#line 71 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return self;
#line 416 "tracker-turtle-reader.c"
}

TrackerTurtleReader*
tracker_turtle_reader_new (GFile* file,
                           GError** error)
{
#line 71 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return tracker_turtle_reader_construct (TRACKER_TYPE_TURTLE_READER, file, error);
#line 425 "tracker-turtle-reader.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1455 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1455 "glib-2.0.vapi"
	end = _tmp0_;
#line 1456 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1456 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1457 "glib-2.0.vapi"
		result = maxlen;
#line 1457 "glib-2.0.vapi"
		return result;
#line 448 "tracker-turtle-reader.c"
	} else {
		gchar* _tmp2_;
#line 1459 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1459 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1459 "glib-2.0.vapi"
		return result;
#line 457 "tracker-turtle-reader.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1466 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1468 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 476 "tracker-turtle-reader.c"
	} else {
#line 1468 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 480 "tracker-turtle-reader.c"
	}
#line 1468 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1470 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 486 "tracker-turtle-reader.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1472 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1472 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1472 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 496 "tracker-turtle-reader.c"
	}
#line 1475 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1476 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1477 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 504 "tracker-turtle-reader.c"
	} else {
#line 1479 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 508 "tracker-turtle-reader.c"
	}
#line 1481 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1482 "glib-2.0.vapi"
		len = string_length - offset;
#line 514 "tracker-turtle-reader.c"
	}
#line 1484 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1485 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1485 "glib-2.0.vapi"
	result = _tmp3_;
#line 1485 "glib-2.0.vapi"
	return result;
#line 524 "tracker-turtle-reader.c"
}

static gchar*
tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self,
                                        const gchar* user_bnodeid)
{
	gchar* result;
#line 97 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (user_bnodeid == NULL) {
#line 536 "tracker-turtle-reader.c"
		gint _tmp0_;
		gchar* _tmp1_;
#line 100 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->bnodeid = self->priv->bnodeid + 1;
#line 100 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = self->priv->bnodeid;
#line 100 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = g_strdup_printf (":%d", _tmp0_);
#line 100 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = _tmp1_;
#line 100 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 549 "tracker-turtle-reader.c"
	} else {
		GChecksum* checksum = NULL;
		GChecksum* _tmp2_;
		GChecksum* _tmp3_;
		guchar* _tmp4_;
		gint _tmp4__length1;
		GChecksum* _tmp5_;
		gchar* sha1 = NULL;
		GChecksum* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
#line 102 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp2_ = g_checksum_new (G_CHECKSUM_SHA1);
#line 102 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		checksum = _tmp2_;
#line 104 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp3_ = checksum;
#line 104 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4_ = self->priv->base_uuid;
#line 104 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4__length1 = self->priv->base_uuid_length1;
#line 104 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_checksum_update (_tmp3_, _tmp4_, (gsize) 16);
#line 106 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = checksum;
#line 106 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_checksum_update (_tmp5_, (guchar*) user_bnodeid, (gsize) -1);
#line 108 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = checksum;
#line 108 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = g_checksum_get_string (_tmp6_);
#line 108 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 108 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		sha1 = _tmp8_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = sha1;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = sha1;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = string_substring (_tmp10_, (glong) 8, (glong) -1);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp12_ = _tmp11_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp13_ = sha1;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp14_ = string_substring (_tmp13_, (glong) 12, (glong) -1);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp15_ = _tmp14_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp16_ = sha1;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp17_ = string_substring (_tmp16_, (glong) 16, (glong) -1);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp18_ = _tmp17_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp19_ = sha1;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp20_ = string_substring (_tmp19_, (glong) 20, (glong) -1);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp21_ = _tmp20_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp22_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", _tmp9_, _tmp12_, _tmp15_, _tmp18_, _tmp21_);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp23_ = _tmp22_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp21_);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp18_);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp15_);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp12_);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = _tmp23_;
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (sha1);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_checksum_free0 (checksum);
#line 111 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 646 "tracker-turtle-reader.c"
	}
}

static inline gboolean
tracker_turtle_reader_next_token (TrackerTurtleReader* self,
                                  GError** error)
{
	gint _tmp0_;
	TrackerTurtleReaderTokenInfo* _tmp12_;
	gint _tmp12__length1;
	TrackerTurtleReaderTokenInfo _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 116 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 117 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->index = (self->priv->index + 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 118 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->size;
#line 118 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->size = _tmp0_ - 1;
#line 119 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (self->priv->size <= 0) {
#line 670 "tracker-turtle-reader.c"
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type = 0;
		TrackerSparqlScanner* _tmp1_;
		TrackerSourceLocation _tmp2_ = {0};
		TrackerSourceLocation _tmp3_ = {0};
		TrackerSparqlTokenType _tmp4_;
		TrackerTurtleReaderTokenInfo* _tmp7_;
		gint _tmp7__length1;
		TrackerTurtleReaderTokenInfo* _tmp8_;
		gint _tmp8__length1;
		TrackerSourceLocation _tmp9_;
		TrackerTurtleReaderTokenInfo* _tmp10_;
		gint _tmp10__length1;
		TrackerSourceLocation _tmp11_;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp1_ = self->priv->scanner;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4_ = tracker_sparql_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		begin = _tmp2_;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		end = _tmp3_;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		type = _tmp4_;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 700 "tracker-turtle-reader.c"
				gboolean _tmp5_ = FALSE;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error0_);
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp5_;
#line 706 "tracker-turtle-reader.c"
			} else {
				gboolean _tmp6_ = FALSE;
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 121 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp6_;
#line 715 "tracker-turtle-reader.c"
			}
		}
#line 122 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = self->priv->tokens;
#line 122 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7__length1 = self->priv->tokens_length1;
#line 122 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_[self->priv->index].type = type;
#line 123 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_ = self->priv->tokens;
#line 123 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8__length1 = self->priv->tokens_length1;
#line 123 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp9_ = begin;
#line 123 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp8_[self->priv->index].begin = _tmp9_;
#line 124 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_ = self->priv->tokens;
#line 124 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10__length1 = self->priv->tokens_length1;
#line 124 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp11_ = end;
#line 124 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp10_[self->priv->index].end = _tmp11_;
#line 125 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->size = 1;
#line 742 "tracker-turtle-reader.c"
	}
#line 127 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = self->priv->tokens;
#line 127 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12__length1 = self->priv->tokens_length1;
#line 127 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp13_ = _tmp12_[self->priv->index];
#line 127 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp13_.type != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 127 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 754 "tracker-turtle-reader.c"
}

static inline TrackerSparqlTokenType
tracker_turtle_reader_current (TrackerTurtleReader* self)
{
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	TrackerTurtleReaderTokenInfo _tmp1_;
	TrackerSparqlTokenType result;
#line 130 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 131 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 131 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 131 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = _tmp0_[self->priv->index];
#line 131 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp1_.type;
#line 131 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 776 "tracker-turtle-reader.c"
}

static inline gboolean
tracker_turtle_reader_accept (TrackerTurtleReader* self,
                              TrackerSparqlTokenType type,
                              GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 134 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 135 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (tracker_turtle_reader_current (self) == type) {
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_next_token (self, &_inner_error0_);
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 796 "tracker-turtle-reader.c"
				gboolean _tmp0_ = FALSE;
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_propagate_error (error, _inner_error0_);
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp0_;
#line 802 "tracker-turtle-reader.c"
			} else {
				gboolean _tmp1_ = FALSE;
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 136 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return _tmp1_;
#line 811 "tracker-turtle-reader.c"
			}
		}
#line 137 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = TRUE;
#line 137 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 818 "tracker-turtle-reader.c"
	}
#line 139 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = FALSE;
#line 139 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 824 "tracker-turtle-reader.c"
}

static GError*
tracker_turtle_reader_get_error (TrackerTurtleReader* self,
                                 const gchar* msg)
{
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	TrackerTurtleReaderTokenInfo _tmp1_;
	TrackerSourceLocation _tmp2_;
	TrackerTurtleReaderTokenInfo* _tmp3_;
	gint _tmp3__length1;
	TrackerTurtleReaderTokenInfo _tmp4_;
	TrackerSourceLocation _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* result;
#line 142 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 142 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = _tmp0_[self->priv->index];
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_.begin;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = self->priv->tokens;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3__length1 = self->priv->tokens_length1;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = _tmp3_[self->priv->index];
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = _tmp4_.begin;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = g_strdup_printf ("%d.%d: syntax error, %s", _tmp2_.line, _tmp5_.column, msg);
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp7_);
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (_tmp7_);
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp9_;
#line 143 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 878 "tracker-turtle-reader.c"
}

static gboolean
tracker_turtle_reader_expect (TrackerTurtleReader* self,
                              TrackerSparqlTokenType type,
                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 146 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = tracker_turtle_reader_accept (self, type, &_inner_error0_);
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 902 "tracker-turtle-reader.c"
			gboolean _tmp1_ = FALSE;
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return _tmp1_;
#line 908 "tracker-turtle-reader.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return _tmp2_;
#line 917 "tracker-turtle-reader.c"
		}
	}
#line 147 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp0_) {
#line 148 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		result = TRUE;
#line 148 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return result;
#line 926 "tracker-turtle-reader.c"
	}
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = tracker_sparql_token_type_to_string (type);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = g_strdup_printf ("expected %s", _tmp3_);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = _tmp4_;
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = tracker_turtle_reader_get_error (self, _tmp5_);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_;
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (_tmp5_);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_inner_error0_ = _tmp7_;
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 944 "tracker-turtle-reader.c"
		gboolean _tmp8_ = FALSE;
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_propagate_error (error, _inner_error0_);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return _tmp8_;
#line 950 "tracker-turtle-reader.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_clear_error (&_inner_error0_);
#line 151 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return _tmp9_;
#line 959 "tracker-turtle-reader.c"
	}
}

static gchar*
tracker_turtle_reader_get_last_string (TrackerTurtleReader* self,
                                       gint strip)
{
	gint last_index = 0;
	TrackerTurtleReaderTokenInfo* _tmp0_;
	gint _tmp0__length1;
	TrackerTurtleReaderTokenInfo _tmp1_;
	TrackerSourceLocation _tmp2_;
	gchar* _tmp3_;
	TrackerTurtleReaderTokenInfo* _tmp4_;
	gint _tmp4__length1;
	TrackerTurtleReaderTokenInfo _tmp5_;
	TrackerSourceLocation _tmp6_;
	gchar* _tmp7_;
	TrackerTurtleReaderTokenInfo* _tmp8_;
	gint _tmp8__length1;
	TrackerTurtleReaderTokenInfo _tmp9_;
	TrackerSourceLocation _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
#line 154 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	last_index = ((self->priv->index + TRACKER_TURTLE_READER_BUFFER_SIZE) - 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->tokens;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = _tmp0_[last_index];
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = _tmp1_.begin;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = _tmp2_.pos;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4_ = self->priv->tokens;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp4__length1 = self->priv->tokens_length1;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp5_ = _tmp4_[last_index];
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp6_ = _tmp5_.end;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp7_ = _tmp6_.pos;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = self->priv->tokens;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8__length1 = self->priv->tokens_length1;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = _tmp8_[last_index];
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp10_ = _tmp9_.begin;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp11_ = _tmp10_.pos;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp12_ = string_substring ((const gchar*) (_tmp3_ + strip), (glong) 0, (glong) ((gint) ((_tmp7_ - _tmp11_) - (2 * strip))));
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp12_;
#line 156 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1025 "tracker-turtle-reader.c"
}

static gchar*
tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self,
                                             const gchar* prefix,
                                             const gchar* local_name,
                                             GError** error)
{
	gchar* ns = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 159 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 159 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (local_name != NULL, NULL);
#line 160 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->prefix_map;
#line 160 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, prefix);
#line 160 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
#line 160 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	ns = _tmp2_;
#line 161 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp3_ = ns;
#line 161 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (_tmp3_ == NULL) {
#line 1061 "tracker-turtle-reader.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp4_ = g_strdup_printf ("use of undefined prefix `%s'", prefix);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp5_ = _tmp4_;
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp6_ = tracker_turtle_reader_get_error (self, _tmp5_);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp7_ = _tmp6_;
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (_tmp5_);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error0_ = _tmp7_;
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_propagate_error (error, _inner_error0_);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_free0 (ns);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 1086 "tracker-turtle-reader.c"
		} else {
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_free0 (ns);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 162 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return NULL;
#line 1096 "tracker-turtle-reader.c"
		}
	}
#line 164 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp8_ = ns;
#line 164 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp9_ = g_strconcat (_tmp8_, local_name, NULL);
#line 164 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp9_;
#line 164 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (ns);
#line 164 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 1109 "tracker-turtle-reader.c"
}

gboolean
tracker_turtle_reader_next (TrackerTurtleReader* self,
                            GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 167 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 168 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	while (TRUE) {
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		switch (self->priv->state) {
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_INITIAL:
#line 1126 "tracker-turtle-reader.c"
			{
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_turtle_reader_next_token (self, &_inner_error0_);
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1134 "tracker-turtle-reader.c"
						gboolean _tmp0_ = FALSE;
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp0_;
#line 1140 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp1_ = FALSE;
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 171 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp1_;
#line 1149 "tracker-turtle-reader.c"
					}
				}
#line 172 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 173 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				continue;
#line 1156 "tracker-turtle-reader.c"
			}
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_BOS:
#line 1160 "tracker-turtle-reader.c"
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp29_ = FALSE;
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp2_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, &_inner_error0_);
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1170 "tracker-turtle-reader.c"
						gboolean _tmp3_ = FALSE;
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp3_;
#line 1176 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp4_ = FALSE;
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp4_;
#line 1185 "tracker-turtle-reader.c"
					}
				}
#line 176 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp2_) {
#line 1190 "tracker-turtle-reader.c"
					gchar* ns = NULL;
					gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
					gchar* uri = NULL;
					gchar* _tmp14_;
					GHashTable* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
#line 177 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp5_ = g_strdup ("");
#line 177 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					ns = _tmp5_;
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp6_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1211 "tracker-turtle-reader.c"
							gboolean _tmp7_ = FALSE;
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp7_;
#line 1219 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp8_ = FALSE;
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp8_;
#line 1230 "tracker-turtle-reader.c"
						}
					}
#line 178 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp6_) {
#line 1235 "tracker-turtle-reader.c"
						gchar* _tmp9_;
#line 179 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp9_ = tracker_turtle_reader_get_last_string (self, 0);
#line 179 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 179 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp9_;
#line 1243 "tracker-turtle-reader.c"
					}
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1251 "tracker-turtle-reader.c"
							gboolean _tmp10_ = FALSE;
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp10_;
#line 1259 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp11_ = FALSE;
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 181 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp11_;
#line 1270 "tracker-turtle-reader.c"
						}
					}
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1279 "tracker-turtle-reader.c"
							gboolean _tmp12_ = FALSE;
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp12_;
#line 1287 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp13_ = FALSE;
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 182 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp13_;
#line 1298 "tracker-turtle-reader.c"
						}
					}
#line 183 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp14_ = tracker_turtle_reader_get_last_string (self, 1);
#line 183 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					uri = _tmp14_;
#line 184 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp15_ = self->priv->prefix_map;
#line 184 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp16_ = ns;
#line 184 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp17_ = g_strdup (_tmp16_);
#line 184 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp18_ = uri;
#line 184 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp19_ = g_strdup (_tmp18_);
#line 184 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_hash_table_insert (_tmp15_, _tmp17_, _tmp19_);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1323 "tracker-turtle-reader.c"
							gboolean _tmp20_ = FALSE;
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (uri);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp20_;
#line 1333 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp21_ = FALSE;
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (uri);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (ns);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 185 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp21_;
#line 1346 "tracker-turtle-reader.c"
						}
					}
#line 186 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (uri);
#line 186 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (ns);
#line 186 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1355 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp22_ = FALSE;
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp22_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATBASE, &_inner_error0_);
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1364 "tracker-turtle-reader.c"
							gboolean _tmp23_ = FALSE;
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp23_;
#line 1370 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp24_ = FALSE;
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp24_;
#line 1379 "tracker-turtle-reader.c"
						}
					}
#line 187 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp22_) {
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1390 "tracker-turtle-reader.c"
								gboolean _tmp25_ = FALSE;
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp25_;
#line 1396 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp26_ = FALSE;
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 188 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp26_;
#line 1405 "tracker-turtle-reader.c"
							}
						}
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1414 "tracker-turtle-reader.c"
								gboolean _tmp27_ = FALSE;
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp27_;
#line 1420 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp28_ = FALSE;
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 189 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp28_;
#line 1429 "tracker-turtle-reader.c"
							}
						}
#line 190 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1434 "tracker-turtle-reader.c"
					} else {
#line 191 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (tracker_turtle_reader_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 192 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = FALSE;
#line 192 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 1442 "tracker-turtle-reader.c"
						}
					}
				}
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp29_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1452 "tracker-turtle-reader.c"
						gboolean _tmp30_ = FALSE;
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp30_;
#line 1458 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp31_ = FALSE;
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp31_;
#line 1467 "tracker-turtle-reader.c"
					}
				}
#line 195 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp29_) {
#line 1472 "tracker-turtle-reader.c"
					gchar* _tmp32_;
					gchar* _tmp33_;
#line 196 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp32_ = tracker_turtle_reader_get_last_string (self, 1);
#line 196 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp33_ = _tmp32_;
#line 196 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_subject (self, _tmp33_);
#line 196 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (_tmp33_);
#line 197 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 198 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1487 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp34_ = FALSE;
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp34_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1496 "tracker-turtle-reader.c"
							gboolean _tmp35_ = FALSE;
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp35_;
#line 1502 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp36_ = FALSE;
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp36_;
#line 1511 "tracker-turtle-reader.c"
						}
					}
#line 199 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp34_) {
#line 1516 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp37_;
						gchar* _tmp40_ = NULL;
						const gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
#line 201 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp37_ = tracker_turtle_reader_get_last_string (self, 0);
#line 201 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp37_;
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1537 "tracker-turtle-reader.c"
								gboolean _tmp38_ = FALSE;
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp38_;
#line 1545 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp39_ = FALSE;
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 202 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp39_;
#line 1556 "tracker-turtle-reader.c"
							}
						}
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp41_ = ns;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp42_ = tracker_turtle_reader_get_last_string (self, 0);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp43_ = _tmp42_;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp44_ = string_substring (_tmp43_, (glong) 1, (glong) -1);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp45_ = _tmp44_;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp46_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp41_, _tmp45_, &_inner_error0_);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp47_ = _tmp46_;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp45_);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp43_);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp40_ = _tmp47_;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1583 "tracker-turtle-reader.c"
								gboolean _tmp48_ = FALSE;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp48_;
#line 1591 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp49_ = FALSE;
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp49_;
#line 1602 "tracker-turtle-reader.c"
							}
						}
#line 203 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_subject (self, _tmp40_);
#line 204 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 205 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp40_);
#line 205 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 205 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1615 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp50_ = FALSE;
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp50_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1624 "tracker-turtle-reader.c"
								gboolean _tmp51_ = FALSE;
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp51_;
#line 1630 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp52_ = FALSE;
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp52_;
#line 1639 "tracker-turtle-reader.c"
							}
						}
#line 206 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp50_) {
#line 1644 "tracker-turtle-reader.c"
							gchar* _tmp53_ = NULL;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp54_ = tracker_turtle_reader_get_last_string (self, 0);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp55_ = _tmp54_;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp56_ = string_substring (_tmp55_, (glong) 1, (glong) -1);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp57_ = _tmp56_;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp58_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp57_, &_inner_error0_);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp59_ = _tmp58_;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp57_);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp55_);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp53_ = _tmp59_;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1674 "tracker-turtle-reader.c"
									gboolean _tmp60_ = FALSE;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp60_;
#line 1680 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp61_ = FALSE;
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp61_;
#line 1689 "tracker-turtle-reader.c"
								}
							}
#line 208 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp53_);
#line 209 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 210 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp53_);
#line 210 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 1700 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp62_ = FALSE;
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp62_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error0_);
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1709 "tracker-turtle-reader.c"
									gboolean _tmp63_ = FALSE;
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp63_;
#line 1715 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp64_ = FALSE;
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp64_;
#line 1724 "tracker-turtle-reader.c"
								}
							}
#line 211 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp62_) {
#line 1729 "tracker-turtle-reader.c"
								gchar* _tmp67_;
								gchar* _tmp68_;
								gchar* _tmp69_;
								gchar* _tmp70_;
								gchar* _tmp71_;
								gchar* _tmp72_;
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1742 "tracker-turtle-reader.c"
										gboolean _tmp65_ = FALSE;
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error0_);
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp65_;
#line 1748 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp66_ = FALSE;
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error0_);
#line 213 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp66_;
#line 1757 "tracker-turtle-reader.c"
									}
								}
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp67_ = tracker_turtle_reader_get_last_string (self, 0);
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp68_ = _tmp67_;
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp69_ = string_substring (_tmp68_, (glong) 1, (glong) -1);
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp70_ = _tmp69_;
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp71_ = tracker_turtle_reader_generate_bnodeid (self, _tmp70_);
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp72_ = _tmp71_;
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_subject (self, _tmp72_);
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp72_);
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp70_);
#line 214 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp68_);
#line 215 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 216 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 1784 "tracker-turtle-reader.c"
							} else {
								GError* _tmp73_;
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp73_ = tracker_turtle_reader_get_error (self, "expected subject");
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error0_ = _tmp73_;
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1793 "tracker-turtle-reader.c"
									gboolean _tmp74_ = FALSE;
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp74_;
#line 1799 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp75_ = FALSE;
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 218 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp75_;
#line 1808 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_SUBJECT:
#line 1817 "tracker-turtle-reader.c"
			{
				gboolean _tmp76_ = FALSE;
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp76_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1826 "tracker-turtle-reader.c"
						gboolean _tmp77_ = FALSE;
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp77_;
#line 1832 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp78_ = FALSE;
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp78_;
#line 1841 "tracker-turtle-reader.c"
					}
				}
#line 222 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp76_) {
#line 1846 "tracker-turtle-reader.c"
					gchar* _tmp79_;
					gchar* _tmp80_;
#line 223 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp79_ = tracker_turtle_reader_get_last_string (self, 1);
#line 223 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp80_ = _tmp79_;
#line 223 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_predicate (self, _tmp80_);
#line 223 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (_tmp80_);
#line 224 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 225 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 1861 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp81_ = FALSE;
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp81_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1870 "tracker-turtle-reader.c"
							gboolean _tmp82_ = FALSE;
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp82_;
#line 1876 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp83_ = FALSE;
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp83_;
#line 1885 "tracker-turtle-reader.c"
						}
					}
#line 226 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp81_) {
#line 1890 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp84_;
						gchar* _tmp87_ = NULL;
						const gchar* _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar* _tmp92_;
						gchar* _tmp93_;
						gchar* _tmp94_;
#line 227 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp84_ = tracker_turtle_reader_get_last_string (self, 0);
#line 227 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp84_;
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1911 "tracker-turtle-reader.c"
								gboolean _tmp85_ = FALSE;
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp85_;
#line 1919 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp86_ = FALSE;
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 228 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp86_;
#line 1930 "tracker-turtle-reader.c"
							}
						}
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp88_ = ns;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp89_ = tracker_turtle_reader_get_last_string (self, 0);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp90_ = _tmp89_;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp91_ = string_substring (_tmp90_, (glong) 1, (glong) -1);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp92_ = _tmp91_;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp93_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp88_, _tmp92_, &_inner_error0_);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp94_ = _tmp93_;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp92_);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp90_);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp87_ = _tmp94_;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1957 "tracker-turtle-reader.c"
								gboolean _tmp95_ = FALSE;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp95_;
#line 1965 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp96_ = FALSE;
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp96_;
#line 1976 "tracker-turtle-reader.c"
							}
						}
#line 229 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_predicate (self, _tmp87_);
#line 230 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 231 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp87_);
#line 231 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 231 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 1989 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp97_ = FALSE;
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp97_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1998 "tracker-turtle-reader.c"
								gboolean _tmp98_ = FALSE;
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp98_;
#line 2004 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp99_ = FALSE;
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp99_;
#line 2013 "tracker-turtle-reader.c"
							}
						}
#line 232 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp97_) {
#line 2018 "tracker-turtle-reader.c"
							gchar* _tmp100_ = NULL;
							gchar* _tmp101_;
							gchar* _tmp102_;
							gchar* _tmp103_;
							gchar* _tmp104_;
							gchar* _tmp105_;
							gchar* _tmp106_;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp101_ = tracker_turtle_reader_get_last_string (self, 0);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp102_ = _tmp101_;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp103_ = string_substring (_tmp102_, (glong) 1, (glong) -1);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp104_ = _tmp103_;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp105_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp104_, &_inner_error0_);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp106_ = _tmp105_;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp104_);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp102_);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp100_ = _tmp106_;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2048 "tracker-turtle-reader.c"
									gboolean _tmp107_ = FALSE;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp107_;
#line 2054 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp108_ = FALSE;
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp108_;
#line 2063 "tracker-turtle-reader.c"
								}
							}
#line 233 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp100_);
#line 234 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 235 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp100_);
#line 235 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 2074 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp109_ = FALSE;
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp109_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_A, &_inner_error0_);
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2083 "tracker-turtle-reader.c"
									gboolean _tmp110_ = FALSE;
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp110_;
#line 2089 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp111_ = FALSE;
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp111_;
#line 2098 "tracker-turtle-reader.c"
								}
							}
#line 236 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp109_) {
#line 237 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_predicate (self, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 238 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 239 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 2109 "tracker-turtle-reader.c"
							} else {
								GError* _tmp112_;
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp112_ = tracker_turtle_reader_get_error (self, "expected predicate");
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error0_ = _tmp112_;
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2118 "tracker-turtle-reader.c"
									gboolean _tmp113_ = FALSE;
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp113_;
#line 2124 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp114_ = FALSE;
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 241 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp114_;
#line 2133 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_PREDICATE:
#line 2142 "tracker-turtle-reader.c"
			{
				gboolean _tmp115_ = FALSE;
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp115_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2151 "tracker-turtle-reader.c"
						gboolean _tmp116_ = FALSE;
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp116_;
#line 2157 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp117_ = FALSE;
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp117_;
#line 2166 "tracker-turtle-reader.c"
					}
				}
#line 245 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp115_) {
#line 2171 "tracker-turtle-reader.c"
					gchar* _tmp118_;
					gchar* _tmp119_;
#line 246 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp118_ = tracker_turtle_reader_get_last_string (self, 1);
#line 246 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp119_ = _tmp118_;
#line 246 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object (self, _tmp119_);
#line 246 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_free0 (_tmp119_);
#line 247 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 248 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 249 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					result = TRUE;
#line 249 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					return result;
#line 2190 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp120_ = FALSE;
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp120_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2199 "tracker-turtle-reader.c"
							gboolean _tmp121_ = FALSE;
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp121_;
#line 2205 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp122_ = FALSE;
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp122_;
#line 2214 "tracker-turtle-reader.c"
						}
					}
#line 250 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp120_) {
#line 2219 "tracker-turtle-reader.c"
						gchar* ns = NULL;
						gchar* _tmp123_;
						gchar* _tmp126_ = NULL;
						const gchar* _tmp127_;
						gchar* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						gchar* _tmp132_;
						gchar* _tmp133_;
#line 252 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp123_ = tracker_turtle_reader_get_last_string (self, 0);
#line 252 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						ns = _tmp123_;
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2240 "tracker-turtle-reader.c"
								gboolean _tmp124_ = FALSE;
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp124_;
#line 2248 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp125_ = FALSE;
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 253 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp125_;
#line 2259 "tracker-turtle-reader.c"
							}
						}
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp127_ = ns;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp128_ = tracker_turtle_reader_get_last_string (self, 0);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp129_ = _tmp128_;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp130_ = string_substring (_tmp129_, (glong) 1, (glong) -1);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp131_ = _tmp130_;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp132_ = tracker_turtle_reader_resolve_prefixed_name (self, _tmp127_, _tmp131_, &_inner_error0_);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp133_ = _tmp132_;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp131_);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp129_);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp126_ = _tmp133_;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2286 "tracker-turtle-reader.c"
								gboolean _tmp134_ = FALSE;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp134_;
#line 2294 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp135_ = FALSE;
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (ns);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp135_;
#line 2305 "tracker-turtle-reader.c"
							}
						}
#line 254 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object (self, _tmp126_);
#line 255 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 256 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 257 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						result = TRUE;
#line 257 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (_tmp126_);
#line 257 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_g_free0 (ns);
#line 257 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return result;
#line 2322 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp136_ = FALSE;
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp136_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2331 "tracker-turtle-reader.c"
								gboolean _tmp137_ = FALSE;
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp137_;
#line 2337 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp138_ = FALSE;
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp138_;
#line 2346 "tracker-turtle-reader.c"
							}
						}
#line 258 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp136_) {
#line 2351 "tracker-turtle-reader.c"
							gchar* _tmp139_ = NULL;
							gchar* _tmp140_;
							gchar* _tmp141_;
							gchar* _tmp142_;
							gchar* _tmp143_;
							gchar* _tmp144_;
							gchar* _tmp145_;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp140_ = tracker_turtle_reader_get_last_string (self, 0);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp141_ = _tmp140_;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp142_ = string_substring (_tmp141_, (glong) 1, (glong) -1);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp143_ = _tmp142_;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp144_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp143_, &_inner_error0_);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp145_ = _tmp144_;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp143_);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp141_);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp139_ = _tmp145_;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2381 "tracker-turtle-reader.c"
									gboolean _tmp146_ = FALSE;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp146_;
#line 2387 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp147_ = FALSE;
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp147_;
#line 2396 "tracker-turtle-reader.c"
								}
							}
#line 260 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp139_);
#line 261 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 262 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 263 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = TRUE;
#line 263 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp139_);
#line 263 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 2411 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp148_ = FALSE;
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp148_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error0_);
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2420 "tracker-turtle-reader.c"
									gboolean _tmp149_ = FALSE;
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp149_;
#line 2426 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp150_ = FALSE;
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp150_;
#line 2435 "tracker-turtle-reader.c"
								}
							}
#line 264 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp148_) {
#line 2440 "tracker-turtle-reader.c"
								gchar* _tmp153_;
								gchar* _tmp154_;
								gchar* _tmp155_;
								gchar* _tmp156_;
								gchar* _tmp157_;
								gchar* _tmp158_;
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2453 "tracker-turtle-reader.c"
										gboolean _tmp151_ = FALSE;
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error0_);
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp151_;
#line 2459 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp152_ = FALSE;
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error0_);
#line 266 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp152_;
#line 2468 "tracker-turtle-reader.c"
									}
								}
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp153_ = tracker_turtle_reader_get_last_string (self, 0);
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp154_ = _tmp153_;
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp155_ = string_substring (_tmp154_, (glong) 1, (glong) -1);
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp156_ = _tmp155_;
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp157_ = tracker_turtle_reader_generate_bnodeid (self, _tmp156_);
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp158_ = _tmp157_;
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object (self, _tmp158_);
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp158_);
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp156_);
#line 267 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_g_free0 (_tmp154_);
#line 268 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 269 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 270 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								result = TRUE;
#line 270 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return result;
#line 2499 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp159_ = FALSE;
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp159_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, &_inner_error0_);
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2508 "tracker-turtle-reader.c"
										gboolean _tmp160_ = FALSE;
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_propagate_error (error, _inner_error0_);
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp160_;
#line 2514 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp161_ = FALSE;
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										g_clear_error (&_inner_error0_);
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return _tmp161_;
#line 2523 "tracker-turtle-reader.c"
									}
								}
#line 271 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_tmp159_) {
#line 2528 "tracker-turtle-reader.c"
									GQueue* _tmp162_;
									const gchar* _tmp163_;
									gchar* _tmp164_;
									GQueue* _tmp165_;
									const gchar* _tmp166_;
									gchar* _tmp167_;
									gchar* _tmp168_;
									gchar* _tmp169_;
#line 273 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp162_ = self->priv->subject_stack;
#line 273 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp163_ = self->priv->_subject;
#line 273 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp164_ = g_strdup (_tmp163_);
#line 273 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_queue_push_tail (_tmp162_, _tmp164_);
#line 274 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp165_ = self->priv->predicate_stack;
#line 274 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp166_ = self->priv->_predicate;
#line 274 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp167_ = g_strdup (_tmp166_);
#line 274 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_queue_push_tail (_tmp165_, _tmp167_);
#line 275 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp168_ = tracker_turtle_reader_generate_bnodeid (self, NULL);
#line 275 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp169_ = _tmp168_;
#line 275 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									tracker_turtle_reader_set_subject (self, _tmp169_);
#line 275 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_g_free0 (_tmp169_);
#line 276 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 277 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									continue;
#line 2565 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp170_ = FALSE;
									gboolean _tmp171_ = FALSE;
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									_tmp171_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, &_inner_error0_);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2575 "tracker-turtle-reader.c"
											gboolean _tmp172_ = FALSE;
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_propagate_error (error, _inner_error0_);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return _tmp172_;
#line 2581 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp173_ = FALSE;
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											g_clear_error (&_inner_error0_);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return _tmp173_;
#line 2590 "tracker-turtle-reader.c"
										}
									}
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_tmp171_) {
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp170_ = TRUE;
#line 2597 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp174_ = FALSE;
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp174_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, &_inner_error0_);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2606 "tracker-turtle-reader.c"
												gboolean _tmp175_ = FALSE;
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error0_);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp175_;
#line 2612 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp176_ = FALSE;
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error0_);
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp176_;
#line 2621 "tracker-turtle-reader.c"
											}
										}
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp170_ = _tmp174_;
#line 2626 "tracker-turtle-reader.c"
									}
#line 278 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									if (_tmp170_) {
#line 2630 "tracker-turtle-reader.c"
										GString* sb = NULL;
										GString* _tmp177_;
										gchar* s = NULL;
										gchar* _tmp178_;
										const gchar* p = NULL;
										const gchar* _tmp179_;
										const gchar* end = NULL;
										const gchar* _tmp180_;
										const gchar* _tmp181_;
										gint _tmp182_;
										gint _tmp183_;
										GString* _tmp210_;
										const gchar* _tmp211_;
										gboolean _tmp212_ = FALSE;
#line 279 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp177_ = g_string_new ("");
#line 279 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										sb = _tmp177_;
#line 281 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp178_ = tracker_turtle_reader_get_last_string (self, 1);
#line 281 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										s = _tmp178_;
#line 282 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp179_ = s;
#line 282 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										p = _tmp179_;
#line 283 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp180_ = p;
#line 283 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp181_ = s;
#line 283 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp182_ = strlen (_tmp181_);
#line 283 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp183_ = _tmp182_;
#line 283 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										end = _tmp180_ + _tmp183_;
#line 284 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										while (TRUE) {
#line 2669 "tracker-turtle-reader.c"
											const gchar* _tmp184_;
											const gchar* _tmp185_;
											const gchar* q = NULL;
											const gchar* _tmp186_;
											const gchar* _tmp187_;
											const gchar* _tmp188_;
#line 284 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp184_ = p;
#line 284 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp185_ = end;
#line 284 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (!(((glong) _tmp184_) < ((glong) _tmp185_))) {
#line 284 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												break;
#line 2684 "tracker-turtle-reader.c"
											}
#line 285 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp186_ = p;
#line 285 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp187_ = strchr (_tmp186_, (gint) '\\');
#line 285 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											q = _tmp187_;
#line 286 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp188_ = q;
#line 286 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp188_ == NULL) {
#line 2696 "tracker-turtle-reader.c"
												GString* _tmp189_;
												const gchar* _tmp190_;
												const gchar* _tmp191_;
												const gchar* _tmp192_;
												const gchar* _tmp193_;
#line 287 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp189_ = sb;
#line 287 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp190_ = p;
#line 287 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp191_ = end;
#line 287 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp192_ = p;
#line 287 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_string_append_len (_tmp189_, _tmp190_, (gssize) ((glong) (_tmp191_ - _tmp192_)));
#line 288 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp193_ = end;
#line 288 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp193_;
#line 2716 "tracker-turtle-reader.c"
											} else {
												GString* _tmp194_;
												const gchar* _tmp195_;
												const gchar* _tmp196_;
												const gchar* _tmp197_;
												const gchar* _tmp198_;
												const gchar* _tmp199_;
												gchar _tmp200_;
												const gchar* _tmp209_;
#line 290 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp194_ = sb;
#line 290 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp195_ = p;
#line 290 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp196_ = q;
#line 290 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp197_ = p;
#line 290 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_string_append_len (_tmp194_, _tmp195_, (gssize) ((glong) (_tmp196_ - _tmp197_)));
#line 291 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp198_ = q;
#line 291 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp198_ + 1;
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp199_ = p;
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp200_ = ((gchar*) _tmp199_)[0];
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												switch (_tmp200_) {
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '\'':
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '"':
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case '\\':
#line 2752 "tracker-turtle-reader.c"
													{
														GString* _tmp201_;
														const gchar* _tmp202_;
														gchar _tmp203_;
#line 296 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp201_ = sb;
#line 296 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp202_ = p;
#line 296 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp203_ = ((gchar*) _tmp202_)[0];
#line 296 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp201_, _tmp203_);
#line 297 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2767 "tracker-turtle-reader.c"
													}
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'b':
#line 2771 "tracker-turtle-reader.c"
													{
														GString* _tmp204_;
#line 299 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp204_ = sb;
#line 299 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp204_, '\b');
#line 300 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2780 "tracker-turtle-reader.c"
													}
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'f':
#line 2784 "tracker-turtle-reader.c"
													{
														GString* _tmp205_;
#line 302 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp205_ = sb;
#line 302 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp205_, '\f');
#line 303 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2793 "tracker-turtle-reader.c"
													}
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'n':
#line 2797 "tracker-turtle-reader.c"
													{
														GString* _tmp206_;
#line 305 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp206_ = sb;
#line 305 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp206_, '\n');
#line 306 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2806 "tracker-turtle-reader.c"
													}
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 'r':
#line 2810 "tracker-turtle-reader.c"
													{
														GString* _tmp207_;
#line 308 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp207_ = sb;
#line 308 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp207_, '\r');
#line 309 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2819 "tracker-turtle-reader.c"
													}
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													case 't':
#line 2823 "tracker-turtle-reader.c"
													{
														GString* _tmp208_;
#line 311 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_tmp208_ = sb;
#line 311 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_string_append_c (_tmp208_, '\t');
#line 312 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														break;
#line 2832 "tracker-turtle-reader.c"
													}
													default:
#line 292 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													break;
#line 2837 "tracker-turtle-reader.c"
												}
#line 314 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp209_ = p;
#line 314 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												p = _tmp209_ + 1;
#line 2843 "tracker-turtle-reader.c"
											}
										}
#line 317 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp210_ = sb;
#line 317 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp211_ = _tmp210_->str;
#line 317 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object (self, _tmp211_);
#line 318 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 319 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp212_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error0_);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2862 "tracker-turtle-reader.c"
												gboolean _tmp213_ = FALSE;
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error0_);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_free0 (s);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp213_;
#line 2872 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp214_ = FALSE;
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_free0 (s);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_string_free0 (sb);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error0_);
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp214_;
#line 2885 "tracker-turtle-reader.c"
											}
										}
#line 321 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp212_) {
#line 2890 "tracker-turtle-reader.c"
											gboolean _tmp215_ = FALSE;
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp215_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2898 "tracker-turtle-reader.c"
													gboolean _tmp216_ = FALSE;
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_free0 (s);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp216_;
#line 2908 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp217_ = FALSE;
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_free0 (s);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													_g_string_free0 (sb);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp217_;
#line 2921 "tracker-turtle-reader.c"
												}
											}
#line 322 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (!_tmp215_) {
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2932 "tracker-turtle-reader.c"
														gboolean _tmp218_ = FALSE;
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp218_;
#line 2942 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp219_ = FALSE;
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 323 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp219_;
#line 2955 "tracker-turtle-reader.c"
													}
												}
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 2964 "tracker-turtle-reader.c"
														gboolean _tmp220_ = FALSE;
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp220_;
#line 2974 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp221_ = FALSE;
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_free0 (s);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														_g_string_free0 (sb);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 324 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp221_;
#line 2987 "tracker-turtle-reader.c"
													}
												}
											}
										}
#line 328 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										result = TRUE;
#line 328 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_g_free0 (s);
#line 328 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_g_string_free0 (sb);
#line 328 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										return result;
#line 3000 "tracker-turtle-reader.c"
									} else {
										gboolean _tmp222_ = FALSE;
										gboolean _tmp223_ = FALSE;
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										_tmp223_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, &_inner_error0_);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3010 "tracker-turtle-reader.c"
												gboolean _tmp224_ = FALSE;
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_propagate_error (error, _inner_error0_);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp224_;
#line 3016 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp225_ = FALSE;
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												g_clear_error (&_inner_error0_);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return _tmp225_;
#line 3025 "tracker-turtle-reader.c"
											}
										}
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp223_) {
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp222_ = TRUE;
#line 3032 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp226_ = FALSE;
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp226_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, &_inner_error0_);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3041 "tracker-turtle-reader.c"
													gboolean _tmp227_ = FALSE;
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp227_;
#line 3047 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp228_ = FALSE;
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp228_;
#line 3056 "tracker-turtle-reader.c"
												}
											}
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp222_ = _tmp226_;
#line 3061 "tracker-turtle-reader.c"
										}
#line 329 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
										if (_tmp222_) {
#line 3065 "tracker-turtle-reader.c"
											gchar* _tmp229_;
											gchar* _tmp230_;
											gboolean _tmp231_ = FALSE;
#line 330 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp229_ = tracker_turtle_reader_get_last_string (self, 3);
#line 330 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp230_ = _tmp229_;
#line 330 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object (self, _tmp230_);
#line 330 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_g_free0 (_tmp230_);
#line 331 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 332 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp231_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error0_);
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3087 "tracker-turtle-reader.c"
													gboolean _tmp232_ = FALSE;
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp232_;
#line 3093 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp233_ = FALSE;
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp233_;
#line 3102 "tracker-turtle-reader.c"
												}
											}
#line 334 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp231_) {
#line 3107 "tracker-turtle-reader.c"
												gboolean _tmp234_ = FALSE;
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp234_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3115 "tracker-turtle-reader.c"
														gboolean _tmp235_ = FALSE;
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp235_;
#line 3121 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp236_ = FALSE;
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp236_;
#line 3130 "tracker-turtle-reader.c"
													}
												}
#line 335 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (!_tmp234_) {
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3141 "tracker-turtle-reader.c"
															gboolean _tmp237_ = FALSE;
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error0_);
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp237_;
#line 3147 "tracker-turtle-reader.c"
														} else {
															gboolean _tmp238_ = FALSE;
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_clear_error (&_inner_error0_);
#line 336 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp238_;
#line 3156 "tracker-turtle-reader.c"
														}
													}
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3165 "tracker-turtle-reader.c"
															gboolean _tmp239_ = FALSE;
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_propagate_error (error, _inner_error0_);
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp239_;
#line 3171 "tracker-turtle-reader.c"
														} else {
															gboolean _tmp240_ = FALSE;
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															g_clear_error (&_inner_error0_);
#line 337 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
															return _tmp240_;
#line 3180 "tracker-turtle-reader.c"
														}
													}
												}
											}
#line 341 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											result = TRUE;
#line 341 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											return result;
#line 3189 "tracker-turtle-reader.c"
										} else {
											gboolean _tmp241_ = FALSE;
											gboolean _tmp242_ = FALSE;
											gboolean _tmp243_ = FALSE;
											gboolean _tmp244_ = FALSE;
											gboolean _tmp245_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											_tmp245_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3202 "tracker-turtle-reader.c"
													gboolean _tmp246_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp246_;
#line 3208 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp247_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp247_;
#line 3217 "tracker-turtle-reader.c"
												}
											}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp245_) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp244_ = TRUE;
#line 3224 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp248_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp248_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, &_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3233 "tracker-turtle-reader.c"
														gboolean _tmp249_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp249_;
#line 3239 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp250_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp250_;
#line 3248 "tracker-turtle-reader.c"
													}
												}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp244_ = _tmp248_;
#line 3253 "tracker-turtle-reader.c"
											}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp244_) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp243_ = TRUE;
#line 3259 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp251_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp251_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, &_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3268 "tracker-turtle-reader.c"
														gboolean _tmp252_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp252_;
#line 3274 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp253_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp253_;
#line 3283 "tracker-turtle-reader.c"
													}
												}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp243_ = _tmp251_;
#line 3288 "tracker-turtle-reader.c"
											}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp243_) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp242_ = TRUE;
#line 3294 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp254_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp254_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_TRUE, &_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3303 "tracker-turtle-reader.c"
														gboolean _tmp255_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp255_;
#line 3309 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp256_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp256_;
#line 3318 "tracker-turtle-reader.c"
													}
												}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp242_ = _tmp254_;
#line 3323 "tracker-turtle-reader.c"
											}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp242_) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp241_ = TRUE;
#line 3329 "tracker-turtle-reader.c"
											} else {
												gboolean _tmp257_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp257_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FALSE, &_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3338 "tracker-turtle-reader.c"
														gboolean _tmp258_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_propagate_error (error, _inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp258_;
#line 3344 "tracker-turtle-reader.c"
													} else {
														gboolean _tmp259_ = FALSE;
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														g_clear_error (&_inner_error0_);
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
														return _tmp259_;
#line 3353 "tracker-turtle-reader.c"
													}
												}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp241_ = _tmp257_;
#line 3358 "tracker-turtle-reader.c"
											}
#line 342 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
											if (_tmp241_) {
#line 3362 "tracker-turtle-reader.c"
												gchar* _tmp260_;
												gchar* _tmp261_;
#line 343 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp260_ = tracker_turtle_reader_get_last_string (self, 0);
#line 343 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp261_ = _tmp260_;
#line 343 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object (self, _tmp261_);
#line 343 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_g_free0 (_tmp261_);
#line 344 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												tracker_turtle_reader_set_object_is_uri (self, FALSE);
#line 345 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 346 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												result = TRUE;
#line 346 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												return result;
#line 3381 "tracker-turtle-reader.c"
											} else {
												GError* _tmp262_;
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_tmp262_ = tracker_turtle_reader_get_error (self, "expected object");
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												_inner_error0_ = _tmp262_;
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3390 "tracker-turtle-reader.c"
													gboolean _tmp263_ = FALSE;
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_propagate_error (error, _inner_error0_);
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp263_;
#line 3396 "tracker-turtle-reader.c"
												} else {
													gboolean _tmp264_ = FALSE;
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													g_clear_error (&_inner_error0_);
#line 348 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
													return _tmp264_;
#line 3405 "tracker-turtle-reader.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			case TRACKER_TURTLE_READER_STATE_OBJECT:
#line 3418 "tracker-turtle-reader.c"
			{
				gboolean _tmp265_ = FALSE;
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp265_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3427 "tracker-turtle-reader.c"
						gboolean _tmp266_ = FALSE;
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_propagate_error (error, _inner_error0_);
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp266_;
#line 3433 "tracker-turtle-reader.c"
					} else {
						gboolean _tmp267_ = FALSE;
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						g_clear_error (&_inner_error0_);
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						return _tmp267_;
#line 3442 "tracker-turtle-reader.c"
					}
				}
#line 351 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_tmp265_) {
#line 352 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
#line 353 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					continue;
#line 3451 "tracker-turtle-reader.c"
				} else {
					gboolean _tmp268_ = FALSE;
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_tmp268_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error0_);
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3460 "tracker-turtle-reader.c"
							gboolean _tmp269_ = FALSE;
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_propagate_error (error, _inner_error0_);
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp269_;
#line 3466 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp270_ = FALSE;
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							g_clear_error (&_inner_error0_);
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return _tmp270_;
#line 3475 "tracker-turtle-reader.c"
						}
					}
#line 354 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_tmp268_) {
#line 3480 "tracker-turtle-reader.c"
						gboolean _tmp271_ = FALSE;
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp271_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3488 "tracker-turtle-reader.c"
								gboolean _tmp272_ = FALSE;
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_propagate_error (error, _inner_error0_);
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp272_;
#line 3494 "tracker-turtle-reader.c"
							} else {
								gboolean _tmp273_ = FALSE;
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								g_clear_error (&_inner_error0_);
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								return _tmp273_;
#line 3503 "tracker-turtle-reader.c"
							}
						}
#line 355 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (_tmp271_) {
#line 357 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 358 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							continue;
#line 3512 "tracker-turtle-reader.c"
						}
#line 360 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
#line 361 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						continue;
#line 3518 "tracker-turtle-reader.c"
					} else {
						GQueue* _tmp274_;
#line 362 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						_tmp274_ = self->priv->subject_stack;
#line 362 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
						if (!g_queue_is_empty (_tmp274_)) {
#line 3525 "tracker-turtle-reader.c"
							const gchar* _tmp277_;
							GQueue* _tmp278_;
							gpointer _tmp279_;
							gchar* _tmp280_;
							GQueue* _tmp281_;
							gpointer _tmp282_;
							gchar* _tmp283_;
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error0_);
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3539 "tracker-turtle-reader.c"
									gboolean _tmp275_ = FALSE;
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp275_;
#line 3545 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp276_ = FALSE;
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 364 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp276_;
#line 3554 "tracker-turtle-reader.c"
								}
							}
#line 366 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp277_ = self->priv->_subject;
#line 366 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object (self, _tmp277_);
#line 367 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
#line 369 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp278_ = self->priv->subject_stack;
#line 369 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp279_ = g_queue_pop_tail (_tmp278_);
#line 369 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp280_ = (gchar*) _tmp279_;
#line 369 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_subject (self, _tmp280_);
#line 369 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp280_);
#line 370 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp281_ = self->priv->predicate_stack;
#line 370 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp282_ = g_queue_pop_tail (_tmp281_);
#line 370 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp283_ = (gchar*) _tmp282_;
#line 370 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							tracker_turtle_reader_set_predicate (self, _tmp283_);
#line 370 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_g_free0 (_tmp283_);
#line 372 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
#line 373 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							result = TRUE;
#line 373 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							return result;
#line 3589 "tracker-turtle-reader.c"
						} else {
							gboolean _tmp284_ = FALSE;
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							_tmp284_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error0_);
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3598 "tracker-turtle-reader.c"
									gboolean _tmp285_ = FALSE;
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp285_;
#line 3604 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp286_ = FALSE;
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp286_;
#line 3613 "tracker-turtle-reader.c"
								}
							}
#line 374 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
							if (_tmp284_) {
#line 375 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
#line 376 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								continue;
#line 3622 "tracker-turtle-reader.c"
							} else {
								GError* _tmp287_;
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_tmp287_ = tracker_turtle_reader_get_error (self, "expected comma, semicolon, or dot");
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								_inner_error0_ = _tmp287_;
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3631 "tracker-turtle-reader.c"
									gboolean _tmp288_ = FALSE;
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_propagate_error (error, _inner_error0_);
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp288_;
#line 3637 "tracker-turtle-reader.c"
								} else {
									gboolean _tmp289_ = FALSE;
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									g_clear_error (&_inner_error0_);
#line 378 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
									return _tmp289_;
#line 3646 "tracker-turtle-reader.c"
								}
							}
						}
					}
				}
			}
			default:
#line 169 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			break;
#line 3656 "tracker-turtle-reader.c"
		}
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 401 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return self ? g_error_copy (self) : NULL;
#line 3666 "tracker-turtle-reader.c"
}

void
tracker_turtle_reader_load (GFile* file,
                            TrackerData* data,
                            GError** error)
{
	GError* _inner_error0_ = NULL;
#line 384 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (file != NULL);
#line 384 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (data != NULL);
#line 3679 "tracker-turtle-reader.c"
	{
		TrackerTurtleReader* reader = NULL;
		TrackerTurtleReader* _tmp0_;
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_begin_transaction (data, &_inner_error0_);
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3689 "tracker-turtle-reader.c"
				goto __catch0_tracker_sparql_error;
			}
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3694 "tracker-turtle-reader.c"
				goto __catch0_tracker_db_interface_error;
			}
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 386 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 3703 "tracker-turtle-reader.c"
		}
#line 388 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = tracker_turtle_reader_new (file, &_inner_error0_);
#line 388 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		reader = _tmp0_;
#line 388 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 388 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3713 "tracker-turtle-reader.c"
				goto __catch0_tracker_sparql_error;
			}
#line 388 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3718 "tracker-turtle-reader.c"
				goto __catch0_tracker_db_interface_error;
			}
			goto __finally0;
		}
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		while (TRUE) {
#line 3725 "tracker-turtle-reader.c"
			gboolean _tmp1_ = FALSE;
			TrackerTurtleReader* _tmp2_;
			TrackerTurtleReader* _tmp3_;
			gboolean _tmp4_;
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp2_ = reader;
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp1_ = tracker_turtle_reader_next (_tmp2_, &_inner_error0_);
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3740 "tracker-turtle-reader.c"
					goto __catch0_tracker_sparql_error;
				}
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3745 "tracker-turtle-reader.c"
					goto __catch0_tracker_db_interface_error;
				}
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return;
#line 3754 "tracker-turtle-reader.c"
			}
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (!_tmp1_) {
#line 389 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				break;
#line 3760 "tracker-turtle-reader.c"
			}
#line 390 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp3_ = reader;
#line 390 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_tmp4_ = _tmp3_->priv->_object_is_uri;
#line 390 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_tmp4_) {
#line 3768 "tracker-turtle-reader.c"
				TrackerTurtleReader* _tmp5_;
				const gchar* _tmp6_;
				TrackerTurtleReader* _tmp7_;
				const gchar* _tmp8_;
				TrackerTurtleReader* _tmp9_;
				const gchar* _tmp10_;
				TrackerTurtleReader* _tmp11_;
				const gchar* _tmp12_;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp5_ = reader;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp6_ = _tmp5_->priv->_graph;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp7_ = reader;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp8_ = _tmp7_->priv->_subject;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp9_ = reader;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp10_ = _tmp9_->priv->_predicate;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp11_ = reader;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp12_ = _tmp11_->priv->_object;
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_uri (data, _tmp6_, _tmp8_, _tmp10_, _tmp12_, &_inner_error0_);
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3801 "tracker-turtle-reader.c"
						goto __catch0_tracker_sparql_error;
					}
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3806 "tracker-turtle-reader.c"
						goto __catch0_tracker_db_interface_error;
					}
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					g_clear_error (&_inner_error0_);
#line 391 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					return;
#line 3815 "tracker-turtle-reader.c"
				}
			} else {
				TrackerTurtleReader* _tmp13_;
				const gchar* _tmp14_;
				TrackerTurtleReader* _tmp15_;
				const gchar* _tmp16_;
				TrackerTurtleReader* _tmp17_;
				const gchar* _tmp18_;
				TrackerTurtleReader* _tmp19_;
				const gchar* _tmp20_;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp13_ = reader;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp14_ = _tmp13_->priv->_graph;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp15_ = reader;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp16_ = _tmp15_->priv->_subject;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp17_ = reader;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp18_ = _tmp17_->priv->_predicate;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp19_ = reader;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_tmp20_ = _tmp19_->priv->_object;
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				tracker_data_insert_statement_with_string (data, _tmp14_, _tmp16_, _tmp18_, _tmp20_, &_inner_error0_);
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					_g_object_unref0 (reader);
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3850 "tracker-turtle-reader.c"
						goto __catch0_tracker_sparql_error;
					}
#line 393 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
					if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3855 "tracker-turtle-reader.c"
						goto __catch0_tracker_db_interface_error;
					}
					goto __finally0;
				}
			}
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			tracker_data_update_buffer_might_flush (data, &_inner_error0_);
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				_g_object_unref0 (reader);
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3869 "tracker-turtle-reader.c"
					goto __catch0_tracker_sparql_error;
				}
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3874 "tracker-turtle-reader.c"
					goto __catch0_tracker_db_interface_error;
				}
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				g_clear_error (&_inner_error0_);
#line 395 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
				return;
#line 3883 "tracker-turtle-reader.c"
			}
		}
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_commit_transaction (data, &_inner_error0_);
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			_g_object_unref0 (reader);
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 3894 "tracker-turtle-reader.c"
				goto __catch0_tracker_sparql_error;
			}
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			if (_inner_error0_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 3899 "tracker-turtle-reader.c"
				goto __catch0_tracker_db_interface_error;
			}
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			g_clear_error (&_inner_error0_);
#line 398 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
			return;
#line 3908 "tracker-turtle-reader.c"
		}
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_object_unref0 (reader);
#line 3912 "tracker-turtle-reader.c"
	}
	goto __finally0;
	__catch0_tracker_sparql_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		GError* _tmp22_;
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		e = _inner_error0_;
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error0_ = NULL;
#line 400 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_rollback_transaction (data);
#line 401 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp21_ = e;
#line 401 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp22_ = _g_error_copy0 (_tmp21_);
#line 401 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error0_ = _tmp22_;
#line 401 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 3934 "tracker-turtle-reader.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		GError* _tmp24_;
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		e = _inner_error0_;
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error0_ = NULL;
#line 403 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_data_rollback_transaction (data);
#line 404 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp23_ = e;
#line 404 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp24_ = _g_error_copy0 (_tmp23_);
#line 404 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_inner_error0_ = _tmp24_;
#line 404 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_error_free0 (e);
#line 3957 "tracker-turtle-reader.c"
		goto __finally0;
	}
	__finally0:
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_propagate_error (error, _inner_error0_);
#line 385 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		return;
#line 3967 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_graph (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_graph;
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 3984 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_graph (TrackerTurtleReader* self,
                                 const gchar* value)
{
	gchar* old_value;
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	old_value = tracker_turtle_reader_get_graph (self);
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3998 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_graph);
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_graph = _tmp0_;
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_GRAPH_PROPERTY]);
#line 4008 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_subject (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_subject;
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4025 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_subject (TrackerTurtleReader* self,
                                   const gchar* value)
{
	gchar* old_value;
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	old_value = tracker_turtle_reader_get_subject (self);
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4039 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_subject);
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_subject = _tmp0_;
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_SUBJECT_PROPERTY]);
#line 4049 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_predicate (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_predicate;
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4066 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_predicate (TrackerTurtleReader* self,
                                     const gchar* value)
{
	gchar* old_value;
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	old_value = tracker_turtle_reader_get_predicate (self);
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4080 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_predicate);
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_predicate = _tmp0_;
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_PREDICATE_PROPERTY]);
#line 4090 "tracker-turtle-reader.c"
	}
}

const gchar*
tracker_turtle_reader_get_object (TrackerTurtleReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_tmp0_ = self->priv->_object;
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = _tmp0_;
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4107 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_object (TrackerTurtleReader* self,
                                  const gchar* value)
{
	gchar* old_value;
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	old_value = tracker_turtle_reader_get_object (self);
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4121 "tracker-turtle-reader.c"
		gchar* _tmp0_;
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_tmp0_ = g_strdup (value);
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		_g_free0 (self->priv->_object);
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_object = _tmp0_;
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_PROPERTY]);
#line 4131 "tracker-turtle-reader.c"
	}
}

gboolean
tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self)
{
	gboolean result;
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	result = self->priv->_object_is_uri;
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return result;
#line 4145 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self,
                                         gboolean value)
{
	gboolean old_value;
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_return_if_fail (self != NULL);
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	old_value = tracker_turtle_reader_get_object_is_uri (self);
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	if (old_value != value) {
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		self->priv->_object_is_uri = value;
#line 57 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY]);
#line 4163 "tracker-turtle-reader.c"
	}
}

static TrackerTurtleReaderTokenInfo*
tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self)
{
	TrackerTurtleReaderTokenInfo* dup;
#line 35 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	dup = g_new0 (TrackerTurtleReaderTokenInfo, 1);
#line 35 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	memcpy (dup, self, sizeof (TrackerTurtleReaderTokenInfo));
#line 35 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	return dup;
#line 4177 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self)
{
#line 35 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_free (self);
#line 4185 "tracker-turtle-reader.c"
}

static GType
tracker_turtle_reader_token_info_get_type_once (void)
{
	GType tracker_turtle_reader_token_info_type_id;
	tracker_turtle_reader_token_info_type_id = g_boxed_type_register_static ("TrackerTurtleReaderTokenInfo", (GBoxedCopyFunc) tracker_turtle_reader_token_info_dup, (GBoxedFreeFunc) tracker_turtle_reader_token_info_free);
	return tracker_turtle_reader_token_info_type_id;
}

static GType
tracker_turtle_reader_token_info_get_type (void)
{
	static volatile gsize tracker_turtle_reader_token_info_type_id__once = 0;
	if (g_once_init_enter (&tracker_turtle_reader_token_info_type_id__once)) {
		GType tracker_turtle_reader_token_info_type_id;
		tracker_turtle_reader_token_info_type_id = tracker_turtle_reader_token_info_get_type_once ();
		g_once_init_leave (&tracker_turtle_reader_token_info_type_id__once, tracker_turtle_reader_token_info_type_id);
	}
	return tracker_turtle_reader_token_info_type_id__once;
}

static void
tracker_turtle_reader_class_init (TrackerTurtleReaderClass * klass,
                                  gpointer klass_data)
{
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	tracker_turtle_reader_parent_class = g_type_class_peek_parent (klass);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_type_class_adjust_private_offset (klass, &TrackerTurtleReader_private_offset);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_turtle_reader_get_property;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_turtle_reader_set_property;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_reader_finalize;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_GRAPH_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_GRAPH_PROPERTY] = g_param_spec_string ("graph", "graph", "graph", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_SUBJECT_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_SUBJECT_PROPERTY] = g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_PREDICATE_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_PREDICATE_PROPERTY] = g_param_spec_string ("predicate", "predicate", "predicate", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_PROPERTY] = g_param_spec_string ("object", "object", "object", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY, tracker_turtle_reader_properties[TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY] = g_param_spec_boolean ("object-is-uri", "object-is-uri", "object-is-uri", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4232 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_instance_init (TrackerTurtleReader * self,
                                     gpointer klass)
{
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv = tracker_turtle_reader_get_instance_private (self);
#line 64 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->bnodeid = 0;
#line 4243 "tracker-turtle-reader.c"
}

static void
tracker_turtle_reader_finalize (GObject * obj)
{
	TrackerTurtleReader * self;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 23 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_object_unref0 (self->priv->scanner);
#line 26 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 52 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_graph);
#line 54 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_subject);
#line 55 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_predicate);
#line 56 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_free0 (self->priv->_object);
#line 59 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 61 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(self->priv->subject_stack == NULL) ? NULL : (self->priv->subject_stack = (_g_queue_free__g_free0_ (self->priv->subject_stack), NULL));
#line 62 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	(self->priv->predicate_stack == NULL) ? NULL : (self->priv->predicate_stack = (_g_queue_free__g_free0_ (self->priv->predicate_stack), NULL));
#line 66 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 68 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	_g_mapped_file_unref0 (self->priv->mapped_file);
#line 69 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	G_OBJECT_CLASS (tracker_turtle_reader_parent_class)->finalize (obj);
#line 4278 "tracker-turtle-reader.c"
}

static GType
tracker_turtle_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleReader), 0, (GInstanceInitFunc) tracker_turtle_reader_instance_init, NULL };
	GType tracker_turtle_reader_type_id;
	tracker_turtle_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleReader", &g_define_type_info, 0);
	TrackerTurtleReader_private_offset = g_type_add_instance_private (tracker_turtle_reader_type_id, sizeof (TrackerTurtleReaderPrivate));
	return tracker_turtle_reader_type_id;
}

GType
tracker_turtle_reader_get_type (void)
{
	static volatile gsize tracker_turtle_reader_type_id__once = 0;
	if (g_once_init_enter (&tracker_turtle_reader_type_id__once)) {
		GType tracker_turtle_reader_type_id;
		tracker_turtle_reader_type_id = tracker_turtle_reader_get_type_once ();
		g_once_init_leave (&tracker_turtle_reader_type_id__once, tracker_turtle_reader_type_id);
	}
	return tracker_turtle_reader_type_id__once;
}

static void
_vala_tracker_turtle_reader_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	switch (property_id) {
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_graph (self));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_subject (self));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_predicate (self));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_string (value, tracker_turtle_reader_get_object (self));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		g_value_set_boolean (value, tracker_turtle_reader_get_object_is_uri (self));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4343 "tracker-turtle-reader.c"
		default:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4349 "tracker-turtle-reader.c"
	}
}

static void
_vala_tracker_turtle_reader_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	TrackerTurtleReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
	switch (property_id) {
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_GRAPH_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_graph (self, g_value_get_string (value));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_SUBJECT_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_subject (self, g_value_get_string (value));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_PREDICATE_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_predicate (self, g_value_get_string (value));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object (self, g_value_get_string (value));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		case TRACKER_TURTLE_READER_OBJECT_IS_URI_PROPERTY:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		tracker_turtle_reader_set_object_is_uri (self, g_value_get_boolean (value));
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4393 "tracker-turtle-reader.c"
		default:
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../tracker/src/libtracker-data/tracker-turtle-reader.vala"
		break;
#line 4399 "tracker-turtle-reader.c"
	}
}

