"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigManager = void 0;
const events_1 = require("events");
const configurationEventName = 'configuration-changed';
class ConfigManager {
    constructor() {
        this.emitter = new events_1.EventEmitter();
        this.config = {
            enable: true
        };
    }
    onConfigurationChanged(listener) {
        this.emitter.on(configurationEventName, listener);
    }
    isConfigChanged(config) {
        // right now we only care about enable
        return config.enable !== this.config.enable;
    }
    updateConfigFromPluginConfig(config) {
        this.config = {
            ...this.config,
            ...config
        };
        this.emitter.emit(configurationEventName, config);
    }
    getConfig() {
        return this.config;
    }
}
exports.ConfigManager = ConfigManager;
//# sourceMappingURL=config-manager.js.map