/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class FCLSupport {
    ListenerList<FileChangeListener> listeners;
    private static final RequestProcessor RP = new RequestProcessor("Async FileEvent dispatcher", 1, false, false);
    private static final Queue<DispatchEventWrapper> q = new ConcurrentLinkedQueue<DispatchEventWrapper>();
    private static final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            DispatchEventWrapper dispatchEventWrapper = (DispatchEventWrapper)q.poll();
            HashSet<Runnable> hashSet = new HashSet<Runnable>();
            while (dispatchEventWrapper != null) {
                dispatchEventWrapper.dispatchEvent(false, hashSet);
                dispatchEventWrapper = (DispatchEventWrapper)q.poll();
            }
            for (Runnable runnable : hashSet) {
                runnable.run();
            }
        }
    });

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add(fileChangeListener);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fileEvent, Op op, Collection<Runnable> collection) {
        List<FileChangeListener> list;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getAllListeners();
        }
        for (FileChangeListener fileChangeListener : list) {
            FCLSupport.dispatchEvent(fileChangeListener, fileEvent, op, collection);
        }
    }

    static void dispatchEvent(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op, Collection<Runnable> collection) {
        boolean bl = fileEvent.isAsynchronous();
        DispatchEventWrapperSingle dispatchEventWrapperSingle = new DispatchEventWrapperSingle(fileChangeListener, fileEvent, op);
        dispatchEventWrapperSingle.dispatchEvent(bl, collection);
    }

    static void dispatchEvent(Collection<FileChangeListener> collection, FileEvent fileEvent, Op op, Collection<Runnable> collection2) {
        boolean bl = fileEvent.isAsynchronous();
        DispatchEventWrapperMulti dispatchEventWrapperMulti = new DispatchEventWrapperMulti(collection, fileEvent, op);
        dispatchEventWrapperMulti.dispatchEvent(bl, collection2);
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.hasListeners();
    }

    private static class DispatchEventWrapperMulti
    extends DispatchEventWrapper {
        private final Collection<FileChangeListener> listeners;

        public DispatchEventWrapperMulti(Collection<FileChangeListener> collection, FileEvent fileEvent, Op op) {
            super(fileEvent, op);
            this.listeners = collection;
        }

        @Override
        protected void dispatchAllEventsSync(Collection<Runnable> collection) {
            for (FileChangeListener fileChangeListener : this.listeners) {
                this.dispatchEventImpl(fileChangeListener, this.fe, this.operation, collection);
            }
        }
    }

    private static class DispatchEventWrapperSingle
    extends DispatchEventWrapper {
        private final FileChangeListener fcl;

        public DispatchEventWrapperSingle(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op) {
            super(fileEvent, op);
            this.fcl = fileChangeListener;
        }

        @Override
        protected void dispatchAllEventsSync(Collection<Runnable> collection) {
            this.dispatchEventImpl(this.fcl, this.fe, this.operation, collection);
        }
    }

    private static abstract class DispatchEventWrapper {
        final FileEvent fe;
        final Op operation;

        DispatchEventWrapper(FileEvent fileEvent, Op op) {
            this.fe = fileEvent;
            this.operation = op;
        }

        void dispatchEvent(boolean bl, Collection<Runnable> collection) {
            if (bl) {
                q.offer(this);
                task.schedule(300);
            } else {
                this.dispatchAllEventsSync(collection);
            }
        }

        protected abstract void dispatchAllEventsSync(Collection<Runnable> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void dispatchEventImpl(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op, Collection<Runnable> collection) {
            Thread thread;
            String string;
            block26: {
                String string2;
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                string = null;
                thread = null;
                if (bl && (string2 = (thread = Thread.currentThread()).getName()) != null && !string2.contains(" :: ")) {
                    try {
                        string = string2;
                        thread.setName(string2 + " :: " + (Object)((Object)op) + " " + fileEvent.getFile().getPath());
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                if (collection != null) {
                    fileEvent.setPostNotify(collection);
                }
                switch (op) {
                    case DATA_CREATED: {
                        fileChangeListener.fileDataCreated(fileEvent);
                        break;
                    }
                    case FOLDER_CREATED: {
                        fileChangeListener.fileFolderCreated(fileEvent);
                        break;
                    }
                    case FILE_CHANGED: {
                        fileChangeListener.fileChanged(fileEvent);
                        break;
                    }
                    case FILE_DELETED: {
                        fileChangeListener.fileDeleted(fileEvent);
                        break;
                    }
                    case FILE_RENAMED: {
                        fileChangeListener.fileRenamed((FileRenameEvent)fileEvent);
                        break;
                    }
                    case ATTR_CHANGED: {
                        fileChangeListener.fileAttributeChanged((FileAttributeEvent)fileEvent);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)op);
                    }
                }
                if (collection == null) break block26;
                fileEvent.setPostNotify(null);
            }
            if (thread == null || string == null) return;
            try {
                thread.setName(string);
                return;
            }
            catch (SecurityException securityException) {}
            return;
            catch (RuntimeException runtimeException) {
                try {
                    Exceptions.printStackTrace((Throwable)runtimeException);
                    if (collection != null) {
                        fileEvent.setPostNotify(null);
                    }
                    if (thread == null || string == null) return;
                }
                catch (Throwable throwable) {
                    if (collection != null) {
                        fileEvent.setPostNotify(null);
                    }
                    if (thread == null || string == null) throw throwable;
                    try {
                        thread.setName(string);
                        throw throwable;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    thread.setName(string);
                    return;
                }
                catch (SecurityException securityException) {}
                return;
            }
        }
    }

    static enum Op {
        DATA_CREATED,
        FOLDER_CREATED,
        FILE_CHANGED,
        FILE_DELETED,
        FILE_RENAMED,
        ATTR_CHANGED;

    }
}

