/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.NonVerifyingHandler;
import nu.xom.ParsingException;
import nu.xom.URIUtil;
import nu.xom.ValidityException;
import nu.xom.XML1_0Parser;
import nu.xom.XMLException;
import nu.xom.XOMHandler;
import org.apache.xerces.impl.Version;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Builder {
    private XMLReader parser;
    private NodeFactory factory;
    private static double xercesVersion;
    private static String[] parsers;
    private static String fileURLPrefix;

    public Builder() {
        this(false);
    }

    public Builder(boolean bl) {
        this(Builder.findParser(bl), bl, null);
    }

    public Builder(boolean bl, NodeFactory nodeFactory) {
        this(Builder.findParser(bl), bl, nodeFactory);
    }

    static XMLReader findParser(boolean bl) {
        try {
            XML1_0Parser xML1_0Parser = new XML1_0Parser();
            Builder.setupParser((XMLReader)((Object)xML1_0Parser), bl);
            return xML1_0Parser;
        }
        catch (SAXException sAXException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            XMLReader xMLReader = (XMLReader)Class.forName("nu.xom.JDK15XML1_0Parser").newInstance();
            Builder.setupParser(xMLReader, bl);
            return xMLReader;
        }
        catch (SAXException sAXException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (int i = 2; i < parsers.length; ++i) {
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader(parsers[i]);
                Builder.setupParser(xMLReader, bl);
                return xMLReader;
            }
            catch (SAXException sAXException) {
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            Builder.setupParser(xMLReader, bl);
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new XMLException("Could not find a suitable SAX2 parser", sAXException);
        }
    }

    private static void setupParser(XMLReader xMLReader, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        Object object;
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        Object object2 = xMLReader;
        while (object2 instanceof XMLFilter && (object = ((XMLFilter)object2).getParent()) != null) {
            object2 = object;
        }
        object = object2.getClass().getName();
        if (!bl) {
            if (((String)object).equals("org.apache.crimson.parser.XMLReaderImpl")) {
                xMLReader.setErrorHandler(new NamespaceWellformednessRequired());
            } else {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", true);
                xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            }
        } else {
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setErrorHandler(new ValidityRequired());
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (((String)object).equals("nu.xom.XML1_0Parser") || ((String)object).equals("nu.xom.JDK15XML1_0Parser") || ((String)object).equals("org.apache.xerces.parsers.SAXParser") || ((String)object).equals("com.sun.org.apache.xerces.internal.parsers.SAXParser") || ((String)object).equals("org.apache.xerces.jaxp.SAXParserImpl$JAXPSAXParser") || ((String)object).equals("com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParser")) {
            try {
                xMLReader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                xMLReader.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public Builder(XMLReader xMLReader) {
        this(xMLReader, false);
    }

    public Builder(NodeFactory nodeFactory) {
        this(Builder.findParser(false), false, nodeFactory);
    }

    public Builder(XMLReader xMLReader, boolean bl) {
        this(xMLReader, bl, null);
    }

    public Builder(XMLReader xMLReader, boolean bl, NodeFactory nodeFactory) {
        try {
            Builder.setupParser(xMLReader, bl);
        }
        catch (SAXException sAXException) {
            if (bl) {
                throw new XMLException(xMLReader.getClass().getName() + " does not support validation.", sAXException);
            }
            throw new XMLException(xMLReader.getClass().getName() + " does not support the entity resolution features XOM requires.", sAXException);
        }
        this.parser = xMLReader;
        this.factory = nodeFactory;
        this.setHandlers();
    }

    private static boolean knownGoodParser(XMLReader xMLReader) {
        String string = xMLReader.getClass().getName();
        if (string.equals("org.apache.xml.resolver.tools.ResolvingXMLFilter")) {
            XMLFilter xMLFilter = (XMLFilter)xMLReader;
            string = xMLFilter.getParent().getClass().getName();
        }
        if (string.equals("gnu.xml.aelfred2.XmlReader")) {
            return false;
        }
        if (string.equals("net.sf.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (string.equals("com.icl.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (string.equals("org.apache.xerces.parsers.SAXParser") && xercesVersion >= 2.4) {
            return false;
        }
        for (int i = 0; i < parsers.length; ++i) {
            if (!string.equals(parsers[i])) continue;
            return true;
        }
        return false;
    }

    private void setHandlers() {
        XOMHandler xOMHandler;
        if ((this.factory == null || this.factory.getClass().getName().equals("nu.xom.NodeFactory")) && Builder.knownGoodParser(this.parser)) {
            NodeFactory nodeFactory = this.factory;
            if (nodeFactory == null) {
                nodeFactory = new NodeFactory();
            }
            xOMHandler = new NonVerifyingHandler(nodeFactory);
        } else {
            if (this.factory == null) {
                this.factory = new NodeFactory();
            }
            xOMHandler = new XOMHandler(this.factory);
        }
        this.parser.setContentHandler(xOMHandler);
        this.parser.setDTDHandler(xOMHandler);
        try {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", xOMHandler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", xOMHandler);
            if (this.parser.getClass().getName().equals("org.apache.crimson.parser.XMLReaderImpl")) {
                xOMHandler.usingCrimson = true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Document build(String string) throws ParsingException, ValidityException, IOException {
        string = this.canonicalizeURL(string);
        InputSource inputSource = new InputSource(string);
        return this.build(inputSource);
    }

    public Document build(InputStream inputStream) throws ParsingException, ValidityException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("Null InputStream");
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.build(inputSource);
    }

    public Document build(InputStream inputStream, String string) throws ParsingException, ValidityException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        if (string != null) {
            string = this.canonicalizeURL(string);
            inputSource.setSystemId(string);
        }
        return this.build(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document build(File file) throws ParsingException, ValidityException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder(fileURLPrefix);
        int n = string.length();
        char c = File.separatorChar;
        block102: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuilder.append('/');
                continue;
            }
            switch (c2) {
                case ' ': {
                    stringBuilder.append("%20");
                    continue block102;
                }
                case '!': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block102;
                }
                case '#': {
                    stringBuilder.append("%23");
                    continue block102;
                }
                case '$': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '%': {
                    stringBuilder.append("%25");
                    continue block102;
                }
                case '&': {
                    stringBuilder.append('&');
                    continue block102;
                }
                case '\'': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '(': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case ')': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '*': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '+': {
                    stringBuilder.append("%2B");
                    continue block102;
                }
                case ',': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '-': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '.': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '/': {
                    stringBuilder.append("%2F");
                    continue block102;
                }
                case '0': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '1': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '2': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '3': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '4': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '5': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '6': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '7': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '8': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '9': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case ':': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case ';': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '<': {
                    stringBuilder.append("%3C");
                    continue block102;
                }
                case '=': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '>': {
                    stringBuilder.append("%3E");
                    continue block102;
                }
                case '?': {
                    stringBuilder.append("%3F");
                    continue block102;
                }
                case '@': {
                    stringBuilder.append("%40");
                    continue block102;
                }
                case 'A': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'B': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'C': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'D': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'E': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'F': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'G': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'H': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'I': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'J': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'K': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'L': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'M': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'N': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'O': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'P': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'Q': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'R': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'S': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'T': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'U': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'V': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'W': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'X': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'Y': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'Z': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '[': {
                    stringBuilder.append("%5B");
                    continue block102;
                }
                case '\\': {
                    stringBuilder.append("%5C");
                    continue block102;
                }
                case ']': {
                    stringBuilder.append("%5D");
                    continue block102;
                }
                case '^': {
                    stringBuilder.append("%5E");
                    continue block102;
                }
                case '_': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '`': {
                    stringBuilder.append("%60");
                    continue block102;
                }
                case 'a': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'b': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'c': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'd': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'e': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'f': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'g': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'h': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'i': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'j': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'k': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'l': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'm': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'n': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'o': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'p': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'q': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'r': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 's': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 't': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'u': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'v': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'w': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'x': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'y': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case 'z': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                case '{': {
                    stringBuilder.append("%7B");
                    continue block102;
                }
                case '|': {
                    stringBuilder.append("%7C");
                    continue block102;
                }
                case '}': {
                    stringBuilder.append("%7D");
                    continue block102;
                }
                case '~': {
                    stringBuilder.append(c2);
                    continue block102;
                }
                default: {
                    if (c2 < '\ud800' || c2 > '\udfff') {
                        stringBuilder.append(URIUtil.percentEscape(c2));
                        continue block102;
                    }
                    if (c2 <= '\udbff') {
                        ++i;
                        try {
                            char c3 = string.charAt(i);
                            String string2 = String.valueOf(c2) + c3;
                            byte[] byArray = string2.getBytes("UTF8");
                            for (int j = 0; j < 4; ++j) {
                                stringBuilder.append('%');
                                String string3 = Integer.toHexString(byArray[j]).toUpperCase();
                                stringBuilder.append(string3.substring(string3.length() - 2));
                            }
                            continue block102;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            stringBuilder = new StringBuilder(0);
                            continue block102;
                        }
                    }
                    stringBuilder = new StringBuilder(0);
                }
            }
        }
        String string4 = stringBuilder.toString();
        try {
            Document document;
            Document document2 = document = this.build(fileInputStream, string4);
            return document2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public Document build(Reader reader) throws ParsingException, ValidityException, IOException {
        if (reader == null) {
            throw new NullPointerException("Attempted to build from null reader");
        }
        InputSource inputSource = new InputSource(reader);
        return this.build(inputSource);
    }

    public Document build(Reader reader, String string) throws ParsingException, ValidityException, IOException {
        InputSource inputSource = new InputSource(reader);
        if (string != null) {
            string = this.canonicalizeURL(string);
            inputSource.setSystemId(string);
        }
        return this.build(inputSource);
    }

    public Document build(String string, String string2) throws ParsingException, ValidityException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.build(stringReader, string2);
    }

    private String canonicalizeURL(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getPath();
            String string3 = uRL.getProtocol();
            String string4 = uRL.getHost();
            String string5 = uRL.getQuery();
            int n = uRL.getPort();
            if (string2 == null || string2.length() == 0) {
                string2 = "/";
            }
            string2 = URIUtil.removeDotSegments(string2);
            StringBuilder stringBuilder = new StringBuilder(string.length());
            stringBuilder.append(string3);
            stringBuilder.append("://");
            if (string4 != null) {
                stringBuilder.append(string4);
            }
            if (n >= 0) {
                stringBuilder.append(":" + n);
            }
            stringBuilder.append(string2);
            if (string5 != null) {
                stringBuilder.append("?" + string5);
            }
            return stringBuilder.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private Document build(InputSource inputSource) throws ParsingException, ValidityException, IOException {
        ValidityRequired validityRequired;
        ErrorHandler errorHandler;
        XOMHandler xOMHandler = (XOMHandler)this.parser.getContentHandler();
        Document document = null;
        try {
            this.parser.parse(inputSource);
            document = xOMHandler.getDocument();
        }
        catch (SAXParseException sAXParseException) {
            ParsingException parsingException = new ParsingException(sAXParseException.getMessage(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException);
            throw parsingException;
        }
        catch (SAXException sAXException) {
            ParsingException parsingException = new ParsingException(sAXException.getMessage(), inputSource.getSystemId(), sAXException);
            throw parsingException;
        }
        catch (XMLException xMLException) {
            throw new ParsingException(xMLException.getMessage(), xMLException);
        }
        catch (RuntimeException runtimeException) {
            ParsingException parsingException = new ParsingException(runtimeException.getMessage(), inputSource.getSystemId(), runtimeException);
            throw parsingException;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            ParsingException parsingException = new ParsingException(uTFDataFormatException.getMessage(), inputSource.getSystemId(), uTFDataFormatException);
            throw parsingException;
        }
        catch (CharConversionException charConversionException) {
            ParsingException parsingException = new ParsingException(charConversionException.getMessage(), inputSource.getSystemId(), charConversionException);
            throw parsingException;
        }
        catch (IOException iOException) {
            if (iOException.getClass().getName().equals("org.apache.xerces.util.URI$MalformedURIException")) {
                throw new ParsingException(iOException.getMessage(), inputSource.getSystemId(), iOException);
            }
            throw iOException;
        }
        finally {
            xOMHandler.freeMemory();
        }
        if (document == null) {
            ParsingException parsingException = new ParsingException("Parser did not build document", inputSource.getSystemId(), -1, -1);
            throw parsingException;
        }
        if ("".equals(document.getBaseURI())) {
            document.setBaseURI(inputSource.getSystemId());
        }
        if ((errorHandler = this.parser.getErrorHandler()) instanceof ValidityRequired && !(validityRequired = (ValidityRequired)errorHandler).isValid()) {
            ValidityException validityException = validityRequired.vexception;
            validityException.setDocument(document);
            validityRequired.reset();
            throw validityException;
        }
        return document;
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    static {
        String string;
        xercesVersion = 2.6;
        try {
            string = Version.getVersion();
            String string2 = string.substring(9);
            int n = string2.indexOf(".");
            int n2 = string2.lastIndexOf(".");
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, n2);
            if (Integer.parseInt(string4) < 10 && Integer.parseInt(string3) < 3) {
                xercesVersion = Double.parseDouble(string.substring(9, 12));
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        parsers = new String[]{"nu.xom.XML1_0Parser", "nu.xom.JDK15XML1_0Parser", "org.apache.xerces.parsers.SAXParser", "org.apache.xerces.jaxp.SAXParserImpl$JAXPSAXParser", "com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParser", "com.sun.org.apache.xerces.internal.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "org.apache.crimson.parser.XMLReaderImpl", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", "com.jclark.xml.sax.SAX2Driver", "net.sf.saxon.aelfred.SAXDriver", "com.icl.saxon.aelfred.SAXDriver", "org.dom4j.io.aelfred2.SAXDriver", "org.dom4j.io.aelfred.SAXDriver", "org.xmlpull.v1.sax2.Driver"};
        fileURLPrefix = "file://";
        string = System.getProperty("os.name", "Unix");
        if (string.indexOf("Windows") >= 0) {
            fileURLPrefix = "file:/";
        }
    }

    private static class NamespaceWellformednessRequired
    implements ErrorHandler {
        private NamespaceWellformednessRequired() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            if (sAXParseException.getMessage().equals("Illegal Namespace prefix: \"xml\".")) {
                return;
            }
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }
    }

    private static class ValidityRequired
    implements ErrorHandler {
        ValidityException vexception = null;

        private ValidityRequired() {
        }

        void reset() {
            this.vexception = null;
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            if (this.vexception == null) {
                this.vexception = new ValidityException(sAXParseException.getMessage(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException);
            }
            this.vexception.addError(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        boolean isValid() {
            return this.vexception == null;
        }
    }
}

