/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan.filters.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ascan.filters.FilterCriteria;
import org.zaproxy.zap.extension.ascan.filters.FilterResult;
import org.zaproxy.zap.extension.ascan.filters.ScanFilter;

public abstract class AbstractGenericScanFilter<T, V>
implements ScanFilter {
    public static final String INCLUDE_FILTER_CRITERIA_MESSAGE_KEY = "scan.filter.filtercriteria.include";
    public static final String EXCLUDE_FILTER_CRITERIA_MESSAGE_KEY = "scan.filter.filtercriteria.exclude";
    private final BiPredicate<Collection<T>, V> matcher;
    private FilterCriteria filterCriteria = FilterCriteria.INCLUDE;
    private Collection<T> filterData = new LinkedHashSet<T>();

    public AbstractGenericScanFilter() {
        this((filterData, value) -> filterData.contains(value));
    }

    public AbstractGenericScanFilter(BiPredicate<Collection<T>, V> matcher) {
        this.matcher = matcher;
    }

    public abstract String getFilterType();

    public FilterCriteria getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setFilterCriteria(FilterCriteria filterCriteria) {
        Objects.requireNonNull(filterCriteria);
        this.filterCriteria = filterCriteria;
    }

    public Collection<T> getFilterData() {
        return this.filterData;
    }

    public void setFilterData(Collection<T> filterData) {
        Objects.requireNonNull(filterData);
        this.filterData = filterData;
    }

    protected FilterResult isFiltered(Collection<V> values) {
        Objects.requireNonNull(values);
        if (this.filterData.isEmpty()) {
            return FilterResult.NOT_FILTERED;
        }
        FilterCriteria filterCriteria = this.getFilterCriteria();
        switch (filterCriteria) {
            case INCLUDE: {
                if (values.stream().anyMatch(value -> this.matcher.test(this.filterData, value))) {
                    return FilterResult.NOT_FILTERED;
                }
                return new FilterResult(Constant.messages.getString(INCLUDE_FILTER_CRITERIA_MESSAGE_KEY, this.getFilterType(), this.filterData));
            }
            case EXCLUDE: {
                for (V value2 : values) {
                    if (!this.matcher.test(this.filterData, value2)) continue;
                    return new FilterResult(Constant.messages.getString(EXCLUDE_FILTER_CRITERIA_MESSAGE_KEY, this.getFilterType(), "[" + value2 + "]"));
                }
                return FilterResult.NOT_FILTERED;
            }
        }
        return FilterResult.NOT_FILTERED;
    }

    protected FilterResult isFiltered(V value) {
        Objects.requireNonNull(value);
        LinkedHashSet<V> nodeValues = new LinkedHashSet<V>();
        nodeValues.add(value);
        return this.isFiltered((V)nodeValues);
    }
}

