/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;

public class HttpSessionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6380136823410869457L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("httpsessions.table.header.active"), Constant.messages.getString("httpsessions.table.header.name"), Constant.messages.getString("httpsessions.table.header.tokens"), Constant.messages.getString("httpsessions.table.header.matched")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private ArrayList<HttpSession> sessions;
    private HttpSessionsSite site;

    public HttpSessionsTableModel(HttpSessionsSite site) {
        this.site = site;
        this.sessions = new ArrayList(2);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.sessions.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.sessions.size()) {
            return null;
        }
        HttpSession session = this.sessions.get(row);
        switch (col) {
            case 0: {
                return session.isActive();
            }
            case 1: {
                return session.getName();
            }
            case 2: {
                return session.getTokenValuesString();
            }
            case 3: {
                return session.getMessagesMatched();
            }
        }
        return null;
    }

    public void removeAllElements() {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.removeAllElements();
                }
            });
            return;
        }
        this.sessions.clear();
        this.sessions.trimToSize();
        this.fireTableDataChanged();
    }

    public void addHttpSession(final HttpSession session) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.addHttpSession(session);
                }
            });
            return;
        }
        if (this.sessions.contains(session)) {
            return;
        }
        this.sessions.add(session);
        int affectedRow = this.sessions.size() - 1;
        this.fireTableRowsInserted(affectedRow, affectedRow);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.site.renameHttpSession(this.sessions.get(rowIndex).getName(), (String)aValue);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return null;
    }

    protected HttpSession getHttpSessionAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.sessions.size()) {
            return null;
        }
        return this.sessions.get(rowIndex);
    }

    public void removeHttpSession(final HttpSession session) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.removeHttpSession(session);
                }
            });
            return;
        }
        int index = this.sessions.indexOf(session);
        this.sessions.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void fireHttpSessionUpdated(final HttpSession session) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSessionsTableModel.this.fireHttpSessionUpdated(session);
                }
            });
            return;
        }
        int index = this.sessions.indexOf(session);
        this.fireTableRowsUpdated(index, index);
    }
}

