"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;
var _constants = require("../utils/constants");
var _operators = require("rxjs/operators");
var _router = _interopRequireDefault(require("./router"));
var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));
var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));
var _ad = _interopRequireWildcard(require("./routes/ad"));
var _alerting = _interopRequireWildcard(require("./routes/alerting"));
var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));
var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));
var _constants2 = require("./utils/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core) {
    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch;

    // Create OpenSearch client w/ relevant plugins and headers
    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      plugins: [_adPlugin.default, _alertingPlugin.default],
      customHeaders: {
        ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    });

    // Create router
    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH);

    // Create services & register with OpenSearch client
    const adService = new _ad.default(client);
    const alertingService = new _alerting.default(client);
    const opensearchService = new _opensearch.default(client);
    const sampleDataService = new _sampleData.default(client);

    // Register server routes with the service
    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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