#!/bin/bash
# vim: set tabstop=8 shiftwidth=4 softtabstop=4 expandtab smarttab colorcolumn=80:
#
# Copyright (c) 2016 Red Hat, Inc.
# Author: Nathaniel McCallum <npmccallum@redhat.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

depends() {
    echo crypt systemd
    return 255
}

install() {
    if dracut_module_included "systemd"; then
        inst_multiple \
            $systemdsystemunitdir/clevis-luks-askpass.service \
            $systemdsystemunitdir/clevis-luks-askpass.path
        systemctl -q --root "$initdir" add-wants cryptsetup.target clevis-luks-askpass.path
    else
        inst_hook initqueue/online 60 "$moddir/clevis-hook.sh"
        inst_hook initqueue/settled 60 "$moddir/clevis-hook.sh"
    fi

    inst_multiple \
        /etc/services \
        /usr/lib/systemd/systemd-reply-password \
        /usr/lib/clevis-luks-askpass \
        clevis-luks-common-functions \
        grep sed cut \
        clevis-decrypt \
        clevis-luks-list \
        cryptsetup \
        luksmeta \
        clevis \
        mktemp \
        mkdir \
        jose

    dracut_need_initqueue
}
