/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.util;

import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.util.CustomSSLSocketFactory;
import org.bouncycastle.jsse.util.SNIUtil;

public class SNISocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SNISocketFactory.class.getName());
    protected static final ThreadLocal<SNISocketFactory> threadLocal = new ThreadLocal();
    protected final URL url;

    public static SocketFactory getDefault() {
        SSLSocketFactory sSLSocketFactory = threadLocal.get();
        if (null != sSLSocketFactory) {
            return sSLSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SNISocketFactory(SSLSocketFactory sSLSocketFactory, URL uRL) {
        super(sSLSocketFactory);
        this.url = uRL;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket socket) {
        if (socket instanceof BCSSLSocket) {
            BCSSLSocket bCSSLSocket = (BCSSLSocket)((Object)socket);
            BCSNIHostName bCSNIHostName = this.getBCSNIHostName();
            if (null != bCSNIHostName) {
                LOG.fine("Setting SNI on socket: " + bCSNIHostName);
                BCSSLParameters bCSSLParameters = new BCSSLParameters();
                bCSSLParameters.setServerNames(Collections.singletonList(bCSNIHostName));
                bCSSLSocket.setParameters(bCSSLParameters);
            }
        }
        return socket;
    }

    protected BCSNIHostName getBCSNIHostName() {
        return SNIUtil.getBCSNIHostName(this.url);
    }
}

