/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.protege.editor.owl.model.entity.AutoIDGenerator;
import org.protege.editor.owl.model.entity.CustomLabelDescriptor;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.model.entity.IterativeAutoIDGenerator;
import org.protege.editor.owl.model.entity.LabelDescriptor;
import org.protege.editor.owl.model.entity.MatchRendererLabelDescriptor;
import org.protege.editor.owl.model.entity.RandomProlong;
import org.protege.editor.owl.model.entity.UniqueIdGenerator;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewEntitiesPreferencesPanel
extends OWLPreferencesPanel
implements ActionListener {
    private static final long serialVersionUID = -319986509127880607L;
    private static final String SEP_COLON = ":";
    private static final String SEP_HASH = "#";
    private static final String SEP_SLASH = "/";
    private final Logger logger = LoggerFactory.getLogger(NewEntitiesPreferencesPanel.class);
    private JRadioButton autoIDIriFragment;
    private JRadioButton colonButton;
    private JRadioButton hashButton;
    private JRadioButton nameAsIriFragment;
    private JRadioButton slashButton;
    private JRadioButton iriBaseActiveOntology;
    private JRadioButton iriBaseSpecifiedIri;
    private JTextField iriDefaultBaseField;
    private IRI labelAnnotation = null;
    private JButton annotationSelectButton;
    private JComboBox annotationLangSelector;
    private JLabel langLabel;
    private JLabel iriLabel;
    private JRadioButton customLabelButton;
    private JRadioButton sameAsRendererLabelButton;
    private JTextField annotationIriLabel;
    private JCheckBox saveIterativeIds;
    private JLabel digitCountLabel;
    private JLabel endLabel;
    private JLabel prefixLabel;
    private JLabel startLabel;
    private JLabel suffixLabel;
    private JPanel autoGeneratedIDPanel;
    private JRadioButton iterativeButton;
    private JRadioButton uniqueIdButton;
    private JSpinner autoIDEnd;
    private JSpinner autoIDStart;
    private JSpinner autoIDDigitCount;
    private JTextField autoIDPrefix;
    private JTextField autoIDSuffix;
    private JRadioButton ideIdButton;

    public void initialise() throws Exception {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.createEntityIriPanel());
        this.add(Box.createVerticalStrut(7));
        this.add(this.createEntityLabelPanel());
        this.add(Box.createVerticalStrut(7));
        this.add(this.createAutoGeneratedIDPanel());
    }

    private JPanel createEntityIriPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Entity IRI"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.insets = new Insets(12, 12, 0, 12);
        c.anchor = 23;
        panel.add((Component)new JLabel("Start with:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(12, 0, 0, 0);
        this.iriBaseActiveOntology = new JRadioButton("Active ontology IRI");
        this.iriBaseActiveOntology.setSelected(!EntityCreationPreferences.useDefaultBaseIRI());
        panel.add((Component)this.iriBaseActiveOntology, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 5);
        this.iriBaseSpecifiedIri = new JRadioButton("Specified IRI:");
        this.iriBaseSpecifiedIri.setSelected(EntityCreationPreferences.useDefaultBaseIRI());
        panel.add((Component)this.iriBaseSpecifiedIri, c);
        c.gridx = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 12);
        this.iriDefaultBaseField = new JTextField();
        this.iriDefaultBaseField.setText(EntityCreationPreferences.getDefaultBaseIRI().toString());
        panel.add((Component)this.iriDefaultBaseField, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.iriBaseActiveOntology);
        group.add(this.iriBaseSpecifiedIri);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 0;
        c.insets = new Insets(11, 12, 0, 12);
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Followed by:"), c);
        c.gridx = 1;
        c.insets = new Insets(11, 0, 0, 0);
        this.hashButton = new JRadioButton(SEP_HASH);
        this.hashButton.setSelected(EntityCreationPreferences.getDefaultSeparator().equals(SEP_HASH));
        panel.add((Component)this.hashButton, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        this.slashButton = new JRadioButton(SEP_SLASH);
        this.slashButton.setSelected(EntityCreationPreferences.getDefaultSeparator().equals(SEP_SLASH));
        panel.add((Component)this.slashButton, c);
        c.gridy = 4;
        c.insets = new Insets(0, 0, 0, 0);
        this.colonButton = new JRadioButton(SEP_COLON);
        this.colonButton.setSelected(EntityCreationPreferences.getDefaultSeparator().equals(SEP_COLON));
        panel.add((Component)this.colonButton, c);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.hashButton);
        group2.add(this.slashButton);
        group2.add(this.colonButton);
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(11, 12, 0, 12);
        panel.add((Component)new JLabel("End with:"), c);
        c.gridx = 1;
        c.insets = new Insets(11, 0, 0, 0);
        c.gridwidth = 2;
        this.nameAsIriFragment = new JRadioButton("User supplied name");
        this.nameAsIriFragment.setSelected(!EntityCreationPreferences.isFragmentAutoGenerated());
        this.nameAsIriFragment.addActionListener(e -> this.handleActionEndWithName());
        panel.add((Component)this.nameAsIriFragment, c);
        c.gridy = 6;
        c.insets = new Insets(0, 0, 12, 0);
        c.weighty = 1.0;
        this.autoIDIriFragment = new JRadioButton("Auto-generated ID");
        this.autoIDIriFragment.setSelected(EntityCreationPreferences.isFragmentAutoGenerated());
        this.autoIDIriFragment.addActionListener(e -> this.handleActionEndWithID());
        panel.add((Component)this.autoIDIriFragment, c);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.nameAsIriFragment);
        group3.add(this.autoIDIriFragment);
        return panel;
    }

    private JPanel createEntityLabelPanel() {
        Class<? extends LabelDescriptor> labelDescrCls = EntityCreationPreferences.getLabelDescriptorClass();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Entity Label (for use with Auto-generated ID)"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 23;
        c.insets = new Insets(0, 12, 0, 0);
        this.sameAsRendererLabelButton = new JRadioButton("Same as label renderer");
        this.sameAsRendererLabelButton.setSelected(labelDescrCls.equals(MatchRendererLabelDescriptor.class));
        panel.add((Component)this.sameAsRendererLabelButton, c);
        c.gridy = 1;
        this.customLabelButton = new JRadioButton("Custom label");
        this.customLabelButton.setSelected(labelDescrCls.equals(CustomLabelDescriptor.class));
        panel.add((Component)this.customLabelButton, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.sameAsRendererLabelButton);
        group.add(this.customLabelButton);
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = new Insets(5, 30, 0, 5);
        this.iriLabel = new JLabel("IRI");
        panel.add((Component)this.iriLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 1.0;
        this.annotationIriLabel = new JTextField();
        this.labelAnnotation = EntityCreationPreferences.getNameLabelIRI();
        if (this.labelAnnotation == null) {
            this.labelAnnotation = OWLRDFVocabulary.RDFS_LABEL.getIRI();
        }
        this.annotationIriLabel.setText(this.labelAnnotation.toString());
        this.annotationIriLabel.setEditable(false);
        panel.add((Component)this.annotationIriLabel, c);
        c.gridx = 2;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 12);
        c.weightx = 0.0;
        this.annotationSelectButton = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 7759812643136092837L;

            @Override
            public void actionPerformed(ActionEvent event) {
                NewEntitiesPreferencesPanel.this.handleSelectAnnotation();
            }
        });
        panel.add((Component)this.annotationSelectButton, c);
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(5, 30, 12, 5);
        this.langLabel = new JLabel("Lang");
        panel.add((Component)this.langLabel, c);
        c.gridx = 1;
        c.insets = new Insets(5, 0, 12, 0);
        c.weighty = 1.0;
        this.annotationLangSelector = new UIHelper(this.getOWLEditorKit()).getLanguageSelector();
        this.annotationLangSelector.setSelectedItem(EntityCreationPreferences.getNameLabelLang());
        panel.add((Component)this.annotationLangSelector, c);
        return panel;
    }

    private JPanel createAutoGeneratedIDPanel() {
        this.autoGeneratedIDPanel = new JPanel();
        this.autoGeneratedIDPanel.setLayout(new FlowLayout(3));
        this.autoGeneratedIDPanel.setBorder(new TitledBorder("Auto-generated ID"));
        JPanel interiorPanel = new JPanel(new BorderLayout(32, 0));
        interiorPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 0, 0));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        this.iterativeButton = new JRadioButton("Numeric (iterative)");
        this.uniqueIdButton = new JRadioButton("Globally unique");
        this.ideIdButton = new JRadioButton("Identitas");
        Class<? extends AutoIDGenerator> autoIDGenCls = EntityCreationPreferences.getAutoIDGeneratorClass();
        this.iterativeButton.setSelected(autoIDGenCls.equals(IterativeAutoIDGenerator.class));
        this.uniqueIdButton.setSelected(autoIDGenCls.equals(UniqueIdGenerator.class));
        this.ideIdButton.setSelected(autoIDGenCls.equals(RandomProlong.class));
        ButtonGroup group = new ButtonGroup();
        group.add(this.iterativeButton);
        group.add(this.uniqueIdButton);
        group.add(this.ideIdButton);
        this.iterativeButton.addActionListener(this);
        this.uniqueIdButton.addActionListener(this);
        this.ideIdButton.addActionListener(this);
        leftPanel.add(this.iterativeButton);
        leftPanel.add(this.uniqueIdButton);
        leftPanel.add(this.ideIdButton);
        leftPanel.add(Box.createVerticalGlue());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 22;
        this.prefixLabel = new JLabel("Prefix: ");
        centerPanel.add((Component)this.prefixLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 23;
        this.autoIDPrefix = new JTextField();
        this.autoIDPrefix.setText(EntityCreationPreferences.getPrefix());
        this.autoIDPrefix.setColumns(30);
        centerPanel.add((Component)this.autoIDPrefix, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 22;
        this.suffixLabel = new JLabel("Suffix: ");
        centerPanel.add((Component)this.suffixLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 23;
        this.autoIDSuffix = new JTextField();
        this.autoIDSuffix.setText(EntityCreationPreferences.getSuffix());
        this.autoIDSuffix.setColumns(30);
        centerPanel.add((Component)this.autoIDSuffix, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 22;
        this.digitCountLabel = new JLabel("Digit count: ");
        centerPanel.add((Component)this.digitCountLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 23;
        c.weightx = 0.5;
        this.autoIDDigitCount = new JSpinner(new SpinnerNumberModel(6, 0, 255, 1));
        this.autoIDDigitCount.setValue(EntityCreationPreferences.getAutoIDDigitCount());
        this.autoIDDigitCount.setPreferredSize(new Dimension(100, 20));
        centerPanel.add((Component)this.autoIDDigitCount, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.anchor = 22;
        this.startLabel = new JLabel("Start: ");
        this.startLabel.setEnabled(this.iterativeButton.isSelected());
        centerPanel.add((Component)this.startLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 23;
        this.autoIDStart = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.autoIDStart.setPreferredSize(new Dimension(100, 20));
        this.autoIDStart.setValue(EntityCreationPreferences.getAutoIDStart());
        this.autoIDStart.setEnabled(this.iterativeButton.isSelected());
        this.autoIDStart.addChangeListener(event -> {
            if ((Integer)this.autoIDEnd.getValue() != -1 && (Integer)this.autoIDEnd.getValue() <= (Integer)this.autoIDStart.getValue()) {
                this.autoIDEnd.setValue(this.autoIDStart.getValue());
            }
        });
        centerPanel.add((Component)this.autoIDStart, c);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 22;
        this.endLabel = new JLabel("End: ");
        this.endLabel.setEnabled(this.iterativeButton.isSelected());
        centerPanel.add((Component)this.endLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 23;
        this.autoIDEnd = new JSpinner(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        this.autoIDEnd.setPreferredSize(new Dimension(100, 20));
        this.autoIDEnd.setValue(EntityCreationPreferences.getAutoIDEnd());
        this.autoIDEnd.setEnabled(this.iterativeButton.isSelected());
        this.autoIDEnd.addChangeListener(event -> {
            if ((Integer)this.autoIDEnd.getValue() != -1 && (Integer)this.autoIDEnd.getValue() <= (Integer)this.autoIDStart.getValue()) {
                this.autoIDStart.setValue(this.autoIDEnd.getValue());
            }
        });
        centerPanel.add((Component)this.autoIDEnd, c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 2;
        c.fill = 2;
        c.weighty = 1.0;
        this.saveIterativeIds = new JCheckBox("Remember last ID between Prot\u00e9g\u00e9 sessions");
        this.saveIterativeIds.setSelected(EntityCreationPreferences.getSaveAutoIDStart());
        this.saveIterativeIds.setEnabled(this.iterativeButton.isSelected());
        centerPanel.add((Component)this.saveIterativeIds, c);
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        centerPanel.add(new JLabel(""));
        this.enableAutoGeneratedIDPanel(this.autoIDIriFragment.isSelected());
        this.enableLabelCreationPanel(this.autoIDIriFragment.isSelected());
        interiorPanel.add((Component)leftPanel, "Before");
        interiorPanel.add((Component)centerPanel, "Center");
        this.autoGeneratedIDPanel.add(interiorPanel);
        return this.autoGeneratedIDPanel;
    }

    private void enableAutoGeneratedIDPanel(boolean b) {
        this.autoIDDigitCount.setEnabled(b);
        this.autoIDEnd.setEnabled(b);
        this.autoIDPrefix.setEnabled(b);
        this.autoIDStart.setEnabled(b);
        this.autoIDSuffix.setEnabled(b);
        this.autoGeneratedIDPanel.setEnabled(b);
        this.digitCountLabel.setEnabled(b);
        this.endLabel.setEnabled(b);
        this.iterativeButton.setEnabled(b);
        this.prefixLabel.setEnabled(b);
        this.saveIterativeIds.setEnabled(b);
        this.startLabel.setEnabled(b);
        this.suffixLabel.setEnabled(b);
        this.uniqueIdButton.setEnabled(b);
        this.ideIdButton.setEnabled(b);
        this.enableNumericIterativeOptions(this.iterativeButton.isSelected() && this.iterativeButton.isEnabled());
    }

    private void enableLabelCreationPanel(boolean b) {
        this.annotationSelectButton.setEnabled(b);
        this.annotationLangSelector.setEnabled(b);
        this.customLabelButton.setEnabled(b);
        this.sameAsRendererLabelButton.setEnabled(b);
        this.annotationIriLabel.setEnabled(b);
    }

    private void enableNumericIterativeOptions(boolean b) {
        this.startLabel.setEnabled(b);
        this.autoIDStart.setEnabled(b);
        this.endLabel.setEnabled(b);
        this.autoIDEnd.setEnabled(b);
        this.saveIterativeIds.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.iterativeButton) {
            this.enableNumericIterativeOptions(true);
        } else if (object == this.uniqueIdButton) {
            this.enableNumericIterativeOptions(false);
        } else if (object == this.ideIdButton) {
            this.enableNumericIterativeOptions(false);
        }
    }

    public void applyChanges() {
        EntityCreationPreferences.setUseDefaultBaseIRI(this.iriBaseSpecifiedIri.isSelected());
        try {
            IRI defaultBase = IRI.create((URI)new URI(this.iriDefaultBaseField.getText()));
            EntityCreationPreferences.setDefaultBaseIRI(defaultBase);
        }
        catch (URISyntaxException e) {
            this.logger.error("Ignoring invalid base IRI ({})", (Object)this.iriDefaultBaseField.getText(), (Object)e);
        }
        if (this.hashButton.isSelected()) {
            EntityCreationPreferences.setDefaultSeparator(SEP_HASH);
        } else if (this.slashButton.isSelected()) {
            EntityCreationPreferences.setDefaultSeparator(SEP_SLASH);
        } else if (this.colonButton.isSelected()) {
            EntityCreationPreferences.setDefaultSeparator(SEP_COLON);
        }
        EntityCreationPreferences.setFragmentAutoGenerated(this.autoIDIriFragment.isSelected());
        EntityCreationPreferences.setGenerateNameLabel(this.autoIDIriFragment.isSelected());
        EntityCreationPreferences.setGenerateIDLabel(false);
        if (this.sameAsRendererLabelButton.isSelected()) {
            EntityCreationPreferences.setLabelDescriptorClass(MatchRendererLabelDescriptor.class);
        }
        if (this.customLabelButton.isSelected()) {
            EntityCreationPreferences.setLabelDescriptorClass(CustomLabelDescriptor.class);
        }
        EntityCreationPreferences.setNameLabelIRI(IRI.create((String)this.annotationIriLabel.getText()));
        Object lang = this.annotationLangSelector.getSelectedItem();
        if (lang != null && !lang.equals("")) {
            EntityCreationPreferences.setNameLabelLang((String)lang);
        } else {
            EntityCreationPreferences.setNameLabelLang(null);
        }
        if (this.iterativeButton.isSelected()) {
            EntityCreationPreferences.setAutoIDGeneratorClass(IterativeAutoIDGenerator.class);
        }
        if (this.uniqueIdButton.isSelected()) {
            EntityCreationPreferences.setAutoIDGeneratorClass(UniqueIdGenerator.class);
        }
        if (this.ideIdButton.isSelected()) {
            EntityCreationPreferences.setAutoIDGeneratorClass(RandomProlong.class);
        }
        EntityCreationPreferences.setAutoIDStart((Integer)this.autoIDStart.getValue());
        EntityCreationPreferences.setAutoIDEnd((Integer)this.autoIDEnd.getValue());
        EntityCreationPreferences.setAutoIDDigitCount((Integer)this.autoIDDigitCount.getValue());
        EntityCreationPreferences.setPrefix(this.autoIDPrefix.getText());
        EntityCreationPreferences.setSuffix(this.autoIDSuffix.getText());
        EntityCreationPreferences.setSaveAutoIDStart(this.saveIterativeIds.isSelected());
    }

    private void handleActionEndWithID() {
        boolean selected = this.autoIDIriFragment.isSelected();
        this.enableAutoGeneratedIDPanel(selected);
        this.enableLabelCreationPanel(selected);
    }

    private void handleActionEndWithName() {
        boolean selected = this.nameAsIriFragment.isSelected();
        if (selected) {
            this.enableAutoGeneratedIDPanel(false);
            this.enableLabelCreationPanel(false);
        }
    }

    protected void handleSelectAnnotation() {
        OWLAnnotationProperty prop = new UIHelper(this.getOWLEditorKit()).pickAnnotationProperty();
        if (prop != null) {
            this.labelAnnotation = prop.getIRI();
            this.annotationIriLabel.setText(this.labelAnnotation.toString());
        }
    }

    public IRI getFirstRendererLabel() {
        List<IRI> iris = OWLRendererPreferences.getInstance().getAnnotationIRIs();
        if (!iris.isEmpty()) {
            return iris.get(0);
        }
        return OWLRDFVocabulary.RDFS_LABEL.getIRI();
    }

    public void dispose() throws Exception {
    }
}

