/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.http.WebConnection;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private static final StringManager sm = StringManager.getManager(WsRemoteEndpointImplServer.class);
    private final Log log = LogFactory.getLog(WsRemoteEndpointImplServer.class);
    private final SocketWrapperBase<?> socketWrapper;
    private final UpgradeInfo upgradeInfo;
    private final WebConnection connection;
    private final WsWriteTimeout wsWriteTimeout;
    private volatile SendHandler handler = null;
    private volatile ByteBuffer[] buffers = null;
    private volatile long timeoutExpiry = -1L;

    public WsRemoteEndpointImplServer(SocketWrapperBase<?> socketWrapperBase, UpgradeInfo upgradeInfo, WsServerContainer wsServerContainer, WebConnection webConnection) {
        this.socketWrapper = socketWrapperBase;
        this.upgradeInfo = upgradeInfo;
        this.connection = webConnection;
        this.wsWriteTimeout = wsServerContainer.getTimeout();
    }

    @Override
    protected final boolean isMasked() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean acquireMessagePartInProgressSemaphore(byte by, long l) throws InterruptedException {
        if (this.socketWrapper.getLock() instanceof ReentrantLock) {
            ReentrantLock reentrantLock = (ReentrantLock)this.socketWrapper.getLock();
            if (by == 8 && reentrantLock.isHeldByCurrentThread()) {
                int n = reentrantLock.getHoldCount();
                while (!this.messagePartInProgress.tryAcquire()) {
                    int n2;
                    if (l < System.currentTimeMillis()) {
                        return false;
                    }
                    try {
                        this.socketWrapper.setCurrentProcessor((Object)this.connection);
                        for (n2 = 0; n2 < n; ++n2) {
                            this.socketWrapper.getLock().unlock();
                        }
                        Thread.yield();
                    }
                    finally {
                        for (n2 = 0; n2 < n; ++n2) {
                            this.socketWrapper.getLock().lock();
                        }
                        this.socketWrapper.takeCurrentProcessor();
                    }
                }
                return true;
            }
        }
        return super.acquireMessagePartInProgressSemaphore(by, l);
    }

    @Override
    protected void doWrite(final SendHandler sendHandler, final long l, ByteBuffer ... byteBufferArray) {
        if (this.socketWrapper.hasAsyncIO()) {
            final boolean bl = l != -1L;
            long l2 = -1L;
            if (bl) {
                l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) {
                    SendResult sendResult = new SendResult((Throwable)new SocketTimeoutException());
                    sendHandler.onResult(sendResult);
                    return;
                }
            } else {
                this.handler = sendHandler;
                l2 = this.getSendTimeout();
                if (l2 > 0L) {
                    this.timeoutExpiry = l2 + System.currentTimeMillis();
                    this.wsWriteTimeout.register(this);
                }
            }
            this.socketWrapper.write(bl ? SocketWrapperBase.BlockingMode.BLOCK : SocketWrapperBase.BlockingMode.SEMI_BLOCK, l2, TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE_WITH_COMPLETION, (CompletionHandler)new CompletionHandler<Long, Void>(){

                @Override
                public void completed(Long l3, Void void_) {
                    if (bl) {
                        long l2 = l - System.currentTimeMillis();
                        if (l2 <= 0L) {
                            this.failed((Throwable)new SocketTimeoutException(), null);
                        } else {
                            sendHandler.onResult(SENDRESULT_OK);
                        }
                    } else {
                        WsRemoteEndpointImplServer.this.wsWriteTimeout.unregister(WsRemoteEndpointImplServer.this);
                        WsRemoteEndpointImplServer.this.clearHandler(null, true);
                    }
                }

                @Override
                public void failed(Throwable throwable, Void void_) {
                    if (bl) {
                        SendResult sendResult = new SendResult(throwable);
                        sendHandler.onResult(sendResult);
                    } else {
                        WsRemoteEndpointImplServer.this.wsWriteTimeout.unregister(WsRemoteEndpointImplServer.this);
                        WsRemoteEndpointImplServer.this.clearHandler(throwable, true);
                        WsRemoteEndpointImplServer.this.close();
                    }
                }
            }, byteBufferArray);
        } else if (l == -1L) {
            this.handler = sendHandler;
            this.buffers = byteBufferArray;
            this.onWritePossible(true);
        } else {
            try {
                for (ByteBuffer byteBuffer : byteBufferArray) {
                    long l3 = l - System.currentTimeMillis();
                    if (l3 <= 0L) {
                        SendResult sendResult = new SendResult((Throwable)new SocketTimeoutException());
                        sendHandler.onResult(sendResult);
                        return;
                    }
                    this.socketWrapper.setWriteTimeout(l3);
                    this.socketWrapper.write(true, byteBuffer);
                }
                long l4 = l - System.currentTimeMillis();
                if (l4 <= 0L) {
                    SendResult sendResult = new SendResult((Throwable)new SocketTimeoutException());
                    sendHandler.onResult(sendResult);
                    return;
                }
                this.socketWrapper.setWriteTimeout(l4);
                this.socketWrapper.flush(true);
                sendHandler.onResult(SENDRESULT_OK);
            }
            catch (IOException iOException) {
                SendResult sendResult = new SendResult((Throwable)iOException);
                sendHandler.onResult(sendResult);
            }
        }
    }

    @Override
    protected void updateStats(long l) {
        this.upgradeInfo.addMsgsSent(1L);
        this.upgradeInfo.addBytesSent(l);
    }

    public void onWritePossible(boolean bl) {
        long l;
        ByteBuffer[] byteBufferArray = this.buffers;
        if (byteBufferArray == null) {
            return;
        }
        boolean bl2 = false;
        try {
            this.socketWrapper.flush(false);
            while (this.socketWrapper.isReadyForWrite()) {
                bl2 = true;
                for (ByteBuffer byteBuffer : byteBufferArray) {
                    if (!byteBuffer.hasRemaining()) continue;
                    bl2 = false;
                    this.socketWrapper.write(false, byteBuffer);
                    break;
                }
                if (!bl2) continue;
                this.socketWrapper.flush(false);
                bl2 = this.socketWrapper.isReadyForWrite();
                if (bl2) {
                    this.wsWriteTimeout.unregister(this);
                    this.clearHandler(null, bl);
                }
                break;
            }
        }
        catch (IOException | IllegalStateException exception) {
            this.wsWriteTimeout.unregister(this);
            this.clearHandler(exception, bl);
            this.close();
        }
        if (!bl2 && (l = this.getSendTimeout()) > 0L) {
            this.timeoutExpiry = l + System.currentTimeMillis();
            this.wsWriteTimeout.register(this);
        }
    }

    @Override
    protected void doClose() {
        block3: {
            if (this.handler != null) {
                this.clearHandler(new EOFException(), true);
            }
            try {
                this.socketWrapper.close();
            }
            catch (Exception exception) {
                if (!this.log.isInfoEnabled()) break block3;
                this.log.info((Object)sm.getString("wsRemoteEndpointServer.closeFailed"), (Throwable)exception);
            }
        }
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout(boolean bl) {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException(), bl);
        }
        this.close();
    }

    @Override
    protected void setTransformation(Transformation transformation) {
        super.setTransformation(transformation);
    }

    void clearHandler(Throwable throwable, boolean bl) {
        SendHandler sendHandler = this.handler;
        this.handler = null;
        this.buffers = null;
        if (sendHandler != null) {
            if (bl) {
                OnResultRunnable onResultRunnable = new OnResultRunnable(sendHandler, throwable);
                try {
                    this.socketWrapper.execute((Runnable)onResultRunnable);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    onResultRunnable.run();
                }
            } else if (throwable == null) {
                sendHandler.onResult(new SendResult());
            } else {
                sendHandler.onResult(new SendResult(throwable));
            }
        }
    }

    @Override
    protected Lock getLock() {
        return this.socketWrapper.getLock();
    }

    private static class OnResultRunnable
    implements Runnable {
        private final SendHandler sh;
        private final Throwable t;

        private OnResultRunnable(SendHandler sendHandler, Throwable throwable) {
            this.sh = sendHandler;
            this.t = throwable;
        }

        @Override
        public void run() {
            if (this.t == null) {
                this.sh.onResult(new SendResult());
            } else {
                this.sh.onResult(new SendResult(this.t));
            }
        }
    }
}

