/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public class NodeTreeModel
extends DefaultTreeModel {
    static final long serialVersionUID = 1900670294524747212L;
    private static final Logger LOG = Logger.getLogger(NodeTreeModel.class.getName());
    private transient Listener listener;
    private CopyOnWriteArrayList<TreeView> views = new CopyOnWriteArrayList();

    void addView(TreeView treeView) {
        this.views.add(treeView);
    }

    public NodeTreeModel() {
        super(VisualizerNode.EMPTY, true);
    }

    public NodeTreeModel(Node node) {
        super(VisualizerNode.EMPTY, true);
        this.doCallSetNode(node);
    }

    final void doCallSetNode(Node node) {
        this.setNode(node);
    }

    public void setNode(Node node) {
        this.setNode(node, null);
    }

    void setNode(final Node node, final TreeView.VisualizerHolder visualizerHolder) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                VisualizerNode visualizerNode;
                VisualizerNode visualizerNode2 = (VisualizerNode)NodeTreeModel.this.getRoot();
                if (visualizerNode2 == (visualizerNode = VisualizerNode.getVisualizer(null, node))) {
                    return;
                }
                visualizerNode2.removeNodeModel(NodeTreeModel.this.listener());
                visualizerNode.addNodeModel(NodeTreeModel.this.listener());
                NodeTreeModel.this.setRoot(visualizerNode);
                if (visualizerHolder != null) {
                    visualizerHolder.add(visualizerNode.getChildren());
                    visualizerHolder.removeRecur(visualizerNode2.getChildren());
                }
            }
        });
    }

    private Listener listener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        if (treePath == null) {
            return;
        }
        Object object2 = treePath.getLastPathComponent();
        if (object2 instanceof VisualizerNode) {
            this.nodeChanged((VisualizerNode)object2);
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)object2;
        mutableTreeNode.setUserObject(object);
        this.nodeChanged(mutableTreeNode);
    }

    void nodesWereInsertedInternal(VisualizerEvent visualizerEvent) {
        if (this.listenerList == null) {
            return;
        }
        VisualizerNode visualizerNode = visualizerEvent.getVisualizer();
        Object[] objectArray = this.getPathToRoot(visualizerNode);
        Object[] objectArray2 = this.listenerList.getListenerList();
        TreeModelEventImpl treeModelEventImpl = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEventImpl == null) {
                treeModelEventImpl = new TreeModelEventImpl(this, objectArray, visualizerEvent);
            }
            try {
                ((TreeModelListener)objectArray2[i + 1]).treeNodesInserted(treeModelEventImpl);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LOG.log(Level.WARNING, "Visualizer: {0}", visualizerNode);
                Node node = Visualizer.findNode(visualizerNode);
                LOG.log(Level.WARNING, "Node: {0}", node);
                if (node != null) {
                    LOG.log(Level.WARNING, "  # children: {0}", node.getChildren().getNodesCount());
                    LOG.log(Level.WARNING, "  children: {0}", node.getChildren().getClass());
                }
                LOG.log(Level.WARNING, "Path: {0}", Arrays.toString(objectArray));
                LOG.log(Level.WARNING, "ev.getArray: {0}", Arrays.toString(visualizerEvent.getArray()));
                LOG.log(Level.WARNING, "ev.getSnapshot: {0}", visualizerEvent.getSnapshot());
                throw indexOutOfBoundsException;
            }
        }
    }

    static Object[] computeChildren(VisualizerEvent visualizerEvent) {
        int[] nArray = visualizerEvent.getArray();
        Object[] objectArray = new Object[nArray.length];
        List<Node> list = visualizerEvent.getSnapshot();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = Visualizer.findVisualizer(list.get(nArray[i]));
        }
        return objectArray;
    }

    private static class TreeModelEventImpl
    extends TreeModelEvent {
        private final VisualizerEvent ev;

        public TreeModelEventImpl(Object object, Object[] objectArray, VisualizerEvent visualizerEvent) {
            super(object, objectArray, visualizerEvent.getArray(), null);
            this.ev = visualizerEvent;
        }

        @Override
        public Object[] getChildren() {
            if (this.children == null) {
                this.children = NodeTreeModel.computeChildren(this.ev);
            }
            return this.children;
        }
    }

    private static final class Listener
    implements NodeModel {
        private Reference<NodeTreeModel> model;

        public Listener(NodeTreeModel nodeTreeModel) {
            this.model = new WeakReference<NodeTreeModel>(nodeTreeModel);
        }

        private NodeTreeModel get(VisualizerEvent visualizerEvent) {
            NodeTreeModel nodeTreeModel = this.model.get();
            if (nodeTreeModel == null && visualizerEvent != null) {
                visualizerEvent.getVisualizer().removeNodeModel(this);
                return null;
            }
            return nodeTreeModel;
        }

        @Override
        public void added(VisualizerEvent.Added added) {
            NodeTreeModel nodeTreeModel = this.get(added);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodesWereInsertedInternal(added);
        }

        @Override
        public void removed(VisualizerEvent.Removed removed) {
            NodeTreeModel nodeTreeModel = this.get(removed);
            if (nodeTreeModel == null) {
                return;
            }
            for (TreeView treeView : nodeTreeModel.views) {
                treeView.removedNodes(removed.removed);
            }
            nodeTreeModel.nodesWereRemoved(removed.getVisualizer(), removed.getArray(), removed.removed.toArray());
        }

        @Override
        public void reordered(VisualizerEvent.Reordered reordered) {
            NodeTreeModel nodeTreeModel = this.get(reordered);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodeStructureChanged(reordered.getVisualizer());
        }

        @Override
        public void update(VisualizerNode visualizerNode) {
            NodeTreeModel nodeTreeModel = this.get(null);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodeChanged(visualizerNode);
        }

        @Override
        public void structuralChange(VisualizerNode visualizerNode) {
            NodeTreeModel nodeTreeModel = this.get(null);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodeStructureChanged(visualizerNode);
        }
    }
}

