/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Collection;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.util.HaltingThread;

public class DynamicRenderer
extends StaticRenderer {
    static final int COPY_OVERHEAD = 1000;
    static final int COPY_LINE_OVERHEAD = 10;
    RectListManager damagedAreas;

    public DynamicRenderer() {
    }

    public DynamicRenderer(RenderingHints renderingHints, AffineTransform affineTransform) {
        super(renderingHints, affineTransform);
    }

    @Override
    protected CachableRed setupCache(CachableRed cachableRed) {
        return cachableRed;
    }

    @Override
    public void flush(Rectangle rectangle) {
    }

    @Override
    public void flush(Collection collection) {
    }

    @Override
    protected void updateWorkingBuffers() {
        if (this.rootFilter == null) {
            this.rootFilter = this.rootGN.getGraphicsNodeRable(true);
            this.rootCR = null;
        }
        this.rootCR = this.renderGNR();
        if (this.rootCR == null) {
            this.workingRaster = null;
            this.workingOffScreen = null;
            this.workingBaseRaster = null;
            this.currentOffScreen = null;
            this.currentBaseRaster = null;
            this.currentRaster = null;
            return;
        }
        SampleModel sampleModel = this.rootCR.getSampleModel();
        int n = this.offScreenWidth;
        int n2 = this.offScreenHeight;
        if (this.workingBaseRaster == null || this.workingBaseRaster.getWidth() < n || this.workingBaseRaster.getHeight() < n2) {
            sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
            this.workingBaseRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
            this.workingRaster = this.workingBaseRaster.createWritableChild(0, 0, n, n2, 0, 0, null);
            this.workingOffScreen = new BufferedImage(this.rootCR.getColorModel(), this.workingRaster, this.rootCR.getColorModel().isAlphaPremultiplied(), null);
        }
        if (!this.isDoubleBuffered) {
            this.currentOffScreen = this.workingOffScreen;
            this.currentBaseRaster = this.workingBaseRaster;
            this.currentRaster = this.workingRaster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint(RectListManager rectListManager) {
        if (rectListManager == null) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootCR == null || this.workingBaseRaster == null) {
            return;
        }
        CachableRed cachableRed = this.rootCR;
        WritableRaster writableRaster = this.workingBaseRaster;
        WritableRaster writableRaster2 = this.workingRaster;
        Rectangle rectangle = this.rootCR.getBounds();
        Rectangle rectangle2 = this.workingRaster.getBounds();
        if (rectangle2.x < rectangle.x || rectangle2.y < rectangle.y || rectangle2.x + rectangle2.width > rectangle.x + rectangle.width || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        }
        boolean bl = false;
        Rectangle rectangle3 = writableRaster2.getBounds();
        Rectangle rectangle4 = null;
        if (this.currentRaster != null) {
            rectangle4 = this.currentRaster.getBounds();
        }
        Object object = writableRaster;
        synchronized (object) {
            if (bl) {
                cachableRed.copyData(writableRaster2);
            } else {
                WritableRaster writableRaster3;
                Color color;
                Color color2;
                Graphics2D graphics2D = null;
                if (this.isDoubleBuffered && this.currentRaster != null && this.damagedAreas != null) {
                    this.damagedAreas.subtract(rectListManager, 1000, 10);
                    this.damagedAreas.mergeRects(1000, 10);
                    color2 = new Color(0, 0, 255, 50);
                    color = new Color(0, 0, 0, 50);
                    for (Rectangle rectangle5 : this.damagedAreas) {
                        if (!rectangle3.intersects(rectangle5)) continue;
                        rectangle5 = rectangle3.intersection(rectangle5);
                        if (rectangle4 != null && !rectangle4.intersects(rectangle5)) continue;
                        rectangle5 = rectangle4.intersection(rectangle5);
                        writableRaster3 = this.currentRaster.createWritableChild(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, rectangle5.x, rectangle5.y, null);
                        GraphicsUtil.copyData((Raster)writableRaster3, (WritableRaster)writableRaster2);
                        if (graphics2D == null) continue;
                        graphics2D.setPaint(color2);
                        graphics2D.fill(rectangle5);
                        graphics2D.setPaint(color);
                        graphics2D.draw(rectangle5);
                    }
                }
                color2 = new Color(255, 0, 0, 50);
                color = new Color(0, 0, 0, 50);
                for (Rectangle rectangle5 : rectListManager) {
                    if (!rectangle3.intersects(rectangle5)) continue;
                    rectangle5 = rectangle3.intersection(rectangle5);
                    writableRaster3 = writableRaster2.createWritableChild(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, rectangle5.x, rectangle5.y, null);
                    cachableRed.copyData(writableRaster3);
                    if (graphics2D == null) continue;
                    graphics2D.setPaint(color2);
                    graphics2D.fill(rectangle5);
                    graphics2D.setPaint(color);
                    graphics2D.draw(rectangle5);
                }
            }
        }
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        object = this.workingOffScreen;
        this.workingBaseRaster = this.currentBaseRaster;
        this.workingRaster = this.currentRaster;
        this.workingOffScreen = this.currentOffScreen;
        this.currentRaster = writableRaster2;
        this.currentBaseRaster = writableRaster;
        this.currentOffScreen = object;
        this.damagedAreas = rectListManager;
    }
}

