/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.util.Range;
import info.monitorenter.util.units.AUnit;
import info.monitorenter.util.units.UnitUnchanged;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class ALabelFormatter
implements IAxisLabelFormatter {
    public static final AUnit UNIT_UNCHANGED = new UnitUnchanged();
    private IAxis m_axis;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);

    protected ALabelFormatter() {
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public IAxis getAxis() {
        return this.m_axis;
    }

    public int getMaxAmountChars() {
        int fractionDigits = 0;
        Range range = this.m_axis.getRange();
        double dRange = range.getExtent();
        if (dRange < 1.0) {
            if (dRange == 0.0) {
                fractionDigits = 1;
            } else {
                while (dRange < 1.0) {
                    dRange *= 10.0;
                    ++fractionDigits;
                }
            }
        } else {
            if (dRange == 0.0) {
                dRange = 1.0;
            }
            fractionDigits = dRange < 10.0 ? 2 : (dRange < 100.0 ? 1 : 0);
        }
        int integerDigits = 0;
        double max = range.getMax();
        double min = Math.abs(range.getMin());
        if (max == 0.0 && min == 0.0) {
            integerDigits = 1;
        } else if (max < min) {
            while (min > 1.0) {
                min /= 10.0;
                ++integerDigits;
            }
        } else {
            while (max > 1.0) {
                max /= 10.0;
                ++integerDigits;
            }
        }
        return 1 + integerDigits + 1 + fractionDigits;
    }

    public AUnit getUnit() {
        return UNIT_UNCHANGED;
    }

    public void initPaintIteration() {
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setAxis(IAxis axis) {
        this.m_axis = axis;
    }
}

