/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.fibs.geotag.Settings;
import org.fibs.geotag.gpsbabel.GPSBabel;
import org.fibs.geotag.gui.settings.BooleanSettingsPanel;
import org.fibs.geotag.gui.settings.ChoiceSettingsPanel;
import org.fibs.geotag.gui.settings.FileSettingsPanel;
import org.fibs.geotag.gui.settings.FontSettingsPanel;
import org.fibs.geotag.gui.settings.IntegerSettingsPanel;
import org.fibs.geotag.gui.settings.SettingsPanel;
import org.fibs.geotag.gui.settings.StringSettingsPanel;
import org.fibs.geotag.util.Coordinates;
import org.fibs.geotag.util.FontUtil;
import org.fibs.geotag.util.OperatingSystem;
import org.fibs.geotag.util.Proxies;
import org.fibs.geotag.util.Units;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SettingsDialog
extends JDialog
implements TreeSelectionListener {
    private static final I18n i18n = I18nFactory.getI18n(SettingsDialog.class);
    private JFrame parent;
    private List<SettingsPanel> panelList = new ArrayList<SettingsPanel>();
    private JPanel treeAndSettingsPanel;
    private SettingsPanel visibleSettingsPanel = null;
    private JTree tree;

    public SettingsDialog(JFrame parent) {
        super(parent, i18n.tr("Settings"), true);
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.treeAndSettingsPanel = new JPanel();
        this.treeAndSettingsPanel.setLayout(new BorderLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(i18n.tr("Settings"));
        this.createTreeNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.treeAndSettingsPanel.add((Component)treeView, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.add((Component)this.treeAndSettingsPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            SettingsPanel panel = (SettingsPanel)nodeInfo;
            if (this.visibleSettingsPanel != null) {
                this.treeAndSettingsPanel.remove(this.visibleSettingsPanel);
                this.treeAndSettingsPanel.validate();
            }
            this.treeAndSettingsPanel.add((Component)panel, "South");
            this.visibleSettingsPanel = panel;
            this.pack();
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        String ok = i18n.tr("OK");
        String cancel = i18n.tr("Cancel");
        JButton okButton = new JButton(ok);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SettingsPanel settingsPanel : SettingsDialog.this.getPanelList()) {
                    settingsPanel.save();
                }
                Settings.flush();
                SettingsDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(cancel);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        FontMetrics fontMetrics = okButton.getFontMetrics(okButton.getFont());
        int preferredWidth = Math.max(fontMetrics.stringWidth(ok), fontMetrics.stringWidth(cancel)) * 2;
        Dimension preferredSize = okButton.getPreferredSize();
        preferredSize.width = preferredWidth;
        okButton.setPreferredSize(preferredSize);
        cancelButton.setPreferredSize(preferredSize);
        Dimension minimumSize = this.parent.getSize();
        minimumSize.height /= 2;
        minimumSize.width /= 2;
        this.setMinimumSize(minimumSize);
        return buttonPanel;
    }

    private void addPanel(DefaultMutableTreeNode parentNode, SettingsPanel panel) {
        this.panelList.add(panel);
        DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(panel);
        parentNode.add(leaf);
    }

    private void createTreeNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode general = new DefaultMutableTreeNode(i18n.tr("General settings"));
        IntegerSettingsPanel mouseClicks = new IntegerSettingsPanel(this.parent, i18n.tr("Mouse click count to edit"), Settings.SETTING.CLICKS_TO_EDIT, 1, 1, 2, 1);
        this.addPanel(general, mouseClicks);
        FontSettingsPanel font = new FontSettingsPanel(this.parent, i18n.tr("Font"), Settings.SETTING.FONT, FontUtil.fontToID(UIManager.getLookAndFeel().getDefaults().getFont("Table.font")));
        this.addPanel(general, font);
        BooleanSettingsPanel tooltipThumbnails = new BooleanSettingsPanel(this.parent, i18n.tr("Show thumbnail images in tooltips"), Settings.SETTING.TUMBNAILS_IN_TOOLTIPS, true);
        this.addPanel(general, tooltipThumbnails);
        IntegerSettingsPanel thumbnailsSize = new IntegerSettingsPanel(this.parent, i18n.tr("Thumbnail size"), Settings.SETTING.THUMBNAIL_SIZE, 150, 100, 800, 10);
        this.addPanel(general, thumbnailsSize);
        BooleanSettingsPanel xmpOnly = new BooleanSettingsPanel(this.parent, i18n.tr("Always write to XMP files"), Settings.SETTING.XMP_FILES_ONLY, false);
        this.addPanel(general, xmpOnly);
        BooleanSettingsPanel updates = new BooleanSettingsPanel(this.parent, i18n.tr("Check for updates"), Settings.SETTING.CHECK_FOR_NEW_VERSION, true);
        this.addPanel(general, updates);
        ChoiceSettingsPanel distances = new ChoiceSettingsPanel(this.parent, i18n.tr("Distance unit"), Settings.SETTING.DISTANCE_UNIT, Units.getDistanceUnitNames(), 0);
        this.addPanel(general, distances);
        ChoiceSettingsPanel altitudes = new ChoiceSettingsPanel(this.parent, i18n.tr("Altitude unit"), Settings.SETTING.ALTITUDE_UNIT, Units.getAltitudeUnitNames(), 0);
        this.addPanel(general, altitudes);
        ChoiceSettingsPanel coordinates = new ChoiceSettingsPanel(this.parent, i18n.tr("Coordinate format"), Settings.SETTING.COORDINATES_FORMAT, Coordinates.FORMAT_NAMES, 0);
        this.addPanel(general, coordinates);
        ChoiceSettingsPanel proxyType = new ChoiceSettingsPanel(this.parent, i18n.tr("Proxy type"), Settings.SETTING.PROXY_TYPE, Proxies.PROXY_TYPES, 0);
        this.addPanel(general, proxyType);
        StringSettingsPanel proxyAddress = new StringSettingsPanel(this.parent, i18n.tr("Proxy address (host:port)"), Settings.SETTING.PROXY_ADDRESS, "");
        this.addPanel(general, proxyAddress);
        StringSettingsPanel xmpFileTypes = new StringSettingsPanel(this.parent, i18n.tr("Additional image file types with XMP"), Settings.SETTING.FILE_TYPES_SUPPORTED_BY_XMP, "");
        this.addPanel(general, xmpFileTypes);
        top.add(general);
        DefaultMutableTreeNode external = this.createExternalTreeNodes();
        top.add(external);
        DefaultMutableTreeNode export = new DefaultMutableTreeNode(i18n.tr("Export"));
        DefaultMutableTreeNode googleearth = new DefaultMutableTreeNode(i18n.tr("Google Earth"));
        BooleanSettingsPanel imagesInKmz = new BooleanSettingsPanel(this.parent, i18n.tr("Store thumbnails in KMZ files"), Settings.SETTING.KMZ_STORE_THUMBNAILS, false);
        this.addPanel(googleearth, imagesInKmz);
        StringSettingsPanel kmlImagePath = new StringSettingsPanel(this.parent, i18n.tr("KML image path"), Settings.SETTING.KML_IMAGE_PATH, "");
        this.addPanel(googleearth, kmlImagePath);
        StringSettingsPanel kmlIconUrl = new StringSettingsPanel(this.parent, i18n.tr("KML icon URL"), Settings.SETTING.KML_ICON_URL, "http://maps.google.com/mapfiles/kml/pal4/icon46.png");
        this.addPanel(googleearth, kmlIconUrl);
        StringSettingsPanel kmlDescriptionHeader = new StringSettingsPanel(this.parent, i18n.tr("KML description header"), Settings.SETTING.KML_DESCRIPTION_HEADER, "");
        this.addPanel(googleearth, kmlDescriptionHeader);
        StringSettingsPanel kmlDescriptionFooter = new StringSettingsPanel(this.parent, i18n.tr("KML description footer"), Settings.SETTING.KML_DESCRIPTION_FOOTER, "");
        this.addPanel(googleearth, kmlDescriptionFooter);
        export.add(googleearth);
        top.add(export);
        DefaultMutableTreeNode location = new DefaultMutableTreeNode(i18n.tr("Place name look up"));
        DefaultMutableTreeNode geonames = this.createGeonamesTreeNodes();
        location.add(geonames);
        top.add(location);
    }

    private DefaultMutableTreeNode createExternalTreeNodes() {
        DefaultMutableTreeNode external = new DefaultMutableTreeNode(i18n.tr("External programs"));
        DefaultMutableTreeNode browser = new DefaultMutableTreeNode(i18n.tr("Browser"));
        external.add(browser);
        FileSettingsPanel browserPath = new FileSettingsPanel(this.parent, i18n.tr("Browser path"), Settings.SETTING.BROWSER, "");
        this.addPanel(browser, browserPath);
        DefaultMutableTreeNode exiftool = new DefaultMutableTreeNode(i18n.tr("Exiftool"));
        external.add(exiftool);
        FileSettingsPanel exiftoolPath = new FileSettingsPanel(this.parent, i18n.tr("Exiftool path"), Settings.SETTING.EXIFTOOL_PATH, "exiftool");
        this.addPanel(exiftool, exiftoolPath);
        StringSettingsPanel exiftoolArguments = new StringSettingsPanel(this.parent, i18n.tr("Additional Exiftool arguments"), Settings.SETTING.EXIFTOOL_ARGUMENTS, "");
        this.addPanel(exiftool, exiftoolArguments);
        BooleanSettingsPanel createBackups = new BooleanSettingsPanel(this.parent, i18n.tr("Keep backups of images when writing to files"), Settings.SETTING.CREATE_BACKUPS, true);
        this.addPanel(exiftool, createBackups);
        DefaultMutableTreeNode gpsbabel = new DefaultMutableTreeNode(i18n.tr("GPSBabel"));
        external.add(gpsbabel);
        FileSettingsPanel gpsbabelPath = new FileSettingsPanel(this.parent, i18n.tr("GPSBabel path"), Settings.SETTING.GPSBABEL_PATH, "gpsbabel");
        this.addPanel(gpsbabel, gpsbabelPath);
        StringSettingsPanel gpsbabelProtocol = new StringSettingsPanel(this.parent, i18n.tr("GPSBabel protocol"), Settings.SETTING.GPSBABEL_PROTOCOL, "garmin");
        this.addPanel(gpsbabel, gpsbabelProtocol);
        StringSettingsPanel gpsbabelDevice = new StringSettingsPanel(this.parent, i18n.tr("GPSBabel device"), Settings.SETTING.GPSBABEL_DEVICE, GPSBabel.getDefaultDevice());
        this.addPanel(gpsbabel, gpsbabelDevice);
        DefaultMutableTreeNode dcraw = new DefaultMutableTreeNode(i18n.tr("Dcraw"));
        FileSettingsPanel dcrawPath = new FileSettingsPanel(this.parent, i18n.tr("Dcraw path"), Settings.SETTING.DCRAW_PATH, "dcraw");
        this.addPanel(dcraw, dcrawPath);
        external.add(dcraw);
        if (OperatingSystem.isLinux()) {
            DefaultMutableTreeNode googleEarth = new DefaultMutableTreeNode(i18n.tr("Google Earth"));
            FileSettingsPanel googleEarthPath = new FileSettingsPanel(this.parent, i18n.tr("Google Earth path"), Settings.SETTING.GOOGLE_EARTH_PATH, "googleearth");
            this.addPanel(googleEarth, googleEarthPath);
            external.add(googleEarth);
        }
        DefaultMutableTreeNode clipboard = new DefaultMutableTreeNode(i18n.tr("Clipboard"));
        BooleanSettingsPanel enableClipboard = new BooleanSettingsPanel(this.parent, i18n.tr("Monitor clipboard"), Settings.SETTING.CLIPBOARD_ENABLED, false);
        this.addPanel(clipboard, enableClipboard);
        BooleanSettingsPanel latitudeFirst = new BooleanSettingsPanel(this.parent, i18n.tr("Latitude first"), Settings.SETTING.CLIPBOARD_LATITUDE_FIRST, true);
        this.addPanel(clipboard, latitudeFirst);
        StringSettingsPanel north = new StringSettingsPanel(this.parent, i18n.tr("Letters for 'North'"), Settings.SETTING.CLIPBOARD_NORTH, Coordinates.NORTH);
        this.addPanel(clipboard, north);
        StringSettingsPanel south = new StringSettingsPanel(this.parent, i18n.tr("Letters for 'South'"), Settings.SETTING.CLIPBOARD_SOUTH, Coordinates.SOUTH);
        this.addPanel(clipboard, south);
        StringSettingsPanel east = new StringSettingsPanel(this.parent, i18n.tr("Letters for 'East'"), Settings.SETTING.CLIPBOARD_EAST, Coordinates.EAST);
        this.addPanel(clipboard, east);
        StringSettingsPanel west = new StringSettingsPanel(this.parent, i18n.tr("Letters for 'West'"), Settings.SETTING.CLIPBOARD_WEST, Coordinates.WEST);
        this.addPanel(clipboard, west);
        external.add(clipboard);
        return external;
    }

    private DefaultMutableTreeNode createGeonamesTreeNodes() {
        DefaultMutableTreeNode geonames = new DefaultMutableTreeNode(i18n.tr("geonames.org"));
        StringSettingsPanel url = new StringSettingsPanel(this.parent, i18n.tr("Geonames URL"), Settings.SETTING.GEONAMES_URL, "api.geonames.org");
        this.addPanel(geonames, url);
        IntegerSettingsPanel radius = new IntegerSettingsPanel(this.parent, i18n.tr("Search radius"), Settings.SETTING.GEONAMES_USE_RADIUS, false, Settings.SETTING.GEONAMES_RADIUS, 5, 0, Integer.MAX_VALUE, 1);
        this.addPanel(geonames, radius);
        IntegerSettingsPanel maxRows = new IntegerSettingsPanel(this.parent, i18n.tr("Number of results"), Settings.SETTING.GEONAMES_MAX_ROWS, 5, 1, 50, 1);
        this.addPanel(geonames, maxRows);
        IntegerSettingsPanel wikipedia = new IntegerSettingsPanel(this.parent, i18n.tr("Retrieve Wikipedia place names"), Settings.SETTING.GEONAMES_USE_WIKIPEDIA, false, Settings.SETTING.GEONAMES_WIKIPEDIA_ENTRIES, 3, 0, 50, 1);
        this.addPanel(geonames, wikipedia);
        StringSettingsPanel language = new StringSettingsPanel(this.parent, i18n.tr("Override query language"), Settings.SETTING.GEONAMES_OVERRIDE_LANGUAGE, false, Settings.SETTING.GEONAMES_LANGUAGE, "");
        this.addPanel(geonames, language);
        return geonames;
    }

    public void openDialog() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }

    public List<SettingsPanel> getPanelList() {
        return this.panelList;
    }
}

