/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.topografix.gpx._1._0.Gpx;
import com.topografix.gpx._1._0.ObjectFactory;
import com.topografix.gpx._1._1.GpxType;
import com.topografix.gpx._1._1.TrkType;
import com.topografix.gpx._1._1.TrksegType;
import com.topografix.gpx._1._1.WptType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public final class GpxOneOneReader {
    private GpxOneOneReader() {
    }

    public static Gpx read(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            GpxType gpxType = GpxOneOneReader.read(fileInputStream);
            Gpx gpx = GpxOneOneReader.convert(gpxType);
            fileInputStream.close();
            return gpx;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static GpxType read(InputStream inputStream) {
        GpxType gpx = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.topografix.gpx._1._1");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(inputStream);
            gpx = (GpxType)element.getValue();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return gpx;
    }

    private static Gpx convert(GpxType gpxType) {
        ObjectFactory objectFactoryOneZero = new ObjectFactory();
        Gpx gpx = objectFactoryOneZero.createGpx();
        List<Gpx.Trk> tracksOneZero = gpx.getTrk();
        for (TrkType trackOneOne : gpxType.getTrk()) {
            Gpx.Trk trackOneZero = objectFactoryOneZero.createGpxTrk();
            tracksOneZero.add(trackOneZero);
            trackOneZero.setName(trackOneOne.getName());
            trackOneZero.setNumber(trackOneOne.getNumber());
            List<Gpx.Trk.Trkseg> segmentsOneZero = trackOneZero.getTrkseg();
            for (TrksegType segmentOneOne : trackOneOne.getTrkseg()) {
                Gpx.Trk.Trkseg segmentOneZero = objectFactoryOneZero.createGpxTrkTrkseg();
                segmentsOneZero.add(segmentOneZero);
                List<Gpx.Trk.Trkseg.Trkpt> trackpointsOneZero = segmentOneZero.getTrkpt();
                for (WptType trkptOneOne : segmentOneOne.getTrkpt()) {
                    Gpx.Trk.Trkseg.Trkpt trkptOneZero = objectFactoryOneZero.createGpxTrkTrksegTrkpt();
                    trackpointsOneZero.add(trkptOneZero);
                    trkptOneZero.setCmt(trkptOneOne.getCmt());
                    trkptOneZero.setDesc(trkptOneOne.getDesc());
                    trkptOneZero.setLat(trkptOneOne.getLat());
                    trkptOneZero.setLon(trkptOneOne.getLon());
                    trkptOneZero.setEle(trkptOneOne.getEle());
                    trkptOneZero.setName(trkptOneOne.getName());
                    trkptOneZero.setTime(trkptOneOne.getTime());
                }
            }
        }
        System.out.println(gpx.getTrk().size());
        return gpx;
    }
}

