<?php
/*
 * Generated by peggy 1.0.0 with phpeggy plugin
 *
 * https://peggyjs.org/
 */

namespace MediaWiki\Extension\Math\TexVC;

use MediaWiki\Extension\Math\TexVC\Nodes\Box;
use MediaWiki\Extension\Math\TexVC\Nodes\Big;
use MediaWiki\Extension\Math\TexVC\Nodes\ChemFun2u;
use MediaWiki\Extension\Math\TexVC\Nodes\ChemWord;
use MediaWiki\Extension\Math\TexVC\Nodes\Curly;
use MediaWiki\Extension\Math\TexVC\Nodes\Declh;
use MediaWiki\Extension\Math\TexVC\Nodes\Dollar;
use MediaWiki\Extension\Math\TexVC\Nodes\DQ;
use MediaWiki\Extension\Math\TexVC\Nodes\FQ;
use MediaWiki\Extension\Math\TexVC\Nodes\Fun1;
use MediaWiki\Extension\Math\TexVC\Nodes\Fun1nb;
use MediaWiki\Extension\Math\TexVC\Nodes\Fun2;
use MediaWiki\Extension\Math\TexVC\Nodes\Fun2nb;
use MediaWiki\Extension\Math\TexVC\Nodes\Fun2sq;
use MediaWiki\Extension\Math\TexVC\Nodes\Fun4;
use MediaWiki\Extension\Math\TexVC\Nodes\Infix;
use MediaWiki\Extension\Math\TexVC\Nodes\Literal;
use MediaWiki\Extension\Math\TexVC\Nodes\Lr;
use MediaWiki\Extension\Math\TexVC\Nodes\Matrix;
use MediaWiki\Extension\Math\TexVC\Nodes\Mhchem;
use MediaWiki\Extension\Math\TexVC\Nodes\UQ;
use MediaWiki\Extension\Math\TexVC\Nodes\TexArray;
use MediaWiki\Extension\Math\TexVC\TexUtil;
use MediaWiki\Extension\Math\TexVC\ParserUtil;
/* Useful functions: */

/* chr_unicode - get unicode character from its char code */
if (!function_exists("MediaWiki\\Extension\\Math\\TexVC\\chr_unicode")) {
    function chr_unicode($code) {
        return html_entity_decode("&#$code;", ENT_QUOTES, "UTF-8");
    }
}
/* ord_unicode - get unicode char code from string */
if (!function_exists("MediaWiki\\Extension\\Math\\TexVC\\ord_unicode")) {
    function ord_unicode($character) {
        if (strlen($character) === 1) {
            return ord($character);
        }
        $json = json_encode($character);
        $utf16_1 = hexdec(substr($json, 3, 4));
        if (substr($json, 7, 2) === "\u") {
            $utf16_2 = hexdec(substr($json, 9, 4));
            return 0x10000 + (($utf16_1 & 0x3ff) << 10) + ($utf16_2 & 0x3ff);
        } else {
            return $utf16_1;
        }
    }
}
/* peg_regex_test - multibyte regex test */
if (!function_exists("MediaWiki\\Extension\\Math\\TexVC\\peg_regex_test")) {
    function peg_regex_test($pattern, $string) {
        if (substr($pattern, -1) == "i") {
            return mb_eregi(substr($pattern, 1, -2), $string);
        } else {
            return mb_ereg(substr($pattern, 1, -1), $string);
        }
    }
}

/* Syntax error exception */
if (!class_exists("MediaWiki\\Extension\\Math\\TexVC\\SyntaxError", false)) {
    class SyntaxError extends \Exception {
        public $expected;
        public $found;
        public $grammarOffset;
        public $grammarLine;
        public $grammarColumn;
        public $name;
        public function __construct($message, $expected, $found, $offset, $line, $column) {
            parent::__construct($message, 0);
            $this->expected = $expected;
            $this->found = $found;
            $this->grammarOffset = $offset;
            $this->grammarLine = $line;
            $this->grammarColumn = $column;
            $this->name = "SyntaxError";
        }
    }
}

class Parser {
    private $peg_currPos          = 0;
    private $peg_reportedPos      = 0;
    private $peg_cachedPos        = 0;
    private $peg_cachedPosDetails = array('line' => 1, 'column' => 1, 'seenCR' => false );
    private $peg_maxFailPos       = 0;
    private $peg_maxFailExpected  = array();
    private $peg_silentFails      = 0;
    private $input                = array();
    private $input_length         = 0;
    public $peg_cache = array();

    private function cleanup_state() {
      $this->peg_currPos          = 0;
      $this->peg_reportedPos      = 0;
      $this->peg_cachedPos        = 0;
      $this->peg_cachedPosDetails = array('line' => 1, 'column' => 1, 'seenCR' => false );
      $this->peg_maxFailPos       = 0;
      $this->peg_maxFailExpected  = array();
      $this->peg_silentFails      = 0;
      $this->input                = array();
      $this->input_length         = 0;
      $this->peg_cache = array();
    }

    private function input_substr($start, $length) {
      if ($length === 1 && $start < $this->input_length) {
        return $this->input[$start];
      }
      $substr = '';
      $max = min($start + $length, $this->input_length);
      for ($i = $start; $i < $max; $i++) {
        $substr .= $this->input[$i];
      }
      return $substr;
    }


    private function text() {
      return $this->input_substr($this->peg_reportedPos, $this->peg_currPos - $this->peg_reportedPos);
    }

    private function offset() {
      return $this->peg_reportedPos;
    }

    private function line() {
      $compute_pd = $this->peg_computePosDetails($this->peg_reportedPos);
      return $compute_pd["line"];
    }

    private function column() {
      $compute_pd = $this->peg_computePosDetails($this->peg_reportedPos);
      return $compute_pd["column"];
    }

    private function expected($description) {
      throw $this->peg_buildException(
        null,
        array(array("type" => "other", "description" => $description )),
        $this->peg_reportedPos
      );
    }

    private function error($message) {
      throw $this->peg_buildException($message, null, $this->peg_reportedPos);
    }

    private function peg_advancePos(&$details, $startPos, $endPos) {
      for ($p = $startPos; $p < $endPos; $p++) {
        $ch = $this->input_substr($p, 1);
        if ($ch === "\n") {
          if (!$details["seenCR"]) { $details["line"]++; }
          $details["column"] = 1;
          $details["seenCR"] = false;
        } else if ($ch === "\r" || $ch === "\u2028" || $ch === "\u2029") {
          $details["line"]++;
          $details["column"] = 1;
          $details["seenCR"] = true;
        } else {
          $details["column"]++;
          $details["seenCR"] = false;
        }
      }
    }

    private function peg_computePosDetails($pos) {
      if ($this->peg_cachedPos !== $pos) {
        if ($this->peg_cachedPos > $pos) {
          $this->peg_cachedPos = 0;
          $this->peg_cachedPosDetails = array( "line" => 1, "column" => 1, "seenCR" => false );
        }
        $this->peg_advancePos($this->peg_cachedPosDetails, $this->peg_cachedPos, $pos);
        $this->peg_cachedPos = $pos;
      }

      return $this->peg_cachedPosDetails;
    }

    private function peg_fail($expected) {
      if ($this->peg_currPos < $this->peg_maxFailPos) { return; }

      if ($this->peg_currPos > $this->peg_maxFailPos) {
        $this->peg_maxFailPos = $this->peg_currPos;
        $this->peg_maxFailExpected = array();
      }

      $this->peg_maxFailExpected[] = $expected;
    }

    private function peg_buildException_expectedComparator($a, $b) {
      if ($a["description"] < $b["description"]) {
        return -1;
      } else if ($a["description"] > $b["description"]) {
        return 1;
      } else {
        return 0;
      }
    }

    private function peg_buildException($message, $expected, $pos) {
      $posDetails = $this->peg_computePosDetails($pos);
      $found      = $pos < $this->input_length ? $this->input[$pos] : null;

      if ($expected !== null) {
        usort($expected, array($this, "peg_buildException_expectedComparator"));
        $i = 1;
        while ($i < count($expected)) {
          if ($expected[$i - 1] === $expected[$i]) {
            array_splice($expected, $i, 1);
          } else {
            $i++;
          }
        }
      }

      if ($message === null) {
        $expectedDescs = array_fill(0, count($expected), null);

        for ($i = 0; $i < count($expected); $i++) {
          $expectedDescs[$i] = $expected[$i]["description"];
        }

        $expectedDesc = count($expected) > 1
          ? join(", ", array_slice($expectedDescs, 0, -1))
              . " or "
              . $expectedDescs[count($expected) - 1]
          : $expectedDescs[0];

        $foundDesc = $found ? json_encode($found) : "end of input";

        $message = "Expected " . $expectedDesc . " but " . $foundDesc . " found.";
      }

      return new SyntaxError(
        $message,
        $expected,
        $found,
        $pos,
        $posDetails["line"],
        $posDetails["column"]
      );
    }

    private $peg_FAILED;
    private $peg_c0;
    private $peg_c1;
    private $peg_c2;
    private $peg_c3;
    private $peg_c4;
    private $peg_c5;
    private $peg_c6;
    private $peg_c7;
    private $peg_c8;
    private $peg_c9;
    private $peg_c10;
    private $peg_c11;
    private $peg_c12;
    private $peg_c13;
    private $peg_c14;
    private $peg_c15;
    private $peg_c16;
    private $peg_c17;
    private $peg_c18;
    private $peg_c19;
    private $peg_c20;
    private $peg_c21;
    private $peg_c22;
    private $peg_c23;
    private $peg_c24;
    private $peg_c25;
    private $peg_c26;
    private $peg_c27;
    private $peg_c28;
    private $peg_c29;
    private $peg_c30;
    private $peg_c31;
    private $peg_c32;
    private $peg_c33;
    private $peg_c34;
    private $peg_c35;
    private $peg_c36;
    private $peg_c37;
    private $peg_c38;
    private $peg_c39;
    private $peg_c40;
    private $peg_c41;
    private $peg_c42;
    private $peg_c43;
    private $peg_c44;
    private $peg_c45;
    private $peg_c46;
    private $peg_c47;
    private $peg_c48;
    private $peg_c49;
    private $peg_c50;
    private $peg_c51;
    private $peg_c52;
    private $peg_c53;
    private $peg_c54;
    private $peg_c55;
    private $peg_c56;
    private $peg_c57;
    private $peg_c58;
    private $peg_c59;
    private $peg_c60;
    private $peg_c61;
    private $peg_c62;
    private $peg_c63;
    private $peg_c64;
    private $peg_c65;
    private $peg_c66;
    private $peg_c67;
    private $peg_c68;
    private $peg_c69;
    private $peg_c70;
    private $peg_c71;
    private $peg_c72;
    private $peg_c73;
    private $peg_c74;
    private $peg_c75;
    private $peg_c76;
    private $peg_c77;
    private $peg_c78;
    private $peg_c79;
    private $peg_c80;
    private $peg_c81;
    private $peg_c82;
    private $peg_c83;
    private $peg_c84;
    private $peg_c85;
    private $peg_c86;
    private $peg_c87;
    private $peg_c88;
    private $peg_c89;
    private $peg_c90;
    private $peg_c91;
    private $peg_c92;
    private $peg_c93;
    private $peg_c94;
    private $peg_c95;
    private $peg_c96;
    private $peg_c97;
    private $peg_c98;
    private $peg_c99;
    private $peg_c100;
    private $peg_c101;
    private $peg_c102;
    private $peg_c103;
    private $peg_c104;
    private $peg_c105;
    private $peg_c106;
    private $peg_c107;
    private $peg_c108;
    private $peg_c109;
    private $peg_c110;
    private $peg_c111;
    private $peg_c112;
    private $peg_c113;
    private $peg_c114;
    private $peg_c115;
    private $peg_c116;
    private $peg_c117;
    private $peg_c118;
    private $peg_c119;
    private $peg_c120;
    private $peg_c121;
    private $peg_c122;
    private $peg_c123;
    private $peg_c124;
    private $peg_c125;
    private $peg_c126;
    private $peg_c127;
    private $peg_c128;
    private $peg_c129;
    private $peg_c130;
    private $peg_c131;
    private $peg_c132;
    private $peg_c133;
    private $peg_c134;
    private $peg_c135;
    private $peg_c136;
    private $peg_c137;
    private $peg_c138;
    private $peg_c139;
    private $peg_c140;
    private $peg_c141;
    private $peg_c142;
    private $peg_c143;
    private $peg_c144;
    private $peg_c145;
    private $peg_c146;
    private $peg_c147;
    private $peg_c148;
    private $peg_c149;
    private $peg_c150;
    private $peg_c151;
    private $peg_c152;
    private $peg_c153;
    private $peg_c154;
    private $peg_c155;
    private $peg_c156;
    private $peg_c157;
    private $peg_c158;

    private function peg_f0($t) {
            # assert.ok($t instanceof TexArray);
            assert($t instanceof TexArray);
            return ParserUtil::lst2arr($t);
        }
    private function peg_f1($e) { return $e; }
    private function peg_f2($e1, $name, $e2) { return new TexArray(new Infix($name, ParserUtil::lst2arr($e1), ParserUtil::lst2arr($e2))); }
    private function peg_f3() { return new TexArray(); }
    private function peg_f4($h, $t) { return new TexArray($h, $t); }
    private function peg_f5($d, $e) { return new TexArray(new Declh($d->getFname(), ParserUtil::lst2arr($e))); }
    private function peg_f6($l1, $l2) { return new FQ($l1->getBase(), $l1->getDown(), $l2); }
    private function peg_f7($l1, $l2) { return new FQ($l1->getBase(), $l2, $l1->getUp()); }
    private function peg_f8($base, $upi) { return new UQ($base, $upi); }
    private function peg_f9($base, $downi) { return new DQ($base, $downi); }
    private function peg_f10() { return new Literal( "]"); }
    private function peg_f11($l, $e) { return new TexArray($l, $e); }
    private function peg_f12($l1, $l2) { return new FQ ($l1->getBase(), $l2, $l1->getUp()); }
    private function peg_f13($l1, $l2) { return new FQ(new TexArray(), $l1->getDown(), $l2); }
    private function peg_f14($l) { return new UQ(new TexArray(),$l); }
    private function peg_f15($l) { return new DQ(new TexArray(),$l); }
    private function peg_f16($d) { return $d; }
    private function peg_f17() { return  "]"; }
    private function peg_f18($r) { return new Literal($r); }
    private function peg_f19($f) { return $this->tu->latex_function_names($f); }
    private function peg_f20($f) { return " ";}
    private function peg_f21($f, $c) { return new TexArray( new Literal( $f ) , new Literal( $c ) ) ; }
    private function peg_f22($f) { return $this->tu->nullary_macro_aliase($f); }
    private function peg_f23($f) {
         $parser = new Parser();
         $ast = $parser->parse($this->tu->nullary_macro_aliase($f), $this->options);
         assert($ast instanceof TexArray && count($ast->getArgs()) === 1);
         return $ast->first();
       }
    private function peg_f24($f) { return $this->tu->deprecated_nullary_macro_aliase($f); }
    private function peg_f25($f) {
         $parser = new Parser();
         $ast = $parser->parse($this->tu->deprecated_nullary_macro_aliase($f), $this->options);
         assert($ast instanceof TexArray && count($ast->getArgs()) === 1);
         if ($this->options['oldtexvc']){
           return $ast->first();
         } else {
              throw new SyntaxError("Deprecation: Alias no longer supported.", [], $this->text(), $this->offset(),
                $this->line(), $this->column());
         }
       }
    private function peg_f26($b, $r) { return new Big($b, $r); }
    private function peg_f27($b) { return new Big($b,  "]"); }
    private function peg_f28($l, $e, $r) {return new Lr($l, $r, ParserUtil::lst2arr($e)); }
    private function peg_f29($name, $e, $l) { return new Fun2sq($name, new Curly(ParserUtil::lst2arr($e)), $l); }
    private function peg_f30($name, $l) { return new Fun1($name, $l); }
    private function peg_f31($name, $l) {return new Fun1nb($name, $l); }
    private function peg_f32($name, $l) { return new Mhchem($name, $l); }
    private function peg_f33($name, $l1, $l2) { return new Fun2($name, $l1, $l2); }
    private function peg_f34($name, $l1, $l2, $l3, $l4) { return new Fun4($name, $l1, $l2, $l3, $l4); }
    private function peg_f35($name, $l1, $l2) { return new Fun2nb($name, $l1, $l2); }
    private function peg_f36($e) { return new Curly(ParserUtil::lst2arr($e)); }
    private function peg_f37($e1, $name, $e2) { return new Infix($name, ParserUtil::lst2arr($e1), ParserUtil::lst2arr($e2)); }
    private function peg_f38($m) { return new Matrix("matrix", ParserUtil::lst2arr($m)); }
    private function peg_f39($m) { return new Matrix("pmatrix", ParserUtil::lst2arr($m)); }
    private function peg_f40($m) { return new Matrix("bmatrix", ParserUtil::lst2arr($m)); }
    private function peg_f41($m) { return new Matrix("Bmatrix", ParserUtil::lst2arr($m)); }
    private function peg_f42($m) { return new Matrix("vmatrix", ParserUtil::lst2arr($m)); }
    private function peg_f43($m) { return new Matrix("Vmatrix", ParserUtil::lst2arr($m)); }
    private function peg_f44($m) { return new Matrix("array", ParserUtil::lst2arr($m)); }
    private function peg_f45($m) { return new Matrix("aligned", ParserUtil::lst2arr($m)); }
    private function peg_f46($m) { return new Matrix("alignedat", ParserUtil::lst2arr($m)); }
    private function peg_f47($m) { return new Matrix("smallmatrix", ParserUtil::lst2arr($m)); }
    private function peg_f48($m) { return new Matrix("cases", ParserUtil::lst2arr($m)); }
    private function peg_f49() { throw new SyntaxError("Illegal TeX function", [], $this->text(), $this->offset(),
                                $this->line(), $this->column()); }
    private function peg_f50($f) { return !$this->tu->getAllFunctionsAt($f); }
    private function peg_f51($f) { throw new SyntaxError("Illegal TeX function", [], $f, $this->offset(), $this->line(), $this->column()); }
    private function peg_f52($cs, $m) {
            if ($m->getLength() ) {
                $m->first()->first()->unshift($cs);
                return $m;
            }
            return new TexArray(new TexArray($cs));
        }
    private function peg_f53($as, $m) { $m->first()->first()->unshift($as); return $m; }
    private function peg_f54($l, $m) { return $m; }
    private function peg_f55($l, $tail) { return new TexArray( ParserUtil::lst2arr($l), $tail ); }
    private function peg_f56($f, $l) {
            if ($l->first() === null ) {
                $l->push(new TexArray());
            }
            $l->first()->unshift(new Literal($f . " ")); return $l;}
    private function peg_f57($e, $l) { return $l; }
    private function peg_f58($e, $tail) { return new TexArray($e, $tail); }
    private function peg_f59() { return $this->text(); }
    private function peg_f60($cs) { return new Curly(new TexArray(new Literal($cs))); }
    private function peg_f61($num) { return new Curly(new TexArray(new Literal($num))); }
    private function peg_f62($p, $s) { return new TexArray($p,new TexArray(new Literal(" "),$s)); }
    private function peg_f63($p) { return new TexArray($p,new TexArray()); }
    private function peg_f64($m) { return new Literal($m); }
    private function peg_f65($m, $n) { return new ChemWord($m, new Literal($n)); }
    private function peg_f66($m) { return $m; }
    private function peg_f67($m, $n) { return new ChemWord($m, $n); }
    private function peg_f68($m, $n, $o) { return new ChemWord(new ChemWord(new Literal($m), $n), $o); }
    private function peg_f69() { return new Literal(""); }
    private function peg_f70($m) { return $m;}
    private function peg_f71($c) { return new Literal($c); }
    private function peg_f72($c) { return new Curly(new TexArray($c)); }
    private function peg_f73($c) { return new Dollar(ParserUtil::lst2arr($c)); }
    private function peg_f74($e) { return new Curly(new TexArray(new Literal($e))); }
    private function peg_f75($a, $b) { return new ChemWord(new Literal($a), new Literal($b)); }
    private function peg_f76($a, $b) { return new ChemWord(new Literal($a), $b); }
    private function peg_f77($a, $b) { return new ChemWord(new Literal($a), new Dollar(ParserUtil::lst2arr($b))); }
    private function peg_f78($name, $l1, $l2) { return new ChemFun2u($name, $l1, $l2); }
    private function peg_f79($cs) { return new Literal(join('',$cs)); }
    private function peg_f80($name) { return new Literal(join('',$name)); }
    private function peg_f81($l, $h) { return $this->text(); }
    private function peg_f82($b) { return $this->tu->box_functions($b); }
    private function peg_f83($b, $cs) { return new Box($b, join('', $cs)); }
    private function peg_f84($c) { return $c; }
    private function peg_f85($f) { return $this->tu->mediawiki_function_names($f); }
    private function peg_f86($f, $c) {
            if(is_array($f)) {
                // This is an unexpected case, but covers the ambiguity of slice in javascript.
                $fProcessed = implode(array_slice($f, 1));
            } else {
                $fProcessed = substr($f,1);
            }
            return "\\operatorname {" . $fProcessed . "}" . $c;
        }
    private function peg_f87($f) { return $this->tu->nullary_macro($f); }
    private function peg_f88($f) { return $f . " "; }
    private function peg_f89($f) { return $this->options['usemathrm'] && $this->tu->nullary_macro_in_mbox($f); }
    private function peg_f90($f) { return "\\mathrm {" . $f . "} "; }
    private function peg_f91($mathrm) { return $this->options['usemathrm'] && $mathrm === "\\mathrm"; }
    private function peg_f92($mathrm, $f) { return $this->options['usemathrm'] && $this->tu->nullary_macro_in_mbox($f); }
    private function peg_f93($mathrm, $f) {  return  $this->options['usemathrm'] ? "\\mathrm {" . $f . "} " : false;}
    private function peg_f94($f) { return $this->tu->nullary_macro_in_mbox($f); }
    private function peg_f95($f) { return "\\mbox{" . $f . "} "; }
    private function peg_f96($mbox) { return $mbox === "\\mbox"; }
    private function peg_f97($mbox, $f) { return $this->tu->nullary_macro_in_mbox($f); }
    private function peg_f98($mbox, $f) { return "\\mbox{" . $f . "} "; }
    private function peg_f99($f) { return $f; }
    private function peg_f100($c) { return "\\" . $c; }
    private function peg_f101($c) { if($this->options['oldtexvc']) {
        return "\\" . $c; /* escape dangerous chars */
        } else {
         throw new SyntaxError("Deprecation: % and $ need to be escaped.", [], $this->text(), $this->offset(),
            $this->line(), $this->column());
        }}
    private function peg_f102($f) { return $this->tu->other_delimiters1($f); }
    private function peg_f103($f) { return $this->tu->other_delimiters2($f); }
    private function peg_f104($f) {
         $parser = new Parser();
         $p = $parser->parse($this->tu->other_delimiters2($f), $this->options);
         # assert.ok(p instanceof TexArray && p.length === 1);
         assert($p instanceof TexArray && count($p->getArgs()) === 1);

         # assert.ok(p.first() instanceof Literal);
          assert($p->first() instanceof Literal);

         return $p->first()->getArg();
       }
    private function peg_f105($f) { return $this->tu->fun_ar1nb($f); }
    private function peg_f106($f) { return $this->tu->fun_ar1opt($f); }
    private function peg_f107($f) { return $this->tu->big_literals($f); }
    private function peg_f108($f) { return $this->tu->fun_ar1($f); }
    private function peg_f109($f) { return $this->options['oldmhchem'] && $this->tu->fun_mhchem($f);}
    private function peg_f110($f) { return $this->tu->other_fun_ar1($f); }
    private function peg_f111($f) { if ($this->options['oldtexvc']) {
            return $this->tu->other_fun_ar1($f);
         } else {
            throw new SyntaxError("Deprecation: \\Bbb and \\bold are not allowed in math mode.", [],
                $this->text(), $this->offset(), $this->line(),$this->column());
         }
       }
    private function peg_f112($f) { return $this->tu->fun_mhchem($f); }
    private function peg_f113($f) { return $this->tu->fun_ar2($f); }
    private function peg_f114($f) { return $this->tu->fun_ar4($f) && $this->tu->mhchemtexified_required($f); }
    private function peg_f115($f) { return $this->tu->fun_infix($f); }
    private function peg_f116($f) { return $this->tu->declh_function($f); }
    private function peg_f117($f) { return new Declh($f, new TexArray()); }
    private function peg_f118($f) { return $this->tu->fun_ar2nb($f); }
    private function peg_f119($f) { return $this->tu->left_function($f); }
    private function peg_f120($f) { return $this->tu->right_function($f); }
    private function peg_f121($f) { return $this->tu->hline_function($f); }
    private function peg_f122($f) { return $this->tu->color_function($f); }
    private function peg_f123($f, $cs) { return $f . " " . $cs; }
    private function peg_f124($f) { return $this->tu->definecolor_function($f); }
    private function peg_f125($f, $name, $cs) { return "{named}" . $cs; }
    private function peg_f126($f, $name, $cs) { return "{gray}" . $cs; }
    private function peg_f127($f, $name, $cs) { return "{rgb}" . $cs; }
    private function peg_f128($f, $name, $cs) { return "{cmyk}" . $cs; }
    private function peg_f129($f, $name, $a) { return $f . " {" . join('',$name) . "}" . $a; }
    private function peg_f130($cs) { return "[named]" . $cs; }
    private function peg_f131($cs) { return "[gray]" . $cs; }
    private function peg_f132($cs) { return "[rgb]" . $cs; }
    private function peg_f133($cs) { return "[cmyk]" . $cs; }
    private function peg_f134($name) { return "{" . join('', $name) . "}"; }
    private function peg_f135($k) { $s = is_array($k) ? $k[0] : $k;
          return "{" . $s . "}";}
    private function peg_f136($r, $g, $b) { return "{" . $r . "," . $g . "," . $b . "}"; }
    private function peg_f137($c, $m, $y, $k) { return "{" . $c . "," . $m . "," . $y . "," . $k . "}"; }
    private function peg_f138($n) { return intval($n, 10) <= 255; }
    private function peg_f139($n) { return $n / 255; }
    private function peg_f140($n) { return $n; }
    private function peg_f141($f) { return $this->tu->mhchem_single_macro($f); }
    private function peg_f142($f) { return $this->tu->mhchem_bond($f); }
    private function peg_f143($f) { return $this->tu->mhchem_macro_1p($f); }
    private function peg_f144($f) { return $this->tu->mhchem_macro_2p($f); }
    private function peg_f145($f) { return $this->tu->mhchem_macro_2pu($f); }
    private function peg_f146($f) { return $this->tu->mhchem_macro_2pc($f); }
    private function peg_f147() { return "{}"; }
    private function peg_f148() { return false; }
    private function peg_f149() { return $this->peg_currPos === $this->input_length; }

    private function peg_parsestart() {

      $key = $this->peg_currPos * 126 + 0;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parse_();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsetex_expr();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f0($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parse_() {

      $key = $this->peg_currPos * 126 + 1;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = array();
      if (peg_regex_test($this->peg_c0, $this->input_substr($this->peg_currPos, 1))) {
        $s1 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      while ($s1 !== $this->peg_FAILED) {
        $s0[] = $s1;
        if (peg_regex_test($this->peg_c0, $this->input_substr($this->peg_currPos, 1))) {
          $s1 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c1);
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsetex_expr() {

      $key = $this->peg_currPos * 126 + 2;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseexpr();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseEOF();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f1($s1);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parsene_expr();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseFUN_INFIX();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parsene_expr();
            if ($s3 !== $this->peg_FAILED) {
              $s4 = $this->peg_parseEOF();
              if ($s4 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f2($s1, $s2, $s3);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseexpr() {

      $key = $this->peg_currPos * 126 + 3;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parsene_expr();
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_c2;
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f3();
        }
        $s0 = $s1;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsene_expr() {

      $key = $this->peg_currPos * 126 + 4;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselit_aq();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseexpr();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f4($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parselitsq_aq();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseexpr();
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f4($s1, $s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parseDECLh();
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parseexpr();
            if ($s2 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f5($s1, $s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselitsq_aq() {

      $key = $this->peg_currPos * 126 + 5;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parselitsq_fq();
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_parselitsq_dq();
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_parselitsq_uq();
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_parselitsq_zq();
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselitsq_fq() {

      $key = $this->peg_currPos * 126 + 6;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselitsq_dq();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseSUP();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parselit();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f6($s1, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parselitsq_uq();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseSUB();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parselit();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f7($s1, $s3);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselitsq_uq() {

      $key = $this->peg_currPos * 126 + 7;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselitsq_zq();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseSUP();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parselit();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f8($s1, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselitsq_dq() {

      $key = $this->peg_currPos * 126 + 8;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselitsq_zq();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseSUB();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parselit();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f9($s1, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselitsq_zq() {

      $key = $this->peg_currPos * 126 + 9;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseSQ_CLOSE();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f10();
      }
      $s0 = $s1;

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseexpr_nosqc() {

      $key = $this->peg_currPos * 126 + 10;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselit_aq();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseexpr_nosqc();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f11($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_c2;
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f3();
        }
        $s0 = $s1;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit_aq() {

      $key = $this->peg_currPos * 126 + 11;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parselit_fq();
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_parselit_dq();
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_parselit_uq();
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_parselit_dqn();
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_parselit_uqn();
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_parselit();
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit_fq() {

      $key = $this->peg_currPos * 126 + 12;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselit_dq();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseSUP();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parselit();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f6($s1, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parselit_uq();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseSUB();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parselit();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f12($s1, $s3);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parselit_dqn();
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parseSUP();
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parselit();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f13($s1, $s3);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit_uq() {

      $key = $this->peg_currPos * 126 + 13;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselit();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseSUP();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parselit();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f8($s1, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit_dq() {

      $key = $this->peg_currPos * 126 + 14;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parselit();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseSUB();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parselit();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f9($s1, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit_uqn() {

      $key = $this->peg_currPos * 126 + 15;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseSUP();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parselit();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f14($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit_dqn() {

      $key = $this->peg_currPos * 126 + 16;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseSUB();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parselit();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f15($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseleft() {

      $key = $this->peg_currPos * 126 + 17;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseLEFTI();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseDELIMITER();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f16($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseLEFTI();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseSQ_CLOSE();
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f17();
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseright() {

      $key = $this->peg_currPos * 126 + 18;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseRIGHTI();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseDELIMITER();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f16($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseRIGHTI();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseSQ_CLOSE();
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f17();
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parselit() {

      $key = $this->peg_currPos * 126 + 19;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseLITERAL();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f18($s1);
      }
      $s0 = $s1;
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parsegeneric_func();
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $this->peg_currPos;
          $s2 = $this->peg_f19($s1);
          if ($s2) {
            $s2 = null;
          } else {
            $s2 = $this->peg_FAILED;
          }
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parse_();
            if ($s3 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c3) {
                $s4 = $this->peg_c3;
                $this->peg_currPos++;
              } else {
                $s4 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c4);
                }
              }
              if ($s4 === $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
                  $s4 = $this->peg_c5;
                  $this->peg_currPos++;
                } else {
                  $s4 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c6);
                  }
                }
                if ($s4 === $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c7) {
                    $s4 = $this->peg_c7;
                    $this->peg_currPos += 2;
                  } else {
                    $s4 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c8);
                    }
                  }
                  if ($s4 === $this->peg_FAILED) {
                    $s4 = $this->peg_currPos;
                    $s5 = $this->peg_c2;
                    if ($s5 !== $this->peg_FAILED) {
                      $this->peg_reportedPos = $s4;
                      $s5 = $this->peg_f20($s1);
                    }
                    $s4 = $s5;
                  }
                }
              }
              if ($s4 !== $this->peg_FAILED) {
                $s5 = $this->peg_parse_();
                if ($s5 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f21($s1, $s4);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parsegeneric_func();
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $this->peg_currPos;
            $s2 = $this->peg_f22($s1);
            if ($s2) {
              $s2 = null;
            } else {
              $s2 = $this->peg_FAILED;
            }
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parse_();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f23($s1);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_parsegeneric_func();
            if ($s1 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $this->peg_currPos;
              $s2 = $this->peg_f24($s1);
              if ($s2) {
                $s2 = null;
              } else {
                $s2 = $this->peg_FAILED;
              }
              if ($s2 !== $this->peg_FAILED) {
                $s3 = $this->peg_parse_();
                if ($s3 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f25($s1);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              $s1 = $this->peg_parseDELIMITER();
              if ($s1 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f18($s1);
              }
              $s0 = $s1;
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_currPos;
                $s1 = $this->peg_parseBIG();
                if ($s1 !== $this->peg_FAILED) {
                  $s2 = $this->peg_parseDELIMITER();
                  if ($s2 !== $this->peg_FAILED) {
                    $this->peg_reportedPos = $s0;
                    $s1 = $this->peg_f26($s1, $s2);
                    $s0 = $s1;
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
                if ($s0 === $this->peg_FAILED) {
                  $s0 = $this->peg_currPos;
                  $s1 = $this->peg_parseBIG();
                  if ($s1 !== $this->peg_FAILED) {
                    $s2 = $this->peg_parseSQ_CLOSE();
                    if ($s2 !== $this->peg_FAILED) {
                      $this->peg_reportedPos = $s0;
                      $s1 = $this->peg_f27($s1);
                      $s0 = $s1;
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                  if ($s0 === $this->peg_FAILED) {
                    $s0 = $this->peg_currPos;
                    $s1 = $this->peg_parseleft();
                    if ($s1 !== $this->peg_FAILED) {
                      $s2 = $this->peg_parseexpr();
                      if ($s2 !== $this->peg_FAILED) {
                        $s3 = $this->peg_parseright();
                        if ($s3 !== $this->peg_FAILED) {
                          $this->peg_reportedPos = $s0;
                          $s1 = $this->peg_f28($s1, $s2, $s3);
                          $s0 = $s1;
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                    if ($s0 === $this->peg_FAILED) {
                      $s0 = $this->peg_currPos;
                      $s1 = $this->peg_parseFUN_AR1opt();
                      if ($s1 !== $this->peg_FAILED) {
                        $s2 = $this->peg_parseexpr_nosqc();
                        if ($s2 !== $this->peg_FAILED) {
                          $s3 = $this->peg_parseSQ_CLOSE();
                          if ($s3 !== $this->peg_FAILED) {
                            $s4 = $this->peg_parselit();
                            if ($s4 !== $this->peg_FAILED) {
                              $this->peg_reportedPos = $s0;
                              $s1 = $this->peg_f29($s1, $s2, $s4);
                              $s0 = $s1;
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                      if ($s0 === $this->peg_FAILED) {
                        $s0 = $this->peg_currPos;
                        $s1 = $this->peg_parseFUN_AR1();
                        if ($s1 !== $this->peg_FAILED) {
                          $s2 = $this->peg_parselit();
                          if ($s2 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f30($s1, $s2);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                        if ($s0 === $this->peg_FAILED) {
                          $s0 = $this->peg_currPos;
                          $s1 = $this->peg_parseFUN_AR1nb();
                          if ($s1 !== $this->peg_FAILED) {
                            $s2 = $this->peg_parselit();
                            if ($s2 !== $this->peg_FAILED) {
                              $this->peg_reportedPos = $s0;
                              $s1 = $this->peg_f31($s1, $s2);
                              $s0 = $s1;
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                          if ($s0 === $this->peg_FAILED) {
                            $s0 = $this->peg_currPos;
                            $s1 = $this->peg_parseFUN_MHCHEM();
                            if ($s1 !== $this->peg_FAILED) {
                              $s2 = $this->peg_parsechem_lit();
                              if ($s2 !== $this->peg_FAILED) {
                                $this->peg_reportedPos = $s0;
                                $s1 = $this->peg_f32($s1, $s2);
                                $s0 = $s1;
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                            if ($s0 === $this->peg_FAILED) {
                              $s0 = $this->peg_currPos;
                              $s1 = $this->peg_parseFUN_AR2();
                              if ($s1 !== $this->peg_FAILED) {
                                $s2 = $this->peg_parselit();
                                if ($s2 !== $this->peg_FAILED) {
                                  $s3 = $this->peg_parselit();
                                  if ($s3 !== $this->peg_FAILED) {
                                    $this->peg_reportedPos = $s0;
                                    $s1 = $this->peg_f33($s1, $s2, $s3);
                                    $s0 = $s1;
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                              if ($s0 === $this->peg_FAILED) {
                                $s0 = $this->peg_currPos;
                                $s1 = $this->peg_parseFUN_AR4_MHCHEM_TEXIFIED();
                                if ($s1 !== $this->peg_FAILED) {
                                  $s2 = $this->peg_parselit();
                                  if ($s2 !== $this->peg_FAILED) {
                                    $s3 = $this->peg_parselit();
                                    if ($s3 !== $this->peg_FAILED) {
                                      $s4 = $this->peg_parselit();
                                      if ($s4 !== $this->peg_FAILED) {
                                        $s5 = $this->peg_parselit();
                                        if ($s5 !== $this->peg_FAILED) {
                                          $this->peg_reportedPos = $s0;
                                          $s1 = $this->peg_f34($s1, $s2, $s3, $s4, $s5);
                                          $s0 = $s1;
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s0;
                                      $s0 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                                if ($s0 === $this->peg_FAILED) {
                                  $s0 = $this->peg_currPos;
                                  $s1 = $this->peg_parseFUN_AR2nb();
                                  if ($s1 !== $this->peg_FAILED) {
                                    $s2 = $this->peg_parselit();
                                    if ($s2 !== $this->peg_FAILED) {
                                      $s3 = $this->peg_parselit();
                                      if ($s3 !== $this->peg_FAILED) {
                                        $this->peg_reportedPos = $s0;
                                        $s1 = $this->peg_f35($s1, $s2, $s3);
                                        $s0 = $s1;
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s0;
                                      $s0 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                  if ($s0 === $this->peg_FAILED) {
                                    $s0 = $this->peg_parseBOX();
                                    if ($s0 === $this->peg_FAILED) {
                                      $s0 = $this->peg_currPos;
                                      $s1 = $this->peg_parseCURLY_OPEN();
                                      if ($s1 !== $this->peg_FAILED) {
                                        $s2 = $this->peg_parseexpr();
                                        if ($s2 !== $this->peg_FAILED) {
                                          $s3 = $this->peg_parseCURLY_CLOSE();
                                          if ($s3 !== $this->peg_FAILED) {
                                            $this->peg_reportedPos = $s0;
                                            $s1 = $this->peg_f36($s2);
                                            $s0 = $s1;
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                      if ($s0 === $this->peg_FAILED) {
                                        $s0 = $this->peg_currPos;
                                        $s1 = $this->peg_parseCURLY_OPEN();
                                        if ($s1 !== $this->peg_FAILED) {
                                          $s2 = $this->peg_parsene_expr();
                                          if ($s2 !== $this->peg_FAILED) {
                                            $s3 = $this->peg_parseFUN_INFIX();
                                            if ($s3 !== $this->peg_FAILED) {
                                              $s4 = $this->peg_parsene_expr();
                                              if ($s4 !== $this->peg_FAILED) {
                                                $s5 = $this->peg_parseCURLY_CLOSE();
                                                if ($s5 !== $this->peg_FAILED) {
                                                  $this->peg_reportedPos = $s0;
                                                  $s1 = $this->peg_f37($s2, $s3, $s4);
                                                  $s0 = $s1;
                                                } else {
                                                  $this->peg_currPos = $s0;
                                                  $s0 = $this->peg_FAILED;
                                                }
                                              } else {
                                                $this->peg_currPos = $s0;
                                                $s0 = $this->peg_FAILED;
                                              }
                                            } else {
                                              $this->peg_currPos = $s0;
                                              $s0 = $this->peg_FAILED;
                                            }
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                        if ($s0 === $this->peg_FAILED) {
                                          $s0 = $this->peg_currPos;
                                          $s1 = $this->peg_parseBEGIN_MATRIX();
                                          if ($s1 !== $this->peg_FAILED) {
                                            $s2 = $this->peg_parsearray();
                                            if ($s2 === $this->peg_FAILED) {
                                              $s2 = $this->peg_parsematrix();
                                            }
                                            if ($s2 !== $this->peg_FAILED) {
                                              $s3 = $this->peg_parseEND_MATRIX();
                                              if ($s3 !== $this->peg_FAILED) {
                                                $this->peg_reportedPos = $s0;
                                                $s1 = $this->peg_f38($s2);
                                                $s0 = $s1;
                                              } else {
                                                $this->peg_currPos = $s0;
                                                $s0 = $this->peg_FAILED;
                                              }
                                            } else {
                                              $this->peg_currPos = $s0;
                                              $s0 = $this->peg_FAILED;
                                            }
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                          if ($s0 === $this->peg_FAILED) {
                                            $s0 = $this->peg_currPos;
                                            $s1 = $this->peg_parseBEGIN_PMATRIX();
                                            if ($s1 !== $this->peg_FAILED) {
                                              $s2 = $this->peg_parsearray();
                                              if ($s2 === $this->peg_FAILED) {
                                                $s2 = $this->peg_parsematrix();
                                              }
                                              if ($s2 !== $this->peg_FAILED) {
                                                $s3 = $this->peg_parseEND_PMATRIX();
                                                if ($s3 !== $this->peg_FAILED) {
                                                  $this->peg_reportedPos = $s0;
                                                  $s1 = $this->peg_f39($s2);
                                                  $s0 = $s1;
                                                } else {
                                                  $this->peg_currPos = $s0;
                                                  $s0 = $this->peg_FAILED;
                                                }
                                              } else {
                                                $this->peg_currPos = $s0;
                                                $s0 = $this->peg_FAILED;
                                              }
                                            } else {
                                              $this->peg_currPos = $s0;
                                              $s0 = $this->peg_FAILED;
                                            }
                                            if ($s0 === $this->peg_FAILED) {
                                              $s0 = $this->peg_currPos;
                                              $s1 = $this->peg_parseBEGIN_BMATRIX();
                                              if ($s1 !== $this->peg_FAILED) {
                                                $s2 = $this->peg_parsearray();
                                                if ($s2 === $this->peg_FAILED) {
                                                  $s2 = $this->peg_parsematrix();
                                                }
                                                if ($s2 !== $this->peg_FAILED) {
                                                  $s3 = $this->peg_parseEND_BMATRIX();
                                                  if ($s3 !== $this->peg_FAILED) {
                                                    $this->peg_reportedPos = $s0;
                                                    $s1 = $this->peg_f40($s2);
                                                    $s0 = $s1;
                                                  } else {
                                                    $this->peg_currPos = $s0;
                                                    $s0 = $this->peg_FAILED;
                                                  }
                                                } else {
                                                  $this->peg_currPos = $s0;
                                                  $s0 = $this->peg_FAILED;
                                                }
                                              } else {
                                                $this->peg_currPos = $s0;
                                                $s0 = $this->peg_FAILED;
                                              }
                                              if ($s0 === $this->peg_FAILED) {
                                                $s0 = $this->peg_currPos;
                                                $s1 = $this->peg_parseBEGIN_BBMATRIX();
                                                if ($s1 !== $this->peg_FAILED) {
                                                  $s2 = $this->peg_parsearray();
                                                  if ($s2 === $this->peg_FAILED) {
                                                    $s2 = $this->peg_parsematrix();
                                                  }
                                                  if ($s2 !== $this->peg_FAILED) {
                                                    $s3 = $this->peg_parseEND_BBMATRIX();
                                                    if ($s3 !== $this->peg_FAILED) {
                                                      $this->peg_reportedPos = $s0;
                                                      $s1 = $this->peg_f41($s2);
                                                      $s0 = $s1;
                                                    } else {
                                                      $this->peg_currPos = $s0;
                                                      $s0 = $this->peg_FAILED;
                                                    }
                                                  } else {
                                                    $this->peg_currPos = $s0;
                                                    $s0 = $this->peg_FAILED;
                                                  }
                                                } else {
                                                  $this->peg_currPos = $s0;
                                                  $s0 = $this->peg_FAILED;
                                                }
                                                if ($s0 === $this->peg_FAILED) {
                                                  $s0 = $this->peg_currPos;
                                                  $s1 = $this->peg_parseBEGIN_VMATRIX();
                                                  if ($s1 !== $this->peg_FAILED) {
                                                    $s2 = $this->peg_parsearray();
                                                    if ($s2 === $this->peg_FAILED) {
                                                      $s2 = $this->peg_parsematrix();
                                                    }
                                                    if ($s2 !== $this->peg_FAILED) {
                                                      $s3 = $this->peg_parseEND_VMATRIX();
                                                      if ($s3 !== $this->peg_FAILED) {
                                                        $this->peg_reportedPos = $s0;
                                                        $s1 = $this->peg_f42($s2);
                                                        $s0 = $s1;
                                                      } else {
                                                        $this->peg_currPos = $s0;
                                                        $s0 = $this->peg_FAILED;
                                                      }
                                                    } else {
                                                      $this->peg_currPos = $s0;
                                                      $s0 = $this->peg_FAILED;
                                                    }
                                                  } else {
                                                    $this->peg_currPos = $s0;
                                                    $s0 = $this->peg_FAILED;
                                                  }
                                                  if ($s0 === $this->peg_FAILED) {
                                                    $s0 = $this->peg_currPos;
                                                    $s1 = $this->peg_parseBEGIN_VVMATRIX();
                                                    if ($s1 !== $this->peg_FAILED) {
                                                      $s2 = $this->peg_parsearray();
                                                      if ($s2 === $this->peg_FAILED) {
                                                        $s2 = $this->peg_parsematrix();
                                                      }
                                                      if ($s2 !== $this->peg_FAILED) {
                                                        $s3 = $this->peg_parseEND_VVMATRIX();
                                                        if ($s3 !== $this->peg_FAILED) {
                                                          $this->peg_reportedPos = $s0;
                                                          $s1 = $this->peg_f43($s2);
                                                          $s0 = $s1;
                                                        } else {
                                                          $this->peg_currPos = $s0;
                                                          $s0 = $this->peg_FAILED;
                                                        }
                                                      } else {
                                                        $this->peg_currPos = $s0;
                                                        $s0 = $this->peg_FAILED;
                                                      }
                                                    } else {
                                                      $this->peg_currPos = $s0;
                                                      $s0 = $this->peg_FAILED;
                                                    }
                                                    if ($s0 === $this->peg_FAILED) {
                                                      $s0 = $this->peg_currPos;
                                                      $s1 = $this->peg_parseBEGIN_ARRAY();
                                                      if ($s1 !== $this->peg_FAILED) {
                                                        $s2 = $this->peg_parseopt_pos();
                                                        if ($s2 !== $this->peg_FAILED) {
                                                          $s3 = $this->peg_parsearray();
                                                          if ($s3 !== $this->peg_FAILED) {
                                                            $s4 = $this->peg_parseEND_ARRAY();
                                                            if ($s4 !== $this->peg_FAILED) {
                                                              $this->peg_reportedPos = $s0;
                                                              $s1 = $this->peg_f44($s3);
                                                              $s0 = $s1;
                                                            } else {
                                                              $this->peg_currPos = $s0;
                                                              $s0 = $this->peg_FAILED;
                                                            }
                                                          } else {
                                                            $this->peg_currPos = $s0;
                                                            $s0 = $this->peg_FAILED;
                                                          }
                                                        } else {
                                                          $this->peg_currPos = $s0;
                                                          $s0 = $this->peg_FAILED;
                                                        }
                                                      } else {
                                                        $this->peg_currPos = $s0;
                                                        $s0 = $this->peg_FAILED;
                                                      }
                                                      if ($s0 === $this->peg_FAILED) {
                                                        $s0 = $this->peg_currPos;
                                                        $s1 = $this->peg_parseBEGIN_ALIGN();
                                                        if ($s1 !== $this->peg_FAILED) {
                                                          $s2 = $this->peg_parseopt_pos();
                                                          if ($s2 !== $this->peg_FAILED) {
                                                            $s3 = $this->peg_parsematrix();
                                                            if ($s3 !== $this->peg_FAILED) {
                                                              $s4 = $this->peg_parseEND_ALIGN();
                                                              if ($s4 !== $this->peg_FAILED) {
                                                                $this->peg_reportedPos = $s0;
                                                                $s1 = $this->peg_f45($s3);
                                                                $s0 = $s1;
                                                              } else {
                                                                $this->peg_currPos = $s0;
                                                                $s0 = $this->peg_FAILED;
                                                              }
                                                            } else {
                                                              $this->peg_currPos = $s0;
                                                              $s0 = $this->peg_FAILED;
                                                            }
                                                          } else {
                                                            $this->peg_currPos = $s0;
                                                            $s0 = $this->peg_FAILED;
                                                          }
                                                        } else {
                                                          $this->peg_currPos = $s0;
                                                          $s0 = $this->peg_FAILED;
                                                        }
                                                        if ($s0 === $this->peg_FAILED) {
                                                          $s0 = $this->peg_currPos;
                                                          $s1 = $this->peg_parseBEGIN_ALIGNED();
                                                          if ($s1 !== $this->peg_FAILED) {
                                                            $s2 = $this->peg_parseopt_pos();
                                                            if ($s2 !== $this->peg_FAILED) {
                                                              $s3 = $this->peg_parsematrix();
                                                              if ($s3 !== $this->peg_FAILED) {
                                                                $s4 = $this->peg_parseEND_ALIGNED();
                                                                if ($s4 !== $this->peg_FAILED) {
                                                                  $this->peg_reportedPos = $s0;
                                                                  $s1 = $this->peg_f45($s3);
                                                                  $s0 = $s1;
                                                                } else {
                                                                  $this->peg_currPos = $s0;
                                                                  $s0 = $this->peg_FAILED;
                                                                }
                                                              } else {
                                                                $this->peg_currPos = $s0;
                                                                $s0 = $this->peg_FAILED;
                                                              }
                                                            } else {
                                                              $this->peg_currPos = $s0;
                                                              $s0 = $this->peg_FAILED;
                                                            }
                                                          } else {
                                                            $this->peg_currPos = $s0;
                                                            $s0 = $this->peg_FAILED;
                                                          }
                                                          if ($s0 === $this->peg_FAILED) {
                                                            $s0 = $this->peg_currPos;
                                                            $s1 = $this->peg_parseBEGIN_ALIGNAT();
                                                            if ($s1 !== $this->peg_FAILED) {
                                                              $s2 = $this->peg_parsealignat();
                                                              if ($s2 !== $this->peg_FAILED) {
                                                                $s3 = $this->peg_parseEND_ALIGNAT();
                                                                if ($s3 !== $this->peg_FAILED) {
                                                                  $this->peg_reportedPos = $s0;
                                                                  $s1 = $this->peg_f46($s2);
                                                                  $s0 = $s1;
                                                                } else {
                                                                  $this->peg_currPos = $s0;
                                                                  $s0 = $this->peg_FAILED;
                                                                }
                                                              } else {
                                                                $this->peg_currPos = $s0;
                                                                $s0 = $this->peg_FAILED;
                                                              }
                                                            } else {
                                                              $this->peg_currPos = $s0;
                                                              $s0 = $this->peg_FAILED;
                                                            }
                                                            if ($s0 === $this->peg_FAILED) {
                                                              $s0 = $this->peg_currPos;
                                                              $s1 = $this->peg_parseBEGIN_ALIGNEDAT();
                                                              if ($s1 !== $this->peg_FAILED) {
                                                                $s2 = $this->peg_parsealignat();
                                                                if ($s2 !== $this->peg_FAILED) {
                                                                  $s3 = $this->peg_parseEND_ALIGNEDAT();
                                                                  if ($s3 !== $this->peg_FAILED) {
                                                                    $this->peg_reportedPos = $s0;
                                                                    $s1 = $this->peg_f46($s2);
                                                                    $s0 = $s1;
                                                                  } else {
                                                                    $this->peg_currPos = $s0;
                                                                    $s0 = $this->peg_FAILED;
                                                                  }
                                                                } else {
                                                                  $this->peg_currPos = $s0;
                                                                  $s0 = $this->peg_FAILED;
                                                                }
                                                              } else {
                                                                $this->peg_currPos = $s0;
                                                                $s0 = $this->peg_FAILED;
                                                              }
                                                              if ($s0 === $this->peg_FAILED) {
                                                                $s0 = $this->peg_currPos;
                                                                $s1 = $this->peg_parseBEGIN_SMALLMATRIX();
                                                                if ($s1 !== $this->peg_FAILED) {
                                                                  $s2 = $this->peg_parsearray();
                                                                  if ($s2 === $this->peg_FAILED) {
                                                                    $s2 = $this->peg_parsematrix();
                                                                  }
                                                                  if ($s2 !== $this->peg_FAILED) {
                                                                    $s3 = $this->peg_parseEND_SMALLMATRIX();
                                                                    if ($s3 !== $this->peg_FAILED) {
                                                                      $this->peg_reportedPos = $s0;
                                                                      $s1 = $this->peg_f47($s2);
                                                                      $s0 = $s1;
                                                                    } else {
                                                                      $this->peg_currPos = $s0;
                                                                      $s0 = $this->peg_FAILED;
                                                                    }
                                                                  } else {
                                                                    $this->peg_currPos = $s0;
                                                                    $s0 = $this->peg_FAILED;
                                                                  }
                                                                } else {
                                                                  $this->peg_currPos = $s0;
                                                                  $s0 = $this->peg_FAILED;
                                                                }
                                                                if ($s0 === $this->peg_FAILED) {
                                                                  $s0 = $this->peg_currPos;
                                                                  $s1 = $this->peg_parseBEGIN_CASES();
                                                                  if ($s1 !== $this->peg_FAILED) {
                                                                    $s2 = $this->peg_parsematrix();
                                                                    if ($s2 !== $this->peg_FAILED) {
                                                                      $s3 = $this->peg_parseEND_CASES();
                                                                      if ($s3 !== $this->peg_FAILED) {
                                                                        $this->peg_reportedPos = $s0;
                                                                        $s1 = $this->peg_f48($s2);
                                                                        $s0 = $s1;
                                                                      } else {
                                                                        $this->peg_currPos = $s0;
                                                                        $s0 = $this->peg_FAILED;
                                                                      }
                                                                    } else {
                                                                      $this->peg_currPos = $s0;
                                                                      $s0 = $this->peg_FAILED;
                                                                    }
                                                                  } else {
                                                                    $this->peg_currPos = $s0;
                                                                    $s0 = $this->peg_FAILED;
                                                                  }
                                                                  if ($s0 === $this->peg_FAILED) {
                                                                    $s0 = $this->peg_currPos;
                                                                    if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c9) {
                                                                      $s1 = $this->peg_c9;
                                                                      $this->peg_currPos += 7;
                                                                    } else {
                                                                      $s1 = $this->peg_FAILED;
                                                                      if ($this->peg_silentFails === 0) {
                                                                          $this->peg_fail($this->peg_c10);
                                                                      }
                                                                    }
                                                                    if ($s1 !== $this->peg_FAILED) {
                                                                      $s2 = array();
                                                                      $s3 = $this->peg_parsealpha();
                                                                      if ($s3 !== $this->peg_FAILED) {
                                                                        while ($s3 !== $this->peg_FAILED) {
                                                                          $s2[] = $s3;
                                                                          $s3 = $this->peg_parsealpha();
                                                                        }
                                                                      } else {
                                                                        $s2 = $this->peg_FAILED;
                                                                      }
                                                                      if ($s2 !== $this->peg_FAILED) {
                                                                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                                                          $s3 = $this->peg_c11;
                                                                          $this->peg_currPos++;
                                                                        } else {
                                                                          $s3 = $this->peg_FAILED;
                                                                          if ($this->peg_silentFails === 0) {
                                                                              $this->peg_fail($this->peg_c12);
                                                                          }
                                                                        }
                                                                        if ($s3 !== $this->peg_FAILED) {
                                                                          $this->peg_reportedPos = $s0;
                                                                          $s1 = $this->peg_f49();
                                                                          $s0 = $s1;
                                                                        } else {
                                                                          $this->peg_currPos = $s0;
                                                                          $s0 = $this->peg_FAILED;
                                                                        }
                                                                      } else {
                                                                        $this->peg_currPos = $s0;
                                                                        $s0 = $this->peg_FAILED;
                                                                      }
                                                                    } else {
                                                                      $this->peg_currPos = $s0;
                                                                      $s0 = $this->peg_FAILED;
                                                                    }
                                                                    if ($s0 === $this->peg_FAILED) {
                                                                      $s0 = $this->peg_currPos;
                                                                      $s1 = $this->peg_parsegeneric_func();
                                                                      if ($s1 !== $this->peg_FAILED) {
                                                                        $this->peg_reportedPos = $this->peg_currPos;
                                                                        $s2 = $this->peg_f50($s1);
                                                                        if ($s2) {
                                                                          $s2 = null;
                                                                        } else {
                                                                          $s2 = $this->peg_FAILED;
                                                                        }
                                                                        if ($s2 !== $this->peg_FAILED) {
                                                                          $this->peg_reportedPos = $s0;
                                                                          $s1 = $this->peg_f51($s1);
                                                                          $s0 = $s1;
                                                                        } else {
                                                                          $this->peg_currPos = $s0;
                                                                          $s0 = $this->peg_FAILED;
                                                                        }
                                                                      } else {
                                                                        $this->peg_currPos = $s0;
                                                                        $s0 = $this->peg_FAILED;
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsearray() {

      $key = $this->peg_currPos * 126 + 20;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsecolumn_spec();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsematrix();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f52($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsealignat() {

      $key = $this->peg_currPos * 126 + 21;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsealignat_spec();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsematrix();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f53($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsematrix() {

      $key = $this->peg_currPos * 126 + 22;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseline_start();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        $s3 = $this->peg_parseNEXT_ROW();
        if ($s3 !== $this->peg_FAILED) {
          $s4 = $this->peg_parsematrix();
          if ($s4 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s2;
            $s3 = $this->peg_f54($s1, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 === $this->peg_FAILED) {
          $s2 = null;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f55($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseline_start() {

      $key = $this->peg_currPos * 126 + 23;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseHLINE();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseline_start();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f56($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_parseline();
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseline() {

      $key = $this->peg_currPos * 126 + 24;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseexpr();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        $s3 = $this->peg_parseNEXT_CELL();
        if ($s3 !== $this->peg_FAILED) {
          $s4 = $this->peg_parseline();
          if ($s4 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s2;
            $s3 = $this->peg_f57($s1, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 === $this->peg_FAILED) {
          $s2 = null;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f58($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsecolumn_spec() {

      $key = $this->peg_currPos * 126 + 25;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseCURLY_OPEN();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        $s3 = array();
        $s4 = $this->peg_parseone_col();
        if ($s4 !== $this->peg_FAILED) {
          while ($s4 !== $this->peg_FAILED) {
            $s3[] = $s4;
            $s4 = $this->peg_parseone_col();
          }
        } else {
          $s3 = $this->peg_FAILED;
        }
        if ($s3 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s2;
          $s3 = $this->peg_f59();
        }
        $s2 = $s3;
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseCURLY_CLOSE();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f60($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseone_col() {

      $key = $this->peg_currPos * 126 + 26;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if (peg_regex_test($this->peg_c13, $this->input_substr($this->peg_currPos, 1))) {
        $s1 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c14);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c15) {
          $s1 = $this->peg_c15;
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c16);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseCURLY_OPEN();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = array();
            $s4 = $this->peg_parseboxchars();
            if ($s4 !== $this->peg_FAILED) {
              while ($s4 !== $this->peg_FAILED) {
                $s3[] = $s4;
                $s4 = $this->peg_parseboxchars();
              }
            } else {
              $s3 = $this->peg_FAILED;
            }
            if ($s3 !== $this->peg_FAILED) {
              $s4 = $this->peg_parseCURLY_CLOSE();
              if ($s4 !== $this->peg_FAILED) {
                $s1 = array($s1, $s2, $s3, $s4);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c17) {
            $s1 = $this->peg_c17;
            $this->peg_currPos++;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c18);
            }
          }
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parseCURLY_OPEN();
            if ($s2 !== $this->peg_FAILED) {
              $s3 = array();
              if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
                $s4 = $this->input_substr($this->peg_currPos, 1);
                $this->peg_currPos++;
              } else {
                $s4 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c20);
                }
              }
              if ($s4 !== $this->peg_FAILED) {
                while ($s4 !== $this->peg_FAILED) {
                  $s3[] = $s4;
                  if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
                    $s4 = $this->input_substr($this->peg_currPos, 1);
                    $this->peg_currPos++;
                  } else {
                    $s4 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c20);
                    }
                  }
                }
              } else {
                $s3 = $this->peg_FAILED;
              }
              if ($s3 !== $this->peg_FAILED) {
                $s4 = $this->peg_parse_();
                if ($s4 !== $this->peg_FAILED) {
                  $s5 = $this->peg_parseCURLY_CLOSE();
                  if ($s5 !== $this->peg_FAILED) {
                    $s6 = $this->peg_parseone_col();
                    if ($s6 === $this->peg_FAILED) {
                      $s6 = $this->peg_currPos;
                      $s7 = $this->peg_parseCURLY_OPEN();
                      if ($s7 !== $this->peg_FAILED) {
                        $s8 = array();
                        $s9 = $this->peg_parseone_col();
                        if ($s9 !== $this->peg_FAILED) {
                          while ($s9 !== $this->peg_FAILED) {
                            $s8[] = $s9;
                            $s9 = $this->peg_parseone_col();
                          }
                        } else {
                          $s8 = $this->peg_FAILED;
                        }
                        if ($s8 !== $this->peg_FAILED) {
                          $s9 = $this->peg_parseCURLY_CLOSE();
                          if ($s9 !== $this->peg_FAILED) {
                            $s7 = array($s7, $s8, $s9);
                            $s6 = $s7;
                          } else {
                            $this->peg_currPos = $s6;
                            $s6 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s6;
                          $s6 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s6;
                        $s6 = $this->peg_FAILED;
                      }
                    }
                    if ($s6 !== $this->peg_FAILED) {
                      $s1 = array($s1, $s2, $s3, $s4, $s5, $s6);
                      $s0 = $s1;
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c21) {
              $s1 = $this->peg_c21;
              $this->peg_currPos += 2;
            } else {
              $s1 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c22);
              }
            }
            if ($s1 !== $this->peg_FAILED) {
              $s2 = $this->peg_parse_();
              if ($s2 !== $this->peg_FAILED) {
                $s1 = array($s1, $s2);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c23) {
                $s1 = $this->peg_c23;
                $this->peg_currPos++;
              } else {
                $s1 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c24);
                }
              }
              if ($s1 !== $this->peg_FAILED) {
                $s2 = $this->peg_parse_();
                if ($s2 !== $this->peg_FAILED) {
                  $s1 = array($s1, $s2);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_currPos;
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c25) {
                  $s1 = $this->peg_c25;
                  $this->peg_currPos++;
                } else {
                  $s1 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c26);
                  }
                }
                if ($s1 !== $this->peg_FAILED) {
                  $s2 = $this->peg_parse_();
                  if ($s2 !== $this->peg_FAILED) {
                    $s3 = $this->peg_parseCURLY_OPEN();
                    if ($s3 !== $this->peg_FAILED) {
                      $s4 = array();
                      $s5 = $this->peg_parseboxchars();
                      if ($s5 !== $this->peg_FAILED) {
                        while ($s5 !== $this->peg_FAILED) {
                          $s4[] = $s5;
                          $s5 = $this->peg_parseboxchars();
                        }
                      } else {
                        $s4 = $this->peg_FAILED;
                      }
                      if ($s4 !== $this->peg_FAILED) {
                        $s5 = $this->peg_parseCURLY_CLOSE();
                        if ($s5 !== $this->peg_FAILED) {
                          $s1 = array($s1, $s2, $s3, $s4, $s5);
                          $s0 = $s1;
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsealignat_spec() {

      $key = $this->peg_currPos * 126 + 27;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseCURLY_OPEN();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        $s3 = array();
        if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
          $s4 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s4 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c20);
          }
        }
        if ($s4 !== $this->peg_FAILED) {
          while ($s4 !== $this->peg_FAILED) {
            $s3[] = $s4;
            if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
              $s4 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c20);
              }
            }
          }
        } else {
          $s3 = $this->peg_FAILED;
        }
        if ($s3 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s2;
          $s3 = $this->peg_f59();
        }
        $s2 = $s3;
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parseCURLY_CLOSE();
            if ($s4 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f61($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseopt_pos() {

      $key = $this->peg_currPos * 126 + 28;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
        $s1 = $this->peg_c5;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c6);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c27, $this->input_substr($this->peg_currPos, 1))) {
            $s3 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c28);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
                $s5 = $this->peg_c29;
                $this->peg_currPos++;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c30);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parse_();
                if ($s6 !== $this->peg_FAILED) {
                  $s1 = array($s1, $s2, $s3, $s4, $s5, $s6);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_c2;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_lit() {

      $key = $this->peg_currPos * 126 + 29;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseCURLY_OPEN();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsechem_sentence();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseCURLY_CLOSE();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f36($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_sentence() {

      $key = $this->peg_currPos * 126 + 30;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parse_();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsechem_phrase();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c31) {
            $s3 = $this->peg_c31;
            $this->peg_currPos++;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c32);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parsechem_sentence();
            if ($s4 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f62($s2, $s4);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parse_();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parsechem_phrase();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parse_();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f63($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_phrase() {

      $key = $this->peg_currPos * 126 + 31;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c33) {
        $s1 = $this->peg_c33;
        $this->peg_currPos += 3;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c34);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f64($s1);
      }
      $s0 = $s1;
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parsechem_word();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseCHEM_SINGLE_MACRO();
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f65($s1, $s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parsechem_word();
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f66($s1);
          }
          $s0 = $s1;
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_parseCHEM_SINGLE_MACRO();
            if ($s1 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f64($s1);
            }
            $s0 = $s1;
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c35) {
                $s1 = $this->peg_c35;
                $this->peg_currPos++;
              } else {
                $s1 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c36);
                }
              }
              if ($s1 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f64($s1);
              }
              $s0 = $s1;
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_word() {

      $key = $this->peg_currPos * 126 + 32;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsechem_char();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsechem_word_nt();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f67($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseCHEM_SINGLE_MACRO();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parsechem_char_nl();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parsechem_word_nt();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f68($s1, $s2, $s3);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_word_nt() {

      $key = $this->peg_currPos * 126 + 33;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsechem_word();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f66($s1);
      }
      $s0 = $s1;
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_c2;
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f69();
        }
        $s0 = $s1;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_char() {

      $key = $this->peg_currPos * 126 + 34;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsechem_char_nl();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f70($s1);
      }
      $s0 = $s1;
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseCHEM_LETTER();
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f71($s1);
        }
        $s0 = $s1;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_char_nl() {

      $key = $this->peg_currPos * 126 + 35;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsechem_script();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f70($s1);
      }
      $s0 = $s1;
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseCURLY_OPEN();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parsechem_text();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parseCURLY_CLOSE();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f72($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parseBEGIN_MATH();
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parseexpr();
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parseEND_MATH();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f73($s2);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_parseCHEM_BONDI();
            if ($s1 !== $this->peg_FAILED) {
              $s2 = $this->peg_parsechem_bond();
              if ($s2 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f30($s1, $s2);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              $s1 = $this->peg_parsechem_macro();
              if ($s1 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f66($s1);
              }
              $s0 = $s1;
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_currPos;
                $s1 = $this->peg_parseCHEM_NONLETTER();
                if ($s1 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f71($s1);
                }
                $s0 = $s1;
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_bond() {

      $key = $this->peg_currPos * 126 + 36;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseCURLY_OPEN();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseCHEM_BOND_TYPE();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseCURLY_CLOSE();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f74($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_script() {

      $key = $this->peg_currPos * 126 + 37;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseCHEM_SUPERSUB();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parseCHEM_SCRIPT_FOLLOW();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f75($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseCHEM_SUPERSUB();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parsechem_lit();
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f76($s1, $s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parseCHEM_SUPERSUB();
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parseBEGIN_MATH();
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parseexpr();
              if ($s3 !== $this->peg_FAILED) {
                $s4 = $this->peg_parseEND_MATH();
                if ($s4 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f77($s1, $s3);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_macro() {

      $key = $this->peg_currPos * 126 + 38;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseCHEM_MACRO_2PU();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parsechem_lit();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c37) {
            $s3 = $this->peg_c37;
            $this->peg_currPos++;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c38);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parsechem_lit();
            if ($s4 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f78($s1, $s2, $s4);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseCHEM_MACRO_2PC();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parseCHEM_COLOR();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parsechem_lit();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f33($s1, $s2, $s3);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parseCHEM_MACRO_2P();
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parsechem_lit();
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parsechem_lit();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f33($s1, $s2, $s3);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_parseCHEM_MACRO_1P();
            if ($s1 !== $this->peg_FAILED) {
              $s2 = $this->peg_parsechem_lit();
              if ($s2 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f30($s1, $s2);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsechem_text() {

      $key = $this->peg_currPos * 126 + 39;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = array();
      $s2 = $this->peg_parseboxchars();
      if ($s2 !== $this->peg_FAILED) {
        while ($s2 !== $this->peg_FAILED) {
          $s1[] = $s2;
          $s2 = $this->peg_parseboxchars();
        }
      } else {
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f79($s1);
      }
      $s0 = $s1;

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_COLOR() {

      $key = $this->peg_currPos * 126 + 40;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = array();
          $s4 = $this->peg_parsealpha();
          if ($s4 !== $this->peg_FAILED) {
            while ($s4 !== $this->peg_FAILED) {
              $s3[] = $s4;
              $s4 = $this->peg_parsealpha();
            }
          } else {
            $s3 = $this->peg_FAILED;
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                $s5 = $this->peg_c11;
                $this->peg_currPos++;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parse_();
                if ($s6 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f80($s3);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsealpha() {

      $key = $this->peg_currPos * 126 + 41;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c41, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c42);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseliteral_id() {

      $key = $this->peg_currPos * 126 + 42;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c41, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c42);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseliteral_mn() {

      $key = $this->peg_currPos * 126 + 43;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c20);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseliteral_uf_lt() {

      $key = $this->peg_currPos * 126 + 44;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c43, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c44);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsedelimiter_uf_lt() {

      $key = $this->peg_currPos * 126 + 45;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c45, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c46);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseliteral_uf_op() {

      $key = $this->peg_currPos * 126 + 46;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c47, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c48);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsedelimiter_uf_op() {

      $key = $this->peg_currPos * 126 + 47;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c49, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c50);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseboxchars() {

      $key = $this->peg_currPos * 126 + 48;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c51, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c52);
        }
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if (peg_regex_test($this->peg_c53, $this->input_substr($this->peg_currPos, 1))) {
          $s1 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c54);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c55, $this->input_substr($this->peg_currPos, 1))) {
            $s2 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c56);
            }
          }
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f81($s1, $s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBOX() {

      $key = $this->peg_currPos * 126 + 49;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f82($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
              $s4 = $this->peg_c39;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c40);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = array();
              $s6 = $this->peg_parseboxchars();
              if ($s6 !== $this->peg_FAILED) {
                while ($s6 !== $this->peg_FAILED) {
                  $s5[] = $s6;
                  $s6 = $this->peg_parseboxchars();
                }
              } else {
                $s5 = $this->peg_FAILED;
              }
              if ($s5 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                  $s6 = $this->peg_c11;
                  $this->peg_currPos++;
                } else {
                  $s6 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c12);
                  }
                }
                if ($s6 !== $this->peg_FAILED) {
                  $s7 = $this->peg_parse_();
                  if ($s7 !== $this->peg_FAILED) {
                    $this->peg_reportedPos = $s0;
                    $s1 = $this->peg_f83($s1, $s5);
                    $s0 = $s1;
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseLITERAL() {

      $key = $this->peg_currPos * 126 + 50;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseliteral_id();
      if ($s1 === $this->peg_FAILED) {
        $s1 = $this->peg_parseliteral_mn();
        if ($s1 === $this->peg_FAILED) {
          $s1 = $this->peg_parseliteral_uf_lt();
          if ($s1 === $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c57) {
              $s1 = $this->peg_c57;
              $this->peg_currPos++;
            } else {
              $s1 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c58);
              }
            }
            if ($s1 === $this->peg_FAILED) {
              $s1 = $this->peg_parseliteral_uf_op();
            }
          }
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f84($s1);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parsegeneric_func();
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $this->peg_currPos;
          $s2 = $this->peg_f85($s1);
          if ($s2) {
            $s2 = null;
          } else {
            $s2 = $this->peg_FAILED;
          }
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parse_();
            if ($s3 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c3) {
                $s4 = $this->peg_c3;
                $this->peg_currPos++;
              } else {
                $s4 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c4);
                }
              }
              if ($s4 === $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
                  $s4 = $this->peg_c5;
                  $this->peg_currPos++;
                } else {
                  $s4 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c6);
                  }
                }
                if ($s4 === $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c7) {
                    $s4 = $this->peg_c7;
                    $this->peg_currPos += 2;
                  } else {
                    $s4 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c8);
                    }
                  }
                  if ($s4 === $this->peg_FAILED) {
                    $s4 = $this->peg_currPos;
                    $s5 = $this->peg_c2;
                    if ($s5 !== $this->peg_FAILED) {
                      $this->peg_reportedPos = $s4;
                      $s5 = $this->peg_f20($s1);
                    }
                    $s4 = $s5;
                  }
                }
              }
              if ($s4 !== $this->peg_FAILED) {
                $s5 = $this->peg_parse_();
                if ($s5 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f86($s1, $s4);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parsegeneric_func();
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $this->peg_currPos;
            $s2 = $this->peg_f87($s1);
            if ($s2) {
              $s2 = null;
            } else {
              $s2 = $this->peg_FAILED;
            }
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parse_();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f88($s1);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_parsegeneric_func();
            if ($s1 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $this->peg_currPos;
              $s2 = $this->peg_f89($s1);
              if ($s2) {
                $s2 = null;
              } else {
                $s2 = $this->peg_FAILED;
              }
              if ($s2 !== $this->peg_FAILED) {
                $s3 = $this->peg_parse_();
                if ($s3 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f90($s1);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              $s1 = $this->peg_parsegeneric_func();
              if ($s1 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $this->peg_currPos;
                $s2 = $this->peg_f91($s1);
                if ($s2) {
                  $s2 = null;
                } else {
                  $s2 = $this->peg_FAILED;
                }
                if ($s2 !== $this->peg_FAILED) {
                  $s3 = $this->peg_parse_();
                  if ($s3 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
                      $s4 = $this->peg_c39;
                      $this->peg_currPos++;
                    } else {
                      $s4 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c40);
                      }
                    }
                    if ($s4 !== $this->peg_FAILED) {
                      $s5 = $this->peg_parsegeneric_func();
                      if ($s5 !== $this->peg_FAILED) {
                        $this->peg_reportedPos = $this->peg_currPos;
                        $s6 = $this->peg_f92($s1, $s5);
                        if ($s6) {
                          $s6 = null;
                        } else {
                          $s6 = $this->peg_FAILED;
                        }
                        if ($s6 !== $this->peg_FAILED) {
                          $s7 = $this->peg_parse_();
                          if ($s7 !== $this->peg_FAILED) {
                            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                              $s8 = $this->peg_c11;
                              $this->peg_currPos++;
                            } else {
                              $s8 = $this->peg_FAILED;
                              if ($this->peg_silentFails === 0) {
                                  $this->peg_fail($this->peg_c12);
                              }
                            }
                            if ($s8 !== $this->peg_FAILED) {
                              $s9 = $this->peg_parse_();
                              if ($s9 !== $this->peg_FAILED) {
                                $this->peg_reportedPos = $s0;
                                $s1 = $this->peg_f93($s1, $s5);
                                $s0 = $s1;
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_currPos;
                $s1 = $this->peg_parsegeneric_func();
                if ($s1 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $this->peg_currPos;
                  $s2 = $this->peg_f94($s1);
                  if ($s2) {
                    $s2 = null;
                  } else {
                    $s2 = $this->peg_FAILED;
                  }
                  if ($s2 !== $this->peg_FAILED) {
                    $s3 = $this->peg_parse_();
                    if ($s3 !== $this->peg_FAILED) {
                      $this->peg_reportedPos = $s0;
                      $s1 = $this->peg_f95($s1);
                      $s0 = $s1;
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
                if ($s0 === $this->peg_FAILED) {
                  $s0 = $this->peg_currPos;
                  $s1 = $this->peg_parsegeneric_func();
                  if ($s1 !== $this->peg_FAILED) {
                    $this->peg_reportedPos = $this->peg_currPos;
                    $s2 = $this->peg_f96($s1);
                    if ($s2) {
                      $s2 = null;
                    } else {
                      $s2 = $this->peg_FAILED;
                    }
                    if ($s2 !== $this->peg_FAILED) {
                      $s3 = $this->peg_parse_();
                      if ($s3 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
                          $s4 = $this->peg_c39;
                          $this->peg_currPos++;
                        } else {
                          $s4 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c40);
                          }
                        }
                        if ($s4 !== $this->peg_FAILED) {
                          $s5 = $this->peg_parsegeneric_func();
                          if ($s5 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $this->peg_currPos;
                            $s6 = $this->peg_f97($s1, $s5);
                            if ($s6) {
                              $s6 = null;
                            } else {
                              $s6 = $this->peg_FAILED;
                            }
                            if ($s6 !== $this->peg_FAILED) {
                              $s7 = $this->peg_parse_();
                              if ($s7 !== $this->peg_FAILED) {
                                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                  $s8 = $this->peg_c11;
                                  $this->peg_currPos++;
                                } else {
                                  $s8 = $this->peg_FAILED;
                                  if ($this->peg_silentFails === 0) {
                                      $this->peg_fail($this->peg_c12);
                                  }
                                }
                                if ($s8 !== $this->peg_FAILED) {
                                  $s9 = $this->peg_parse_();
                                  if ($s9 !== $this->peg_FAILED) {
                                    $this->peg_reportedPos = $s0;
                                    $s1 = $this->peg_f98($s1, $s5);
                                    $s0 = $s1;
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                  if ($s0 === $this->peg_FAILED) {
                    $s0 = $this->peg_currPos;
                    $s1 = $this->peg_parseCOLOR();
                    if ($s1 === $this->peg_FAILED) {
                      $s1 = $this->peg_parseDEFINECOLOR();
                    }
                    if ($s1 !== $this->peg_FAILED) {
                      $this->peg_reportedPos = $s0;
                      $s1 = $this->peg_f99($s1);
                    }
                    $s0 = $s1;
                    if ($s0 === $this->peg_FAILED) {
                      $s0 = $this->peg_currPos;
                      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c59) {
                        $s1 = $this->peg_c59;
                        $this->peg_currPos++;
                      } else {
                        $s1 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c60);
                        }
                      }
                      if ($s1 !== $this->peg_FAILED) {
                        if (peg_regex_test($this->peg_c61, $this->input_substr($this->peg_currPos, 1))) {
                          $s2 = $this->input_substr($this->peg_currPos, 1);
                          $this->peg_currPos++;
                        } else {
                          $s2 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c62);
                          }
                        }
                        if ($s2 !== $this->peg_FAILED) {
                          $s3 = $this->peg_parse_();
                          if ($s3 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f100($s2);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                      if ($s0 === $this->peg_FAILED) {
                        $s0 = $this->peg_currPos;
                        if (peg_regex_test($this->peg_c63, $this->input_substr($this->peg_currPos, 1))) {
                          $s1 = $this->input_substr($this->peg_currPos, 1);
                          $this->peg_currPos++;
                        } else {
                          $s1 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c64);
                          }
                        }
                        if ($s1 !== $this->peg_FAILED) {
                          $s2 = $this->peg_parse_();
                          if ($s2 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f84($s1);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                        if ($s0 === $this->peg_FAILED) {
                          $s0 = $this->peg_currPos;
                          if (peg_regex_test($this->peg_c65, $this->input_substr($this->peg_currPos, 1))) {
                            $s1 = $this->input_substr($this->peg_currPos, 1);
                            $this->peg_currPos++;
                          } else {
                            $s1 = $this->peg_FAILED;
                            if ($this->peg_silentFails === 0) {
                                $this->peg_fail($this->peg_c66);
                            }
                          }
                          if ($s1 !== $this->peg_FAILED) {
                            $s2 = $this->peg_parse_();
                            if ($s2 !== $this->peg_FAILED) {
                              $this->peg_reportedPos = $s0;
                              $s1 = $this->peg_f101($s1);
                              $s0 = $s1;
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseDELIMITER() {

      $key = $this->peg_currPos * 126 + 51;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsedelimiter_uf_lt();
      if ($s1 === $this->peg_FAILED) {
        $s1 = $this->peg_parsedelimiter_uf_op();
        if ($s1 === $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
            $s1 = $this->peg_c5;
            $this->peg_currPos++;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c6);
            }
          }
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f84($s1);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c59) {
          $s1 = $this->peg_c59;
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c60);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c67, $this->input_substr($this->peg_currPos, 1))) {
            $s2 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c68);
            }
          }
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parse_();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f100($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parsegeneric_func();
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $this->peg_currPos;
            $s2 = $this->peg_f102($s1);
            if ($s2) {
              $s2 = null;
            } else {
              $s2 = $this->peg_FAILED;
            }
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parse_();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f88($s1);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_parsegeneric_func();
            if ($s1 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $this->peg_currPos;
              $s2 = $this->peg_f103($s1);
              if ($s2) {
                $s2 = null;
              } else {
                $s2 = $this->peg_FAILED;
              }
              if ($s2 !== $this->peg_FAILED) {
                $s3 = $this->peg_parse_();
                if ($s3 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f104($s1);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_AR1nb() {

      $key = $this->peg_currPos * 126 + 52;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f105($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_AR1opt() {

      $key = $this->peg_currPos * 126 + 53;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f106($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
              $s4 = $this->peg_c5;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c6);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f99($s1);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseNEXT_CELL() {

      $key = $this->peg_currPos * 126 + 54;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c69) {
        $s1 = $this->peg_c69;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c70);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseNEXT_ROW() {

      $key = $this->peg_currPos * 126 + 55;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c71) {
        $s1 = $this->peg_c71;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c72);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN() {

      $key = $this->peg_currPos * 126 + 56;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c73) {
        $s1 = $this->peg_c73;
        $this->peg_currPos += 6;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c74);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND() {

      $key = $this->peg_currPos * 126 + 57;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c75) {
        $s1 = $this->peg_c75;
        $this->peg_currPos += 4;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c76);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_MATRIX() {

      $key = $this->peg_currPos * 126 + 58;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 8) === $this->peg_c77) {
          $s2 = $this->peg_c77;
          $this->peg_currPos += 8;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c78);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_MATRIX() {

      $key = $this->peg_currPos * 126 + 59;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 8) === $this->peg_c77) {
          $s2 = $this->peg_c77;
          $this->peg_currPos += 8;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c78);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_PMATRIX() {

      $key = $this->peg_currPos * 126 + 60;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c79) {
          $s2 = $this->peg_c79;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c80);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_PMATRIX() {

      $key = $this->peg_currPos * 126 + 61;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c79) {
          $s2 = $this->peg_c79;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c80);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_BMATRIX() {

      $key = $this->peg_currPos * 126 + 62;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c81) {
          $s2 = $this->peg_c81;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c82);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_BMATRIX() {

      $key = $this->peg_currPos * 126 + 63;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c81) {
          $s2 = $this->peg_c81;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c82);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_BBMATRIX() {

      $key = $this->peg_currPos * 126 + 64;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c83) {
          $s2 = $this->peg_c83;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c84);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_BBMATRIX() {

      $key = $this->peg_currPos * 126 + 65;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c83) {
          $s2 = $this->peg_c83;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c84);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_VMATRIX() {

      $key = $this->peg_currPos * 126 + 66;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c85) {
          $s2 = $this->peg_c85;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c86);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_VMATRIX() {

      $key = $this->peg_currPos * 126 + 67;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c85) {
          $s2 = $this->peg_c85;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c86);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_VVMATRIX() {

      $key = $this->peg_currPos * 126 + 68;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c87) {
          $s2 = $this->peg_c87;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c88);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_VVMATRIX() {

      $key = $this->peg_currPos * 126 + 69;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c87) {
          $s2 = $this->peg_c87;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c88);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_ARRAY() {

      $key = $this->peg_currPos * 126 + 70;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c89) {
          $s2 = $this->peg_c89;
          $this->peg_currPos += 7;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c90);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_ARRAY() {

      $key = $this->peg_currPos * 126 + 71;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c89) {
          $s2 = $this->peg_c89;
          $this->peg_currPos += 7;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c90);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_ALIGN() {

      $key = $this->peg_currPos * 126 + 72;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c91) {
          $s2 = $this->peg_c91;
          $this->peg_currPos += 7;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c92);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_ALIGN() {

      $key = $this->peg_currPos * 126 + 73;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c91) {
          $s2 = $this->peg_c91;
          $this->peg_currPos += 7;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c92);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_ALIGNED() {

      $key = $this->peg_currPos * 126 + 74;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c93) {
          $s2 = $this->peg_c93;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c94);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_ALIGNED() {

      $key = $this->peg_currPos * 126 + 75;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c93) {
          $s2 = $this->peg_c93;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c94);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_ALIGNAT() {

      $key = $this->peg_currPos * 126 + 76;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c95) {
          $s2 = $this->peg_c95;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c96);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_ALIGNAT() {

      $key = $this->peg_currPos * 126 + 77;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 9) === $this->peg_c95) {
          $s2 = $this->peg_c95;
          $this->peg_currPos += 9;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c96);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_ALIGNEDAT() {

      $key = $this->peg_currPos * 126 + 78;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 11) === $this->peg_c97) {
          $s2 = $this->peg_c97;
          $this->peg_currPos += 11;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c98);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_ALIGNEDAT() {

      $key = $this->peg_currPos * 126 + 79;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 11) === $this->peg_c97) {
          $s2 = $this->peg_c97;
          $this->peg_currPos += 11;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c98);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_SMALLMATRIX() {

      $key = $this->peg_currPos * 126 + 80;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 13) === $this->peg_c99) {
          $s2 = $this->peg_c99;
          $this->peg_currPos += 13;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c100);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_SMALLMATRIX() {

      $key = $this->peg_currPos * 126 + 81;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 13) === $this->peg_c99) {
          $s2 = $this->peg_c99;
          $this->peg_currPos += 13;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c100);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_CASES() {

      $key = $this->peg_currPos * 126 + 82;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c101) {
          $s2 = $this->peg_c101;
          $this->peg_currPos += 7;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c102);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_CASES() {

      $key = $this->peg_currPos * 126 + 83;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c101) {
          $s2 = $this->peg_c101;
          $this->peg_currPos += 7;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c102);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseSQ_CLOSE() {

      $key = $this->peg_currPos * 126 + 84;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
        $s1 = $this->peg_c29;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c30);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCURLY_OPEN() {

      $key = $this->peg_currPos * 126 + 85;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCURLY_CLOSE() {

      $key = $this->peg_currPos * 126 + 86;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
        $s1 = $this->peg_c11;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c12);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseSUP() {

      $key = $this->peg_currPos * 126 + 87;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c35) {
        $s1 = $this->peg_c35;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c36);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseSUB() {

      $key = $this->peg_currPos * 126 + 88;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c37) {
        $s1 = $this->peg_c37;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c38);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s1 = array($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parsegeneric_func() {

      $key = $this->peg_currPos * 126 + 89;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c59) {
        $s1 = $this->peg_c59;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c60);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = array();
        $s3 = $this->peg_parsealpha();
        if ($s3 !== $this->peg_FAILED) {
          while ($s3 !== $this->peg_FAILED) {
            $s2[] = $s3;
            $s3 = $this->peg_parsealpha();
          }
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f59();
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBIG() {

      $key = $this->peg_currPos * 126 + 90;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f107($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_AR1() {

      $key = $this->peg_currPos * 126 + 91;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f108($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parsegeneric_func();
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $this->peg_currPos;
          $s2 = $this->peg_f109($s1);
          if ($s2) {
            $s2 = null;
          } else {
            $s2 = $this->peg_FAILED;
          }
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parse_();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f99($s1);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_parsegeneric_func();
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $this->peg_currPos;
            $s2 = $this->peg_f110($s1);
            if ($s2) {
              $s2 = null;
            } else {
              $s2 = $this->peg_FAILED;
            }
            if ($s2 !== $this->peg_FAILED) {
              $s3 = $this->peg_parse_();
              if ($s3 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f111($s1);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_MHCHEM() {

      $key = $this->peg_currPos * 126 + 92;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f112($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_AR2() {

      $key = $this->peg_currPos * 126 + 93;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f113($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_AR4_MHCHEM_TEXIFIED() {

      $key = $this->peg_currPos * 126 + 94;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f114($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_INFIX() {

      $key = $this->peg_currPos * 126 + 95;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f115($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseDECLh() {

      $key = $this->peg_currPos * 126 + 96;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f116($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f117($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseFUN_AR2nb() {

      $key = $this->peg_currPos * 126 + 97;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f118($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseLEFTI() {

      $key = $this->peg_currPos * 126 + 98;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f119($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRIGHTI() {

      $key = $this->peg_currPos * 126 + 99;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f120($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseHLINE() {

      $key = $this->peg_currPos * 126 + 100;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f121($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR() {

      $key = $this->peg_currPos * 126 + 101;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f122($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parseCOLOR_SPEC();
            if ($s4 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f123($s1, $s4);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseDEFINECOLOR() {

      $key = $this->peg_currPos * 126 + 102;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f124($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
              $s4 = $this->peg_c39;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c40);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                $s6 = array();
                $s7 = $this->peg_parsealpha();
                if ($s7 !== $this->peg_FAILED) {
                  while ($s7 !== $this->peg_FAILED) {
                    $s6[] = $s7;
                    $s7 = $this->peg_parsealpha();
                  }
                } else {
                  $s6 = $this->peg_FAILED;
                }
                if ($s6 !== $this->peg_FAILED) {
                  $s7 = $this->peg_parse_();
                  if ($s7 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                      $s8 = $this->peg_c11;
                      $this->peg_currPos++;
                    } else {
                      $s8 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c12);
                      }
                    }
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parse_();
                      if ($s9 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
                          $s10 = $this->peg_c39;
                          $this->peg_currPos++;
                        } else {
                          $s10 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c40);
                          }
                        }
                        if ($s10 !== $this->peg_FAILED) {
                          $s11 = $this->peg_parse_();
                          if ($s11 !== $this->peg_FAILED) {
                            $s12 = $this->peg_currPos;
                            if (mb_strtolower($this->input_substr($this->peg_currPos, 5), "UTF-8") === $this->peg_c103) {
                              $s13 = $this->input_substr($this->peg_currPos, 5);
                              $this->peg_currPos += 5;
                            } else {
                              $s13 = $this->peg_FAILED;
                              if ($this->peg_silentFails === 0) {
                                  $this->peg_fail($this->peg_c104);
                              }
                            }
                            if ($s13 !== $this->peg_FAILED) {
                              $s14 = $this->peg_parse_();
                              if ($s14 !== $this->peg_FAILED) {
                                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                  $s15 = $this->peg_c11;
                                  $this->peg_currPos++;
                                } else {
                                  $s15 = $this->peg_FAILED;
                                  if ($this->peg_silentFails === 0) {
                                      $this->peg_fail($this->peg_c12);
                                  }
                                }
                                if ($s15 !== $this->peg_FAILED) {
                                  $s16 = $this->peg_parse_();
                                  if ($s16 !== $this->peg_FAILED) {
                                    $s17 = $this->peg_parseCOLOR_SPEC_NAMED();
                                    if ($s17 !== $this->peg_FAILED) {
                                      $this->peg_reportedPos = $s12;
                                      $s13 = $this->peg_f125($s1, $s6, $s17);
                                      $s12 = $s13;
                                    } else {
                                      $this->peg_currPos = $s12;
                                      $s12 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s12;
                                    $s12 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s12;
                                  $s12 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s12;
                                $s12 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s12;
                              $s12 = $this->peg_FAILED;
                            }
                            if ($s12 === $this->peg_FAILED) {
                              $s12 = $this->peg_currPos;
                              if (mb_strtolower($this->input_substr($this->peg_currPos, 4), "UTF-8") === $this->peg_c105) {
                                $s13 = $this->input_substr($this->peg_currPos, 4);
                                $this->peg_currPos += 4;
                              } else {
                                $s13 = $this->peg_FAILED;
                                if ($this->peg_silentFails === 0) {
                                    $this->peg_fail($this->peg_c106);
                                }
                              }
                              if ($s13 !== $this->peg_FAILED) {
                                $s14 = $this->peg_parse_();
                                if ($s14 !== $this->peg_FAILED) {
                                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                    $s15 = $this->peg_c11;
                                    $this->peg_currPos++;
                                  } else {
                                    $s15 = $this->peg_FAILED;
                                    if ($this->peg_silentFails === 0) {
                                        $this->peg_fail($this->peg_c12);
                                    }
                                  }
                                  if ($s15 !== $this->peg_FAILED) {
                                    $s16 = $this->peg_parse_();
                                    if ($s16 !== $this->peg_FAILED) {
                                      $s17 = $this->peg_parseCOLOR_SPEC_GRAY();
                                      if ($s17 !== $this->peg_FAILED) {
                                        $this->peg_reportedPos = $s12;
                                        $s13 = $this->peg_f126($s1, $s6, $s17);
                                        $s12 = $s13;
                                      } else {
                                        $this->peg_currPos = $s12;
                                        $s12 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s12;
                                      $s12 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s12;
                                    $s12 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s12;
                                  $s12 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s12;
                                $s12 = $this->peg_FAILED;
                              }
                              if ($s12 === $this->peg_FAILED) {
                                $s12 = $this->peg_currPos;
                                if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c107) {
                                  $s13 = $this->peg_c107;
                                  $this->peg_currPos += 3;
                                } else {
                                  $s13 = $this->peg_FAILED;
                                  if ($this->peg_silentFails === 0) {
                                      $this->peg_fail($this->peg_c108);
                                  }
                                }
                                if ($s13 !== $this->peg_FAILED) {
                                  $s14 = $this->peg_parse_();
                                  if ($s14 !== $this->peg_FAILED) {
                                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                      $s15 = $this->peg_c11;
                                      $this->peg_currPos++;
                                    } else {
                                      $s15 = $this->peg_FAILED;
                                      if ($this->peg_silentFails === 0) {
                                          $this->peg_fail($this->peg_c12);
                                      }
                                    }
                                    if ($s15 !== $this->peg_FAILED) {
                                      $s16 = $this->peg_parse_();
                                      if ($s16 !== $this->peg_FAILED) {
                                        $s17 = $this->peg_parseCOLOR_SPEC_rgb();
                                        if ($s17 !== $this->peg_FAILED) {
                                          $this->peg_reportedPos = $s12;
                                          $s13 = $this->peg_f127($s1, $s6, $s17);
                                          $s12 = $s13;
                                        } else {
                                          $this->peg_currPos = $s12;
                                          $s12 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s12;
                                        $s12 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s12;
                                      $s12 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s12;
                                    $s12 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s12;
                                  $s12 = $this->peg_FAILED;
                                }
                                if ($s12 === $this->peg_FAILED) {
                                  $s12 = $this->peg_currPos;
                                  if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c109) {
                                    $s13 = $this->peg_c109;
                                    $this->peg_currPos += 3;
                                  } else {
                                    $s13 = $this->peg_FAILED;
                                    if ($this->peg_silentFails === 0) {
                                        $this->peg_fail($this->peg_c110);
                                    }
                                  }
                                  if ($s13 !== $this->peg_FAILED) {
                                    $s14 = $this->peg_parse_();
                                    if ($s14 !== $this->peg_FAILED) {
                                      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                        $s15 = $this->peg_c11;
                                        $this->peg_currPos++;
                                      } else {
                                        $s15 = $this->peg_FAILED;
                                        if ($this->peg_silentFails === 0) {
                                            $this->peg_fail($this->peg_c12);
                                        }
                                      }
                                      if ($s15 !== $this->peg_FAILED) {
                                        $s16 = $this->peg_parse_();
                                        if ($s16 !== $this->peg_FAILED) {
                                          $s17 = $this->peg_parseCOLOR_SPEC_RGBI();
                                          if ($s17 !== $this->peg_FAILED) {
                                            $this->peg_reportedPos = $s12;
                                            $s13 = $this->peg_f127($s1, $s6, $s17);
                                            $s12 = $s13;
                                          } else {
                                            $this->peg_currPos = $s12;
                                            $s12 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s12;
                                          $s12 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s12;
                                        $s12 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s12;
                                      $s12 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s12;
                                    $s12 = $this->peg_FAILED;
                                  }
                                  if ($s12 === $this->peg_FAILED) {
                                    $s12 = $this->peg_currPos;
                                    if (mb_strtolower($this->input_substr($this->peg_currPos, 4), "UTF-8") === $this->peg_c111) {
                                      $s13 = $this->input_substr($this->peg_currPos, 4);
                                      $this->peg_currPos += 4;
                                    } else {
                                      $s13 = $this->peg_FAILED;
                                      if ($this->peg_silentFails === 0) {
                                          $this->peg_fail($this->peg_c112);
                                      }
                                    }
                                    if ($s13 !== $this->peg_FAILED) {
                                      $s14 = $this->peg_parse_();
                                      if ($s14 !== $this->peg_FAILED) {
                                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                          $s15 = $this->peg_c11;
                                          $this->peg_currPos++;
                                        } else {
                                          $s15 = $this->peg_FAILED;
                                          if ($this->peg_silentFails === 0) {
                                              $this->peg_fail($this->peg_c12);
                                          }
                                        }
                                        if ($s15 !== $this->peg_FAILED) {
                                          $s16 = $this->peg_parse_();
                                          if ($s16 !== $this->peg_FAILED) {
                                            $s17 = $this->peg_parseCOLOR_SPEC_CMYK();
                                            if ($s17 !== $this->peg_FAILED) {
                                              $this->peg_reportedPos = $s12;
                                              $s13 = $this->peg_f128($s1, $s6, $s17);
                                              $s12 = $s13;
                                            } else {
                                              $this->peg_currPos = $s12;
                                              $s12 = $this->peg_FAILED;
                                            }
                                          } else {
                                            $this->peg_currPos = $s12;
                                            $s12 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s12;
                                          $s12 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s12;
                                        $s12 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s12;
                                      $s12 = $this->peg_FAILED;
                                    }
                                  }
                                }
                              }
                            }
                            if ($s12 !== $this->peg_FAILED) {
                              $this->peg_reportedPos = $s0;
                              $s1 = $this->peg_f129($s1, $s6, $s12);
                              $s0 = $s1;
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR_SPEC() {

      $key = $this->peg_currPos * 126 + 103;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parseCOLOR_SPEC_NAMED();
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
          $s1 = $this->peg_c5;
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parse_();
          if ($s2 !== $this->peg_FAILED) {
            if (mb_strtolower($this->input_substr($this->peg_currPos, 5), "UTF-8") === $this->peg_c103) {
              $s3 = $this->input_substr($this->peg_currPos, 5);
              $this->peg_currPos += 5;
            } else {
              $s3 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c104);
              }
            }
            if ($s3 !== $this->peg_FAILED) {
              $s4 = $this->peg_parse_();
              if ($s4 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
                  $s5 = $this->peg_c29;
                  $this->peg_currPos++;
                } else {
                  $s5 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c30);
                  }
                }
                if ($s5 !== $this->peg_FAILED) {
                  $s6 = $this->peg_parse_();
                  if ($s6 !== $this->peg_FAILED) {
                    $s7 = $this->peg_parseCOLOR_SPEC_NAMED();
                    if ($s7 !== $this->peg_FAILED) {
                      $this->peg_reportedPos = $s0;
                      $s1 = $this->peg_f130($s7);
                      $s0 = $s1;
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
            $s1 = $this->peg_c5;
            $this->peg_currPos++;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c6);
            }
          }
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parse_();
            if ($s2 !== $this->peg_FAILED) {
              if (mb_strtolower($this->input_substr($this->peg_currPos, 4), "UTF-8") === $this->peg_c105) {
                $s3 = $this->input_substr($this->peg_currPos, 4);
                $this->peg_currPos += 4;
              } else {
                $s3 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c106);
                }
              }
              if ($s3 !== $this->peg_FAILED) {
                $s4 = $this->peg_parse_();
                if ($s4 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
                    $s5 = $this->peg_c29;
                    $this->peg_currPos++;
                  } else {
                    $s5 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c30);
                    }
                  }
                  if ($s5 !== $this->peg_FAILED) {
                    $s6 = $this->peg_parse_();
                    if ($s6 !== $this->peg_FAILED) {
                      $s7 = $this->peg_parseCOLOR_SPEC_GRAY();
                      if ($s7 !== $this->peg_FAILED) {
                        $this->peg_reportedPos = $s0;
                        $s1 = $this->peg_f131($s7);
                        $s0 = $s1;
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
              $s1 = $this->peg_c5;
              $this->peg_currPos++;
            } else {
              $s1 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c6);
              }
            }
            if ($s1 !== $this->peg_FAILED) {
              $s2 = $this->peg_parse_();
              if ($s2 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c107) {
                  $s3 = $this->peg_c107;
                  $this->peg_currPos += 3;
                } else {
                  $s3 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c108);
                  }
                }
                if ($s3 !== $this->peg_FAILED) {
                  $s4 = $this->peg_parse_();
                  if ($s4 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
                      $s5 = $this->peg_c29;
                      $this->peg_currPos++;
                    } else {
                      $s5 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c30);
                      }
                    }
                    if ($s5 !== $this->peg_FAILED) {
                      $s6 = $this->peg_parse_();
                      if ($s6 !== $this->peg_FAILED) {
                        $s7 = $this->peg_parseCOLOR_SPEC_rgb();
                        if ($s7 !== $this->peg_FAILED) {
                          $this->peg_reportedPos = $s0;
                          $s1 = $this->peg_f132($s7);
                          $s0 = $s1;
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
                $s1 = $this->peg_c5;
                $this->peg_currPos++;
              } else {
                $s1 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c6);
                }
              }
              if ($s1 !== $this->peg_FAILED) {
                $s2 = $this->peg_parse_();
                if ($s2 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c109) {
                    $s3 = $this->peg_c109;
                    $this->peg_currPos += 3;
                  } else {
                    $s3 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c110);
                    }
                  }
                  if ($s3 !== $this->peg_FAILED) {
                    $s4 = $this->peg_parse_();
                    if ($s4 !== $this->peg_FAILED) {
                      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
                        $s5 = $this->peg_c29;
                        $this->peg_currPos++;
                      } else {
                        $s5 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c30);
                        }
                      }
                      if ($s5 !== $this->peg_FAILED) {
                        $s6 = $this->peg_parse_();
                        if ($s6 !== $this->peg_FAILED) {
                          $s7 = $this->peg_parseCOLOR_SPEC_RGBI();
                          if ($s7 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f132($s7);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_currPos;
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c5) {
                  $s1 = $this->peg_c5;
                  $this->peg_currPos++;
                } else {
                  $s1 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c6);
                  }
                }
                if ($s1 !== $this->peg_FAILED) {
                  $s2 = $this->peg_parse_();
                  if ($s2 !== $this->peg_FAILED) {
                    if (mb_strtolower($this->input_substr($this->peg_currPos, 4), "UTF-8") === $this->peg_c111) {
                      $s3 = $this->input_substr($this->peg_currPos, 4);
                      $this->peg_currPos += 4;
                    } else {
                      $s3 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c112);
                      }
                    }
                    if ($s3 !== $this->peg_FAILED) {
                      $s4 = $this->peg_parse_();
                      if ($s4 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c29) {
                          $s5 = $this->peg_c29;
                          $this->peg_currPos++;
                        } else {
                          $s5 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c30);
                          }
                        }
                        if ($s5 !== $this->peg_FAILED) {
                          $s6 = $this->peg_parse_();
                          if ($s6 !== $this->peg_FAILED) {
                            $s7 = $this->peg_parseCOLOR_SPEC_CMYK();
                            if ($s7 !== $this->peg_FAILED) {
                              $this->peg_reportedPos = $s0;
                              $s1 = $this->peg_f133($s7);
                              $s0 = $s1;
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR_SPEC_NAMED() {

      $key = $this->peg_currPos * 126 + 104;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = array();
          $s4 = $this->peg_parsealpha();
          if ($s4 !== $this->peg_FAILED) {
            while ($s4 !== $this->peg_FAILED) {
              $s3[] = $s4;
              $s4 = $this->peg_parsealpha();
            }
          } else {
            $s3 = $this->peg_FAILED;
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                $s5 = $this->peg_c11;
                $this->peg_currPos++;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parse_();
                if ($s6 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f134($s3);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR_SPEC_GRAY() {

      $key = $this->peg_currPos * 126 + 105;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = array();
          $s4 = $this->peg_parseCNUM();
          if ($s4 !== $this->peg_FAILED) {
            while ($s4 !== $this->peg_FAILED) {
              $s3[] = $s4;
              $s4 = $this->peg_parseCNUM();
            }
          } else {
            $s3 = $this->peg_FAILED;
          }
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
              $s4 = $this->peg_c11;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c12);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f135($s3);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR_SPEC_rgb() {

      $key = $this->peg_currPos * 126 + 106;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseCNUM();
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
              $s4 = $this->peg_c113;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c114);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parseCNUM();
                if ($s6 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
                    $s7 = $this->peg_c113;
                    $this->peg_currPos++;
                  } else {
                    $s7 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c114);
                    }
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parseCNUM();
                      if ($s9 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                          $s10 = $this->peg_c11;
                          $this->peg_currPos++;
                        } else {
                          $s10 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c12);
                          }
                        }
                        if ($s10 !== $this->peg_FAILED) {
                          $s11 = $this->peg_parse_();
                          if ($s11 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f136($s3, $s6, $s9);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR_SPEC_RGBI() {

      $key = $this->peg_currPos * 126 + 107;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseCNUM255();
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
              $s4 = $this->peg_c113;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c114);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parseCNUM255();
                if ($s6 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
                    $s7 = $this->peg_c113;
                    $this->peg_currPos++;
                  } else {
                    $s7 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c114);
                    }
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parseCNUM255();
                      if ($s9 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                          $s10 = $this->peg_c11;
                          $this->peg_currPos++;
                        } else {
                          $s10 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c12);
                          }
                        }
                        if ($s10 !== $this->peg_FAILED) {
                          $s11 = $this->peg_parse_();
                          if ($s11 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f136($s3, $s6, $s9);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCOLOR_SPEC_CMYK() {

      $key = $this->peg_currPos * 126 + 108;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c39) {
        $s1 = $this->peg_c39;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c40);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseCNUM();
          if ($s3 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
              $s4 = $this->peg_c113;
              $this->peg_currPos++;
            } else {
              $s4 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c114);
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parseCNUM();
                if ($s6 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
                    $s7 = $this->peg_c113;
                    $this->peg_currPos++;
                  } else {
                    $s7 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c114);
                    }
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parseCNUM();
                      if ($s9 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c113) {
                          $s10 = $this->peg_c113;
                          $this->peg_currPos++;
                        } else {
                          $s10 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c114);
                          }
                        }
                        if ($s10 !== $this->peg_FAILED) {
                          $s11 = $this->peg_parse_();
                          if ($s11 !== $this->peg_FAILED) {
                            $s12 = $this->peg_parseCNUM();
                            if ($s12 !== $this->peg_FAILED) {
                              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c11) {
                                $s13 = $this->peg_c11;
                                $this->peg_currPos++;
                              } else {
                                $s13 = $this->peg_FAILED;
                                if ($this->peg_silentFails === 0) {
                                    $this->peg_fail($this->peg_c12);
                                }
                              }
                              if ($s13 !== $this->peg_FAILED) {
                                $s14 = $this->peg_parse_();
                                if ($s14 !== $this->peg_FAILED) {
                                  $this->peg_reportedPos = $s0;
                                  $s1 = $this->peg_f137($s3, $s6, $s9, $s12);
                                  $s0 = $s1;
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCNUM255() {

      $key = $this->peg_currPos * 126 + 109;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c115) {
        $s2 = $this->peg_c115;
        $this->peg_currPos++;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c116);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        if (peg_regex_test($this->peg_c117, $this->input_substr($this->peg_currPos, 1))) {
          $s3 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s3 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c118);
          }
        }
        if ($s3 !== $this->peg_FAILED) {
          $s4 = $this->peg_currPos;
          if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
            $s5 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c20);
            }
          }
          if ($s5 !== $this->peg_FAILED) {
            if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
              $s6 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s6 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c20);
              }
            }
            if ($s6 === $this->peg_FAILED) {
              $s6 = null;
            }
            if ($s6 !== $this->peg_FAILED) {
              $s5 = array($s5, $s6);
              $s4 = $s5;
            } else {
              $this->peg_currPos = $s4;
              $s4 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s4;
            $s4 = $this->peg_FAILED;
          }
          if ($s4 === $this->peg_FAILED) {
            $s4 = null;
          }
          if ($s4 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
      }
      if ($s2 !== $this->peg_FAILED) {
        $s1 = $this->input_substr($s1, $this->peg_currPos - $s1);
      } else {
        $s1 = $s2;
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f138($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f139($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCNUM() {

      $key = $this->peg_currPos * 126 + 110;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $s2 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c115) {
        $s3 = $this->peg_c115;
        $this->peg_currPos++;
      } else {
        $s3 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c116);
        }
      }
      if ($s3 === $this->peg_FAILED) {
        $s3 = null;
      }
      if ($s3 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c119) {
          $s4 = $this->peg_c119;
          $this->peg_currPos++;
        } else {
          $s4 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c120);
          }
        }
        if ($s4 !== $this->peg_FAILED) {
          $s5 = array();
          if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
            $s6 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s6 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c20);
            }
          }
          if ($s6 !== $this->peg_FAILED) {
            while ($s6 !== $this->peg_FAILED) {
              $s5[] = $s6;
              if (peg_regex_test($this->peg_c19, $this->input_substr($this->peg_currPos, 1))) {
                $s6 = $this->input_substr($this->peg_currPos, 1);
                $this->peg_currPos++;
              } else {
                $s6 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c20);
                }
              }
            }
          } else {
            $s5 = $this->peg_FAILED;
          }
          if ($s5 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4, $s5);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s2;
        $s2 = $this->peg_FAILED;
      }
      if ($s2 !== $this->peg_FAILED) {
        $s1 = $this->input_substr($s1, $this->peg_currPos - $s1);
      } else {
        $s1 = $s2;
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f140($s1);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_currPos;
        $s2 = $this->peg_currPos;
        if (peg_regex_test($this->peg_c121, $this->input_substr($this->peg_currPos, 1))) {
          $s3 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s3 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c122);
          }
        }
        if ($s3 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c119) {
            $s4 = $this->peg_c119;
            $this->peg_currPos++;
          } else {
            $s4 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c120);
            }
          }
          if ($s4 === $this->peg_FAILED) {
            $s4 = null;
          }
          if ($s4 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s1 = $this->input_substr($s1, $this->peg_currPos - $s1);
        } else {
          $s1 = $s2;
        }
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parse_();
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f140($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_SINGLE_MACRO() {

      $key = $this->peg_currPos * 126 + 111;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f141($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f99($s1);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c59) {
          $s1 = $this->peg_c59;
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c60);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c61, $this->input_substr($this->peg_currPos, 1))) {
            $s2 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c62);
            }
          }
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f100($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_BONDI() {

      $key = $this->peg_currPos * 126 + 112;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f142($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_MACRO_1P() {

      $key = $this->peg_currPos * 126 + 113;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f143($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_MACRO_2P() {

      $key = $this->peg_currPos * 126 + 114;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f144($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_MACRO_2PU() {

      $key = $this->peg_currPos * 126 + 115;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f145($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_MACRO_2PC() {

      $key = $this->peg_currPos * 126 + 116;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parsegeneric_func();
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $this->peg_currPos;
        $s2 = $this->peg_f146($s1);
        if ($s2) {
          $s2 = null;
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f99($s1);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_SCRIPT_FOLLOW() {

      $key = $this->peg_currPos * 126 + 117;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parseliteral_mn();
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_parseliteral_id();
        if ($s0 === $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c123, $this->input_substr($this->peg_currPos, 1))) {
            $s0 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s0 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c124);
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_SUPERSUB() {

      $key = $this->peg_currPos * 126 + 118;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c37) {
        $s0 = $this->peg_c37;
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c38);
        }
      }
      if ($s0 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c35) {
          $s0 = $this->peg_c35;
          $this->peg_currPos++;
        } else {
          $s0 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c36);
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_BOND_TYPE() {

      $key = $this->peg_currPos * 126 + 119;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c125) {
        $s0 = $this->peg_c125;
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c126);
        }
      }
      if ($s0 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c127) {
          $s0 = $this->peg_c127;
          $this->peg_currPos++;
        } else {
          $s0 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c128);
          }
        }
        if ($s0 === $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c129) {
            $s0 = $this->peg_c129;
            $this->peg_currPos += 3;
          } else {
            $s0 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c130);
            }
          }
          if ($s0 === $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c131) {
              $s0 = $this->peg_c131;
              $this->peg_currPos += 2;
            } else {
              $s0 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c132);
              }
            }
            if ($s0 === $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c133) {
                $s0 = $this->peg_c133;
                $this->peg_currPos += 2;
              } else {
                $s0 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c134);
                }
              }
              if ($s0 === $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c135) {
                  $s0 = $this->peg_c135;
                  $this->peg_currPos++;
                } else {
                  $s0 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c136);
                  }
                }
                if ($s0 === $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c137) {
                    $s0 = $this->peg_c137;
                    $this->peg_currPos += 3;
                  } else {
                    $s0 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c138);
                    }
                  }
                  if ($s0 === $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c139) {
                      $s0 = $this->peg_c139;
                      $this->peg_currPos += 4;
                    } else {
                      $s0 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c140);
                      }
                    }
                    if ($s0 === $this->peg_FAILED) {
                      if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c141) {
                        $s0 = $this->peg_c141;
                        $this->peg_currPos += 3;
                      } else {
                        $s0 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c142);
                        }
                      }
                      if ($s0 === $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c143) {
                          $s0 = $this->peg_c143;
                          $this->peg_currPos += 2;
                        } else {
                          $s0 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c144);
                          }
                        }
                        if ($s0 === $this->peg_FAILED) {
                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c145) {
                            $s0 = $this->peg_c145;
                            $this->peg_currPos += 2;
                          } else {
                            $s0 = $this->peg_FAILED;
                            if ($this->peg_silentFails === 0) {
                                $this->peg_fail($this->peg_c146);
                            }
                          }
                          if ($s0 === $this->peg_FAILED) {
                            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c57) {
                              $s0 = $this->peg_c57;
                              $this->peg_currPos++;
                            } else {
                              $s0 = $this->peg_FAILED;
                              if ($this->peg_silentFails === 0) {
                                  $this->peg_fail($this->peg_c58);
                              }
                            }
                            if ($s0 === $this->peg_FAILED) {
                              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c147) {
                                $s0 = $this->peg_c147;
                                $this->peg_currPos++;
                              } else {
                                $s0 = $this->peg_FAILED;
                                if ($this->peg_silentFails === 0) {
                                    $this->peg_fail($this->peg_c148);
                                }
                              }
                              if ($s0 === $this->peg_FAILED) {
                                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c149) {
                                  $s0 = $this->peg_c149;
                                  $this->peg_currPos++;
                                } else {
                                  $s0 = $this->peg_FAILED;
                                  if ($this->peg_silentFails === 0) {
                                      $this->peg_fail($this->peg_c150);
                                  }
                                }
                                if ($s0 === $this->peg_FAILED) {
                                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c151) {
                                    $s0 = $this->peg_c151;
                                    $this->peg_currPos++;
                                  } else {
                                    $s0 = $this->peg_FAILED;
                                    if ($this->peg_silentFails === 0) {
                                        $this->peg_fail($this->peg_c152);
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBEGIN_MATH() {

      $key = $this->peg_currPos * 126 + 120;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseBEGIN();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c153) {
          $s2 = $this->peg_c153;
          $this->peg_currPos += 6;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c154);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEND_MATH() {

      $key = $this->peg_currPos * 126 + 121;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseEND();
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c153) {
          $s2 = $this->peg_c153;
          $this->peg_currPos += 6;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c154);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parse_();
          if ($s3 !== $this->peg_FAILED) {
            $s1 = array($s1, $s2, $s3);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_LETTER() {

      $key = $this->peg_currPos * 126 + 122;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c41, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c42);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCHEM_NONLETTER() {

      $key = $this->peg_currPos * 126 + 123;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c7) {
        $s1 = $this->peg_c7;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c8);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f84($s1);
      }
      $s0 = $s1;
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c155) {
          $s1 = $this->peg_c155;
          $this->peg_currPos += 2;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c156);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f84($s1);
        }
        $s0 = $s1;
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c71) {
            $s1 = $this->peg_c71;
            $this->peg_currPos += 2;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c72);
            }
          }
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f84($s1);
          }
          $s0 = $s1;
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            if (peg_regex_test($this->peg_c157, $this->input_substr($this->peg_currPos, 1))) {
              $s1 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s1 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c158);
              }
            }
            if ($s1 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f84($s1);
            }
            $s0 = $s1;
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_currPos;
              $s1 = $this->peg_parseliteral_mn();
              if ($s1 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f84($s1);
              }
              $s0 = $s1;
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_currPos;
                $s1 = $this->peg_parseCURLY_OPEN();
                if ($s1 !== $this->peg_FAILED) {
                  $s2 = $this->peg_parseCURLY_CLOSE();
                  if ($s2 !== $this->peg_FAILED) {
                    $this->peg_reportedPos = $s0;
                    $s1 = $this->peg_f147();
                    $s0 = $s1;
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseimpossible() {

      $key = $this->peg_currPos * 126 + 124;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_reportedPos = $this->peg_currPos;
      $s0 = $this->peg_f148();
      if ($s0) {
        $s0 = null;
      } else {
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEOF() {

      $key = $this->peg_currPos * 126 + 125;
      $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_reportedPos = $this->peg_currPos;
      $s0 = $this->peg_f149();
      if ($s0) {
        $s0 = null;
      } else {
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

  public function parse($input) {
    $arguments = func_get_args();
    $options = count($arguments) > 1 ? $arguments[1] : array();
    $this->cleanup_state();

    if (is_array($input)) {
        $this->input = $input;
    } else {
        preg_match_all("/./us", $input, $match);
        $this->input = $match[0];
    }
    $this->input_length = count($this->input);

    $old_regex_encoding = mb_regex_encoding();
    mb_regex_encoding("UTF-8");

    $this->peg_FAILED = new \stdClass;
    $this->peg_c0 = "/^[ \\t\\n\\r]/";
    $this->peg_c1 = array( "type" => "class", "value" => "[ \t\n\r]", "description" => "[ \t\n\r]" );
    $this->peg_c2 = "";
    $this->peg_c3 = "(";
    $this->peg_c4 = array( "type" => "literal", "value" => "(", "description" => "\"(\"" );
    $this->peg_c5 = "[";
    $this->peg_c6 = array( "type" => "literal", "value" => "[", "description" => "\"[\"" );
    $this->peg_c7 = "\\{";
    $this->peg_c8 = array( "type" => "literal", "value" => "\\{", "description" => "\"\\\\{\"" );
    $this->peg_c9 = "\\begin{";
    $this->peg_c10 = array( "type" => "literal", "value" => "\\begin{", "description" => "\"\\\\begin{\"" );
    $this->peg_c11 = "}";
    $this->peg_c12 = array( "type" => "literal", "value" => "}", "description" => "\"}\"" );
    $this->peg_c13 = "/^[lrc]/";
    $this->peg_c14 = array( "type" => "class", "value" => "[lrc]", "description" => "[lrc]" );
    $this->peg_c15 = "p";
    $this->peg_c16 = array( "type" => "literal", "value" => "p", "description" => "\"p\"" );
    $this->peg_c17 = "*";
    $this->peg_c18 = array( "type" => "literal", "value" => "*", "description" => "\"*\"" );
    $this->peg_c19 = "/^[0-9]/";
    $this->peg_c20 = array( "type" => "class", "value" => "[0-9]", "description" => "[0-9]" );
    $this->peg_c21 = "||";
    $this->peg_c22 = array( "type" => "literal", "value" => "||", "description" => "\"||\"" );
    $this->peg_c23 = "|";
    $this->peg_c24 = array( "type" => "literal", "value" => "|", "description" => "\"|\"" );
    $this->peg_c25 = "@";
    $this->peg_c26 = array( "type" => "literal", "value" => "@", "description" => "\"@\"" );
    $this->peg_c27 = "/^[tcb]/";
    $this->peg_c28 = array( "type" => "class", "value" => "[tcb]", "description" => "[tcb]" );
    $this->peg_c29 = "]";
    $this->peg_c30 = array( "type" => "literal", "value" => "]", "description" => "\"]\"" );
    $this->peg_c31 = " ";
    $this->peg_c32 = array( "type" => "literal", "value" => " ", "description" => "\" \"" );
    $this->peg_c33 = "(^)";
    $this->peg_c34 = array( "type" => "literal", "value" => "(^)", "description" => "\"(^)\"" );
    $this->peg_c35 = "^";
    $this->peg_c36 = array( "type" => "literal", "value" => "^", "description" => "\"^\"" );
    $this->peg_c37 = "_";
    $this->peg_c38 = array( "type" => "literal", "value" => "_", "description" => "\"_\"" );
    $this->peg_c39 = "{";
    $this->peg_c40 = array( "type" => "literal", "value" => "{", "description" => "\"{\"" );
    $this->peg_c41 = "/^[a-zA-Z]/";
    $this->peg_c42 = array( "type" => "class", "value" => "[a-zA-Z]", "description" => "[a-zA-Z]" );
    $this->peg_c43 = "/^[,:;?!']/";
    $this->peg_c44 = array( "type" => "class", "value" => "[,:;?!']", "description" => "[,:;?!']" );
    $this->peg_c45 = "/^[\\(\\).]/";
    $this->peg_c46 = array( "type" => "class", "value" => "[().]", "description" => "[().]" );
    $this->peg_c47 = "/^[-+*=]/";
    $this->peg_c48 = array( "type" => "class", "value" => "[-+*=]", "description" => "[-+*=]" );
    $this->peg_c49 = "/^[\\/|]/";
    $this->peg_c50 = array( "type" => "class", "value" => "[/|]", "description" => "[/|]" );
    $this->peg_c51 = "/^[-0-9a-zA-Z+*,=\\(\\):\\/;?.!'` \\[\\]\\[\\x{0080}-\\x{D7FF}\\]\\[\\x{E000}-\\x{FFFF}\\]]/";
    $this->peg_c52 = array( "type" => "class", "value" => "[-0-9a-zA-Z+*,=():/;?.!'` [][\x{0080}-\x{D7FF}][\x{E000}-\x{FFFF}]]", "description" => "[-0-9a-zA-Z+*,=():/;?.!'` [][\x{0080}-\x{D7FF}][\x{E000}-\x{FFFF}]]" );
    $this->peg_c53 = "/^[\\x{D800}-\\x{DBFF}]/";
    $this->peg_c54 = array( "type" => "class", "value" => "[\x{D800}-\x{DBFF}]", "description" => "[\x{D800}-\x{DBFF}]" );
    $this->peg_c55 = "/^[\\x{DC00}-\\x{DFFF}]/";
    $this->peg_c56 = array( "type" => "class", "value" => "[\x{DC00}-\x{DFFF}]", "description" => "[\x{DC00}-\x{DFFF}]" );
    $this->peg_c57 = "-";
    $this->peg_c58 = array( "type" => "literal", "value" => "-", "description" => "\"-\"" );
    $this->peg_c59 = "\\";
    $this->peg_c60 = array( "type" => "literal", "value" => "\\", "description" => "\"\\\\\"" );
    $this->peg_c61 = "/^[, ;!_#%\\\$&]/";
    $this->peg_c62 = array( "type" => "class", "value" => "[, ;!_#%\$&]", "description" => "[, ;!_#%\$&]" );
    $this->peg_c63 = "/^[><~]/";
    $this->peg_c64 = array( "type" => "class", "value" => "[><~]", "description" => "[><~]" );
    $this->peg_c65 = "/^[%\\\$]/";
    $this->peg_c66 = array( "type" => "class", "value" => "[%\$]", "description" => "[%\$]" );
    $this->peg_c67 = "/^[{}|]/";
    $this->peg_c68 = array( "type" => "class", "value" => "[{}|]", "description" => "[{}|]" );
    $this->peg_c69 = "&";
    $this->peg_c70 = array( "type" => "literal", "value" => "&", "description" => "\"&\"" );
    $this->peg_c71 = "\\\\";
    $this->peg_c72 = array( "type" => "literal", "value" => "\\\\", "description" => "\"\\\\\\\\\"" );
    $this->peg_c73 = "\\begin";
    $this->peg_c74 = array( "type" => "literal", "value" => "\\begin", "description" => "\"\\\\begin\"" );
    $this->peg_c75 = "\\end";
    $this->peg_c76 = array( "type" => "literal", "value" => "\\end", "description" => "\"\\\\end\"" );
    $this->peg_c77 = "{matrix}";
    $this->peg_c78 = array( "type" => "literal", "value" => "{matrix}", "description" => "\"{matrix}\"" );
    $this->peg_c79 = "{pmatrix}";
    $this->peg_c80 = array( "type" => "literal", "value" => "{pmatrix}", "description" => "\"{pmatrix}\"" );
    $this->peg_c81 = "{bmatrix}";
    $this->peg_c82 = array( "type" => "literal", "value" => "{bmatrix}", "description" => "\"{bmatrix}\"" );
    $this->peg_c83 = "{Bmatrix}";
    $this->peg_c84 = array( "type" => "literal", "value" => "{Bmatrix}", "description" => "\"{Bmatrix}\"" );
    $this->peg_c85 = "{vmatrix}";
    $this->peg_c86 = array( "type" => "literal", "value" => "{vmatrix}", "description" => "\"{vmatrix}\"" );
    $this->peg_c87 = "{Vmatrix}";
    $this->peg_c88 = array( "type" => "literal", "value" => "{Vmatrix}", "description" => "\"{Vmatrix}\"" );
    $this->peg_c89 = "{array}";
    $this->peg_c90 = array( "type" => "literal", "value" => "{array}", "description" => "\"{array}\"" );
    $this->peg_c91 = "{align}";
    $this->peg_c92 = array( "type" => "literal", "value" => "{align}", "description" => "\"{align}\"" );
    $this->peg_c93 = "{aligned}";
    $this->peg_c94 = array( "type" => "literal", "value" => "{aligned}", "description" => "\"{aligned}\"" );
    $this->peg_c95 = "{alignat}";
    $this->peg_c96 = array( "type" => "literal", "value" => "{alignat}", "description" => "\"{alignat}\"" );
    $this->peg_c97 = "{alignedat}";
    $this->peg_c98 = array( "type" => "literal", "value" => "{alignedat}", "description" => "\"{alignedat}\"" );
    $this->peg_c99 = "{smallmatrix}";
    $this->peg_c100 = array( "type" => "literal", "value" => "{smallmatrix}", "description" => "\"{smallmatrix}\"" );
    $this->peg_c101 = "{cases}";
    $this->peg_c102 = array( "type" => "literal", "value" => "{cases}", "description" => "\"{cases}\"" );
    $this->peg_c103 = "named";
    $this->peg_c104 = array( "type" => "literal", "value" => "named", "description" => "\"named\"" );
    $this->peg_c105 = "gray";
    $this->peg_c106 = array( "type" => "literal", "value" => "gray", "description" => "\"gray\"" );
    $this->peg_c107 = "rgb";
    $this->peg_c108 = array( "type" => "literal", "value" => "rgb", "description" => "\"rgb\"" );
    $this->peg_c109 = "RGB";
    $this->peg_c110 = array( "type" => "literal", "value" => "RGB", "description" => "\"RGB\"" );
    $this->peg_c111 = "cmyk";
    $this->peg_c112 = array( "type" => "literal", "value" => "cmyk", "description" => "\"cmyk\"" );
    $this->peg_c113 = ",";
    $this->peg_c114 = array( "type" => "literal", "value" => ",", "description" => "\",\"" );
    $this->peg_c115 = "0";
    $this->peg_c116 = array( "type" => "literal", "value" => "0", "description" => "\"0\"" );
    $this->peg_c117 = "/^[1-9]/";
    $this->peg_c118 = array( "type" => "class", "value" => "[1-9]", "description" => "[1-9]" );
    $this->peg_c119 = ".";
    $this->peg_c120 = array( "type" => "literal", "value" => ".", "description" => "\".\"" );
    $this->peg_c121 = "/^[01]/";
    $this->peg_c122 = array( "type" => "class", "value" => "[01]", "description" => "[01]" );
    $this->peg_c123 = "/^[+-.*']/";
    $this->peg_c124 = array( "type" => "class", "value" => "[+-.*']", "description" => "[+-.*']" );
    $this->peg_c125 = "=";
    $this->peg_c126 = array( "type" => "literal", "value" => "=", "description" => "\"=\"" );
    $this->peg_c127 = "#";
    $this->peg_c128 = array( "type" => "literal", "value" => "#", "description" => "\"#\"" );
    $this->peg_c129 = "~--";
    $this->peg_c130 = array( "type" => "literal", "value" => "~--", "description" => "\"~--\"" );
    $this->peg_c131 = "~-";
    $this->peg_c132 = array( "type" => "literal", "value" => "~-", "description" => "\"~-\"" );
    $this->peg_c133 = "~=";
    $this->peg_c134 = array( "type" => "literal", "value" => "~=", "description" => "\"~=\"" );
    $this->peg_c135 = "~";
    $this->peg_c136 = array( "type" => "literal", "value" => "~", "description" => "\"~\"" );
    $this->peg_c137 = "-~-";
    $this->peg_c138 = array( "type" => "literal", "value" => "-~-", "description" => "\"-~-\"" );
    $this->peg_c139 = "....";
    $this->peg_c140 = array( "type" => "literal", "value" => "....", "description" => "\"....\"" );
    $this->peg_c141 = "...";
    $this->peg_c142 = array( "type" => "literal", "value" => "...", "description" => "\"...\"" );
    $this->peg_c143 = "<-";
    $this->peg_c144 = array( "type" => "literal", "value" => "<-", "description" => "\"<-\"" );
    $this->peg_c145 = "->";
    $this->peg_c146 = array( "type" => "literal", "value" => "->", "description" => "\"->\"" );
    $this->peg_c147 = "1";
    $this->peg_c148 = array( "type" => "literal", "value" => "1", "description" => "\"1\"" );
    $this->peg_c149 = "2";
    $this->peg_c150 = array( "type" => "literal", "value" => "2", "description" => "\"2\"" );
    $this->peg_c151 = "3";
    $this->peg_c152 = array( "type" => "literal", "value" => "3", "description" => "\"3\"" );
    $this->peg_c153 = "{math}";
    $this->peg_c154 = array( "type" => "literal", "value" => "{math}", "description" => "\"{math}\"" );
    $this->peg_c155 = "\\}";
    $this->peg_c156 = array( "type" => "literal", "value" => "\\}", "description" => "\"\\\\}\"" );
    $this->peg_c157 = "/^[+-=#\\(\\).,;\\/*<>|@&'\\[\\]]/";
    $this->peg_c158 = array( "type" => "class", "value" => "[+-=#().,;/*<>|@&'[]]", "description" => "[+-=#().,;/*<>|@&'[]]" );

    $peg_startRuleFunctions = array( 'start' => array($this, "peg_parsestart") );
    $peg_startRuleFunction  = array($this, "peg_parsestart");
    if (isset($options["startRule"])) {
      if (!(isset($peg_startRuleFunctions[$options["startRule"]]))) {
        throw new \Exception("Can't start parsing from rule \"" . $options["startRule"] . "\".");
      }

      $peg_startRuleFunction = $peg_startRuleFunctions[$options["startRule"]];
    }

    /* BEGIN initializer code */

    $this->tu = TexUtil::getInstance();

    # get reference of the options for usage in functions.


    # get reference of the options for usage in functions.
    $this->options = ParserUtil::createOptions($options);


    /* END initializer code */

    $peg_result = call_user_func($peg_startRuleFunction);

    $this->peg_cache = array();

    mb_regex_encoding($old_regex_encoding);

    if ($peg_result !== $this->peg_FAILED && $this->peg_currPos === $this->input_length) {
      $this->cleanup_state(); // Free up memory
      return $peg_result;
    } else {
      if ($peg_result !== $this->peg_FAILED && $this->peg_currPos < $this->input_length) {
        $this->peg_fail(array("type" => "end", "description" => "end of input" ));
      }

      $exception = $this->peg_buildException(null, $this->peg_maxFailExpected, $this->peg_maxFailPos);
      $this->cleanup_state(); // Free up memory
      throw $exception;
    }
  }

};