/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;

public class NumericFormatter
extends Command {
    private NumberFormat numFormat;
    private String decimalChar = null;
    private boolean prohibitDecimal = false;

    public NumericFormatter(String string, NumberFormat numberFormat) {
        this(string, numberFormat, null, false);
    }

    public NumericFormatter(String string, NumberFormat numberFormat, String string2) {
        this(string, numberFormat, string2, string2 != null);
    }

    public NumericFormatter(String string, NumberFormat numberFormat, String string2, boolean bl) {
        super(string);
        this.numFormat = numberFormat;
        this.decimalChar = string2;
        this.prohibitDecimal = bl;
    }

    @Override
    public Object clone() {
        return this;
    }

    public Number parse(String string) throws ParseException {
        int n;
        if (this.decimalChar != null && this.prohibitDecimal && (n = string.indexOf(this.decimalChar)) > -1) {
            throw new ParseException("Invalid integer '" + string + "' (decimal character '" + this.decimalChar + "' found)", n);
        }
        return this.numFormat.parse(string);
    }

    protected String fmtArg(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string;
        if (teXObject instanceof TeXFloatingPoint) {
            string = this.numFormat.format(((TeXFloatingPoint)teXObject).doubleValue());
        } else if (teXObject instanceof Numerical) {
            string = this.numFormat.format(((Numerical)teXObject).number(teXParser));
        } else {
            String string2 = teXParser.expandToString(teXObject, teXObjectList);
            try {
                string = this.numFormat.format(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    string = this.numFormat.format(Double.parseDouble(string2));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new TeXSyntaxException((Throwable)numberFormatException2, teXParser, "tex.error.number_expected", string2);
                }
            }
        }
        return string;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return teXParser.getListener().createString(this.fmtArg(teXObject, teXParser, teXObjectList));
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        teXParser.getListener().getWriteable().write(this.fmtArg(teXObject, teXParser, teXObjectList));
    }
}

