/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;

public class Overlay {
    private static final String XOBJECT_PREFIX = "OL";
    private LayoutPage defaultOverlayPage;
    private LayoutPage firstPageOverlayPage;
    private LayoutPage lastPageOverlayPage;
    private LayoutPage oddPageOverlayPage;
    private LayoutPage evenPageOverlayPage;
    private Map<Integer, PDDocument> specificPageOverlay = new HashMap<Integer, PDDocument>();
    private Map<Integer, LayoutPage> specificPageOverlayPage = new HashMap<Integer, LayoutPage>();
    private Position position = Position.BACKGROUND;
    private String inputFileName = null;
    private PDDocument inputPDFDocument = null;
    private String outputFilename = null;
    private String defaultOverlayFilename = null;
    private PDDocument defaultOverlay = null;
    private String firstPageOverlayFilename = null;
    private PDDocument firstPageOverlay = null;
    private String lastPageOverlayFilename = null;
    private PDDocument lastPageOverlay = null;
    private String allPagesOverlayFilename = null;
    private PDDocument allPagesOverlay = null;
    private String oddPageOverlayFilename = null;
    private PDDocument oddPageOverlay = null;
    private String evenPageOverlayFilename = null;
    private PDDocument evenPageOverlay = null;
    private int numberOfOverlayPages = 0;
    private boolean useAllOverlayPages = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlay(Map<Integer, String> specificPageOverlayFile, boolean useNonSeqParser) throws IOException, COSVisitorException {
        block18: {
            try {
                this.loadPDFs(useNonSeqParser);
                for (Map.Entry<Integer, String> entry : specificPageOverlayFile.entrySet()) {
                    PDDocument doc = this.loadPDF(entry.getValue(), useNonSeqParser);
                    this.specificPageOverlay.put(entry.getKey(), doc);
                    this.specificPageOverlayPage.put(entry.getKey(), this.getLayoutPage(doc));
                }
                PDDocumentCatalog pdfCatalog = this.inputPDFDocument.getDocumentCatalog();
                this.processPages(pdfCatalog.getAllPages());
                this.inputPDFDocument.save(this.outputFilename);
                if (this.inputPDFDocument == null) break block18;
            }
            catch (Throwable throwable) {
                if (this.inputPDFDocument != null) {
                    this.inputPDFDocument.close();
                }
                if (this.defaultOverlay != null) {
                    this.defaultOverlay.close();
                }
                if (this.firstPageOverlay != null) {
                    this.firstPageOverlay.close();
                }
                if (this.lastPageOverlay != null) {
                    this.lastPageOverlay.close();
                }
                if (this.allPagesOverlay != null) {
                    this.allPagesOverlay.close();
                }
                if (this.oddPageOverlay != null) {
                    this.oddPageOverlay.close();
                }
                if (this.evenPageOverlay != null) {
                    this.evenPageOverlay.close();
                }
                for (Map.Entry<Integer, PDDocument> e : this.specificPageOverlay.entrySet()) {
                    e.getValue().close();
                }
                this.specificPageOverlay.clear();
                this.specificPageOverlayPage.clear();
                throw throwable;
            }
            this.inputPDFDocument.close();
        }
        if (this.defaultOverlay != null) {
            this.defaultOverlay.close();
        }
        if (this.firstPageOverlay != null) {
            this.firstPageOverlay.close();
        }
        if (this.lastPageOverlay != null) {
            this.lastPageOverlay.close();
        }
        if (this.allPagesOverlay != null) {
            this.allPagesOverlay.close();
        }
        if (this.oddPageOverlay != null) {
            this.oddPageOverlay.close();
        }
        if (this.evenPageOverlay != null) {
            this.evenPageOverlay.close();
        }
        for (Map.Entry<Integer, Object> entry : this.specificPageOverlay.entrySet()) {
            ((PDDocument)entry.getValue()).close();
        }
        this.specificPageOverlay.clear();
        this.specificPageOverlayPage.clear();
    }

    private void loadPDFs(boolean useNonSeqParser) throws IOException {
        if (this.inputFileName != null) {
            this.inputPDFDocument = this.loadPDF(this.inputFileName, useNonSeqParser);
        }
        if (this.defaultOverlayFilename != null) {
            this.defaultOverlay = this.loadPDF(this.defaultOverlayFilename, useNonSeqParser);
        }
        if (this.defaultOverlay != null) {
            this.defaultOverlayPage = this.getLayoutPage(this.defaultOverlay);
        }
        if (this.firstPageOverlayFilename != null) {
            this.firstPageOverlay = this.loadPDF(this.firstPageOverlayFilename, useNonSeqParser);
        }
        if (this.firstPageOverlay != null) {
            this.firstPageOverlayPage = this.getLayoutPage(this.firstPageOverlay);
        }
        if (this.lastPageOverlayFilename != null) {
            this.lastPageOverlay = this.loadPDF(this.lastPageOverlayFilename, useNonSeqParser);
        }
        if (this.lastPageOverlay != null) {
            this.lastPageOverlayPage = this.getLayoutPage(this.lastPageOverlay);
        }
        if (this.oddPageOverlayFilename != null) {
            this.oddPageOverlay = this.loadPDF(this.oddPageOverlayFilename, useNonSeqParser);
        }
        if (this.oddPageOverlay != null) {
            this.oddPageOverlayPage = this.getLayoutPage(this.oddPageOverlay);
        }
        if (this.evenPageOverlayFilename != null) {
            this.evenPageOverlay = this.loadPDF(this.evenPageOverlayFilename, useNonSeqParser);
        }
        if (this.evenPageOverlay != null) {
            this.evenPageOverlayPage = this.getLayoutPage(this.evenPageOverlay);
        }
        if (this.allPagesOverlayFilename != null) {
            this.allPagesOverlay = this.loadPDF(this.allPagesOverlayFilename, useNonSeqParser);
        }
        if (this.allPagesOverlay != null) {
            this.specificPageOverlayPage = this.getLayoutPages(this.allPagesOverlay);
            this.useAllOverlayPages = true;
            this.numberOfOverlayPages = this.specificPageOverlayPage.size();
        }
    }

    private PDDocument loadPDF(String pdfName, boolean useNonSeqParser) throws IOException {
        PDDocument pdf = null;
        pdf = useNonSeqParser ? PDDocument.loadNonSeq(new File(pdfName), null) : PDDocument.load(pdfName);
        return pdf;
    }

    private LayoutPage getLayoutPage(PDDocument doc) throws IOException {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        PDPage page = (PDPage)catalog.getAllPages().get(0);
        COSBase contents = page.getCOSDictionary().getDictionaryObject(COSName.CONTENTS);
        PDResources resources = page.findResources();
        if (resources == null) {
            resources = new PDResources();
        }
        return new LayoutPage(page.getMediaBox(), this.createContentStream(contents), resources.getCOSDictionary());
    }

    private HashMap<Integer, LayoutPage> getLayoutPages(PDDocument doc) throws IOException {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        int numberOfPages = doc.getNumberOfPages();
        HashMap<Integer, LayoutPage> layoutPages = new HashMap<Integer, LayoutPage>(numberOfPages);
        for (int i = 0; i < numberOfPages; ++i) {
            PDPage page = (PDPage)catalog.getAllPages().get(i);
            COSBase contents = page.getCOSDictionary().getDictionaryObject(COSName.CONTENTS);
            PDResources resources = page.findResources();
            if (resources == null) {
                resources = new PDResources();
            }
            layoutPages.put(i, new LayoutPage(page.getMediaBox(), this.createContentStream(contents), resources.getCOSDictionary()));
        }
        return layoutPages;
    }

    private COSStream createContentStream(COSBase contents) throws IOException {
        List<COSStream> contentStreams = this.createContentStreamList(contents);
        COSStream concatStream = new COSStream(new RandomAccessBuffer());
        OutputStream out = concatStream.createUnfilteredStream();
        for (COSStream contentStream : contentStreams) {
            int n;
            InputStream in = contentStream.getUnfilteredStream();
            byte[] buf = new byte[2048];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            out.flush();
        }
        out.close();
        concatStream.setFilters(COSName.FLATE_DECODE);
        return concatStream;
    }

    private List<COSStream> createContentStreamList(COSBase contents) throws IOException {
        ArrayList<COSStream> contentStreams = new ArrayList<COSStream>();
        if (contents instanceof COSStream) {
            contentStreams.add((COSStream)contents);
        } else if (contents instanceof COSArray) {
            for (COSBase item : (COSArray)contents) {
                contentStreams.addAll(this.createContentStreamList(item));
            }
        } else if (contents instanceof COSObject) {
            contentStreams.addAll(this.createContentStreamList(((COSObject)contents).getObject()));
        } else {
            throw new IOException("Unknown content type: " + (contents == null ? "(null)" : contents.getClass().getName()));
        }
        return contentStreams;
    }

    private void processPages(List<PDPage> pages) throws IOException {
        int pageCount = 0;
        for (PDPage page : pages) {
            COSDictionary pageDictionary = page.getCOSDictionary();
            COSBase contents = pageDictionary.getDictionaryObject(COSName.CONTENTS);
            COSArray contentArray = new COSArray();
            switch (this.position) {
                case FOREGROUND: {
                    contentArray.add(this.createStream("q\n"));
                    if (contents instanceof COSStream) {
                        contentArray.add(contents);
                    } else if (contents instanceof COSArray) {
                        contentArray.addAll((COSArray)contents);
                    } else {
                        throw new IOException("Unknown content type: " + (contents == null ? "(null)" : contents.getClass().getName()));
                    }
                    contentArray.add(this.createStream("Q\n"));
                    this.overlayPage(contentArray, page, pageCount + 1, pages.size());
                    break;
                }
                case BACKGROUND: {
                    this.overlayPage(contentArray, page, pageCount + 1, pages.size());
                    if (contents instanceof COSStream) {
                        contentArray.add(contents);
                        break;
                    }
                    if (contents instanceof COSArray) {
                        contentArray.addAll((COSArray)contents);
                        break;
                    }
                    throw new IOException("Unknown content type: " + (contents == null ? "(null)" : contents.getClass().getName()));
                }
                default: {
                    throw new IOException("Unknown type of position:" + (Object)((Object)this.position));
                }
            }
            pageDictionary.setItem(COSName.CONTENTS, (COSBase)contentArray);
            ++pageCount;
        }
    }

    private void overlayPage(COSArray array, PDPage page, int pageNumber, int numberOfPages) throws IOException {
        LayoutPage layoutPage = null;
        if (!this.useAllOverlayPages && this.specificPageOverlayPage.containsKey(pageNumber)) {
            layoutPage = this.specificPageOverlayPage.get(pageNumber);
        } else if (pageNumber == 1 && this.firstPageOverlayPage != null) {
            layoutPage = this.firstPageOverlayPage;
        } else if (pageNumber == numberOfPages && this.lastPageOverlayPage != null) {
            layoutPage = this.lastPageOverlayPage;
        } else if (pageNumber % 2 == 1 && this.oddPageOverlayPage != null) {
            layoutPage = this.oddPageOverlayPage;
        } else if (pageNumber % 2 == 0 && this.evenPageOverlayPage != null) {
            layoutPage = this.evenPageOverlayPage;
        } else if (this.defaultOverlayPage != null) {
            layoutPage = this.defaultOverlayPage;
        } else if (this.useAllOverlayPages) {
            int usePageNum = (pageNumber - 1) % this.numberOfOverlayPages;
            layoutPage = this.specificPageOverlayPage.get(usePageNum);
        }
        if (layoutPage != null) {
            PDResources resources = page.findResources();
            if (resources == null) {
                resources = new PDResources();
                page.setResources(resources);
            }
            String xObjectId = this.createOverlayXObject(page, layoutPage, layoutPage.overlayContentStream);
            array.add(this.createOverlayStream(page, layoutPage, xObjectId));
        }
    }

    private String createOverlayXObject(PDPage page, LayoutPage layoutPage, COSStream contentStream) {
        PDXObjectForm xobjForm = new PDXObjectForm(contentStream);
        xobjForm.setResources(new PDResources(layoutPage.overlayResources));
        xobjForm.setFormType(1);
        xobjForm.setBBox(layoutPage.overlayMediaBox.createRetranslatedRectangle());
        xobjForm.setMatrix(new AffineTransform());
        PDResources resources = page.findResources();
        return resources.addXObject(xobjForm, XOBJECT_PREFIX);
    }

    private COSStream createOverlayStream(PDPage page, LayoutPage layoutPage, String xObjectId) throws IOException {
        PDRectangle pageMediaBox = page.getMediaBox();
        float hShift = (pageMediaBox.getWidth() - layoutPage.overlayMediaBox.getWidth()) / 2.0f;
        float vShift = (pageMediaBox.getHeight() - layoutPage.overlayMediaBox.getHeight()) / 2.0f;
        StringBuilder overlayStream = new StringBuilder();
        overlayStream.append("q\nq 1 0 0 1 ");
        overlayStream.append(this.float2String(hShift));
        overlayStream.append(" ");
        overlayStream.append(this.float2String(vShift));
        overlayStream.append(" cm /");
        overlayStream.append(xObjectId);
        overlayStream.append(" Do Q\nQ\n");
        return this.createStream(overlayStream.toString());
    }

    private String float2String(float floatValue) {
        BigDecimal value = new BigDecimal(String.valueOf(floatValue));
        String stringValue = value.toPlainString();
        if (stringValue.indexOf(46) > -1 && !stringValue.endsWith(".0")) {
            while (stringValue.endsWith("0") && !stringValue.endsWith(".0")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
        }
        return stringValue;
    }

    private COSStream createStream(String content) throws IOException {
        COSStream stream = new COSStream(new RandomAccessBuffer());
        OutputStream out = stream.createUnfilteredStream();
        out.write(content.getBytes("ISO-8859-1"));
        out.close();
        stream.setFilters(COSName.FLATE_DECODE);
        return stream;
    }

    public void setOverlayPosition(Position overlayPosition) {
        this.position = overlayPosition;
    }

    public void setInputFile(String inputFile) {
        this.inputFileName = inputFile;
    }

    public void setInputPDF(PDDocument inputPDF) {
        this.inputPDFDocument = inputPDF;
    }

    public String getInputFile() {
        return this.inputFileName;
    }

    public void setOutputFile(String outputFile) {
        this.outputFilename = outputFile;
    }

    public String getOutputFile() {
        return this.outputFilename;
    }

    public void setDefaultOverlayFile(String defaultOverlayFile) {
        this.defaultOverlayFilename = defaultOverlayFile;
    }

    public void setDefaultOverlayPDF(PDDocument defaultOverlayPDF) {
        this.defaultOverlay = defaultOverlayPDF;
    }

    public String getDefaultOverlayFile() {
        return this.defaultOverlayFilename;
    }

    public void setFirstPageOverlayFile(String firstPageOverlayFile) {
        this.firstPageOverlayFilename = firstPageOverlayFile;
    }

    public void setFirstPageOverlayPDF(PDDocument firstPageOverlayPDF) {
        this.firstPageOverlay = firstPageOverlayPDF;
    }

    public void setLastPageOverlayFile(String lastPageOverlayFile) {
        this.lastPageOverlayFilename = lastPageOverlayFile;
    }

    public void setLastPageOverlayPDF(PDDocument lastPageOverlayPDF) {
        this.lastPageOverlay = lastPageOverlayPDF;
    }

    public void setAllPagesOverlayFile(String allPagesOverlayFile) {
        this.allPagesOverlayFilename = allPagesOverlayFile;
    }

    public void setAllPagesOverlayPDF(PDDocument allPagesOverlayPDF) {
        this.allPagesOverlay = allPagesOverlayPDF;
    }

    public void setOddPageOverlayFile(String oddPageOverlayFile) {
        this.oddPageOverlayFilename = oddPageOverlayFile;
    }

    public void setOddPageOverlayPDF(PDDocument oddPageOverlayPDF) {
        this.oddPageOverlay = oddPageOverlayPDF;
    }

    public void setEvenPageOverlayFile(String evenPageOverlayFile) {
        this.evenPageOverlayFilename = evenPageOverlayFile;
    }

    public void setEvenPageOverlayPDF(PDDocument evenPageOverlayPDF) {
        this.evenPageOverlay = evenPageOverlayPDF;
    }

    private static class LayoutPage {
        private final PDRectangle overlayMediaBox;
        private final COSStream overlayContentStream;
        private final COSDictionary overlayResources;

        private LayoutPage(PDRectangle mediaBox, COSStream contentStream, COSDictionary resources) {
            this.overlayMediaBox = mediaBox;
            this.overlayContentStream = contentStream;
            this.overlayResources = resources;
        }
    }

    public static enum Position {
        FOREGROUND,
        BACKGROUND;

    }
}

