/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.ha.session.SessionMessageImpl;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class DeltaManager
extends ClusterManagerBase {
    public final Log log = LogFactory.getLog(DeltaManager.class);
    protected static final StringManager sm = StringManager.getManager(DeltaManager.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected String name = null;
    private boolean expireSessionsOnShutdown = false;
    private boolean notifySessionListenersOnReplication = true;
    private boolean notifyContainerListenersOnReplication = true;
    private volatile boolean stateTransferred = false;
    private volatile boolean noContextManagerReceived = false;
    private int stateTransferTimeout = 60;
    private boolean sendAllSessions = true;
    private int sendAllSessionsSize = 1000;
    private int sendAllSessionsWaitTime = 2000;
    private final ArrayList<SessionMessage> receivedMessageQueue = new ArrayList();
    private boolean receiverQueue = false;
    private boolean stateTimestampDrop = true;
    private volatile long stateTransferCreateSendTime;
    private volatile long sessionReplaceCounter = 0L;
    private volatile long counterReceive_EVT_GET_ALL_SESSIONS = 0L;
    private volatile long counterReceive_EVT_ALL_SESSION_DATA = 0L;
    private volatile long counterReceive_EVT_SESSION_CREATED = 0L;
    private volatile long counterReceive_EVT_SESSION_EXPIRED = 0L;
    private volatile long counterReceive_EVT_SESSION_ACCESSED = 0L;
    private volatile long counterReceive_EVT_SESSION_DELTA = 0L;
    private volatile int counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    private volatile long counterReceive_EVT_CHANGE_SESSION_ID = 0L;
    private volatile long counterReceive_EVT_ALL_SESSION_NOCONTEXTMANAGER = 0L;
    private volatile long counterSend_EVT_GET_ALL_SESSIONS = 0L;
    private volatile long counterSend_EVT_ALL_SESSION_DATA = 0L;
    private volatile long counterSend_EVT_SESSION_CREATED = 0L;
    private volatile long counterSend_EVT_SESSION_DELTA = 0L;
    private volatile long counterSend_EVT_SESSION_ACCESSED = 0L;
    private volatile long counterSend_EVT_SESSION_EXPIRED = 0L;
    private volatile int counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    private volatile long counterSend_EVT_CHANGE_SESSION_ID = 0L;
    private volatile int counterNoStateTransferred = 0;

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getCounterSend_EVT_GET_ALL_SESSIONS() {
        return this.counterSend_EVT_GET_ALL_SESSIONS;
    }

    public long getCounterSend_EVT_SESSION_ACCESSED() {
        return this.counterSend_EVT_SESSION_ACCESSED;
    }

    public long getCounterSend_EVT_SESSION_CREATED() {
        return this.counterSend_EVT_SESSION_CREATED;
    }

    public long getCounterSend_EVT_SESSION_DELTA() {
        return this.counterSend_EVT_SESSION_DELTA;
    }

    public long getCounterSend_EVT_SESSION_EXPIRED() {
        return this.counterSend_EVT_SESSION_EXPIRED;
    }

    public long getCounterSend_EVT_ALL_SESSION_DATA() {
        return this.counterSend_EVT_ALL_SESSION_DATA;
    }

    public int getCounterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE() {
        return this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE;
    }

    public long getCounterSend_EVT_CHANGE_SESSION_ID() {
        return this.counterSend_EVT_CHANGE_SESSION_ID;
    }

    public long getCounterReceive_EVT_ALL_SESSION_DATA() {
        return this.counterReceive_EVT_ALL_SESSION_DATA;
    }

    public long getCounterReceive_EVT_GET_ALL_SESSIONS() {
        return this.counterReceive_EVT_GET_ALL_SESSIONS;
    }

    public long getCounterReceive_EVT_SESSION_ACCESSED() {
        return this.counterReceive_EVT_SESSION_ACCESSED;
    }

    public long getCounterReceive_EVT_SESSION_CREATED() {
        return this.counterReceive_EVT_SESSION_CREATED;
    }

    public long getCounterReceive_EVT_SESSION_DELTA() {
        return this.counterReceive_EVT_SESSION_DELTA;
    }

    public long getCounterReceive_EVT_SESSION_EXPIRED() {
        return this.counterReceive_EVT_SESSION_EXPIRED;
    }

    public int getCounterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE() {
        return this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE;
    }

    public long getCounterReceive_EVT_CHANGE_SESSION_ID() {
        return this.counterReceive_EVT_CHANGE_SESSION_ID;
    }

    public long getCounterReceive_EVT_ALL_SESSION_NOCONTEXTMANAGER() {
        return this.counterReceive_EVT_ALL_SESSION_NOCONTEXTMANAGER;
    }

    public long getSessionReplaceCounter() {
        return this.sessionReplaceCounter;
    }

    public int getCounterNoStateTransferred() {
        return this.counterNoStateTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReceivedQueueSize() {
        ArrayList<SessionMessage> arrayList = this.receivedMessageQueue;
        synchronized (arrayList) {
            return this.receivedMessageQueue.size();
        }
    }

    public int getStateTransferTimeout() {
        return this.stateTransferTimeout;
    }

    public void setStateTransferTimeout(int n) {
        this.stateTransferTimeout = n;
    }

    public boolean getStateTransferred() {
        return this.stateTransferred;
    }

    public void setStateTransferred(boolean bl) {
        this.stateTransferred = bl;
    }

    public boolean isNoContextManagerReceived() {
        return this.noContextManagerReceived;
    }

    public void setNoContextManagerReceived(boolean bl) {
        this.noContextManagerReceived = bl;
    }

    public int getSendAllSessionsWaitTime() {
        return this.sendAllSessionsWaitTime;
    }

    public void setSendAllSessionsWaitTime(int n) {
        this.sendAllSessionsWaitTime = n;
    }

    public boolean isStateTimestampDrop() {
        return this.stateTimestampDrop;
    }

    public void setStateTimestampDrop(boolean bl) {
        this.stateTimestampDrop = bl;
    }

    public boolean isSendAllSessions() {
        return this.sendAllSessions;
    }

    public void setSendAllSessions(boolean bl) {
        this.sendAllSessions = bl;
    }

    public int getSendAllSessionsSize() {
        return this.sendAllSessionsSize;
    }

    public void setSendAllSessionsSize(int n) {
        this.sendAllSessionsSize = n;
    }

    public boolean isNotifySessionListenersOnReplication() {
        return this.notifySessionListenersOnReplication;
    }

    public void setNotifySessionListenersOnReplication(boolean bl) {
        this.notifySessionListenersOnReplication = bl;
    }

    public boolean isExpireSessionsOnShutdown() {
        return this.expireSessionsOnShutdown;
    }

    public void setExpireSessionsOnShutdown(boolean bl) {
        this.expireSessionsOnShutdown = bl;
    }

    public boolean isNotifyContainerListenersOnReplication() {
        return this.notifyContainerListenersOnReplication;
    }

    public void setNotifyContainerListenersOnReplication(boolean bl) {
        this.notifyContainerListenersOnReplication = bl;
    }

    public Session createSession(String string) {
        return this.createSession(string, true);
    }

    public Session createSession(String string, boolean bl) {
        DeltaSession deltaSession = (DeltaSession)super.createSession(string);
        if (bl) {
            this.sendCreateSession(deltaSession.getId(), deltaSession);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.createSession.newSession", new Object[]{deltaSession.getId(), this.sessions.size()}));
        }
        return deltaSession;
    }

    protected void sendCreateSession(String string, DeltaSession deltaSession) {
        if (this.cluster.getMembers().length > 0) {
            SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(this.getName(), 1, null, string, string + "-" + System.currentTimeMillis());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)sm.getString("deltaManager.sendMessage.newSession", new Object[]{this.name, string}));
            }
            sessionMessageImpl.setTimestamp(deltaSession.getCreationTime());
            ++this.counterSend_EVT_SESSION_CREATED;
            this.send(sessionMessageImpl);
        }
    }

    protected void send(SessionMessage sessionMessage) {
        if (this.cluster != null) {
            this.cluster.send(sessionMessage);
        }
    }

    public Session createEmptySession() {
        return new DeltaSession(this);
    }

    public String rotateSessionId(Session session) {
        return this.rotateSessionId(session, true);
    }

    public void changeSessionId(Session session, String string) {
        this.changeSessionId(session, string, true);
    }

    protected String rotateSessionId(Session session, boolean bl) {
        String string = session.getId();
        String string2 = super.rotateSessionId(session);
        if (bl) {
            this.sendChangeSessionId(session.getId(), string);
        }
        return string2;
    }

    protected void changeSessionId(Session session, String string, boolean bl) {
        String string2 = session.getId();
        super.changeSessionId(session, string);
        if (bl) {
            this.sendChangeSessionId(session.getId(), string2);
        }
    }

    protected void sendChangeSessionId(String string, String string2) {
        if (this.cluster.getMembers().length > 0) {
            try {
                byte[] byArray = this.serializeSessionId(string);
                SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(this.getName(), 15, byArray, string2, string2 + "-" + System.currentTimeMillis());
                sessionMessageImpl.setTimestamp(System.currentTimeMillis());
                ++this.counterSend_EVT_CHANGE_SESSION_ID;
                this.send(sessionMessageImpl);
            }
            catch (IOException iOException) {
                this.log.error((Object)sm.getString("deltaManager.unableSerializeSessionID", new Object[]{string}), (Throwable)iOException);
            }
        }
    }

    protected byte[] serializeSessionId(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeUTF(string);
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    protected String deserializeSessionId(byte[] byArray) throws IOException {
        ReplicationStream replicationStream = this.getReplicationStream(byArray);
        String string = replicationStream.readUTF();
        replicationStream.close();
        return string;
    }

    protected void deserializeSessions(byte[] byArray) throws ClassNotFoundException, IOException {
        try (ReplicationStream replicationStream = this.getReplicationStream(byArray);){
            Integer n = (Integer)replicationStream.readObject();
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                DeltaSession deltaSession = (DeltaSession)this.createEmptySession();
                deltaSession.readObjectData((ObjectInputStream)replicationStream);
                deltaSession.setManager(this);
                deltaSession.setValid(true);
                deltaSession.setPrimarySession(false);
                deltaSession.access();
                deltaSession.setAccessCount(0);
                deltaSession.resetDeltaRequest();
                if (this.findSession(deltaSession.getIdInternal()) == null) {
                    ++this.sessionCounter;
                } else {
                    ++this.sessionReplaceCounter;
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)sm.getString("deltaManager.loading.existing.session", new Object[]{deltaSession.getIdInternal()}));
                    }
                }
                this.add(deltaSession);
                if (!this.notifySessionListenersOnReplication) continue;
                deltaSession.tellNew();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error((Object)sm.getString("deltaManager.loading.cnfe", new Object[]{classNotFoundException}), (Throwable)classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("deltaManager.loading.ioe", new Object[]{iOException}), (Throwable)iOException);
            throw iOException;
        }
    }

    protected byte[] serializeSessions(Session[] sessionArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));){
            objectOutputStream.writeObject(sessionArray.length);
            for (Session session : sessionArray) {
                ((DeltaSession)session).writeObjectData(objectOutputStream);
            }
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("deltaManager.unloading.ioe", new Object[]{iOException}), (Throwable)iOException);
            throw iOException;
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            if (this.cluster == null) {
                this.log.error((Object)sm.getString("deltaManager.noCluster", new Object[]{this.getName()}));
                return;
            }
            if (this.log.isInfoEnabled()) {
                String string = "unknown";
                if (this.cluster.getContainer() instanceof Host) {
                    string = "Host";
                } else if (this.cluster.getContainer() instanceof Engine) {
                    string = "Engine";
                }
                this.log.info((Object)sm.getString("deltaManager.registerCluster", new Object[]{this.getName(), string, this.cluster.getClusterName()}));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sm.getString("deltaManager.startClustering", new Object[]{this.getName()}));
            }
            this.getAllClusterSessions();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log.error((Object)sm.getString("deltaManager.managerLoad"), throwable);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getAllClusterSessions() {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ArrayList<SessionMessage> arrayList;
            long l = System.currentTimeMillis();
            Member member = this.findSessionMasterMember();
            if (member == null) {
                return;
            }
            SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(this.getName(), 4, null, "GET-ALL", "GET-ALL-" + this.getName());
            sessionMessageImpl.setTimestamp(l);
            this.stateTransferCreateSendTime = l;
            ++this.counterSend_EVT_GET_ALL_SESSIONS;
            this.stateTransferred = false;
            try {
                arrayList = this.receivedMessageQueue;
                synchronized (arrayList) {
                    this.receiverQueue = true;
                }
                this.cluster.send(sessionMessageImpl, member, 8);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)sm.getString("deltaManager.waitForSessionState", new Object[]{this.getName(), member, this.getStateTransferTimeout()}));
                }
                this.waitForSendAllSessions(l);
                arrayList = this.receivedMessageQueue;
            }
            catch (Throwable throwable) {
                ArrayList<SessionMessage> arrayList2 = this.receivedMessageQueue;
                synchronized (arrayList2) {
                    for (SessionMessage sessionMessage : this.receivedMessageQueue) {
                        if (!this.stateTimestampDrop) {
                            this.messageReceived(sessionMessage, sessionMessage.getAddress());
                            continue;
                        }
                        if (sessionMessage.getEventType() != 4 && sessionMessage.getTimestamp() >= this.stateTransferCreateSendTime) {
                            this.messageReceived(sessionMessage, sessionMessage.getAddress());
                            continue;
                        }
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn((Object)sm.getString("deltaManager.dropMessage", new Object[]{this.getName(), sessionMessage.getEventTypeString(), new Date(this.stateTransferCreateSendTime), new Date(sessionMessage.getTimestamp())}));
                    }
                    this.receivedMessageQueue.clear();
                    this.receiverQueue = false;
                }
                throw throwable;
            }
            synchronized (arrayList) {
                for (SessionMessage sessionMessage : this.receivedMessageQueue) {
                    if (!this.stateTimestampDrop) {
                        this.messageReceived(sessionMessage, sessionMessage.getAddress());
                        continue;
                    }
                    if (sessionMessage.getEventType() != 4 && sessionMessage.getTimestamp() >= this.stateTransferCreateSendTime) {
                        this.messageReceived(sessionMessage, sessionMessage.getAddress());
                        continue;
                    }
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)sm.getString("deltaManager.dropMessage", new Object[]{this.getName(), sessionMessage.getEventTypeString(), new Date(this.stateTransferCreateSendTime), new Date(sessionMessage.getTimestamp())}));
                }
                this.receivedMessageQueue.clear();
                this.receiverQueue = false;
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)sm.getString("deltaManager.noMembers", new Object[]{this.getName()}));
        }
    }

    protected Member findSessionMasterMember() {
        Member member = null;
        Member[] memberArray = this.cluster.getMembers();
        if (memberArray.length != 0) {
            member = memberArray[0];
        }
        if (member == null && this.log.isWarnEnabled()) {
            this.log.warn((Object)sm.getString("deltaManager.noMasterMember", new Object[]{this.getName(), ""}));
        }
        if (member != null && this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("deltaManager.foundMasterMember", new Object[]{this.getName(), member}));
        }
        return member;
    }

    protected void waitForSendAllSessions(long l) {
        long l2;
        long l3 = l2 = System.currentTimeMillis();
        boolean bl = false;
        if (this.getStateTransferTimeout() > 0) {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l3 = System.currentTimeMillis();
                boolean bl2 = bl = l3 - l2 > 1000L * (long)this.getStateTransferTimeout();
            } while (!this.getStateTransferred() && !bl && !this.isNoContextManagerReceived());
        } else if (this.getStateTransferTimeout() == -1) {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!this.getStateTransferred() && !this.isNoContextManagerReceived());
            l3 = System.currentTimeMillis();
        }
        if (bl) {
            ++this.counterNoStateTransferred;
            this.log.error((Object)sm.getString("deltaManager.noSessionState", new Object[]{this.getName(), new Date(l), l3 - l}));
        } else if (this.isNoContextManagerReceived()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)sm.getString("deltaManager.noContextManager", new Object[]{this.getName(), new Date(l), l3 - l}));
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info((Object)sm.getString("deltaManager.sessionReceived", new Object[]{this.getName(), new Date(l), l3 - l}));
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        Session[] sessionArray;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.stopped", new Object[]{this.getName()}));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)sm.getString("deltaManager.expireSessions", new Object[]{this.getName()}));
        }
        for (Session session : sessionArray = this.findSessions()) {
            DeltaSession deltaSession = (DeltaSession)session;
            if (!deltaSession.isValid()) continue;
            try {
                deltaSession.expire(true, this.isExpireSessionsOnShutdown());
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
        }
        super.stopInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageDataReceived(ClusterMessage clusterMessage) {
        if (clusterMessage instanceof SessionMessage) {
            SessionMessage sessionMessage = (SessionMessage)clusterMessage;
            switch (sessionMessage.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 15: {
                    ArrayList<SessionMessage> arrayList = this.receivedMessageQueue;
                    synchronized (arrayList) {
                        if (this.receiverQueue) {
                            this.receivedMessageQueue.add(sessionMessage);
                            return;
                        }
                        break;
                    }
                }
            }
            this.messageReceived(sessionMessage, sessionMessage.getAddress());
        }
    }

    @Override
    public ClusterMessage requestCompleted(String string) {
        return this.requestCompleted(string, false);
    }

    public ClusterMessage requestCompleted(String string, boolean bl) {
        DeltaSession deltaSession = null;
        ClusterMessage clusterMessage = null;
        try {
            deltaSession = (DeltaSession)this.findSession(string);
            if (deltaSession == null) {
                return null;
            }
            if (deltaSession.isDirty()) {
                ++this.counterSend_EVT_SESSION_DELTA;
                clusterMessage = new SessionMessageImpl(this.getName(), 13, deltaSession.getDiff(), string, string + "-" + System.currentTimeMillis());
            }
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("deltaManager.createMessage.unableCreateDeltaRequest", new Object[]{string}), (Throwable)iOException);
            return null;
        }
        if (clusterMessage == null) {
            if (!bl && !deltaSession.isPrimarySession()) {
                ++this.counterSend_EVT_SESSION_ACCESSED;
                clusterMessage = new SessionMessageImpl(this.getName(), 3, null, string, string + "-" + System.currentTimeMillis());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("deltaManager.createMessage.accessChangePrimary", new Object[]{this.getName(), string}));
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.createMessage.delta", new Object[]{this.getName(), string}));
        }
        if (!bl) {
            deltaSession.setPrimarySession(true);
        }
        if (!bl && clusterMessage == null) {
            long l = System.currentTimeMillis() - deltaSession.getLastTimeReplicated();
            if (deltaSession.getMaxInactiveInterval() >= 0 && l > (long)deltaSession.getMaxInactiveInterval() * 1000L) {
                ++this.counterSend_EVT_SESSION_ACCESSED;
                clusterMessage = new SessionMessageImpl(this.getName(), 3, null, string, string + "-" + System.currentTimeMillis());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("deltaManager.createMessage.access", new Object[]{this.getName(), string}));
                }
            }
        }
        if (clusterMessage != null) {
            deltaSession.setLastTimeReplicated(System.currentTimeMillis());
            clusterMessage.setTimestamp(deltaSession.getLastTimeReplicated());
        }
        return clusterMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetStatistics() {
        this.processingTime = 0L;
        this.expiredSessions.set(0L);
        Deque deque = this.sessionCreationTiming;
        synchronized (deque) {
            this.sessionCreationTiming.clear();
            while (this.sessionCreationTiming.size() < 100) {
                this.sessionCreationTiming.add(null);
            }
        }
        deque = this.sessionExpirationTiming;
        synchronized (deque) {
            this.sessionExpirationTiming.clear();
            while (this.sessionExpirationTiming.size() < 100) {
                this.sessionExpirationTiming.add(null);
            }
        }
        this.rejectedSessions = 0;
        this.sessionReplaceCounter = 0L;
        this.counterNoStateTransferred = 0;
        this.setMaxActive(this.getActiveSessions());
        this.sessionCounter = this.getActiveSessions();
        this.counterReceive_EVT_ALL_SESSION_DATA = 0L;
        this.counterReceive_EVT_GET_ALL_SESSIONS = 0L;
        this.counterReceive_EVT_SESSION_ACCESSED = 0L;
        this.counterReceive_EVT_SESSION_CREATED = 0L;
        this.counterReceive_EVT_SESSION_DELTA = 0L;
        this.counterReceive_EVT_SESSION_EXPIRED = 0L;
        this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
        this.counterReceive_EVT_CHANGE_SESSION_ID = 0L;
        this.counterSend_EVT_ALL_SESSION_DATA = 0L;
        this.counterSend_EVT_GET_ALL_SESSIONS = 0L;
        this.counterSend_EVT_SESSION_ACCESSED = 0L;
        this.counterSend_EVT_SESSION_CREATED = 0L;
        this.counterSend_EVT_SESSION_DELTA = 0L;
        this.counterSend_EVT_SESSION_EXPIRED = 0L;
        this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
        this.counterSend_EVT_CHANGE_SESSION_ID = 0L;
    }

    protected void sessionExpired(String string) {
        if (this.cluster.getMembers().length > 0) {
            ++this.counterSend_EVT_SESSION_EXPIRED;
            SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(this.getName(), 2, null, string, string + "-EXPIRED-MSG");
            sessionMessageImpl.setTimestamp(System.currentTimeMillis());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("deltaManager.createMessage.expire", new Object[]{this.getName(), string}));
            }
            this.send(sessionMessageImpl);
        }
    }

    public void expireAllLocalSessions() {
        Session[] sessionArray = this.findSessions();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        if (this.log.isTraceEnabled()) {
            l = System.currentTimeMillis();
            this.log.trace((Object)("Start expire all sessions " + this.getName() + " at " + l + " sessioncount " + sessionArray.length));
        }
        for (Session session : sessionArray) {
            DeltaSession deltaSession;
            if (!(session instanceof DeltaSession) || !(deltaSession = (DeltaSession)session).isPrimarySession()) continue;
            if (deltaSession.isValid()) {
                deltaSession.expire();
                ++n;
                continue;
            }
            ++n2;
        }
        if (this.log.isTraceEnabled()) {
            long l2 = System.currentTimeMillis();
            this.log.trace((Object)("End expire sessions " + this.getName() + " expire processingTime " + (l2 - l) + " expired direct sessions: " + n + " expired direct sessions: " + n2));
        }
    }

    @Override
    public String[] getInvalidatedSessions() {
        return EMPTY_STRING_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void messageReceived(SessionMessage sessionMessage, Member member) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            ClassLoader[] classLoaderArray = this.getClassLoaders();
            thread.setContextClassLoader(classLoaderArray[0]);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)sm.getString("deltaManager.receiveMessage.eventType", new Object[]{this.getName(), sessionMessage.getEventTypeString(), member}));
            }
            switch (sessionMessage.getEventType()) {
                case 4: {
                    this.handleGET_ALL_SESSIONS(sessionMessage, member);
                    return;
                }
                case 12: {
                    this.handleALL_SESSION_DATA(sessionMessage, member);
                    return;
                }
                case 14: {
                    this.handleALL_SESSION_TRANSFERCOMPLETE(sessionMessage, member);
                    return;
                }
                case 1: {
                    this.handleSESSION_CREATED(sessionMessage, member);
                    return;
                }
                case 2: {
                    this.handleSESSION_EXPIRED(sessionMessage, member);
                    return;
                }
                case 3: {
                    this.handleSESSION_ACCESSED(sessionMessage, member);
                    return;
                }
                case 13: {
                    this.handleSESSION_DELTA(sessionMessage, member);
                    return;
                }
                case 15: {
                    this.handleCHANGE_SESSION_ID(sessionMessage, member);
                    return;
                }
                case 16: {
                    this.handleALL_SESSION_NOCONTEXTMANAGER(sessionMessage, member);
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            this.log.error((Object)sm.getString("deltaManager.receiveMessage.error", new Object[]{this.getName()}), (Throwable)exception);
            return;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    protected void handleALL_SESSION_TRANSFERCOMPLETE(SessionMessage sessionMessage, Member member) {
        ++this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.transfercomplete", new Object[]{this.getName(), member.getHost(), member.getPort()}));
        }
        this.stateTransferCreateSendTime = sessionMessage.getTimestamp();
        this.stateTransferred = true;
    }

    protected void handleSESSION_DELTA(SessionMessage sessionMessage, Member member) throws IOException, ClassNotFoundException {
        ++this.counterReceive_EVT_SESSION_DELTA;
        byte[] byArray = sessionMessage.getSession();
        DeltaSession deltaSession = (DeltaSession)this.findSession(sessionMessage.getSessionID());
        if (deltaSession == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("deltaManager.receiveMessage.delta.unknown", new Object[]{this.getName(), sessionMessage.getSessionID()}));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("deltaManager.receiveMessage.delta", new Object[]{this.getName(), sessionMessage.getSessionID()}));
            }
            deltaSession.deserializeAndExecuteDeltaRequest(byArray);
        }
    }

    protected void handleSESSION_ACCESSED(SessionMessage sessionMessage, Member member) throws IOException {
        ++this.counterReceive_EVT_SESSION_ACCESSED;
        DeltaSession deltaSession = (DeltaSession)this.findSession(sessionMessage.getSessionID());
        if (deltaSession != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("deltaManager.receiveMessage.accessed", new Object[]{this.getName(), sessionMessage.getSessionID()}));
            }
            deltaSession.access();
            deltaSession.setPrimarySession(false);
            deltaSession.endAccess();
        }
    }

    protected void handleSESSION_EXPIRED(SessionMessage sessionMessage, Member member) throws IOException {
        ++this.counterReceive_EVT_SESSION_EXPIRED;
        DeltaSession deltaSession = (DeltaSession)this.findSession(sessionMessage.getSessionID());
        if (deltaSession != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("deltaManager.receiveMessage.expired", new Object[]{this.getName(), sessionMessage.getSessionID()}));
            }
            deltaSession.expire(this.notifySessionListenersOnReplication, false);
        }
    }

    protected void handleSESSION_CREATED(SessionMessage sessionMessage, Member member) {
        ++this.counterReceive_EVT_SESSION_CREATED;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.createNewSession", new Object[]{this.getName(), sessionMessage.getSessionID()}));
        }
        DeltaSession deltaSession = (DeltaSession)this.createEmptySession();
        deltaSession.setValid(true);
        deltaSession.setPrimarySession(false);
        deltaSession.setCreationTime(sessionMessage.getTimestamp());
        deltaSession.setMaxInactiveInterval(this.getContext().getSessionTimeout() * 60, false);
        deltaSession.access();
        deltaSession.setId(sessionMessage.getSessionID(), this.notifySessionListenersOnReplication);
        deltaSession.endAccess();
    }

    protected void handleALL_SESSION_DATA(SessionMessage sessionMessage, Member member) throws ClassNotFoundException, IOException {
        ++this.counterReceive_EVT_ALL_SESSION_DATA;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.allSessionDataBegin", new Object[]{this.getName()}));
        }
        byte[] byArray = sessionMessage.getSession();
        this.deserializeSessions(byArray);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.allSessionDataAfter", new Object[]{this.getName()}));
        }
    }

    protected void handleGET_ALL_SESSIONS(SessionMessage sessionMessage, Member member) throws IOException {
        ++this.counterReceive_EVT_GET_ALL_SESSIONS;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.unloadingBegin", new Object[]{this.getName()}));
        }
        Session[] sessionArray = this.findSessions();
        long l = System.currentTimeMillis();
        if (this.isSendAllSessions()) {
            this.sendSessions(member, sessionArray, l);
        } else {
            int n = sessionArray.length;
            for (int i = 0; i < sessionArray.length; i += this.getSendAllSessionsSize()) {
                int n2 = i + this.getSendAllSessionsSize() > sessionArray.length ? sessionArray.length - i : this.getSendAllSessionsSize();
                Session[] sessionArray2 = new Session[n2];
                System.arraycopy(sessionArray, i, sessionArray2, 0, n2);
                this.sendSessions(member, sessionArray2, l);
                if (this.getSendAllSessionsWaitTime() <= 0 || (n -= n2) <= 0) continue;
                try {
                    Thread.sleep(this.getSendAllSessionsWaitTime());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(this.name, 14, null, "SESSION-STATE-TRANSFERRED", "SESSION-STATE-TRANSFERRED" + this.getName());
        sessionMessageImpl.setTimestamp(l);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.createMessage.allSessionTransferred", new Object[]{this.getName()}));
        }
        ++this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE;
        this.cluster.send(sessionMessageImpl, member);
    }

    protected void handleCHANGE_SESSION_ID(SessionMessage sessionMessage, Member member) throws IOException {
        ++this.counterReceive_EVT_CHANGE_SESSION_ID;
        DeltaSession deltaSession = (DeltaSession)this.findSession(sessionMessage.getSessionID());
        if (deltaSession != null) {
            String string = this.deserializeSessionId(sessionMessage.getSession());
            deltaSession.setPrimarySession(false);
            this.changeSessionId(deltaSession, string, this.notifySessionListenersOnReplication, this.notifyContainerListenersOnReplication);
        }
    }

    protected void handleALL_SESSION_NOCONTEXTMANAGER(SessionMessage sessionMessage, Member member) {
        ++this.counterReceive_EVT_ALL_SESSION_NOCONTEXTMANAGER;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.noContextManager", new Object[]{this.getName(), member.getHost(), member.getPort()}));
        }
        this.noContextManagerReceived = true;
    }

    protected void sendSessions(Member member, Session[] sessionArray, long l) throws IOException {
        byte[] byArray = this.serializeSessions(sessionArray);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.receiveMessage.unloadingAfter", new Object[]{this.getName()}));
        }
        SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(this.name, 12, byArray, "SESSION-STATE", "SESSION-STATE-" + this.getName());
        sessionMessageImpl.setTimestamp(l);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("deltaManager.createMessage.allSessionData", new Object[]{this.getName()}));
        }
        ++this.counterSend_EVT_ALL_SESSION_DATA;
        int n = 6;
        this.cluster.send(sessionMessageImpl, member, n);
    }

    @Override
    public ClusterManager cloneFromTemplate() {
        DeltaManager deltaManager = new DeltaManager();
        this.clone(deltaManager);
        deltaManager.expireSessionsOnShutdown = this.expireSessionsOnShutdown;
        deltaManager.notifySessionListenersOnReplication = this.notifySessionListenersOnReplication;
        deltaManager.notifyContainerListenersOnReplication = this.notifyContainerListenersOnReplication;
        deltaManager.stateTransferTimeout = this.stateTransferTimeout;
        deltaManager.sendAllSessions = this.sendAllSessions;
        deltaManager.sendAllSessionsSize = this.sendAllSessionsSize;
        deltaManager.sendAllSessionsWaitTime = this.sendAllSessionsWaitTime;
        deltaManager.stateTimestampDrop = this.stateTimestampDrop;
        return deltaManager;
    }
}

