/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnSessionKey;

public class SingleSignOnEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String authType = null;
    private String password = null;
    private transient Principal principal = null;
    private final Map<SingleSignOnSessionKey, SingleSignOnSessionKey> sessionKeys = new ConcurrentHashMap<SingleSignOnSessionKey, SingleSignOnSessionKey>();
    private String username = null;
    private boolean canReauthenticate = false;

    public SingleSignOnEntry(Principal principal, String string, String string2, String string3) {
        this.updateCredentials(principal, string, string2, string3);
    }

    public void addSession(SingleSignOn singleSignOn, String string, Session session) {
        SingleSignOnSessionKey singleSignOnSessionKey = new SingleSignOnSessionKey(session);
        SingleSignOnSessionKey singleSignOnSessionKey2 = this.sessionKeys.putIfAbsent(singleSignOnSessionKey, singleSignOnSessionKey);
        if (singleSignOnSessionKey2 == null) {
            session.addSessionListener(singleSignOn.getSessionListener(string));
        }
    }

    public void removeSession(Session session) {
        SingleSignOnSessionKey singleSignOnSessionKey = new SingleSignOnSessionKey(session);
        this.sessionKeys.remove(singleSignOnSessionKey);
    }

    public Set<SingleSignOnSessionKey> findSessions() {
        return this.sessionKeys.keySet();
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean getCanReauthenticate() {
        return this.canReauthenticate;
    }

    public String getPassword() {
        return this.password;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void updateCredentials(Principal principal, String string, String string2, String string3) {
        this.principal = principal;
        this.authType = string;
        this.username = string2;
        this.password = string3;
        this.canReauthenticate = "BASIC".equals(string) || "FORM".equals(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.principal instanceof Serializable) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.principal);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            this.principal = (Principal)objectInputStream.readObject();
        }
    }
}

