/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;

public class IdentityOutputFilter
implements OutputFilter {
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected HttpOutputBuffer buffer;

    @Override
    public int doWrite(ByteBuffer byteBuffer) throws IOException {
        int n = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                n = byteBuffer.remaining();
                if ((long)n > this.remaining) {
                    byteBuffer.limit(byteBuffer.position() + (int)this.remaining);
                    n = (int)this.remaining;
                    this.remaining = 0L;
                } else {
                    this.remaining -= (long)n;
                }
                this.buffer.doWrite(byteBuffer);
            } else {
                byteBuffer.position(0);
                byteBuffer.limit(0);
                n = -1;
            }
        } else {
            n = byteBuffer.remaining();
            this.buffer.doWrite(byteBuffer);
            n -= byteBuffer.remaining();
        }
        return n;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
        this.remaining = this.contentLength = response.getContentLengthLong();
    }

    @Override
    public void setBuffer(HttpOutputBuffer httpOutputBuffer) {
        this.buffer = httpOutputBuffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        this.buffer.end();
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }
}

