# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Attributes(_serialization.Model):
    """The object attributes managed by the KeyVault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.not_before = not_before
        self.expires = expires
        self.created = None
        self.updated = None


class BackupKeyResult(_serialization.Model):
    """The backup key result, containing the backup blob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The backup blob containing the backed up key.
    :vartype value: bytes
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class KeyBundle(_serialization.Model):
    """A KeyBundle consisting of a WebKey plus its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key: The Json web key.
    :vartype key: ~key_vault_client.models.JsonWebKey
    :ivar attributes: The key management attributes.
    :vartype attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~key_vault_client.models.KeyReleasePolicy
    """

    _validation = {
        "managed": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "JsonWebKey"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
        "release_policy": {"key": "release_policy", "type": "KeyReleasePolicy"},
    }

    def __init__(
        self,
        *,
        key: Optional["_models.JsonWebKey"] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: The Json web key.
        :paramtype key: ~key_vault_client.models.JsonWebKey
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword release_policy: The policy rules under which the key can be exported.
        :paramtype release_policy: ~key_vault_client.models.KeyReleasePolicy
        """
        super().__init__(**kwargs)
        self.key = key
        self.attributes = attributes
        self.tags = tags
        self.managed = None
        self.release_policy = release_policy


class DeletedKeyBundle(KeyBundle):
    """A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key: The Json web key.
    :vartype key: ~key_vault_client.models.JsonWebKey
    :ivar attributes: The key management attributes.
    :vartype attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~key_vault_client.models.KeyReleasePolicy
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     key.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the key was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "managed": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "JsonWebKey"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
        "release_policy": {"key": "release_policy", "type": "KeyReleasePolicy"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        key: Optional["_models.JsonWebKey"] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
        recovery_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: The Json web key.
        :paramtype key: ~key_vault_client.models.JsonWebKey
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword release_policy: The policy rules under which the key can be exported.
        :paramtype release_policy: ~key_vault_client.models.KeyReleasePolicy
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         key.
        :paramtype recovery_id: str
        """
        super().__init__(key=key, attributes=attributes, tags=tags, release_policy=release_policy, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class KeyItem(_serialization.Model):
    """The key item containing key metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar attributes: The key management attributes.
    :vartype attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        "managed": {"readonly": True},
    }

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kid: Key identifier.
        :paramtype kid: str
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.kid = kid
        self.attributes = attributes
        self.tags = tags
        self.managed = None


class DeletedKeyItem(KeyItem):
    """The deleted key item containing the deleted key metadata and information about deletion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar attributes: The key management attributes.
    :vartype attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     key.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the key was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "managed": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed": {"key": "managed", "type": "bool"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kid: Key identifier.
        :paramtype kid: str
        :keyword attributes: The key management attributes.
        :paramtype attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         key.
        :paramtype recovery_id: str
        """
        super().__init__(kid=kid, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedKeyListResult(_serialization.Model):
    """A list of keys that have been deleted in this vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of deleted keys in the vault along with a
     link to the next page of deleted keys.
    :vartype value: list[~key_vault_client.models.DeletedKeyItem]
    :ivar next_link: The URL to get the next set of deleted keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedKeyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Error(_serialization.Model):
    """The key vault server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~key_vault_client.models.Error
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "inner_error": {"key": "innererror", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class GetRandomBytesRequest(_serialization.Model):
    """The get random bytes request object.

    All required parameters must be populated in order to send to Azure.

    :ivar count: The requested number of random bytes. Required.
    :vartype count: int
    """

    _validation = {
        "count": {"required": True, "maximum": 128, "minimum": 1},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: int, **kwargs: Any) -> None:
        """
        :keyword count: The requested number of random bytes. Required.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class JsonWebKey(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """As of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar kty: JsonWebKey Key Type (kty), as defined in
     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40. Known values are: "EC",
     "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
    :vartype kty: str or ~key_vault_client.models.JsonWebKeyType
    :ivar key_ops:
    :vartype key_ops: list[str]
    :ivar n: RSA modulus.
    :vartype n: bytes
    :ivar e: RSA public exponent.
    :vartype e: bytes
    :ivar d: RSA private exponent, or the D component of an EC private key.
    :vartype d: bytes
    :ivar dp: RSA private key parameter.
    :vartype dp: bytes
    :ivar dq: RSA private key parameter.
    :vartype dq: bytes
    :ivar qi: RSA private key parameter.
    :vartype qi: bytes
    :ivar p: RSA secret prime.
    :vartype p: bytes
    :ivar q: RSA secret prime, with p < q.
    :vartype q: bytes
    :ivar k: Symmetric key.
    :vartype k: bytes
    :ivar t: Protected Key, used with 'Bring Your Own Key'.
    :vartype t: bytes
    :ivar crv: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype crv: str or ~key_vault_client.models.JsonWebKeyCurveName
    :ivar x: X component of an EC public key.
    :vartype x: bytes
    :ivar y: Y component of an EC public key.
    :vartype y: bytes
    """

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "kty": {"key": "kty", "type": "str"},
        "key_ops": {"key": "key_ops", "type": "[str]"},
        "n": {"key": "n", "type": "base64"},
        "e": {"key": "e", "type": "base64"},
        "d": {"key": "d", "type": "base64"},
        "dp": {"key": "dp", "type": "base64"},
        "dq": {"key": "dq", "type": "base64"},
        "qi": {"key": "qi", "type": "base64"},
        "p": {"key": "p", "type": "base64"},
        "q": {"key": "q", "type": "base64"},
        "k": {"key": "k", "type": "base64"},
        "t": {"key": "key_hsm", "type": "base64"},
        "crv": {"key": "crv", "type": "str"},
        "x": {"key": "x", "type": "base64"},
        "y": {"key": "y", "type": "base64"},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        kty: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_ops: Optional[List[str]] = None,
        n: Optional[bytes] = None,
        e: Optional[bytes] = None,
        d: Optional[bytes] = None,
        dp: Optional[bytes] = None,
        dq: Optional[bytes] = None,
        qi: Optional[bytes] = None,
        p: Optional[bytes] = None,
        q: Optional[bytes] = None,
        k: Optional[bytes] = None,
        t: Optional[bytes] = None,
        crv: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        x: Optional[bytes] = None,
        y: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kid: Key identifier.
        :paramtype kid: str
        :keyword kty: JsonWebKey Key Type (kty), as defined in
         https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40. Known values are: "EC",
         "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
        :paramtype kty: str or ~key_vault_client.models.JsonWebKeyType
        :keyword key_ops:
        :paramtype key_ops: list[str]
        :keyword n: RSA modulus.
        :paramtype n: bytes
        :keyword e: RSA public exponent.
        :paramtype e: bytes
        :keyword d: RSA private exponent, or the D component of an EC private key.
        :paramtype d: bytes
        :keyword dp: RSA private key parameter.
        :paramtype dp: bytes
        :keyword dq: RSA private key parameter.
        :paramtype dq: bytes
        :keyword qi: RSA private key parameter.
        :paramtype qi: bytes
        :keyword p: RSA secret prime.
        :paramtype p: bytes
        :keyword q: RSA secret prime, with p < q.
        :paramtype q: bytes
        :keyword k: Symmetric key.
        :paramtype k: bytes
        :keyword t: Protected Key, used with 'Bring Your Own Key'.
        :paramtype t: bytes
        :keyword crv: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
         "P-256", "P-384", "P-521", and "P-256K".
        :paramtype crv: str or ~key_vault_client.models.JsonWebKeyCurveName
        :keyword x: X component of an EC public key.
        :paramtype x: bytes
        :keyword y: Y component of an EC public key.
        :paramtype y: bytes
        """
        super().__init__(**kwargs)
        self.kid = kid
        self.kty = kty
        self.key_ops = key_ops
        self.n = n
        self.e = e
        self.d = d
        self.dp = dp
        self.dq = dq
        self.qi = qi
        self.p = p
        self.q = q
        self.k = k
        self.t = t
        self.crv = crv
        self.x = x
        self.y = y


class KeyAttributes(Attributes):
    """The attributes of a key managed by the key vault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recoverable_days: softDelete data retention days. Value should be >=7 and <=90 when
     softDelete enabled, otherwise 0.
    :vartype recoverable_days: int
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for keys in the
     current vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged
     user; otherwise, only the system can purge the key, at the end of the retention interval. Known
     values are: "Purgeable", "Recoverable+Purgeable", "Recoverable",
     "Recoverable+ProtectedSubscription", "CustomizedRecoverable+Purgeable",
     "CustomizedRecoverable", and "CustomizedRecoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~key_vault_client.models.DeletionRecoveryLevel
    :ivar exportable: Indicates if the private key can be exported. Release policy must be provided
     when creating the first version of an exportable key.
    :vartype exportable: bool
    :ivar hsm_platform: The underlying HSM Platform.
    :vartype hsm_platform: str
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
        "recoverable_days": {"readonly": True},
        "recovery_level": {"readonly": True},
        "hsm_platform": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
        "recoverable_days": {"key": "recoverableDays", "type": "int"},
        "recovery_level": {"key": "recoveryLevel", "type": "str"},
        "exportable": {"key": "exportable", "type": "bool"},
        "hsm_platform": {"key": "hsmPlatform", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        exportable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        :keyword exportable: Indicates if the private key can be exported. Release policy must be
         provided when creating the first version of an exportable key.
        :paramtype exportable: bool
        """
        super().__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recoverable_days = None
        self.recovery_level = None
        self.exportable = exportable
        self.hsm_platform = None


class KeyCreateParameters(_serialization.Model):
    """The key create parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar kty: The type of key to create. For valid values, see JsonWebKeyType. Required. Known
     values are: "EC", "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
    :vartype kty: str or ~key_vault_client.models.JsonWebKeyType
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar public_exponent: The public exponent for a RSA key.
    :vartype public_exponent: int
    :ivar key_ops:
    :vartype key_ops: list[str or ~key_vault_client.models.JsonWebKeyOperation]
    :ivar key_attributes: The attributes of a key managed by the key vault service.
    :vartype key_attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve: str or ~key_vault_client.models.JsonWebKeyCurveName
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~key_vault_client.models.KeyReleasePolicy
    """

    _validation = {
        "kty": {"required": True},
    }

    _attribute_map = {
        "kty": {"key": "kty", "type": "str"},
        "key_size": {"key": "key_size", "type": "int"},
        "public_exponent": {"key": "public_exponent", "type": "int"},
        "key_ops": {"key": "key_ops", "type": "[str]"},
        "key_attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "curve": {"key": "crv", "type": "str"},
        "release_policy": {"key": "release_policy", "type": "KeyReleasePolicy"},
    }

    def __init__(
        self,
        *,
        kty: Union[str, "_models.JsonWebKeyType"],
        key_size: Optional[int] = None,
        public_exponent: Optional[int] = None,
        key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kty: The type of key to create. For valid values, see JsonWebKeyType. Required. Known
         values are: "EC", "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
        :paramtype kty: str or ~key_vault_client.models.JsonWebKeyType
        :keyword key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
        :paramtype key_size: int
        :keyword public_exponent: The public exponent for a RSA key.
        :paramtype public_exponent: int
        :keyword key_ops:
        :paramtype key_ops: list[str or ~key_vault_client.models.JsonWebKeyOperation]
        :keyword key_attributes: The attributes of a key managed by the key vault service.
        :paramtype key_attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values
         are: "P-256", "P-384", "P-521", and "P-256K".
        :paramtype curve: str or ~key_vault_client.models.JsonWebKeyCurveName
        :keyword release_policy: The policy rules under which the key can be exported.
        :paramtype release_policy: ~key_vault_client.models.KeyReleasePolicy
        """
        super().__init__(**kwargs)
        self.kty = kty
        self.key_size = key_size
        self.public_exponent = public_exponent
        self.key_ops = key_ops
        self.key_attributes = key_attributes
        self.tags = tags
        self.curve = curve
        self.release_policy = release_policy


class KeyExportParameters(_serialization.Model):
    """The export key parameters.

    :ivar wrapping_key: The export key encryption Json web key. This key MUST be a RSA key that
     supports encryption.
    :vartype wrapping_key: ~key_vault_client.models.JsonWebKey
    :ivar wrapping_kid: The export key encryption key identifier. This key MUST be a RSA key that
     supports encryption.
    :vartype wrapping_kid: str
    :ivar enc: The encryption algorithm to use to protected the exported key material. Known values
     are: "CKM_RSA_AES_KEY_WRAP", "RSA_AES_KEY_WRAP_256", and "RSA_AES_KEY_WRAP_384".
    :vartype enc: str or ~key_vault_client.models.KeyEncryptionAlgorithm
    """

    _attribute_map = {
        "wrapping_key": {"key": "wrappingKey", "type": "JsonWebKey"},
        "wrapping_kid": {"key": "wrappingKid", "type": "str"},
        "enc": {"key": "enc", "type": "str"},
    }

    def __init__(
        self,
        *,
        wrapping_key: Optional["_models.JsonWebKey"] = None,
        wrapping_kid: Optional[str] = None,
        enc: Optional[Union[str, "_models.KeyEncryptionAlgorithm"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword wrapping_key: The export key encryption Json web key. This key MUST be a RSA key that
         supports encryption.
        :paramtype wrapping_key: ~key_vault_client.models.JsonWebKey
        :keyword wrapping_kid: The export key encryption key identifier. This key MUST be a RSA key
         that supports encryption.
        :paramtype wrapping_kid: str
        :keyword enc: The encryption algorithm to use to protected the exported key material. Known
         values are: "CKM_RSA_AES_KEY_WRAP", "RSA_AES_KEY_WRAP_256", and "RSA_AES_KEY_WRAP_384".
        :paramtype enc: str or ~key_vault_client.models.KeyEncryptionAlgorithm
        """
        super().__init__(**kwargs)
        self.wrapping_key = wrapping_key
        self.wrapping_kid = wrapping_kid
        self.enc = enc


class KeyImportParameters(_serialization.Model):
    """The key import parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar hsm: Whether to import as a hardware key (HSM) or software key.
    :vartype hsm: bool
    :ivar key: The Json web key. Required.
    :vartype key: ~key_vault_client.models.JsonWebKey
    :ivar key_attributes: The key management attributes.
    :vartype key_attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~key_vault_client.models.KeyReleasePolicy
    """

    _validation = {
        "key": {"required": True},
    }

    _attribute_map = {
        "hsm": {"key": "Hsm", "type": "bool"},
        "key": {"key": "key", "type": "JsonWebKey"},
        "key_attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "release_policy": {"key": "release_policy", "type": "KeyReleasePolicy"},
    }

    def __init__(
        self,
        *,
        key: "_models.JsonWebKey",
        hsm: Optional[bool] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hsm: Whether to import as a hardware key (HSM) or software key.
        :paramtype hsm: bool
        :keyword key: The Json web key. Required.
        :paramtype key: ~key_vault_client.models.JsonWebKey
        :keyword key_attributes: The key management attributes.
        :paramtype key_attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword release_policy: The policy rules under which the key can be exported.
        :paramtype release_policy: ~key_vault_client.models.KeyReleasePolicy
        """
        super().__init__(**kwargs)
        self.hsm = hsm
        self.key = key
        self.key_attributes = key_attributes
        self.tags = tags
        self.release_policy = release_policy


class KeyListResult(_serialization.Model):
    """The key list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of keys in the key vault along with a link to
     the next page of keys.
    :vartype value: list[~key_vault_client.models.KeyItem]
    :ivar next_link: The URL to get the next set of keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[KeyItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class KeyOperationResult(_serialization.Model):
    """The key operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar result:
    :vartype result: bytes
    :ivar iv:
    :vartype iv: bytes
    :ivar authentication_tag:
    :vartype authentication_tag: bytes
    :ivar additional_authenticated_data:
    :vartype additional_authenticated_data: bytes
    """

    _validation = {
        "kid": {"readonly": True},
        "result": {"readonly": True},
        "iv": {"readonly": True},
        "authentication_tag": {"readonly": True},
        "additional_authenticated_data": {"readonly": True},
    }

    _attribute_map = {
        "kid": {"key": "kid", "type": "str"},
        "result": {"key": "value", "type": "base64"},
        "iv": {"key": "iv", "type": "base64"},
        "authentication_tag": {"key": "tag", "type": "base64"},
        "additional_authenticated_data": {"key": "aad", "type": "base64"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kid = None
        self.result = None
        self.iv = None
        self.authentication_tag = None
        self.additional_authenticated_data = None


class KeyOperationsParameters(_serialization.Model):
    """The key operations parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar algorithm: algorithm identifier. Required. Known values are: "RSA-OAEP", "RSA-OAEP-256",
     "RSA1_5", "A128GCM", "A192GCM", "A256GCM", "A128KW", "A192KW", "A256KW", "A128CBC", "A192CBC",
     "A256CBC", "A128CBCPAD", "A192CBCPAD", and "A256CBCPAD".
    :vartype algorithm: str or ~key_vault_client.models.JsonWebKeyEncryptionAlgorithm
    :ivar value: Required.
    :vartype value: bytes
    :ivar iv: Cryptographically random, non-repeating initialization vector for symmetric
     algorithms.
    :vartype iv: bytes
    :ivar aad: Additional data to authenticate but not encrypt/decrypt when using authenticated
     crypto algorithms.
    :vartype aad: bytes
    :ivar tag: The tag to authenticate when performing decryption with an authenticated algorithm.
    :vartype tag: bytes
    """

    _validation = {
        "algorithm": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "algorithm": {"key": "alg", "type": "str"},
        "value": {"key": "value", "type": "base64"},
        "iv": {"key": "iv", "type": "base64"},
        "aad": {"key": "aad", "type": "base64"},
        "tag": {"key": "tag", "type": "base64"},
    }

    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.JsonWebKeyEncryptionAlgorithm"],
        value: bytes,
        iv: Optional[bytes] = None,
        aad: Optional[bytes] = None,
        tag: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword algorithm: algorithm identifier. Required. Known values are: "RSA-OAEP",
         "RSA-OAEP-256", "RSA1_5", "A128GCM", "A192GCM", "A256GCM", "A128KW", "A192KW", "A256KW",
         "A128CBC", "A192CBC", "A256CBC", "A128CBCPAD", "A192CBCPAD", and "A256CBCPAD".
        :paramtype algorithm: str or ~key_vault_client.models.JsonWebKeyEncryptionAlgorithm
        :keyword value: Required.
        :paramtype value: bytes
        :keyword iv: Cryptographically random, non-repeating initialization vector for symmetric
         algorithms.
        :paramtype iv: bytes
        :keyword aad: Additional data to authenticate but not encrypt/decrypt when using authenticated
         crypto algorithms.
        :paramtype aad: bytes
        :keyword tag: The tag to authenticate when performing decryption with an authenticated
         algorithm.
        :paramtype tag: bytes
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value
        self.iv = iv
        self.aad = aad
        self.tag = tag


class KeyProperties(_serialization.Model):
    """Properties of the key pair backing a certificate.

    :ivar exportable: Indicates if the private key can be exported. Release policy must be provided
     when creating the first version of an exportable key.
    :vartype exportable: bool
    :ivar key_type: The type of key pair to be used for the certificate. Known values are: "EC",
     "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
    :vartype key_type: str or ~key_vault_client.models.JsonWebKeyType
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar reuse_key: Indicates if the same key pair will be used on certificate renewal.
    :vartype reuse_key: bool
    :ivar curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve: str or ~key_vault_client.models.JsonWebKeyCurveName
    """

    _attribute_map = {
        "exportable": {"key": "exportable", "type": "bool"},
        "key_type": {"key": "kty", "type": "str"},
        "key_size": {"key": "key_size", "type": "int"},
        "reuse_key": {"key": "reuse_key", "type": "bool"},
        "curve": {"key": "crv", "type": "str"},
    }

    def __init__(
        self,
        *,
        exportable: Optional[bool] = None,
        key_type: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_size: Optional[int] = None,
        reuse_key: Optional[bool] = None,
        curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exportable: Indicates if the private key can be exported. Release policy must be
         provided when creating the first version of an exportable key.
        :paramtype exportable: bool
        :keyword key_type: The type of key pair to be used for the certificate. Known values are: "EC",
         "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
        :paramtype key_type: str or ~key_vault_client.models.JsonWebKeyType
        :keyword key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
        :paramtype key_size: int
        :keyword reuse_key: Indicates if the same key pair will be used on certificate renewal.
        :paramtype reuse_key: bool
        :keyword curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values
         are: "P-256", "P-384", "P-521", and "P-256K".
        :paramtype curve: str or ~key_vault_client.models.JsonWebKeyCurveName
        """
        super().__init__(**kwargs)
        self.exportable = exportable
        self.key_type = key_type
        self.key_size = key_size
        self.reuse_key = reuse_key
        self.curve = curve


class KeyReleaseParameters(_serialization.Model):
    """The release key parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar target_attestation_token: The attestation assertion for the target of the key release.
     Required.
    :vartype target_attestation_token: str
    :ivar nonce: A client provided nonce for freshness.
    :vartype nonce: str
    :ivar enc: The encryption algorithm to use to protected the exported key material. Known values
     are: "CKM_RSA_AES_KEY_WRAP", "RSA_AES_KEY_WRAP_256", and "RSA_AES_KEY_WRAP_384".
    :vartype enc: str or ~key_vault_client.models.KeyEncryptionAlgorithm
    """

    _validation = {
        "target_attestation_token": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "target_attestation_token": {"key": "target", "type": "str"},
        "nonce": {"key": "nonce", "type": "str"},
        "enc": {"key": "enc", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_attestation_token: str,
        nonce: Optional[str] = None,
        enc: Optional[Union[str, "_models.KeyEncryptionAlgorithm"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_attestation_token: The attestation assertion for the target of the key release.
         Required.
        :paramtype target_attestation_token: str
        :keyword nonce: A client provided nonce for freshness.
        :paramtype nonce: str
        :keyword enc: The encryption algorithm to use to protected the exported key material. Known
         values are: "CKM_RSA_AES_KEY_WRAP", "RSA_AES_KEY_WRAP_256", and "RSA_AES_KEY_WRAP_384".
        :paramtype enc: str or ~key_vault_client.models.KeyEncryptionAlgorithm
        """
        super().__init__(**kwargs)
        self.target_attestation_token = target_attestation_token
        self.nonce = nonce
        self.enc = enc


class KeyReleasePolicy(_serialization.Model):
    """The policy rules under which the key can be exported.

    :ivar content_type: Content type and version of key release policy.
    :vartype content_type: str
    :ivar immutable: Defines the mutability state of the policy. Once marked immutable, this flag
     cannot be reset and the policy cannot be changed under any circumstances.
    :vartype immutable: bool
    :ivar encoded_policy: Blob encoding the policy rules under which the key can be released. Blob
     must be base64 URL encoded.
    :vartype encoded_policy: bytes
    """

    _attribute_map = {
        "content_type": {"key": "contentType", "type": "str"},
        "immutable": {"key": "immutable", "type": "bool"},
        "encoded_policy": {"key": "data", "type": "base64"},
    }

    def __init__(
        self,
        *,
        content_type: str = "application/json; charset=utf-8",
        immutable: Optional[bool] = None,
        encoded_policy: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content_type: Content type and version of key release policy.
        :paramtype content_type: str
        :keyword immutable: Defines the mutability state of the policy. Once marked immutable, this
         flag cannot be reset and the policy cannot be changed under any circumstances.
        :paramtype immutable: bool
        :keyword encoded_policy: Blob encoding the policy rules under which the key can be released.
         Blob must be base64 URL encoded.
        :paramtype encoded_policy: bytes
        """
        super().__init__(**kwargs)
        self.content_type = content_type
        self.immutable = immutable
        self.encoded_policy = encoded_policy


class KeyReleaseResult(_serialization.Model):
    """The release result, containing the released key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A signed object containing the released key.
    :vartype value: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class KeyRestoreParameters(_serialization.Model):
    """The key restore parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar key_bundle_backup: The backup blob associated with a key bundle. Required.
    :vartype key_bundle_backup: bytes
    """

    _validation = {
        "key_bundle_backup": {"required": True},
    }

    _attribute_map = {
        "key_bundle_backup": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, key_bundle_backup: bytes, **kwargs: Any) -> None:
        """
        :keyword key_bundle_backup: The backup blob associated with a key bundle. Required.
        :paramtype key_bundle_backup: bytes
        """
        super().__init__(**kwargs)
        self.key_bundle_backup = key_bundle_backup


class KeyRotationPolicy(_serialization.Model):
    """Management policy for a key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The key policy id.
    :vartype id: str
    :ivar lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a key.
     For preview, lifetimeActions can only have two items at maximum: one for rotate, one for
     notify. Notification time would be default to 30 days before expiry and it is not configurable.
    :vartype lifetime_actions: list[~key_vault_client.models.LifetimeActions]
    :ivar attributes: The key rotation policy attributes.
    :vartype attributes: ~key_vault_client.models.KeyRotationPolicyAttributes
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "lifetime_actions": {"key": "lifetimeActions", "type": "[LifetimeActions]"},
        "attributes": {"key": "attributes", "type": "KeyRotationPolicyAttributes"},
    }

    def __init__(
        self,
        *,
        lifetime_actions: Optional[List["_models.LifetimeActions"]] = None,
        attributes: Optional["_models.KeyRotationPolicyAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a
         key. For preview, lifetimeActions can only have two items at maximum: one for rotate, one for
         notify. Notification time would be default to 30 days before expiry and it is not configurable.
        :paramtype lifetime_actions: list[~key_vault_client.models.LifetimeActions]
        :keyword attributes: The key rotation policy attributes.
        :paramtype attributes: ~key_vault_client.models.KeyRotationPolicyAttributes
        """
        super().__init__(**kwargs)
        self.id = None
        self.lifetime_actions = lifetime_actions
        self.attributes = attributes


class KeyRotationPolicyAttributes(_serialization.Model):
    """The key rotation policy attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiry_time: The expiryTime will be applied on the new key version. It should be at least
     28 days. It will be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours:
     PT48H, 1 year and 10 days: P1Y10D.
    :vartype expiry_time: str
    :ivar created: The key rotation policy created time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: The key rotation policy's last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "expiry_time": {"key": "expiryTime", "type": "str"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(self, *, expiry_time: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword expiry_time: The expiryTime will be applied on the new key version. It should be at
         least 28 days. It will be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours:
         PT48H, 1 year and 10 days: P1Y10D.
        :paramtype expiry_time: str
        """
        super().__init__(**kwargs)
        self.expiry_time = expiry_time
        self.created = None
        self.updated = None


class KeySignParameters(_serialization.Model):
    """The key operations parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar algorithm: The signing/verification algorithm identifier. For more information on
     possible algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are:
     "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and
     "ES256K".
    :vartype algorithm: str or ~key_vault_client.models.JsonWebKeySignatureAlgorithm
    :ivar value: Required.
    :vartype value: bytes
    """

    _validation = {
        "algorithm": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "algorithm": {"key": "alg", "type": "str"},
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(
        self, *, algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"], value: bytes, **kwargs: Any
    ) -> None:
        """
        :keyword algorithm: The signing/verification algorithm identifier. For more information on
         possible algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are:
         "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and
         "ES256K".
        :paramtype algorithm: str or ~key_vault_client.models.JsonWebKeySignatureAlgorithm
        :keyword value: Required.
        :paramtype value: bytes
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class KeyUpdateParameters(_serialization.Model):
    """The key update parameters.

    :ivar key_ops: Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation.
    :vartype key_ops: list[str or ~key_vault_client.models.JsonWebKeyOperation]
    :ivar key_attributes: The attributes of a key managed by the key vault service.
    :vartype key_attributes: ~key_vault_client.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~key_vault_client.models.KeyReleasePolicy
    """

    _attribute_map = {
        "key_ops": {"key": "key_ops", "type": "[str]"},
        "key_attributes": {"key": "attributes", "type": "KeyAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "release_policy": {"key": "release_policy", "type": "KeyReleasePolicy"},
    }

    def __init__(
        self,
        *,
        key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_ops: Json web key operations. For more information on possible key operations, see
         JsonWebKeyOperation.
        :paramtype key_ops: list[str or ~key_vault_client.models.JsonWebKeyOperation]
        :keyword key_attributes: The attributes of a key managed by the key vault service.
        :paramtype key_attributes: ~key_vault_client.models.KeyAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword release_policy: The policy rules under which the key can be exported.
        :paramtype release_policy: ~key_vault_client.models.KeyReleasePolicy
        """
        super().__init__(**kwargs)
        self.key_ops = key_ops
        self.key_attributes = key_attributes
        self.tags = tags
        self.release_policy = release_policy


class KeyVaultError(_serialization.Model):
    """The key vault error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The key vault server error.
    :vartype error: ~key_vault_client.models.Error
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class KeyVerifyParameters(_serialization.Model):
    """The key verify parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar algorithm: The signing/verification algorithm. For more information on possible algorithm
     types, see JsonWebKeySignatureAlgorithm. Required. Known values are: "PS256", "PS384", "PS512",
     "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and "ES256K".
    :vartype algorithm: str or ~key_vault_client.models.JsonWebKeySignatureAlgorithm
    :ivar digest: The digest used for signing. Required.
    :vartype digest: bytes
    :ivar signature: The signature to be verified. Required.
    :vartype signature: bytes
    """

    _validation = {
        "algorithm": {"required": True},
        "digest": {"required": True},
        "signature": {"required": True},
    }

    _attribute_map = {
        "algorithm": {"key": "alg", "type": "str"},
        "digest": {"key": "digest", "type": "base64"},
        "signature": {"key": "value", "type": "base64"},
    }

    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"],
        digest: bytes,
        signature: bytes,
        **kwargs: Any
    ) -> None:
        """
        :keyword algorithm: The signing/verification algorithm. For more information on possible
         algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are: "PS256",
         "PS384", "PS512", "RS256", "RS384", "RS512", "RSNULL", "ES256", "ES384", "ES512", and "ES256K".
        :paramtype algorithm: str or ~key_vault_client.models.JsonWebKeySignatureAlgorithm
        :keyword digest: The digest used for signing. Required.
        :paramtype digest: bytes
        :keyword signature: The signature to be verified. Required.
        :paramtype signature: bytes
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.digest = digest
        self.signature = signature


class KeyVerifyResult(_serialization.Model):
    """The key verify result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: True if the signature is verified, otherwise false.
    :vartype value: bool
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class LifetimeActions(_serialization.Model):
    """Action and its trigger that will be performed by Key Vault over the lifetime of a key.

    :ivar trigger: The condition that will execute the action.
    :vartype trigger: ~key_vault_client.models.LifetimeActionsTrigger
    :ivar action: The action that will be executed.
    :vartype action: ~key_vault_client.models.LifetimeActionsType
    """

    _attribute_map = {
        "trigger": {"key": "trigger", "type": "LifetimeActionsTrigger"},
        "action": {"key": "action", "type": "LifetimeActionsType"},
    }

    def __init__(
        self,
        *,
        trigger: Optional["_models.LifetimeActionsTrigger"] = None,
        action: Optional["_models.LifetimeActionsType"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword trigger: The condition that will execute the action.
        :paramtype trigger: ~key_vault_client.models.LifetimeActionsTrigger
        :keyword action: The action that will be executed.
        :paramtype action: ~key_vault_client.models.LifetimeActionsType
        """
        super().__init__(**kwargs)
        self.trigger = trigger
        self.action = action


class LifetimeActionsTrigger(_serialization.Model):
    """A condition to be satisfied for an action to be executed.

    :ivar time_after_create: Time after creation to attempt to rotate. It only applies to rotate.
     It will be in ISO 8601 duration format. Example: 90 days : "P90D".
    :vartype time_after_create: str
    :ivar time_before_expiry: Time before expiry to attempt to rotate or notify. It will be in ISO
     8601 duration format. Example: 90 days : "P90D".
    :vartype time_before_expiry: str
    """

    _attribute_map = {
        "time_after_create": {"key": "timeAfterCreate", "type": "str"},
        "time_before_expiry": {"key": "timeBeforeExpiry", "type": "str"},
    }

    def __init__(
        self, *, time_after_create: Optional[str] = None, time_before_expiry: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword time_after_create: Time after creation to attempt to rotate. It only applies to
         rotate. It will be in ISO 8601 duration format. Example: 90 days : "P90D".
        :paramtype time_after_create: str
        :keyword time_before_expiry: Time before expiry to attempt to rotate or notify. It will be in
         ISO 8601 duration format. Example: 90 days : "P90D".
        :paramtype time_before_expiry: str
        """
        super().__init__(**kwargs)
        self.time_after_create = time_after_create
        self.time_before_expiry = time_before_expiry


class LifetimeActionsType(_serialization.Model):
    """The action that will be executed.

    :ivar type: The type of the action. The value should be compared case-insensitively. Known
     values are: "Rotate" and "Notify".
    :vartype type: str or ~key_vault_client.models.ActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ActionType"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of the action. The value should be compared case-insensitively. Known
         values are: "Rotate" and "Notify".
        :paramtype type: str or ~key_vault_client.models.ActionType
        """
        super().__init__(**kwargs)
        self.type = type


class RandomBytes(_serialization.Model):
    """The get random bytes response object containing the bytes.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The bytes encoded as a base64url string. Required.
    :vartype value: bytes
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, value: bytes, **kwargs: Any) -> None:
        """
        :keyword value: The bytes encoded as a base64url string. Required.
        :paramtype value: bytes
        """
        super().__init__(**kwargs)
        self.value = value
