# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.privatelinks.v2020_05_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.privatelinks.v2020_05_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class PrivateLinkAssociation(_serialization.Model):
    """PrivateLinkAssociation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: The private link association properties.
    :vartype properties:
     ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PrivateLinkAssociationPropertiesExpanded
    :ivar id: The plaResourceID.
    :vartype id: str
    :ivar type: The operation type.
    :vartype type: str
    :ivar name: The pla name.
    :vartype name: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "PrivateLinkAssociationPropertiesExpanded"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, properties: Optional["_models.PrivateLinkAssociationPropertiesExpanded"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The private link association properties.
        :paramtype properties:
         ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PrivateLinkAssociationPropertiesExpanded
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.type = None
        self.name = None


class PrivateLinkAssociationGetResult(_serialization.Model):
    """Result of the request to get PLA for a MG scope.

    :ivar value: private link association information.
    :vartype value:
     list[~azure.mgmt.resource.privatelinks.v2020_05_01.models.PrivateLinkAssociation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkAssociation]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkAssociation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: private link association information.
        :paramtype value:
         list[~azure.mgmt.resource.privatelinks.v2020_05_01.models.PrivateLinkAssociation]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkAssociationObject(_serialization.Model):
    """PrivateLinkAssociationObject.

    :ivar properties: The properties of the PrivateLinkAssociation.
    :vartype properties:
     ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PrivateLinkAssociationProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "PrivateLinkAssociationProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.PrivateLinkAssociationProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The properties of the PrivateLinkAssociation.
        :paramtype properties:
         ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PrivateLinkAssociationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateLinkAssociationProperties(_serialization.Model):
    """PrivateLinkAssociationProperties.

    :ivar private_link: The rmpl Resource ID.
    :vartype private_link: str
    :ivar public_network_access: Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PublicNetworkAccessOptions
    """

    _attribute_map = {
        "private_link": {"key": "privateLink", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_link: The rmpl Resource ID.
        :paramtype private_link: str
        :keyword public_network_access: Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PublicNetworkAccessOptions
        """
        super().__init__(**kwargs)
        self.private_link = private_link
        self.public_network_access = public_network_access


class PrivateLinkAssociationPropertiesExpanded(_serialization.Model):
    """Private Link Association Properties.

    :ivar private_link: The rmpl Resource ID.
    :vartype private_link: str
    :ivar public_network_access: Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PublicNetworkAccessOptions
    :ivar tenant_id: The TenantID.
    :vartype tenant_id: str
    :ivar scope: The scope of the private link association.
    :vartype scope: str
    """

    _attribute_map = {
        "private_link": {"key": "privateLink", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "tenant_id": {"key": "tenantID", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessOptions"]] = None,
        tenant_id: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_link: The rmpl Resource ID.
        :paramtype private_link: str
        :keyword public_network_access: Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.resource.privatelinks.v2020_05_01.models.PublicNetworkAccessOptions
        :keyword tenant_id: The TenantID.
        :paramtype tenant_id: str
        :keyword scope: The scope of the private link association.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.private_link = private_link
        self.public_network_access = public_network_access
        self.tenant_id = tenant_id
        self.scope = scope


class ResourceManagementPrivateLink(_serialization.Model):
    """ResourceManagementPrivateLink.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.resource.privatelinks.v2020_05_01.models.ResourceManagementPrivateLinkEndpointConnections
    :ivar id: The rmplResourceID.
    :vartype id: str
    :ivar name: The rmpl Name.
    :vartype name: str
    :ivar type: The operation type.
    :vartype type: str
    :ivar location: the region of the rmpl.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ResourceManagementPrivateLinkEndpointConnections"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ResourceManagementPrivateLinkEndpointConnections"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.resource.privatelinks.v2020_05_01.models.ResourceManagementPrivateLinkEndpointConnections
        :keyword location: the region of the rmpl.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.location = location


class ResourceManagementPrivateLinkEndpointConnections(_serialization.Model):
    """ResourceManagementPrivateLinkEndpointConnections.

    :ivar private_endpoint_connections: The private endpoint connections.
    :vartype private_endpoint_connections: list[str]
    """

    _attribute_map = {
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[str]"},
    }

    def __init__(self, *, private_endpoint_connections: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword private_endpoint_connections: The private endpoint connections.
        :paramtype private_endpoint_connections: list[str]
        """
        super().__init__(**kwargs)
        self.private_endpoint_connections = private_endpoint_connections


class ResourceManagementPrivateLinkListResult(_serialization.Model):
    """ResourceManagementPrivateLinkListResult.

    :ivar value: An array of resource management private links.
    :vartype value:
     list[~azure.mgmt.resource.privatelinks.v2020_05_01.models.ResourceManagementPrivateLink]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceManagementPrivateLink]"},
    }

    def __init__(self, *, value: Optional[List["_models.ResourceManagementPrivateLink"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of resource management private links.
        :paramtype value:
         list[~azure.mgmt.resource.privatelinks.v2020_05_01.models.ResourceManagementPrivateLink]
        """
        super().__init__(**kwargs)
        self.value = value


class ResourceManagementPrivateLinkLocation(_serialization.Model):
    """ResourceManagementPrivateLinkLocation.

    :ivar location: the region to create private link association.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: the region to create private link association.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location
