"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.ResourceType = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_INTEGER = exports.LOGIN_PAGE_URI = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearchDashboardsSecurity';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'security-dashboards-plugin';
const APP_ID_LOGIN = exports.APP_ID_LOGIN = 'login';
const APP_ID_CUSTOMERROR = exports.APP_ID_CUSTOMERROR = 'customerror';
const OPENDISTRO_SECURITY_ANONYMOUS = exports.OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
const API_PREFIX = exports.API_PREFIX = '/api/v1';
const CONFIGURATION_API_PREFIX = exports.CONFIGURATION_API_PREFIX = 'configuration';
const API_ENDPOINT_AUTHINFO = exports.API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
const API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_DASHBOARDSINFO = API_PREFIX + '/auth/dashboardsinfo';
const API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
const LOGIN_PAGE_URI = exports.LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
const CUSTOM_ERROR_PAGE_URI = exports.CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
const API_AUTH_LOGIN = exports.API_AUTH_LOGIN = '/auth/login';
const API_AUTH_LOGOUT = exports.API_AUTH_LOGOUT = '/auth/logout';
const OPENID_AUTH_LOGIN = exports.OPENID_AUTH_LOGIN = '/auth/openid/login';
const OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = '/auth/openid/captureUrlFragment';
const SAML_AUTH_LOGIN = exports.SAML_AUTH_LOGIN = '/auth/saml/login';
const SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment';
const ANONYMOUS_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
const OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGOUT = '/auth/openid/logout';
const SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGOUT = '/auth/saml/logout';
const ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
const ERROR_MISSING_ROLE_PATH = exports.ERROR_MISSING_ROLE_PATH = '/missing-role';
const AUTH_HEADER_NAME = exports.AUTH_HEADER_NAME = 'authorization';
const AUTH_GRANT_TYPE = exports.AUTH_GRANT_TYPE = 'authorization_code';
const AUTH_RESPONSE_TYPE = exports.AUTH_RESPONSE_TYPE = 'code';
const GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_SYMBOL = '';
const PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_SYMBOL = '__user__';
const DEFAULT_TENANT = exports.DEFAULT_TENANT = 'default';
const GLOBAL_TENANT_RENDERING_TEXT = exports.GLOBAL_TENANT_RENDERING_TEXT = 'Global';
const PRIVATE_TENANT_RENDERING_TEXT = exports.PRIVATE_TENANT_RENDERING_TEXT = 'Private';
const globalTenantName = exports.globalTenantName = 'global_tenant';
const MAX_INTEGER = exports.MAX_INTEGER = 2147483647;
const MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_LENGTH_OF_COOKIE_BYTES = 4000;
const ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = 1.5;
let AuthType = exports.AuthType = /*#__PURE__*/function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
  return AuthType;
}({});
let ResourceType = exports.ResourceType = /*#__PURE__*/function (ResourceType) {
  ResourceType["roles"] = "roles";
  ResourceType["users"] = "users";
  ResourceType["permissions"] = "permissions";
  ResourceType["tenants"] = "tenants";
  ResourceType["tenantsManageTab"] = "tenantsManageTab";
  ResourceType["tenantsConfigureTab"] = "tenantsConfigureTab";
  ResourceType["auth"] = "auth";
  ResourceType["auditLogging"] = "auditLogging";
  return ResourceType;
}({});
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */
function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}
function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}
function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}
function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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