"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProxyAuthentication = void 0;
var _lodash = require("lodash");
var _routes = require("./routes");
var _authentication_type = require("../authentication_type");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
class ProxyAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    var _this$config$proxycac, _this$config$proxycac2;
    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);
    _defineProperty(this, "type", 'proxy');
    _defineProperty(this, "authType", 'proxycache');
    _defineProperty(this, "userHeaderName", void 0);
    _defineProperty(this, "roleHeaderName", void 0);
    this.userHeaderName = ((_this$config$proxycac = this.config.proxycache) === null || _this$config$proxycac === void 0 || (_this$config$proxycac = _this$config$proxycac.user_header) === null || _this$config$proxycac === void 0 ? void 0 : _this$config$proxycac.toLowerCase()) || '';
    this.roleHeaderName = ((_this$config$proxycac2 = this.config.proxycache) === null || _this$config$proxycac2 === void 0 || (_this$config$proxycac2 = _this$config$proxycac2.roles_header) === null || _this$config$proxycac2 === void 0 ? void 0 : _this$config$proxycac2.toLowerCase()) || '';
  }
  async init() {
    const routes = new _routes.ProxyAuthRoutes(this.router, this.config, this.sessionStorageFactory, this.securityClient, this.coreSetup);
    routes.setupRoutes();
  }
  requestIncludesAuthInfo(request) {
    return request.headers[ProxyAuthentication.XFF] && request.headers[this.userHeaderName] ? true : false;
  }
  async getAdditionalAuthHeader(request) {
    var _this$config$proxycac3, _this$config$proxycac4;
    const authHeaders = {};
    const customProxyHeader = (_this$config$proxycac3 = this.config.proxycache) === null || _this$config$proxycac3 === void 0 ? void 0 : _this$config$proxycac3.proxy_header;
    if (customProxyHeader && !request.headers[customProxyHeader] && (_this$config$proxycac4 = this.config.proxycache) !== null && _this$config$proxycac4 !== void 0 && _this$config$proxycac4.proxy_header_ip) {
      // TODO: check how to get remoteIp from OpenSearchDashboardsRequest and add remoteIp to this header
      authHeaders[customProxyHeader] = this.config.proxycache.proxy_header_ip;
    }
    return authHeaders;
  }
  getCookie(request, authInfo) {
    const cookie = {
      username: authInfo.username,
      credentials: {},
      authType: this.authType,
      isAnonymousAuth: false,
      expiryTime: Date.now() + this.config.session.ttl
    };
    if (this.userHeaderName && request.headers[this.userHeaderName]) {
      cookie.credentials[this.userHeaderName] = request.headers[this.userHeaderName];
    }
    if (this.roleHeaderName && request.headers[this.roleHeaderName]) {
      cookie.credentials[this.roleHeaderName] = request.headers[this.roleHeaderName];
    }
    if (request.headers[ProxyAuthentication.XFF]) {
      cookie.credentials[ProxyAuthentication.XFF] = request.headers[ProxyAuthentication.XFF];
    }
    if (request.headers.authorization) {
      cookie.credentials.authorization = request.headers.authorization;
    }
    return cookie;
  }
  async isValidCookie(cookie) {
    return cookie.authType === this.type && cookie.username && cookie.expiryTime && cookie.credentials[this.userHeaderName];
  }
  handleUnauthedRequest(request, response, toolkit) {
    var _this$config$proxycac5;
    const loginEndpoint = (_this$config$proxycac5 = this.config.proxycache) === null || _this$config$proxycac5 === void 0 ? void 0 : _this$config$proxycac5.login_endpoint;
    if (loginEndpoint) {
      return toolkit.redirected({
        location: loginEndpoint
      });
    } else {
      return toolkit.notHandled(); // TODO: redirect to error page?
    }
  }

  buildAuthHeaderFromCookie(cookie) {
    const authHeaders = {};
    if ((0, _lodash.get)(cookie.credentials, this.userHeaderName)) {
      authHeaders[this.userHeaderName] = cookie.credentials[this.userHeaderName];
      if ((0, _lodash.get)(cookie.credentials, this.roleHeaderName)) {
        authHeaders[this.roleHeaderName] = cookie.credentials[this.roleHeaderName];
      }
      if ((0, _lodash.get)(cookie.credentials, ProxyAuthentication.XFF)) {
        authHeaders[ProxyAuthentication.XFF] = cookie.credentials[ProxyAuthentication.XFF];
      }
      return authHeaders;
    } else if ((0, _lodash.get)(cookie.credentials, 'authorization')) {
      authHeaders.authorization = (0, _lodash.get)(cookie.credentials, 'authorization');
      return authHeaders;
    }
  }
}
exports.ProxyAuthentication = ProxyAuthentication;
_defineProperty(ProxyAuthentication, "XFF", 'x-forwarded-for');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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