# 
# acl_clock_crossing_bridge "ACL AVMM Clock Crossing Bridge" v1.0
#  2018.10.01.00:00:00
# This hw.tcl was derived from acl_hyper_optimized_ccb_hw.tcl
# 

# 
# request TCL package from ACDS 17.0
# 
package require -exact qsys 17.0

# 
# module acl_clock_crossing_bridge
# 
set_module_property DESCRIPTION ""
set_module_property NAME acl_clock_crossing_bridge
set_module_property VERSION 1.0
set_module_property INTERNAL false
set_module_property OPAQUE_ADDRESS_MAP true
set_module_property AUTHOR ""
set_module_property DISPLAY_NAME "ACL AVMM Clock Crossing Bridge"
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property REPORT_TO_TALKBACK false
set_module_property ALLOW_GREYBOX_GENERATION false
set_module_property REPORT_HIERARCHY false


# 
# file sets
# 
add_fileset QUARTUS_SYNTH QUARTUS_SYNTH "" ""
set_fileset_property QUARTUS_SYNTH TOP_LEVEL acl_clock_crossing_bridge
set_fileset_property QUARTUS_SYNTH ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property QUARTUS_SYNTH ENABLE_FILE_OVERWRITE_MODE false

add_fileset_file acl_clock_crossing_bridge.sv               SYSTEM_VERILOG PATH     acl_clock_crossing_bridge.sv
add_fileset_file acl_dcfifo.sv                              SYSTEM_VERILOG PATH     acl_dcfifo.sv
add_fileset_file acl_reset_handler.sv                       SYSTEM_VERILOG PATH     ../../acl_reset_handler.sv
add_fileset_file acl_parameter_assert.svh                   SYSTEM_VERILOG PATH     ../../acl_parameter_assert.svh
add_fileset_file acl_width_clip.svh                         SYSTEM_VERILOG PATH     ../../acl_width_clip.svh

add_fileset SIM_VERILOG SIM_VERILOG "" ""
set_fileset_property SIM_VERILOG TOP_LEVEL acl_clock_crossing_bridge
set_fileset_property SIM_VERILOG ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property SIM_VERILOG ENABLE_FILE_OVERWRITE_MODE false

add_fileset_file acl_clock_crossing_bridge.sv               SYSTEM_VERILOG PATH     acl_clock_crossing_bridge.sv
add_fileset_file acl_dcfifo.sv                              SYSTEM_VERILOG PATH     acl_dcfifo.sv
add_fileset_file acl_reset_handler.sv                       SYSTEM_VERILOG PATH     ../../acl_reset_handler.sv
add_fileset_file acl_parameter_assert.svh                   SYSTEM_VERILOG PATH     ../../acl_parameter_assert.svh
add_fileset_file acl_width_clip.svh                         SYSTEM_VERILOG PATH     ../../acl_width_clip.svh

# 
# parameters
# 
add_parameter ADDRESS_WIDTH INTEGER 32
set_parameter_property ADDRESS_WIDTH DEFAULT_VALUE 32
set_parameter_property ADDRESS_WIDTH DISPLAY_NAME "Address width"
set_parameter_property ADDRESS_WIDTH TYPE INTEGER
set_parameter_property ADDRESS_WIDTH UNITS None
set_parameter_property ADDRESS_WIDTH HDL_PARAMETER true
set_parameter_property ADDRESS_WIDTH AFFECTS_ELABORATION true

add_parameter DATA_WIDTH INTEGER 32
set_parameter_property DATA_WIDTH DEFAULT_VALUE 32
set_parameter_property DATA_WIDTH DISPLAY_NAME "Data width"
set_parameter_property DATA_WIDTH TYPE INTEGER
set_parameter_property DATA_WIDTH UNITS None
set_parameter_property DATA_WIDTH HDL_PARAMETER false
set_parameter_property DATA_WIDTH AFFECTS_ELABORATION true

add_parameter BURSTCOUNT_WIDTH INTEGER 5
set_parameter_property BURSTCOUNT_WIDTH DEFAULT_VALUE 5
set_parameter_property BURSTCOUNT_WIDTH DISPLAY_NAME "Burstcount width"
set_parameter_property BURSTCOUNT_WIDTH TYPE INTEGER
set_parameter_property BURSTCOUNT_WIDTH UNITS None
set_parameter_property BURSTCOUNT_WIDTH HDL_PARAMETER true
set_parameter_property BURSTCOUNT_WIDTH AFFECTS_ELABORATION true

add_parameter BYTEENABLE_WIDTH INTEGER 64
set_parameter_property BYTEENABLE_WIDTH DEFAULT_VALUE 64
set_parameter_property BYTEENABLE_WIDTH DISPLAY_NAME "Byteenable width"
set_parameter_property BYTEENABLE_WIDTH TYPE INTEGER
set_parameter_property BYTEENABLE_WIDTH UNITS None
set_parameter_property BYTEENABLE_WIDTH HDL_PARAMETER true
set_parameter_property BYTEENABLE_WIDTH AFFECTS_ELABORATION true

add_parameter CMD_DCFIFO_MIN_DEPTH INTEGER 32
set_parameter_property CMD_DCFIFO_MIN_DEPTH DEFAULT_VALUE 32
set_parameter_property CMD_DCFIFO_MIN_DEPTH DISPLAY_NAME "Command DCFIFO depth"
set_parameter_property CMD_DCFIFO_MIN_DEPTH TYPE INTEGER
set_parameter_property CMD_DCFIFO_MIN_DEPTH UNITS None
set_parameter_property CMD_DCFIFO_MIN_DEPTH HDL_PARAMETER true
set_parameter_property CMD_DCFIFO_MIN_DEPTH AFFECTS_ELABORATION true

add_parameter RSP_DCFIFO_MIN_DEPTH INTEGER 512
set_parameter_property RSP_DCFIFO_MIN_DEPTH DEFAULT_VALUE 512
set_parameter_property RSP_DCFIFO_MIN_DEPTH DISPLAY_NAME "Response DCFIFO depth"
set_parameter_property RSP_DCFIFO_MIN_DEPTH TYPE INTEGER
set_parameter_property RSP_DCFIFO_MIN_DEPTH UNITS None
set_parameter_property RSP_DCFIFO_MIN_DEPTH HDL_PARAMETER true
set_parameter_property RSP_DCFIFO_MIN_DEPTH AFFECTS_ELABORATION true

add_parameter SLAVE_STALL_LATENCY INTEGER 0
set_parameter_property SLAVE_STALL_LATENCY DEFAULT_VALUE 0
set_parameter_property SLAVE_STALL_LATENCY DISPLAY_NAME "Slave port waitrequest allowance"
set_parameter_property SLAVE_STALL_LATENCY TYPE INTEGER
set_parameter_property SLAVE_STALL_LATENCY UNITS None
set_parameter_property SLAVE_STALL_LATENCY HDL_PARAMETER true
set_parameter_property SLAVE_STALL_LATENCY AFFECTS_ELABORATION true

add_parameter MASTER_STALL_LATENCY INTEGER 0
set_parameter_property MASTER_STALL_LATENCY DEFAULT_VALUE 0
set_parameter_property MASTER_STALL_LATENCY DISPLAY_NAME "Master port waitrequest allowance"
set_parameter_property MASTER_STALL_LATENCY TYPE INTEGER
set_parameter_property MASTER_STALL_LATENCY UNITS None
set_parameter_property MASTER_STALL_LATENCY HDL_PARAMETER true
set_parameter_property MASTER_STALL_LATENCY AFFECTS_ELABORATION true

add_parameter USE_WRITE_ACK INTEGER 0
set_parameter_property USE_WRITE_ACK DEFAULT_VALUE 0
set_parameter_property USE_WRITE_ACK DISPLAY_NAME "Use write acknowledge, intended only for AXI on HBM"
set_parameter_property USE_WRITE_ACK TYPE INTEGER
set_parameter_property USE_WRITE_ACK UNITS None
set_parameter_property USE_WRITE_ACK HDL_PARAMETER true
set_parameter_property USE_WRITE_ACK AFFECTS_ELABORATION true

# 
# connection point slave_clk
# 
add_interface slave_clk clock end
set_interface_property slave_clk clockRate 0
set_interface_property slave_clk ENABLED true
set_interface_property slave_clk EXPORT_OF ""
set_interface_property slave_clk PORT_NAME_MAP ""
set_interface_property slave_clk CMSIS_SVD_VARIABLES ""
set_interface_property slave_clk SVD_ADDRESS_GROUP ""

add_interface_port slave_clk s_clock clk Input 1

# 
# connection point slave
# 
add_interface slave avalon end
set_interface_property slave addressUnits SYMBOLS
set_interface_property slave associatedClock slave_clk
set_interface_property slave associatedReset master_reset
set_interface_property slave bitsPerSymbol 8
set_interface_property slave bridgedAddressOffset ""
set_interface_property slave bridgesToMaster "master"
set_interface_property slave burstOnBurstBoundariesOnly false
set_interface_property slave burstcountUnits WORDS
set_interface_property slave explicitAddressSpan 0
set_interface_property slave holdTime 0
set_interface_property slave linewrapBursts false
set_interface_property slave maximumPendingReadTransactions 64
set_interface_property slave maximumPendingWriteTransactions 0
set_interface_property slave minimumResponseLatency 6
set_interface_property slave readLatency 0
set_interface_property slave readWaitTime 0
set_interface_property slave setupTime 0
set_interface_property slave timingUnits Cycles
set_interface_property slave transparentBridge false
set_interface_property slave waitrequestAllowance 0
set_interface_property slave writeWaitTime 0
set_interface_property slave ENABLED true
set_interface_property slave EXPORT_OF ""
set_interface_property slave PORT_NAME_MAP ""
set_interface_property slave CMSIS_SVD_VARIABLES ""
set_interface_property slave SVD_ADDRESS_GROUP ""

add_interface_port slave s_read read Input 1
add_interface_port slave s_write write Input 1
add_interface_port slave s_address address Input ADDRESS_WIDTH
add_interface_port slave s_burstcount burstcount Input BURSTCOUNT_WIDTH
add_interface_port slave s_byteenable byteenable Input BYTEENABLE_WIDTH
add_interface_port slave s_writedata writedata Input DATA_WIDTH
add_interface_port slave s_waitrequest waitrequest Output 1
add_interface_port slave s_readdatavalid readdatavalid Output 1
add_interface_port slave s_readdata readdata Output DATA_WIDTH

set_interface_assignment slave embeddedsw.configuration.isFlash 0
set_interface_assignment slave embeddedsw.configuration.isMemoryDevice 0
set_interface_assignment slave embeddedsw.configuration.isNonVolatileStorage 0
set_interface_assignment slave embeddedsw.configuration.isPrintableDevice 0

# 
# connection point slave_writeack -- this write ack is not avalon conformant, expose it separately
# 
add_interface slave_writeack conduit start
set_interface_property slave_writeack ENABLED true
set_interface_property slave_writeack associatedClock slave_clk
set_interface_property slave_writeack associatedReset ""
add_interface_port slave_writeack s_writeack writeack Output 1

# 
# connection point master_clk
# 
add_interface master_clk clock end
set_interface_property master_clk clockRate 0
set_interface_property master_clk ENABLED true
set_interface_property master_clk EXPORT_OF ""
set_interface_property master_clk PORT_NAME_MAP ""
set_interface_property master_clk CMSIS_SVD_VARIABLES ""
set_interface_property master_clk SVD_ADDRESS_GROUP ""

add_interface_port master_clk m_clock clk Input 1

# 
# connection point master_reset
# 
add_interface master_reset reset end
set_interface_property master_reset associatedClock ""
set_interface_property master_reset synchronousEdges NONE
set_interface_property master_reset ENABLED true
set_interface_property master_reset EXPORT_OF ""
set_interface_property master_reset PORT_NAME_MAP ""
set_interface_property master_reset CMSIS_SVD_VARIABLES ""
set_interface_property master_reset SVD_ADDRESS_GROUP ""

add_interface_port master_reset async_resetn reset_n Input 1

# 
# connection point master
# 
add_interface master avalon start
set_interface_property master addressUnits SYMBOLS
set_interface_property master associatedClock master_clk
set_interface_property master associatedReset master_reset
set_interface_property master bitsPerSymbol 8
set_interface_property master burstOnBurstBoundariesOnly false
set_interface_property master burstcountUnits WORDS
set_interface_property master doStreamReads false
set_interface_property master doStreamWrites false
set_interface_property master holdTime 0
set_interface_property master linewrapBursts false
set_interface_property master maximumPendingReadTransactions 64
set_interface_property master maximumPendingWriteTransactions 0
set_interface_property master minimumResponseLatency 1
set_interface_property master readLatency 0
set_interface_property master readWaitTime 0
set_interface_property master setupTime 0
set_interface_property master timingUnits Cycles
set_interface_property master waitrequestAllowance 0
set_interface_property master writeWaitTime 0
set_interface_property master ENABLED true
set_interface_property master EXPORT_OF ""
set_interface_property master PORT_NAME_MAP ""
set_interface_property master CMSIS_SVD_VARIABLES ""
set_interface_property master SVD_ADDRESS_GROUP ""

add_interface_port master m_read read Output 1
add_interface_port master m_write write Output 1
add_interface_port master m_address address Output ADDRESS_WIDTH
add_interface_port master m_burstcount burstcount Output BURSTCOUNT_WIDTH
add_interface_port master m_byteenable byteenable Output BYTEENABLE_WIDTH
add_interface_port master m_writedata writedata Output DATA_WIDTH
add_interface_port master m_waitrequest waitrequest Input 1
add_interface_port master m_readdatavalid readdatavalid Input 1
add_interface_port master m_readdata readdata Input DATA_WIDTH

# 
# connection point master_writeack -- this write ack is not avalon conformant, expose it separately
# 
add_interface master_writeack conduit end
set_interface_property master_writeack ENABLED true
set_interface_property master_writeack associatedClock master_clk
set_interface_property master_writeack associatedReset ""
add_interface_port master_writeack m_writeack writeack Input 1
