/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.protege.editor.core.ui.renderer.HasUseSystemForeground;
import org.protege.editor.owl.ui.renderer.EntityActionIcon;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;

public class DeleteEntityIcon
implements Icon,
HasUseSystemForeground {
    private final OWLEntityIcon entityIcon;

    public DeleteEntityIcon(OWLEntityIcon entityIcon) {
        this.entityIcon = entityIcon;
    }

    public DeleteEntityIcon useSystemForeground() {
        this.entityIcon.setOverriderColorToForegroundColor();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        EntityActionIcon.setupState(c, g2, this.entityIcon);
        try {
            int halfWidth = this.getIconWidth() / 2;
            int xC = halfWidth + x;
            int halfHeight = this.getIconHeight() / 2;
            int yC = halfHeight + y;
            this.entityIcon.paintIcon(c, g2, xC - this.entityIcon.getIconWidth() / 2, yC - this.entityIcon.getIconHeight() / 2);
            g2.setStroke(EntityActionIcon.ACTION_STROKE);
            g2.setColor(this.entityIcon.getColor());
            int crossLegLen = 7;
            g2.drawLine(xC - crossLegLen, yC - crossLegLen, xC + crossLegLen, yC + crossLegLen);
            g2.drawLine(xC - crossLegLen, yC + crossLegLen, xC + crossLegLen, yC - crossLegLen);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return this.entityIcon.getIconWidth() + 2;
    }

    @Override
    public int getIconHeight() {
        return this.entityIcon.getIconHeight() + 2;
    }
}

