/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.extensions.action.ExtensionProxyAction;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.DocumentMissingException;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.jobscheduler.ScheduledJobProvider;
import org.opensearch.jobscheduler.model.ExtensionJobParameter;
import org.opensearch.jobscheduler.model.JobDetails;
import org.opensearch.jobscheduler.spi.JobDocVersion;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.transport.request.ExtensionJobActionRequest;
import org.opensearch.jobscheduler.transport.request.JobParameterRequest;
import org.opensearch.jobscheduler.transport.request.JobRunnerRequest;
import org.opensearch.jobscheduler.transport.response.JobParameterResponse;
import org.opensearch.jobscheduler.transport.response.JobRunnerResponse;
import org.opensearch.jobscheduler.utils.VisibleForTesting;

public class JobDetailsService
implements IndexingOperationListener {
    private static final Logger logger = LogManager.getLogger(JobDetailsService.class);
    public static final String JOB_DETAILS_INDEX_NAME = ".opensearch-job-scheduler-job-details";
    private static final String PLUGINS_JOB_DETAILS_MAPPING_FILE = "/mappings/opensearch_job_scheduler_job_details.json";
    public static Long TIME_OUT_FOR_REQUEST = 15L;
    private final Client client;
    private final ClusterService clusterService;
    private Set<String> indicesToListen;
    private Map<String, ScheduledJobProvider> indexToJobProviders;
    private static final ConcurrentMap<String, JobDetails> indexToJobDetails = IndexToJobDetails.getInstance();

    public JobDetailsService(Client client, ClusterService clusterService, Set<String> indicesToListen, Map<String, ScheduledJobProvider> indexToJobProviders) {
        this.client = client;
        this.clusterService = clusterService;
        this.indicesToListen = indicesToListen;
        this.indexToJobProviders = indexToJobProviders;
    }

    public static ConcurrentMap<String, JobDetails> getIndexToJobDetails() {
        return indexToJobDetails;
    }

    public Map<String, ScheduledJobProvider> getIndexToJobProviders() {
        return this.indexToJobProviders;
    }

    public boolean jobDetailsIndexExist() {
        return this.clusterService.state().routingTable().hasIndex(JOB_DETAILS_INDEX_NAME);
    }

    private void updateIndicesToListen(String jobIndexName) {
        this.indicesToListen.add(jobIndexName);
    }

    void updateIndexToJobProviders(String documentId, JobDetails jobDetails) {
        String extensionJobIndex = jobDetails.getJobIndex();
        String extensionJobType = jobDetails.getJobType();
        String extensionUniqueId = jobDetails.getExtensionUniqueId();
        ScheduledJobParser extensionJobParser = this.createProxyScheduledJobParser(extensionUniqueId, jobDetails.getJobParameterAction());
        ScheduledJobRunner extensionJobRunner = this.createProxyScheduledJobRunner(documentId, extensionUniqueId, jobDetails.getJobRunnerAction());
        this.indexToJobProviders.put(extensionJobIndex, new ScheduledJobProvider(extensionJobType, extensionJobIndex, extensionJobParser, extensionJobRunner));
    }

    void updateIndexToJobDetails(String documentId, JobDetails jobDetails) {
        indexToJobDetails.put(documentId, jobDetails);
        this.updateIndicesToListen(jobDetails.getJobIndex());
        this.updateIndexToJobProviders(documentId, jobDetails);
    }

    private ScheduledJobParser createProxyScheduledJobParser(final String extensionUniqueId, final String extensionJobParameterAction) {
        return new ScheduledJobParser(){

            public ScheduledJobParameter parse(XContentParser xContentParser, String id, JobDocVersion jobDocVersion) throws IOException {
                logger.info("Sending ScheduledJobParameter parse request to extension : " + extensionUniqueId);
                ExtensionJobParameter[] extensionJobParameterHolder = new ExtensionJobParameter[1];
                CompletableFuture inProgressFuture = new CompletableFuture();
                JobParameterRequest jobParamRequest = new JobParameterRequest("placeholder", xContentParser, id, jobDocVersion);
                JobDetailsService.this.client.execute((ActionType)ExtensionProxyAction.INSTANCE, new ExtensionJobActionRequest<JobParameterRequest>(extensionJobParameterAction, jobParamRequest), ActionListener.wrap(response -> {
                    JobParameterResponse jobParameterResponse = new JobParameterResponse(response.getResponseBytes());
                    extensionJobParameterHolder[0] = jobParameterResponse.getJobParameter();
                    inProgressFuture.complete(extensionJobParameterHolder);
                }, exception -> {
                    logger.error("Could not parse job parameter", (Throwable)exception);
                    inProgressFuture.completeExceptionally((Throwable)exception);
                }));
                try {
                    inProgressFuture.orTimeout(TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS).join();
                }
                catch (CompletionException e) {
                    if (e.getCause() instanceof TimeoutException) {
                        logger.error("Request timed out with an exception ", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not parse ScheduledJobParameter due to exception ", (Throwable)e);
                }
                return extensionJobParameterHolder[0];
            }
        };
    }

    private ScheduledJobRunner createProxyScheduledJobRunner(final String documentId, final String extensionUniqueId, final String extensionJobRunnerAction) {
        return new ScheduledJobRunner(){

            public void runJob(ScheduledJobParameter jobParameter, JobExecutionContext context) {
                logger.info("Sending ScheduledJobRunner runJob request to extension : " + extensionUniqueId);
                Boolean[] extensionJobRunnerStatus = new Boolean[1];
                CompletableFuture inProgressFuture = new CompletableFuture();
                try {
                    JobRunnerRequest jobRunnerRequest = new JobRunnerRequest("placeholder", documentId, context);
                    JobDetailsService.this.client.execute((ActionType)ExtensionProxyAction.INSTANCE, new ExtensionJobActionRequest<JobRunnerRequest>(extensionJobRunnerAction, jobRunnerRequest), ActionListener.wrap(response -> {
                        JobRunnerResponse jobRunnerResponse = new JobRunnerResponse(response.getResponseBytes());
                        extensionJobRunnerStatus[0] = jobRunnerResponse.getJobRunnerStatus();
                        inProgressFuture.complete(extensionJobRunnerStatus);
                    }, exception -> {
                        logger.error("Failed to run job due to exception ", (Throwable)exception);
                        inProgressFuture.completeExceptionally((Throwable)exception);
                    }));
                    inProgressFuture.orTimeout(TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS).join();
                }
                catch (IOException e) {
                    logger.error("Failed to create JobRunnerRequest", (Throwable)e);
                }
                catch (CompletionException e) {
                    if (e.getCause() instanceof TimeoutException) {
                        logger.error("Request timed out with an exception ", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not run extension job due to exception ", (Throwable)e);
                }
                logger.info("Job Runner Status for extension " + extensionUniqueId + " : " + extensionJobRunnerStatus[0]);
            }
        };
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        if (result.getResultType().equals((Object)Engine.Result.Type.FAILURE)) {
            logger.info("Job Details Registration failed for extension {} on index {}", (Object)index.id(), (Object)shardId.getIndexName());
            return;
        }
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, index.source().utf8ToString());
            parser.nextToken();
            this.updateIndexToJobDetails(index.id(), JobDetails.parse(parser));
        }
        catch (IOException e) {
            logger.error("IOException occurred creating job details for extension id " + index.id(), (Throwable)e);
        }
    }

    @VisibleForTesting
    void createJobDetailsIndex(ActionListener<Boolean> listener) {
        if (this.jobDetailsIndexExist()) {
            listener.onResponse((Object)true);
        } else {
            CreateIndexRequest request = new CreateIndexRequest(JOB_DETAILS_INDEX_NAME).mapping(this.jobDetailsMapping());
            this.client.admin().indices().create(request, ActionListener.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), exception -> {
                if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) {
                    listener.onResponse((Object)true);
                } else {
                    listener.onFailure(exception);
                }
            }));
        }
    }

    public void processJobDetails(String documentId, String jobIndexName, String jobTypeName, String jobParameterActionName, String jobRunnerActionName, String extensionUniqueId, ActionListener<String> listener) {
        if (jobIndexName == null || jobIndexName.isEmpty() || jobTypeName == null || jobTypeName.isEmpty() || jobParameterActionName == null || jobParameterActionName.isEmpty() || jobRunnerActionName == null || jobRunnerActionName.isEmpty() || extensionUniqueId == null || extensionUniqueId.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("JobIndexName, JobTypeName, JobParameterActionName, JobRunnerActionName, Extension Unique Id must not be null or empty"));
        } else {
            this.createJobDetailsIndex((ActionListener<Boolean>)ActionListener.wrap(created -> {
                block5: {
                    if (created.booleanValue()) {
                        try {
                            if (documentId != null) {
                                this.findJobDetails(documentId, (ActionListener<JobDetails>)ActionListener.wrap(existingJobDetails -> {
                                    JobDetails updateJobDetails = new JobDetails((JobDetails)existingJobDetails);
                                    updateJobDetails.setJobIndex(jobIndexName);
                                    updateJobDetails.setJobType(jobTypeName);
                                    updateJobDetails.setJobParameterAction(jobParameterActionName);
                                    updateJobDetails.setJobRunnerAction(jobRunnerActionName);
                                    this.updateJobDetails(documentId, updateJobDetails, listener);
                                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                                break block5;
                            }
                            JobDetails tempJobDetails = new JobDetails(jobIndexName, jobTypeName, jobParameterActionName, jobRunnerActionName, extensionUniqueId);
                            logger.info("Creating job details for extension unique id " + extensionUniqueId + " : " + tempJobDetails.toString());
                            this.createJobDetails(tempJobDetails, listener);
                        }
                        catch (VersionConflictEngineException e) {
                            logger.debug("could not process job index for extensionUniqueId " + extensionUniqueId, (Object)e.getMessage());
                            listener.onResponse(null);
                        }
                    } else {
                        listener.onResponse(null);
                    }
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void createJobDetails(JobDetails tempJobDetails, ActionListener<String> listener) {
        try {
            IndexRequest request = new IndexRequest(JOB_DETAILS_INDEX_NAME).source(tempJobDetails.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setIfSeqNo(-2L).setIfPrimaryTerm(0L).create(true);
            this.client.index(request, ActionListener.wrap(response -> listener.onResponse((Object)response.getId()), exception -> {
                if (exception instanceof IOException) {
                    logger.error("IOException occurred creating job details", (Throwable)exception);
                }
                listener.onResponse(null);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred creating job details", (Throwable)e);
            listener.onResponse(null);
        }
    }

    private void findJobDetails(String documentId, ActionListener<JobDetails> listener) {
        GetRequest getRequest = new GetRequest(JOB_DETAILS_INDEX_NAME).id(documentId);
        this.client.get(getRequest, ActionListener.wrap(response -> {
            if (!response.isExists()) {
                listener.onResponse(null);
            } else {
                try {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
                    parser.nextToken();
                    listener.onResponse((Object)JobDetails.parse(parser));
                }
                catch (IOException e) {
                    logger.error("IOException occurred finding JobDetails for documentId " + documentId, (Throwable)e);
                    listener.onResponse(null);
                }
            }
        }, exception -> {
            logger.error("Exception occurred finding job details for documentId " + documentId, (Throwable)exception);
            listener.onFailure(exception);
        }));
    }

    public void deleteJobDetails(String documentId, ActionListener<Boolean> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(JOB_DETAILS_INDEX_NAME).id(documentId);
        this.client.delete(deleteRequest, ActionListener.wrap(response -> listener.onResponse((Object)(response.getResult() == DocWriteResponse.Result.DELETED || response.getResult() == DocWriteResponse.Result.NOT_FOUND ? 1 : 0)), exception -> {
            if (exception instanceof IndexNotFoundException || exception.getCause() instanceof IndexNotFoundException) {
                logger.debug("Index is not found to delete job details for document id. {} " + documentId, (Object)exception.getMessage());
                listener.onResponse((Object)true);
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    private void updateJobDetails(String documentId, JobDetails updateJobDetails, ActionListener<String> listener) {
        try {
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(JOB_DETAILS_INDEX_NAME)).id(documentId).doc(updateJobDetails.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).fetchSource(true);
            this.client.update(updateRequest, ActionListener.wrap(response -> listener.onResponse((Object)response.getId()), exception -> {
                if (exception instanceof VersionConflictEngineException) {
                    logger.debug("could not update job details for documentId " + documentId, (Object)exception.getMessage());
                }
                if (exception instanceof DocumentMissingException) {
                    logger.debug("Document is deleted. This happens if the job details is already removed {}", (Object)exception.getMessage());
                }
                if (exception instanceof IOException) {
                    logger.error("IOException occurred in updating job details.", (Throwable)exception);
                }
                listener.onResponse(null);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred updating job details for documentId " + documentId, (Throwable)e);
            listener.onResponse(null);
        }
    }

    private String jobDetailsMapping() {
        try {
            String line;
            InputStream in = JobDetailsService.class.getResourceAsStream(PLUGINS_JOB_DETAILS_MAPPING_FILE);
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JobDetails Mapping cannot be read correctly.");
        }
    }

    private static class IndexToJobDetails {
        private static final ConcurrentMap<String, JobDetails> indexToJobDetails = new ConcurrentHashMap<String, JobDetails>();

        private IndexToJobDetails() {
        }

        public static ConcurrentMap<String, JobDetails> getInstance() {
            return indexToJobDetails;
        }
    }
}

