/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.destination.message;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyDestinationType;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class LegacyCustomWebhookMessage
extends LegacyBaseMessage {
    private final String message;
    private final String url;
    private final String scheme;
    private final String host;
    private final String method;
    private final int port;
    private String path;
    private final Map<String, String> queryParams;
    private Map<String, String> headerParams;

    private LegacyCustomWebhookMessage(String destinationName, String url, String scheme, String host, Integer port, String path, String method, Map<String, String> queryParams, Map<String, String> headerParams, String message) {
        super(LegacyDestinationType.LEGACY_CUSTOM_WEBHOOK, destinationName, message);
        if (!Strings.isNullOrEmpty((String)url)) {
            this.setUrl(url.trim());
        }
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        this.scheme = Strings.isNullOrEmpty((String)scheme) ? "https" : scheme;
        int n = this.port = port == null ? -1 : port;
        if (!Strings.isNullOrEmpty((String)path) && !path.startsWith("/")) {
            this.path = "/" + path;
        }
        if (Strings.isNullOrEmpty((String)url) && Strings.isNullOrEmpty((String)host)) {
            throw new IllegalArgumentException("Either fully qualified URL or host name should be provided");
        }
        if (Strings.isNullOrEmpty((String)method)) {
            this.method = "POST";
        } else {
            if (!("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method))) {
                throw new IllegalArgumentException("Invalid method supplied. Only POST, PUT and PATCH are allowed");
            }
            this.method = method;
        }
        this.message = message;
        this.url = url;
        this.host = host;
        this.queryParams = queryParams;
        this.headerParams = headerParams;
    }

    public LegacyCustomWebhookMessage(StreamInput streamInput) throws IOException {
        super(streamInput);
        this.message = super.getMessageContent();
        this.url = streamInput.readOptionalString();
        this.scheme = null;
        this.host = null;
        this.method = streamInput.readOptionalString();
        this.port = -1;
        this.path = null;
        this.queryParams = null;
        if (streamInput.readBoolean()) {
            Map headerParams;
            this.headerParams = headerParams = streamInput.readMap();
        }
    }

    public String toString() {
        return "DestinationType: " + this.getChannelType() + ", DestinationName:" + this.destinationName + ", Url: " + this.url + ", scheme: " + this.scheme + ", Host: " + this.host + ", Port: " + this.port + ", Path: " + this.path + ", Method: " + this.method + ", Message: <...>";
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    @Override
    public URI getUri() {
        return this.buildUri(this.getUrl(), this.getScheme(), this.getHost(), this.getPort(), this.getPath(), this.getQueryParams());
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        if (Strings.isNullOrEmpty((String)this.getUrl())) {
            throw new IllegalStateException("Cannot use LegacyCustomWebhookMessage across transport wire without defining full url.");
        }
        streamOutput.writeOptionalString(this.url);
        streamOutput.writeOptionalString(this.method);
        streamOutput.writeBoolean(this.headerParams != null);
        if (this.headerParams != null) {
            Map<String, String> headerParams = this.headerParams;
            streamOutput.writeMap(headerParams);
        }
    }

    public static class Builder {
        private String message;
        private final String destinationName;
        private String url;
        private String scheme;
        private String host;
        private Integer port;
        private String path;
        private String method;
        private Map<String, String> queryParams;
        private Map<String, String> headerParams;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
        }

        public Builder withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withQueryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder withHeaderParams(Map<String, String> headerParams) {
            this.headerParams = headerParams;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public LegacyCustomWebhookMessage build() {
            return new LegacyCustomWebhookMessage(this.destinationName, this.url, this.scheme, this.host, this.port, this.path, this.method, this.queryParams, this.headerParams, this.message);
        }
    }
}

