"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerAlertingRoutes = registerAlertingRoutes;
var _lodash = require("lodash");
var _constants = require("../utils/constants");
var _adHelpers = require("./utils/adHelpers");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ //@ts-ignore
function registerAlertingRoutes(apiRouter, alertingService) {
  apiRouter.post('/monitors/_search', alertingService.searchMonitors);
  apiRouter.get('/monitors/alerts', alertingService.searchAlerts);
}
class AlertingService {
  constructor(client) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "searchMonitors", async (context, request, opensearchDashboardsResponse) => {
      try {
        const requestBody = {
          size: _constants.MAX_MONITORS,
          query: {
            nested: {
              path: 'monitor.inputs',
              query: {
                bool: {
                  should: [{
                    term: {
                      'monitor.inputs.search.indices.keyword': {
                        value: '.opendistro-anomaly-results*'
                      }
                    }
                  }, {
                    match_phrase_prefix: {
                      'monitor.inputs.search.indices': 'opensearch-ad-plugin-result-'
                    }
                  }]
                }
              }
            }
          }
        };
        const response = await this.client.asScoped(request).callAsCurrentUser('alerting.searchMonitors', {
          body: requestBody
        });
        const totalMonitors = (0, _lodash.get)(response, 'hits.total.value', 0);
        const allMonitors = (0, _lodash.get)(response, 'hits.hits', []).reduce((acc, monitor) => ({
          ...acc,
          [monitor._id]: {
            id: monitor._id,
            name: (0, _lodash.get)(monitor, '_source.name'),
            enabled: (0, _lodash.get)(monitor, '_source.enabled', false),
            enabledTime: (0, _lodash.get)(monitor, '_source.enabled_time'),
            schedule: (0, _lodash.get)(monitor, '_source.schedule'),
            inputs: (0, _lodash.get)(monitor, '_source.inputs'),
            triggers: (0, _lodash.get)(monitor, '_source.triggers'),
            lastUpdateTime: (0, _lodash.get)(monitor, '_source.last_update_time')
          }
        }), {});
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response: {
              totalMonitors,
              monitors: Object.values(allMonitors)
            }
          }
        });
      } catch (err) {
        console.log('Unable to get monitor on top of detector', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    _defineProperty(this, "searchAlerts", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          monitorId,
          startTime,
          endTime
        } = request.query;
        const response = await this.client.asScoped(request).callAsCurrentUser('alerting.searchAlerts', {
          monitorId: monitorId,
          startTime: startTime,
          endTime: endTime
        });
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response
          }
        });
      } catch (err) {
        console.log('Unable to search alerts', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    this.client = client;
  }
}
exports.default = AlertingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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