"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerSampleDataRoutes = registerSampleDataRoutes;
var _path = _interopRequireDefault(require("path"));
var _constants = require("../utils/constants");
var _helpers = require("../sampleData/utils/helpers");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ //@ts-ignore
function registerSampleDataRoutes(apiRouter, sampleDataService) {
  apiRouter.post('/create_sample_data/{type}', sampleDataService.createSampleData);
}
class SampleDataService {
  constructor(client) {
    _defineProperty(this, "client", void 0);
    // Get the zip file stored in server, unzip it, and bulk insert it
    _defineProperty(this, "createSampleData", async (context, request, opensearchDashboardsResponse) => {
      //@ts-ignore
      const type = request.params.type;
      try {
        let filePath = '';
        let indexName = '';
        switch (type) {
          case _constants.SAMPLE_TYPE.HTTP_RESPONSES:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/httpResponses.json.gz');
              indexName = 'sample-http-responses';
              break;
            }
          case _constants.SAMPLE_TYPE.ECOMMERCE:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/ecommerce.json.gz');
              indexName = 'sample-ecommerce';
              break;
            }
          case _constants.SAMPLE_TYPE.HOST_HEALTH:
            {
              filePath = _path.default.resolve(__dirname, '../sampleData/rawData/hostHealth.json.gz');
              indexName = 'sample-host-health';
              break;
            }
        }
        await (0, _helpers.loadSampleData)(filePath, indexName, this.client, request);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true
          }
        });
      } catch (err) {
        console.log('Anomaly detector - Unable to load the sample data', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    this.client = client;
  }
}
exports.default = SampleDataService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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