/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.collapse.CollapseBuilder;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.sql.legacy.domain.ColumnTypeProvider;
import org.opensearch.sql.legacy.domain.Query;
import org.opensearch.sql.legacy.domain.QueryStatement;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.domain.hints.Hint;
import org.opensearch.sql.legacy.domain.hints.HintType;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.Format;
import org.opensearch.sql.legacy.query.SqlElasticRequestBuilder;
import org.opensearch.sql.legacy.request.SqlRequest;

public abstract class QueryAction {
    protected Query query;
    protected Client client;
    protected SqlRequest sqlRequest = SqlRequest.NULL;
    protected ColumnTypeProvider scriptColumnType;
    protected Format format;

    public QueryAction(Client client, Query query) {
        this.client = client;
        this.query = query;
    }

    public Client getClient() {
        return this.client;
    }

    public QueryStatement getQueryStatement() {
        return this.query;
    }

    public void setSqlRequest(SqlRequest sqlRequest) {
        this.sqlRequest = sqlRequest;
    }

    public void setColumnTypeProvider(ColumnTypeProvider scriptColumnType) {
        this.scriptColumnType = scriptColumnType;
    }

    public SqlRequest getSqlRequest() {
        return this.sqlRequest;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public ColumnTypeProvider getScriptColumnType() {
        return this.scriptColumnType;
    }

    public Optional<List<String>> getFieldNames() {
        return Optional.empty();
    }

    protected void updateRequestWithCollapse(Select select, SearchRequestBuilder request) throws SqlParseException {
        JsonFactory jsonFactory = new JsonFactory();
        for (Hint hint : select.getHints()) {
            if (hint.getType() != HintType.COLLAPSE || hint.getParams() == null || 0 >= hint.getParams().length) continue;
            try (JsonXContentParser parser = new JsonXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonFactory.createParser(hint.getParams()[0].toString()));){
                request.setCollapse(CollapseBuilder.fromXContent((XContentParser)parser));
            }
            catch (IOException e) {
                throw new SqlParseException("could not parse collapse hint: " + e.getMessage());
            }
        }
    }

    protected void updateRequestWithPostFilter(Select select, SearchRequestBuilder request) {
        for (Hint hint : select.getHints()) {
            if (hint.getType() != HintType.POST_FILTER || hint.getParams() == null || 0 >= hint.getParams().length) continue;
            request.setPostFilter((QueryBuilder)QueryBuilders.wrapperQuery((String)hint.getParams()[0].toString()));
        }
    }

    protected void updateRequestWithIndexAndRoutingOptions(Select select, SearchRequestBuilder request) {
        for (Hint hint : select.getHints()) {
            if (hint.getType() == HintType.IGNORE_UNAVAILABLE) {
                request.setIndicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)true, (boolean)false, (IndicesOptions)IndicesOptions.strictExpandOpenAndForbidClosed()));
            }
            if (hint.getType() != HintType.ROUTINGS) continue;
            Object[] routings = hint.getParams();
            String[] routingsAsStringArray = new String[routings.length];
            for (int i = 0; i < routings.length; ++i) {
                routingsAsStringArray[i] = routings[i].toString();
            }
            request.setRouting(routingsAsStringArray);
        }
    }

    protected void updateRequestWithHighlight(Select select, SearchRequestBuilder request) {
        boolean foundAnyHighlights = false;
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (Hint hint : select.getHints()) {
            HighlightBuilder.Field highlightField;
            if (hint.getType() != HintType.HIGHLIGHT || (highlightField = this.parseHighlightField(hint.getParams())) == null) continue;
            foundAnyHighlights = true;
            highlightBuilder.field(highlightField);
        }
        if (foundAnyHighlights) {
            request.highlighter(highlightBuilder);
        }
    }

    protected HighlightBuilder.Field parseHighlightField(Object[] params) {
        if (params == null || params.length == 0 || params.length > 2) {
            // empty if block
        }
        HighlightBuilder.Field field = new HighlightBuilder.Field(params[0].toString());
        if (params.length == 1) {
            return field;
        }
        Map highlightParams = (Map)params[1];
        for (Map.Entry param : highlightParams.entrySet()) {
            switch ((String)param.getKey()) {
                case "type": {
                    field.highlighterType((String)param.getValue());
                    break;
                }
                case "boundary_chars": {
                    field.boundaryChars(this.fromArrayListToCharArray((ArrayList)param.getValue()));
                    break;
                }
                case "boundary_max_scan": {
                    field.boundaryMaxScan((Integer)param.getValue());
                    break;
                }
                case "force_source": {
                    field.forceSource((Boolean)param.getValue());
                    break;
                }
                case "fragmenter": {
                    field.fragmenter((String)param.getValue());
                    break;
                }
                case "fragment_offset": {
                    field.fragmentOffset(((Integer)param.getValue()).intValue());
                    break;
                }
                case "fragment_size": {
                    field.fragmentSize((Integer)param.getValue());
                    break;
                }
                case "highlight_filter": {
                    field.highlightFilter((Boolean)param.getValue());
                    break;
                }
                case "matched_fields": {
                    field.matchedFields(((ArrayList)param.getValue()).toArray(new String[0]));
                    break;
                }
                case "no_match_size": {
                    field.noMatchSize((Integer)param.getValue());
                    break;
                }
                case "num_of_fragments": {
                    field.numOfFragments((Integer)param.getValue());
                    break;
                }
                case "order": {
                    field.order((String)param.getValue());
                    break;
                }
                case "phrase_limit": {
                    field.phraseLimit((Integer)param.getValue());
                    break;
                }
                case "post_tags": {
                    field.postTags(((ArrayList)param.getValue()).toArray(new String[0]));
                    break;
                }
                case "pre_tags": {
                    field.preTags(((ArrayList)param.getValue()).toArray(new String[0]));
                    break;
                }
                case "require_field_match": {
                    field.requireFieldMatch((Boolean)param.getValue());
                }
            }
        }
        return field;
    }

    private char[] fromArrayListToCharArray(ArrayList arrayList) {
        char[] chars = new char[arrayList.size()];
        int i = 0;
        for (Object item : arrayList) {
            chars[i] = item.toString().charAt(0);
            ++i;
        }
        return chars;
    }

    public abstract SqlElasticRequestBuilder explain() throws SqlParseException;
}

