#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Sun Mar 20 12:32:25 2022 by generateDS.py version 2.40.9.
# Python 3.8.10 (default, Nov 26 2021, 20:14:08)  [GCC 9.3.0]
#
# Command line options:
#   ('-f', '')
#   ('-o', 'out/ipxact.py')
#   ('--user-methods', 'gends_user_methods.py')
#
# Command line arguments:
#   2014/index.xsd
#
# Command line:
#   /home/olof/.local/bin/generateDS -f -o "out/ipxact.py" --user-methods="gends_user_methods.py" 2014/index.xsd
#
# Current working directory (os.getcwd()):
#   ipxact_gen
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % float(input_data)).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class abstractorModeType(str, Enum):
    """abstractorModeType -- Mode for this abstractor
    
    """
    MASTER='master'
    SLAVE='slave'
    DIRECT='direct'
    SYSTEM='system'


class accessType_impl(str, Enum):
    """accessType_impl -- The read/write accessability of an addess block.
    
    """
    READONLY='read-only'
    WRITEONLY='write-only'
    READWRITE='read-write'
    WRITE_ONCE='writeOnce'
    READWRITE_ONCE='read-writeOnce'


class apiType(str, Enum):
    TGI__2009='TGI_2009'
    TGI__2014_BASE='TGI_2014_BASE'
    TGI__2014_EXTENDED='TGI_2014_EXTENDED'
    NONE='none'


class bankAlignmentType(str, Enum):
    """bankAlignmentType -- 'serial' or 'parallel' bank alignment.
    
    """
    SERIAL='serial'
    PARALLEL='parallel'


class cellClassValueType(str, Enum):
    """cellClassValueType -- Indicates legal cell class values.
    
    """
    COMBINATIONAL='combinational'
    SEQUENTIAL='sequential'


class cellFunctionValueType(str, Enum):
    """cellFunctionValueType -- Indicates legal cell function values.
    
    """
    NAND_2='nand2'
    BUF='buf'
    INV='inv'
    MUX_21='mux21'
    DFF='dff'
    LATCH='latch'
    XOR_2='xor2'
    OTHER='other'


class cellStrengthValueType(str, Enum):
    """cellStrengthValueType -- Indicates legal cell strength values.
    
    """
    LOW='low'
    MEDIAN='median'
    HIGH='high'


class componentPortDirectionType(str, Enum):
    """componentPortDirectionType -- The direction of a component port.
    
    """
    IN='in'
    OUT='out'
    INOUT='inout'
    PHANTOM='phantom'


class dataTypeType(str, Enum):
    """dataTypeType -- Enumerates C argument data types.
    
    """
    INT='int'
    UNSIGNEDINT='unsigned int'
    LONG='long'
    UNSIGNEDLONG='unsigned long'
    FLOAT='float'
    DOUBLE='double'
    CHAR='char *'
    VOID='void *'


class delayValueType(str, Enum):
    """delayValueType -- Indicates the type of delay value - minimum or maximum delay.
    
    """
    MIN='min'
    MAX='max'


class delayValueUnitType(str, Enum):
    """delayValueUnitType -- Indicates legal units for delay values.
    
    """
    PS='ps'
    NS='ns'


class direction(str, Enum):
    IN='in'
    OUT='out'
    INOUT='inout'


class driverTypeType(str, Enum):
    """driverTypeType -- Defines the type of driver that is required. The default is any type of driver. The 2 other options are a clock type driver or a singleshot type driver.
    
    """
    CLOCK='clock'
    SINGLE_SHOT='singleShot'
    ANY='any'


class edgeValueType(str, Enum):
    """edgeValueType -- Indicates legal values for edge specification attributes.
    
    """
    RISE='rise'
    FALL='fall'


class endianessType(str, Enum):
    """endianessType -- 'big': means the most significant element of any multi-element  data field is stored at the lowest memory address. 'little' means the least significant element of any multi-element data field is stored at the lowest memory address. If this element is not present the default is 'little' endian.
    
    """
    BIG='big'
    LITTLE='little'


class formatType(str, Enum):
    """formatType -- This is an indication on the format of the value. bit: 1-bit or more (vector) bits unsigned integer, byte: 8-bit signed integer, shortint: 16-bit signed integer, int: 32-bit signed integer, longint: 64-bit signed integer, shortreal: 32-bit signed floating point number, real: 64-bit signed floating point number, string: textual information.
    
    """
    BIT='bit'
    BYTE='byte'
    SHORTINT='shortint'
    INT='int'
    LONGINT='longint'
    SHORTREAL='shortreal'
    REAL='real'
    STRING='string'


class initiativeType34(str, Enum):
    """initiativeType34 -- If this element is present, the type of access is restricted to the specified value.
    
    """
    REQUIRES='requires'
    PROVIDES='provides'
    BOTH='both'


class initiativeType38(str, Enum):
    """initiativeType38 -- If this element is present, the type of access is restricted to the specified value.
    
    """
    REQUIRES='requires'
    PROVIDES='provides'
    BOTH='both'


class initiativeType40(str, Enum):
    """initiativeType40 -- If this element is present, the type of access is restricted to the specified value.
    
    """
    REQUIRES='requires'
    PROVIDES='provides'
    BOTH='both'


class initiativeType42(str, Enum):
    """initiativeType42 -- If this element is present, the type of access is restricted to the specified value.
    
    """
    REQUIRES='requires'
    PROVIDES='provides'
    BOTH='both'


class initiativeType_impl(str, Enum):
    REQUIRES='requires'
    PROVIDES='provides'
    BOTH='both'
    PHANTOM='phantom'


class interfaceModeType(str, Enum):
    MASTER='master'
    SLAVE='slave'
    SYSTEM='system'
    MIRRORED_MASTER='mirroredMaster'
    MIRRORED_SLAVE='mirroredSlave'
    MIRRORED_SYSTEM='mirroredSystem'


class interfaceModeType31(str, Enum):
    MASTER='master'
    SLAVE='slave'
    SYSTEM='system'
    MIRRORED_MASTER='mirroredMaster'
    MIRRORED_SLAVE='mirroredSlave'
    MIRRORED_SYSTEM='mirroredSystem'


class ipxactFileTypesEnum(str, Enum):
    BUS_DEFINITION='busDefinition'
    ABSTRACTION_DEFINITION='abstractionDefinition'
    COMPONENT='component'
    ABSTRACTOR='abstractor'
    DESIGN='design'
    DESIGN_CONFIG='designConfig'
    GENERATOR_CHAIN='generatorChain'
    CATALOG='catalog'


class kindType(str, Enum):
    TLM_PORT='tlm_port'
    TLM_SOCKET='tlm_socket'
    SIMPLE_SOCKET='simple_socket'
    MULTI_SOCKET='multi_socket'
    CUSTOM='custom'


class modelInstantiationType(str, Enum):
    MODULE='module'
    ENTITYARCHITECTURE='entity(architecture)'
    CONFIGURATION='configuration'


class modifiedWriteValueType(str, Enum):
    ONE_TO_CLEAR='oneToClear'
    ONE_TO_SET='oneToSet'
    ONE_TO_TOGGLE='oneToToggle'
    ZERO_TO_CLEAR='zeroToClear'
    ZERO_TO_SET='zeroToSet'
    ZERO_TO_TOGGLE='zeroToToggle'
    CLEAR='clear'
    SET='set'
    MODIFY='modify'


class multipleGroupSelectionOperatorType(str, Enum):
    """multipleGroupSelectionOperatorType -- Specifies the OR or AND selection operator if there is more than one group name.
    
    """
    AND='and'
    OR='or'


class prefixType(str, Enum):
    """prefixType -- Defines the prefix that precedes the unit of a value. The prefix is not applied to the value (e.g. in calculations).
    
    """
    DECA='deca'
    HECTO='hecto'
    KILO='kilo'
    MEGA='mega'
    GIGA='giga'
    TERA='tera'
    PETA='peta'
    EXA='exa'
    ZETTA='zetta'
    YOTTA='yotta'
    DECI='deci'
    CENTI='centi'
    MILLI='milli'
    MICRO='micro'
    NANO='nano'
    PICO='pico'
    FEMTO='femto'
    ATTO='atto'
    ZEPTO='zepto'
    YOCTO='yocto'


class presenceType_impl(str, Enum):
    REQUIRED='required'
    ILLEGAL='illegal'
    OPTIONAL='optional'


class protocolTypeType(str, Enum):
    TLM='tlm'
    CUSTOM='custom'


class readActionType(str, Enum):
    CLEAR='clear'
    SET='set'
    MODIFY='modify'


class resolveType(str, Enum):
    """resolveType -- Determines how a property value can be configured.
    Determines how a parameter is resolved. User means the value must be obtained from the user. Generated means the value will be provided by a generator.
    
    """
    IMMEDIATE='immediate' # Property content cannot be modified through configuration.
    USER='user' # Property content can be modified through configuration. Modifications will be saved with the design.
    GENERATED='generated' # Generators may modify this property. Modifications get saved with the design.


class returnTypeType(str, Enum):
    VOID='void'
    INT='int'


class scopeType(str, Enum):
    """scopeType -- The scope attribute applies to component generators and specifies whether the generator should be run for each instance of the entity (or module) or just once for all instances of the entity.
    
    """
    INSTANCE='instance'
    ENTITY='entity'


class sharedType(str, Enum):
    """sharedType -- The sharedness of the memoryMap content.
    
    """
    YES='yes'
    NO='no'
    UNDEFINED='undefined'


class signType(str, Enum):
    """signType -- This is an indication of the signedness of the value.
    
    """
    SIGNED='signed'
    UNSIGNED='unsigned'


class simpleBitSteeringExpression(str, Enum):
    """simpleBitSteeringExpression -- Indicates whether bit steering should be used to map this interface onto a bus of different data width.
    Values are "on", "off" (defaults to "off").
    
    """
    ON='on'
    OFF='off'


class simpleFileType(str, Enum):
    UNKNOWN='unknown'
    C_SOURCE='cSource'
    CPP_SOURCE='cppSource'
    ASM_SOURCE='asmSource'
    VHDL_SOURCE='vhdlSource'
    VHDL_SOURCE_87='vhdlSource-87'
    VHDL_SOURCE_93='vhdlSource-93'
    VERILOG_SOURCE='verilogSource'
    VERILOG_SOURCE_95='verilogSource-95'
    VERILOG_SOURCE_2001='verilogSource-2001'
    SW_OBJECT='swObject'
    SW_OBJECT_LIBRARY='swObjectLibrary'
    VHDL_BINARY_LIBRARY='vhdlBinaryLibrary'
    VERILOG_BINARY_LIBRARY='verilogBinaryLibrary'
    UNELABORATED_HDL='unelaboratedHdl'
    EXECUTABLE_HDL='executableHdl'
    SYSTEM_VERILOG_SOURCE='systemVerilogSource'
    SYSTEM_VERILOG_SOURCE_3_0='systemVerilogSource-3.0'
    SYSTEM_VERILOG_SOURCE_3_1='systemVerilogSource-3.1'
    SYSTEM_C_SOURCE='systemCSource'
    SYSTEM_C_SOURCE_2_0='systemCSource-2.0'
    SYSTEM_C_SOURCE_2_0_1='systemCSource-2.0.1'
    SYSTEM_C_SOURCE_2_1='systemCSource-2.1'
    SYSTEM_C_SOURCE_2_2='systemCSource-2.2'
    VERA_SOURCE='veraSource'
    E_SOURCE='eSource'
    PERL_SOURCE='perlSource'
    TCL_SOURCE='tclSource'
    OVA_SOURCE='OVASource'
    SVA_SOURCE='SVASource'
    PSL_SOURCE='pslSource'
    SYSTEM_VERILOG_SOURCE_3_1_A='systemVerilogSource-3.1a'
    SDC='SDC'
    VHDL_AMS_SOURCE='vhdlAmsSource'
    VERILOG_AMS_SOURCE='verilogAmsSource'
    SYSTEM_C_AMS_SOURCE='systemCAmsSource'
    LIBERTY_SOURCE='libertySource'
    USER='user'


class simplePortAccessType_impl(str, Enum):
    REF='ref'
    PTR='ptr'


class simpleTiedValueType(str, Enum):
    OPEN='open'
    DEFAULT='default'


class simpleWhiteboxType(str, Enum):
    SIGNAL='signal'
    PIN='pin'
    INTERFACE='interface'


class testConstraintType(str, Enum):
    """testConstraintType -- Constraint for an automated register test routine. 'unconstrained' (default) means may read and write all legal values. 'restore' means may read and write legal values but the value must be restored to the initially read value before accessing another register. 'writeAsRead' has limitations on testability where only the value read before a write may be written to the field. 'readOnly' has limitations on testability where values may only be read from the field.
    
    """
    UNCONSTRAINED='unconstrained'
    RESTORE='restore'
    WRITE_AS_READ='writeAsRead'
    READ_ONLY='readOnly'


class testConstraintType63(str, Enum):
    """testConstraintType63 -- Constraint for an automated register test routine. 'unconstrained' (default) means may read and write all legal values. 'restore' means may read and write legal values but the value must be restored to the initially read value before accessing another register. 'writeAsRead' has limitations on testability where only the value read before a write may be written to the field. 'readOnly' has limitations on testability where values may only be read from the field.
    
    """
    UNCONSTRAINED='unconstrained'
    RESTORE='restore'
    WRITE_AS_READ='writeAsRead'
    READ_ONLY='readOnly'


class transportMethodType(str, Enum):
    FILE='file'


class typeType(str, Enum):
    """typeType -- Defines the type of the payload.
    
    """
    GENERIC='generic'
    SPECIFIC='specific'


class unitType(str, Enum):
    """unitType -- Defines the unit of the value.
    
    """
    SECOND='second'
    AMPERE='ampere'
    KELVIN='kelvin'
    HERTZ='hertz'
    JOULE='joule'
    WATT='watt'
    COULOMB='coulomb'
    VOLT='volt'
    FARAD='farad'
    OHM='ohm'
    SIEMENS='siemens'
    HENRY='henry'
    CELSIUS='Celsius'


class usageType(str, Enum):
    """usageType -- Describes the usage of an address block.
    
    """
    MEMORY='memory' # Denotes an address range that can be used for read-write or read-only data storage.
    REGISTER='register' # Denotes an address block that is used to communicate with hardware.
    RESERVED='reserved' # Denotes an address range that must remain unoccupied.


class usageType55(str, Enum):
    """usageType55 -- Usage for the enumeration. 'read' for a software read access. 'write' for a software write access. 'read-write' for a software read or write access.
    
    """
    READ='read'
    WRITE='write'
    READWRITE='read-write'


class usageTypeType(str, Enum):
    """usageTypeType -- Indicates the type of the module parameter. Legal values are defined in the attribute enumeration list. Default value is 'nontyped'.
    
    """
    NONTYPED='nontyped'
    TYPED='typed'


class busDefinition(GeneratedsSuper):
    """vendor -- Name of the vendor who supplies this file.
    library -- Name of the logical library this element belongs to.
    name -- The name of the object.
    version -- Indicates the version of the named element.
    directConnection -- This element indicates that a master interface may be directly connected to a slave interface (under certain conditions) for busses of this type.
    broadcast -- This element indicates that this bus definition supports 'broadcast' mode. This means that it is legal to make one-to-many interface connections.
    isAddressable -- If true, indicates that this is an addressable bus.
    extends -- Optional name of bus type that this bus definition is compatible with. This bus definition may change the definitions in the existing bus definition
    maxMasters -- Indicates the maximum number of masters this bus supports.  If this element is not present, the number of masters allowed is unbounded.
    maxSlaves -- Indicates the maximum number of slaves this bus supports.  If the element is not present, the number of slaves allowed is unbounded.
    systemGroupNames -- Indicates the list of system group names that are defined for this bus definition.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('vendor', 'xs:Name', 0, 0, {'name': 'vendor', 'type': 'xs:Name'}, None),
        MemberSpec_('library', 'xs:Name', 0, 0, {'name': 'library', 'type': 'xs:Name'}, None),
        MemberSpec_('name', 'xs:NMTOKEN', 0, 0, {'name': 'name', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('version', 'xs:NMTOKEN', 0, 0, {'name': 'version', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('directConnection', 'xs:boolean', 0, 0, {'name': 'directConnection', 'type': 'xs:boolean'}, None),
        MemberSpec_('broadcast', 'xs:boolean', 0, 1, {'minOccurs': '0', 'name': 'broadcast', 'type': 'xs:boolean'}, None),
        MemberSpec_('isAddressable', 'xs:boolean', 0, 0, {'name': 'isAddressable', 'type': 'xs:boolean'}, None),
        MemberSpec_('extends', 'libraryRefType', 0, 1, {'minOccurs': '0', 'name': 'extends', 'type': 'libraryRefType'}, None),
        MemberSpec_('maxMasters', 'unsignedIntExpression', 0, 1, {'minOccurs': '0', 'name': 'maxMasters', 'type': 'unsignedIntExpression'}, None),
        MemberSpec_('maxSlaves', 'unsignedIntExpression', 0, 1, {'minOccurs': '0', 'name': 'maxSlaves', 'type': 'unsignedIntExpression'}, None),
        MemberSpec_('systemGroupNames', 'systemGroupNamesType', 0, 1, {'minOccurs': '0', 'name': 'systemGroupNames', 'type': 'systemGroupNamesType'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('assertions', 'assertions', 0, 1, {'minOccurs': '0', 'name': 'assertions', 'ref': 'assertions', 'type': 'assertions'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, vendor=None, library=None, name=None, version=None, directConnection=None, broadcast=None, isAddressable=None, extends=None, maxMasters=None, maxSlaves=None, systemGroupNames=None, description=None, parameters=None, assertions=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.vendor = vendor
        self.vendor_nsprefix_ = "ipxact"
        self.library = library
        self.library_nsprefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.version = version
        self.version_nsprefix_ = "ipxact"
        self.directConnection = directConnection
        self.directConnection_nsprefix_ = "ipxact"
        self.broadcast = broadcast
        self.broadcast_nsprefix_ = "ipxact"
        self.isAddressable = isAddressable
        self.isAddressable_nsprefix_ = "ipxact"
        self.extends = extends
        self.extends_nsprefix_ = "ipxact"
        self.maxMasters = maxMasters
        self.maxMasters_nsprefix_ = "ipxact"
        self.maxSlaves = maxSlaves
        self.maxSlaves_nsprefix_ = "ipxact"
        self.systemGroupNames = systemGroupNames
        self.systemGroupNames_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.assertions = assertions
        self.assertions_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, busDefinition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if busDefinition.subclass:
            return busDefinition.subclass(*args_, **kwargs_)
        else:
            return busDefinition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vendor(self):
        return self.vendor
    def set_vendor(self, vendor):
        self.vendor = vendor
    def get_library(self):
        return self.library
    def set_library(self, library):
        self.library = library
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_directConnection(self):
        return self.directConnection
    def set_directConnection(self, directConnection):
        self.directConnection = directConnection
    def get_broadcast(self):
        return self.broadcast
    def set_broadcast(self, broadcast):
        self.broadcast = broadcast
    def get_isAddressable(self):
        return self.isAddressable
    def set_isAddressable(self, isAddressable):
        self.isAddressable = isAddressable
    def get_extends(self):
        return self.extends
    def set_extends(self, extends):
        self.extends = extends
    def get_maxMasters(self):
        return self.maxMasters
    def set_maxMasters(self, maxMasters):
        self.maxMasters = maxMasters
    def get_maxSlaves(self):
        return self.maxSlaves
    def set_maxSlaves(self, maxSlaves):
        self.maxSlaves = maxSlaves
    def get_systemGroupNames(self):
        return self.systemGroupNames
    def set_systemGroupNames(self, systemGroupNames):
        self.systemGroupNames = systemGroupNames
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_assertions(self):
        return self.assertions
    def set_assertions(self, assertions):
        self.assertions = assertions
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.vendor is not None or
            self.library is not None or
            self.name is not None or
            self.version is not None or
            self.directConnection is not None or
            self.broadcast is not None or
            self.isAddressable is not None or
            self.extends is not None or
            self.maxMasters is not None or
            self.maxSlaves is not None or
            self.systemGroupNames is not None or
            self.description is not None or
            self.parameters is not None or
            self.assertions is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='busDefinition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('busDefinition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'busDefinition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='busDefinition')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='busDefinition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='busDefinition'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='busDefinition', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vendor is not None:
            namespaceprefix_ = self.vendor_nsprefix_ + ':' if (UseCapturedNS_ and self.vendor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor>%s</%svendor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vendor), input_name='vendor')), namespaceprefix_ , eol_))
        if self.library is not None:
            namespaceprefix_ = self.library_nsprefix_ + ':' if (UseCapturedNS_ and self.library_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slibrary>%s</%slibrary>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.library), input_name='library')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.directConnection is not None:
            namespaceprefix_ = self.directConnection_nsprefix_ + ':' if (UseCapturedNS_ and self.directConnection_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdirectConnection>%s</%sdirectConnection>%s' % (namespaceprefix_ , self.gds_format_boolean(self.directConnection, input_name='directConnection'), namespaceprefix_ , eol_))
        if self.broadcast is not None:
            namespaceprefix_ = self.broadcast_nsprefix_ + ':' if (UseCapturedNS_ and self.broadcast_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbroadcast>%s</%sbroadcast>%s' % (namespaceprefix_ , self.gds_format_boolean(self.broadcast, input_name='broadcast'), namespaceprefix_ , eol_))
        if self.isAddressable is not None:
            namespaceprefix_ = self.isAddressable_nsprefix_ + ':' if (UseCapturedNS_ and self.isAddressable_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sisAddressable>%s</%sisAddressable>%s' % (namespaceprefix_ , self.gds_format_boolean(self.isAddressable, input_name='isAddressable'), namespaceprefix_ , eol_))
        if self.extends is not None:
            namespaceprefix_ = self.extends_nsprefix_ + ':' if (UseCapturedNS_ and self.extends_nsprefix_) else ''
            self.extends.export(outfile, level, namespaceprefix_, namespacedef_='', name_='extends', pretty_print=pretty_print)
        if self.maxMasters is not None:
            namespaceprefix_ = self.maxMasters_nsprefix_ + ':' if (UseCapturedNS_ and self.maxMasters_nsprefix_) else ''
            self.maxMasters.export(outfile, level, namespaceprefix_, namespacedef_='', name_='maxMasters', pretty_print=pretty_print)
        if self.maxSlaves is not None:
            namespaceprefix_ = self.maxSlaves_nsprefix_ + ':' if (UseCapturedNS_ and self.maxSlaves_nsprefix_) else ''
            self.maxSlaves.export(outfile, level, namespaceprefix_, namespacedef_='', name_='maxSlaves', pretty_print=pretty_print)
        if self.systemGroupNames is not None:
            namespaceprefix_ = self.systemGroupNames_nsprefix_ + ':' if (UseCapturedNS_ and self.systemGroupNames_nsprefix_) else ''
            self.systemGroupNames.export(outfile, level, namespaceprefix_, namespacedef_='', name_='systemGroupNames', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.assertions is not None:
            namespaceprefix_ = self.assertions_nsprefix_ + ':' if (UseCapturedNS_ and self.assertions_nsprefix_) else ''
            self.assertions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='assertions', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vendor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vendor')
            value_ = self.gds_validate_string(value_, node, 'vendor')
            self.vendor = value_
            self.vendor_nsprefix_ = child_.prefix
        elif nodeName_ == 'library':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'library')
            value_ = self.gds_validate_string(value_, node, 'library')
            self.library = value_
            self.library_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'directConnection':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'directConnection')
            ival_ = self.gds_validate_boolean(ival_, node, 'directConnection')
            self.directConnection = ival_
            self.directConnection_nsprefix_ = child_.prefix
        elif nodeName_ == 'broadcast':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'broadcast')
            ival_ = self.gds_validate_boolean(ival_, node, 'broadcast')
            self.broadcast = ival_
            self.broadcast_nsprefix_ = child_.prefix
        elif nodeName_ == 'isAddressable':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'isAddressable')
            ival_ = self.gds_validate_boolean(ival_, node, 'isAddressable')
            self.isAddressable = ival_
            self.isAddressable_nsprefix_ = child_.prefix
        elif nodeName_ == 'extends':
            obj_ = LibraryRef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extends = obj_
            obj_.original_tagname_ = 'extends'
        elif nodeName_ == 'maxMasters':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.maxMasters = obj_
            obj_.original_tagname_ = 'maxMasters'
        elif nodeName_ == 'maxSlaves':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.maxSlaves = obj_
            obj_.original_tagname_ = 'maxSlaves'
        elif nodeName_ == 'systemGroupNames':
            obj_ = systemGroupNamesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.systemGroupNames = obj_
            obj_.original_tagname_ = 'systemGroupNames'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'assertions':
            obj_ = assertions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assertions = obj_
            obj_.original_tagname_ = 'assertions'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class busDefinition


class LibraryRef(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('vendor', 'xs:Name', 0, 0, {'use': 'required', 'name': 'vendor'}),
        MemberSpec_('library', 'xs:Name', 0, 0, {'use': 'required', 'name': 'library'}),
        MemberSpec_('name', 'xs:NMTOKEN', 0, 0, {'use': 'required', 'name': 'name'}),
        MemberSpec_('version', 'xs:NMTOKEN', 0, 0, {'use': 'required', 'name': 'version'}),
    ]
    subclass = None
    superclass = None
    def __init__(self, vendor=None, library=None, name=None, version=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.vendor = _cast(None, vendor)
        self.vendor_nsprefix_ = None
        self.library = _cast(None, library)
        self.library_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LibraryRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LibraryRef.subclass:
            return LibraryRef.subclass(*args_, **kwargs_)
        else:
            return LibraryRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vendor(self):
        return self.vendor
    def set_vendor(self, vendor):
        self.vendor = vendor
    def get_library(self):
        return self.library
    def set_library(self, library):
        self.library = library
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def _hasContent(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='libraryRefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('libraryRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'libraryRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='libraryRefType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='libraryRefType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='libraryRefType'):
        if self.vendor is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            outfile.write(' vendor=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.vendor), input_name='vendor')), ))
        if self.library is not None and 'library' not in already_processed:
            already_processed.add('library')
            outfile.write(' library=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.library), input_name='library')), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='libraryRefType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vendor', node)
        if value is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            self.vendor = value
        value = find_attr_value_('library', node)
        if value is not None and 'library' not in already_processed:
            already_processed.add('library')
            self.library = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class LibraryRef


class ConfigurableLibraryRef(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('vendor', 'xs:Name', 0, 0, {'use': 'required', 'name': 'vendor'}),
        MemberSpec_('library', 'xs:Name', 0, 0, {'use': 'required', 'name': 'library'}),
        MemberSpec_('name', 'xs:NMTOKEN', 0, 0, {'use': 'required', 'name': 'name'}),
        MemberSpec_('version', 'xs:NMTOKEN', 0, 0, {'use': 'required', 'name': 'version'}),
        MemberSpec_('configurableElementValues', 'configurableElementValues', 0, 1, {'minOccurs': '0', 'name': 'configurableElementValues', 'ref': 'configurableElementValues', 'type': 'configurableElementValues'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, vendor=None, library=None, name=None, version=None, configurableElementValues=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.vendor = _cast(None, vendor)
        self.vendor_nsprefix_ = None
        self.library = _cast(None, library)
        self.library_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
        self.configurableElementValues = configurableElementValues
        self.configurableElementValues_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConfigurableLibraryRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConfigurableLibraryRef.subclass:
            return ConfigurableLibraryRef.subclass(*args_, **kwargs_)
        else:
            return ConfigurableLibraryRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_configurableElementValues(self):
        return self.configurableElementValues
    def set_configurableElementValues(self, configurableElementValues):
        self.configurableElementValues = configurableElementValues
    def get_vendor(self):
        return self.vendor
    def set_vendor(self, vendor):
        self.vendor = vendor
    def get_library(self):
        return self.library
    def set_library(self, library):
        self.library = library
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def _hasContent(self):
        if (
            self.configurableElementValues is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableLibraryRefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('configurableLibraryRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'configurableLibraryRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='configurableLibraryRefType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='configurableLibraryRefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='configurableLibraryRefType'):
        if self.vendor is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            outfile.write(' vendor=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.vendor), input_name='vendor')), ))
        if self.library is not None and 'library' not in already_processed:
            already_processed.add('library')
            outfile.write(' library=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.library), input_name='library')), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableLibraryRefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.configurableElementValues is not None:
            namespaceprefix_ = self.configurableElementValues_nsprefix_ + ':' if (UseCapturedNS_ and self.configurableElementValues_nsprefix_) else ''
            self.configurableElementValues.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='configurableElementValues', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vendor', node)
        if value is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            self.vendor = value
        value = find_attr_value_('library', node)
        if value is not None and 'library' not in already_processed:
            already_processed.add('library')
            self.library = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'configurableElementValues':
            obj_ = configurableElementValues.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.configurableElementValues = obj_
            obj_.original_tagname_ = 'configurableElementValues'
# end class ConfigurableLibraryRef


class complexBaseExpression(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('valueOf_', ['simpleBaseExpression', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complexBaseExpression)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complexBaseExpression.subclass:
            return complexBaseExpression.subclass(*args_, **kwargs_)
        else:
            return complexBaseExpression(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_simpleBaseExpression(self, value):
        result = True
        # Validate type simpleBaseExpression, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on simpleBaseExpression' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='complexBaseExpression', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complexBaseExpression')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'complexBaseExpression':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complexBaseExpression')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complexBaseExpression', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='complexBaseExpression'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='complexBaseExpression', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class complexBaseExpression


class choices(GeneratedsSuper):
    """choice -- Non-empty set of legal values for a elements with an attribute ipxact:choiceRef.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('choice', 'choiceType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'choice', 'type': 'choiceType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, choice=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if choice is None:
            self.choice = []
        else:
            self.choice = choice
        self.choice_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, choices)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if choices.subclass:
            return choices.subclass(*args_, **kwargs_)
        else:
            return choices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_choice(self):
        return self.choice
    def set_choice(self, choice):
        self.choice = choice
    def add_choice(self, value):
        self.choice.append(value)
    def insert_choice_at(self, index, value):
        self.choice.insert(index, value)
    def replace_choice_at(self, index, value):
        self.choice[index] = value
    def _hasContent(self):
        if (
            self.choice
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='choices', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('choices')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'choices':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='choices')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='choices', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='choices'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='choices', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for choice_ in self.choice:
            namespaceprefix_ = self.choice_nsprefix_ + ':' if (UseCapturedNS_ and self.choice_nsprefix_) else ''
            choice_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='choice', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'choice':
            obj_ = choiceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.choice.append(obj_)
            obj_.original_tagname_ = 'choice'
# end class choices


class complexTiedValueType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('minimum', 'xs:int', 0, 1, {'use': 'optional', 'name': 'minimum'}),
        MemberSpec_('maximum', 'xs:int', 0, 1, {'use': 'optional', 'name': 'maximum'}),
        MemberSpec_('valueOf_', ['simpleTiedValueType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, minimum=None, maximum=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.minimum = _cast(int, minimum)
        self.minimum_nsprefix_ = None
        self.maximum = _cast(int, maximum)
        self.maximum_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complexTiedValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complexTiedValueType.subclass:
            return complexTiedValueType.subclass(*args_, **kwargs_)
        else:
            return complexTiedValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_minimum(self):
        return self.minimum
    def set_minimum(self, minimum):
        self.minimum = minimum
    def get_maximum(self):
        return self.maximum
    def set_maximum(self, maximum):
        self.maximum = maximum
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_simpleTiedValueType(self, value):
        result = True
        # Validate type simpleTiedValueType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='complexTiedValueType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complexTiedValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'complexTiedValueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complexTiedValueType')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complexTiedValueType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='complexTiedValueType'):
        if self.minimum is not None and 'minimum' not in already_processed:
            already_processed.add('minimum')
            outfile.write(' minimum="%s"' % self.gds_format_integer(self.minimum, input_name='minimum'))
        if self.maximum is not None and 'maximum' not in already_processed:
            already_processed.add('maximum')
            outfile.write(' maximum="%s"' % self.gds_format_integer(self.maximum, input_name='maximum'))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='complexTiedValueType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('minimum', node)
        if value is not None and 'minimum' not in already_processed:
            already_processed.add('minimum')
            self.minimum = self.gds_parse_integer(value, node, 'minimum')
        value = find_attr_value_('maximum', node)
        if value is not None and 'maximum' not in already_processed:
            already_processed.add('maximum')
            self.maximum = self.gds_parse_integer(value, node, 'maximum')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class complexTiedValueType


class configurableElementValues(GeneratedsSuper):
    """configurableElementValue -- Describes the content of a configurable element. The required referenceId attribute refers to the ID attribute of the configurable element.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('configurableElementValue', 'configurableElementValue', 1, 0, {'maxOccurs': 'unbounded', 'name': 'configurableElementValue', 'ref': 'configurableElementValue', 'type': 'configurableElementValue'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, configurableElementValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if configurableElementValue is None:
            self.configurableElementValue = []
        else:
            self.configurableElementValue = configurableElementValue
        self.configurableElementValue_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, configurableElementValues)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if configurableElementValues.subclass:
            return configurableElementValues.subclass(*args_, **kwargs_)
        else:
            return configurableElementValues(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_configurableElementValue(self):
        return self.configurableElementValue
    def set_configurableElementValue(self, configurableElementValue):
        self.configurableElementValue = configurableElementValue
    def add_configurableElementValue(self, value):
        self.configurableElementValue.append(value)
    def insert_configurableElementValue_at(self, index, value):
        self.configurableElementValue.insert(index, value)
    def replace_configurableElementValue_at(self, index, value):
        self.configurableElementValue[index] = value
    def _hasContent(self):
        if (
            self.configurableElementValue
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableElementValues', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('configurableElementValues')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'configurableElementValues':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='configurableElementValues')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='configurableElementValues', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='configurableElementValues'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableElementValues', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for configurableElementValue_ in self.configurableElementValue:
            namespaceprefix_ = self.configurableElementValue_nsprefix_ + ':' if (UseCapturedNS_ and self.configurableElementValue_nsprefix_) else ''
            configurableElementValue_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='configurableElementValue', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'configurableElementValue':
            obj_ = configurableElementValue.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.configurableElementValue.append(obj_)
            obj_.original_tagname_ = 'configurableElementValue'
# end class configurableElementValues


class configurableElementValue(complexBaseExpression):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('referenceId', 'xs:Name', 0, 0, {'use': 'required', 'name': 'referenceId'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('valueOf_', 'complexBaseExpression', 0),
    ]
    subclass = None
    superclass = complexBaseExpression
    def __init__(self, referenceId=None, id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        super(globals().get("configurableElementValue"), self).__init__(valueOf_,  **kwargs_)
        self.referenceId = _cast(None, referenceId)
        self.referenceId_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, configurableElementValue)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if configurableElementValue.subclass:
            return configurableElementValue.subclass(*args_, **kwargs_)
        else:
            return configurableElementValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_referenceId(self):
        return self.referenceId
    def set_referenceId(self, referenceId):
        self.referenceId = referenceId
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(configurableElementValue, self)._hasContent()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableElementValue', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('configurableElementValue')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'configurableElementValue':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='configurableElementValue')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='configurableElementValue', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='configurableElementValue'):
        super(configurableElementValue, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='configurableElementValue')
        if self.referenceId is not None and 'referenceId' not in already_processed:
            already_processed.add('referenceId')
            outfile.write(' referenceId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.referenceId), input_name='referenceId')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableElementValue', fromsubclass_=False, pretty_print=True):
        super(configurableElementValue, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('referenceId', node)
        if value is not None and 'referenceId' not in already_processed:
            already_processed.add('referenceId')
            self.referenceId = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        super(configurableElementValue, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class configurableElementValue


class componentInstance(GeneratedsSuper):
    """componentRef -- References a component to be found in an external library.  The four attributes define the VLNV of the referenced element.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('instanceName', 'xs:Name', 0, 0, {'name': 'instanceName', 'ref': 'instanceName', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('componentRef', 'configurableLibraryRefType', 0, 0, {'name': 'componentRef', 'type': 'configurableLibraryRefType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, instanceName=None, displayName=None, description=None, isPresent=None, componentRef=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.instanceName = instanceName
        self.instanceName_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.componentRef = componentRef
        self.componentRef_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, componentInstance)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if componentInstance.subclass:
            return componentInstance.subclass(*args_, **kwargs_)
        else:
            return componentInstance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_instanceName(self):
        return self.instanceName
    def set_instanceName(self, instanceName):
        self.instanceName = instanceName
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_componentRef(self):
        return self.componentRef
    def set_componentRef(self, componentRef):
        self.componentRef = componentRef
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.instanceName is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.componentRef is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentInstance', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('componentInstance')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'componentInstance':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='componentInstance')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='componentInstance', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='componentInstance'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentInstance', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.instanceName is not None:
            namespaceprefix_ = self.instanceName_nsprefix_ + ':' if (UseCapturedNS_ and self.instanceName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstanceName>%s</%sinstanceName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.instanceName), input_name='instanceName')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.componentRef is not None:
            namespaceprefix_ = self.componentRef_nsprefix_ + ':' if (UseCapturedNS_ and self.componentRef_nsprefix_) else ''
            self.componentRef.export(outfile, level, namespaceprefix_, namespacedef_='', name_='componentRef', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'instanceName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'instanceName')
            value_ = self.gds_validate_string(value_, node, 'instanceName')
            self.instanceName = value_
            self.instanceName_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'componentRef':
            obj_ = ConfigurableLibraryRef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentRef = obj_
            obj_.original_tagname_ = 'componentRef'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class componentInstance


class componentInstances(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('componentInstance', 'componentInstance', 1, 0, {'maxOccurs': 'unbounded', 'name': 'componentInstance', 'ref': 'componentInstance', 'type': 'componentInstance'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, componentInstance=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if componentInstance is None:
            self.componentInstance = []
        else:
            self.componentInstance = componentInstance
        self.componentInstance_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, componentInstances)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if componentInstances.subclass:
            return componentInstances.subclass(*args_, **kwargs_)
        else:
            return componentInstances(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_componentInstance(self):
        return self.componentInstance
    def set_componentInstance(self, componentInstance):
        self.componentInstance = componentInstance
    def add_componentInstance(self, value):
        self.componentInstance.append(value)
    def insert_componentInstance_at(self, index, value):
        self.componentInstance.insert(index, value)
    def replace_componentInstance_at(self, index, value):
        self.componentInstance[index] = value
    def _hasContent(self):
        if (
            self.componentInstance
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentInstances', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('componentInstances')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'componentInstances':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='componentInstances')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='componentInstances', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='componentInstances'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentInstances', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for componentInstance_ in self.componentInstance:
            namespaceprefix_ = self.componentInstance_nsprefix_ + ':' if (UseCapturedNS_ and self.componentInstance_nsprefix_) else ''
            componentInstance_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='componentInstance', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'componentInstance':
            obj_ = componentInstance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentInstance.append(obj_)
            obj_.original_tagname_ = 'componentInstance'
# end class componentInstances


class adHocConnection(GeneratedsSuper):
    """name -- Unique name
    tiedValue -- The logic value of this connection. The value can be an unsigned longint expression or open or default. Only valid for ports of style wire.
    portReferences -- Liist of internal and external port references involved in the adhocConnection
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', ['portName', 'xs:string'], 0, 0, {'name': 'name', 'type': 'xs:string'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('tiedValue', 'complexTiedValueType', 0, 1, {'minOccurs': '0', 'name': 'tiedValue', 'type': 'complexTiedValueType'}, None),
        MemberSpec_('portReferences', 'portReferencesType', 0, 0, {'name': 'portReferences', 'type': 'portReferencesType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, isPresent=None, tiedValue=None, portReferences=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.validate_portName(self.name)
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.tiedValue = tiedValue
        self.tiedValue_nsprefix_ = "ipxact"
        self.portReferences = portReferences
        self.portReferences_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adHocConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adHocConnection.subclass:
            return adHocConnection.subclass(*args_, **kwargs_)
        else:
            return adHocConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_tiedValue(self):
        return self.tiedValue
    def set_tiedValue(self, tiedValue):
        self.tiedValue = tiedValue
    def get_portReferences(self):
        return self.portReferences
    def set_portReferences(self, portReferences):
        self.portReferences = portReferences
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_portName(self, value):
        result = True
        # Validate type portName, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_portName_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_portName_patterns_, ))
                result = False
        return result
    validate_portName_patterns_ = [['^([A-Za-z0-9\\.\\-:_]*)$']]
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.tiedValue is not None or
            self.portReferences is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='adHocConnection', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('adHocConnection')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'adHocConnection':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='adHocConnection')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='adHocConnection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='adHocConnection'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='adHocConnection', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.tiedValue is not None:
            namespaceprefix_ = self.tiedValue_nsprefix_ + ':' if (UseCapturedNS_ and self.tiedValue_nsprefix_) else ''
            self.tiedValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tiedValue', pretty_print=pretty_print)
        if self.portReferences is not None:
            namespaceprefix_ = self.portReferences_nsprefix_ + ':' if (UseCapturedNS_ and self.portReferences_nsprefix_) else ''
            self.portReferences.export(outfile, level, namespaceprefix_, namespacedef_='', name_='portReferences', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
            # validate type portName
            self.validate_portName(self.name)
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'tiedValue':
            obj_ = complexTiedValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.tiedValue = obj_
            obj_.original_tagname_ = 'tiedValue'
        elif nodeName_ == 'portReferences':
            obj_ = portReferencesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.portReferences = obj_
            obj_.original_tagname_ = 'portReferences'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class adHocConnection


class adHocConnections(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('adHocConnection', 'adHocConnection', 1, 0, {'maxOccurs': 'unbounded', 'name': 'adHocConnection', 'ref': 'adHocConnection', 'type': 'adHocConnection'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, adHocConnection=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if adHocConnection is None:
            self.adHocConnection = []
        else:
            self.adHocConnection = adHocConnection
        self.adHocConnection_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adHocConnections)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adHocConnections.subclass:
            return adHocConnections.subclass(*args_, **kwargs_)
        else:
            return adHocConnections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_adHocConnection(self):
        return self.adHocConnection
    def set_adHocConnection(self, adHocConnection):
        self.adHocConnection = adHocConnection
    def add_adHocConnection(self, value):
        self.adHocConnection.append(value)
    def insert_adHocConnection_at(self, index, value):
        self.adHocConnection.insert(index, value)
    def replace_adHocConnection_at(self, index, value):
        self.adHocConnection[index] = value
    def _hasContent(self):
        if (
            self.adHocConnection
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='adHocConnections', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('adHocConnections')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'adHocConnections':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='adHocConnections')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='adHocConnections', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='adHocConnections'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='adHocConnections', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for adHocConnection_ in self.adHocConnection:
            namespaceprefix_ = self.adHocConnection_nsprefix_ + ':' if (UseCapturedNS_ and self.adHocConnection_nsprefix_) else ''
            adHocConnection_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='adHocConnection', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'adHocConnection':
            obj_ = adHocConnection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.adHocConnection.append(obj_)
            obj_.original_tagname_ = 'adHocConnection'
# end class adHocConnections


class interconnection(GeneratedsSuper):
    """name -- Unique name
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('activeInterface', 'activeInterface', 1, 0, {'maxOccurs': 'unbounded', 'name': 'activeInterface', 'ref': 'activeInterface', 'type': 'activeInterface'}, 3),
        MemberSpec_('hierInterface', 'hierInterface', 1, 0, {'maxOccurs': 'unbounded', 'name': 'hierInterface', 'type': 'hierInterfaceType'}, 3),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, isPresent=None, activeInterface=None, hierInterface=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        if activeInterface is None:
            self.activeInterface = []
        else:
            self.activeInterface = activeInterface
        self.activeInterface_nsprefix_ = "ipxact"
        if hierInterface is None:
            self.hierInterface = []
        else:
            self.hierInterface = hierInterface
        self.hierInterface_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, interconnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if interconnection.subclass:
            return interconnection.subclass(*args_, **kwargs_)
        else:
            return interconnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_activeInterface(self):
        return self.activeInterface
    def set_activeInterface(self, activeInterface):
        self.activeInterface = activeInterface
    def add_activeInterface(self, value):
        self.activeInterface.append(value)
    def insert_activeInterface_at(self, index, value):
        self.activeInterface.insert(index, value)
    def replace_activeInterface_at(self, index, value):
        self.activeInterface[index] = value
    def get_hierInterface(self):
        return self.hierInterface
    def set_hierInterface(self, hierInterface):
        self.hierInterface = hierInterface
    def add_hierInterface(self, value):
        self.hierInterface.append(value)
    def insert_hierInterface_at(self, index, value):
        self.hierInterface.insert(index, value)
    def replace_hierInterface_at(self, index, value):
        self.hierInterface[index] = value
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.activeInterface or
            self.hierInterface or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='interconnection', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('interconnection')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'interconnection':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='interconnection')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='interconnection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='interconnection'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='interconnection', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        for activeInterface_ in self.activeInterface:
            namespaceprefix_ = self.activeInterface_nsprefix_ + ':' if (UseCapturedNS_ and self.activeInterface_nsprefix_) else ''
            activeInterface_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='activeInterface', pretty_print=pretty_print)
        for hierInterface_ in self.hierInterface:
            namespaceprefix_ = self.hierInterface_nsprefix_ + ':' if (UseCapturedNS_ and self.hierInterface_nsprefix_) else ''
            hierInterface_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='hierInterface', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'activeInterface':
            obj_ = activeInterface.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.activeInterface.append(obj_)
            obj_.original_tagname_ = 'activeInterface'
        elif nodeName_ == 'hierInterface':
            obj_ = hierInterfaceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.hierInterface.append(obj_)
            obj_.original_tagname_ = 'hierInterface'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class interconnection


class monitorInterconnection(GeneratedsSuper):
    """name -- Unique name
    monitoredActiveInterface -- Describes an active interface of the design that all the monitors will be connected to.
    The componentRef and busRef attributes indicate the instance name and bus interface name. The optional path attribute indicates the hierarchical instance name path to the component.
    monitorInterface -- Describes a list of monitor interfaces that are connected to the single active interface.
    The componentRef and busRef attributes indicate the instance name and bus interface name. The optional path attribute indicates the hierarchical instance name path to the component.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('monitoredActiveInterface', 'monitorInterfaceType', 0, 0, {'name': 'monitoredActiveInterface', 'type': 'monitorInterfaceType'}, None),
        MemberSpec_('monitorInterface', 'monitorInterfaceType1', 1, 0, {'maxOccurs': 'unbounded', 'name': 'monitorInterface', 'type': 'monitorInterfaceType1'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, displayName=None, description=None, isPresent=None, monitoredActiveInterface=None, monitorInterface=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.monitoredActiveInterface = monitoredActiveInterface
        self.monitoredActiveInterface_nsprefix_ = "ipxact"
        if monitorInterface is None:
            self.monitorInterface = []
        else:
            self.monitorInterface = monitorInterface
        self.monitorInterface_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, monitorInterconnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if monitorInterconnection.subclass:
            return monitorInterconnection.subclass(*args_, **kwargs_)
        else:
            return monitorInterconnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_monitoredActiveInterface(self):
        return self.monitoredActiveInterface
    def set_monitoredActiveInterface(self, monitoredActiveInterface):
        self.monitoredActiveInterface = monitoredActiveInterface
    def get_monitorInterface(self):
        return self.monitorInterface
    def set_monitorInterface(self, monitorInterface):
        self.monitorInterface = monitorInterface
    def add_monitorInterface(self, value):
        self.monitorInterface.append(value)
    def insert_monitorInterface_at(self, index, value):
        self.monitorInterface.insert(index, value)
    def replace_monitorInterface_at(self, index, value):
        self.monitorInterface[index] = value
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.monitoredActiveInterface is not None or
            self.monitorInterface
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='monitorInterconnection', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('monitorInterconnection')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'monitorInterconnection':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='monitorInterconnection')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='monitorInterconnection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='monitorInterconnection'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='monitorInterconnection', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.monitoredActiveInterface is not None:
            namespaceprefix_ = self.monitoredActiveInterface_nsprefix_ + ':' if (UseCapturedNS_ and self.monitoredActiveInterface_nsprefix_) else ''
            self.monitoredActiveInterface.export(outfile, level, namespaceprefix_, namespacedef_='', name_='monitoredActiveInterface', pretty_print=pretty_print)
        for monitorInterface_ in self.monitorInterface:
            namespaceprefix_ = self.monitorInterface_nsprefix_ + ':' if (UseCapturedNS_ and self.monitorInterface_nsprefix_) else ''
            monitorInterface_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='monitorInterface', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'monitoredActiveInterface':
            class_obj_ = self.get_class_obj_(child_, monitorInterfaceType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.monitoredActiveInterface = obj_
            obj_.original_tagname_ = 'monitoredActiveInterface'
        elif nodeName_ == 'monitorInterface':
            obj_ = monitorInterfaceType1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.monitorInterface.append(obj_)
            obj_.original_tagname_ = 'monitorInterface'
# end class monitorInterconnection


class interconnections(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('interconnection', 'interconnection', 1, 1, {'name': 'interconnection', 'ref': 'interconnection', 'type': 'interconnection'}, 4),
        MemberSpec_('monitorInterconnection', 'monitorInterconnection', 1, 1, {'name': 'monitorInterconnection', 'ref': 'monitorInterconnection', 'type': 'monitorInterconnection'}, 4),
    ]
    subclass = None
    superclass = None
    def __init__(self, interconnection=None, monitorInterconnection=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if interconnection is None:
            self.interconnection = []
        else:
            self.interconnection = interconnection
        self.interconnection_nsprefix_ = "ipxact"
        if monitorInterconnection is None:
            self.monitorInterconnection = []
        else:
            self.monitorInterconnection = monitorInterconnection
        self.monitorInterconnection_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, interconnections)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if interconnections.subclass:
            return interconnections.subclass(*args_, **kwargs_)
        else:
            return interconnections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_interconnection(self):
        return self.interconnection
    def set_interconnection(self, interconnection):
        self.interconnection = interconnection
    def add_interconnection(self, value):
        self.interconnection.append(value)
    def insert_interconnection_at(self, index, value):
        self.interconnection.insert(index, value)
    def replace_interconnection_at(self, index, value):
        self.interconnection[index] = value
    def get_monitorInterconnection(self):
        return self.monitorInterconnection
    def set_monitorInterconnection(self, monitorInterconnection):
        self.monitorInterconnection = monitorInterconnection
    def add_monitorInterconnection(self, value):
        self.monitorInterconnection.append(value)
    def insert_monitorInterconnection_at(self, index, value):
        self.monitorInterconnection.insert(index, value)
    def replace_monitorInterconnection_at(self, index, value):
        self.monitorInterconnection[index] = value
    def _hasContent(self):
        if (
            self.interconnection or
            self.monitorInterconnection
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='interconnections', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('interconnections')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'interconnections':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='interconnections')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='interconnections', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='interconnections'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='interconnections', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for interconnection_ in self.interconnection:
            namespaceprefix_ = self.interconnection_nsprefix_ + ':' if (UseCapturedNS_ and self.interconnection_nsprefix_) else ''
            interconnection_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='interconnection', pretty_print=pretty_print)
        for monitorInterconnection_ in self.monitorInterconnection:
            namespaceprefix_ = self.monitorInterconnection_nsprefix_ + ':' if (UseCapturedNS_ and self.monitorInterconnection_nsprefix_) else ''
            monitorInterconnection_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='monitorInterconnection', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'interconnection':
            obj_ = interconnection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.interconnection.append(obj_)
            obj_.original_tagname_ = 'interconnection'
        elif nodeName_ == 'monitorInterconnection':
            obj_ = monitorInterconnection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.monitorInterconnection.append(obj_)
            obj_.original_tagname_ = 'monitorInterconnection'
# end class interconnections


class interfaceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('componentRef', 'xs:Name', 0, 0, {'use': 'required', 'name': 'componentRef'}),
        MemberSpec_('busRef', 'xs:Name', 0, 0, {'use': 'required', 'name': 'busRef'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
    ]
    subclass = None
    superclass = None
    def __init__(self, componentRef=None, busRef=None, id=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.componentRef = _cast(None, componentRef)
        self.componentRef_nsprefix_ = None
        self.busRef = _cast(None, busRef)
        self.busRef_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, interfaceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if interfaceType.subclass:
            return interfaceType.subclass(*args_, **kwargs_)
        else:
            return interfaceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_componentRef(self):
        return self.componentRef
    def set_componentRef(self, componentRef):
        self.componentRef = componentRef
    def get_busRef(self):
        return self.busRef
    def set_busRef(self, busRef):
        self.busRef = busRef
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='interfaceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('interfaceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'interfaceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='interfaceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='interfaceType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='interfaceType'):
        if self.componentRef is not None and 'componentRef' not in already_processed:
            already_processed.add('componentRef')
            outfile.write(' componentRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.componentRef), input_name='componentRef')), ))
        if self.busRef is not None and 'busRef' not in already_processed:
            already_processed.add('busRef')
            outfile.write(' busRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.busRef), input_name='busRef')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='interfaceType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('componentRef', node)
        if value is not None and 'componentRef' not in already_processed:
            already_processed.add('componentRef')
            self.componentRef = value
        value = find_attr_value_('busRef', node)
        if value is not None and 'busRef' not in already_processed:
            already_processed.add('busRef')
            self.busRef = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class interfaceType


class hierInterfaceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('busRef', 'xs:Name', 0, 0, {'use': 'required', 'name': 'busRef'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, busRef=None, id=None, isPresent=None, description=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.busRef = _cast(None, busRef)
        self.busRef_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, hierInterfaceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if hierInterfaceType.subclass:
            return hierInterfaceType.subclass(*args_, **kwargs_)
        else:
            return hierInterfaceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_busRef(self):
        return self.busRef
    def set_busRef(self, busRef):
        self.busRef = busRef
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.isPresent is not None or
            self.description is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='hierInterfaceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('hierInterfaceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'hierInterfaceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='hierInterfaceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='hierInterfaceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='hierInterfaceType'):
        if self.busRef is not None and 'busRef' not in already_processed:
            already_processed.add('busRef')
            outfile.write(' busRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.busRef), input_name='busRef')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='hierInterfaceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('busRef', node)
        if value is not None and 'busRef' not in already_processed:
            already_processed.add('busRef')
            self.busRef = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class hierInterfaceType


class monitorInterfaceType(interfaceType):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('path', 'xs:string', 0, 1, {'use': 'optional', 'name': 'path'}),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = interfaceType
    def __init__(self, componentRef=None, busRef=None, id=None, path=None, description=None, vendorExtensions=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        super(globals().get("monitorInterfaceType"), self).__init__(componentRef, busRef, id, extensiontype_,  **kwargs_)
        self.path = _cast(None, path)
        self.path_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, monitorInterfaceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if monitorInterfaceType.subclass:
            return monitorInterfaceType.subclass(*args_, **kwargs_)
        else:
            return monitorInterfaceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_path(self):
        return self.path
    def set_path(self, path):
        self.path = path
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (
            self.description is not None or
            self.vendorExtensions is not None or
            super(monitorInterfaceType, self)._hasContent()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='monitorInterfaceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('monitorInterfaceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'monitorInterfaceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='monitorInterfaceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='monitorInterfaceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='monitorInterfaceType'):
        super(monitorInterfaceType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='monitorInterfaceType')
        if self.path is not None and 'path' not in already_processed:
            already_processed.add('path')
            outfile.write(' path=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.path), input_name='path')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='monitorInterfaceType', fromsubclass_=False, pretty_print=True):
        super(monitorInterfaceType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('path', node)
        if value is not None and 'path' not in already_processed:
            already_processed.add('path')
            self.path = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(monitorInterfaceType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
        super(monitorInterfaceType, self)._buildChildren(child_, node, nodeName_, True)
# end class monitorInterfaceType


class externalPortReference(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('portRef', 'ipxact:portName', 0, 0, {'use': 'required', 'name': 'portRef'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('PartSelect', 'partSelect', 0, 1, {'minOccurs': '0', 'name': 'partSelect', 'ref': 'partSelect', 'type': 'partSelect'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, portRef=None, id=None, isPresent=None, PartSelect=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.portRef = _cast(None, portRef)
        self.portRef_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.PartSelect = PartSelect
        self.PartSelect_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, externalPortReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if externalPortReference.subclass:
            return externalPortReference.subclass(*args_, **kwargs_)
        else:
            return externalPortReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_partSelect(self):
        return self.PartSelect
    def set_partSelect(self, PartSelect):
        self.PartSelect = PartSelect
    def get_portRef(self):
        return self.portRef
    def set_portRef(self, portRef):
        self.portRef = portRef
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_portName(self, value):
        # Validate type ipxact:portName, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_portName_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_portName_patterns_, ))
    validate_portName_patterns_ = [['^([A-Za-z0-9\\.\\-:_]*)$']]
    def _hasContent(self):
        if (
            self.isPresent is not None or
            self.PartSelect is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='externalPortReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('externalPortReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'externalPortReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='externalPortReference')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='externalPortReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='externalPortReference'):
        if self.portRef is not None and 'portRef' not in already_processed:
            already_processed.add('portRef')
            outfile.write(' portRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.portRef), input_name='portRef')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='externalPortReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.PartSelect is not None:
            namespaceprefix_ = self.PartSelect_nsprefix_ + ':' if (UseCapturedNS_ and self.PartSelect_nsprefix_) else ''
            self.PartSelect.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='partSelect', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('portRef', node)
        if value is not None and 'portRef' not in already_processed:
            already_processed.add('portRef')
            self.portRef = value
            self.validate_portName(self.portRef)    # validate type portName
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'partSelect':
            obj_ = PartSelect.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PartSelect = obj_
            obj_.original_tagname_ = 'partSelect'
# end class externalPortReference


class activeInterface(interfaceType):
    """excludePorts -- The list of physical ports to be excluded from an interface based connection. Analogous to the removing the port map element for the named ports.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('excludePorts', 'excludePortsType', 0, 1, {'minOccurs': '0', 'name': 'excludePorts', 'type': 'excludePortsType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = interfaceType
    def __init__(self, componentRef=None, busRef=None, id=None, isPresent=None, description=None, excludePorts=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        super(globals().get("activeInterface"), self).__init__(componentRef, busRef, id,  **kwargs_)
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.excludePorts = excludePorts
        self.excludePorts_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, activeInterface)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if activeInterface.subclass:
            return activeInterface.subclass(*args_, **kwargs_)
        else:
            return activeInterface(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_excludePorts(self):
        return self.excludePorts
    def set_excludePorts(self, excludePorts):
        self.excludePorts = excludePorts
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def _hasContent(self):
        if (
            self.isPresent is not None or
            self.description is not None or
            self.excludePorts is not None or
            self.vendorExtensions is not None or
            super(activeInterface, self)._hasContent()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='activeInterface', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('activeInterface')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'activeInterface':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='activeInterface')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='activeInterface', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='activeInterface'):
        super(activeInterface, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='activeInterface')
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='activeInterface', fromsubclass_=False, pretty_print=True):
        super(activeInterface, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.excludePorts is not None:
            namespaceprefix_ = self.excludePorts_nsprefix_ + ':' if (UseCapturedNS_ and self.excludePorts_nsprefix_) else ''
            self.excludePorts.export(outfile, level, namespaceprefix_, namespacedef_='', name_='excludePorts', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(activeInterface, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'excludePorts':
            obj_ = excludePortsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.excludePorts = obj_
            obj_.original_tagname_ = 'excludePorts'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
        super(activeInterface, self)._buildChildren(child_, node, nodeName_, True)
# end class activeInterface


class assertion(GeneratedsSuper):
    """name -- Unique name
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('assert_', 'unsignedBitExpression', 0, 0, {'name': 'assert', 'type': 'unsignedBitExpression'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, assert_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.assert_ = assert_
        self.assert__nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, assertion)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if assertion.subclass:
            return assertion.subclass(*args_, **kwargs_)
        else:
            return assertion(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_assert(self):
        return self.assert_
    def set_assert(self, assert_):
        self.assert_ = assert_
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.assert_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='assertion', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('assertion')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'assertion':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='assertion')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='assertion', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='assertion'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='assertion', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.assert_ is not None:
            namespaceprefix_ = self.assert__nsprefix_ + ':' if (UseCapturedNS_ and self.assert__nsprefix_) else ''
            self.assert_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assert', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'assert':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assert_ = obj_
            obj_.original_tagname_ = 'assert'
# end class assertion


class assertions(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('assertion', 'assertion', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'assertion', 'ref': 'assertion', 'type': 'assertion'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, assertion=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if assertion is None:
            self.assertion = []
        else:
            self.assertion = assertion
        self.assertion_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, assertions)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if assertions.subclass:
            return assertions.subclass(*args_, **kwargs_)
        else:
            return assertions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_assertion(self):
        return self.assertion
    def set_assertion(self, assertion):
        self.assertion = assertion
    def add_assertion(self, value):
        self.assertion.append(value)
    def insert_assertion_at(self, index, value):
        self.assertion.insert(index, value)
    def replace_assertion_at(self, index, value):
        self.assertion[index] = value
    def _hasContent(self):
        if (
            self.assertion
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='assertions', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('assertions')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'assertions':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='assertions')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='assertions', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='assertions'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='assertions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for assertion_ in self.assertion:
            namespaceprefix_ = self.assertion_nsprefix_ + ':' if (UseCapturedNS_ and self.assertion_nsprefix_) else ''
            assertion_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='assertion', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'assertion':
            obj_ = assertion.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assertion.append(obj_)
            obj_.original_tagname_ = 'assertion'
# end class assertions


class parameters(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('parameter', 'parameterType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'parameter', 'ref': 'parameter', 'type': 'parameter'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, parameter=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if parameter is None:
            self.parameter = []
        else:
            self.parameter = parameter
        self.parameter_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, parameters)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if parameters.subclass:
            return parameters.subclass(*args_, **kwargs_)
        else:
            return parameters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_parameter(self):
        return self.parameter
    def set_parameter(self, parameter):
        self.parameter = parameter
    def add_parameter(self, value):
        self.parameter.append(value)
    def insert_parameter_at(self, index, value):
        self.parameter.insert(index, value)
    def replace_parameter_at(self, index, value):
        self.parameter[index] = value
    def _hasContent(self):
        if (
            self.parameter
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='parameters', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('parameters')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'parameters':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='parameters')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='parameters', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='parameters'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='parameters', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for parameter_ in self.parameter:
            namespaceprefix_ = self.parameter_nsprefix_ + ':' if (UseCapturedNS_ and self.parameter_nsprefix_) else ''
            parameter_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameter', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'parameter':
            class_obj_ = self.get_class_obj_(child_, parameterType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameter.append(obj_)
            obj_.original_tagname_ = 'parameter'
# end class parameters


class vendorExtensions(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('__ANY__', '__ANY__', 1, 0, {'maxOccurs': 'unbounded', 'namespace': '##any', 'processContents': 'lax'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vendorExtensions)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vendorExtensions.subclass:
            return vendorExtensions.subclass(*args_, **kwargs_)
        else:
            return vendorExtensions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def _hasContent(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='vendorExtensions', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vendorExtensions')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'vendorExtensions':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vendorExtensions')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vendorExtensions', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='vendorExtensions'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='vendorExtensions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if not fromsubclass_:
            for obj_ in self.anytypeobjs_:
                showIndent(outfile, level, pretty_print)
                outfile.write(obj_)
                outfile.write('\n')
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        content_ = self.gds_build_any(child_, 'vendorExtensions')
        self.anytypeobjs_.append(content_)
# end class vendorExtensions


class leafAccessHandle(GeneratedsSuper):
    """viewRef -- A list of views this accessHandle is applicable to. Note this element is optional, if it is not present the accessHandle applies to all views.
    indices -- For a multi dimensional IP-XACT object, indices can be specified to select the element the accessHandle applies to. This is an index into a multi-dimensional array and follows C-semantics for indexing.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('force', 'xs:boolean', 0, 1, {'use': 'optional', 'name': 'force'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('viewRef', 'viewRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'viewRef', 'type': 'viewRefType'}, None),
        MemberSpec_('indices', 'indicesType2', 0, 1, {'minOccurs': '0', 'name': 'indices', 'type': 'indicesType2'}, None),
        MemberSpec_('slices', 'slicesType', 0, 0, {'name': 'slices', 'type': 'slicesType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, force=True, id=None, viewRef=None, indices=None, slices=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.force = _cast(bool, force)
        self.force_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if viewRef is None:
            self.viewRef = []
        else:
            self.viewRef = viewRef
        self.viewRef_nsprefix_ = "ipxact"
        self.indices = indices
        self.indices_nsprefix_ = "ipxact"
        self.slices = slices
        self.slices_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, leafAccessHandle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if leafAccessHandle.subclass:
            return leafAccessHandle.subclass(*args_, **kwargs_)
        else:
            return leafAccessHandle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_viewRef(self):
        return self.viewRef
    def set_viewRef(self, viewRef):
        self.viewRef = viewRef
    def add_viewRef(self, value):
        self.viewRef.append(value)
    def insert_viewRef_at(self, index, value):
        self.viewRef.insert(index, value)
    def replace_viewRef_at(self, index, value):
        self.viewRef[index] = value
    def get_indices(self):
        return self.indices
    def set_indices(self, indices):
        self.indices = indices
    def get_slices(self):
        return self.slices
    def set_slices(self, slices):
        self.slices = slices
    def get_force(self):
        return self.force
    def set_force(self, force):
        self.force = force
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.viewRef or
            self.indices is not None or
            self.slices is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='leafAccessHandle', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('leafAccessHandle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'leafAccessHandle':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='leafAccessHandle')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='leafAccessHandle', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='leafAccessHandle'):
        if not self.force and 'force' not in already_processed:
            already_processed.add('force')
            outfile.write(' force="%s"' % self.gds_format_boolean(self.force, input_name='force'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='leafAccessHandle', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for viewRef_ in self.viewRef:
            namespaceprefix_ = self.viewRef_nsprefix_ + ':' if (UseCapturedNS_ and self.viewRef_nsprefix_) else ''
            viewRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='viewRef', pretty_print=pretty_print)
        if self.indices is not None:
            namespaceprefix_ = self.indices_nsprefix_ + ':' if (UseCapturedNS_ and self.indices_nsprefix_) else ''
            self.indices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='indices', pretty_print=pretty_print)
        if self.slices is not None:
            namespaceprefix_ = self.slices_nsprefix_ + ':' if (UseCapturedNS_ and self.slices_nsprefix_) else ''
            self.slices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slices', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('force', node)
        if value is not None and 'force' not in already_processed:
            already_processed.add('force')
            if value in ('true', '1'):
                self.force = True
            elif value in ('false', '0'):
                self.force = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'viewRef':
            obj_ = viewRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.viewRef.append(obj_)
            obj_.original_tagname_ = 'viewRef'
        elif nodeName_ == 'indices':
            obj_ = indicesType2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.indices = obj_
            obj_.original_tagname_ = 'indices'
        elif nodeName_ == 'slices':
            obj_ = slicesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.slices = obj_
            obj_.original_tagname_ = 'slices'
# end class leafAccessHandle


class nonIndexedLeafAccessHandle(GeneratedsSuper):
    """viewRef -- A list of views this accessHandle is applicable to. Note this element is optional, if it is not present the accessHandle applies to all views.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('force', 'xs:boolean', 0, 1, {'use': 'optional', 'name': 'force'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('viewRef', 'viewRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'viewRef', 'type': 'viewRefType3'}, None),
        MemberSpec_('slices', 'slicesType', 0, 0, {'name': 'slices', 'type': 'slicesType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, force=True, id=None, viewRef=None, slices=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.force = _cast(bool, force)
        self.force_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if viewRef is None:
            self.viewRef = []
        else:
            self.viewRef = viewRef
        self.viewRef_nsprefix_ = "ipxact"
        self.slices = slices
        self.slices_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, nonIndexedLeafAccessHandle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if nonIndexedLeafAccessHandle.subclass:
            return nonIndexedLeafAccessHandle.subclass(*args_, **kwargs_)
        else:
            return nonIndexedLeafAccessHandle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_viewRef(self):
        return self.viewRef
    def set_viewRef(self, viewRef):
        self.viewRef = viewRef
    def add_viewRef(self, value):
        self.viewRef.append(value)
    def insert_viewRef_at(self, index, value):
        self.viewRef.insert(index, value)
    def replace_viewRef_at(self, index, value):
        self.viewRef[index] = value
    def get_slices(self):
        return self.slices
    def set_slices(self, slices):
        self.slices = slices
    def get_force(self):
        return self.force
    def set_force(self, force):
        self.force = force
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.viewRef or
            self.slices is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='nonIndexedLeafAccessHandle', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('nonIndexedLeafAccessHandle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'nonIndexedLeafAccessHandle':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='nonIndexedLeafAccessHandle')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='nonIndexedLeafAccessHandle', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='nonIndexedLeafAccessHandle'):
        if not self.force and 'force' not in already_processed:
            already_processed.add('force')
            outfile.write(' force="%s"' % self.gds_format_boolean(self.force, input_name='force'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='nonIndexedLeafAccessHandle', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for viewRef_ in self.viewRef:
            namespaceprefix_ = self.viewRef_nsprefix_ + ':' if (UseCapturedNS_ and self.viewRef_nsprefix_) else ''
            viewRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='viewRef', pretty_print=pretty_print)
        if self.slices is not None:
            namespaceprefix_ = self.slices_nsprefix_ + ':' if (UseCapturedNS_ and self.slices_nsprefix_) else ''
            self.slices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slices', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('force', node)
        if value is not None and 'force' not in already_processed:
            already_processed.add('force')
            if value in ('true', '1'):
                self.force = True
            elif value in ('false', '0'):
                self.force = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'viewRef':
            obj_ = viewRefType3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.viewRef.append(obj_)
            obj_.original_tagname_ = 'viewRef'
        elif nodeName_ == 'slices':
            obj_ = slicesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.slices = obj_
            obj_.original_tagname_ = 'slices'
# end class nonIndexedLeafAccessHandle


class indexedAccessHandle(GeneratedsSuper):
    """viewRef -- A list of views this accessHandle is applicable to. Note this element is optional, if it is not present the accessHandle applies to all views.
    indices -- For a multi dimensional IP-XACT object, indices can be specified to select the element the accessHandle applies to. This is an index into a multi-dimensional array and follows C-semantics for indexing.
    pathSegments -- An ordered list of pathSegment elements. When concatenated with a desired separator the elements in this form a HDL path for the parent slice into the referenced view.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('viewRef', 'viewRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'viewRef', 'type': 'viewRefType4'}, None),
        MemberSpec_('indices', 'indicesType5', 0, 1, {'minOccurs': '0', 'name': 'indices', 'type': 'indicesType5'}, None),
        MemberSpec_('pathSegments', 'pathSegmentsType', 0, 0, {'name': 'pathSegments', 'type': 'pathSegmentsType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, viewRef=None, indices=None, pathSegments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if viewRef is None:
            self.viewRef = []
        else:
            self.viewRef = viewRef
        self.viewRef_nsprefix_ = "ipxact"
        self.indices = indices
        self.indices_nsprefix_ = "ipxact"
        self.pathSegments = pathSegments
        self.pathSegments_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, indexedAccessHandle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if indexedAccessHandle.subclass:
            return indexedAccessHandle.subclass(*args_, **kwargs_)
        else:
            return indexedAccessHandle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_viewRef(self):
        return self.viewRef
    def set_viewRef(self, viewRef):
        self.viewRef = viewRef
    def add_viewRef(self, value):
        self.viewRef.append(value)
    def insert_viewRef_at(self, index, value):
        self.viewRef.insert(index, value)
    def replace_viewRef_at(self, index, value):
        self.viewRef[index] = value
    def get_indices(self):
        return self.indices
    def set_indices(self, indices):
        self.indices = indices
    def get_pathSegments(self):
        return self.pathSegments
    def set_pathSegments(self, pathSegments):
        self.pathSegments = pathSegments
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.viewRef or
            self.indices is not None or
            self.pathSegments is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indexedAccessHandle', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('indexedAccessHandle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'indexedAccessHandle':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='indexedAccessHandle')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='indexedAccessHandle', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='indexedAccessHandle'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indexedAccessHandle', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for viewRef_ in self.viewRef:
            namespaceprefix_ = self.viewRef_nsprefix_ + ':' if (UseCapturedNS_ and self.viewRef_nsprefix_) else ''
            viewRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='viewRef', pretty_print=pretty_print)
        if self.indices is not None:
            namespaceprefix_ = self.indices_nsprefix_ + ':' if (UseCapturedNS_ and self.indices_nsprefix_) else ''
            self.indices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='indices', pretty_print=pretty_print)
        if self.pathSegments is not None:
            namespaceprefix_ = self.pathSegments_nsprefix_ + ':' if (UseCapturedNS_ and self.pathSegments_nsprefix_) else ''
            self.pathSegments.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pathSegments', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'viewRef':
            obj_ = viewRefType4.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.viewRef.append(obj_)
            obj_.original_tagname_ = 'viewRef'
        elif nodeName_ == 'indices':
            obj_ = indicesType5.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.indices = obj_
            obj_.original_tagname_ = 'indices'
        elif nodeName_ == 'pathSegments':
            obj_ = pathSegmentsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pathSegments = obj_
            obj_.original_tagname_ = 'pathSegments'
# end class indexedAccessHandle


class simpleAccessHandle(GeneratedsSuper):
    """viewRef -- A list of views this accessHandle is applicable to. Note this element is optional, if it is not present the accessHandle applies to all views.
    pathSegments -- An ordered list of pathSegment elements. When concatenated with a desired separator the elements in this form a HDL path for the parent slice into the referenced view.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('viewRef', 'viewRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'viewRef', 'type': 'viewRefType6'}, None),
        MemberSpec_('pathSegments', 'pathSegmentsType7', 0, 0, {'name': 'pathSegments', 'type': 'pathSegmentsType7'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, viewRef=None, pathSegments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if viewRef is None:
            self.viewRef = []
        else:
            self.viewRef = viewRef
        self.viewRef_nsprefix_ = "ipxact"
        self.pathSegments = pathSegments
        self.pathSegments_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, simpleAccessHandle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if simpleAccessHandle.subclass:
            return simpleAccessHandle.subclass(*args_, **kwargs_)
        else:
            return simpleAccessHandle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_viewRef(self):
        return self.viewRef
    def set_viewRef(self, viewRef):
        self.viewRef = viewRef
    def add_viewRef(self, value):
        self.viewRef.append(value)
    def insert_viewRef_at(self, index, value):
        self.viewRef.insert(index, value)
    def replace_viewRef_at(self, index, value):
        self.viewRef[index] = value
    def get_pathSegments(self):
        return self.pathSegments
    def set_pathSegments(self, pathSegments):
        self.pathSegments = pathSegments
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.viewRef or
            self.pathSegments is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='simpleAccessHandle', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('simpleAccessHandle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'simpleAccessHandle':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='simpleAccessHandle')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='simpleAccessHandle', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='simpleAccessHandle'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='simpleAccessHandle', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for viewRef_ in self.viewRef:
            namespaceprefix_ = self.viewRef_nsprefix_ + ':' if (UseCapturedNS_ and self.viewRef_nsprefix_) else ''
            viewRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='viewRef', pretty_print=pretty_print)
        if self.pathSegments is not None:
            namespaceprefix_ = self.pathSegments_nsprefix_ + ':' if (UseCapturedNS_ and self.pathSegments_nsprefix_) else ''
            self.pathSegments.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pathSegments', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'viewRef':
            obj_ = viewRefType6.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.viewRef.append(obj_)
            obj_.original_tagname_ = 'viewRef'
        elif nodeName_ == 'pathSegments':
            obj_ = pathSegmentsType7.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pathSegments = obj_
            obj_.original_tagname_ = 'pathSegments'
# end class simpleAccessHandle


class slicesType(GeneratedsSuper):
    """slice -- The HDL path for a slice of the IP-XACT object.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('slice', 'sliceType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'slice', 'type': 'sliceType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, slice=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if slice is None:
            self.slice = []
        else:
            self.slice = slice
        self.slice_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, slicesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if slicesType.subclass:
            return slicesType.subclass(*args_, **kwargs_)
        else:
            return slicesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_slice(self):
        return self.slice
    def set_slice(self, slice):
        self.slice = slice
    def add_slice(self, value):
        self.slice.append(value)
    def insert_slice_at(self, index, value):
        self.slice.insert(index, value)
    def replace_slice_at(self, index, value):
        self.slice[index] = value
    def _hasContent(self):
        if (
            self.slice
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='slicesType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('slicesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'slicesType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='slicesType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='slicesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='slicesType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='slicesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for slice_ in self.slice:
            namespaceprefix_ = self.slice_nsprefix_ + ':' if (UseCapturedNS_ and self.slice_nsprefix_) else ''
            slice_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slice', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'slice':
            obj_ = sliceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.slice.append(obj_)
            obj_.original_tagname_ = 'slice'
# end class slicesType


class sliceType(GeneratedsSuper):
    """pathSegments -- An ordered list of pathSegment elements. When concatenated with a desired separator the elements in this form a HDL path for the
    parent slice into the referenced view.
    range -- A range to be applied to the concatenation of the above path segments
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('pathSegments', 'pathSegmentsType8', 0, 0, {'name': 'pathSegments', 'type': 'pathSegmentsType8'}, None),
        MemberSpec_('Range', 'range', 0, 1, {'minOccurs': '0', 'name': 'range', 'ref': 'range', 'type': 'range'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, pathSegments=None, Range=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.pathSegments = pathSegments
        self.pathSegments_nsprefix_ = "ipxact"
        self.Range = Range
        self.Range_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sliceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sliceType.subclass:
            return sliceType.subclass(*args_, **kwargs_)
        else:
            return sliceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_pathSegments(self):
        return self.pathSegments
    def set_pathSegments(self, pathSegments):
        self.pathSegments = pathSegments
    def get_range(self):
        return self.Range
    def set_range(self, Range):
        self.Range = Range
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.pathSegments is not None or
            self.Range is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='sliceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sliceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sliceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sliceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='sliceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='sliceType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='sliceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pathSegments is not None:
            namespaceprefix_ = self.pathSegments_nsprefix_ + ':' if (UseCapturedNS_ and self.pathSegments_nsprefix_) else ''
            self.pathSegments.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pathSegments', pretty_print=pretty_print)
        if self.Range is not None:
            namespaceprefix_ = self.Range_nsprefix_ + ':' if (UseCapturedNS_ and self.Range_nsprefix_) else ''
            self.Range.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='range', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'pathSegments':
            obj_ = pathSegmentsType8.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pathSegments = obj_
            obj_.original_tagname_ = 'pathSegments'
        elif nodeName_ == 'range':
            obj_ = Range.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Range = obj_
            obj_.original_tagname_ = 'range'
# end class sliceType


class pathSegmentType(GeneratedsSuper):
    """pathSegmentName -- One section of a HDL path
    indices -- Specifies a multi-dimensional index into pathSegementName
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('pathSegmentName', 'xs:string', 0, 0, {'name': 'pathSegmentName', 'type': 'xs:string'}, None),
        MemberSpec_('indices', 'indicesType', 0, 1, {'minOccurs': '0', 'name': 'indices', 'type': 'indicesType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, pathSegmentName=None, indices=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.pathSegmentName = pathSegmentName
        self.pathSegmentName_nsprefix_ = "ipxact"
        self.indices = indices
        self.indices_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pathSegmentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pathSegmentType.subclass:
            return pathSegmentType.subclass(*args_, **kwargs_)
        else:
            return pathSegmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_pathSegmentName(self):
        return self.pathSegmentName
    def set_pathSegmentName(self, pathSegmentName):
        self.pathSegmentName = pathSegmentName
    def get_indices(self):
        return self.indices
    def set_indices(self, indices):
        self.indices = indices
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.pathSegmentName is not None or
            self.indices is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='pathSegmentType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pathSegmentType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'pathSegmentType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pathSegmentType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='pathSegmentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='pathSegmentType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='pathSegmentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pathSegmentName is not None:
            namespaceprefix_ = self.pathSegmentName_nsprefix_ + ':' if (UseCapturedNS_ and self.pathSegmentName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spathSegmentName>%s</%spathSegmentName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pathSegmentName), input_name='pathSegmentName')), namespaceprefix_ , eol_))
        if self.indices is not None:
            namespaceprefix_ = self.indices_nsprefix_ + ':' if (UseCapturedNS_ and self.indices_nsprefix_) else ''
            self.indices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='indices', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'pathSegmentName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pathSegmentName')
            value_ = self.gds_validate_string(value_, node, 'pathSegmentName')
            self.pathSegmentName = value_
            self.pathSegmentName_nsprefix_ = child_.prefix
        elif nodeName_ == 'indices':
            obj_ = indicesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.indices = obj_
            obj_.original_tagname_ = 'indices'
# end class pathSegmentType


class parameterBaseType(GeneratedsSuper):
    """name -- Unique name
    value -- The value of the parameter.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('parameterId', 'xs:Name', 0, 1, {'use': 'optional', 'name': 'parameterId'}),
        MemberSpec_('prompt', 'xs:string', 0, 1, {'use': 'optional', 'name': 'prompt'}),
        MemberSpec_('choiceRef', 'xs:Name', 0, 1, {'use': 'optional', 'name': 'choiceRef'}),
        MemberSpec_('order', 'xs:float', 0, 1, {'use': 'optional', 'name': 'order'}),
        MemberSpec_('configGroups', 'xs:NMTOKENS', 0, 1, {'use': 'optional', 'name': 'configGroups'}),
        MemberSpec_('minimum', 'xs:string', 0, 1, {'use': 'optional', 'name': 'minimum'}),
        MemberSpec_('maximum', 'xs:string', 0, 1, {'use': 'optional', 'name': 'maximum'}),
        MemberSpec_('type_', 'ipxact:formatType', 0, 1, {'use': 'optional', 'name': 'type_'}),
        MemberSpec_('sign', 'ipxact:signType', 0, 1, {'use': 'optional', 'name': 'sign'}),
        MemberSpec_('prefix', 'prefixType', 0, 1, {'use': 'optional', 'name': 'prefix'}),
        MemberSpec_('unit', 'unitType', 0, 1, {'use': 'optional', 'name': 'unit'}),
        MemberSpec_('name', 'xs:string', 0, 0, {'name': 'name', 'type': 'xs:string'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('Vectors', 'vectors', 0, 1, {'minOccurs': '0', 'name': 'vectors', 'ref': 'vectors', 'type': 'vectors'}, None),
        MemberSpec_('arrays', 'configurableArrays', 0, 1, {'minOccurs': '0', 'name': 'arrays', 'type': 'configurableArrays'}, None),
        MemberSpec_('value', 'stringExpression', 0, 0, {'name': 'value', 'type': 'complexBaseExpression'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, parameterId=None, prompt=None, choiceRef=None, order=None, configGroups=None, minimum=None, maximum=None, type_='string', sign=None, prefix=None, unit=None, name=None, displayName=None, description=None, Vectors=None, arrays=None, value=None, vendorExtensions=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.parameterId = _cast(None, parameterId)
        self.parameterId_nsprefix_ = None
        self.prompt = _cast(None, prompt)
        self.prompt_nsprefix_ = None
        self.choiceRef = _cast(None, choiceRef)
        self.choiceRef_nsprefix_ = None
        self.order = _cast(float, order)
        self.order_nsprefix_ = None
        self.configGroups = _cast(None, configGroups)
        self.configGroups_nsprefix_ = None
        self.minimum = _cast(None, minimum)
        self.minimum_nsprefix_ = None
        self.maximum = _cast(None, maximum)
        self.maximum_nsprefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.sign = _cast(None, sign)
        self.sign_nsprefix_ = None
        self.prefix = _cast(None, prefix)
        self.prefix_nsprefix_ = None
        self.unit = _cast(None, unit)
        self.unit_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.Vectors = Vectors
        self.Vectors_nsprefix_ = "ipxact"
        self.arrays = arrays
        self.arrays_nsprefix_ = "ipxact"
        self.value = value
        self.value_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, parameterBaseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if parameterBaseType.subclass:
            return parameterBaseType.subclass(*args_, **kwargs_)
        else:
            return parameterBaseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_vectors(self):
        return self.Vectors
    def set_vectors(self, Vectors):
        self.Vectors = Vectors
    def get_arrays(self):
        return self.arrays
    def set_arrays(self, arrays):
        self.arrays = arrays
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_parameterId(self):
        return self.parameterId
    def set_parameterId(self, parameterId):
        self.parameterId = parameterId
    def get_prompt(self):
        return self.prompt
    def set_prompt(self, prompt):
        self.prompt = prompt
    def get_choiceRef(self):
        return self.choiceRef
    def set_choiceRef(self, choiceRef):
        self.choiceRef = choiceRef
    def get_order(self):
        return self.order
    def set_order(self, order):
        self.order = order
    def get_configGroups(self):
        return self.configGroups
    def set_configGroups(self, configGroups):
        self.configGroups = configGroups
    def get_minimum(self):
        return self.minimum
    def set_minimum(self, minimum):
        self.minimum = minimum
    def get_maximum(self):
        return self.maximum
    def set_maximum(self, maximum):
        self.maximum = maximum
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_sign(self):
        return self.sign
    def set_sign(self, sign):
        self.sign = sign
    def get_prefix(self):
        return self.prefix
    def set_prefix(self, prefix):
        self.prefix = prefix
    def get_unit(self):
        return self.unit
    def set_unit(self, unit):
        self.unit = unit
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_formatType(self, value):
        # Validate type ipxact:formatType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['bit', 'byte', 'shortint', 'int', 'longint', 'shortreal', 'real', 'string']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on formatType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_signType(self, value):
        # Validate type ipxact:signType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['signed', 'unsigned']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on signType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_prefixType(self, value):
        # Validate type prefixType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['deca', 'hecto', 'kilo', 'mega', 'giga', 'tera', 'peta', 'exa', 'zetta', 'yotta', 'deci', 'centi', 'milli', 'micro', 'nano', 'pico', 'femto', 'atto', 'zepto', 'yocto']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on prefixType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_unitType(self, value):
        # Validate type unitType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['second', 'ampere', 'kelvin', 'hertz', 'joule', 'watt', 'coulomb', 'volt', 'farad', 'ohm', 'siemens', 'henry', 'Celsius']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on unitType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.Vectors is not None or
            self.arrays is not None or
            self.value is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='parameterBaseType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('parameterBaseType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'parameterBaseType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='parameterBaseType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='parameterBaseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='parameterBaseType'):
        if self.parameterId is not None and 'parameterId' not in already_processed:
            already_processed.add('parameterId')
            outfile.write(' parameterId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.parameterId), input_name='parameterId')), ))
        if self.prompt is not None and 'prompt' not in already_processed:
            already_processed.add('prompt')
            outfile.write(' prompt=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prompt), input_name='prompt')), ))
        if self.choiceRef is not None and 'choiceRef' not in already_processed:
            already_processed.add('choiceRef')
            outfile.write(' choiceRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.choiceRef), input_name='choiceRef')), ))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_float(self.order, input_name='order'))
        if self.configGroups is not None and 'configGroups' not in already_processed:
            already_processed.add('configGroups')
            outfile.write(' configGroups=%s' % (quote_attrib(self.configGroups), ))
        if self.minimum is not None and 'minimum' not in already_processed:
            already_processed.add('minimum')
            outfile.write(' minimum=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.minimum), input_name='minimum')), ))
        if self.maximum is not None and 'maximum' not in already_processed:
            already_processed.add('maximum')
            outfile.write(' maximum=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.maximum), input_name='maximum')), ))
        if self.type_ != "string" and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
        if self.sign is not None and 'sign' not in already_processed:
            already_processed.add('sign')
            outfile.write(' sign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.sign), input_name='sign')), ))
        if self.prefix is not None and 'prefix' not in already_processed:
            already_processed.add('prefix')
            outfile.write(' prefix=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prefix), input_name='prefix')), ))
        if self.unit is not None and 'unit' not in already_processed:
            already_processed.add('unit')
            outfile.write(' unit=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.unit), input_name='unit')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='parameterBaseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.Vectors is not None:
            namespaceprefix_ = self.Vectors_nsprefix_ + ':' if (UseCapturedNS_ and self.Vectors_nsprefix_) else ''
            self.Vectors.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vectors', pretty_print=pretty_print)
        if self.arrays is not None:
            namespaceprefix_ = self.arrays_nsprefix_ + ':' if (UseCapturedNS_ and self.arrays_nsprefix_) else ''
            self.arrays.export(outfile, level, namespaceprefix_, namespacedef_='', name_='arrays', pretty_print=pretty_print)
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('parameterId', node)
        if value is not None and 'parameterId' not in already_processed:
            already_processed.add('parameterId')
            self.parameterId = value
        value = find_attr_value_('prompt', node)
        if value is not None and 'prompt' not in already_processed:
            already_processed.add('prompt')
            self.prompt = value
        value = find_attr_value_('choiceRef', node)
        if value is not None and 'choiceRef' not in already_processed:
            already_processed.add('choiceRef')
            self.choiceRef = value
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            value = self.gds_parse_float(value, node, 'order')
            self.order = value
        value = find_attr_value_('configGroups', node)
        if value is not None and 'configGroups' not in already_processed:
            already_processed.add('configGroups')
            self.configGroups = value
        value = find_attr_value_('minimum', node)
        if value is not None and 'minimum' not in already_processed:
            already_processed.add('minimum')
            self.minimum = value
        value = find_attr_value_('maximum', node)
        if value is not None and 'maximum' not in already_processed:
            already_processed.add('maximum')
            self.maximum = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
            self.validate_formatType(self.type_)    # validate type formatType
        value = find_attr_value_('sign', node)
        if value is not None and 'sign' not in already_processed:
            already_processed.add('sign')
            self.sign = value
            self.sign = ' '.join(self.sign.split())
            self.validate_signType(self.sign)    # validate type signType
        value = find_attr_value_('prefix', node)
        if value is not None and 'prefix' not in already_processed:
            already_processed.add('prefix')
            self.prefix = value
            self.validate_prefixType(self.prefix)    # validate type prefixType
        value = find_attr_value_('unit', node)
        if value is not None and 'unit' not in already_processed:
            already_processed.add('unit')
            self.unit = value
            self.validate_unitType(self.unit)    # validate type unitType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'vectors':
            obj_ = Vectors.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Vectors = obj_
            obj_.original_tagname_ = 'vectors'
        elif nodeName_ == 'arrays':
            obj_ = configurableArrays.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.arrays = obj_
            obj_.original_tagname_ = 'arrays'
        elif nodeName_ == 'value':
            class_obj_ = self.get_class_obj_(child_, complexBaseExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class parameterBaseType


class parameterType(parameterBaseType):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('resolve', 'resolveType', 0, 1, {'use': 'optional', 'name': 'resolve'}),
    ]
    subclass = None
    superclass = parameterBaseType
    def __init__(self, parameterId=None, prompt=None, choiceRef=None, order=None, configGroups=None, minimum=None, maximum=None, type_='string', sign=None, prefix=None, unit=None, name=None, displayName=None, description=None, Vectors=None, arrays=None, value=None, vendorExtensions=None, resolve='immediate', extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        super(globals().get("parameterType"), self).__init__(parameterId, prompt, choiceRef, order, configGroups, minimum, maximum, type_, sign, prefix, unit, name, displayName, description, Vectors, arrays, value, vendorExtensions, extensiontype_,  **kwargs_)
        self.resolve = _cast(None, resolve)
        self.resolve_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, parameterType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if parameterType.subclass:
            return parameterType.subclass(*args_, **kwargs_)
        else:
            return parameterType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_resolve(self):
        return self.resolve
    def set_resolve(self, resolve):
        self.resolve = resolve
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_resolveType(self, value):
        # Validate type resolveType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['immediate', 'user', 'generated']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on resolveType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            super(parameterType, self)._hasContent()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='parameterType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('parameterType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'parameterType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='parameterType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='parameterType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='parameterType'):
        super(parameterType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='parameterType')
        if self.resolve != "immediate" and 'resolve' not in already_processed:
            already_processed.add('resolve')
            outfile.write(' resolve=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.resolve), input_name='resolve')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='parameterType', fromsubclass_=False, pretty_print=True):
        super(parameterType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('resolve', node)
        if value is not None and 'resolve' not in already_processed:
            already_processed.add('resolve')
            self.resolve = value
            self.resolve = ' '.join(self.resolve.split())
            self.validate_resolveType(self.resolve)    # validate type resolveType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(parameterType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(parameterType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class parameterType


class nameValuePairType(GeneratedsSuper):
    """name -- Unique name
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:string', 0, 0, {'name': 'name', 'type': 'xs:string'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('value', 'stringExpression', 0, 0, {'name': 'value', 'ref': 'value', 'type': 'value'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, value=None, vendorExtensions=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.value = value
        self.value_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, nameValuePairType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if nameValuePairType.subclass:
            return nameValuePairType.subclass(*args_, **kwargs_)
        else:
            return nameValuePairType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.value is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='nameValuePairType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('nameValuePairType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'nameValuePairType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='nameValuePairType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='nameValuePairType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='nameValuePairType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='nameValuePairType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'value':
            class_obj_ = self.get_class_obj_(child_, stringExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class nameValuePairType


class Vector(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('left', 'unsignedIntExpression', 0, 0, {'name': 'left', 'ref': 'left', 'type': 'left'}, None),
        MemberSpec_('right', 'unsignedIntExpression', 0, 0, {'name': 'right', 'ref': 'right', 'type': 'right'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, left=None, right=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.left = left
        self.left_nsprefix_ = "ipxact"
        self.right = right
        self.right_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Vector)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Vector.subclass:
            return Vector.subclass(*args_, **kwargs_)
        else:
            return Vector(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_left(self):
        return self.left
    def set_left(self, left):
        self.left = left
    def get_right(self):
        return self.right
    def set_right(self, right):
        self.right = right
    def _hasContent(self):
        if (
            self.left is not None or
            self.right is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='vector', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vector')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'vector':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vector')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vector', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='vector'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='vector', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.left is not None:
            namespaceprefix_ = self.left_nsprefix_ + ':' if (UseCapturedNS_ and self.left_nsprefix_) else ''
            self.left.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='left', pretty_print=pretty_print)
        if self.right is not None:
            namespaceprefix_ = self.right_nsprefix_ + ':' if (UseCapturedNS_ and self.right_nsprefix_) else ''
            self.right.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='right', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'left':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.left = obj_
            obj_.original_tagname_ = 'left'
        elif nodeName_ == 'right':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.right = obj_
            obj_.original_tagname_ = 'right'
# end class Vector


class Vectors(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Vector', 'vector', 1, 0, {'maxOccurs': 'unbounded', 'name': 'vector', 'ref': 'vector', 'type': 'vector'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Vector=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if Vector is None:
            self.Vector = []
        else:
            self.Vector = Vector
        self.Vector_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Vectors)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Vectors.subclass:
            return Vectors.subclass(*args_, **kwargs_)
        else:
            return Vectors(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vector(self):
        return self.Vector
    def set_vector(self, Vector):
        self.Vector = Vector
    def add_vector(self, value):
        self.Vector.append(value)
    def insert_vector_at(self, index, value):
        self.Vector.insert(index, value)
    def replace_vector_at(self, index, value):
        self.Vector[index] = value
    def _hasContent(self):
        if (
            self.Vector
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='vectors', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vectors')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'vectors':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vectors')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vectors', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='vectors'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='vectors', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vector_ in self.Vector:
            namespaceprefix_ = self.Vector_nsprefix_ + ':' if (UseCapturedNS_ and self.Vector_nsprefix_) else ''
            vector_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vector', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vector':
            obj_ = Vector.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Vector.append(obj_)
            obj_.original_tagname_ = 'vector'
# end class Vectors


class Range(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('left', 'unsignedIntExpression', 0, 0, {'name': 'left', 'ref': 'left', 'type': 'left'}, None),
        MemberSpec_('right', 'unsignedIntExpression', 0, 0, {'name': 'right', 'ref': 'right', 'type': 'right'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, left=None, right=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.left = left
        self.left_nsprefix_ = "ipxact"
        self.right = right
        self.right_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Range)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Range.subclass:
            return Range.subclass(*args_, **kwargs_)
        else:
            return Range(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_left(self):
        return self.left
    def set_left(self, left):
        self.left = left
    def get_right(self):
        return self.right
    def set_right(self, right):
        self.right = right
    def _hasContent(self):
        if (
            self.left is not None or
            self.right is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='range', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('range')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'range':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='range')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='range', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='range'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='range', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.left is not None:
            namespaceprefix_ = self.left_nsprefix_ + ':' if (UseCapturedNS_ and self.left_nsprefix_) else ''
            self.left.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='left', pretty_print=pretty_print)
        if self.right is not None:
            namespaceprefix_ = self.right_nsprefix_ + ':' if (UseCapturedNS_ and self.right_nsprefix_) else ''
            self.right.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='right', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'left':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.left = obj_
            obj_.original_tagname_ = 'left'
        elif nodeName_ == 'right':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.right = obj_
            obj_.original_tagname_ = 'right'
# end class Range


class PartSelect(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('indices', 'indicesType', 0, 0, {'name': 'indices', 'type': 'indicesType'}, 5),
        MemberSpec_('Range', 'range', 0, 1, {'minOccurs': '0', 'name': 'range', 'ref': 'range', 'type': 'range'}, 5),
    ]
    subclass = None
    superclass = None
    def __init__(self, indices=None, Range=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.indices = indices
        self.indices_nsprefix_ = "ipxact"
        self.Range = Range
        self.Range_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PartSelect)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PartSelect.subclass:
            return PartSelect.subclass(*args_, **kwargs_)
        else:
            return PartSelect(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_indices(self):
        return self.indices
    def set_indices(self, indices):
        self.indices = indices
    def get_range(self):
        return self.Range
    def set_range(self, Range):
        self.Range = Range
    def _hasContent(self):
        if (
            self.indices is not None or
            self.Range is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='partSelect', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('partSelect')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'partSelect':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='partSelect')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='partSelect', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='partSelect'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='partSelect', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.indices is not None:
            namespaceprefix_ = self.indices_nsprefix_ + ':' if (UseCapturedNS_ and self.indices_nsprefix_) else ''
            self.indices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='indices', pretty_print=pretty_print)
        if self.Range is not None:
            namespaceprefix_ = self.Range_nsprefix_ + ':' if (UseCapturedNS_ and self.Range_nsprefix_) else ''
            self.Range.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='range', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'indices':
            obj_ = indicesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.indices = obj_
            obj_.original_tagname_ = 'indices'
        elif nodeName_ == 'range':
            obj_ = Range.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Range = obj_
            obj_.original_tagname_ = 'range'
# end class PartSelect


class configurableArrays(GeneratedsSuper):
    """array -- Specific left and right array bounds.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('array', 'arrayType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'array', 'type': 'arrayType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, array=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if array is None:
            self.array = []
        else:
            self.array = array
        self.array_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, configurableArrays)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if configurableArrays.subclass:
            return configurableArrays.subclass(*args_, **kwargs_)
        else:
            return configurableArrays(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_array(self):
        return self.array
    def set_array(self, array):
        self.array = array
    def add_array(self, value):
        self.array.append(value)
    def insert_array_at(self, index, value):
        self.array.insert(index, value)
    def replace_array_at(self, index, value):
        self.array[index] = value
    def _hasContent(self):
        if (
            self.array
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableArrays', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('configurableArrays')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'configurableArrays':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='configurableArrays')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='configurableArrays', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='configurableArrays'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='configurableArrays', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for array_ in self.array:
            namespaceprefix_ = self.array_nsprefix_ + ':' if (UseCapturedNS_ and self.array_nsprefix_) else ''
            array_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='array', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'array':
            obj_ = arrayType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.array.append(obj_)
            obj_.original_tagname_ = 'array'
# end class configurableArrays


class indicesType(GeneratedsSuper):
    """index -- An index into an object in the referenced view.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('index', 'unsignedIntExpression', 1, 0, {'maxOccurs': 'unbounded', 'name': 'index', 'type': 'unsignedIntExpression'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, index=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if index is None:
            self.index = []
        else:
            self.index = index
        self.index_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, indicesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if indicesType.subclass:
            return indicesType.subclass(*args_, **kwargs_)
        else:
            return indicesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_index(self):
        return self.index
    def set_index(self, index):
        self.index = index
    def add_index(self, value):
        self.index.append(value)
    def insert_index_at(self, index, value):
        self.index.insert(index, value)
    def replace_index_at(self, index, value):
        self.index[index] = value
    def _hasContent(self):
        if (
            self.index
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indicesType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('indicesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'indicesType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='indicesType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='indicesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='indicesType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indicesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for index_ in self.index:
            namespaceprefix_ = self.index_nsprefix_ + ':' if (UseCapturedNS_ and self.index_nsprefix_) else ''
            index_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='index', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'index':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.index.append(obj_)
            obj_.original_tagname_ = 'index'
# end class indicesType


class Port(GeneratedsSuper):
    """name -- Unique name
    wire -- Defines a port whose type resolves to simple bits.
    transactional -- Defines a port that implements or uses a service that can be implemented with functions or methods.
    access -- Port access characteristics.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', ['portName', 'xs:string'], 0, 0, {'name': 'name', 'type': 'xs:string'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('wire', 'portWireType', 0, 0, {'name': 'wire', 'type': 'portWireType'}, 6),
        MemberSpec_('transactional', 'portTransactionalType', 0, 0, {'name': 'transactional', 'type': 'portTransactionalType'}, 6),
        MemberSpec_('arrays', 'configurableArrays', 0, 1, {'minOccurs': '0', 'name': 'arrays', 'ref': 'arrays', 'type': 'arrays'}, None),
        MemberSpec_('access', 'accessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'type': 'portAccessType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, isPresent=None, wire=None, transactional=None, arrays=None, access=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.validate_portName(self.name)
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.wire = wire
        self.wire_nsprefix_ = "ipxact"
        self.transactional = transactional
        self.transactional_nsprefix_ = "ipxact"
        self.arrays = arrays
        self.arrays_nsprefix_ = "ipxact"
        self.access = access
        self.access_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Port)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Port.subclass:
            return Port.subclass(*args_, **kwargs_)
        else:
            return Port(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_wire(self):
        return self.wire
    def set_wire(self, wire):
        self.wire = wire
    def get_transactional(self):
        return self.transactional
    def set_transactional(self, transactional):
        self.transactional = transactional
    def get_arrays(self):
        return self.arrays
    def set_arrays(self, arrays):
        self.arrays = arrays
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_portName(self, value):
        result = True
        # Validate type portName, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_portName_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_portName_patterns_, ))
                result = False
        return result
    validate_portName_patterns_ = [['^([A-Za-z0-9\\.\\-:_]*)$']]
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.wire is not None or
            self.transactional is not None or
            self.arrays is not None or
            self.access is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('portType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'portType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='portType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='portType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='portType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.wire is not None:
            namespaceprefix_ = self.wire_nsprefix_ + ':' if (UseCapturedNS_ and self.wire_nsprefix_) else ''
            self.wire.export(outfile, level, namespaceprefix_, namespacedef_='', name_='wire', pretty_print=pretty_print)
        if self.transactional is not None:
            namespaceprefix_ = self.transactional_nsprefix_ + ':' if (UseCapturedNS_ and self.transactional_nsprefix_) else ''
            self.transactional.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transactional', pretty_print=pretty_print)
        if self.arrays is not None:
            namespaceprefix_ = self.arrays_nsprefix_ + ':' if (UseCapturedNS_ and self.arrays_nsprefix_) else ''
            self.arrays.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='arrays', pretty_print=pretty_print)
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_, namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
            # validate type portName
            self.validate_portName(self.name)
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'wire':
            obj_ = PortWire.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.wire = obj_
            obj_.original_tagname_ = 'wire'
        elif nodeName_ == 'transactional':
            obj_ = portTransactionalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transactional = obj_
            obj_.original_tagname_ = 'transactional'
        elif nodeName_ == 'arrays':
            obj_ = configurableArrays.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.arrays = obj_
            obj_.original_tagname_ = 'arrays'
        elif nodeName_ == 'access':
            obj_ = portAccessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class Port


class abstractorPortType(GeneratedsSuper):
    """name -- Unique name
    wire -- Defines a port whose type resolves to simple bits.
    transactional -- Defines a port that implements or uses a service that can be implemented with functions or methods.
    access -- Port access characteristics.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', ['portName', 'xs:string'], 0, 0, {'name': 'name', 'type': 'xs:string'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('wire', 'abstractorPortWireType', 0, 0, {'name': 'wire', 'type': 'abstractorPortWireType'}, 7),
        MemberSpec_('transactional', 'portTransactionalType', 0, 0, {'name': 'transactional', 'type': 'portTransactionalType'}, 7),
        MemberSpec_('access', 'accessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'type': 'portAccessType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, isPresent=None, wire=None, transactional=None, access=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.validate_portName(self.name)
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.wire = wire
        self.wire_nsprefix_ = "ipxact"
        self.transactional = transactional
        self.transactional_nsprefix_ = "ipxact"
        self.access = access
        self.access_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, abstractorPortType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if abstractorPortType.subclass:
            return abstractorPortType.subclass(*args_, **kwargs_)
        else:
            return abstractorPortType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_wire(self):
        return self.wire
    def set_wire(self, wire):
        self.wire = wire
    def get_transactional(self):
        return self.transactional
    def set_transactional(self, transactional):
        self.transactional = transactional
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_portName(self, value):
        result = True
        # Validate type portName, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_portName_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_portName_patterns_, ))
                result = False
        return result
    validate_portName_patterns_ = [['^([A-Za-z0-9\\.\\-:_]*)$']]
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.wire is not None or
            self.transactional is not None or
            self.access is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorPortType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractorPortType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractorPortType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractorPortType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractorPortType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractorPortType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorPortType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.wire is not None:
            namespaceprefix_ = self.wire_nsprefix_ + ':' if (UseCapturedNS_ and self.wire_nsprefix_) else ''
            self.wire.export(outfile, level, namespaceprefix_, namespacedef_='', name_='wire', pretty_print=pretty_print)
        if self.transactional is not None:
            namespaceprefix_ = self.transactional_nsprefix_ + ':' if (UseCapturedNS_ and self.transactional_nsprefix_) else ''
            self.transactional.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transactional', pretty_print=pretty_print)
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_, namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
            # validate type portName
            self.validate_portName(self.name)
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'wire':
            obj_ = abstractorPortWireType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.wire = obj_
            obj_.original_tagname_ = 'wire'
        elif nodeName_ == 'transactional':
            obj_ = portTransactionalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transactional = obj_
            obj_.original_tagname_ = 'transactional'
        elif nodeName_ == 'access':
            obj_ = portAccessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class abstractorPortType


class protocol(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('protocolType', 'protocolTypeType9', 0, 0, {'name': 'protocolType', 'type': 'protocolTypeType9'}, None),
        MemberSpec_('payload', 'payload', 0, 1, {'minOccurs': '0', 'name': 'payload', 'ref': 'payload', 'type': 'payload'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, protocolType=None, payload=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.protocolType = protocolType
        self.protocolType_nsprefix_ = "ipxact"
        self.payload = payload
        self.payload_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, protocol)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if protocol.subclass:
            return protocol.subclass(*args_, **kwargs_)
        else:
            return protocol(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_protocolType(self):
        return self.protocolType
    def set_protocolType(self, protocolType):
        self.protocolType = protocolType
    def get_payload(self):
        return self.payload
    def set_payload(self, payload):
        self.payload = payload
    def _hasContent(self):
        if (
            self.protocolType is not None or
            self.payload is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='protocol', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('protocol')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'protocol':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='protocol')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='protocol', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='protocol'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='protocol', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.protocolType is not None:
            namespaceprefix_ = self.protocolType_nsprefix_ + ':' if (UseCapturedNS_ and self.protocolType_nsprefix_) else ''
            self.protocolType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protocolType', pretty_print=pretty_print)
        if self.payload is not None:
            namespaceprefix_ = self.payload_nsprefix_ + ':' if (UseCapturedNS_ and self.payload_nsprefix_) else ''
            self.payload.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='payload', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'protocolType':
            obj_ = protocolTypeType9.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protocolType = obj_
            obj_.original_tagname_ = 'protocolType'
        elif nodeName_ == 'payload':
            obj_ = payload.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.payload = obj_
            obj_.original_tagname_ = 'payload'
# end class protocol


class kind(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('custom', 'xs:string', 0, 1, {'use': 'optional', 'name': 'custom'}),
        MemberSpec_('valueOf_', ['kindType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, custom=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.custom = _cast(None, custom)
        self.custom_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, kind)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if kind.subclass:
            return kind.subclass(*args_, **kwargs_)
        else:
            return kind(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_custom(self):
        return self.custom
    def set_custom(self, custom):
        self.custom = custom
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_kindType(self, value):
        result = True
        # Validate type kindType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['tlm_port', 'tlm_socket', 'simple_socket', 'multi_socket', 'custom']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on kindType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='kind', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('kind')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'kind':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='kind')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='kind', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='kind'):
        if self.custom is not None and 'custom' not in already_processed:
            already_processed.add('custom')
            outfile.write(' custom=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.custom), input_name='custom')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='kind', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('custom', node)
        if value is not None and 'custom' not in already_processed:
            already_processed.add('custom')
            self.custom = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class kind


class payload(GeneratedsSuper):
    """name -- Defines the name of the payload. For example: TLM2 or TLM1
    type -- Defines the type of the payload.
    extension -- Defines the name of the payload extension. If attribute is not specified, it is by default optional.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'name', 'type': 'xs:string'}, None),
        MemberSpec_('type_', ['typeType', 'xs:string'], 0, 0, {'name': 'type', 'type': 'xs:string'}, None),
        MemberSpec_('extension', 'extensionType', 0, 1, {'minOccurs': '0', 'name': 'extension', 'type': 'extensionType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, type_=None, extension=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.type_ = type_
        self.validate_typeType(self.type_)
        self.type__nsprefix_ = "ipxact"
        self.extension = extension
        self.extension_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, payload)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if payload.subclass:
            return payload.subclass(*args_, **kwargs_)
        else:
            return payload(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_extension(self):
        return self.extension
    def set_extension(self, extension):
        self.extension = extension
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def validate_typeType(self, value):
        result = True
        # Validate type typeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['generic', 'specific']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on typeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.name is not None or
            self.type_ is not None or
            self.extension is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='payload', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('payload')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'payload':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='payload')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='payload', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='payload'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='payload', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), namespaceprefix_ , eol_))
        if self.extension is not None:
            namespaceprefix_ = self.extension_nsprefix_ + ':' if (UseCapturedNS_ and self.extension_nsprefix_) else ''
            self.extension.export(outfile, level, namespaceprefix_, namespacedef_='', name_='extension', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'type')
            value_ = self.gds_validate_string(value_, node, 'type')
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
            # validate type typeType
            self.validate_typeType(self.type_)
        elif nodeName_ == 'extension':
            obj_ = extensionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extension = obj_
            obj_.original_tagname_ = 'extension'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class payload


class typeParameters(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('typeParameter', 'moduleParameterType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'typeParameter', 'ref': 'typeParameter', 'type': 'typeParameter'}, None),
        MemberSpec_('serviceTypeDef', 'serviceTypeDef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'serviceTypeDef', 'ref': 'serviceTypeDef', 'type': 'serviceTypeDef'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, typeParameter=None, serviceTypeDef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if typeParameter is None:
            self.typeParameter = []
        else:
            self.typeParameter = typeParameter
        self.typeParameter_nsprefix_ = "ipxact"
        if serviceTypeDef is None:
            self.serviceTypeDef = []
        else:
            self.serviceTypeDef = serviceTypeDef
        self.serviceTypeDef_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, typeParameters)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if typeParameters.subclass:
            return typeParameters.subclass(*args_, **kwargs_)
        else:
            return typeParameters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_typeParameter(self):
        return self.typeParameter
    def set_typeParameter(self, typeParameter):
        self.typeParameter = typeParameter
    def add_typeParameter(self, value):
        self.typeParameter.append(value)
    def insert_typeParameter_at(self, index, value):
        self.typeParameter.insert(index, value)
    def replace_typeParameter_at(self, index, value):
        self.typeParameter[index] = value
    def get_serviceTypeDef(self):
        return self.serviceTypeDef
    def set_serviceTypeDef(self, serviceTypeDef):
        self.serviceTypeDef = serviceTypeDef
    def add_serviceTypeDef(self, value):
        self.serviceTypeDef.append(value)
    def insert_serviceTypeDef_at(self, index, value):
        self.serviceTypeDef.insert(index, value)
    def replace_serviceTypeDef_at(self, index, value):
        self.serviceTypeDef[index] = value
    def _hasContent(self):
        if (
            self.typeParameter or
            self.serviceTypeDef
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='typeParameters', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('typeParameters')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'typeParameters':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='typeParameters')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='typeParameters', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='typeParameters'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='typeParameters', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for typeParameter_ in self.typeParameter:
            namespaceprefix_ = self.typeParameter_nsprefix_ + ':' if (UseCapturedNS_ and self.typeParameter_nsprefix_) else ''
            typeParameter_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='typeParameter', pretty_print=pretty_print)
        for serviceTypeDef_ in self.serviceTypeDef:
            namespaceprefix_ = self.serviceTypeDef_nsprefix_ + ':' if (UseCapturedNS_ and self.serviceTypeDef_nsprefix_) else ''
            serviceTypeDef_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='serviceTypeDef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'typeParameter':
            obj_ = moduleParameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeParameter.append(obj_)
            obj_.original_tagname_ = 'typeParameter'
        elif nodeName_ == 'serviceTypeDef':
            obj_ = serviceTypeDef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.serviceTypeDef.append(obj_)
            obj_.original_tagname_ = 'serviceTypeDef'
# end class typeParameters


class transTypeDef(GeneratedsSuper):
    """typeName -- The name of the port type. Can be any predefined type such sc_port or sc_export in SystemC or any user-defined type such as tlm_port.
    typeDefinition -- Where the definition of the type is contained. For SystemC and SystemVerilog it is the include file containing the type definition.
    viewRef -- A reference to a view name in the file for which this type applies.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('typeName', 'typeNameType', 0, 1, {'minOccurs': '0', 'name': 'typeName', 'type': 'typeNameType'}, None),
        MemberSpec_('typeDefinition', 'typeDefinitionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'typeDefinition', 'type': 'typeDefinitionType'}, None),
        MemberSpec_('typeParameters', 'typeParameters', 0, 1, {'minOccurs': '0', 'name': 'typeParameters', 'ref': 'typeParameters', 'type': 'typeParameters'}, None),
        MemberSpec_('viewRef', 'viewRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'viewRef', 'type': 'viewRefType10'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, typeName=None, typeDefinition=None, typeParameters=None, viewRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.typeName = typeName
        self.typeName_nsprefix_ = "ipxact"
        if typeDefinition is None:
            self.typeDefinition = []
        else:
            self.typeDefinition = typeDefinition
        self.typeDefinition_nsprefix_ = "ipxact"
        self.typeParameters = typeParameters
        self.typeParameters_nsprefix_ = "ipxact"
        if viewRef is None:
            self.viewRef = []
        else:
            self.viewRef = viewRef
        self.viewRef_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transTypeDef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transTypeDef.subclass:
            return transTypeDef.subclass(*args_, **kwargs_)
        else:
            return transTypeDef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_typeName(self):
        return self.typeName
    def set_typeName(self, typeName):
        self.typeName = typeName
    def get_typeDefinition(self):
        return self.typeDefinition
    def set_typeDefinition(self, typeDefinition):
        self.typeDefinition = typeDefinition
    def add_typeDefinition(self, value):
        self.typeDefinition.append(value)
    def insert_typeDefinition_at(self, index, value):
        self.typeDefinition.insert(index, value)
    def replace_typeDefinition_at(self, index, value):
        self.typeDefinition[index] = value
    def get_typeParameters(self):
        return self.typeParameters
    def set_typeParameters(self, typeParameters):
        self.typeParameters = typeParameters
    def get_viewRef(self):
        return self.viewRef
    def set_viewRef(self, viewRef):
        self.viewRef = viewRef
    def add_viewRef(self, value):
        self.viewRef.append(value)
    def insert_viewRef_at(self, index, value):
        self.viewRef.insert(index, value)
    def replace_viewRef_at(self, index, value):
        self.viewRef[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.typeName is not None or
            self.typeDefinition or
            self.typeParameters is not None or
            self.viewRef
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='transTypeDef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('transTypeDef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'transTypeDef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='transTypeDef')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='transTypeDef', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='transTypeDef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='transTypeDef', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.typeName is not None:
            namespaceprefix_ = self.typeName_nsprefix_ + ':' if (UseCapturedNS_ and self.typeName_nsprefix_) else ''
            self.typeName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeName', pretty_print=pretty_print)
        for typeDefinition_ in self.typeDefinition:
            namespaceprefix_ = self.typeDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.typeDefinition_nsprefix_) else ''
            typeDefinition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeDefinition', pretty_print=pretty_print)
        if self.typeParameters is not None:
            namespaceprefix_ = self.typeParameters_nsprefix_ + ':' if (UseCapturedNS_ and self.typeParameters_nsprefix_) else ''
            self.typeParameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='typeParameters', pretty_print=pretty_print)
        for viewRef_ in self.viewRef:
            namespaceprefix_ = self.viewRef_nsprefix_ + ':' if (UseCapturedNS_ and self.viewRef_nsprefix_) else ''
            viewRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='viewRef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'typeName':
            obj_ = typeNameType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeName = obj_
            obj_.original_tagname_ = 'typeName'
        elif nodeName_ == 'typeDefinition':
            obj_ = typeDefinitionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeDefinition.append(obj_)
            obj_.original_tagname_ = 'typeDefinition'
        elif nodeName_ == 'typeParameters':
            obj_ = typeParameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeParameters = obj_
            obj_.original_tagname_ = 'typeParameters'
        elif nodeName_ == 'viewRef':
            obj_ = viewRefType10.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.viewRef.append(obj_)
            obj_.original_tagname_ = 'viewRef'
# end class transTypeDef


class serviceTypeDef(GeneratedsSuper):
    """typeName -- The name of the service type. Can be any predefined type such as booean or integer or any user-defined type such as addr_type or data_type.
    typeDefinition -- Where the definition of the type is contained if the type if not part of the language. For SystemC and SystemVerilog it is the include file containing the type definition.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('typeName', 'typeNameType11', 0, 0, {'name': 'typeName', 'type': 'typeNameType11'}, None),
        MemberSpec_('typeDefinition', 'typeDefinitionType12', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'typeDefinition', 'type': 'typeDefinitionType12'}, None),
        MemberSpec_('typeParameters', 'typeParameters', 0, 1, {'minOccurs': '0', 'name': 'typeParameters', 'ref': 'typeParameters', 'type': 'typeParameters'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, typeName=None, typeDefinition=None, typeParameters=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.typeName = typeName
        self.typeName_nsprefix_ = "ipxact"
        if typeDefinition is None:
            self.typeDefinition = []
        else:
            self.typeDefinition = typeDefinition
        self.typeDefinition_nsprefix_ = "ipxact"
        self.typeParameters = typeParameters
        self.typeParameters_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, serviceTypeDef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if serviceTypeDef.subclass:
            return serviceTypeDef.subclass(*args_, **kwargs_)
        else:
            return serviceTypeDef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_typeName(self):
        return self.typeName
    def set_typeName(self, typeName):
        self.typeName = typeName
    def get_typeDefinition(self):
        return self.typeDefinition
    def set_typeDefinition(self, typeDefinition):
        self.typeDefinition = typeDefinition
    def add_typeDefinition(self, value):
        self.typeDefinition.append(value)
    def insert_typeDefinition_at(self, index, value):
        self.typeDefinition.insert(index, value)
    def replace_typeDefinition_at(self, index, value):
        self.typeDefinition[index] = value
    def get_typeParameters(self):
        return self.typeParameters
    def set_typeParameters(self, typeParameters):
        self.typeParameters = typeParameters
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.typeName is not None or
            self.typeDefinition or
            self.typeParameters is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='serviceTypeDef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('serviceTypeDef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'serviceTypeDef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='serviceTypeDef')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='serviceTypeDef', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='serviceTypeDef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='serviceTypeDef', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.typeName is not None:
            namespaceprefix_ = self.typeName_nsprefix_ + ':' if (UseCapturedNS_ and self.typeName_nsprefix_) else ''
            self.typeName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeName', pretty_print=pretty_print)
        for typeDefinition_ in self.typeDefinition:
            namespaceprefix_ = self.typeDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.typeDefinition_nsprefix_) else ''
            typeDefinition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeDefinition', pretty_print=pretty_print)
        if self.typeParameters is not None:
            namespaceprefix_ = self.typeParameters_nsprefix_ + ':' if (UseCapturedNS_ and self.typeParameters_nsprefix_) else ''
            self.typeParameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='typeParameters', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'typeName':
            obj_ = typeNameType11.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeName = obj_
            obj_.original_tagname_ = 'typeName'
        elif nodeName_ == 'typeDefinition':
            obj_ = typeDefinitionType12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeDefinition.append(obj_)
            obj_.original_tagname_ = 'typeDefinition'
        elif nodeName_ == 'typeParameters':
            obj_ = typeParameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeParameters = obj_
            obj_.original_tagname_ = 'typeParameters'
# end class serviceTypeDef


class wireTypeDef(GeneratedsSuper):
    """typeName -- The name of the logic type. Examples could be std_logic, std_ulogic, std_logic_vector, sc_logic, ...
    typeDefinition -- Where the definition of the type is contained. For std_logic, this is contained in IEEE.std_logic_1164.all. For sc_logic, this is contained in systemc.h. For VHDL this is the library and package as defined by the "used" statement. For SystemC and SystemVerilog it is the include file required. For verilog this is not needed.
    viewRef -- A reference to a view name in the file for which this type applies.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('typeName', 'typeNameType13', 0, 1, {'minOccurs': '0', 'name': 'typeName', 'type': 'typeNameType13'}, None),
        MemberSpec_('typeDefinition', 'typeDefinitionType14', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'typeDefinition', 'type': 'typeDefinitionType14'}, None),
        MemberSpec_('viewRef', 'viewRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'viewRef', 'type': 'viewRefType15'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, typeName=None, typeDefinition=None, viewRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.typeName = typeName
        self.typeName_nsprefix_ = "ipxact"
        if typeDefinition is None:
            self.typeDefinition = []
        else:
            self.typeDefinition = typeDefinition
        self.typeDefinition_nsprefix_ = "ipxact"
        if viewRef is None:
            self.viewRef = []
        else:
            self.viewRef = viewRef
        self.viewRef_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, wireTypeDef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if wireTypeDef.subclass:
            return wireTypeDef.subclass(*args_, **kwargs_)
        else:
            return wireTypeDef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_typeName(self):
        return self.typeName
    def set_typeName(self, typeName):
        self.typeName = typeName
    def get_typeDefinition(self):
        return self.typeDefinition
    def set_typeDefinition(self, typeDefinition):
        self.typeDefinition = typeDefinition
    def add_typeDefinition(self, value):
        self.typeDefinition.append(value)
    def insert_typeDefinition_at(self, index, value):
        self.typeDefinition.insert(index, value)
    def replace_typeDefinition_at(self, index, value):
        self.typeDefinition[index] = value
    def get_viewRef(self):
        return self.viewRef
    def set_viewRef(self, viewRef):
        self.viewRef = viewRef
    def add_viewRef(self, value):
        self.viewRef.append(value)
    def insert_viewRef_at(self, index, value):
        self.viewRef.insert(index, value)
    def replace_viewRef_at(self, index, value):
        self.viewRef[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.typeName is not None or
            self.typeDefinition or
            self.viewRef
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='wireTypeDef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('wireTypeDef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'wireTypeDef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='wireTypeDef')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='wireTypeDef', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='wireTypeDef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='wireTypeDef', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.typeName is not None:
            namespaceprefix_ = self.typeName_nsprefix_ + ':' if (UseCapturedNS_ and self.typeName_nsprefix_) else ''
            self.typeName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeName', pretty_print=pretty_print)
        for typeDefinition_ in self.typeDefinition:
            namespaceprefix_ = self.typeDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.typeDefinition_nsprefix_) else ''
            typeDefinition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeDefinition', pretty_print=pretty_print)
        for viewRef_ in self.viewRef:
            namespaceprefix_ = self.viewRef_nsprefix_ + ':' if (UseCapturedNS_ and self.viewRef_nsprefix_) else ''
            viewRef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='viewRef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'typeName':
            obj_ = typeNameType13.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeName = obj_
            obj_.original_tagname_ = 'typeName'
        elif nodeName_ == 'typeDefinition':
            obj_ = typeDefinitionType14.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeDefinition.append(obj_)
            obj_.original_tagname_ = 'typeDefinition'
        elif nodeName_ == 'viewRef':
            obj_ = viewRefType15.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.viewRef.append(obj_)
            obj_.original_tagname_ = 'viewRef'
# end class wireTypeDef


class serviceTypeDefs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('serviceTypeDef', 'serviceTypeDef', 1, 0, {'maxOccurs': 'unbounded', 'name': 'serviceTypeDef', 'ref': 'serviceTypeDef', 'type': 'serviceTypeDef'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, serviceTypeDef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if serviceTypeDef is None:
            self.serviceTypeDef = []
        else:
            self.serviceTypeDef = serviceTypeDef
        self.serviceTypeDef_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, serviceTypeDefs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if serviceTypeDefs.subclass:
            return serviceTypeDefs.subclass(*args_, **kwargs_)
        else:
            return serviceTypeDefs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_serviceTypeDef(self):
        return self.serviceTypeDef
    def set_serviceTypeDef(self, serviceTypeDef):
        self.serviceTypeDef = serviceTypeDef
    def add_serviceTypeDef(self, value):
        self.serviceTypeDef.append(value)
    def insert_serviceTypeDef_at(self, index, value):
        self.serviceTypeDef.insert(index, value)
    def replace_serviceTypeDef_at(self, index, value):
        self.serviceTypeDef[index] = value
    def _hasContent(self):
        if (
            self.serviceTypeDef
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='serviceTypeDefs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('serviceTypeDefs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'serviceTypeDefs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='serviceTypeDefs')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='serviceTypeDefs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='serviceTypeDefs'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='serviceTypeDefs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for serviceTypeDef_ in self.serviceTypeDef:
            namespaceprefix_ = self.serviceTypeDef_nsprefix_ + ':' if (UseCapturedNS_ and self.serviceTypeDef_nsprefix_) else ''
            serviceTypeDef_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='serviceTypeDef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'serviceTypeDef':
            obj_ = serviceTypeDef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.serviceTypeDef.append(obj_)
            obj_.original_tagname_ = 'serviceTypeDef'
# end class serviceTypeDefs


class wireTypeDefs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('wireTypeDef', 'wireTypeDef', 1, 0, {'maxOccurs': 'unbounded', 'name': 'wireTypeDef', 'ref': 'wireTypeDef', 'type': 'wireTypeDef'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, wireTypeDef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if wireTypeDef is None:
            self.wireTypeDef = []
        else:
            self.wireTypeDef = wireTypeDef
        self.wireTypeDef_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, wireTypeDefs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if wireTypeDefs.subclass:
            return wireTypeDefs.subclass(*args_, **kwargs_)
        else:
            return wireTypeDefs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_wireTypeDef(self):
        return self.wireTypeDef
    def set_wireTypeDef(self, wireTypeDef):
        self.wireTypeDef = wireTypeDef
    def add_wireTypeDef(self, value):
        self.wireTypeDef.append(value)
    def insert_wireTypeDef_at(self, index, value):
        self.wireTypeDef.insert(index, value)
    def replace_wireTypeDef_at(self, index, value):
        self.wireTypeDef[index] = value
    def _hasContent(self):
        if (
            self.wireTypeDef
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='wireTypeDefs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('wireTypeDefs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'wireTypeDefs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='wireTypeDefs')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='wireTypeDefs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='wireTypeDefs'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='wireTypeDefs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for wireTypeDef_ in self.wireTypeDef:
            namespaceprefix_ = self.wireTypeDef_nsprefix_ + ':' if (UseCapturedNS_ and self.wireTypeDef_nsprefix_) else ''
            wireTypeDef_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='wireTypeDef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'wireTypeDef':
            obj_ = wireTypeDef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.wireTypeDef.append(obj_)
            obj_.original_tagname_ = 'wireTypeDef'
# end class wireTypeDefs


class transTypeDefs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('transTypeDef', 'transTypeDef', 1, 0, {'maxOccurs': 'unbounded', 'name': 'transTypeDef', 'ref': 'transTypeDef', 'type': 'transTypeDef'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, transTypeDef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if transTypeDef is None:
            self.transTypeDef = []
        else:
            self.transTypeDef = transTypeDef
        self.transTypeDef_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transTypeDefs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transTypeDefs.subclass:
            return transTypeDefs.subclass(*args_, **kwargs_)
        else:
            return transTypeDefs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_transTypeDef(self):
        return self.transTypeDef
    def set_transTypeDef(self, transTypeDef):
        self.transTypeDef = transTypeDef
    def add_transTypeDef(self, value):
        self.transTypeDef.append(value)
    def insert_transTypeDef_at(self, index, value):
        self.transTypeDef.insert(index, value)
    def replace_transTypeDef_at(self, index, value):
        self.transTypeDef[index] = value
    def _hasContent(self):
        if (
            self.transTypeDef
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='transTypeDefs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('transTypeDefs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'transTypeDefs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='transTypeDefs')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='transTypeDefs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='transTypeDefs'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='transTypeDefs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for transTypeDef_ in self.transTypeDef:
            namespaceprefix_ = self.transTypeDef_nsprefix_ + ':' if (UseCapturedNS_ and self.transTypeDef_nsprefix_) else ''
            transTypeDef_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='transTypeDef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'transTypeDef':
            obj_ = transTypeDef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transTypeDef.append(obj_)
            obj_.original_tagname_ = 'transTypeDef'
# end class transTypeDefs


class PortWire(GeneratedsSuper):
    """direction -- The direction of a wire style port. The basic directions for a port are 'in' for input ports, 'out' for output port and 'inout' for bidirectional and tristate ports.
    A value of 'phantom' is also allowed and define a port that exist on the IP-XACT component but not on the HDL model.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('allLogicalDirectionsAllowed', 'xs:boolean', 0, 1, {'use': 'optional', 'name': 'allLogicalDirectionsAllowed'}),
        MemberSpec_('direction', ['componentPortDirectionType', 'xs:token'], 0, 0, {'name': 'direction', 'type': 'xs:token'}, None),
        MemberSpec_('Vectors', 'vectors', 0, 1, {'minOccurs': '0', 'name': 'vectors', 'ref': 'vectors', 'type': 'vectors'}, None),
        MemberSpec_('wireTypeDefs', 'wireTypeDefs', 0, 1, {'minOccurs': '0', 'name': 'wireTypeDefs', 'ref': 'wireTypeDefs', 'type': 'wireTypeDefs'}, None),
        MemberSpec_('drivers', 'drivers', 0, 1, {'minOccurs': '0', 'name': 'drivers', 'ref': 'drivers', 'type': 'drivers'}, None),
        MemberSpec_('constraintSets', 'constraintSets', 0, 1, {'minOccurs': '0', 'name': 'constraintSets', 'ref': 'constraintSets', 'type': 'constraintSets'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, allLogicalDirectionsAllowed=False, direction=None, Vectors=None, wireTypeDefs=None, drivers=None, constraintSets=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.allLogicalDirectionsAllowed = _cast(bool, allLogicalDirectionsAllowed)
        self.allLogicalDirectionsAllowed_nsprefix_ = None
        self.direction = direction
        self.validate_componentPortDirectionType(self.direction)
        self.direction_nsprefix_ = "ipxact"
        self.Vectors = Vectors
        self.Vectors_nsprefix_ = "ipxact"
        self.wireTypeDefs = wireTypeDefs
        self.wireTypeDefs_nsprefix_ = "ipxact"
        self.drivers = drivers
        self.drivers_nsprefix_ = "ipxact"
        self.constraintSets = constraintSets
        self.constraintSets_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PortWire)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PortWire.subclass:
            return PortWire.subclass(*args_, **kwargs_)
        else:
            return PortWire(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_direction(self):
        return self.direction
    def set_direction(self, direction):
        self.direction = direction
    def get_vectors(self):
        return self.Vectors
    def set_vectors(self, Vectors):
        self.Vectors = Vectors
    def get_wireTypeDefs(self):
        return self.wireTypeDefs
    def set_wireTypeDefs(self, wireTypeDefs):
        self.wireTypeDefs = wireTypeDefs
    def get_drivers(self):
        return self.drivers
    def set_drivers(self, drivers):
        self.drivers = drivers
    def get_constraintSets(self):
        return self.constraintSets
    def set_constraintSets(self, constraintSets):
        self.constraintSets = constraintSets
    def get_allLogicalDirectionsAllowed(self):
        return self.allLogicalDirectionsAllowed
    def set_allLogicalDirectionsAllowed(self, allLogicalDirectionsAllowed):
        self.allLogicalDirectionsAllowed = allLogicalDirectionsAllowed
    def validate_componentPortDirectionType(self, value):
        result = True
        # Validate type componentPortDirectionType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['in', 'out', 'inout', 'phantom']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on componentPortDirectionType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.direction is not None or
            self.Vectors is not None or
            self.wireTypeDefs is not None or
            self.drivers is not None or
            self.constraintSets is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portWireType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('portWireType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'portWireType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='portWireType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='portWireType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='portWireType'):
        if self.allLogicalDirectionsAllowed and 'allLogicalDirectionsAllowed' not in already_processed:
            already_processed.add('allLogicalDirectionsAllowed')
            outfile.write(' allLogicalDirectionsAllowed="%s"' % self.gds_format_boolean(self.allLogicalDirectionsAllowed, input_name='allLogicalDirectionsAllowed'))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portWireType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.direction is not None:
            namespaceprefix_ = self.direction_nsprefix_ + ':' if (UseCapturedNS_ and self.direction_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdirection>%s</%sdirection>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.direction), input_name='direction')), namespaceprefix_ , eol_))
        if self.Vectors is not None:
            namespaceprefix_ = self.Vectors_nsprefix_ + ':' if (UseCapturedNS_ and self.Vectors_nsprefix_) else ''
            self.Vectors.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vectors', pretty_print=pretty_print)
        if self.wireTypeDefs is not None:
            namespaceprefix_ = self.wireTypeDefs_nsprefix_ + ':' if (UseCapturedNS_ and self.wireTypeDefs_nsprefix_) else ''
            self.wireTypeDefs.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='wireTypeDefs', pretty_print=pretty_print)
        if self.drivers is not None:
            namespaceprefix_ = self.drivers_nsprefix_ + ':' if (UseCapturedNS_ and self.drivers_nsprefix_) else ''
            self.drivers.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='drivers', pretty_print=pretty_print)
        if self.constraintSets is not None:
            namespaceprefix_ = self.constraintSets_nsprefix_ + ':' if (UseCapturedNS_ and self.constraintSets_nsprefix_) else ''
            self.constraintSets.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='constraintSets', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('allLogicalDirectionsAllowed', node)
        if value is not None and 'allLogicalDirectionsAllowed' not in already_processed:
            already_processed.add('allLogicalDirectionsAllowed')
            if value in ('true', '1'):
                self.allLogicalDirectionsAllowed = True
            elif value in ('false', '0'):
                self.allLogicalDirectionsAllowed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'direction':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'direction')
            value_ = self.gds_validate_string(value_, node, 'direction')
            self.direction = value_
            self.direction_nsprefix_ = child_.prefix
            # validate type componentPortDirectionType
            self.validate_componentPortDirectionType(self.direction)
        elif nodeName_ == 'vectors':
            obj_ = Vectors.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Vectors = obj_
            obj_.original_tagname_ = 'vectors'
        elif nodeName_ == 'wireTypeDefs':
            obj_ = wireTypeDefs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.wireTypeDefs = obj_
            obj_.original_tagname_ = 'wireTypeDefs'
        elif nodeName_ == 'drivers':
            obj_ = drivers.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.drivers = obj_
            obj_.original_tagname_ = 'drivers'
        elif nodeName_ == 'constraintSets':
            obj_ = constraintSets.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.constraintSets = obj_
            obj_.original_tagname_ = 'constraintSets'
# end class PortWire


class portTransactionalType(GeneratedsSuper):
    """initiative -- Defines how the port accesses this service.
    kind -- Define the kind of transactional port
    busWidth -- Defines the bus width in bits.This can be the result of an expression.
    protocol -- Defines the protocol type. Defaults to tlm_base_protocol_type for TLM sockets
    transTypeDefs -- Definition of the port type expressed in the default language for this port (i.e. SystemC or SystemV).
    connection -- Bounds number of legal connections.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('allLogicalInitiativesAllowed', 'xs:boolean', 0, 1, {'use': 'optional', 'name': 'allLogicalInitiativesAllowed'}),
        MemberSpec_('initiative', 'initiativeType', 0, 0, {'name': 'initiative', 'ref': 'initiative', 'type': 'initiative'}, None),
        MemberSpec_('kind', 'kind', 0, 1, {'minOccurs': '0', 'name': 'kind', 'ref': 'kind', 'type': 'kind'}, None),
        MemberSpec_('busWidth', 'unsignedIntExpression', 0, 1, {'minOccurs': '0', 'name': 'busWidth', 'ref': 'busWidth', 'type': 'busWidth'}, None),
        MemberSpec_('protocol', 'protocol', 0, 1, {'minOccurs': '0', 'name': 'protocol', 'ref': 'protocol', 'type': 'protocol'}, None),
        MemberSpec_('transTypeDefs', 'transTypeDefs', 0, 1, {'minOccurs': '0', 'name': 'transTypeDefs', 'ref': 'transTypeDefs', 'type': 'transTypeDefs'}, None),
        MemberSpec_('connection', 'connectionType', 0, 1, {'minOccurs': '0', 'name': 'connection', 'type': 'connectionType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, allLogicalInitiativesAllowed=False, initiative=None, kind=None, busWidth=None, protocol=None, transTypeDefs=None, connection=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.allLogicalInitiativesAllowed = _cast(bool, allLogicalInitiativesAllowed)
        self.allLogicalInitiativesAllowed_nsprefix_ = None
        self.initiative = initiative
        self.initiative_nsprefix_ = "ipxact"
        self.kind = kind
        self.kind_nsprefix_ = "ipxact"
        self.busWidth = busWidth
        self.busWidth_nsprefix_ = "ipxact"
        self.protocol = protocol
        self.protocol_nsprefix_ = "ipxact"
        self.transTypeDefs = transTypeDefs
        self.transTypeDefs_nsprefix_ = "ipxact"
        self.connection = connection
        self.connection_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, portTransactionalType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if portTransactionalType.subclass:
            return portTransactionalType.subclass(*args_, **kwargs_)
        else:
            return portTransactionalType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_initiative(self):
        return self.initiative
    def set_initiative(self, initiative):
        self.initiative = initiative
    def get_kind(self):
        return self.kind
    def set_kind(self, kind):
        self.kind = kind
    def get_busWidth(self):
        return self.busWidth
    def set_busWidth(self, busWidth):
        self.busWidth = busWidth
    def get_protocol(self):
        return self.protocol
    def set_protocol(self, protocol):
        self.protocol = protocol
    def get_transTypeDefs(self):
        return self.transTypeDefs
    def set_transTypeDefs(self, transTypeDefs):
        self.transTypeDefs = transTypeDefs
    def get_connection(self):
        return self.connection
    def set_connection(self, connection):
        self.connection = connection
    def get_allLogicalInitiativesAllowed(self):
        return self.allLogicalInitiativesAllowed
    def set_allLogicalInitiativesAllowed(self, allLogicalInitiativesAllowed):
        self.allLogicalInitiativesAllowed = allLogicalInitiativesAllowed
    def _hasContent(self):
        if (
            self.initiative is not None or
            self.kind is not None or
            self.busWidth is not None or
            self.protocol is not None or
            self.transTypeDefs is not None or
            self.connection is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portTransactionalType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('portTransactionalType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'portTransactionalType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='portTransactionalType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='portTransactionalType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='portTransactionalType'):
        if self.allLogicalInitiativesAllowed and 'allLogicalInitiativesAllowed' not in already_processed:
            already_processed.add('allLogicalInitiativesAllowed')
            outfile.write(' allLogicalInitiativesAllowed="%s"' % self.gds_format_boolean(self.allLogicalInitiativesAllowed, input_name='allLogicalInitiativesAllowed'))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portTransactionalType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.initiative is not None:
            namespaceprefix_ = self.initiative_nsprefix_ + ':' if (UseCapturedNS_ and self.initiative_nsprefix_) else ''
            self.initiative.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='initiative', pretty_print=pretty_print)
        if self.kind is not None:
            namespaceprefix_ = self.kind_nsprefix_ + ':' if (UseCapturedNS_ and self.kind_nsprefix_) else ''
            self.kind.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='kind', pretty_print=pretty_print)
        if self.busWidth is not None:
            namespaceprefix_ = self.busWidth_nsprefix_ + ':' if (UseCapturedNS_ and self.busWidth_nsprefix_) else ''
            self.busWidth.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='busWidth', pretty_print=pretty_print)
        if self.protocol is not None:
            namespaceprefix_ = self.protocol_nsprefix_ + ':' if (UseCapturedNS_ and self.protocol_nsprefix_) else ''
            self.protocol.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='protocol', pretty_print=pretty_print)
        if self.transTypeDefs is not None:
            namespaceprefix_ = self.transTypeDefs_nsprefix_ + ':' if (UseCapturedNS_ and self.transTypeDefs_nsprefix_) else ''
            self.transTypeDefs.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='transTypeDefs', pretty_print=pretty_print)
        if self.connection is not None:
            namespaceprefix_ = self.connection_nsprefix_ + ':' if (UseCapturedNS_ and self.connection_nsprefix_) else ''
            self.connection.export(outfile, level, namespaceprefix_, namespacedef_='', name_='connection', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('allLogicalInitiativesAllowed', node)
        if value is not None and 'allLogicalInitiativesAllowed' not in already_processed:
            already_processed.add('allLogicalInitiativesAllowed')
            if value in ('true', '1'):
                self.allLogicalInitiativesAllowed = True
            elif value in ('false', '0'):
                self.allLogicalInitiativesAllowed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'initiative':
            obj_ = initiativeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.initiative = obj_
            obj_.original_tagname_ = 'initiative'
        elif nodeName_ == 'kind':
            obj_ = kind.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.kind = obj_
            obj_.original_tagname_ = 'kind'
        elif nodeName_ == 'busWidth':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.busWidth = obj_
            obj_.original_tagname_ = 'busWidth'
        elif nodeName_ == 'protocol':
            obj_ = protocol.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protocol = obj_
            obj_.original_tagname_ = 'protocol'
        elif nodeName_ == 'transTypeDefs':
            obj_ = transTypeDefs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transTypeDefs = obj_
            obj_.original_tagname_ = 'transTypeDefs'
        elif nodeName_ == 'connection':
            obj_ = connectionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.connection = obj_
            obj_.original_tagname_ = 'connection'
# end class portTransactionalType


class abstractorPortWireType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('direction', ['componentPortDirectionType', 'xs:token'], 0, 0, {'name': 'direction', 'type': 'xs:token'}, None),
        MemberSpec_('Vectors', 'vectors', 0, 1, {'minOccurs': '0', 'name': 'vectors', 'ref': 'vectors', 'type': 'vectors'}, None),
        MemberSpec_('wireTypeDefs', 'wireTypeDefs', 0, 1, {'minOccurs': '0', 'name': 'wireTypeDefs', 'ref': 'wireTypeDefs', 'type': 'wireTypeDefs'}, None),
        MemberSpec_('drivers', 'drivers', 0, 1, {'minOccurs': '0', 'name': 'drivers', 'ref': 'drivers', 'type': 'drivers'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, direction=None, Vectors=None, wireTypeDefs=None, drivers=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.direction = direction
        self.validate_componentPortDirectionType(self.direction)
        self.direction_nsprefix_ = "ipxact"
        self.Vectors = Vectors
        self.Vectors_nsprefix_ = "ipxact"
        self.wireTypeDefs = wireTypeDefs
        self.wireTypeDefs_nsprefix_ = "ipxact"
        self.drivers = drivers
        self.drivers_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, abstractorPortWireType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if abstractorPortWireType.subclass:
            return abstractorPortWireType.subclass(*args_, **kwargs_)
        else:
            return abstractorPortWireType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_direction(self):
        return self.direction
    def set_direction(self, direction):
        self.direction = direction
    def get_vectors(self):
        return self.Vectors
    def set_vectors(self, Vectors):
        self.Vectors = Vectors
    def get_wireTypeDefs(self):
        return self.wireTypeDefs
    def set_wireTypeDefs(self, wireTypeDefs):
        self.wireTypeDefs = wireTypeDefs
    def get_drivers(self):
        return self.drivers
    def set_drivers(self, drivers):
        self.drivers = drivers
    def validate_componentPortDirectionType(self, value):
        result = True
        # Validate type componentPortDirectionType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['in', 'out', 'inout', 'phantom']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on componentPortDirectionType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.direction is not None or
            self.Vectors is not None or
            self.wireTypeDefs is not None or
            self.drivers is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorPortWireType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractorPortWireType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractorPortWireType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractorPortWireType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractorPortWireType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractorPortWireType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorPortWireType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.direction is not None:
            namespaceprefix_ = self.direction_nsprefix_ + ':' if (UseCapturedNS_ and self.direction_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdirection>%s</%sdirection>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.direction), input_name='direction')), namespaceprefix_ , eol_))
        if self.Vectors is not None:
            namespaceprefix_ = self.Vectors_nsprefix_ + ':' if (UseCapturedNS_ and self.Vectors_nsprefix_) else ''
            self.Vectors.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vectors', pretty_print=pretty_print)
        if self.wireTypeDefs is not None:
            namespaceprefix_ = self.wireTypeDefs_nsprefix_ + ':' if (UseCapturedNS_ and self.wireTypeDefs_nsprefix_) else ''
            self.wireTypeDefs.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='wireTypeDefs', pretty_print=pretty_print)
        if self.drivers is not None:
            namespaceprefix_ = self.drivers_nsprefix_ + ':' if (UseCapturedNS_ and self.drivers_nsprefix_) else ''
            self.drivers.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='drivers', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'direction':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'direction')
            value_ = self.gds_validate_string(value_, node, 'direction')
            self.direction = value_
            self.direction_nsprefix_ = child_.prefix
            # validate type componentPortDirectionType
            self.validate_componentPortDirectionType(self.direction)
        elif nodeName_ == 'vectors':
            obj_ = Vectors.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Vectors = obj_
            obj_.original_tagname_ = 'vectors'
        elif nodeName_ == 'wireTypeDefs':
            obj_ = wireTypeDefs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.wireTypeDefs = obj_
            obj_.original_tagname_ = 'wireTypeDefs'
        elif nodeName_ == 'drivers':
            obj_ = drivers.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.drivers = obj_
            obj_.original_tagname_ = 'drivers'
# end class abstractorPortWireType


class portAccessType(GeneratedsSuper):
    """portAccessType -- Indicates how a netlister accesses a port. 'ref' means accessed by reference (default) and 'ptr' means accessed through a pointer.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('portAccessType', 'portAccessType', 0, 1, {'minOccurs': '0', 'name': 'portAccessType', 'ref': 'portAccessType', 'type': 'portAccessType'}, None),
        MemberSpec_('accessHandles', 'accessHandlesType', 0, 1, {'minOccurs': '0', 'name': 'accessHandles', 'type': 'accessHandlesType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, portAccessType_member=None, accessHandles=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.portAccessType = portAccessType_member
        self.portAccessType_nsprefix_ = "ipxact"
        self.accessHandles = accessHandles
        self.accessHandles_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, portAccessType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if portAccessType.subclass:
            return portAccessType.subclass(*args_, **kwargs_)
        else:
            return portAccessType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_portAccessType(self):
        return self.portAccessType
    def set_portAccessType(self, portAccessType):
        self.portAccessType = portAccessType
    def get_accessHandles(self):
        return self.accessHandles
    def set_accessHandles(self, accessHandles):
        self.accessHandles = accessHandles
    def _hasContent(self):
        if (
            self.portAccessType is not None or
            self.accessHandles is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portAccessType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('portAccessType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'portAccessType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='portAccessType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='portAccessType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='portAccessType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='portAccessType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.portAccessType is not None:
            namespaceprefix_ = self.portAccessType_nsprefix_ + ':' if (UseCapturedNS_ and self.portAccessType_nsprefix_) else ''
            self.portAccessType.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='portAccessType', pretty_print=pretty_print)
        if self.accessHandles is not None:
            namespaceprefix_ = self.accessHandles_nsprefix_ + ':' if (UseCapturedNS_ and self.accessHandles_nsprefix_) else ''
            self.accessHandles.export(outfile, level, namespaceprefix_, namespacedef_='', name_='accessHandles', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'portAccessType':
            obj_ = portAccessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.portAccessType = obj_
            obj_.original_tagname_ = 'portAccessType'
        elif nodeName_ == 'accessHandles':
            obj_ = accessHandlesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.accessHandles = obj_
            obj_.original_tagname_ = 'accessHandles'
# end class portAccessType


class otherClocks(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('otherClockDriver', 'otherClockDriver', 1, 0, {'maxOccurs': 'unbounded', 'name': 'otherClockDriver', 'ref': 'otherClockDriver', 'type': 'otherClockDriver'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, otherClockDriver=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if otherClockDriver is None:
            self.otherClockDriver = []
        else:
            self.otherClockDriver = otherClockDriver
        self.otherClockDriver_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, otherClocks)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if otherClocks.subclass:
            return otherClocks.subclass(*args_, **kwargs_)
        else:
            return otherClocks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_otherClockDriver(self):
        return self.otherClockDriver
    def set_otherClockDriver(self, otherClockDriver):
        self.otherClockDriver = otherClockDriver
    def add_otherClockDriver(self, value):
        self.otherClockDriver.append(value)
    def insert_otherClockDriver_at(self, index, value):
        self.otherClockDriver.insert(index, value)
    def replace_otherClockDriver_at(self, index, value):
        self.otherClockDriver[index] = value
    def _hasContent(self):
        if (
            self.otherClockDriver
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='otherClocks', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('otherClocks')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'otherClocks':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='otherClocks')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='otherClocks', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='otherClocks'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='otherClocks', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for otherClockDriver_ in self.otherClockDriver:
            namespaceprefix_ = self.otherClockDriver_nsprefix_ + ':' if (UseCapturedNS_ and self.otherClockDriver_nsprefix_) else ''
            otherClockDriver_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='otherClockDriver', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'otherClockDriver':
            obj_ = otherClockDriver.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.otherClockDriver.append(obj_)
            obj_.original_tagname_ = 'otherClockDriver'
# end class otherClocks


class cellSpecification(GeneratedsSuper):
    """cellFunction -- Defines a technology library cell in library independent fashion, based on specification of a cell function and strength.
    cellClass -- Defines a technology library cell in library independent fashion, based on specification of a cell class and strength.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cellStrength', 'ipxact:cellStrengthValueType', 0, 1, {'use': 'optional', 'name': 'cellStrength'}),
        MemberSpec_('cellFunction', 'cellFunctionType', 0, 0, {'name': 'cellFunction', 'type': 'cellFunctionType'}, 8),
        MemberSpec_('cellClass', ['cellClassValueType', 'xs:token'], 0, 0, {'name': 'cellClass', 'type': 'xs:token'}, 8),
    ]
    subclass = None
    superclass = None
    def __init__(self, cellStrength=None, cellFunction=None, cellClass=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.cellStrength = _cast(None, cellStrength)
        self.cellStrength_nsprefix_ = None
        self.cellFunction = cellFunction
        self.cellFunction_nsprefix_ = "ipxact"
        self.cellClass = cellClass
        self.validate_cellClassValueType(self.cellClass)
        self.cellClass_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cellSpecification)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cellSpecification.subclass:
            return cellSpecification.subclass(*args_, **kwargs_)
        else:
            return cellSpecification(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cellFunction(self):
        return self.cellFunction
    def set_cellFunction(self, cellFunction):
        self.cellFunction = cellFunction
    def get_cellClass(self):
        return self.cellClass
    def set_cellClass(self, cellClass):
        self.cellClass = cellClass
    def get_cellStrength(self):
        return self.cellStrength
    def set_cellStrength(self, cellStrength):
        self.cellStrength = cellStrength
    def validate_cellClassValueType(self, value):
        result = True
        # Validate type cellClassValueType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['combinational', 'sequential']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on cellClassValueType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cellStrengthValueType(self, value):
        # Validate type ipxact:cellStrengthValueType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['low', 'median', 'high']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on cellStrengthValueType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            self.cellFunction is not None or
            self.cellClass is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='cellSpecification', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cellSpecification')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'cellSpecification':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cellSpecification')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cellSpecification', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='cellSpecification'):
        if self.cellStrength is not None and 'cellStrength' not in already_processed:
            already_processed.add('cellStrength')
            outfile.write(' cellStrength=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.cellStrength), input_name='cellStrength')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='cellSpecification', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cellFunction is not None:
            namespaceprefix_ = self.cellFunction_nsprefix_ + ':' if (UseCapturedNS_ and self.cellFunction_nsprefix_) else ''
            self.cellFunction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cellFunction', pretty_print=pretty_print)
        if self.cellClass is not None:
            namespaceprefix_ = self.cellClass_nsprefix_ + ':' if (UseCapturedNS_ and self.cellClass_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scellClass>%s</%scellClass>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cellClass), input_name='cellClass')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cellStrength', node)
        if value is not None and 'cellStrength' not in already_processed:
            already_processed.add('cellStrength')
            self.cellStrength = value
            self.cellStrength = ' '.join(self.cellStrength.split())
            self.validate_cellStrengthValueType(self.cellStrength)    # validate type cellStrengthValueType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cellFunction':
            obj_ = cellFunctionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cellFunction = obj_
            obj_.original_tagname_ = 'cellFunction'
        elif nodeName_ == 'cellClass':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cellClass')
            value_ = self.gds_validate_string(value_, node, 'cellClass')
            self.cellClass = value_
            self.cellClass_nsprefix_ = child_.prefix
            # validate type cellClassValueType
            self.validate_cellClassValueType(self.cellClass)
# end class cellSpecification


class timingConstraint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('clockEdge', 'ipxact:edgeValueType', 0, 1, {'use': 'optional', 'name': 'clockEdge'}),
        MemberSpec_('delayType', 'ipxact:delayValueType', 0, 1, {'use': 'optional', 'name': 'delayType'}),
        MemberSpec_('clockName', 'ipxact:portName', 0, 0, {'use': 'required', 'name': 'clockName'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('valueOf_', ['delayPercentageType', 'xs:float'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, clockEdge=None, delayType=None, clockName=None, id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.clockEdge = _cast(None, clockEdge)
        self.clockEdge_nsprefix_ = None
        self.delayType = _cast(None, delayType)
        self.delayType_nsprefix_ = None
        self.clockName = _cast(None, clockName)
        self.clockName_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, timingConstraint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if timingConstraint.subclass:
            return timingConstraint.subclass(*args_, **kwargs_)
        else:
            return timingConstraint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_clockEdge(self):
        return self.clockEdge
    def set_clockEdge(self, clockEdge):
        self.clockEdge = clockEdge
    def get_delayType(self):
        return self.delayType
    def set_delayType(self, delayType):
        self.delayType = delayType
    def get_clockName(self):
        return self.clockName
    def set_clockName(self, clockName):
        self.clockName = clockName
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_delayPercentageType(self, value):
        result = True
        # Validate type delayPercentageType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on delayPercentageType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 100.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on delayPercentageType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_edgeValueType(self, value):
        # Validate type ipxact:edgeValueType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['rise', 'fall']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on edgeValueType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_delayValueType(self, value):
        # Validate type ipxact:delayValueType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['min', 'max']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on delayValueType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_portName(self, value):
        # Validate type ipxact:portName, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_portName_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_portName_patterns_, ))
    validate_portName_patterns_ = [['^([A-Za-z0-9\\.\\-:_]*)$']]
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='timingConstraint', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('timingConstraint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'timingConstraint':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='timingConstraint')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='timingConstraint', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='timingConstraint'):
        if self.clockEdge is not None and 'clockEdge' not in already_processed:
            already_processed.add('clockEdge')
            outfile.write(' clockEdge=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.clockEdge), input_name='clockEdge')), ))
        if self.delayType is not None and 'delayType' not in already_processed:
            already_processed.add('delayType')
            outfile.write(' delayType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.delayType), input_name='delayType')), ))
        if self.clockName is not None and 'clockName' not in already_processed:
            already_processed.add('clockName')
            outfile.write(' clockName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.clockName), input_name='clockName')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='timingConstraint', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('clockEdge', node)
        if value is not None and 'clockEdge' not in already_processed:
            already_processed.add('clockEdge')
            self.clockEdge = value
            self.clockEdge = ' '.join(self.clockEdge.split())
            self.validate_edgeValueType(self.clockEdge)    # validate type edgeValueType
        value = find_attr_value_('delayType', node)
        if value is not None and 'delayType' not in already_processed:
            already_processed.add('delayType')
            self.delayType = value
            self.delayType = ' '.join(self.delayType.split())
            self.validate_delayValueType(self.delayType)    # validate type delayValueType
        value = find_attr_value_('clockName', node)
        if value is not None and 'clockName' not in already_processed:
            already_processed.add('clockName')
            self.clockName = value
            self.validate_portName(self.clockName)    # validate type portName
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class timingConstraint


class driveConstraint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cellSpecification', 'cellSpecification', 0, 0, {'name': 'cellSpecification', 'ref': 'cellSpecification', 'type': 'cellSpecification'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cellSpecification=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.cellSpecification = cellSpecification
        self.cellSpecification_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, driveConstraint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if driveConstraint.subclass:
            return driveConstraint.subclass(*args_, **kwargs_)
        else:
            return driveConstraint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cellSpecification(self):
        return self.cellSpecification
    def set_cellSpecification(self, cellSpecification):
        self.cellSpecification = cellSpecification
    def _hasContent(self):
        if (
            self.cellSpecification is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='driveConstraint', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('driveConstraint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'driveConstraint':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='driveConstraint')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='driveConstraint', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='driveConstraint'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='driveConstraint', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cellSpecification is not None:
            namespaceprefix_ = self.cellSpecification_nsprefix_ + ':' if (UseCapturedNS_ and self.cellSpecification_nsprefix_) else ''
            self.cellSpecification.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='cellSpecification', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cellSpecification':
            obj_ = cellSpecification.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cellSpecification = obj_
            obj_.original_tagname_ = 'cellSpecification'
# end class driveConstraint


class loadConstraint(GeneratedsSuper):
    """count -- Indicates how many loads of the specified cell are connected. If not present, 3 is assumed.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cellSpecification', 'cellSpecification', 0, 0, {'name': 'cellSpecification', 'ref': 'cellSpecification', 'type': 'cellSpecification'}, None),
        MemberSpec_('count', 'unsignedPositiveIntExpression', 0, 1, {'default': '3', 'minOccurs': '0', 'name': 'count', 'type': 'unsignedPositiveIntExpression'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cellSpecification=None, count=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.cellSpecification = cellSpecification
        self.cellSpecification_nsprefix_ = "ipxact"
        if count is None:
            self.count = globals()['unsignedPositiveIntExpression']('3')
        else:
            self.count = count
        self.count_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, loadConstraint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if loadConstraint.subclass:
            return loadConstraint.subclass(*args_, **kwargs_)
        else:
            return loadConstraint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cellSpecification(self):
        return self.cellSpecification
    def set_cellSpecification(self, cellSpecification):
        self.cellSpecification = cellSpecification
    def get_count(self):
        return self.count
    def set_count(self, count):
        self.count = count
    def _hasContent(self):
        if (
            self.cellSpecification is not None or
            self.count is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='loadConstraint', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('loadConstraint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'loadConstraint':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='loadConstraint')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='loadConstraint', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='loadConstraint'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='loadConstraint', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cellSpecification is not None:
            namespaceprefix_ = self.cellSpecification_nsprefix_ + ':' if (UseCapturedNS_ and self.cellSpecification_nsprefix_) else ''
            self.cellSpecification.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='cellSpecification', pretty_print=pretty_print)
        if self.count is not None:
            namespaceprefix_ = self.count_nsprefix_ + ':' if (UseCapturedNS_ and self.count_nsprefix_) else ''
            self.count.export(outfile, level, namespaceprefix_, namespacedef_='', name_='count', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cellSpecification':
            obj_ = cellSpecification.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cellSpecification = obj_
            obj_.original_tagname_ = 'cellSpecification'
        elif nodeName_ == 'count':
            obj_ = unsignedPositiveIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.count = obj_
            obj_.original_tagname_ = 'count'
# end class loadConstraint


class constraintSet(GeneratedsSuper):
    """name -- Unique name
    vector -- The optional element vector specify the bits of a vector for which the constraints apply. The vaules of left and right must be within the range of the port. If the vector is not specified then the constraints apply to all the bits of the port.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('constraintSetId', 'xs:NMTOKEN', 0, 1, {'use': 'optional', 'name': 'constraintSetId'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 1, {'minOccurs': '0', 'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('Vector', 'vectorType', 0, 1, {'minOccurs': '0', 'name': 'vector', 'type': 'vectorType'}, None),
        MemberSpec_('driveConstraint', 'driveConstraint', 0, 1, {'minOccurs': '0', 'name': 'driveConstraint', 'ref': 'driveConstraint', 'type': 'driveConstraint'}, None),
        MemberSpec_('loadConstraint', 'loadConstraint', 0, 1, {'minOccurs': '0', 'name': 'loadConstraint', 'ref': 'loadConstraint', 'type': 'loadConstraint'}, None),
        MemberSpec_('timingConstraint', 'timingConstraint', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'timingConstraint', 'ref': 'timingConstraint', 'type': 'timingConstraint'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, constraintSetId='default', id=None, name=None, displayName=None, description=None, Vector=None, driveConstraint=None, loadConstraint=None, timingConstraint=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.constraintSetId = _cast(None, constraintSetId)
        self.constraintSetId_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.Vector = Vector
        self.Vector_nsprefix_ = "ipxact"
        self.driveConstraint = driveConstraint
        self.driveConstraint_nsprefix_ = "ipxact"
        self.loadConstraint = loadConstraint
        self.loadConstraint_nsprefix_ = "ipxact"
        if timingConstraint is None:
            self.timingConstraint = []
        else:
            self.timingConstraint = timingConstraint
        self.timingConstraint_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, constraintSet)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if constraintSet.subclass:
            return constraintSet.subclass(*args_, **kwargs_)
        else:
            return constraintSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_vector(self):
        return self.Vector
    def set_vector(self, Vector):
        self.Vector = Vector
    def get_driveConstraint(self):
        return self.driveConstraint
    def set_driveConstraint(self, driveConstraint):
        self.driveConstraint = driveConstraint
    def get_loadConstraint(self):
        return self.loadConstraint
    def set_loadConstraint(self, loadConstraint):
        self.loadConstraint = loadConstraint
    def get_timingConstraint(self):
        return self.timingConstraint
    def set_timingConstraint(self, timingConstraint):
        self.timingConstraint = timingConstraint
    def add_timingConstraint(self, value):
        self.timingConstraint.append(value)
    def insert_timingConstraint_at(self, index, value):
        self.timingConstraint.insert(index, value)
    def replace_timingConstraint_at(self, index, value):
        self.timingConstraint[index] = value
    def get_constraintSetId(self):
        return self.constraintSetId
    def set_constraintSetId(self, constraintSetId):
        self.constraintSetId = constraintSetId
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.Vector is not None or
            self.driveConstraint is not None or
            self.loadConstraint is not None or
            self.timingConstraint
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='constraintSet', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('constraintSet')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'constraintSet':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='constraintSet')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='constraintSet', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='constraintSet'):
        if self.constraintSetId != "default" and 'constraintSetId' not in already_processed:
            already_processed.add('constraintSetId')
            outfile.write(' constraintSetId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.constraintSetId), input_name='constraintSetId')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='constraintSet', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.Vector is not None:
            namespaceprefix_ = self.Vector_nsprefix_ + ':' if (UseCapturedNS_ and self.Vector_nsprefix_) else ''
            self.Vector.export(outfile, level, namespaceprefix_, namespacedef_='', name_='vector', pretty_print=pretty_print)
        if self.driveConstraint is not None:
            namespaceprefix_ = self.driveConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.driveConstraint_nsprefix_) else ''
            self.driveConstraint.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='driveConstraint', pretty_print=pretty_print)
        if self.loadConstraint is not None:
            namespaceprefix_ = self.loadConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.loadConstraint_nsprefix_) else ''
            self.loadConstraint.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='loadConstraint', pretty_print=pretty_print)
        for timingConstraint_ in self.timingConstraint:
            namespaceprefix_ = self.timingConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.timingConstraint_nsprefix_) else ''
            timingConstraint_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='timingConstraint', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('constraintSetId', node)
        if value is not None and 'constraintSetId' not in already_processed:
            already_processed.add('constraintSetId')
            self.constraintSetId = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'vector':
            obj_ = vectorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Vector = obj_
            obj_.original_tagname_ = 'vector'
        elif nodeName_ == 'driveConstraint':
            obj_ = driveConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.driveConstraint = obj_
            obj_.original_tagname_ = 'driveConstraint'
        elif nodeName_ == 'loadConstraint':
            obj_ = loadConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.loadConstraint = obj_
            obj_.original_tagname_ = 'loadConstraint'
        elif nodeName_ == 'timingConstraint':
            obj_ = timingConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timingConstraint.append(obj_)
            obj_.original_tagname_ = 'timingConstraint'
# end class constraintSet


class constraintSets(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('constraintSet', 'constraintSet', 1, 0, {'maxOccurs': 'unbounded', 'name': 'constraintSet', 'ref': 'constraintSet', 'type': 'constraintSet'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, constraintSet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if constraintSet is None:
            self.constraintSet = []
        else:
            self.constraintSet = constraintSet
        self.constraintSet_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, constraintSets)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if constraintSets.subclass:
            return constraintSets.subclass(*args_, **kwargs_)
        else:
            return constraintSets(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_constraintSet(self):
        return self.constraintSet
    def set_constraintSet(self, constraintSet):
        self.constraintSet = constraintSet
    def add_constraintSet(self, value):
        self.constraintSet.append(value)
    def insert_constraintSet_at(self, index, value):
        self.constraintSet.insert(index, value)
    def replace_constraintSet_at(self, index, value):
        self.constraintSet[index] = value
    def _hasContent(self):
        if (
            self.constraintSet
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='constraintSets', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('constraintSets')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'constraintSets':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='constraintSets')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='constraintSets', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='constraintSets'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='constraintSets', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for constraintSet_ in self.constraintSet:
            namespaceprefix_ = self.constraintSet_nsprefix_ + ':' if (UseCapturedNS_ and self.constraintSet_nsprefix_) else ''
            constraintSet_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='constraintSet', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'constraintSet':
            obj_ = constraintSet.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.constraintSet.append(obj_)
            obj_.original_tagname_ = 'constraintSet'
# end class constraintSets


class constraintSetRef(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('localName', 'xs:NMTOKEN', 0, 0, {'name': 'localName', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, localName=None, isPresent=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.localName = localName
        self.localName_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, constraintSetRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if constraintSetRef.subclass:
            return constraintSetRef.subclass(*args_, **kwargs_)
        else:
            return constraintSetRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_localName(self):
        return self.localName
    def set_localName(self, localName):
        self.localName = localName
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.localName is not None or
            self.isPresent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='constraintSetRef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('constraintSetRef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'constraintSetRef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='constraintSetRef')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='constraintSetRef', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='constraintSetRef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='constraintSetRef', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.localName is not None:
            namespaceprefix_ = self.localName_nsprefix_ + ':' if (UseCapturedNS_ and self.localName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocalName>%s</%slocalName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.localName), input_name='localName')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'localName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'localName')
            value_ = self.gds_validate_string(value_, node, 'localName')
            self.localName = value_
            self.localName_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
# end class constraintSetRef


class abstractionDefPortConstraintsType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('timingConstraint', 'timingConstraint', 1, 0, {'maxOccurs': 'unbounded', 'name': 'timingConstraint', 'ref': 'timingConstraint', 'type': 'timingConstraint'}, 9),
        MemberSpec_('driveConstraint', 'driveConstraint', 0, 0, {'name': 'driveConstraint', 'ref': 'driveConstraint', 'type': 'driveConstraint'}, 9),
        MemberSpec_('loadConstraint', 'loadConstraint', 0, 1, {'minOccurs': '0', 'name': 'loadConstraint', 'ref': 'loadConstraint', 'type': 'loadConstraint'}, 9),
        MemberSpec_('loadConstraint', 'loadConstraint', 0, 0, {'name': 'loadConstraint', 'ref': 'loadConstraint', 'type': 'loadConstraint'}, 9),
    ]
    subclass = None
    superclass = None
    def __init__(self, timingConstraint=None, driveConstraint=None, loadConstraint=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if timingConstraint is None:
            self.timingConstraint = []
        else:
            self.timingConstraint = timingConstraint
        self.timingConstraint_nsprefix_ = "ipxact"
        self.driveConstraint = driveConstraint
        self.driveConstraint_nsprefix_ = "ipxact"
        self.loadConstraint = loadConstraint
        self.loadConstraint_nsprefix_ = "ipxact"
        self.loadConstraint = loadConstraint
        self.loadConstraint_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, abstractionDefPortConstraintsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if abstractionDefPortConstraintsType.subclass:
            return abstractionDefPortConstraintsType.subclass(*args_, **kwargs_)
        else:
            return abstractionDefPortConstraintsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_timingConstraint(self):
        return self.timingConstraint
    def set_timingConstraint(self, timingConstraint):
        self.timingConstraint = timingConstraint
    def add_timingConstraint(self, value):
        self.timingConstraint.append(value)
    def insert_timingConstraint_at(self, index, value):
        self.timingConstraint.insert(index, value)
    def replace_timingConstraint_at(self, index, value):
        self.timingConstraint[index] = value
    def get_driveConstraint(self):
        return self.driveConstraint
    def set_driveConstraint(self, driveConstraint):
        self.driveConstraint = driveConstraint
    def get_loadConstraint(self):
        return self.loadConstraint
    def set_loadConstraint(self, loadConstraint):
        self.loadConstraint = loadConstraint
    def get_loadConstraint(self):
        return self.loadConstraint
    def set_loadConstraint(self, loadConstraint):
        self.loadConstraint = loadConstraint
    def _hasContent(self):
        if (
            self.timingConstraint or
            self.driveConstraint is not None or
            self.loadConstraint is not None or
            self.loadConstraint is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractionDefPortConstraintsType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractionDefPortConstraintsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractionDefPortConstraintsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractionDefPortConstraintsType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractionDefPortConstraintsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractionDefPortConstraintsType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractionDefPortConstraintsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for timingConstraint_ in self.timingConstraint:
            namespaceprefix_ = self.timingConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.timingConstraint_nsprefix_) else ''
            timingConstraint_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='timingConstraint', pretty_print=pretty_print)
        if self.driveConstraint is not None:
            namespaceprefix_ = self.driveConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.driveConstraint_nsprefix_) else ''
            self.driveConstraint.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='driveConstraint', pretty_print=pretty_print)
        if self.loadConstraint is not None:
            namespaceprefix_ = self.loadConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.loadConstraint_nsprefix_) else ''
            self.loadConstraint.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='loadConstraint', pretty_print=pretty_print)
        if self.loadConstraint is not None:
            namespaceprefix_ = self.loadConstraint_nsprefix_ + ':' if (UseCapturedNS_ and self.loadConstraint_nsprefix_) else ''
            self.loadConstraint.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='loadConstraint', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'timingConstraint':
            obj_ = timingConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timingConstraint.append(obj_)
            obj_.original_tagname_ = 'timingConstraint'
        elif nodeName_ == 'driveConstraint':
            obj_ = driveConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.driveConstraint = obj_
            obj_.original_tagname_ = 'driveConstraint'
        elif nodeName_ == 'loadConstraint':
            obj_ = loadConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.loadConstraint = obj_
            obj_.original_tagname_ = 'loadConstraint'
        elif nodeName_ == 'loadConstraint':
            obj_ = loadConstraint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.loadConstraint = obj_
            obj_.original_tagname_ = 'loadConstraint'
# end class abstractionDefPortConstraintsType


class singleShotDriver(GeneratedsSuper):
    """singleShotOffset -- Time in nanoseconds until start of one-shot.
    singleShotValue -- Value of port after first  edge of one-shot.
    singleShotDuration -- Duration in nanoseconds of the one shot.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('singleShotOffset', 'realExpression', 0, 0, {'name': 'singleShotOffset', 'type': 'realExpression'}, None),
        MemberSpec_('singleShotValue', 'unsignedBitVectorExpression', 0, 0, {'name': 'singleShotValue', 'type': 'unsignedBitVectorExpression'}, None),
        MemberSpec_('singleShotDuration', 'realExpression', 0, 0, {'name': 'singleShotDuration', 'type': 'realExpression'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, singleShotOffset=None, singleShotValue=None, singleShotDuration=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.singleShotOffset = singleShotOffset
        self.singleShotOffset_nsprefix_ = "ipxact"
        self.singleShotValue = singleShotValue
        self.singleShotValue_nsprefix_ = "ipxact"
        self.singleShotDuration = singleShotDuration
        self.singleShotDuration_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, singleShotDriver)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if singleShotDriver.subclass:
            return singleShotDriver.subclass(*args_, **kwargs_)
        else:
            return singleShotDriver(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_singleShotOffset(self):
        return self.singleShotOffset
    def set_singleShotOffset(self, singleShotOffset):
        self.singleShotOffset = singleShotOffset
    def get_singleShotValue(self):
        return self.singleShotValue
    def set_singleShotValue(self, singleShotValue):
        self.singleShotValue = singleShotValue
    def get_singleShotDuration(self):
        return self.singleShotDuration
    def set_singleShotDuration(self, singleShotDuration):
        self.singleShotDuration = singleShotDuration
    def _hasContent(self):
        if (
            self.singleShotOffset is not None or
            self.singleShotValue is not None or
            self.singleShotDuration is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='singleShotDriver', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('singleShotDriver')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'singleShotDriver':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='singleShotDriver')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='singleShotDriver', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='singleShotDriver'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='singleShotDriver', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.singleShotOffset is not None:
            namespaceprefix_ = self.singleShotOffset_nsprefix_ + ':' if (UseCapturedNS_ and self.singleShotOffset_nsprefix_) else ''
            self.singleShotOffset.export(outfile, level, namespaceprefix_, namespacedef_='', name_='singleShotOffset', pretty_print=pretty_print)
        if self.singleShotValue is not None:
            namespaceprefix_ = self.singleShotValue_nsprefix_ + ':' if (UseCapturedNS_ and self.singleShotValue_nsprefix_) else ''
            self.singleShotValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='singleShotValue', pretty_print=pretty_print)
        if self.singleShotDuration is not None:
            namespaceprefix_ = self.singleShotDuration_nsprefix_ + ':' if (UseCapturedNS_ and self.singleShotDuration_nsprefix_) else ''
            self.singleShotDuration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='singleShotDuration', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'singleShotOffset':
            class_obj_ = self.get_class_obj_(child_, realExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.singleShotOffset = obj_
            obj_.original_tagname_ = 'singleShotOffset'
        elif nodeName_ == 'singleShotValue':
            obj_ = unsignedBitVectorExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.singleShotValue = obj_
            obj_.original_tagname_ = 'singleShotValue'
        elif nodeName_ == 'singleShotDuration':
            class_obj_ = self.get_class_obj_(child_, realExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.singleShotDuration = obj_
            obj_.original_tagname_ = 'singleShotDuration'
# end class singleShotDriver


class requiresDriver(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('driverType', 'driverTypeType', 0, 1, {'use': 'optional', 'name': 'driverType'}),
        MemberSpec_('valueOf_', 'xs:boolean', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, driverType='any', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.driverType = _cast(None, driverType)
        self.driverType_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, requiresDriver)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if requiresDriver.subclass:
            return requiresDriver.subclass(*args_, **kwargs_)
        else:
            return requiresDriver(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_driverType(self):
        return self.driverType
    def set_driverType(self, driverType):
        self.driverType = driverType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_driverTypeType(self, value):
        # Validate type driverTypeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['clock', 'singleShot', 'any']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on driverTypeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='requiresDriver', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('requiresDriver')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'requiresDriver':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='requiresDriver')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='requiresDriver', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='requiresDriver'):
        if self.driverType != "any" and 'driverType' not in already_processed:
            already_processed.add('driverType')
            outfile.write(' driverType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.driverType), input_name='driverType')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='requiresDriver', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('driverType', node)
        if value is not None and 'driverType' not in already_processed:
            already_processed.add('driverType')
            self.driverType = value
            self.driverType = ' '.join(self.driverType.split())
            self.validate_driverTypeType(self.driverType)    # validate type driverTypeType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class requiresDriver


class driverType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Range', 'range', 0, 1, {'minOccurs': '0', 'name': 'range', 'ref': 'range', 'type': 'range'}, None),
        MemberSpec_('defaultValue', 'unsignedBitVectorExpression', 0, 1, {'minOccurs': '0', 'name': 'defaultValue', 'ref': 'defaultValue', 'type': 'defaultValue'}, 10),
        MemberSpec_('clockDriver', 'clockDriver', 0, 1, {'minOccurs': '0', 'name': 'clockDriver', 'ref': 'clockDriver', 'type': 'clockDriver'}, 10),
        MemberSpec_('singleShotDriver', 'singleShotDriver', 0, 1, {'minOccurs': '0', 'name': 'singleShotDriver', 'ref': 'singleShotDriver', 'type': 'singleShotDriver'}, 10),
    ]
    subclass = None
    superclass = None
    def __init__(self, Range=None, defaultValue=None, clockDriver=None, singleShotDriver=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.Range = Range
        self.Range_nsprefix_ = "ipxact"
        self.defaultValue = defaultValue
        self.defaultValue_nsprefix_ = "ipxact"
        self.clockDriver = clockDriver
        self.clockDriver_nsprefix_ = "ipxact"
        self.singleShotDriver = singleShotDriver
        self.singleShotDriver_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, driverType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if driverType.subclass:
            return driverType.subclass(*args_, **kwargs_)
        else:
            return driverType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_range(self):
        return self.Range
    def set_range(self, Range):
        self.Range = Range
    def get_defaultValue(self):
        return self.defaultValue
    def set_defaultValue(self, defaultValue):
        self.defaultValue = defaultValue
    def get_clockDriver(self):
        return self.clockDriver
    def set_clockDriver(self, clockDriver):
        self.clockDriver = clockDriver
    def get_singleShotDriver(self):
        return self.singleShotDriver
    def set_singleShotDriver(self, singleShotDriver):
        self.singleShotDriver = singleShotDriver
    def _hasContent(self):
        if (
            self.Range is not None or
            self.defaultValue is not None or
            self.clockDriver is not None or
            self.singleShotDriver is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='driverType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('driverType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'driverType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='driverType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='driverType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='driverType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='driverType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Range is not None:
            namespaceprefix_ = self.Range_nsprefix_ + ':' if (UseCapturedNS_ and self.Range_nsprefix_) else ''
            self.Range.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='range', pretty_print=pretty_print)
        if self.defaultValue is not None:
            namespaceprefix_ = self.defaultValue_nsprefix_ + ':' if (UseCapturedNS_ and self.defaultValue_nsprefix_) else ''
            self.defaultValue.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='defaultValue', pretty_print=pretty_print)
        if self.clockDriver is not None:
            namespaceprefix_ = self.clockDriver_nsprefix_ + ':' if (UseCapturedNS_ and self.clockDriver_nsprefix_) else ''
            self.clockDriver.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='clockDriver', pretty_print=pretty_print)
        if self.singleShotDriver is not None:
            namespaceprefix_ = self.singleShotDriver_nsprefix_ + ':' if (UseCapturedNS_ and self.singleShotDriver_nsprefix_) else ''
            self.singleShotDriver.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='singleShotDriver', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'range':
            obj_ = Range.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Range = obj_
            obj_.original_tagname_ = 'range'
        elif nodeName_ == 'defaultValue':
            obj_ = unsignedBitVectorExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.defaultValue = obj_
            obj_.original_tagname_ = 'defaultValue'
        elif nodeName_ == 'clockDriver':
            obj_ = clockDriver.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.clockDriver = obj_
            obj_.original_tagname_ = 'clockDriver'
        elif nodeName_ == 'singleShotDriver':
            obj_ = singleShotDriver.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.singleShotDriver = obj_
            obj_.original_tagname_ = 'singleShotDriver'
# end class driverType


class drivers(GeneratedsSuper):
    """driver -- Wire port driver element. If no range is specified, default value applies to the entire range.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('driver', 'driverType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'driver', 'ref': 'driver', 'type': 'driver'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, driver=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if driver is None:
            self.driver = []
        else:
            self.driver = driver
        self.driver_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, drivers)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if drivers.subclass:
            return drivers.subclass(*args_, **kwargs_)
        else:
            return drivers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_driver(self):
        return self.driver
    def set_driver(self, driver):
        self.driver = driver
    def add_driver(self, value):
        self.driver.append(value)
    def insert_driver_at(self, index, value):
        self.driver.insert(index, value)
    def replace_driver_at(self, index, value):
        self.driver[index] = value
    def _hasContent(self):
        if (
            self.driver
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='drivers', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('drivers')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'drivers':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='drivers')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='drivers', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='drivers'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='drivers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for driver_ in self.driver:
            namespaceprefix_ = self.driver_nsprefix_ + ':' if (UseCapturedNS_ and self.driver_nsprefix_) else ''
            driver_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='driver', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'driver':
            obj_ = driverType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.driver.append(obj_)
            obj_.original_tagname_ = 'driver'
# end class drivers


class clockDriverType(GeneratedsSuper):
    """clockPeriod -- Clock period in units defined by the units attribute. Default is nanoseconds.
    clockPulseOffset -- Time until first pulse. Units are defined by the units attribute. Default is nanoseconds.
    clockPulseValue -- Value of port after first clock edge.
    clockPulseDuration -- Duration of first state in cycle. Units are defined by the units attribute. Default is nanoseconds.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('clockPeriod', 'clockPeriodType', 0, 0, {'name': 'clockPeriod', 'type': 'clockPeriodType'}, None),
        MemberSpec_('clockPulseOffset', 'clockPulseOffsetType', 0, 0, {'name': 'clockPulseOffset', 'type': 'clockPulseOffsetType'}, None),
        MemberSpec_('clockPulseValue', 'unsignedBitVectorExpression', 0, 0, {'name': 'clockPulseValue', 'type': 'unsignedBitVectorExpression'}, None),
        MemberSpec_('clockPulseDuration', 'clockPulseDurationType', 0, 0, {'name': 'clockPulseDuration', 'type': 'clockPulseDurationType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, clockPeriod=None, clockPulseOffset=None, clockPulseValue=None, clockPulseDuration=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.clockPeriod = clockPeriod
        self.clockPeriod_nsprefix_ = "ipxact"
        self.clockPulseOffset = clockPulseOffset
        self.clockPulseOffset_nsprefix_ = "ipxact"
        self.clockPulseValue = clockPulseValue
        self.clockPulseValue_nsprefix_ = "ipxact"
        self.clockPulseDuration = clockPulseDuration
        self.clockPulseDuration_nsprefix_ = "ipxact"
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, clockDriverType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if clockDriverType.subclass:
            return clockDriverType.subclass(*args_, **kwargs_)
        else:
            return clockDriverType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_clockPeriod(self):
        return self.clockPeriod
    def set_clockPeriod(self, clockPeriod):
        self.clockPeriod = clockPeriod
    def get_clockPulseOffset(self):
        return self.clockPulseOffset
    def set_clockPulseOffset(self, clockPulseOffset):
        self.clockPulseOffset = clockPulseOffset
    def get_clockPulseValue(self):
        return self.clockPulseValue
    def set_clockPulseValue(self, clockPulseValue):
        self.clockPulseValue = clockPulseValue
    def get_clockPulseDuration(self):
        return self.clockPulseDuration
    def set_clockPulseDuration(self, clockPulseDuration):
        self.clockPulseDuration = clockPulseDuration
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (
            self.clockPeriod is not None or
            self.clockPulseOffset is not None or
            self.clockPulseValue is not None or
            self.clockPulseDuration is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='clockDriverType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('clockDriverType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'clockDriverType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='clockDriverType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='clockDriverType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='clockDriverType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='clockDriverType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.clockPeriod is not None:
            namespaceprefix_ = self.clockPeriod_nsprefix_ + ':' if (UseCapturedNS_ and self.clockPeriod_nsprefix_) else ''
            self.clockPeriod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='clockPeriod', pretty_print=pretty_print)
        if self.clockPulseOffset is not None:
            namespaceprefix_ = self.clockPulseOffset_nsprefix_ + ':' if (UseCapturedNS_ and self.clockPulseOffset_nsprefix_) else ''
            self.clockPulseOffset.export(outfile, level, namespaceprefix_, namespacedef_='', name_='clockPulseOffset', pretty_print=pretty_print)
        if self.clockPulseValue is not None:
            namespaceprefix_ = self.clockPulseValue_nsprefix_ + ':' if (UseCapturedNS_ and self.clockPulseValue_nsprefix_) else ''
            self.clockPulseValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='clockPulseValue', pretty_print=pretty_print)
        if self.clockPulseDuration is not None:
            namespaceprefix_ = self.clockPulseDuration_nsprefix_ + ':' if (UseCapturedNS_ and self.clockPulseDuration_nsprefix_) else ''
            self.clockPulseDuration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='clockPulseDuration', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'clockPeriod':
            obj_ = clockPeriodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.clockPeriod = obj_
            obj_.original_tagname_ = 'clockPeriod'
        elif nodeName_ == 'clockPulseOffset':
            obj_ = clockPulseOffsetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.clockPulseOffset = obj_
            obj_.original_tagname_ = 'clockPulseOffset'
        elif nodeName_ == 'clockPulseValue':
            obj_ = unsignedBitVectorExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.clockPulseValue = obj_
            obj_.original_tagname_ = 'clockPulseValue'
        elif nodeName_ == 'clockPulseDuration':
            obj_ = clockPulseDurationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.clockPulseDuration = obj_
            obj_.original_tagname_ = 'clockPulseDuration'
# end class clockDriverType


class otherClockDriver(clockDriverType):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('clockName', 'xs:Name', 0, 0, {'use': 'required', 'name': 'clockName'}),
        MemberSpec_('clockSource', 'xs:string', 0, 1, {'use': 'optional', 'name': 'clockSource'}),
    ]
    subclass = None
    superclass = clockDriverType
    def __init__(self, id=None, clockPeriod=None, clockPulseOffset=None, clockPulseValue=None, clockPulseDuration=None, clockName=None, clockSource=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        super(globals().get("otherClockDriver"), self).__init__(id, clockPeriod, clockPulseOffset, clockPulseValue, clockPulseDuration,  **kwargs_)
        self.clockName = _cast(None, clockName)
        self.clockName_nsprefix_ = None
        self.clockSource = _cast(None, clockSource)
        self.clockSource_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, otherClockDriver)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if otherClockDriver.subclass:
            return otherClockDriver.subclass(*args_, **kwargs_)
        else:
            return otherClockDriver(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_clockName(self):
        return self.clockName
    def set_clockName(self, clockName):
        self.clockName = clockName
    def get_clockSource(self):
        return self.clockSource
    def set_clockSource(self, clockSource):
        self.clockSource = clockSource
    def _hasContent(self):
        if (
            super(otherClockDriver, self)._hasContent()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='otherClockDriver', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('otherClockDriver')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'otherClockDriver':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='otherClockDriver')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='otherClockDriver', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='otherClockDriver'):
        super(otherClockDriver, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='otherClockDriver')
        if self.clockName is not None and 'clockName' not in already_processed:
            already_processed.add('clockName')
            outfile.write(' clockName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.clockName), input_name='clockName')), ))
        if self.clockSource is not None and 'clockSource' not in already_processed:
            already_processed.add('clockSource')
            outfile.write(' clockSource=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.clockSource), input_name='clockSource')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='otherClockDriver', fromsubclass_=False, pretty_print=True):
        super(otherClockDriver, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('clockName', node)
        if value is not None and 'clockName' not in already_processed:
            already_processed.add('clockName')
            self.clockName = value
        value = find_attr_value_('clockSource', node)
        if value is not None and 'clockSource' not in already_processed:
            already_processed.add('clockSource')
            self.clockSource = value
        super(otherClockDriver, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(otherClockDriver, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class otherClockDriver


class file(GeneratedsSuper):
    """name -- Path to the file or directory. If this path is a relative path, then it is relative to the containing XML file.
    isStructural -- Indicates that the current file is purely structural.
    isIncludeFile -- Indicate that the file is include file.
    logicalName -- Logical name for this file or directory e.g. VHDL library name.
    exportedName -- Defines exported names that can be accessed externally, e.g. exported function names from a C source file.
    buildCommand -- Command and flags used to build derived files from the sourceName files. If this element is present, the command and/or flags used to to build the file will override or augment any default builders at a higher level.
    define -- Specifies define symbols that are used in the source file.  The ipxact:name element gives the name to be defined and the text content of the ipxact:value element holds the value.  This element supports full configurability.
    imageType -- Relates the current file to a certain executable image type in the design.
    description -- String for describing this file to users
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('fileId', 'xs:token', 0, 1, {'use': 'optional', 'name': 'fileId'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'stringURIExpression', 0, 0, {'name': 'name', 'type': 'stringURIExpression'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('fileType', 'fileType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'fileType', 'ref': 'fileType', 'type': 'fileType'}, None),
        MemberSpec_('isStructural', 'xs:boolean', 0, 1, {'default': 'false', 'minOccurs': '0', 'name': 'isStructural', 'type': 'xs:boolean'}, None),
        MemberSpec_('isIncludeFile', 'isIncludeFileType', 0, 1, {'minOccurs': '0', 'name': 'isIncludeFile', 'type': 'isIncludeFileType'}, None),
        MemberSpec_('logicalName', 'logicalNameType', 0, 1, {'minOccurs': '0', 'name': 'logicalName', 'type': 'logicalNameType'}, None),
        MemberSpec_('exportedName', 'exportedNameType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'exportedName', 'type': 'exportedNameType'}, None),
        MemberSpec_('buildCommand', 'buildCommandType', 0, 1, {'minOccurs': '0', 'name': 'buildCommand', 'type': 'buildCommandType'}, None),
        MemberSpec_('dependency', 'dependency', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'dependency', 'ref': 'dependency', 'type': 'dependency'}, None),
        MemberSpec_('define', 'nameValuePairType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'define', 'type': 'nameValuePairType'}, None),
        MemberSpec_('imageType', 'imageTypeType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'imageType', 'type': 'imageTypeType'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, fileId=None, id=None, name=None, isPresent=None, fileType=None, isStructural=False, isIncludeFile=None, logicalName=None, exportedName=None, buildCommand=None, dependency=None, define=None, imageType=None, description=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.fileId = _cast(None, fileId)
        self.fileId_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        if fileType is None:
            self.fileType = []
        else:
            self.fileType = fileType
        self.fileType_nsprefix_ = "ipxact"
        self.isStructural = isStructural
        self.isStructural_nsprefix_ = "ipxact"
        self.isIncludeFile = isIncludeFile
        self.isIncludeFile_nsprefix_ = "ipxact"
        self.logicalName = logicalName
        self.logicalName_nsprefix_ = "ipxact"
        if exportedName is None:
            self.exportedName = []
        else:
            self.exportedName = exportedName
        self.exportedName_nsprefix_ = "ipxact"
        self.buildCommand = buildCommand
        self.buildCommand_nsprefix_ = "ipxact"
        if dependency is None:
            self.dependency = []
        else:
            self.dependency = dependency
        self.dependency_nsprefix_ = "ipxact"
        if define is None:
            self.define = []
        else:
            self.define = define
        self.define_nsprefix_ = "ipxact"
        if imageType is None:
            self.imageType = []
        else:
            self.imageType = imageType
        self.imageType_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, file)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if file.subclass:
            return file.subclass(*args_, **kwargs_)
        else:
            return file(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_fileType(self):
        return self.fileType
    def set_fileType(self, fileType):
        self.fileType = fileType
    def add_fileType(self, value):
        self.fileType.append(value)
    def insert_fileType_at(self, index, value):
        self.fileType.insert(index, value)
    def replace_fileType_at(self, index, value):
        self.fileType[index] = value
    def get_isStructural(self):
        return self.isStructural
    def set_isStructural(self, isStructural):
        self.isStructural = isStructural
    def get_isIncludeFile(self):
        return self.isIncludeFile
    def set_isIncludeFile(self, isIncludeFile):
        self.isIncludeFile = isIncludeFile
    def get_logicalName(self):
        return self.logicalName
    def set_logicalName(self, logicalName):
        self.logicalName = logicalName
    def get_exportedName(self):
        return self.exportedName
    def set_exportedName(self, exportedName):
        self.exportedName = exportedName
    def add_exportedName(self, value):
        self.exportedName.append(value)
    def insert_exportedName_at(self, index, value):
        self.exportedName.insert(index, value)
    def replace_exportedName_at(self, index, value):
        self.exportedName[index] = value
    def get_buildCommand(self):
        return self.buildCommand
    def set_buildCommand(self, buildCommand):
        self.buildCommand = buildCommand
    def get_dependency(self):
        return self.dependency
    def set_dependency(self, dependency):
        self.dependency = dependency
    def add_dependency(self, value):
        self.dependency.append(value)
    def insert_dependency_at(self, index, value):
        self.dependency.insert(index, value)
    def replace_dependency_at(self, index, value):
        self.dependency[index] = value
    def get_define(self):
        return self.define
    def set_define(self, define):
        self.define = define
    def add_define(self, value):
        self.define.append(value)
    def insert_define_at(self, index, value):
        self.define.insert(index, value)
    def replace_define_at(self, index, value):
        self.define[index] = value
    def get_imageType(self):
        return self.imageType
    def set_imageType(self, imageType):
        self.imageType = imageType
    def add_imageType(self, value):
        self.imageType.append(value)
    def insert_imageType_at(self, index, value):
        self.imageType.insert(index, value)
    def replace_imageType_at(self, index, value):
        self.imageType[index] = value
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_fileId(self):
        return self.fileId
    def set_fileId(self, fileId):
        self.fileId = fileId
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.name is not None or
            self.isPresent is not None or
            self.fileType or
            self.isStructural or
            self.isIncludeFile is not None or
            self.logicalName is not None or
            self.exportedName or
            self.buildCommand is not None or
            self.dependency or
            self.define or
            self.imageType or
            self.description is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='file', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('file')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'file':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='file')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='file', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='file'):
        if self.fileId is not None and 'fileId' not in already_processed:
            already_processed.add('fileId')
            outfile.write(' fileId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.fileId), input_name='fileId')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='file', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        for fileType_ in self.fileType:
            namespaceprefix_ = self.fileType_nsprefix_ + ':' if (UseCapturedNS_ and self.fileType_nsprefix_) else ''
            fileType_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='fileType', pretty_print=pretty_print)
        if self.isStructural:
            namespaceprefix_ = self.isStructural_nsprefix_ + ':' if (UseCapturedNS_ and self.isStructural_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sisStructural>%s</%sisStructural>%s' % (namespaceprefix_ , self.gds_format_boolean(self.isStructural, input_name='isStructural'), namespaceprefix_ , eol_))
        if self.isIncludeFile is not None:
            namespaceprefix_ = self.isIncludeFile_nsprefix_ + ':' if (UseCapturedNS_ and self.isIncludeFile_nsprefix_) else ''
            self.isIncludeFile.export(outfile, level, namespaceprefix_, namespacedef_='', name_='isIncludeFile', pretty_print=pretty_print)
        if self.logicalName is not None:
            namespaceprefix_ = self.logicalName_nsprefix_ + ':' if (UseCapturedNS_ and self.logicalName_nsprefix_) else ''
            self.logicalName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='logicalName', pretty_print=pretty_print)
        for exportedName_ in self.exportedName:
            namespaceprefix_ = self.exportedName_nsprefix_ + ':' if (UseCapturedNS_ and self.exportedName_nsprefix_) else ''
            exportedName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='exportedName', pretty_print=pretty_print)
        if self.buildCommand is not None:
            namespaceprefix_ = self.buildCommand_nsprefix_ + ':' if (UseCapturedNS_ and self.buildCommand_nsprefix_) else ''
            self.buildCommand.export(outfile, level, namespaceprefix_, namespacedef_='', name_='buildCommand', pretty_print=pretty_print)
        for dependency_ in self.dependency:
            namespaceprefix_ = self.dependency_nsprefix_ + ':' if (UseCapturedNS_ and self.dependency_nsprefix_) else ''
            dependency_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='dependency', pretty_print=pretty_print)
        for define_ in self.define:
            namespaceprefix_ = self.define_nsprefix_ + ':' if (UseCapturedNS_ and self.define_nsprefix_) else ''
            define_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='define', pretty_print=pretty_print)
        for imageType_ in self.imageType:
            namespaceprefix_ = self.imageType_nsprefix_ + ':' if (UseCapturedNS_ and self.imageType_nsprefix_) else ''
            imageType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='imageType', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fileId', node)
        if value is not None and 'fileId' not in already_processed:
            already_processed.add('fileId')
            self.fileId = value
            self.fileId = ' '.join(self.fileId.split())
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = stringURIExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'fileType':
            obj_ = fileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fileType.append(obj_)
            obj_.original_tagname_ = 'fileType'
        elif nodeName_ == 'isStructural':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'isStructural')
            ival_ = self.gds_validate_boolean(ival_, node, 'isStructural')
            self.isStructural = ival_
            self.isStructural_nsprefix_ = child_.prefix
        elif nodeName_ == 'isIncludeFile':
            obj_ = isIncludeFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isIncludeFile = obj_
            obj_.original_tagname_ = 'isIncludeFile'
        elif nodeName_ == 'logicalName':
            obj_ = logicalNameType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.logicalName = obj_
            obj_.original_tagname_ = 'logicalName'
        elif nodeName_ == 'exportedName':
            obj_ = exportedNameType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.exportedName.append(obj_)
            obj_.original_tagname_ = 'exportedName'
        elif nodeName_ == 'buildCommand':
            obj_ = buildCommandType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.buildCommand = obj_
            obj_.original_tagname_ = 'buildCommand'
        elif nodeName_ == 'dependency':
            obj_ = dependency.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dependency.append(obj_)
            obj_.original_tagname_ = 'dependency'
        elif nodeName_ == 'define':
            class_obj_ = self.get_class_obj_(child_, nameValuePairType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.define.append(obj_)
            obj_.original_tagname_ = 'define'
        elif nodeName_ == 'imageType':
            obj_ = imageTypeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.imageType.append(obj_)
            obj_.original_tagname_ = 'imageType'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class file


class executableImage(GeneratedsSuper):
    """name -- Unique name
    parameters -- Additional information about the load module, e.g. stack base addresses, table addresses, etc.
    languageTools -- Default commands and flags for software language tools needed to build the executable image.
    fileSetRefGroup -- Contains a group of file set references that indicates the set of file sets complying with the tool set of the current executable image.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('imageId', 'xs:token', 0, 0, {'use': 'required', 'name': 'imageId'}),
        MemberSpec_('imageType', 'xs:Name', 0, 1, {'use': 'optional', 'name': 'imageType'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('languageTools', 'languageToolsType', 0, 1, {'minOccurs': '0', 'name': 'languageTools', 'type': 'languageToolsType'}, None),
        MemberSpec_('fileSetRefGroup', 'fileSetRefGroupType', 0, 1, {'minOccurs': '0', 'name': 'fileSetRefGroup', 'type': 'fileSetRefGroupType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, imageId=None, imageType=None, id=None, name=None, displayName=None, description=None, parameters=None, languageTools=None, fileSetRefGroup=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.imageId = _cast(None, imageId)
        self.imageId_nsprefix_ = None
        self.imageType = _cast(None, imageType)
        self.imageType_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.languageTools = languageTools
        self.languageTools_nsprefix_ = "ipxact"
        self.fileSetRefGroup = fileSetRefGroup
        self.fileSetRefGroup_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, executableImage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if executableImage.subclass:
            return executableImage.subclass(*args_, **kwargs_)
        else:
            return executableImage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_languageTools(self):
        return self.languageTools
    def set_languageTools(self, languageTools):
        self.languageTools = languageTools
    def get_fileSetRefGroup(self):
        return self.fileSetRefGroup
    def set_fileSetRefGroup(self, fileSetRefGroup):
        self.fileSetRefGroup = fileSetRefGroup
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_imageId(self):
        return self.imageId
    def set_imageId(self, imageId):
        self.imageId = imageId
    def get_imageType(self):
        return self.imageType
    def set_imageType(self, imageType):
        self.imageType = imageType
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.parameters is not None or
            self.languageTools is not None or
            self.fileSetRefGroup is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='executableImage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('executableImage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'executableImage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='executableImage')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='executableImage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='executableImage'):
        if self.imageId is not None and 'imageId' not in already_processed:
            already_processed.add('imageId')
            outfile.write(' imageId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.imageId), input_name='imageId')), ))
        if self.imageType is not None and 'imageType' not in already_processed:
            already_processed.add('imageType')
            outfile.write(' imageType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.imageType), input_name='imageType')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='executableImage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.languageTools is not None:
            namespaceprefix_ = self.languageTools_nsprefix_ + ':' if (UseCapturedNS_ and self.languageTools_nsprefix_) else ''
            self.languageTools.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageTools', pretty_print=pretty_print)
        if self.fileSetRefGroup is not None:
            namespaceprefix_ = self.fileSetRefGroup_nsprefix_ + ':' if (UseCapturedNS_ and self.fileSetRefGroup_nsprefix_) else ''
            self.fileSetRefGroup.export(outfile, level, namespaceprefix_, namespacedef_='', name_='fileSetRefGroup', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('imageId', node)
        if value is not None and 'imageId' not in already_processed:
            already_processed.add('imageId')
            self.imageId = value
            self.imageId = ' '.join(self.imageId.split())
        value = find_attr_value_('imageType', node)
        if value is not None and 'imageType' not in already_processed:
            already_processed.add('imageType')
            self.imageType = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'languageTools':
            obj_ = languageToolsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageTools = obj_
            obj_.original_tagname_ = 'languageTools'
        elif nodeName_ == 'fileSetRefGroup':
            obj_ = fileSetRefGroupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fileSetRefGroup = obj_
            obj_.original_tagname_ = 'fileSetRefGroup'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class executableImage


class linkerCommandFile(GeneratedsSuper):
    """name -- Linker command file name.
    commandLineSwitch -- The command line switch to specify the linker command file.
    enable -- Specifies whether to generate and enable the linker command file.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('name', 'stringURIExpression', 0, 0, {'name': 'name', 'type': 'stringURIExpression'}, None),
        MemberSpec_('commandLineSwitch', 'stringExpression', 0, 0, {'name': 'commandLineSwitch', 'type': 'stringExpression'}, None),
        MemberSpec_('enable', 'unsignedBitExpression', 0, 0, {'name': 'enable', 'type': 'unsignedBitExpression'}, None),
        MemberSpec_('generatorRef', 'generatorRef', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'generatorRef', 'ref': 'generatorRef', 'type': 'generatorRef'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, commandLineSwitch=None, enable=None, generatorRef=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.commandLineSwitch = commandLineSwitch
        self.commandLineSwitch_nsprefix_ = "ipxact"
        self.enable = enable
        self.enable_nsprefix_ = "ipxact"
        if generatorRef is None:
            self.generatorRef = []
        else:
            self.generatorRef = generatorRef
        self.generatorRef_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, linkerCommandFile)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if linkerCommandFile.subclass:
            return linkerCommandFile.subclass(*args_, **kwargs_)
        else:
            return linkerCommandFile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_commandLineSwitch(self):
        return self.commandLineSwitch
    def set_commandLineSwitch(self, commandLineSwitch):
        self.commandLineSwitch = commandLineSwitch
    def get_enable(self):
        return self.enable
    def set_enable(self, enable):
        self.enable = enable
    def get_generatorRef(self):
        return self.generatorRef
    def set_generatorRef(self, generatorRef):
        self.generatorRef = generatorRef
    def add_generatorRef(self, value):
        self.generatorRef.append(value)
    def insert_generatorRef_at(self, index, value):
        self.generatorRef.insert(index, value)
    def replace_generatorRef_at(self, index, value):
        self.generatorRef[index] = value
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def _hasContent(self):
        if (
            self.name is not None or
            self.commandLineSwitch is not None or
            self.enable is not None or
            self.generatorRef or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='linkerCommandFile', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('linkerCommandFile')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'linkerCommandFile':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='linkerCommandFile')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='linkerCommandFile', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='linkerCommandFile'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='linkerCommandFile', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.commandLineSwitch is not None:
            namespaceprefix_ = self.commandLineSwitch_nsprefix_ + ':' if (UseCapturedNS_ and self.commandLineSwitch_nsprefix_) else ''
            self.commandLineSwitch.export(outfile, level, namespaceprefix_, namespacedef_='', name_='commandLineSwitch', pretty_print=pretty_print)
        if self.enable is not None:
            namespaceprefix_ = self.enable_nsprefix_ + ':' if (UseCapturedNS_ and self.enable_nsprefix_) else ''
            self.enable.export(outfile, level, namespaceprefix_, namespacedef_='', name_='enable', pretty_print=pretty_print)
        for generatorRef_ in self.generatorRef:
            namespaceprefix_ = self.generatorRef_nsprefix_ + ':' if (UseCapturedNS_ and self.generatorRef_nsprefix_) else ''
            generatorRef_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='generatorRef', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = stringURIExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'commandLineSwitch':
            class_obj_ = self.get_class_obj_(child_, stringExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.commandLineSwitch = obj_
            obj_.original_tagname_ = 'commandLineSwitch'
        elif nodeName_ == 'enable':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.enable = obj_
            obj_.original_tagname_ = 'enable'
        elif nodeName_ == 'generatorRef':
            obj_ = generatorRef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.generatorRef.append(obj_)
            obj_.original_tagname_ = 'generatorRef'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class linkerCommandFile


class fileSetRef(GeneratedsSuper):
    """localName -- Refers to a fileSet defined within this description.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('localName', 'xs:Name', 0, 0, {'name': 'localName', 'type': 'xs:Name'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, localName=None, isPresent=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.localName = localName
        self.localName_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fileSetRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fileSetRef.subclass:
            return fileSetRef.subclass(*args_, **kwargs_)
        else:
            return fileSetRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_localName(self):
        return self.localName
    def set_localName(self, localName):
        self.localName = localName
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.localName is not None or
            self.isPresent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileSetRef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fileSetRef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fileSetRef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fileSetRef')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='fileSetRef', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='fileSetRef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileSetRef', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.localName is not None:
            namespaceprefix_ = self.localName_nsprefix_ + ':' if (UseCapturedNS_ and self.localName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocalName>%s</%slocalName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.localName), input_name='localName')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'localName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'localName')
            value_ = self.gds_validate_string(value_, node, 'localName')
            self.localName = value_
            self.localName_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
# end class fileSetRef


class fileSets(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('fileSet', 'fileSetType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'fileSet', 'ref': 'fileSet', 'type': 'fileSet'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, fileSet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if fileSet is None:
            self.fileSet = []
        else:
            self.fileSet = fileSet
        self.fileSet_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fileSets)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fileSets.subclass:
            return fileSets.subclass(*args_, **kwargs_)
        else:
            return fileSets(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_fileSet(self):
        return self.fileSet
    def set_fileSet(self, fileSet):
        self.fileSet = fileSet
    def add_fileSet(self, value):
        self.fileSet.append(value)
    def insert_fileSet_at(self, index, value):
        self.fileSet.insert(index, value)
    def replace_fileSet_at(self, index, value):
        self.fileSet[index] = value
    def _hasContent(self):
        if (
            self.fileSet
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileSets', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fileSets')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fileSets':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fileSets')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='fileSets', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='fileSets'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileSets', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for fileSet_ in self.fileSet:
            namespaceprefix_ = self.fileSet_nsprefix_ + ':' if (UseCapturedNS_ and self.fileSet_nsprefix_) else ''
            fileSet_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='fileSet', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'fileSet':
            obj_ = fileSetType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fileSet.append(obj_)
            obj_.original_tagname_ = 'fileSet'
# end class fileSets


class fileBuilderType(GeneratedsSuper):
    """command -- Default command used to build files of the specified fileType.
    flags -- Flags given to the build command when building files of this type.
    replaceDefaultFlags -- If true, replace any default flags value with the value in the sibling flags element. Otherwise, append the contents of the sibling flags element to any default flags value.
    If the value is true and the "flags" element is empty or missing, this will have the result of clearing any default flags value.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('fileType', 'fileType', 0, 0, {'name': 'fileType', 'ref': 'fileType', 'type': 'fileType'}, None),
        MemberSpec_('command', 'stringExpression', 0, 1, {'minOccurs': '0', 'name': 'command', 'type': 'stringExpression'}, None),
        MemberSpec_('flags', 'stringExpression', 0, 1, {'minOccurs': '0', 'name': 'flags', 'type': 'stringExpression'}, None),
        MemberSpec_('replaceDefaultFlags', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'replaceDefaultFlags', 'type': 'unsignedBitExpression'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, fileType=None, command=None, flags=None, replaceDefaultFlags=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.fileType = fileType
        self.fileType_nsprefix_ = "ipxact"
        self.command = command
        self.command_nsprefix_ = "ipxact"
        self.flags = flags
        self.flags_nsprefix_ = "ipxact"
        self.replaceDefaultFlags = replaceDefaultFlags
        self.replaceDefaultFlags_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fileBuilderType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fileBuilderType.subclass:
            return fileBuilderType.subclass(*args_, **kwargs_)
        else:
            return fileBuilderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_fileType(self):
        return self.fileType
    def set_fileType(self, fileType):
        self.fileType = fileType
    def get_command(self):
        return self.command
    def set_command(self, command):
        self.command = command
    def get_flags(self):
        return self.flags
    def set_flags(self, flags):
        self.flags = flags
    def get_replaceDefaultFlags(self):
        return self.replaceDefaultFlags
    def set_replaceDefaultFlags(self, replaceDefaultFlags):
        self.replaceDefaultFlags = replaceDefaultFlags
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.fileType is not None or
            self.command is not None or
            self.flags is not None or
            self.replaceDefaultFlags is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileBuilderType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fileBuilderType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fileBuilderType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fileBuilderType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='fileBuilderType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='fileBuilderType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileBuilderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fileType is not None:
            namespaceprefix_ = self.fileType_nsprefix_ + ':' if (UseCapturedNS_ and self.fileType_nsprefix_) else ''
            self.fileType.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='fileType', pretty_print=pretty_print)
        if self.command is not None:
            namespaceprefix_ = self.command_nsprefix_ + ':' if (UseCapturedNS_ and self.command_nsprefix_) else ''
            self.command.export(outfile, level, namespaceprefix_, namespacedef_='', name_='command', pretty_print=pretty_print)
        if self.flags is not None:
            namespaceprefix_ = self.flags_nsprefix_ + ':' if (UseCapturedNS_ and self.flags_nsprefix_) else ''
            self.flags.export(outfile, level, namespaceprefix_, namespacedef_='', name_='flags', pretty_print=pretty_print)
        if self.replaceDefaultFlags is not None:
            namespaceprefix_ = self.replaceDefaultFlags_nsprefix_ + ':' if (UseCapturedNS_ and self.replaceDefaultFlags_nsprefix_) else ''
            self.replaceDefaultFlags.export(outfile, level, namespaceprefix_, namespacedef_='', name_='replaceDefaultFlags', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'fileType':
            obj_ = fileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fileType = obj_
            obj_.original_tagname_ = 'fileType'
        elif nodeName_ == 'command':
            class_obj_ = self.get_class_obj_(child_, stringExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.command = obj_
            obj_.original_tagname_ = 'command'
        elif nodeName_ == 'flags':
            class_obj_ = self.get_class_obj_(child_, stringExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.flags = obj_
            obj_.original_tagname_ = 'flags'
        elif nodeName_ == 'replaceDefaultFlags':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.replaceDefaultFlags = obj_
            obj_.original_tagname_ = 'replaceDefaultFlags'
# end class fileBuilderType


class fileSetType(GeneratedsSuper):
    """name -- Unique name
    group -- Identifies this filleSet as belonging to a particular group or having a particular purpose. Examples might be "diagnostics", "boot", "application", "interrupt", "deviceDriver", etc.
    defaultFileBuilder -- Default command and flags used to build derived files from the sourceName files in this file set.
    function -- Generator information if this file set describes a function. For example, this file set may describe diagnostics for which the DE can generate a diagnostics driver.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('group', 'xs:Name', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'group', 'type': 'groupType'}, None),
        MemberSpec_('file', 'file', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'file', 'ref': 'file', 'type': 'file'}, None),
        MemberSpec_('defaultFileBuilder', 'fileBuilderType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'defaultFileBuilder', 'type': 'fileBuilderType'}, None),
        MemberSpec_('dependency', 'dependency', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'dependency', 'ref': 'dependency', 'type': 'dependency'}, None),
        MemberSpec_('function', 'functionType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'function', 'type': 'functionType'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, group=None, file=None, defaultFileBuilder=None, dependency=None, function=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        if group is None:
            self.group = []
        else:
            self.group = group
        self.group_nsprefix_ = "ipxact"
        if file is None:
            self.file = []
        else:
            self.file = file
        self.file_nsprefix_ = "ipxact"
        if defaultFileBuilder is None:
            self.defaultFileBuilder = []
        else:
            self.defaultFileBuilder = defaultFileBuilder
        self.defaultFileBuilder_nsprefix_ = "ipxact"
        if dependency is None:
            self.dependency = []
        else:
            self.dependency = dependency
        self.dependency_nsprefix_ = "ipxact"
        if function is None:
            self.function = []
        else:
            self.function = function
        self.function_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fileSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fileSetType.subclass:
            return fileSetType.subclass(*args_, **kwargs_)
        else:
            return fileSetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_group(self):
        return self.group
    def set_group(self, group):
        self.group = group
    def add_group(self, value):
        self.group.append(value)
    def insert_group_at(self, index, value):
        self.group.insert(index, value)
    def replace_group_at(self, index, value):
        self.group[index] = value
    def get_file(self):
        return self.file
    def set_file(self, file):
        self.file = file
    def add_file(self, value):
        self.file.append(value)
    def insert_file_at(self, index, value):
        self.file.insert(index, value)
    def replace_file_at(self, index, value):
        self.file[index] = value
    def get_defaultFileBuilder(self):
        return self.defaultFileBuilder
    def set_defaultFileBuilder(self, defaultFileBuilder):
        self.defaultFileBuilder = defaultFileBuilder
    def add_defaultFileBuilder(self, value):
        self.defaultFileBuilder.append(value)
    def insert_defaultFileBuilder_at(self, index, value):
        self.defaultFileBuilder.insert(index, value)
    def replace_defaultFileBuilder_at(self, index, value):
        self.defaultFileBuilder[index] = value
    def get_dependency(self):
        return self.dependency
    def set_dependency(self, dependency):
        self.dependency = dependency
    def add_dependency(self, value):
        self.dependency.append(value)
    def insert_dependency_at(self, index, value):
        self.dependency.insert(index, value)
    def replace_dependency_at(self, index, value):
        self.dependency[index] = value
    def get_function(self):
        return self.function
    def set_function(self, function):
        self.function = function
    def add_function(self, value):
        self.function.append(value)
    def insert_function_at(self, index, value):
        self.function.insert(index, value)
    def replace_function_at(self, index, value):
        self.function[index] = value
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.group or
            self.file or
            self.defaultFileBuilder or
            self.dependency or
            self.function or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileSetType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fileSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fileSetType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fileSetType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='fileSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='fileSetType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        for group_ in self.group:
            namespaceprefix_ = self.group_nsprefix_ + ':' if (UseCapturedNS_ and self.group_nsprefix_) else ''
            group_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='group', pretty_print=pretty_print)
        for file_ in self.file:
            namespaceprefix_ = self.file_nsprefix_ + ':' if (UseCapturedNS_ and self.file_nsprefix_) else ''
            file_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='file', pretty_print=pretty_print)
        for defaultFileBuilder_ in self.defaultFileBuilder:
            namespaceprefix_ = self.defaultFileBuilder_nsprefix_ + ':' if (UseCapturedNS_ and self.defaultFileBuilder_nsprefix_) else ''
            defaultFileBuilder_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='defaultFileBuilder', pretty_print=pretty_print)
        for dependency_ in self.dependency:
            namespaceprefix_ = self.dependency_nsprefix_ + ':' if (UseCapturedNS_ and self.dependency_nsprefix_) else ''
            dependency_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='dependency', pretty_print=pretty_print)
        for function_ in self.function:
            namespaceprefix_ = self.function_nsprefix_ + ':' if (UseCapturedNS_ and self.function_nsprefix_) else ''
            function_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='function', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'group':
            obj_ = groupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.group.append(obj_)
            obj_.original_tagname_ = 'group'
        elif nodeName_ == 'file':
            obj_ = file.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.file.append(obj_)
            obj_.original_tagname_ = 'file'
        elif nodeName_ == 'defaultFileBuilder':
            obj_ = fileBuilderType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.defaultFileBuilder.append(obj_)
            obj_.original_tagname_ = 'defaultFileBuilder'
        elif nodeName_ == 'dependency':
            obj_ = dependency.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dependency.append(obj_)
            obj_.original_tagname_ = 'dependency'
        elif nodeName_ == 'function':
            obj_ = functionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.function.append(obj_)
            obj_.original_tagname_ = 'function'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class fileSetType


class generatorRef(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, generatorRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if generatorRef.subclass:
            return generatorRef.subclass(*args_, **kwargs_)
        else:
            return generatorRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorRef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('generatorRef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'generatorRef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='generatorRef')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='generatorRef', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='generatorRef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorRef', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class generatorRef


class ipxactURI(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ipxactURI)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ipxactURI.subclass:
            return ipxactURI.subclass(*args_, **kwargs_)
        else:
            return ipxactURI(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='ipxactURI', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ipxactURI')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ipxactURI':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ipxactURI')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ipxactURI', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='ipxactURI'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='ipxactURI', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class ipxactURI


class fileType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('user', 'xs:string', 0, 1, {'use': 'optional', 'name': 'user'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('valueOf_', ['simpleFileType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, user=None, id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.user = _cast(None, user)
        self.user_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fileType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fileType.subclass:
            return fileType.subclass(*args_, **kwargs_)
        else:
            return fileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_user(self):
        return self.user
    def set_user(self, user):
        self.user = user
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_simpleFileType(self, value):
        result = True
        # Validate type simpleFileType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['unknown', 'cSource', 'cppSource', 'asmSource', 'vhdlSource', 'vhdlSource-87', 'vhdlSource-93', 'verilogSource', 'verilogSource-95', 'verilogSource-2001', 'swObject', 'swObjectLibrary', 'vhdlBinaryLibrary', 'verilogBinaryLibrary', 'unelaboratedHdl', 'executableHdl', 'systemVerilogSource', 'systemVerilogSource-3.0', 'systemVerilogSource-3.1', 'systemCSource', 'systemCSource-2.0', 'systemCSource-2.0.1', 'systemCSource-2.1', 'systemCSource-2.2', 'veraSource', 'eSource', 'perlSource', 'tclSource', 'OVASource', 'SVASource', 'pslSource', 'systemVerilogSource-3.1a', 'SDC', 'vhdlAmsSource', 'verilogAmsSource', 'systemCAmsSource', 'libertySource', 'user']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on simpleFileType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fileType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fileType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fileType')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='fileType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='fileType'):
        if self.user is not None and 'user' not in already_processed:
            already_processed.add('user')
            outfile.write(' user=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.user), input_name='user')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='fileType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('user', node)
        if value is not None and 'user' not in already_processed:
            already_processed.add('user')
            self.user = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fileType


class generatorChain(GeneratedsSuper):
    """vendor -- Name of the vendor who supplies this file.
    library -- Name of the logical library this element belongs to.
    name -- The name of the object.
    version -- Indicates the version of the named element.
    generatorChainSelector -- Select other generator chain files for inclusion into this chain. The boolean attribute "unique" (default false) specifies that only a single generator is valid in this context. If more that one generator is selected based on the selection criteria, DE will prompt the user to resolve to a single generator.
    componentGeneratorSelector -- Selects generators declared in components of the current design for inclusion into this generator chain.
    chainGroup -- Identifies this generator chain as belonging to the named group. This is used by other generator chains to select this chain for programmatic inclusion.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('hidden', 'xs:boolean', 0, 1, {'use': 'optional', 'name': 'hidden'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('vendor', 'xs:Name', 0, 0, {'name': 'vendor', 'type': 'xs:Name'}, None),
        MemberSpec_('library', 'xs:Name', 0, 0, {'name': 'library', 'type': 'xs:Name'}, None),
        MemberSpec_('name', 'xs:NMTOKEN', 0, 0, {'name': 'name', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('version', 'xs:NMTOKEN', 0, 0, {'name': 'version', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('generatorChainSelector', 'generatorChainSelectorType', 1, 0, {'name': 'generatorChainSelector', 'type': 'generatorChainSelectorType'}, 11),
        MemberSpec_('componentGeneratorSelector', 'generatorSelectorType', 1, 0, {'name': 'componentGeneratorSelector', 'type': 'generatorSelectorType'}, 11),
        MemberSpec_('generator', 'generator', 1, 0, {'name': 'generator', 'ref': 'generator', 'type': 'generator'}, 11),
        MemberSpec_('chainGroup', 'chainGroupType', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'chainGroup', 'type': 'chainGroupType'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('choices', 'choices', 0, 1, {'minOccurs': '0', 'name': 'choices', 'ref': 'choices', 'type': 'choices'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('assertions', 'assertions', 0, 1, {'minOccurs': '0', 'name': 'assertions', 'ref': 'assertions', 'type': 'assertions'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, hidden=False, id=None, vendor=None, library=None, name=None, version=None, generatorChainSelector=None, componentGeneratorSelector=None, generator=None, chainGroup=None, displayName=None, description=None, choices=None, parameters=None, assertions=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.hidden = _cast(bool, hidden)
        self.hidden_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.vendor = vendor
        self.vendor_nsprefix_ = "ipxact"
        self.library = library
        self.library_nsprefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.version = version
        self.version_nsprefix_ = "ipxact"
        if generatorChainSelector is None:
            self.generatorChainSelector = []
        else:
            self.generatorChainSelector = generatorChainSelector
        self.generatorChainSelector_nsprefix_ = "ipxact"
        if componentGeneratorSelector is None:
            self.componentGeneratorSelector = []
        else:
            self.componentGeneratorSelector = componentGeneratorSelector
        self.componentGeneratorSelector_nsprefix_ = "ipxact"
        if generator is None:
            self.generator = []
        else:
            self.generator = generator
        self.generator_nsprefix_ = "ipxact"
        if chainGroup is None:
            self.chainGroup = []
        else:
            self.chainGroup = chainGroup
        self.chainGroup_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.choices = choices
        self.choices_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.assertions = assertions
        self.assertions_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, generatorChain)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if generatorChain.subclass:
            return generatorChain.subclass(*args_, **kwargs_)
        else:
            return generatorChain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vendor(self):
        return self.vendor
    def set_vendor(self, vendor):
        self.vendor = vendor
    def get_library(self):
        return self.library
    def set_library(self, library):
        self.library = library
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_generatorChainSelector(self):
        return self.generatorChainSelector
    def set_generatorChainSelector(self, generatorChainSelector):
        self.generatorChainSelector = generatorChainSelector
    def add_generatorChainSelector(self, value):
        self.generatorChainSelector.append(value)
    def insert_generatorChainSelector_at(self, index, value):
        self.generatorChainSelector.insert(index, value)
    def replace_generatorChainSelector_at(self, index, value):
        self.generatorChainSelector[index] = value
    def get_componentGeneratorSelector(self):
        return self.componentGeneratorSelector
    def set_componentGeneratorSelector(self, componentGeneratorSelector):
        self.componentGeneratorSelector = componentGeneratorSelector
    def add_componentGeneratorSelector(self, value):
        self.componentGeneratorSelector.append(value)
    def insert_componentGeneratorSelector_at(self, index, value):
        self.componentGeneratorSelector.insert(index, value)
    def replace_componentGeneratorSelector_at(self, index, value):
        self.componentGeneratorSelector[index] = value
    def get_generator(self):
        return self.generator
    def set_generator(self, generator):
        self.generator = generator
    def add_generator(self, value):
        self.generator.append(value)
    def insert_generator_at(self, index, value):
        self.generator.insert(index, value)
    def replace_generator_at(self, index, value):
        self.generator[index] = value
    def get_chainGroup(self):
        return self.chainGroup
    def set_chainGroup(self, chainGroup):
        self.chainGroup = chainGroup
    def add_chainGroup(self, value):
        self.chainGroup.append(value)
    def insert_chainGroup_at(self, index, value):
        self.chainGroup.insert(index, value)
    def replace_chainGroup_at(self, index, value):
        self.chainGroup[index] = value
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_choices(self):
        return self.choices
    def set_choices(self, choices):
        self.choices = choices
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_assertions(self):
        return self.assertions
    def set_assertions(self, assertions):
        self.assertions = assertions
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_hidden(self):
        return self.hidden
    def set_hidden(self, hidden):
        self.hidden = hidden
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.vendor is not None or
            self.library is not None or
            self.name is not None or
            self.version is not None or
            self.generatorChainSelector or
            self.componentGeneratorSelector or
            self.generator or
            self.chainGroup or
            self.displayName is not None or
            self.description is not None or
            self.choices is not None or
            self.parameters is not None or
            self.assertions is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorChain', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('generatorChain')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'generatorChain':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='generatorChain')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='generatorChain', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='generatorChain'):
        if self.hidden and 'hidden' not in already_processed:
            already_processed.add('hidden')
            outfile.write(' hidden="%s"' % self.gds_format_boolean(self.hidden, input_name='hidden'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorChain', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vendor is not None:
            namespaceprefix_ = self.vendor_nsprefix_ + ':' if (UseCapturedNS_ and self.vendor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor>%s</%svendor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vendor), input_name='vendor')), namespaceprefix_ , eol_))
        if self.library is not None:
            namespaceprefix_ = self.library_nsprefix_ + ':' if (UseCapturedNS_ and self.library_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slibrary>%s</%slibrary>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.library), input_name='library')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        for generatorChainSelector_ in self.generatorChainSelector:
            namespaceprefix_ = self.generatorChainSelector_nsprefix_ + ':' if (UseCapturedNS_ and self.generatorChainSelector_nsprefix_) else ''
            generatorChainSelector_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='generatorChainSelector', pretty_print=pretty_print)
        for componentGeneratorSelector_ in self.componentGeneratorSelector:
            namespaceprefix_ = self.componentGeneratorSelector_nsprefix_ + ':' if (UseCapturedNS_ and self.componentGeneratorSelector_nsprefix_) else ''
            componentGeneratorSelector_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='componentGeneratorSelector', pretty_print=pretty_print)
        for generator_ in self.generator:
            namespaceprefix_ = self.generator_nsprefix_ + ':' if (UseCapturedNS_ and self.generator_nsprefix_) else ''
            generator_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='generator', pretty_print=pretty_print)
        for chainGroup_ in self.chainGroup:
            namespaceprefix_ = self.chainGroup_nsprefix_ + ':' if (UseCapturedNS_ and self.chainGroup_nsprefix_) else ''
            chainGroup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chainGroup', pretty_print=pretty_print)
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.choices is not None:
            namespaceprefix_ = self.choices_nsprefix_ + ':' if (UseCapturedNS_ and self.choices_nsprefix_) else ''
            self.choices.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='choices', pretty_print=pretty_print)
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.assertions is not None:
            namespaceprefix_ = self.assertions_nsprefix_ + ':' if (UseCapturedNS_ and self.assertions_nsprefix_) else ''
            self.assertions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='assertions', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('hidden', node)
        if value is not None and 'hidden' not in already_processed:
            already_processed.add('hidden')
            if value in ('true', '1'):
                self.hidden = True
            elif value in ('false', '0'):
                self.hidden = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vendor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vendor')
            value_ = self.gds_validate_string(value_, node, 'vendor')
            self.vendor = value_
            self.vendor_nsprefix_ = child_.prefix
        elif nodeName_ == 'library':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'library')
            value_ = self.gds_validate_string(value_, node, 'library')
            self.library = value_
            self.library_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'generatorChainSelector':
            obj_ = generatorChainSelectorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.generatorChainSelector.append(obj_)
            obj_.original_tagname_ = 'generatorChainSelector'
        elif nodeName_ == 'componentGeneratorSelector':
            obj_ = generatorSelectorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentGeneratorSelector.append(obj_)
            obj_.original_tagname_ = 'componentGeneratorSelector'
        elif nodeName_ == 'generator':
            obj_ = generator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.generator.append(obj_)
            obj_.original_tagname_ = 'generator'
        elif nodeName_ == 'chainGroup':
            obj_ = chainGroupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.chainGroup.append(obj_)
            obj_.original_tagname_ = 'chainGroup'
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'choices':
            obj_ = choices.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.choices = obj_
            obj_.original_tagname_ = 'choices'
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'assertions':
            obj_ = assertions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assertions = obj_
            obj_.original_tagname_ = 'assertions'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class generatorChain


class groupSelector(GeneratedsSuper):
    """name -- Specifies a generator group name or a generator chain group name to be selected for inclusion in the generator chain.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('multipleGroupSelectionOperator', 'multipleGroupSelectionOperatorType', 0, 1, {'use': 'optional', 'name': 'multipleGroupSelectionOperator'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'nameType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'name', 'type': 'nameType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, multipleGroupSelectionOperator='or', id=None, name=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.multipleGroupSelectionOperator = _cast(None, multipleGroupSelectionOperator)
        self.multipleGroupSelectionOperator_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if name is None:
            self.name = []
        else:
            self.name = name
        self.name_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, groupSelector)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if groupSelector.subclass:
            return groupSelector.subclass(*args_, **kwargs_)
        else:
            return groupSelector(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def add_name(self, value):
        self.name.append(value)
    def insert_name_at(self, index, value):
        self.name.insert(index, value)
    def replace_name_at(self, index, value):
        self.name[index] = value
    def get_multipleGroupSelectionOperator(self):
        return self.multipleGroupSelectionOperator
    def set_multipleGroupSelectionOperator(self, multipleGroupSelectionOperator):
        self.multipleGroupSelectionOperator = multipleGroupSelectionOperator
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_multipleGroupSelectionOperatorType(self, value):
        # Validate type multipleGroupSelectionOperatorType, a restriction on xs:Name.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['and', 'or']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on multipleGroupSelectionOperatorType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            self.name
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='groupSelector', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('groupSelector')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'groupSelector':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='groupSelector')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='groupSelector', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='groupSelector'):
        if self.multipleGroupSelectionOperator != "or" and 'multipleGroupSelectionOperator' not in already_processed:
            already_processed.add('multipleGroupSelectionOperator')
            outfile.write(' multipleGroupSelectionOperator=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.multipleGroupSelectionOperator), input_name='multipleGroupSelectionOperator')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='groupSelector', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for name_ in self.name:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            name_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('multipleGroupSelectionOperator', node)
        if value is not None and 'multipleGroupSelectionOperator' not in already_processed:
            already_processed.add('multipleGroupSelectionOperator')
            self.multipleGroupSelectionOperator = value
            self.validate_multipleGroupSelectionOperatorType(self.multipleGroupSelectionOperator)    # validate type multipleGroupSelectionOperatorType
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = nameType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name.append(obj_)
            obj_.original_tagname_ = 'name'
# end class groupSelector


class generatorSelectorType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('groupSelector', 'groupSelector', 0, 0, {'name': 'groupSelector', 'ref': 'groupSelector', 'type': 'groupSelector'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, groupSelector=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.groupSelector = groupSelector
        self.groupSelector_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, generatorSelectorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if generatorSelectorType.subclass:
            return generatorSelectorType.subclass(*args_, **kwargs_)
        else:
            return generatorSelectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_groupSelector(self):
        return self.groupSelector
    def set_groupSelector(self, groupSelector):
        self.groupSelector = groupSelector
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.groupSelector is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorSelectorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('generatorSelectorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'generatorSelectorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='generatorSelectorType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='generatorSelectorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='generatorSelectorType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorSelectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.groupSelector is not None:
            namespaceprefix_ = self.groupSelector_nsprefix_ + ':' if (UseCapturedNS_ and self.groupSelector_nsprefix_) else ''
            self.groupSelector.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='groupSelector', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'groupSelector':
            obj_ = groupSelector.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.groupSelector = obj_
            obj_.original_tagname_ = 'groupSelector'
# end class generatorSelectorType


class componentGenerators(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('componentGenerator', 'instanceGeneratorType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'componentGenerator', 'ref': 'componentGenerator', 'type': 'componentGenerator'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, componentGenerator=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if componentGenerator is None:
            self.componentGenerator = []
        else:
            self.componentGenerator = componentGenerator
        self.componentGenerator_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, componentGenerators)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if componentGenerators.subclass:
            return componentGenerators.subclass(*args_, **kwargs_)
        else:
            return componentGenerators(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_componentGenerator(self):
        return self.componentGenerator
    def set_componentGenerator(self, componentGenerator):
        self.componentGenerator = componentGenerator
    def add_componentGenerator(self, value):
        self.componentGenerator.append(value)
    def insert_componentGenerator_at(self, index, value):
        self.componentGenerator.insert(index, value)
    def replace_componentGenerator_at(self, index, value):
        self.componentGenerator[index] = value
    def _hasContent(self):
        if (
            self.componentGenerator
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentGenerators', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('componentGenerators')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'componentGenerators':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='componentGenerators')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='componentGenerators', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='componentGenerators'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentGenerators', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for componentGenerator_ in self.componentGenerator:
            namespaceprefix_ = self.componentGenerator_nsprefix_ + ':' if (UseCapturedNS_ and self.componentGenerator_nsprefix_) else ''
            componentGenerator_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='componentGenerator', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'componentGenerator':
            obj_ = instanceGeneratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentGenerator.append(obj_)
            obj_.original_tagname_ = 'componentGenerator'
# end class componentGenerators


class abstractorGenerators(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('abstractorGenerator', 'instanceGeneratorType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'abstractorGenerator', 'ref': 'abstractorGenerator', 'type': 'abstractorGenerator'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, abstractorGenerator=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if abstractorGenerator is None:
            self.abstractorGenerator = []
        else:
            self.abstractorGenerator = abstractorGenerator
        self.abstractorGenerator_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, abstractorGenerators)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if abstractorGenerators.subclass:
            return abstractorGenerators.subclass(*args_, **kwargs_)
        else:
            return abstractorGenerators(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_abstractorGenerator(self):
        return self.abstractorGenerator
    def set_abstractorGenerator(self, abstractorGenerator):
        self.abstractorGenerator = abstractorGenerator
    def add_abstractorGenerator(self, value):
        self.abstractorGenerator.append(value)
    def insert_abstractorGenerator_at(self, index, value):
        self.abstractorGenerator.insert(index, value)
    def replace_abstractorGenerator_at(self, index, value):
        self.abstractorGenerator[index] = value
    def _hasContent(self):
        if (
            self.abstractorGenerator
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorGenerators', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractorGenerators')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractorGenerators':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractorGenerators')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractorGenerators', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractorGenerators'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorGenerators', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for abstractorGenerator_ in self.abstractorGenerator:
            namespaceprefix_ = self.abstractorGenerator_nsprefix_ + ':' if (UseCapturedNS_ and self.abstractorGenerator_nsprefix_) else ''
            abstractorGenerator_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='abstractorGenerator', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'abstractorGenerator':
            obj_ = instanceGeneratorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstractorGenerator.append(obj_)
            obj_.original_tagname_ = 'abstractorGenerator'
# end class abstractorGenerators


class generatorType(GeneratedsSuper):
    """name -- Unique name
    apiType -- Indicates the type of API used by the generator. Valid value are TGI_2009, TGI_2014_BASE, TGI_2014_EXTENDED, and none. If this element is not present, TGI_2014_BASE is assumed. The type TGI_2009 indicates a generator using the 1685-2009 version of the TGI API. This is not part of the 1685-2014 version of the standard and may not be supported by Design Environments.
    generatorExe -- The pathname to the executable file that implements the generator
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('hidden', 'xs:boolean', 0, 1, {'use': 'optional', 'name': 'hidden'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('phase', 'realExpression', 0, 1, {'minOccurs': '0', 'name': 'phase', 'ref': 'phase', 'type': 'phase'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('apiType', 'apiTypeType', 0, 1, {'minOccurs': '0', 'name': 'apiType', 'type': 'apiTypeType'}, None),
        MemberSpec_('transportMethods', 'transportMethodsType', 0, 1, {'minOccurs': '0', 'name': 'transportMethods', 'type': 'transportMethodsType'}, None),
        MemberSpec_('generatorExe', 'ipxactURI', 0, 0, {'name': 'generatorExe', 'type': 'ipxactURI'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, hidden=False, id=None, name=None, displayName=None, description=None, phase=None, parameters=None, apiType=None, transportMethods=None, generatorExe=None, vendorExtensions=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.hidden = _cast(bool, hidden)
        self.hidden_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.phase = phase
        self.phase_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.apiType = apiType
        self.apiType_nsprefix_ = "ipxact"
        self.transportMethods = transportMethods
        self.transportMethods_nsprefix_ = "ipxact"
        self.generatorExe = generatorExe
        self.generatorExe_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, generatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if generatorType.subclass:
            return generatorType.subclass(*args_, **kwargs_)
        else:
            return generatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_phase(self):
        return self.phase
    def set_phase(self, phase):
        self.phase = phase
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_apiType(self):
        return self.apiType
    def set_apiType(self, apiType):
        self.apiType = apiType
    def get_transportMethods(self):
        return self.transportMethods
    def set_transportMethods(self, transportMethods):
        self.transportMethods = transportMethods
    def get_generatorExe(self):
        return self.generatorExe
    def set_generatorExe(self, generatorExe):
        self.generatorExe = generatorExe
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_hidden(self):
        return self.hidden
    def set_hidden(self, hidden):
        self.hidden = hidden
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.phase is not None or
            self.parameters is not None or
            self.apiType is not None or
            self.transportMethods is not None or
            self.generatorExe is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('generatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'generatorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='generatorType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='generatorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='generatorType'):
        if self.hidden and 'hidden' not in already_processed:
            already_processed.add('hidden')
            outfile.write(' hidden="%s"' % self.gds_format_boolean(self.hidden, input_name='hidden'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='generatorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.phase is not None:
            namespaceprefix_ = self.phase_nsprefix_ + ':' if (UseCapturedNS_ and self.phase_nsprefix_) else ''
            self.phase.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='phase', pretty_print=pretty_print)
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.apiType is not None:
            namespaceprefix_ = self.apiType_nsprefix_ + ':' if (UseCapturedNS_ and self.apiType_nsprefix_) else ''
            self.apiType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='apiType', pretty_print=pretty_print)
        if self.transportMethods is not None:
            namespaceprefix_ = self.transportMethods_nsprefix_ + ':' if (UseCapturedNS_ and self.transportMethods_nsprefix_) else ''
            self.transportMethods.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transportMethods', pretty_print=pretty_print)
        if self.generatorExe is not None:
            namespaceprefix_ = self.generatorExe_nsprefix_ + ':' if (UseCapturedNS_ and self.generatorExe_nsprefix_) else ''
            self.generatorExe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='generatorExe', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('hidden', node)
        if value is not None and 'hidden' not in already_processed:
            already_processed.add('hidden')
            if value in ('true', '1'):
                self.hidden = True
            elif value in ('false', '0'):
                self.hidden = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'phase':
            class_obj_ = self.get_class_obj_(child_, realExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.phase = obj_
            obj_.original_tagname_ = 'phase'
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'apiType':
            obj_ = apiTypeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.apiType = obj_
            obj_.original_tagname_ = 'apiType'
        elif nodeName_ == 'transportMethods':
            obj_ = transportMethodsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transportMethods = obj_
            obj_.original_tagname_ = 'transportMethods'
        elif nodeName_ == 'generatorExe':
            class_obj_ = self.get_class_obj_(child_, ipxactURI)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.generatorExe = obj_
            obj_.original_tagname_ = 'generatorExe'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class generatorType


class Component(GeneratedsSuper):
    """vendor -- Name of the vendor who supplies this file.
    library -- Name of the logical library this element belongs to.
    name -- The name of the object.
    version -- Indicates the version of the named element.
    componentGenerators -- Generator list is tools-specific.
    whiteboxElements -- A list of whiteboxElements
    cpus -- cpu's in the component
    otherClockDrivers -- Defines a set of clock drivers that are not directly associated with an input port of the component.
    resetTypes -- A list of user defined resetTypes applicable to this component.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('vendor', 'xs:Name', 0, 0, {'name': 'vendor', 'type': 'xs:Name'}, None),
        MemberSpec_('library', 'xs:Name', 0, 0, {'name': 'library', 'type': 'xs:Name'}, None),
        MemberSpec_('name', 'xs:NMTOKEN', 0, 0, {'name': 'name', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('version', 'xs:NMTOKEN', 0, 0, {'name': 'version', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('BusInterfaces', 'busInterfaces', 0, 1, {'minOccurs': '0', 'name': 'busInterfaces', 'ref': 'busInterfaces', 'type': 'busInterfaces'}, None),
        MemberSpec_('indirectInterfaces', 'indirectInterfaces', 0, 1, {'minOccurs': '0', 'name': 'indirectInterfaces', 'ref': 'indirectInterfaces', 'type': 'indirectInterfaces'}, None),
        MemberSpec_('channels', 'channels', 0, 1, {'minOccurs': '0', 'name': 'channels', 'ref': 'channels', 'type': 'channels'}, None),
        MemberSpec_('remapStates', 'remapStates', 0, 1, {'minOccurs': '0', 'name': 'remapStates', 'ref': 'remapStates', 'type': 'remapStates'}, None),
        MemberSpec_('addressSpaces', 'addressSpaces', 0, 1, {'minOccurs': '0', 'name': 'addressSpaces', 'ref': 'addressSpaces', 'type': 'addressSpaces'}, None),
        MemberSpec_('memoryMaps', 'memoryMaps', 0, 1, {'minOccurs': '0', 'name': 'memoryMaps', 'ref': 'memoryMaps', 'type': 'memoryMaps'}, None),
        MemberSpec_('model', 'modelType', 0, 1, {'minOccurs': '0', 'name': 'model', 'ref': 'model', 'type': 'model'}, None),
        MemberSpec_('componentGenerators', 'componentGenerators', 0, 1, {'minOccurs': '0', 'name': 'componentGenerators', 'ref': 'componentGenerators', 'type': 'componentGenerators'}, None),
        MemberSpec_('choices', 'choices', 0, 1, {'minOccurs': '0', 'name': 'choices', 'ref': 'choices', 'type': 'choices'}, None),
        MemberSpec_('fileSets', 'fileSets', 0, 1, {'minOccurs': '0', 'name': 'fileSets', 'ref': 'fileSets', 'type': 'fileSets'}, None),
        MemberSpec_('whiteboxElements', 'whiteboxElementsType', 0, 1, {'minOccurs': '0', 'name': 'whiteboxElements', 'type': 'whiteboxElementsType'}, None),
        MemberSpec_('cpus', 'cpusType', 0, 1, {'minOccurs': '0', 'name': 'cpus', 'type': 'cpusType'}, None),
        MemberSpec_('otherClockDrivers', 'otherClocks', 0, 1, {'minOccurs': '0', 'name': 'otherClockDrivers', 'type': 'otherClocks'}, None),
        MemberSpec_('resetTypes', 'resetTypesType', 0, 1, {'minOccurs': '0', 'name': 'resetTypes', 'type': 'resetTypesType'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('assertions', 'assertions', 0, 1, {'minOccurs': '0', 'name': 'assertions', 'ref': 'assertions', 'type': 'assertions'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, vendor=None, library=None, name=None, version=None, BusInterfaces=None, indirectInterfaces=None, channels=None, remapStates=None, addressSpaces=None, memoryMaps=None, model=None, componentGenerators=None, choices=None, fileSets=None, whiteboxElements=None, cpus=None, otherClockDrivers=None, resetTypes=None, description=None, parameters=None, assertions=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.vendor = vendor
        self.vendor_nsprefix_ = "ipxact"
        self.library = library
        self.library_nsprefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.version = version
        self.version_nsprefix_ = "ipxact"
        self.BusInterfaces = BusInterfaces
        self.BusInterfaces_nsprefix_ = "ipxact"
        self.indirectInterfaces = indirectInterfaces
        self.indirectInterfaces_nsprefix_ = "ipxact"
        self.channels = channels
        self.channels_nsprefix_ = "ipxact"
        self.remapStates = remapStates
        self.remapStates_nsprefix_ = "ipxact"
        self.addressSpaces = addressSpaces
        self.addressSpaces_nsprefix_ = "ipxact"
        self.memoryMaps = memoryMaps
        self.memoryMaps_nsprefix_ = "ipxact"
        self.model = model
        self.model_nsprefix_ = "ipxact"
        self.componentGenerators = componentGenerators
        self.componentGenerators_nsprefix_ = "ipxact"
        self.choices = choices
        self.choices_nsprefix_ = "ipxact"
        self.fileSets = fileSets
        self.fileSets_nsprefix_ = "ipxact"
        self.whiteboxElements = whiteboxElements
        self.whiteboxElements_nsprefix_ = "ipxact"
        self.cpus = cpus
        self.cpus_nsprefix_ = "ipxact"
        self.otherClockDrivers = otherClockDrivers
        self.otherClockDrivers_nsprefix_ = "ipxact"
        self.resetTypes = resetTypes
        self.resetTypes_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.assertions = assertions
        self.assertions_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Component)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Component.subclass:
            return Component.subclass(*args_, **kwargs_)
        else:
            return Component(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vendor(self):
        return self.vendor
    def set_vendor(self, vendor):
        self.vendor = vendor
    def get_library(self):
        return self.library
    def set_library(self, library):
        self.library = library
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_busInterfaces(self):
        return self.BusInterfaces
    def set_busInterfaces(self, BusInterfaces):
        self.BusInterfaces = BusInterfaces
    def get_indirectInterfaces(self):
        return self.indirectInterfaces
    def set_indirectInterfaces(self, indirectInterfaces):
        self.indirectInterfaces = indirectInterfaces
    def get_channels(self):
        return self.channels
    def set_channels(self, channels):
        self.channels = channels
    def get_remapStates(self):
        return self.remapStates
    def set_remapStates(self, remapStates):
        self.remapStates = remapStates
    def get_addressSpaces(self):
        return self.addressSpaces
    def set_addressSpaces(self, addressSpaces):
        self.addressSpaces = addressSpaces
    def get_memoryMaps(self):
        return self.memoryMaps
    def set_memoryMaps(self, memoryMaps):
        self.memoryMaps = memoryMaps
    def get_model(self):
        return self.model
    def set_model(self, model):
        self.model = model
    def get_componentGenerators(self):
        return self.componentGenerators
    def set_componentGenerators(self, componentGenerators):
        self.componentGenerators = componentGenerators
    def get_choices(self):
        return self.choices
    def set_choices(self, choices):
        self.choices = choices
    def get_fileSets(self):
        return self.fileSets
    def set_fileSets(self, fileSets):
        self.fileSets = fileSets
    def get_whiteboxElements(self):
        return self.whiteboxElements
    def set_whiteboxElements(self, whiteboxElements):
        self.whiteboxElements = whiteboxElements
    def get_cpus(self):
        return self.cpus
    def set_cpus(self, cpus):
        self.cpus = cpus
    def get_otherClockDrivers(self):
        return self.otherClockDrivers
    def set_otherClockDrivers(self, otherClockDrivers):
        self.otherClockDrivers = otherClockDrivers
    def get_resetTypes(self):
        return self.resetTypes
    def set_resetTypes(self, resetTypes):
        self.resetTypes = resetTypes
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_assertions(self):
        return self.assertions
    def set_assertions(self, assertions):
        self.assertions = assertions
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.vendor is not None or
            self.library is not None or
            self.name is not None or
            self.version is not None or
            self.BusInterfaces is not None or
            self.indirectInterfaces is not None or
            self.channels is not None or
            self.remapStates is not None or
            self.addressSpaces is not None or
            self.memoryMaps is not None or
            self.model is not None or
            self.componentGenerators is not None or
            self.choices is not None or
            self.fileSets is not None or
            self.whiteboxElements is not None or
            self.cpus is not None or
            self.otherClockDrivers is not None or
            self.resetTypes is not None or
            self.description is not None or
            self.parameters is not None or
            self.assertions is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('componentType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'componentType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='componentType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='componentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='componentType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='componentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vendor is not None:
            namespaceprefix_ = self.vendor_nsprefix_ + ':' if (UseCapturedNS_ and self.vendor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor>%s</%svendor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vendor), input_name='vendor')), namespaceprefix_ , eol_))
        if self.library is not None:
            namespaceprefix_ = self.library_nsprefix_ + ':' if (UseCapturedNS_ and self.library_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slibrary>%s</%slibrary>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.library), input_name='library')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.BusInterfaces is not None:
            namespaceprefix_ = self.BusInterfaces_nsprefix_ + ':' if (UseCapturedNS_ and self.BusInterfaces_nsprefix_) else ''
            self.BusInterfaces.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='busInterfaces', pretty_print=pretty_print)
        if self.indirectInterfaces is not None:
            namespaceprefix_ = self.indirectInterfaces_nsprefix_ + ':' if (UseCapturedNS_ and self.indirectInterfaces_nsprefix_) else ''
            self.indirectInterfaces.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='indirectInterfaces', pretty_print=pretty_print)
        if self.channels is not None:
            namespaceprefix_ = self.channels_nsprefix_ + ':' if (UseCapturedNS_ and self.channels_nsprefix_) else ''
            self.channels.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='channels', pretty_print=pretty_print)
        if self.remapStates is not None:
            namespaceprefix_ = self.remapStates_nsprefix_ + ':' if (UseCapturedNS_ and self.remapStates_nsprefix_) else ''
            self.remapStates.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='remapStates', pretty_print=pretty_print)
        if self.addressSpaces is not None:
            namespaceprefix_ = self.addressSpaces_nsprefix_ + ':' if (UseCapturedNS_ and self.addressSpaces_nsprefix_) else ''
            self.addressSpaces.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='addressSpaces', pretty_print=pretty_print)
        if self.memoryMaps is not None:
            namespaceprefix_ = self.memoryMaps_nsprefix_ + ':' if (UseCapturedNS_ and self.memoryMaps_nsprefix_) else ''
            self.memoryMaps.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='memoryMaps', pretty_print=pretty_print)
        if self.model is not None:
            namespaceprefix_ = self.model_nsprefix_ + ':' if (UseCapturedNS_ and self.model_nsprefix_) else ''
            self.model.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='model', pretty_print=pretty_print)
        if self.componentGenerators is not None:
            namespaceprefix_ = self.componentGenerators_nsprefix_ + ':' if (UseCapturedNS_ and self.componentGenerators_nsprefix_) else ''
            self.componentGenerators.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='componentGenerators', pretty_print=pretty_print)
        if self.choices is not None:
            namespaceprefix_ = self.choices_nsprefix_ + ':' if (UseCapturedNS_ and self.choices_nsprefix_) else ''
            self.choices.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='choices', pretty_print=pretty_print)
        if self.fileSets is not None:
            namespaceprefix_ = self.fileSets_nsprefix_ + ':' if (UseCapturedNS_ and self.fileSets_nsprefix_) else ''
            self.fileSets.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='fileSets', pretty_print=pretty_print)
        if self.whiteboxElements is not None:
            namespaceprefix_ = self.whiteboxElements_nsprefix_ + ':' if (UseCapturedNS_ and self.whiteboxElements_nsprefix_) else ''
            self.whiteboxElements.export(outfile, level, namespaceprefix_, namespacedef_='', name_='whiteboxElements', pretty_print=pretty_print)
        if self.cpus is not None:
            namespaceprefix_ = self.cpus_nsprefix_ + ':' if (UseCapturedNS_ and self.cpus_nsprefix_) else ''
            self.cpus.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cpus', pretty_print=pretty_print)
        if self.otherClockDrivers is not None:
            namespaceprefix_ = self.otherClockDrivers_nsprefix_ + ':' if (UseCapturedNS_ and self.otherClockDrivers_nsprefix_) else ''
            self.otherClockDrivers.export(outfile, level, namespaceprefix_, namespacedef_='', name_='otherClockDrivers', pretty_print=pretty_print)
        if self.resetTypes is not None:
            namespaceprefix_ = self.resetTypes_nsprefix_ + ':' if (UseCapturedNS_ and self.resetTypes_nsprefix_) else ''
            self.resetTypes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='resetTypes', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.assertions is not None:
            namespaceprefix_ = self.assertions_nsprefix_ + ':' if (UseCapturedNS_ and self.assertions_nsprefix_) else ''
            self.assertions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='assertions', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vendor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vendor')
            value_ = self.gds_validate_string(value_, node, 'vendor')
            self.vendor = value_
            self.vendor_nsprefix_ = child_.prefix
        elif nodeName_ == 'library':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'library')
            value_ = self.gds_validate_string(value_, node, 'library')
            self.library = value_
            self.library_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'busInterfaces':
            obj_ = BusInterfaces.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BusInterfaces = obj_
            obj_.original_tagname_ = 'busInterfaces'
        elif nodeName_ == 'indirectInterfaces':
            obj_ = indirectInterfaces.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.indirectInterfaces = obj_
            obj_.original_tagname_ = 'indirectInterfaces'
        elif nodeName_ == 'channels':
            obj_ = channels.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channels = obj_
            obj_.original_tagname_ = 'channels'
        elif nodeName_ == 'remapStates':
            obj_ = remapStates.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.remapStates = obj_
            obj_.original_tagname_ = 'remapStates'
        elif nodeName_ == 'addressSpaces':
            obj_ = addressSpaces.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addressSpaces = obj_
            obj_.original_tagname_ = 'addressSpaces'
        elif nodeName_ == 'memoryMaps':
            obj_ = memoryMaps.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.memoryMaps = obj_
            obj_.original_tagname_ = 'memoryMaps'
        elif nodeName_ == 'model':
            obj_ = Model.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.model = obj_
            obj_.original_tagname_ = 'model'
        elif nodeName_ == 'componentGenerators':
            obj_ = componentGenerators.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentGenerators = obj_
            obj_.original_tagname_ = 'componentGenerators'
        elif nodeName_ == 'choices':
            obj_ = choices.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.choices = obj_
            obj_.original_tagname_ = 'choices'
        elif nodeName_ == 'fileSets':
            obj_ = fileSets.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fileSets = obj_
            obj_.original_tagname_ = 'fileSets'
        elif nodeName_ == 'whiteboxElements':
            obj_ = whiteboxElementsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.whiteboxElements = obj_
            obj_.original_tagname_ = 'whiteboxElements'
        elif nodeName_ == 'cpus':
            obj_ = cpusType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cpus = obj_
            obj_.original_tagname_ = 'cpus'
        elif nodeName_ == 'otherClockDrivers':
            obj_ = otherClocks.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.otherClockDrivers = obj_
            obj_.original_tagname_ = 'otherClockDrivers'
        elif nodeName_ == 'resetTypes':
            obj_ = resetTypesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.resetTypes = obj_
            obj_.original_tagname_ = 'resetTypes'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'assertions':
            obj_ = assertions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assertions = obj_
            obj_.original_tagname_ = 'assertions'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class Component


class whiteboxElementType(GeneratedsSuper):
    """name -- Unique name
    whiteboxType -- Indicates the type of the element. The pin and signal types refer to elements within the HDL description. The register type refers to a register in the memory map. The interface type refers to a group of signals addressed as a single unit.
    driveable -- If true, indicates that the white box element can be driven (e.g. have a new value forced into it).
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('whiteboxType', ['simpleWhiteboxType', 'xs:token'], 0, 0, {'name': 'whiteboxType', 'type': 'xs:token'}, None),
        MemberSpec_('driveable', 'xs:boolean', 0, 1, {'default': 'false', 'minOccurs': '0', 'name': 'driveable', 'type': 'xs:boolean'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, isPresent=None, whiteboxType=None, driveable=False, parameters=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.whiteboxType = whiteboxType
        self.validate_simpleWhiteboxType(self.whiteboxType)
        self.whiteboxType_nsprefix_ = "ipxact"
        self.driveable = driveable
        self.driveable_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, whiteboxElementType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if whiteboxElementType.subclass:
            return whiteboxElementType.subclass(*args_, **kwargs_)
        else:
            return whiteboxElementType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_whiteboxType(self):
        return self.whiteboxType
    def set_whiteboxType(self, whiteboxType):
        self.whiteboxType = whiteboxType
    def get_driveable(self):
        return self.driveable
    def set_driveable(self, driveable):
        self.driveable = driveable
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_simpleWhiteboxType(self, value):
        result = True
        # Validate type simpleWhiteboxType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['signal', 'pin', 'interface']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on simpleWhiteboxType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.whiteboxType is not None or
            self.driveable or
            self.parameters is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='whiteboxElementType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('whiteboxElementType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'whiteboxElementType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='whiteboxElementType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='whiteboxElementType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='whiteboxElementType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='whiteboxElementType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.whiteboxType is not None:
            namespaceprefix_ = self.whiteboxType_nsprefix_ + ':' if (UseCapturedNS_ and self.whiteboxType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swhiteboxType>%s</%swhiteboxType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.whiteboxType), input_name='whiteboxType')), namespaceprefix_ , eol_))
        if self.driveable:
            namespaceprefix_ = self.driveable_nsprefix_ + ':' if (UseCapturedNS_ and self.driveable_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdriveable>%s</%sdriveable>%s' % (namespaceprefix_ , self.gds_format_boolean(self.driveable, input_name='driveable'), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'whiteboxType':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'whiteboxType')
            value_ = self.gds_validate_string(value_, node, 'whiteboxType')
            self.whiteboxType = value_
            self.whiteboxType_nsprefix_ = child_.prefix
            # validate type simpleWhiteboxType
            self.validate_simpleWhiteboxType(self.whiteboxType)
        elif nodeName_ == 'driveable':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'driveable')
            ival_ = self.gds_validate_boolean(ival_, node, 'driveable')
            self.driveable = ival_
            self.driveable_nsprefix_ = child_.prefix
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class whiteboxElementType


class complexBitSteeringExpression(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('valueOf_', ['simpleBitSteeringExpression', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complexBitSteeringExpression)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complexBitSteeringExpression.subclass:
            return complexBitSteeringExpression.subclass(*args_, **kwargs_)
        else:
            return complexBitSteeringExpression(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_simpleBitSteeringExpression(self, value):
        result = True
        # Validate type simpleBitSteeringExpression, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='complexBitSteeringExpression', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complexBitSteeringExpression')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'complexBitSteeringExpression':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complexBitSteeringExpression')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complexBitSteeringExpression', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='complexBitSteeringExpression'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='complexBitSteeringExpression', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class complexBitSteeringExpression


class viewRef(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('valueOf_', 'xs:NMTOKEN', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, viewRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if viewRef.subclass:
            return viewRef.subclass(*args_, **kwargs_)
        else:
            return viewRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='viewRef', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('viewRef')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'viewRef':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='viewRef')
        if self._hasContent():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='viewRef', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='viewRef'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='viewRef', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class viewRef


class BusInterfaces(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('BusInterface', 'busInterface', 1, 0, {'maxOccurs': 'unbounded', 'name': 'busInterface', 'ref': 'busInterface', 'type': 'busInterface'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, BusInterface=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if BusInterface is None:
            self.BusInterface = []
        else:
            self.BusInterface = BusInterface
        self.BusInterface_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BusInterfaces)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BusInterfaces.subclass:
            return BusInterfaces.subclass(*args_, **kwargs_)
        else:
            return BusInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_busInterface(self):
        return self.BusInterface
    def set_busInterface(self, BusInterface):
        self.BusInterface = BusInterface
    def add_busInterface(self, value):
        self.BusInterface.append(value)
    def insert_busInterface_at(self, index, value):
        self.BusInterface.insert(index, value)
    def replace_busInterface_at(self, index, value):
        self.BusInterface[index] = value
    def _hasContent(self):
        if (
            self.BusInterface
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='busInterfaces', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('busInterfaces')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'busInterfaces':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='busInterfaces')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='busInterfaces', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='busInterfaces'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='busInterfaces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for busInterface_ in self.BusInterface:
            namespaceprefix_ = self.BusInterface_nsprefix_ + ':' if (UseCapturedNS_ and self.BusInterface_nsprefix_) else ''
            busInterface_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='busInterface', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'busInterface':
            obj_ = BusInterface.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BusInterface.append(obj_)
            obj_.original_tagname_ = 'busInterface'
# end class BusInterfaces


class BusInterface(GeneratedsSuper):
    """name -- Unique name
    busType -- The bus type of this interface. Refers to bus definition using vendor, library, name, version attributes along with any configurable element values needed to configure this interface.
    master -- If this element is present, the bus interface can serve as a master.  This element encapsulates additional information related to its role as master.
    slave -- If this element is present, the bus interface can serve as a slave.
    system -- If this element is present, the bus interface is a system interface, neither master nor slave, with a specific function on the bus.
    mirroredSlave -- If this element is present, the bus interface represents a mirrored slave interface. All directional constraints on ports are reversed relative to the specification in the bus definition.
    mirroredMaster -- If this element is present, the bus interface represents a mirrored master interface. All directional constraints on ports are reversed relative to the specification in the bus definition.
    mirroredSystem -- If this element is present, the bus interface represents a mirrored system interface. All directional constraints on ports are reversed relative to the specification in the bus definition.
    monitor -- Indicates that this is a (passive) monitor interface. All of the ports in the interface must be inputs. The type of interface to be monitored is specified with the required interfaceType attribute. The ipxact:group element must be specified if monitoring a system interface.
    connectionRequired -- Indicates whether a connection to this interface is required for proper component functionality.
    bitSteering -- Indicates whether bit steering should be used to map this interface onto a bus of different data width.
    Values are "on", "off" (defaults to "off").
    endianness -- 'big': means the most significant element of any multi-element  data field is stored at the lowest memory address. 'little' means the least significant element of any multi-element data field is stored at the lowest memory address. If this element is not present the default is 'little' endian.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('busType', 'configurableLibraryRefType', 0, 0, {'name': 'busType', 'type': 'configurableLibraryRefType'}, None),
        MemberSpec_('AbstractionTypes', 'abstractionTypes', 0, 1, {'minOccurs': '0', 'name': 'abstractionTypes', 'ref': 'abstractionTypes', 'type': 'abstractionTypes'}, None),
        MemberSpec_('master', 'masterType', 0, 0, {'name': 'master', 'type': 'masterType'}, None),
        MemberSpec_('slave', 'slaveType', 0, 0, {'name': 'slave', 'type': 'slaveType'}, None),
        MemberSpec_('system', 'systemType', 0, 0, {'name': 'system', 'type': 'systemType'}, None),
        MemberSpec_('mirroredSlave', 'mirroredSlaveType', 0, 0, {'name': 'mirroredSlave', 'type': 'mirroredSlaveType'}, None),
        MemberSpec_('mirroredMaster', 'mirroredMasterType', 0, 0, {'name': 'mirroredMaster', 'type': 'mirroredMasterType'}, None),
        MemberSpec_('mirroredSystem', 'mirroredSystemType', 0, 0, {'name': 'mirroredSystem', 'type': 'mirroredSystemType'}, None),
        MemberSpec_('monitor', 'monitorType', 0, 0, {'name': 'monitor', 'type': 'monitorType'}, None),
        MemberSpec_('connectionRequired', 'xs:boolean', 0, 1, {'default': 'false', 'minOccurs': '0', 'name': 'connectionRequired', 'type': 'xs:boolean'}, None),
        MemberSpec_('bitsInLau', 'unsignedPositiveLongintExpression', 0, 1, {'minOccurs': '0', 'name': 'bitsInLau', 'ref': 'bitsInLau', 'type': 'bitsInLau'}, None),
        MemberSpec_('bitSteering', 'complexBitSteeringExpression', 0, 1, {'default': 'off', 'minOccurs': '0', 'name': 'bitSteering', 'type': 'complexBitSteeringExpression'}, None),
        MemberSpec_('endianness', ['endianessType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'endianness', 'type': 'xs:string'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, displayName=None, description=None, isPresent=None, busType=None, AbstractionTypes=None, master=None, slave=None, system=None, mirroredSlave=None, mirroredMaster=None, mirroredSystem=None, monitor=None, connectionRequired=False, bitsInLau=None, bitSteering=None, endianness=None, parameters=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.busType = busType
        self.busType_nsprefix_ = "ipxact"
        self.AbstractionTypes = AbstractionTypes
        self.AbstractionTypes_nsprefix_ = "ipxact"
        self.master = master
        self.master_nsprefix_ = "ipxact"
        self.slave = slave
        self.slave_nsprefix_ = "ipxact"
        self.system = system
        self.system_nsprefix_ = "ipxact"
        self.mirroredSlave = mirroredSlave
        self.mirroredSlave_nsprefix_ = "ipxact"
        self.mirroredMaster = mirroredMaster
        self.mirroredMaster_nsprefix_ = "ipxact"
        self.mirroredSystem = mirroredSystem
        self.mirroredSystem_nsprefix_ = "ipxact"
        self.monitor = monitor
        self.monitor_nsprefix_ = "ipxact"
        self.connectionRequired = connectionRequired
        self.connectionRequired_nsprefix_ = "ipxact"
        self.bitsInLau = bitsInLau
        self.bitsInLau_nsprefix_ = "ipxact"
        if bitSteering is None:
            self.bitSteering = globals()['complexBitSteeringExpression']('off')
        else:
            self.bitSteering = bitSteering
        self.bitSteering_nsprefix_ = "ipxact"
        self.endianness = endianness
        self.validate_endianessType(self.endianness)
        self.endianness_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BusInterface)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BusInterface.subclass:
            return BusInterface.subclass(*args_, **kwargs_)
        else:
            return BusInterface(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_busType(self):
        return self.busType
    def set_busType(self, busType):
        self.busType = busType
    def get_abstractionTypes(self):
        return self.AbstractionTypes
    def set_abstractionTypes(self, AbstractionTypes):
        self.AbstractionTypes = AbstractionTypes
    def get_master(self):
        return self.master
    def set_master(self, master):
        self.master = master
    def get_slave(self):
        return self.slave
    def set_slave(self, slave):
        self.slave = slave
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_mirroredSlave(self):
        return self.mirroredSlave
    def set_mirroredSlave(self, mirroredSlave):
        self.mirroredSlave = mirroredSlave
    def get_mirroredMaster(self):
        return self.mirroredMaster
    def set_mirroredMaster(self, mirroredMaster):
        self.mirroredMaster = mirroredMaster
    def get_mirroredSystem(self):
        return self.mirroredSystem
    def set_mirroredSystem(self, mirroredSystem):
        self.mirroredSystem = mirroredSystem
    def get_monitor(self):
        return self.monitor
    def set_monitor(self, monitor):
        self.monitor = monitor
    def get_connectionRequired(self):
        return self.connectionRequired
    def set_connectionRequired(self, connectionRequired):
        self.connectionRequired = connectionRequired
    def get_bitsInLau(self):
        return self.bitsInLau
    def set_bitsInLau(self, bitsInLau):
        self.bitsInLau = bitsInLau
    def get_bitSteering(self):
        return self.bitSteering
    def set_bitSteering(self, bitSteering):
        self.bitSteering = bitSteering
    def get_endianness(self):
        return self.endianness
    def set_endianness(self, endianness):
        self.endianness = endianness
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def validate_endianessType(self, value):
        result = True
        # Validate type endianessType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['big', 'little']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on endianessType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.isPresent is not None or
            self.busType is not None or
            self.AbstractionTypes is not None or
            self.master is not None or
            self.slave is not None or
            self.system is not None or
            self.mirroredSlave is not None or
            self.mirroredMaster is not None or
            self.mirroredSystem is not None or
            self.monitor is not None or
            self.connectionRequired or
            self.bitsInLau is not None or
            self.bitSteering is not None or
            self.endianness is not None or
            self.parameters is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='busInterfaceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('busInterfaceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'busInterfaceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='busInterfaceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='busInterfaceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='busInterfaceType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='busInterfaceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.busType is not None:
            namespaceprefix_ = self.busType_nsprefix_ + ':' if (UseCapturedNS_ and self.busType_nsprefix_) else ''
            self.busType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='busType', pretty_print=pretty_print)
        if self.AbstractionTypes is not None:
            namespaceprefix_ = self.AbstractionTypes_nsprefix_ + ':' if (UseCapturedNS_ and self.AbstractionTypes_nsprefix_) else ''
            self.AbstractionTypes.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='abstractionTypes', pretty_print=pretty_print)
        if self.master is not None:
            namespaceprefix_ = self.master_nsprefix_ + ':' if (UseCapturedNS_ and self.master_nsprefix_) else ''
            self.master.export(outfile, level, namespaceprefix_, namespacedef_='', name_='master', pretty_print=pretty_print)
        if self.slave is not None:
            namespaceprefix_ = self.slave_nsprefix_ + ':' if (UseCapturedNS_ and self.slave_nsprefix_) else ''
            self.slave.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slave', pretty_print=pretty_print)
        if self.system is not None:
            namespaceprefix_ = self.system_nsprefix_ + ':' if (UseCapturedNS_ and self.system_nsprefix_) else ''
            self.system.export(outfile, level, namespaceprefix_, namespacedef_='', name_='system', pretty_print=pretty_print)
        if self.mirroredSlave is not None:
            namespaceprefix_ = self.mirroredSlave_nsprefix_ + ':' if (UseCapturedNS_ and self.mirroredSlave_nsprefix_) else ''
            self.mirroredSlave.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mirroredSlave', pretty_print=pretty_print)
        if self.mirroredMaster is not None:
            namespaceprefix_ = self.mirroredMaster_nsprefix_ + ':' if (UseCapturedNS_ and self.mirroredMaster_nsprefix_) else ''
            self.mirroredMaster.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mirroredMaster', pretty_print=pretty_print)
        if self.mirroredSystem is not None:
            namespaceprefix_ = self.mirroredSystem_nsprefix_ + ':' if (UseCapturedNS_ and self.mirroredSystem_nsprefix_) else ''
            self.mirroredSystem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mirroredSystem', pretty_print=pretty_print)
        if self.monitor is not None:
            namespaceprefix_ = self.monitor_nsprefix_ + ':' if (UseCapturedNS_ and self.monitor_nsprefix_) else ''
            self.monitor.export(outfile, level, namespaceprefix_, namespacedef_='', name_='monitor', pretty_print=pretty_print)
        if self.connectionRequired:
            namespaceprefix_ = self.connectionRequired_nsprefix_ + ':' if (UseCapturedNS_ and self.connectionRequired_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconnectionRequired>%s</%sconnectionRequired>%s' % (namespaceprefix_ , self.gds_format_boolean(self.connectionRequired, input_name='connectionRequired'), namespaceprefix_ , eol_))
        if self.bitsInLau is not None:
            namespaceprefix_ = self.bitsInLau_nsprefix_ + ':' if (UseCapturedNS_ and self.bitsInLau_nsprefix_) else ''
            self.bitsInLau.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='bitsInLau', pretty_print=pretty_print)
        if self.bitSteering is not None:
            namespaceprefix_ = self.bitSteering_nsprefix_ + ':' if (UseCapturedNS_ and self.bitSteering_nsprefix_) else ''
            self.bitSteering.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bitSteering', pretty_print=pretty_print)
        if self.endianness is not None:
            namespaceprefix_ = self.endianness_nsprefix_ + ':' if (UseCapturedNS_ and self.endianness_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendianness>%s</%sendianness>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.endianness), input_name='endianness')), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'busType':
            obj_ = ConfigurableLibraryRef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.busType = obj_
            obj_.original_tagname_ = 'busType'
        elif nodeName_ == 'abstractionTypes':
            obj_ = AbstractionTypes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AbstractionTypes = obj_
            obj_.original_tagname_ = 'abstractionTypes'
        elif nodeName_ == 'master':
            obj_ = Master.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.master = obj_
            obj_.original_tagname_ = 'master'
        elif nodeName_ == 'slave':
            obj_ = Slave.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.slave = obj_
            obj_.original_tagname_ = 'slave'
        elif nodeName_ == 'system':
            obj_ = systemType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.system = obj_
            obj_.original_tagname_ = 'system'
        elif nodeName_ == 'mirroredSlave':
            obj_ = mirroredSlaveType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.mirroredSlave = obj_
            obj_.original_tagname_ = 'mirroredSlave'
        elif nodeName_ == 'mirroredMaster':
            obj_ = mirroredMasterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.mirroredMaster = obj_
            obj_.original_tagname_ = 'mirroredMaster'
        elif nodeName_ == 'mirroredSystem':
            obj_ = mirroredSystemType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.mirroredSystem = obj_
            obj_.original_tagname_ = 'mirroredSystem'
        elif nodeName_ == 'monitor':
            obj_ = monitorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.monitor = obj_
            obj_.original_tagname_ = 'monitor'
        elif nodeName_ == 'connectionRequired':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'connectionRequired')
            ival_ = self.gds_validate_boolean(ival_, node, 'connectionRequired')
            self.connectionRequired = ival_
            self.connectionRequired_nsprefix_ = child_.prefix
        elif nodeName_ == 'bitsInLau':
            obj_ = unsignedPositiveLongintExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bitsInLau = obj_
            obj_.original_tagname_ = 'bitsInLau'
        elif nodeName_ == 'bitSteering':
            obj_ = complexBitSteeringExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bitSteering = obj_
            obj_.original_tagname_ = 'bitSteering'
        elif nodeName_ == 'endianness':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'endianness')
            value_ = self.gds_validate_string(value_, node, 'endianness')
            self.endianness = value_
            self.endianness_nsprefix_ = child_.prefix
            # validate type endianessType
            self.validate_endianessType(self.endianness)
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class BusInterface


class channels(GeneratedsSuper):
    """channel -- Defines a set of mirrored interfaces of this component that are connected to one another.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('channel', 'channelType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'channel', 'type': 'channelType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, channel=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if channel is None:
            self.channel = []
        else:
            self.channel = channel
        self.channel_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, channels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if channels.subclass:
            return channels.subclass(*args_, **kwargs_)
        else:
            return channels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_channel(self):
        return self.channel
    def set_channel(self, channel):
        self.channel = channel
    def add_channel(self, value):
        self.channel.append(value)
    def insert_channel_at(self, index, value):
        self.channel.insert(index, value)
    def replace_channel_at(self, index, value):
        self.channel[index] = value
    def _hasContent(self):
        if (
            self.channel
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='channels', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('channels')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'channels':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='channels')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='channels', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='channels'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='channels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for channel_ in self.channel:
            namespaceprefix_ = self.channel_nsprefix_ + ':' if (UseCapturedNS_ and self.channel_nsprefix_) else ''
            channel_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='channel', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'channel':
            obj_ = channelType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel.append(obj_)
            obj_.original_tagname_ = 'channel'
# end class channels


class remapStates(GeneratedsSuper):
    """remapState -- Contains a list of ports and values in remapPort and a list of registers and values that when all evaluate to true which tell the decoder to enter this remap state. The name attribute identifies the name of the state. If
    a list of remapPorts and/or remapRegisters is not defined then the condition for that state cannot be defined.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('remapState', 'remapStateType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'remapState', 'type': 'remapStateType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, remapState=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if remapState is None:
            self.remapState = []
        else:
            self.remapState = remapState
        self.remapState_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, remapStates)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if remapStates.subclass:
            return remapStates.subclass(*args_, **kwargs_)
        else:
            return remapStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_remapState(self):
        return self.remapState
    def set_remapState(self, remapState):
        self.remapState = remapState
    def add_remapState(self, value):
        self.remapState.append(value)
    def insert_remapState_at(self, index, value):
        self.remapState.insert(index, value)
    def replace_remapState_at(self, index, value):
        self.remapState[index] = value
    def _hasContent(self):
        if (
            self.remapState
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='remapStates', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('remapStates')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'remapStates':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='remapStates')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='remapStates', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='remapStates'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='remapStates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for remapState_ in self.remapState:
            namespaceprefix_ = self.remapState_nsprefix_ + ':' if (UseCapturedNS_ and self.remapState_nsprefix_) else ''
            remapState_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='remapState', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'remapState':
            obj_ = remapStateType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.remapState.append(obj_)
            obj_.original_tagname_ = 'remapState'
# end class remapStates


class transparentBridge(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('masterRef', 'xs:Name', 0, 0, {'use': 'required', 'name': 'masterRef'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, masterRef=None, id=None, isPresent=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.masterRef = _cast(None, masterRef)
        self.masterRef_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transparentBridge)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transparentBridge.subclass:
            return transparentBridge.subclass(*args_, **kwargs_)
        else:
            return transparentBridge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_masterRef(self):
        return self.masterRef
    def set_masterRef(self, masterRef):
        self.masterRef = masterRef
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.isPresent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='transparentBridge', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('transparentBridge')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'transparentBridge':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='transparentBridge')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='transparentBridge', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='transparentBridge'):
        if self.masterRef is not None and 'masterRef' not in already_processed:
            already_processed.add('masterRef')
            outfile.write(' masterRef=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.masterRef), input_name='masterRef')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='transparentBridge', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('masterRef', node)
        if value is not None and 'masterRef' not in already_processed:
            already_processed.add('masterRef')
            self.masterRef = value
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
# end class transparentBridge


class abstractorBusInterfaceType(GeneratedsSuper):
    """name -- Unique name
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('AbstractionTypes', 'abstractionTypes', 0, 1, {'minOccurs': '0', 'name': 'abstractionTypes', 'ref': 'abstractionTypes', 'type': 'abstractionTypes'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, displayName=None, description=None, AbstractionTypes=None, parameters=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.AbstractionTypes = AbstractionTypes
        self.AbstractionTypes_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, abstractorBusInterfaceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if abstractorBusInterfaceType.subclass:
            return abstractorBusInterfaceType.subclass(*args_, **kwargs_)
        else:
            return abstractorBusInterfaceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_abstractionTypes(self):
        return self.AbstractionTypes
    def set_abstractionTypes(self, AbstractionTypes):
        self.AbstractionTypes = AbstractionTypes
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.AbstractionTypes is not None or
            self.parameters is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorBusInterfaceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractorBusInterfaceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractorBusInterfaceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractorBusInterfaceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractorBusInterfaceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractorBusInterfaceType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractorBusInterfaceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.AbstractionTypes is not None:
            namespaceprefix_ = self.AbstractionTypes_nsprefix_ + ':' if (UseCapturedNS_ and self.AbstractionTypes_nsprefix_) else ''
            self.AbstractionTypes.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='abstractionTypes', pretty_print=pretty_print)
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'abstractionTypes':
            obj_ = AbstractionTypes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AbstractionTypes = obj_
            obj_.original_tagname_ = 'abstractionTypes'
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class abstractorBusInterfaceType


class indirectInterfaces(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('indirectInterface', 'indirectInterfaceType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'indirectInterface', 'ref': 'indirectInterface', 'type': 'indirectInterface'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, indirectInterface=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if indirectInterface is None:
            self.indirectInterface = []
        else:
            self.indirectInterface = indirectInterface
        self.indirectInterface_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, indirectInterfaces)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if indirectInterfaces.subclass:
            return indirectInterfaces.subclass(*args_, **kwargs_)
        else:
            return indirectInterfaces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_indirectInterface(self):
        return self.indirectInterface
    def set_indirectInterface(self, indirectInterface):
        self.indirectInterface = indirectInterface
    def add_indirectInterface(self, value):
        self.indirectInterface.append(value)
    def insert_indirectInterface_at(self, index, value):
        self.indirectInterface.insert(index, value)
    def replace_indirectInterface_at(self, index, value):
        self.indirectInterface[index] = value
    def _hasContent(self):
        if (
            self.indirectInterface
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indirectInterfaces', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('indirectInterfaces')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'indirectInterfaces':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='indirectInterfaces')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='indirectInterfaces', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='indirectInterfaces'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indirectInterfaces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for indirectInterface_ in self.indirectInterface:
            namespaceprefix_ = self.indirectInterface_nsprefix_ + ':' if (UseCapturedNS_ and self.indirectInterface_nsprefix_) else ''
            indirectInterface_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='indirectInterface', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'indirectInterface':
            obj_ = indirectInterfaceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.indirectInterface.append(obj_)
            obj_.original_tagname_ = 'indirectInterface'
# end class indirectInterfaces


class indirectInterfaceType(GeneratedsSuper):
    """name -- Unique name
    memoryMapRef -- A reference to a memoryMap. This memoryMap is indirectly accessible through this interface.
    endianness -- 'big': means the most significant element of any multi-element  data field is stored at the lowest memory address. 'little' means the least significant element of any multi-element data field is stored at the lowest memory address. If this element is not present the default is 'little' endian.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('indirectAddressRef', 'xs:Name', 0, 0, {'name': 'indirectAddressRef', 'ref': 'indirectAddressRef', 'type': 'xs:Name'}, None),
        MemberSpec_('indirectDataRef', 'xs:Name', 0, 0, {'name': 'indirectDataRef', 'ref': 'indirectDataRef', 'type': 'xs:Name'}, None),
        MemberSpec_('memoryMapRef', 'memoryMapRefType', 0, 0, {'name': 'memoryMapRef', 'type': 'xs:Name'}, 14),
        MemberSpec_('transparentBridge', 'transparentBridge', 1, 0, {'maxOccurs': 'unbounded', 'name': 'transparentBridge', 'ref': 'transparentBridge', 'type': 'transparentBridge'}, 14),
        MemberSpec_('bitsInLau', 'unsignedPositiveLongintExpression', 0, 1, {'minOccurs': '0', 'name': 'bitsInLau', 'ref': 'bitsInLau', 'type': 'bitsInLau'}, None),
        MemberSpec_('endianness', ['endianessType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'endianness', 'type': 'xs:string'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, displayName=None, description=None, indirectAddressRef=None, indirectDataRef=None, memoryMapRef=None, transparentBridge=None, bitsInLau=None, endianness=None, parameters=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.indirectAddressRef = indirectAddressRef
        self.indirectAddressRef_nsprefix_ = "ipxact"
        self.indirectDataRef = indirectDataRef
        self.indirectDataRef_nsprefix_ = "ipxact"
        self.memoryMapRef = memoryMapRef
        self.memoryMapRef_nsprefix_ = "ipxact"
        if transparentBridge is None:
            self.transparentBridge = []
        else:
            self.transparentBridge = transparentBridge
        self.transparentBridge_nsprefix_ = "ipxact"
        self.bitsInLau = bitsInLau
        self.bitsInLau_nsprefix_ = "ipxact"
        self.endianness = endianness
        self.validate_endianessType(self.endianness)
        self.endianness_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, indirectInterfaceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if indirectInterfaceType.subclass:
            return indirectInterfaceType.subclass(*args_, **kwargs_)
        else:
            return indirectInterfaceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_indirectAddressRef(self):
        return self.indirectAddressRef
    def set_indirectAddressRef(self, indirectAddressRef):
        self.indirectAddressRef = indirectAddressRef
    def get_indirectDataRef(self):
        return self.indirectDataRef
    def set_indirectDataRef(self, indirectDataRef):
        self.indirectDataRef = indirectDataRef
    def get_memoryMapRef(self):
        return self.memoryMapRef
    def set_memoryMapRef(self, memoryMapRef):
        self.memoryMapRef = memoryMapRef
    def get_transparentBridge(self):
        return self.transparentBridge
    def set_transparentBridge(self, transparentBridge):
        self.transparentBridge = transparentBridge
    def add_transparentBridge(self, value):
        self.transparentBridge.append(value)
    def insert_transparentBridge_at(self, index, value):
        self.transparentBridge.insert(index, value)
    def replace_transparentBridge_at(self, index, value):
        self.transparentBridge[index] = value
    def get_bitsInLau(self):
        return self.bitsInLau
    def set_bitsInLau(self, bitsInLau):
        self.bitsInLau = bitsInLau
    def get_endianness(self):
        return self.endianness
    def set_endianness(self, endianness):
        self.endianness = endianness
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def validate_endianessType(self, value):
        result = True
        # Validate type endianessType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['big', 'little']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on endianessType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.indirectAddressRef is not None or
            self.indirectDataRef is not None or
            self.memoryMapRef is not None or
            self.transparentBridge or
            self.bitsInLau is not None or
            self.endianness is not None or
            self.parameters is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indirectInterfaceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('indirectInterfaceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'indirectInterfaceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='indirectInterfaceType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='indirectInterfaceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='indirectInterfaceType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='indirectInterfaceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.indirectAddressRef is not None:
            namespaceprefix_ = self.indirectAddressRef_nsprefix_ + ':' if (UseCapturedNS_ and self.indirectAddressRef_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindirectAddressRef>%s</%sindirectAddressRef>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indirectAddressRef), input_name='indirectAddressRef')), namespaceprefix_ , eol_))
        if self.indirectDataRef is not None:
            namespaceprefix_ = self.indirectDataRef_nsprefix_ + ':' if (UseCapturedNS_ and self.indirectDataRef_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindirectDataRef>%s</%sindirectDataRef>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indirectDataRef), input_name='indirectDataRef')), namespaceprefix_ , eol_))
        if self.memoryMapRef is not None:
            namespaceprefix_ = self.memoryMapRef_nsprefix_ + ':' if (UseCapturedNS_ and self.memoryMapRef_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemoryMapRef>%s</%smemoryMapRef>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.memoryMapRef), input_name='memoryMapRef')), namespaceprefix_ , eol_))
        for transparentBridge_ in self.transparentBridge:
            namespaceprefix_ = self.transparentBridge_nsprefix_ + ':' if (UseCapturedNS_ and self.transparentBridge_nsprefix_) else ''
            transparentBridge_.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='transparentBridge', pretty_print=pretty_print)
        if self.bitsInLau is not None:
            namespaceprefix_ = self.bitsInLau_nsprefix_ + ':' if (UseCapturedNS_ and self.bitsInLau_nsprefix_) else ''
            self.bitsInLau.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='bitsInLau', pretty_print=pretty_print)
        if self.endianness is not None:
            namespaceprefix_ = self.endianness_nsprefix_ + ':' if (UseCapturedNS_ and self.endianness_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendianness>%s</%sendianness>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.endianness), input_name='endianness')), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'indirectAddressRef':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indirectAddressRef')
            value_ = self.gds_validate_string(value_, node, 'indirectAddressRef')
            self.indirectAddressRef = value_
            self.indirectAddressRef_nsprefix_ = child_.prefix
        elif nodeName_ == 'indirectDataRef':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indirectDataRef')
            value_ = self.gds_validate_string(value_, node, 'indirectDataRef')
            self.indirectDataRef = value_
            self.indirectDataRef_nsprefix_ = child_.prefix
        elif nodeName_ == 'memoryMapRef':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'memoryMapRef')
            value_ = self.gds_validate_string(value_, node, 'memoryMapRef')
            self.memoryMapRef = value_
            self.memoryMapRef_nsprefix_ = child_.prefix
        elif nodeName_ == 'transparentBridge':
            obj_ = transparentBridge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transparentBridge.append(obj_)
            obj_.original_tagname_ = 'transparentBridge'
        elif nodeName_ == 'bitsInLau':
            obj_ = unsignedPositiveLongintExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bitsInLau = obj_
            obj_.original_tagname_ = 'bitsInLau'
        elif nodeName_ == 'endianness':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'endianness')
            value_ = self.gds_validate_string(value_, node, 'endianness')
            self.endianness = value_
            self.endianness_nsprefix_ = child_.prefix
            # validate type endianessType
            self.validate_endianessType(self.endianness)
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class indirectInterfaceType


class AbstractionTypes(GeneratedsSuper):
    """abstractionType -- The abstraction type/level of this interface. Refers to abstraction definition using vendor, library, name, version attributes along with any configurable element values needed to configure this abstraction. Bus definition can be found through a reference in this file.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('abstractionType', 'abstractionTypeType', 1, 0, {'maxOccurs': 'unbounded', 'name': 'abstractionType', 'type': 'abstractionTypeType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, abstractionType=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        if abstractionType is None:
            self.abstractionType = []
        else:
            self.abstractionType = abstractionType
        self.abstractionType_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AbstractionTypes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AbstractionTypes.subclass:
            return AbstractionTypes.subclass(*args_, **kwargs_)
        else:
            return AbstractionTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_abstractionType(self):
        return self.abstractionType
    def set_abstractionType(self, abstractionType):
        self.abstractionType = abstractionType
    def add_abstractionType(self, value):
        self.abstractionType.append(value)
    def insert_abstractionType_at(self, index, value):
        self.abstractionType.insert(index, value)
    def replace_abstractionType_at(self, index, value):
        self.abstractionType[index] = value
    def _hasContent(self):
        if (
            self.abstractionType
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractionTypes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractionTypes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractionTypes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractionTypes')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractionTypes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractionTypes'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractionTypes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for abstractionType_ in self.abstractionType:
            namespaceprefix_ = self.abstractionType_nsprefix_ + ':' if (UseCapturedNS_ and self.abstractionType_nsprefix_) else ''
            abstractionType_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abstractionType', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'abstractionType':
            obj_ = AbstractionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.abstractionType.append(obj_)
            obj_.original_tagname_ = 'abstractionType'
# end class AbstractionTypes


class abstractionDefinition(GeneratedsSuper):
    """vendor -- Name of the vendor who supplies this file.
    library -- Name of the logical library this element belongs to.
    name -- The name of the object.
    version -- Indicates the version of the named element.
    busType -- Reference to the busDefinition that this abstractionDefinition implements.
    extends -- Optional name of abstraction type that this abstraction definition is compatible with. This abstraction definition may change the definitions of ports in the existing abstraction definition and add new ports, the ports in the original abstraction are not deleted but may be marked illegal to disallow their use.
    This abstraction definition may only extend another abstraction definition if the bus type of this abstraction definition extends the bus type of the extended abstraction definition
    ports -- This is a list of logical ports defined by the bus.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('vendor', 'xs:Name', 0, 0, {'name': 'vendor', 'type': 'xs:Name'}, None),
        MemberSpec_('library', 'xs:Name', 0, 0, {'name': 'library', 'type': 'xs:Name'}, None),
        MemberSpec_('name', 'xs:NMTOKEN', 0, 0, {'name': 'name', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('version', 'xs:NMTOKEN', 0, 0, {'name': 'version', 'type': 'xs:NMTOKEN'}, None),
        MemberSpec_('busType', 'libraryRefType', 0, 0, {'name': 'busType', 'type': 'libraryRefType'}, None),
        MemberSpec_('extends', 'libraryRefType', 0, 1, {'minOccurs': '0', 'name': 'extends', 'type': 'libraryRefType'}, None),
        MemberSpec_('ports', 'portsType', 0, 0, {'name': 'ports', 'type': 'portsType'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('assertions', 'assertions', 0, 1, {'minOccurs': '0', 'name': 'assertions', 'ref': 'assertions', 'type': 'assertions'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, vendor=None, library=None, name=None, version=None, busType=None, extends=None, ports=None, description=None, parameters=None, assertions=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.vendor = vendor
        self.vendor_nsprefix_ = "ipxact"
        self.library = library
        self.library_nsprefix_ = "ipxact"
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.version = version
        self.version_nsprefix_ = "ipxact"
        self.busType = busType
        self.busType_nsprefix_ = "ipxact"
        self.extends = extends
        self.extends_nsprefix_ = "ipxact"
        self.ports = ports
        self.ports_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.assertions = assertions
        self.assertions_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, abstractionDefinition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if abstractionDefinition.subclass:
            return abstractionDefinition.subclass(*args_, **kwargs_)
        else:
            return abstractionDefinition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vendor(self):
        return self.vendor
    def set_vendor(self, vendor):
        self.vendor = vendor
    def get_library(self):
        return self.library
    def set_library(self, library):
        self.library = library
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_busType(self):
        return self.busType
    def set_busType(self, busType):
        self.busType = busType
    def get_extends(self):
        return self.extends
    def set_extends(self, extends):
        self.extends = extends
    def get_ports(self):
        return self.ports
    def set_ports(self, ports):
        self.ports = ports
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_assertions(self):
        return self.assertions
    def set_assertions(self, assertions):
        self.assertions = assertions
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def _hasContent(self):
        if (
            self.vendor is not None or
            self.library is not None or
            self.name is not None or
            self.version is not None or
            self.busType is not None or
            self.extends is not None or
            self.ports is not None or
            self.description is not None or
            self.parameters is not None or
            self.assertions is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractionDefinition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('abstractionDefinition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'abstractionDefinition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='abstractionDefinition')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='abstractionDefinition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='abstractionDefinition'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='abstractionDefinition', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vendor is not None:
            namespaceprefix_ = self.vendor_nsprefix_ + ':' if (UseCapturedNS_ and self.vendor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svendor>%s</%svendor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vendor), input_name='vendor')), namespaceprefix_ , eol_))
        if self.library is not None:
            namespaceprefix_ = self.library_nsprefix_ + ':' if (UseCapturedNS_ and self.library_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slibrary>%s</%slibrary>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.library), input_name='library')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.busType is not None:
            namespaceprefix_ = self.busType_nsprefix_ + ':' if (UseCapturedNS_ and self.busType_nsprefix_) else ''
            self.busType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='busType', pretty_print=pretty_print)
        if self.extends is not None:
            namespaceprefix_ = self.extends_nsprefix_ + ':' if (UseCapturedNS_ and self.extends_nsprefix_) else ''
            self.extends.export(outfile, level, namespaceprefix_, namespacedef_='', name_='extends', pretty_print=pretty_print)
        if self.ports is not None:
            namespaceprefix_ = self.ports_nsprefix_ + ':' if (UseCapturedNS_ and self.ports_nsprefix_) else ''
            self.ports.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ports', pretty_print=pretty_print)
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.assertions is not None:
            namespaceprefix_ = self.assertions_nsprefix_ + ':' if (UseCapturedNS_ and self.assertions_nsprefix_) else ''
            self.assertions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='assertions', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vendor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vendor')
            value_ = self.gds_validate_string(value_, node, 'vendor')
            self.vendor = value_
            self.vendor_nsprefix_ = child_.prefix
        elif nodeName_ == 'library':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'library')
            value_ = self.gds_validate_string(value_, node, 'library')
            self.library = value_
            self.library_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'busType':
            obj_ = LibraryRef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.busType = obj_
            obj_.original_tagname_ = 'busType'
        elif nodeName_ == 'extends':
            obj_ = LibraryRef.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extends = obj_
            obj_.original_tagname_ = 'extends'
        elif nodeName_ == 'ports':
            obj_ = Ports.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ports = obj_
            obj_.original_tagname_ = 'ports'
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'assertions':
            obj_ = assertions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assertions = obj_
            obj_.original_tagname_ = 'assertions'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class abstractionDefinition


class addressBankType(GeneratedsSuper):
    """name -- Unique name
    addressBlock -- An address block within the bank.  No address information is supplied.
    bank -- A nested bank of blocks within a bank.  No address information is supplied.
    subspaceMap -- A subspace map within the bank.  No address information is supplied.
    Indicates the usage of this block.  Possible values are 'memory', 'register' and 'reserved'.
    usage -- Indicates the usage of this block.  Possible values are 'memory', 'register' and 'reserved'.
    parameters -- Any additional parameters needed to describe this address block to the generators.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('bankAlignment', 'ipxact:bankAlignmentType', 0, 0, {'use': 'required', 'name': 'bankAlignment'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('accessHandles', 'accessHandlesType43', 0, 1, {'minOccurs': '0', 'name': 'accessHandles', 'type': 'accessHandlesType43'}, None),
        MemberSpec_('baseAddress', 'unsignedLongintExpression', 0, 0, {'name': 'baseAddress', 'ref': 'baseAddress', 'type': 'baseAddress'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('addressBlock', 'addressBlockType', 1, 0, {'name': 'addressBlock', 'type': 'bankedBlockType'}, 15),
        MemberSpec_('bank', 'addressBankType', 1, 0, {'name': 'bank', 'type': 'bankedBankType'}, 15),
        MemberSpec_('subspaceMap', 'bankedSubspaceType', 1, 0, {'name': 'subspaceMap', 'type': 'bankedSubspaceType'}, 15),
        MemberSpec_('usage', ['usageType', 'xs:token'], 0, 1, {'minOccurs': '0', 'name': 'usage', 'type': 'xs:token'}, None),
        MemberSpec_('volatile', 'xs:boolean', 0, 1, {'minOccurs': '0', 'name': 'volatile', 'ref': 'volatile', 'type': 'xs:boolean'}, None),
        MemberSpec_('access', 'accessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'ref': 'access', 'type': 'access'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, bankAlignment=None, id=None, name=None, displayName=None, description=None, accessHandles=None, baseAddress=None, isPresent=None, addressBlock=None, bank=None, subspaceMap=None, usage=None, volatile=None, access=None, parameters=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.bankAlignment = _cast(None, bankAlignment)
        self.bankAlignment_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.accessHandles = accessHandles
        self.accessHandles_nsprefix_ = "ipxact"
        self.baseAddress = baseAddress
        self.baseAddress_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        if addressBlock is None:
            self.addressBlock = []
        else:
            self.addressBlock = addressBlock
        self.addressBlock_nsprefix_ = "ipxact"
        if bank is None:
            self.bank = []
        else:
            self.bank = bank
        self.bank_nsprefix_ = "ipxact"
        if subspaceMap is None:
            self.subspaceMap = []
        else:
            self.subspaceMap = subspaceMap
        self.subspaceMap_nsprefix_ = "ipxact"
        self.usage = usage
        self.validate_usageType(self.usage)
        self.usage_nsprefix_ = "ipxact"
        self.volatile = volatile
        self.volatile_nsprefix_ = "ipxact"
        self.access = access
        self.access_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, addressBankType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if addressBankType.subclass:
            return addressBankType.subclass(*args_, **kwargs_)
        else:
            return addressBankType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_accessHandles(self):
        return self.accessHandles
    def set_accessHandles(self, accessHandles):
        self.accessHandles = accessHandles
    def get_baseAddress(self):
        return self.baseAddress
    def set_baseAddress(self, baseAddress):
        self.baseAddress = baseAddress
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_addressBlock(self):
        return self.addressBlock
    def set_addressBlock(self, addressBlock):
        self.addressBlock = addressBlock
    def add_addressBlock(self, value):
        self.addressBlock.append(value)
    def insert_addressBlock_at(self, index, value):
        self.addressBlock.insert(index, value)
    def replace_addressBlock_at(self, index, value):
        self.addressBlock[index] = value
    def get_bank(self):
        return self.bank
    def set_bank(self, bank):
        self.bank = bank
    def add_bank(self, value):
        self.bank.append(value)
    def insert_bank_at(self, index, value):
        self.bank.insert(index, value)
    def replace_bank_at(self, index, value):
        self.bank[index] = value
    def get_subspaceMap(self):
        return self.subspaceMap
    def set_subspaceMap(self, subspaceMap):
        self.subspaceMap = subspaceMap
    def add_subspaceMap(self, value):
        self.subspaceMap.append(value)
    def insert_subspaceMap_at(self, index, value):
        self.subspaceMap.insert(index, value)
    def replace_subspaceMap_at(self, index, value):
        self.subspaceMap[index] = value
    def get_usage(self):
        return self.usage
    def set_usage(self, usage):
        self.usage = usage
    def get_volatile(self):
        return self.volatile
    def set_volatile(self, volatile):
        self.volatile = volatile
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_bankAlignment(self):
        return self.bankAlignment
    def set_bankAlignment(self, bankAlignment):
        self.bankAlignment = bankAlignment
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_usageType(self, value):
        result = True
        # Validate type usageType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['memory', 'register', 'reserved']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on usageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_bankAlignmentType(self, value):
        # Validate type ipxact:bankAlignmentType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['serial', 'parallel']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on bankAlignmentType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.accessHandles is not None or
            self.baseAddress is not None or
            self.isPresent is not None or
            self.addressBlock or
            self.bank or
            self.subspaceMap or
            self.usage is not None or
            self.volatile is not None or
            self.access is not None or
            self.parameters is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='addressBankType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('addressBankType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'addressBankType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='addressBankType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='addressBankType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='addressBankType'):
        if self.bankAlignment is not None and 'bankAlignment' not in already_processed:
            already_processed.add('bankAlignment')
            outfile.write(' bankAlignment=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.bankAlignment), input_name='bankAlignment')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='addressBankType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.accessHandles is not None:
            namespaceprefix_ = self.accessHandles_nsprefix_ + ':' if (UseCapturedNS_ and self.accessHandles_nsprefix_) else ''
            self.accessHandles.export(outfile, level, namespaceprefix_, namespacedef_='', name_='accessHandles', pretty_print=pretty_print)
        if self.baseAddress is not None:
            namespaceprefix_ = self.baseAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.baseAddress_nsprefix_) else ''
            self.baseAddress.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='baseAddress', pretty_print=pretty_print)
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        for addressBlock_ in self.addressBlock:
            namespaceprefix_ = self.addressBlock_nsprefix_ + ':' if (UseCapturedNS_ and self.addressBlock_nsprefix_) else ''
            addressBlock_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addressBlock', pretty_print=pretty_print)
        for bank_ in self.bank:
            namespaceprefix_ = self.bank_nsprefix_ + ':' if (UseCapturedNS_ and self.bank_nsprefix_) else ''
            bank_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bank', pretty_print=pretty_print)
        for subspaceMap_ in self.subspaceMap:
            namespaceprefix_ = self.subspaceMap_nsprefix_ + ':' if (UseCapturedNS_ and self.subspaceMap_nsprefix_) else ''
            subspaceMap_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subspaceMap', pretty_print=pretty_print)
        if self.usage is not None:
            namespaceprefix_ = self.usage_nsprefix_ + ':' if (UseCapturedNS_ and self.usage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.usage), input_name='usage')), namespaceprefix_ , eol_))
        if self.volatile is not None:
            namespaceprefix_ = self.volatile_nsprefix_ + ':' if (UseCapturedNS_ and self.volatile_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolatile>%s</%svolatile>%s' % (namespaceprefix_ , self.gds_format_boolean(self.volatile, input_name='volatile'), namespaceprefix_ , eol_))
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('bankAlignment', node)
        if value is not None and 'bankAlignment' not in already_processed:
            already_processed.add('bankAlignment')
            self.bankAlignment = value
            self.bankAlignment = ' '.join(self.bankAlignment.split())
            self.validate_bankAlignmentType(self.bankAlignment)    # validate type bankAlignmentType
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'accessHandles':
            obj_ = accessHandlesType43.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.accessHandles = obj_
            obj_.original_tagname_ = 'accessHandles'
        elif nodeName_ == 'baseAddress':
            class_obj_ = self.get_class_obj_(child_, unsignedLongintExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.baseAddress = obj_
            obj_.original_tagname_ = 'baseAddress'
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'addressBlock':
            obj_ = bankedBlockType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addressBlock.append(obj_)
            obj_.original_tagname_ = 'addressBlock'
        elif nodeName_ == 'bank':
            obj_ = bankedBankType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bank.append(obj_)
            obj_.original_tagname_ = 'bank'
        elif nodeName_ == 'subspaceMap':
            obj_ = bankedSubspaceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subspaceMap.append(obj_)
            obj_.original_tagname_ = 'subspaceMap'
        elif nodeName_ == 'usage':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'usage')
            value_ = self.gds_validate_string(value_, node, 'usage')
            self.usage = value_
            self.usage_nsprefix_ = child_.prefix
            # validate type usageType
            self.validate_usageType(self.usage)
        elif nodeName_ == 'volatile':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'volatile')
            ival_ = self.gds_validate_boolean(ival_, node, 'volatile')
            self.volatile = ival_
            self.volatile_nsprefix_ = child_.prefix
        elif nodeName_ == 'access':
            obj_ = accessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class addressBankType


class localAddressBankType(GeneratedsSuper):
    """name -- Unique name
    addressBlock -- An address block within the bank.  No address information is supplied.
    bank -- A nested bank of blocks within a bank.  No address information is supplied.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('bankAlignment', 'ipxact:bankAlignmentType', 0, 0, {'use': 'required', 'name': 'bankAlignment'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('accessHandles', 'accessHandlesType44', 0, 1, {'minOccurs': '0', 'name': 'accessHandles', 'type': 'accessHandlesType44'}, None),
        MemberSpec_('baseAddress', 'unsignedLongintExpression', 0, 0, {'name': 'baseAddress', 'ref': 'baseAddress', 'type': 'baseAddress'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('addressBlock', 'addressBlockType', 1, 0, {'name': 'addressBlock', 'type': 'bankedBlockType'}, 16),
        MemberSpec_('bank', 'addressBankType', 1, 0, {'name': 'bank', 'type': 'localBankedBankType'}, 16),
        MemberSpec_('usage', ['usageType', 'xs:token'], 0, 1, {'minOccurs': '0', 'name': 'usage', 'type': 'xs:token'}, None),
        MemberSpec_('volatile', 'xs:boolean', 0, 1, {'minOccurs': '0', 'name': 'volatile', 'ref': 'volatile', 'type': 'xs:boolean'}, None),
        MemberSpec_('access', 'accessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'ref': 'access', 'type': 'access'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, bankAlignment=None, id=None, name=None, displayName=None, description=None, accessHandles=None, baseAddress=None, isPresent=None, addressBlock=None, bank=None, usage=None, volatile=None, access=None, parameters=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.bankAlignment = _cast(None, bankAlignment)
        self.bankAlignment_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.accessHandles = accessHandles
        self.accessHandles_nsprefix_ = "ipxact"
        self.baseAddress = baseAddress
        self.baseAddress_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        if addressBlock is None:
            self.addressBlock = []
        else:
            self.addressBlock = addressBlock
        self.addressBlock_nsprefix_ = "ipxact"
        if bank is None:
            self.bank = []
        else:
            self.bank = bank
        self.bank_nsprefix_ = "ipxact"
        self.usage = usage
        self.validate_usageType(self.usage)
        self.usage_nsprefix_ = "ipxact"
        self.volatile = volatile
        self.volatile_nsprefix_ = "ipxact"
        self.access = access
        self.access_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, localAddressBankType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if localAddressBankType.subclass:
            return localAddressBankType.subclass(*args_, **kwargs_)
        else:
            return localAddressBankType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_accessHandles(self):
        return self.accessHandles
    def set_accessHandles(self, accessHandles):
        self.accessHandles = accessHandles
    def get_baseAddress(self):
        return self.baseAddress
    def set_baseAddress(self, baseAddress):
        self.baseAddress = baseAddress
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_addressBlock(self):
        return self.addressBlock
    def set_addressBlock(self, addressBlock):
        self.addressBlock = addressBlock
    def add_addressBlock(self, value):
        self.addressBlock.append(value)
    def insert_addressBlock_at(self, index, value):
        self.addressBlock.insert(index, value)
    def replace_addressBlock_at(self, index, value):
        self.addressBlock[index] = value
    def get_bank(self):
        return self.bank
    def set_bank(self, bank):
        self.bank = bank
    def add_bank(self, value):
        self.bank.append(value)
    def insert_bank_at(self, index, value):
        self.bank.insert(index, value)
    def replace_bank_at(self, index, value):
        self.bank[index] = value
    def get_usage(self):
        return self.usage
    def set_usage(self, usage):
        self.usage = usage
    def get_volatile(self):
        return self.volatile
    def set_volatile(self, volatile):
        self.volatile = volatile
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_bankAlignment(self):
        return self.bankAlignment
    def set_bankAlignment(self, bankAlignment):
        self.bankAlignment = bankAlignment
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_usageType(self, value):
        result = True
        # Validate type usageType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['memory', 'register', 'reserved']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on usageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_bankAlignmentType(self, value):
        # Validate type ipxact:bankAlignmentType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['serial', 'parallel']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on bankAlignmentType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.accessHandles is not None or
            self.baseAddress is not None or
            self.isPresent is not None or
            self.addressBlock or
            self.bank or
            self.usage is not None or
            self.volatile is not None or
            self.access is not None or
            self.parameters is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='localAddressBankType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('localAddressBankType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'localAddressBankType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='localAddressBankType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='localAddressBankType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='localAddressBankType'):
        if self.bankAlignment is not None and 'bankAlignment' not in already_processed:
            already_processed.add('bankAlignment')
            outfile.write(' bankAlignment=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.bankAlignment), input_name='bankAlignment')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='localAddressBankType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.accessHandles is not None:
            namespaceprefix_ = self.accessHandles_nsprefix_ + ':' if (UseCapturedNS_ and self.accessHandles_nsprefix_) else ''
            self.accessHandles.export(outfile, level, namespaceprefix_, namespacedef_='', name_='accessHandles', pretty_print=pretty_print)
        if self.baseAddress is not None:
            namespaceprefix_ = self.baseAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.baseAddress_nsprefix_) else ''
            self.baseAddress.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='baseAddress', pretty_print=pretty_print)
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        for addressBlock_ in self.addressBlock:
            namespaceprefix_ = self.addressBlock_nsprefix_ + ':' if (UseCapturedNS_ and self.addressBlock_nsprefix_) else ''
            addressBlock_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addressBlock', pretty_print=pretty_print)
        for bank_ in self.bank:
            namespaceprefix_ = self.bank_nsprefix_ + ':' if (UseCapturedNS_ and self.bank_nsprefix_) else ''
            bank_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bank', pretty_print=pretty_print)
        if self.usage is not None:
            namespaceprefix_ = self.usage_nsprefix_ + ':' if (UseCapturedNS_ and self.usage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.usage), input_name='usage')), namespaceprefix_ , eol_))
        if self.volatile is not None:
            namespaceprefix_ = self.volatile_nsprefix_ + ':' if (UseCapturedNS_ and self.volatile_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolatile>%s</%svolatile>%s' % (namespaceprefix_ , self.gds_format_boolean(self.volatile, input_name='volatile'), namespaceprefix_ , eol_))
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('bankAlignment', node)
        if value is not None and 'bankAlignment' not in already_processed:
            already_processed.add('bankAlignment')
            self.bankAlignment = value
            self.bankAlignment = ' '.join(self.bankAlignment.split())
            self.validate_bankAlignmentType(self.bankAlignment)    # validate type bankAlignmentType
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'accessHandles':
            obj_ = accessHandlesType44.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.accessHandles = obj_
            obj_.original_tagname_ = 'accessHandles'
        elif nodeName_ == 'baseAddress':
            class_obj_ = self.get_class_obj_(child_, unsignedLongintExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.baseAddress = obj_
            obj_.original_tagname_ = 'baseAddress'
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'addressBlock':
            obj_ = bankedBlockType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addressBlock.append(obj_)
            obj_.original_tagname_ = 'addressBlock'
        elif nodeName_ == 'bank':
            obj_ = localBankedBankType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bank.append(obj_)
            obj_.original_tagname_ = 'bank'
        elif nodeName_ == 'usage':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'usage')
            value_ = self.gds_validate_string(value_, node, 'usage')
            self.usage = value_
            self.usage_nsprefix_ = child_.prefix
            # validate type usageType
            self.validate_usageType(self.usage)
        elif nodeName_ == 'volatile':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'volatile')
            ival_ = self.gds_validate_boolean(ival_, node, 'volatile')
            self.volatile = ival_
            self.volatile_nsprefix_ = child_.prefix
        elif nodeName_ == 'access':
            obj_ = accessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class localAddressBankType


class addressBlockType(GeneratedsSuper):
    """name -- Unique name
    typeIdentifier -- Identifier name used to indicate that multiple addressBlock elements contain the exact same information except for the elements in the addressBlockInstanceGroup.
    The address range of an address block.  Expressed as the number of addressable units accessible to the block. The range and the width are related by the following formulas:
    range -- The address range of an address block.  Expressed as the number of addressable units accessible to the block. The range and the width are related by the following formulas:
    number_of_bits_in_block = ipxact:addressUnitBits * ipxact:range
    number_of_rows_in_block = number_of_bits_in_block / ipxact:width
      
    * width -- The bit width of a row in the address block. The range and the width are related by the following formulas:
      number_of_bits_in_block = ipxact:addressUnitBits * ipxact:range
      number_of_rows_in_block = number_of_bits_in_block / ipxact:width
      A single register
    * register -- A single register
    * registerFile -- A structure of registers and register files
    
    """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('name', 'xs:Name', 0, 0, {'name': 'name', 'type': 'xs:Name'}, None),
        MemberSpec_('displayName', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'displayName', 'ref': 'displayName', 'type': 'xs:string'}, None),
        MemberSpec_('description', 'xs:string', 0, 1, {'minOccurs': '0', 'name': 'description', 'ref': 'description', 'type': 'xs:string'}, None),
        MemberSpec_('accessHandles', 'accessHandlesType45', 0, 1, {'minOccurs': '0', 'name': 'accessHandles', 'type': 'accessHandlesType45'}, None),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
        MemberSpec_('baseAddress', 'unsignedLongintExpression', 0, 0, {'name': 'baseAddress', 'ref': 'baseAddress', 'type': 'baseAddress'}, None),
        MemberSpec_('typeIdentifier', 'xs:Name', 0, 1, {'minOccurs': '0', 'name': 'typeIdentifier', 'type': 'xs:Name'}, None),
        MemberSpec_('Range', 'unsignedPositiveLongintExpression', 0, 0, {'name': 'range', 'type': 'unsignedPositiveLongintExpression'}, None),
        MemberSpec_('width', 'unsignedIntExpression', 0, 0, {'name': 'width', 'type': 'unsignedIntExpression'}, None),
        MemberSpec_('usage', ['usageType', 'xs:token'], 0, 1, {'minOccurs': '0', 'name': 'usage', 'type': 'xs:token'}, None),
        MemberSpec_('volatile', 'xs:boolean', 0, 1, {'minOccurs': '0', 'name': 'volatile', 'ref': 'volatile', 'type': 'xs:boolean'}, None),
        MemberSpec_('access', 'accessType', 0, 1, {'minOccurs': '0', 'name': 'access', 'ref': 'access', 'type': 'access'}, None),
        MemberSpec_('parameters', 'parameters', 0, 1, {'minOccurs': '0', 'name': 'parameters', 'ref': 'parameters', 'type': 'parameters'}, None),
        MemberSpec_('register', 'registerType51', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'register', 'type': 'registerType51'}, 23),
        MemberSpec_('registerFile', 'registerFile', 0, 0, {'name': 'registerFile', 'ref': 'registerFile', 'type': 'registerFile'}, 23),
        MemberSpec_('vendorExtensions', 'vendorExtensions', 0, 1, {'minOccurs': '0', 'name': 'vendorExtensions', 'ref': 'vendorExtensions', 'type': 'vendorExtensions'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, displayName=None, description=None, accessHandles=None, isPresent=None, baseAddress=None, typeIdentifier=None, Range=None, width=None, usage=None, volatile=None, access=None, parameters=None, register=None, registerFile=None, vendorExtensions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = "ipxact"
        self.displayName = displayName
        self.displayName_nsprefix_ = "ipxact"
        self.description = description
        self.description_nsprefix_ = "ipxact"
        self.accessHandles = accessHandles
        self.accessHandles_nsprefix_ = "ipxact"
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.baseAddress = baseAddress
        self.baseAddress_nsprefix_ = "ipxact"
        self.typeIdentifier = typeIdentifier
        self.typeIdentifier_nsprefix_ = "ipxact"
        self.Range = Range
        self.Range_nsprefix_ = "ipxact"
        self.width = width
        self.width_nsprefix_ = "ipxact"
        self.usage = usage
        self.validate_usageType(self.usage)
        self.usage_nsprefix_ = "ipxact"
        self.volatile = volatile
        self.volatile_nsprefix_ = "ipxact"
        self.access = access
        self.access_nsprefix_ = "ipxact"
        self.parameters = parameters
        self.parameters_nsprefix_ = "ipxact"
        if register is None:
            self.register = []
        else:
            self.register = register
        self.register_nsprefix_ = "ipxact"
        self.registerFile = registerFile
        self.registerFile_nsprefix_ = "ipxact"
        self.vendorExtensions = vendorExtensions
        self.vendorExtensions_nsprefix_ = "ipxact"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, addressBlockType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if addressBlockType.subclass:
            return addressBlockType.subclass(*args_, **kwargs_)
        else:
            return addressBlockType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_displayName(self):
        return self.displayName
    def set_displayName(self, displayName):
        self.displayName = displayName
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_accessHandles(self):
        return self.accessHandles
    def set_accessHandles(self, accessHandles):
        self.accessHandles = accessHandles
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_baseAddress(self):
        return self.baseAddress
    def set_baseAddress(self, baseAddress):
        self.baseAddress = baseAddress
    def get_typeIdentifier(self):
        return self.typeIdentifier
    def set_typeIdentifier(self, typeIdentifier):
        self.typeIdentifier = typeIdentifier
    def get_range(self):
        return self.Range
    def set_range(self, Range):
        self.Range = Range
    def get_width(self):
        return self.width
    def set_width(self, width):
        self.width = width
    def get_usage(self):
        return self.usage
    def set_usage(self, usage):
        self.usage = usage
    def get_volatile(self):
        return self.volatile
    def set_volatile(self, volatile):
        self.volatile = volatile
    def get_access(self):
        return self.access
    def set_access(self, access):
        self.access = access
    def get_parameters(self):
        return self.parameters
    def set_parameters(self, parameters):
        self.parameters = parameters
    def get_register(self):
        return self.register
    def set_register(self, register):
        self.register = register
    def add_register(self, value):
        self.register.append(value)
    def insert_register_at(self, index, value):
        self.register.insert(index, value)
    def replace_register_at(self, index, value):
        self.register[index] = value
    def get_registerFile(self):
        return self.registerFile
    def set_registerFile(self, registerFile):
        self.registerFile = registerFile
    def get_vendorExtensions(self):
        return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions):
        self.vendorExtensions = vendorExtensions
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_usageType(self, value):
        result = True
        # Validate type usageType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['memory', 'register', 'reserved']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on usageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.accessHandles is not None or
            self.isPresent is not None or
            self.baseAddress is not None or
            self.typeIdentifier is not None or
            self.Range is not None or
            self.width is not None or
            self.usage is not None or
            self.volatile is not None or
            self.access is not None or
            self.parameters is not None or
            self.register or
            self.registerFile is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='addressBlockType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('addressBlockType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'addressBlockType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='addressBlockType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='addressBlockType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ipxact:', name_='addressBlockType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' xml:id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='ipxact:', namespacedef_='xmlns:ipxact="http://www.accellera.org/XMLSchema/IPXACT/1685-2014"', name_='addressBlockType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.displayName is not None:
            namespaceprefix_ = self.displayName_nsprefix_ + ':' if (UseCapturedNS_ and self.displayName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.displayName), input_name='displayName')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.accessHandles is not None:
            namespaceprefix_ = self.accessHandles_nsprefix_ + ':' if (UseCapturedNS_ and self.accessHandles_nsprefix_) else ''
            self.accessHandles.export(outfile, level, namespaceprefix_, namespacedef_='', name_='accessHandles', pretty_print=pretty_print)
        if self.isPresent is not None:
            namespaceprefix_ = self.isPresent_nsprefix_ + ':' if (UseCapturedNS_ and self.isPresent_nsprefix_) else ''
            self.isPresent.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='isPresent', pretty_print=pretty_print)
        if self.baseAddress is not None:
            namespaceprefix_ = self.baseAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.baseAddress_nsprefix_) else ''
            self.baseAddress.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='baseAddress', pretty_print=pretty_print)
        if self.typeIdentifier is not None:
            namespaceprefix_ = self.typeIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.typeIdentifier_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stypeIdentifier>%s</%stypeIdentifier>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.typeIdentifier), input_name='typeIdentifier')), namespaceprefix_ , eol_))
        if self.Range is not None:
            namespaceprefix_ = self.Range_nsprefix_ + ':' if (UseCapturedNS_ and self.Range_nsprefix_) else ''
            self.Range.export(outfile, level, namespaceprefix_, namespacedef_='', name_='range', pretty_print=pretty_print)
        if self.width is not None:
            namespaceprefix_ = self.width_nsprefix_ + ':' if (UseCapturedNS_ and self.width_nsprefix_) else ''
            self.width.export(outfile, level, namespaceprefix_, namespacedef_='', name_='width', pretty_print=pretty_print)
        if self.usage is not None:
            namespaceprefix_ = self.usage_nsprefix_ + ':' if (UseCapturedNS_ and self.usage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.usage), input_name='usage')), namespaceprefix_ , eol_))
        if self.volatile is not None:
            namespaceprefix_ = self.volatile_nsprefix_ + ':' if (UseCapturedNS_ and self.volatile_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolatile>%s</%svolatile>%s' % (namespaceprefix_ , self.gds_format_boolean(self.volatile, input_name='volatile'), namespaceprefix_ , eol_))
        if self.access is not None:
            namespaceprefix_ = self.access_nsprefix_ + ':' if (UseCapturedNS_ and self.access_nsprefix_) else ''
            self.access.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='access', pretty_print=pretty_print)
        if self.parameters is not None:
            namespaceprefix_ = self.parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.parameters_nsprefix_) else ''
            self.parameters.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='parameters', pretty_print=pretty_print)
        for register_ in self.register:
            namespaceprefix_ = self.register_nsprefix_ + ':' if (UseCapturedNS_ and self.register_nsprefix_) else ''
            register_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='register', pretty_print=pretty_print)
        if self.registerFile is not None:
            namespaceprefix_ = self.registerFile_nsprefix_ + ':' if (UseCapturedNS_ and self.registerFile_nsprefix_) else ''
            self.registerFile.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='registerFile', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            namespaceprefix_ = self.vendorExtensions_nsprefix_ + ':' if (UseCapturedNS_ and self.vendorExtensions_nsprefix_) else ''
            self.vendorExtensions.export(outfile, level, namespaceprefix_='ipxact:', namespacedef_='', name_='vendorExtensions', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xml:id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'displayName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'displayName')
            value_ = self.gds_validate_string(value_, node, 'displayName')
            self.displayName = value_
            self.displayName_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'accessHandles':
            obj_ = accessHandlesType45.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.accessHandles = obj_
            obj_.original_tagname_ = 'accessHandles'
        elif nodeName_ == 'isPresent':
            class_obj_ = self.get_class_obj_(child_, unsignedBitExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.isPresent = obj_
            obj_.original_tagname_ = 'isPresent'
        elif nodeName_ == 'baseAddress':
            class_obj_ = self.get_class_obj_(child_, unsignedLongintExpression)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.baseAddress = obj_
            obj_.original_tagname_ = 'baseAddress'
        elif nodeName_ == 'typeIdentifier':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'typeIdentifier')
            value_ = self.gds_validate_string(value_, node, 'typeIdentifier')
            self.typeIdentifier = value_
            self.typeIdentifier_nsprefix_ = child_.prefix
        elif nodeName_ == 'range':
            obj_ = unsignedPositiveLongintExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Range = obj_
            obj_.original_tagname_ = 'range'
        elif nodeName_ == 'width':
            obj_ = unsignedIntExpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.width = obj_
            obj_.original_tagname_ = 'width'
        elif nodeName_ == 'usage':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'usage')
            value_ = self.gds_validate_string(value_, node, 'usage')
            self.usage = value_
            self.usage_nsprefix_ = child_.prefix
            # validate type usageType
            self.validate_usageType(self.usage)
        elif nodeName_ == 'volatile':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'volatile')
            ival_ = self.gds_validate_boolean(ival_, node, 'volatile')
            self.volatile = ival_
            self.volatile_nsprefix_ = child_.prefix
        elif nodeName_ == 'access':
            obj_ = accessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.access = obj_
            obj_.original_tagname_ = 'access'
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameters = obj_
            obj_.original_tagname_ = 'parameters'
        elif nodeName_ == 'register':
            obj_ = registerType51.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.register.append(obj_)
            obj_.original_tagname_ = 'register'
        elif nodeName_ == 'registerFile':
            obj_ = registerFile.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.registerFile = obj_
            obj_.original_tagname_ = 'registerFile'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensions.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class addressBlockType


class addrSpaceRefType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('addressSpaceRef', 'xs:Name', 0, 0, {'use': 'required', 'name': 'addressSpaceRef'}),
        MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional', 'name': 'id'}),
        MemberSpec_('isPresent', 'unsignedBitExpression', 0, 1, {'minOccurs': '0', 'name': 'isPresent', 'ref': 'isPresent', 'type': 'isPresent'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, addressSpaceRef=None, id=None, isPresent=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "ipxact"
        self.addressSpaceRef = _cast(None, addressSpaceRef)
        self.addressSpaceRef_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.isPresent = isPresent
        self.isPresent_nsprefix_ = "ipxact"
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, addrSpaceRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if addrSpaceRefType.subclass:
            return addrSpaceRefType.subclass(*args_, **kwargs_)
        else:
            return addrSpaceRefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_isPresent(self):
        return self.isPresent
    def set_isPresent(self, isPresent):
        self.isPresent = isPresent
    def get_addressSpaceRef(self):
        return self.addressSpaceRef
    def set_addressSpaceRef(self, addressSpaceRef):
        self.addressSpaceRef = addressSpaceRef
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def _hasContent(self):
        if (
            self.isPresent is not None
     