/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.BinaryRangeDocValuesField;
import org.apache.lucene.document.FloatRange;
import org.apache.lucene.document.FloatRangeSlowRangeQuery;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;

public class FloatRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final float[] min;
    final float[] max;

    public FloatRangeDocValuesField(String field, float[] min2, float[] max) {
        super(field, FloatRange.encode(min2, max), min2.length, 4);
        FloatRangeDocValuesField.checkArgs(min2, max);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    public float getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public float getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, float[] min2, float[] max, RangeFieldQuery.QueryType queryType) {
        FloatRangeDocValuesField.checkArgs(min2, max);
        return new FloatRangeSlowRangeQuery(field, min2, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, float[] min2, float[] max) {
        return FloatRangeDocValuesField.newSlowRangeQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(float[] min2, float[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min2.length; ++i) {
            if (!(min2[i] > max[i])) continue;
            throw new IllegalArgumentException("min should be less than max");
        }
    }
}

