/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.util.KNNEngine;

public class KNNIndexShard {
    private IndexShard indexShard;
    private NativeMemoryCacheManager nativeMemoryCacheManager;
    private static Logger logger = LogManager.getLogger(KNNIndexShard.class);

    public KNNIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        this.nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
    }

    public IndexShard getIndexShard() {
        return this.indexShard;
    }

    public String getIndexName() {
        return this.indexShard.shardId().getIndexName();
    }

    public void warmup() throws IOException {
        logger.info("[KNN] Warming up index: " + this.getIndexName());
        try (Engine.Searcher searcher = this.indexShard.acquireSearcher("knn-warmup");){
            this.getAllEngineFileContexts(searcher.getIndexReader()).forEach(engineFileContext -> {
                try {
                    this.nativeMemoryCacheManager.get(new NativeMemoryEntryContext.IndexEntryContext(engineFileContext.getIndexPath(), NativeMemoryLoadStrategy.IndexLoadStrategy.getInstance(), IndexUtil.getParametersAtLoading(engineFileContext.getSpaceType(), KNNEngine.getEngineNameFromPath(engineFileContext.getIndexPath()), this.getIndexName()), this.getIndexName(), engineFileContext.getModelId()), true);
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
    }

    @VisibleForTesting
    List<EngineFileContext> getAllEngineFileContexts(IndexReader indexReader) throws IOException {
        ArrayList<EngineFileContext> engineFiles = new ArrayList<EngineFileContext>();
        for (KNNEngine knnEngine : KNNEngine.getEnginesThatCreateCustomSegmentFiles()) {
            engineFiles.addAll(this.getEngineFileContexts(indexReader, knnEngine));
        }
        return engineFiles;
    }

    List<EngineFileContext> getEngineFileContexts(IndexReader indexReader, KNNEngine knnEngine) throws IOException {
        ArrayList<EngineFileContext> engineFiles = new ArrayList<EngineFileContext>();
        for (LeafReaderContext leafReaderContext : indexReader.leaves()) {
            SegmentReader reader = (SegmentReader)FilterLeafReader.unwrap((LeafReader)leafReaderContext.reader());
            Path shardPath = ((FSDirectory)FilterDirectory.unwrap((Directory)reader.directory())).getDirectory();
            String fileExtension = reader.getSegmentInfo().info.getUseCompoundFile() ? knnEngine.getCompoundExtension() : knnEngine.getExtension();
            for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                if (!fieldInfo.attributes().containsKey("knn_field")) continue;
                String spaceTypeName = fieldInfo.attributes().getOrDefault("spaceType", SpaceType.L2.getValue());
                SpaceType spaceType = SpaceType.getSpace(spaceTypeName);
                String modelId = fieldInfo.attributes().getOrDefault("model_id", null);
                engineFiles.addAll(this.getEngineFileContexts(reader.getSegmentInfo().files(), reader.getSegmentInfo().info.name, fieldInfo.name, fileExtension, shardPath, spaceType, modelId));
            }
        }
        return engineFiles;
    }

    @VisibleForTesting
    List<EngineFileContext> getEngineFileContexts(Collection<String> files, String segmentName, String fieldName, String fileExtension, Path shardPath, SpaceType spaceType, String modelId) {
        String prefix = KNNCodecUtil.buildEngineFilePrefix(segmentName);
        String suffix = KNNCodecUtil.buildEngineFileSuffix(fieldName, fileExtension);
        return files.stream().filter(fileName -> fileName.startsWith(prefix)).filter(fileName -> fileName.endsWith(suffix)).map(fileName -> shardPath.resolve((String)fileName).toString()).map(fileName -> new EngineFileContext(spaceType, modelId, (String)fileName)).collect(Collectors.toList());
    }

    @VisibleForTesting
    static class EngineFileContext {
        private final SpaceType spaceType;
        private final String modelId;
        private final String indexPath;

        @Generated
        public EngineFileContext(SpaceType spaceType, String modelId, String indexPath) {
            this.spaceType = spaceType;
            this.modelId = modelId;
            this.indexPath = indexPath;
        }

        @Generated
        public SpaceType getSpaceType() {
            return this.spaceType;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public String getIndexPath() {
            return this.indexPath;
        }
    }
}

