/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statement;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public enum StatementState {
    WAITING("waiting"),
    RUNNING("running"),
    SUCCESS("success"),
    FAILED("failed"),
    CANCELLED("cancelled");

    private final String state;
    private static Map<String, StatementState> STATES;

    private StatementState(String state) {
        this.state = state;
    }

    public static StatementState fromString(String key) {
        for (StatementState ss : StatementState.values()) {
            if (!ss.getState().toLowerCase(Locale.ROOT).equals(key)) continue;
            return ss;
        }
        throw new IllegalArgumentException("Invalid statement state: " + key);
    }

    @Generated
    public String getState() {
        return this.state;
    }

    static {
        STATES = Arrays.stream(StatementState.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), t -> t));
    }
}

