"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;
var _operators = require("rxjs/operators");
var _flights_saved_objects = require("./services/sample_data/flights_saved_objects");
var _clusters = require("./clusters");
var _services = require("./services");
var _routes = require("../server/routes");
var _saved_objects = require("./saved_objects");
var _capabilities_provider = require("./saved_objects/capabilities_provider");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    _defineProperty(this, "config$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
    this.config$ = initializerContext.config.create();
  }

  // Adds dashboards-maps saved objects to existing sample datasets using home plugin
  addMapsSavedObjects(home, config) {
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)(config));
  }
  async setup(core, plugins) {
    this.logger.debug('customImportMap: Setup');
    // @ts-ignore
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    // @ts-ignore
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig);
    // Initialize services
    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter();
    const {
      home
    } = plugins;

    // Register server side APIs
    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router);
    (0, _routes.statsRoute)(router, this.logger);

    // Register saved object types
    core.savedObjects.registerType(_saved_objects.mapSavedObjectsType);

    // Register capabilities
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (home) this.addMapsSavedObjects(home, config);
    return {};
  }
  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }
  stop() {}
}
exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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