/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.function.Predicate;
import org.freeplane.api.Node;
import org.freeplane.api.NodeChangeListener;
import org.freeplane.api.NodeChanged;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.NodeProxy;

class NodeChangeListenerForScript {
    private final NodeChangeListener scriptListener;
    private final ScriptContext context;

    static Predicate<? super NodeChangeListenerForScript> contains(NodeChangeListener listener) {
        return e -> e.scriptListener.equals(listener);
    }

    NodeChangeListenerForScript(NodeChangeListener scriptListener, ScriptContext context) {
        this.scriptListener = scriptListener;
        this.context = context;
    }

    void fire(NodeModel node, NodeChanged.ChangedElement element) {
        this.scriptListener.nodeChanged(new NodeChanged((Node)new NodeProxy(node, this.context), element));
    }

    NodeChangeListener getListener() {
        return this.scriptListener;
    }
}

